@import <MapKit/MKMapView.j>
@import <MapKit/MKLocation.j>


@implementation trackingObject:CPObject{

	CPDictionary  dictParamet         @accessors;
	CPString      imei                @accessors;
	CPString      objeName            @accessors;
	CPString      objeAlia            @accessors;
	CGPoint       lastPoin            @accessors;
	CGPoint       prevPoin            @accessors;
	CPString      lastDate            @accessors;
	CPString      prevDate            @accessors;
	CPString      idDevice            @accessors;
	CPString      stopDate            @accessors;
	CPString      status              @accessors;

	id            trckAble;
	id            myApp;
	id            myMap;
    id            myMrkr;
    id            myMrkrLabl;
    id            visibility;
    id            actiMark;
    id            ownr;
    id            lttnLong;
    id            myInfo;
    id            myInfoContent;
}



- (void) addLastPoint:(id)arra {
    var _date = arra[1];
    var _lngt = arra[2];
    var _lttd = arra[3];
    stopDate  = arra[4];
    status    = arra[5];

	if ( lastPoin ) {
		prevPoin = lastPoin;
		prevDate = lastDate;
	}
	
    if ( [status isEqualToString:@"M"] ) {
    	status = "Movimiento";
    	stopDate = "";
    }
    else {
    	status = "Detenido";
    }
	if ( _lngt == 0 || _lttd == 0 ) {
	    return;
	}

	lastPoin = CGPointMake( [_lngt doubleValue], [_lttd doubleValue] );
	lastDate = [_date substringToIndex:19];
	//[self setCurrentDateInTimeZone:lastDate];


    // SOLO LOS VISIBLES TRABAJARAN EN LOS MARKERS
    if ( visibility  )  {
	    if (actiMark == 0){
            [self markerCreation];
		    actiMark = 1;
    	}
    	else if ( actiMark == 2 ) {
    		myMrkr.setMap(myMap);
   		    myMrkrLabl.setVisible(true);
            actiMark = 1;
    	}
    	[self markerLocate];
    }
    else
       	[self markerRemotion];

	trckAble = YES;
}



- (void)declareMap:(id)_aMap {
     myMap = _aMap;
}


- (CPString) setCurrentDateInTimeZone:(CPString)_date {
    var aStringTime = cDate;
 	var rnge = CPMakeRange(0,4);
	var aYear = [[aStringTime substringWithRange:rnge] intValue];
	rnge = CPMakeRange(5,2);
	var aMnth = [[aStringTime substringWithRange:rnge] intValue];
	rnge = CPMakeRange(8,2);
	var aDay = [[aStringTime substringWithRange:rnge] intValue];
	rnge = CPMakeRange(11,2);
	var aHou = [[aStringTime substringWithRange:rnge] intValue];
		rnge = CPMakeRange(14,2);
	var aMin = [[aStringTime substringWithRange:rnge] intValue];
		rnge = CPMakeRange(17,2);
	var aSec = [[aStringTime substringWithRange:rnge] intValue];
    dife = [[[RITimeZone alloc] initTimeZone:myTimeZone] hours] ;

    var myZone = -6;
    //dife = dife - myZone;

	var xDate = new Date(aYear,aMnth-1,aDay,aHou+dife,aMin,aSec,0);
	return [[xDate description] substringToIndex:19];
}



- (id) initWithRecord:(id)obje inMap:(id)_map{
	self = [super init];
    if ( self ) {
		imei        =  obje[28];
		dictParamet =  [[CPDictionary alloc] init];
		objeName    =  obje[0];
		objeAlia    =  obje[3];
		lastPoin    =  nil;
		prevPoin    =  nil;
		trckAble    =  0;
		myApp       =  nil;
		
		myMrkr      =  nil;
		myMrkrLabl  =  nil;
		actiMark    =  0;
		objeColo    =  obje[27];
		if ( [objeColo isEqualToString:@"null"] ) {
			objeColo = @"Blue";
		}
		objeColo    = "Resources/img/" + objeColo; 
		objeColo    = "Resources/img/Pin.png"; 
		idDevice    =  obje[29];
		myMap       = _map;
		visibility  = YES;
	}

	return self;
}




- (void) markerCreation {

    if ( lastPoin.x && lastPoin.y ) {
    	var vectGoog1 = new google.maps.LatLng(lastPoin.y, lastPoin.x );
    	myInfoContent  = "Dispositivo: <strong>" + objeAlia + "</strong><br>";
    	myInfoContent += "Ultimo registro: <strong>" + lastDate + "</strong><br>";
    	myInfoContent += "Status: <strong>" + status + "</strong><br>";
    	if ( [stopDate length] > 0 ) {
    		myInfoContent += "Hora de parada: <strong>" + stopDate + "</strong><br>";
    	}
        myMrkrLabl = new MarkerWithLabel({
        	position: vectGoog1,
        	map: myMap,
        	icon: 'None',
        	//title: objeAlia,
        	index: 1,
    		label: {
      			text: objeAlia,
      			color: "#3498DB",
      			fontWeight: "Bold",
      			fontSize: "12px"    		
      		},
        	//labelContent: objeAlia,
        	labelAnchor: new google.maps.Point(-5, -35),
        	labelClass: "mrkrLabel", // the CSS class for the label
        	labelStyle: {opacity: 0.75}
    	});
    	google.maps.event.addListener( myMrkrLabl, "click", function (e) {
	    	[self starTrackGlobe];
		});

        
    	myMrkr = new google.maps.Marker({
			position: vectGoog1,
			map: myMap,
			icon: objeColo,
    		title: objeAlia
		});
    	google.maps.event.addListener( myMrkr, "click", function (e) {
	    	[self starTrackGlobe];
		});

  		myInfo = new google.maps.InfoWindow();
		google.maps.event.addListener(myMrkr,'click', (function(_Mrkr,myInfoContent,myInfo){
		    return function() {
		        myInfo.setContent(myInfoContent);
		        myInfo.open(myMap,_Mrkr);
		    };
		})(myMrkr,myInfoContent,myInfo));
    }
}



- (void) markerLocate {
	    if ( myMrkr ) {
	        myMrkr.setPosition(new google.maps.LatLng( lastPoin.y , lastPoin.x));
	        //markerlabel.setPosition(new google.maps.LatLng([lastPoin latitude], [lastPoin longitude]));

	     //    if([[myEssDyna checkDictionary] objectForKey:@"statIcon"] == 1)
	    	//     myMrkr.setIcon([self getIconStat]);
	    	// else
	    	// 	myMrkr.setIcon(objectColor);

            myMrkr.setMap(myMap);
            lttnlong = new google.maps.LatLngBounds();
	    }
	    else {
            console.log(nameMovi + ": no tiene marker. Coordenadas: pnto.x n pnto.y");// + pnto.x + ", " + pnto.y);
	    }
}



- (id) markerRemotion {
	if( myMrkr ) {
		myMrkr.setMap(null);
		markerlabel.setVisible(false);
		actiMark = 2;
	}
}


- (void) starTrackGlobe {

}



@end