// AppController.j
// RMScheduler
//
// Created by Robert T. Beck

@import <Foundation/Foundation.j>
@import <AppKit/AppKit.j>
@import "RMControllerObject.j"
@import "RMMapController.j"
@import "RMSchedulerUserController.j"
@import "RMSchedulerPreferencesController.j"
@import "RMSchedulerController.j"
@import "RMSchedulerResourcesController.j"
@import "RMSchedulerOrganizationsController.j"
@import "RMSchedulerStatisticsController.j"
@import "RMSReportOrganizationController.j"
@import "RMSReportLocationController.j"
@import "RMSReportPersonnelController.j"
@import "RMSReportAnnualController.j"
@import "RMSReportTecnicianController.j"
@import "PSTrackingMap.j"
//@import "automaticReport/AutomaticReport.j"
@import "automaticReport/AutomaticPersonnel.j"
@import "automaticReport/AutomaticLocation.j"
@import "automaticReport/AutomaticOrganization.j" 

//AutomaticOrganization






@implementation AppController : RMControllerObject {

	
	
	
	id resoCont;
	
	id userCont;
	id preferCont;

	id contView;  
	id orgaCont;

	id scheCont;
	id statCont;	
	
	id repoOrgaCont;
	id repoLocaCont;
	id repoPersCont;	
	id repoAnnuCont;
	id repoTecCont;	
	
	id autoRepoOrga;
	id autoRepoLoca;
	id autoRepoPers;
	
	
	
}



- (void) applicationDidFinishLaunching:(CPNotification)aNotification {

	var myApp = [CPApplication sharedApplication];
	var myMenu= [myApp mainMenu];
	[myMenu removeAllItems];
	[CPMenu setMenuBarVisible:YES];



    var viewMenuItem= [[CPMenuItem alloc] initWithTitle:@"RM Scheduler" action:nil keyEquivalent:nil];
	var mainMenu= [[CPMenu alloc] initWithTitle:@"RM Scheduler"];
	[mainMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Quit"  action:@selector(applicationQuit)  keyEquivalent:@"Q"]];
	[mainMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Usuarios"  action:@selector(openUsersController:)  keyEquivalent:@"U"]];
	[mainMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Preferencias"  action:@selector(openPreferencesController:)  keyEquivalent:@"P"]];
	[viewMenuItem setSubmenu:mainMenu];
	[myMenu insertItem:viewMenuItem atIndex:0];

    viewMenuItem= [[CPMenuItem alloc] initWithTitle:@"Modulos" action:nil keyEquivalent:nil];
	[myMenu insertItem:viewMenuItem atIndex:1];
	var viewMenu = [[CPMenu alloc] initWithTitle:@"Modulos"];
	[viewMenuItem setSubmenu:viewMenu];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Organizaciones" action:@selector(openOrganizationsController:)  keyEquivalent:@"C"]];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Recursos"       action:@selector(openResourcesController:)      keyEquivalent:@"A"]];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Scheduler"      action:@selector(openSchedulerController:)      keyEquivalent:@"S"]];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Mapa"      	  action:@selector(openMapController:)      keyEquivalent:@"M"]];
	//[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Mapa"           action:@selector(openMapController:)            keyEquivalent:@"M"]];
//	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Estadisticas"   action:@selector(openStatisticsController:)     keyEquivalent:@"T"]];
	
	//add 2017-03-15
	viewMenuItem= [[CPMenuItem alloc] initWithTitle:@"Reportes" action:nil keyEquivalent:nil];
	[myMenu insertItem:viewMenuItem atIndex:2];
	viewMenu = [[CPMenu alloc] initWithTitle:@"Reportes"];
	[viewMenuItem setSubmenu:viewMenu];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Organización"  action:@selector(openReportOrganizationController:)    keyEquivalent:@"" ]];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Locación"      action:@selector(openReportLocationController:)        keyEquivalent:@"" ]];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Personal"      action:@selector(openReportPersonnelController:)       keyEquivalent:@"" ]];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Anual"         action:@selector(openReportAnnualController:)          keyEquivalent:@"" ]];
	//[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Técnicos"         action:@selector(openReportTecnicianController:)          keyEquivalent:@"" ]];
	//[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Estadisticas"  action:@selector(openStatisticsController:)            keyEquivalent:@"T"]];
	
	viewMenuItem= [[CPMenuItem alloc] initWithTitle:@"Alertas" action:nil keyEquivalent:nil];
	[myMenu insertItem:viewMenuItem atIndex:3];
	viewMenu = [[CPMenu alloc] initWithTitle:@"Alertas"];
	[viewMenuItem setSubmenu:viewMenu];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Organización"  action:@selector(openAutomaticReportOrganization:)    keyEquivalent:@"" ]];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Locación"      action:@selector(openAutomaticReportLocation:)        keyEquivalent:@"" ]];
	[viewMenu addItem:[[CPMenuItem alloc] initWithTitle:@"Personal"      action:@selector(openAutomaticReportPersonnel:)       keyEquivalent:@"" ]];
		

    var wind= [[CPWindow alloc] initWithContentRect:CGRectMakeZero() styleMask:CPBorderlessBridgeWindowMask];
    contView= [wind contentView];
	[contView setBackgroundColor:coloDefa];

    var contFram= [contView frame];
    
    mapCont  = 0;
    scheCont = 0;

	[self addBanners:contView heightBlue:1. heightOrange:4.];

	var colo1= [CPColor colorWithRed:70/255.0 green:102.0/255.0 blue:78.0/255.0 alpha:1.0];
	var colo2= [CPColor colorWithRed:96/255.0 green:126.0/255.0 blue:104.0/255.0 alpha:1.0];
	[self addLogo:contView title:@"RM Scheduler" backgroundColor:colo1 :colo2 imageName:0];

    [wind orderFront:self];

    appCont = self;

   
   	//alert("applicationDidFinishLaunching!");

}


//add, 2017-03-02
- (void) applicationQuit {
	
	if (isLogi == false) {
		return
	}

	if(resoCont)	{  [resoCont applicationQuit]; }
	if(orgaCont)	{  [orgaCont applicationQuit]; }
	if(scheCont)	{  [scheCont applicationQuit];}
	if(statCont)    {  [statCont applicationQuit];}
	if(mapCont)     {  [mapCont applicationQuit];}
	if(repoOrgaCont){  [repoOrgaCont applicationQuit];}
	if(repoLocaCont){  [repoLocaCont applicationQuit];}
	if(repoPersCont){  [repoPersCont applicationQuit];}
	if(repoAnnuCont){  [repoAnnuCont applicationQuit];}
	if(repoTecCont){  [repoTecCont applicationQuit];}
	if(userCont)    {      [userCont applicationQuit];}
	if(autoRepoOrga){  [autoRepoOrga applicationQuit];}
	if(autoRepoLoca){  [autoRepoLoca applicationQuit];}
	if(autoRepoPers){  [autoRepoPers applicationQuit];}
	
	

	isLogi = false;
	//alert("nameDataBase= " + nameDataBase + " hostDataBase= " + hostDataBase + " usernameDataBase= " + usernameDataBase + " passDataBase= " + passDataBase );
	dataBase = "";
	var colo1= [CPColor colorWithCalibratedRed:0.6 green:0.7 blue:0.8 alpha:1.];
	var colo2= [CPColor colorWithCalibratedRed:0.5 green:0.6 blue:0.6 alpha:1.];
	[self addLogo:contView title:@"RM Scheduler" backgroundColor:colo1 :colo2 imageName:0];
}

/*
//back up, 2017-03-02
- (void) applicationQuit {
	
	if ( messView )
		[messView removeFromSuperview];
	messView= NULL;

	if ( mapCont ) {
		[mapCont windowClose];
		[mapCont release];
	}
	
	if ( appCont )
		[appCont applicationQuit];

	var contFram= [contView frame];

	[self addBanners:contView heightBlue:6. heightOrange:5.];

	var colo1= [CPColor colorWithCalibratedRed:0.3 green:0.5 blue:0.6 alpha:1.];
	var colo2= [CPColor colorWithCalibratedRed:0.3 green:0.5 blue:0.6 alpha:1.];
	[self addLogo:contView title:@"RM Scheduler" backgroundColor:colo1 :colo2 imageName:0];

	setTimeout(function(){close()},3000);
}
*/


- (id) init {
	[super init];
	phpHost = @"167.250.194.153";
    cgiHost = document.location.pathname;
	cgiServ = @"rmws_scheduler.cgi";
    cgiServ = @"rm_execute";
    cgiServ = @"rm_execute_base64";
	resoCont = nil;
	orgaCode = @"orkin_cr";
	orgaId = @"1";
	countryCode = @"506";
	orgaCont = nil;
	mapCont = nil;
	scheCont = nil;

	
	
	return self;
}

- (void) changeColorBackground:(id)color {
	[contView setBackgroundColor:coloDefa];
}

- (id) messageViewClose {
	if ( messView )
    	[messView removeFromSuperview];
    messView= NULL;
    return messView;
}


- (void) openResourcesController:(id)sender {

	if ( isLogi == false){
		//alert("No login");
		return;
	}
	
	if ( [self messageViewClose] )
		return;

	if ( !resoCont ) {
		resoCont= [[RMSchedulerResourcesController alloc] init:self];
		[resoCont organizationCodeSet:orgaCode];
		[resoCont countryCodeSet:countryCode];
		[resoCont cgiSetHost:cgiHost server:cgiServ];
		[resoCont setColorWindow:coloDefaBrig];
		[resoCont resourcesPanel:self];
	}
	else
		[[resoCont resourcesPanel] makeKeyAndOrderFront:self];

	[resoCont appControllerSet:self];
	[resoCont mapControllerSet:mapCont];
}


- (void) openReportOrganizationController:(id)sender {	

	if ( isLogi == false){
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !repoOrgaCont ) {
		repoOrgaCont= [[RMSReportOrganizationController alloc] init:self];
		[repoOrgaCont organizationCodeSet:orgaCode];
		[repoOrgaCont cgiSetHost:cgiHost server:cgiServ];
		[repoOrgaCont setColorWindow:coloDefaBrig];
		[repoOrgaCont reportsPanel:self];
	}
	else
		[[repoOrgaCont reportsPanel] makeKeyAndOrderFront:self];
		

	[repoOrgaCont appControllerSet:self];
	[repoOrgaCont mapControllerSet:mapCont];
}


- (void) openReportLocationController:(id)sender {	
	if ( isLogi == false){
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !repoLocaCont ) {
		repoLocaCont= [[RMSReportLocationController alloc] init:self];
		[repoLocaCont organizationCodeSet:orgaCode];
		[repoLocaCont cgiSetHost:cgiHost server:cgiServ];
		[repoLocaCont setColorWindow:coloDefaBrig];
		[repoLocaCont reportsPanel:self];
	}
	else
		[[repoLocaCont reportsPanel] makeKeyAndOrderFront:self];
		

	[repoLocaCont appControllerSet:self];
	[repoLocaCont mapControllerSet:mapCont];
}


- (void) openReportPersonnelController:(id)sender {	

	if ( isLogi == false){
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !repoPersCont ) {
		repoPersCont= [[RMSReportPersonnelController alloc] init:self];
		[repoPersCont organizationCodeSet:orgaCode];
		[repoPersCont cgiSetHost:cgiHost server:cgiServ];
		[repoPersCont setColorWindow:coloDefaBrig];
		[repoPersCont reportsPanel:self];
	}
	else
		[[repoPersCont reportsPanel] makeKeyAndOrderFront:self];
		

	[repoPersCont appControllerSet:self];
	[repoPersCont mapControllerSet:mapCont];
}


- (void) openReportTecnicianController:(id)sender {	

	if ( isLogi == false){
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !repoTecCont ) {
		repoTecCont= [[RMSReportTecnicianController alloc] init:self];
		[repoTecCont organizationCodeSet:orgaCode];
		[repoTecCont cgiSetHost:cgiHost server:cgiServ];
		[repoTecCont setColorWindow:coloDefaBrig];
		[repoTecCont reportsPanel:self];
	}
	else
		[[repoTecCont reportsPanel] makeKeyAndOrderFront:self];
		

	[repoTecCont appControllerSet:self];
	[repoTecCont mapControllerSet:mapCont];
}

- (void) openAutomaticReportOrganization:(id)sender {	

	if ( isLogi == false){
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !autoRepoOrga ) {
		autoRepoOrga = [[AutomaticOrganization alloc] init:self];
		[autoRepoOrga organizationCodeSet:orgaCode];
		[autoRepoOrga cgiSetHost:cgiHost server:cgiServ];
		[autoRepoOrga setColorWindow:coloDefaBrig];
		[autoRepoOrga reportsPanel:self];
	}
	else
		[[autoRepoOrga reportsPanel] makeKeyAndOrderFront:self];
		
		

	[autoRepoOrga appControllerSet:self];
	[autoRepoOrga mapControllerSet:mapCont];
}



- (void) openAutomaticReportLocation:(id)sender {	

	if ( isLogi == false){
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !autoRepoLoca ) {
		autoRepoLoca= [[AutomaticLocation alloc] init:self];
		[autoRepoLoca organizationCodeSet:orgaCode];
		[autoRepoLoca cgiSetHost:cgiHost server:cgiServ];
		[autoRepoLoca setColorWindow:coloDefaBrig];
		[autoRepoLoca reportsPanel:self];
	}
	else
		[[autoRepoLoca reportsPanel] makeKeyAndOrderFront:self];
		
		

	[autoRepoLoca appControllerSet:self];
	[autoRepoLoca mapControllerSet:mapCont];
}

//
- (void) openAutomaticReportPersonnel:(id)sender {	

	if ( isLogi == false){
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !autoRepoPers ) {
		autoRepoPers= [[AutomaticPersonnel alloc] init:self];
		[autoRepoPers organizationCodeSet:orgaCode];
		[autoRepoPers cgiSetHost:cgiHost server:cgiServ];
		[autoRepoPers setColorWindow:coloDefaBrig];
		[autoRepoPers reportsPanel:self];
	}
	else
		[[autoRepoPers reportsPanel] makeKeyAndOrderFront:self];
		
		

	[autoRepoPers appControllerSet:self];
	[autoRepoPers mapControllerSet:mapCont];
}



- (void) openReportAnnualController:(id)sender {	

	if ( isLogi == false){
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !repoAnnuCont ) {
		repoAnnuCont= [[RMSReportAnnualController alloc] init:self];
		[repoAnnuCont organizationCodeSet:orgaCode];
		[repoAnnuCont cgiSetHost:cgiHost server:cgiServ];
		[repoAnnuCont setColorWindow:coloDefaBrig];
		[repoAnnuCont reportsPanel:self];
	}
	else
		[[repoAnnuCont reportsPanel] makeKeyAndOrderFront:self];
		

	[repoAnnuCont appControllerSet:self];
	[repoAnnuCont mapControllerSet:mapCont];
}


/*
- (void) openReportController {
	
	if ( isLogi == false){
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !repoOrgaCont ) {		
		repoOrgaCont = [[RMSchedulerReportController alloc] init:self];
		[repoOrgaCont organizationCodeSet:orgaCode];
		[repoOrgaCont cgiSetHost:cgiHost server:cgiServ];
		[repoOrgaCont reportsPanel:self];
	}
	else{
		[repoOrgaCont setTypeReportSelected:typeRepo];
		[[repoOrgaCont reportsPanel] makeKeyAndOrderFront:self];
	}

	[repoOrgaCont appControllerSet:self];
	[repoOrgaCont mapControllerSet:mapCont];
	
}
*/


- (void) openOrganizationsController:(id)sender {
	
	//var flag = [self isLogi];
	if ( isLogi == false){
		//alert("No login");
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !orgaCont ) {
		//alert("db= " +  dataBase);
		orgaCont= [[RMSchedulerOrganizationsController alloc] init:self];
		[orgaCont organizationCodeSet:orgaCode];
		[orgaCont cgiSetHost:cgiHost server:cgiServ];
		//alert("db AppController= " + dataBase);
		[orgaCont setColorWindow:coloDefaBrig];
		[orgaCont organizationsPanel:self];
	}
	else
		[[orgaCont organizationsPanel] makeKeyAndOrderFront:self];

	[orgaCont appControllerSet:self];
	[orgaCont mapControllerSet:mapCont];
}



- (void) openMapController:(id)sender {

	if ( isLogi == false){
		//alert("No login");
		return;
	}
	
	if ( [self messageViewClose] )
		return;

	if ( !mapCont ) {
		mapCont = [[PSTrackingMap alloc] init:self];
		[orgaCont cgiSetHost:cgiHost server:cgiServ];
	}
	else {
		[mapCont showMap];
	}

	[mapCont appControllerSet:self];
}



- (void) openSchedulerController:(id)sender {
	if ( isLogi == false){
		//alert("No login");
		return;
	}
	
	if ( [self messageViewClose] )
		return;

	if ( ! scheCont ) {
		scheCont = [[RMSchedulerController alloc] init:self];
		[scheCont organizationCodeSet:orgaCode];
		[scheCont countryCodeSet:countryCode];
		[scheCont cgiSetHost:cgiHost server:cgiServ];
		[scheCont setColorWindow:coloDefaBrig];
		[scheCont schedulerPanel:self];
	}
	else
		[[scheCont schedulerPanel] makeKeyAndOrderFront:self];

	[scheCont appControllerSet:self];
	[scheCont mapControllerSet:mapCont];
}



- (void) openStatisticsController:(id)sender {

	if ( isLogi == false){
		//alert("No login");
		return;
	}
	
	if ( [self messageViewClose] )
		return;

	if ( ! statCont ) {
		statCont= [[RMSchedulerStatisticsController alloc] init:self];
		[statCont organizationCodeSet:orgaCode];
		[statCont cgiSetHost:cgiHost server:cgiServ];
		[statCont setColorWindow:coloDefaBrig];
		[statCont statisticsPanel:self];
	}
	else
		[[statCont statisticsPanel] makeKeyAndOrderFront:self];

	[statCont appControllerSet:self];
	[statCont mapControllerSet:mapCont];
}

- (void) openUsersController:(id)sender {	

	if ( isLogi == false){
		return;
	}
	
	if (role != 2){
		[glblAlerPane showWithMessage:@"Atención" info:"No tiene los permisos necesarios para ingresar."];
		return;
	}

	if ( [self messageViewClose] )
		return;

	if ( !userCont ) {
		userCont = [[RMSchedulerUserController alloc] init:self];
		[userCont organizationCodeSet:orgaCode];
		[userCont cgiSetHost:cgiHost server:cgiServ];
		[userCont setColorWindow:coloDefaBrig];
		[userCont reportsPanel:self];
	}
	else
		[[userCont reportsPanel] makeKeyAndOrderFront:self];
		

	[userCont appControllerSet:self];
	[userCont mapControllerSet:mapCont];
}

- (void) openPreferencesController:(id)sender {	

	if ( isLogi == false){
		return;
	}
	

	if ( [self messageViewClose] )
		return;

	if ( !preferCont ) {
		preferCont = [[RMSchedulerPreferencesController alloc] init:self];
		[preferCont organizationCodeSet:orgaCode];
		[preferCont cgiSetHost:cgiHost server:cgiServ];
		[preferCont setColorWindow:coloDefaBrig];
		[preferCont reportsPanel:self];
	}
	else
		[[preferCont reportsPanel] makeKeyAndOrderFront:self];
		

	[preferCont appControllerSet:self];
	[preferCont mapControllerSet:mapCont];
}



@end
