/*
 * RSMPoint.j
 * Route Schedule Maker
 *
 * Created by F. Gomez on December 19, 2011.
 * Copyright 2010, Predisoft Internacional S.A. All rights reserved.
 */

@import <Foundation/CPObject.j>


/* ********************************************************************************************* 
 * RSMPoint
 * 
 * 
 *
 *
 *
 *********************************************************************************************** */
@implementation RSMPoint : CPObject
{
	double _latitude;
	double _longitude;
}



-(id) init {
	self = [super init];
	return self;
}
-(id) initWithLatLong:(double)aLatitude longitud:(double)aLongitude
{
	self = [super init];
	_latitude = aLatitude;
	_longitude = aLongitude;
	return self;
}
-(id) initRandom:(double)aDouble;
{
	self = [super init];
	var alpha;
	if(aDouble!=-1)
	{
		alpha = aDouble;
	}
	else
	{
		alpha = 0.1;
	}
	var xCent= -84.1;
	var yCent= 9.93;
	var x;
	var y;		
	y = (yCent + alpha*(Math.random()-.5));
	x = (xCent + alpha*(Math.random()-.5));
	_latitude = y; 
	_longitude = x;
	return self;
}



-(double) latitude {
	return _latitude;
}



-(double) longitude {
	return _longitude;
}



@end
