// RMSchedulerAssetsController.j
// RMSchedulerAssetsController
// Created by Anthony Picado Ávila

@import <Foundation/Foundation.j>
@import <AppKit/AppKit.j>
@import <MapKit/MKMapView.j>
@import <AppKit/CPTextField.j>
@import <AppKit/CPApplication.j>
@import <Foundation/CPURLRequest.j>
//@import "RMTabView.j"
@import "AppController.j"



@implementation RMSchedulerStatisticsController : RMControllerObject {

	CPPanel statPane;

	CPTableView orgaContStatTabl;
	CPArray orgaContStatArra;

	CPTableView orgaLocaContStatTabl;
	CPArray orgaLocaContStatArra;

	CPTableView orgaPersStatTabl;
	CPArray orgaPersStatArra;
	CPTableView orgaPersWeekStatTabl;
	CPArray orgaPersWeekStatArra;
	int orgaPersWeekStatInde;

	CPTableView orgaReveStatTabl;
	CPArray orgaReveStatArra;

	CPTableView orgaLocaReveStatTabl;
	CPArray orgaLocaReveStatArra;

}



- (void)  applicationQuit {
	if ( statPane ) {
		[statPane orderOut:0];
		[statPane release];
	}
}



- (id) init:(id)paraAppCont {
	[super init];

	orgaPersWeekStatInde = 0;
	statPane = NULL;
	appCont = paraAppCont;
	dataBase = [appCont getDataBase];
	//alert("db init statistics= " + [appCont getDataBase]);

	return self;
}



- (void) statisticsPanel {
	return statPane;
}



- (void) statisticsPanel:(id)sender {

	var horiPos1 = 10;
	var horiPos2 = horiPos1 + 100;
	var horiPos3 = 390;
	var horiPos4 = horiPos3 + 100;

	var horiTextWidt = 200;
	var horiPosiOffs = -4;
	var horiPosi = 200;

	var vertPosi = 20;
	var vertPosiOffs = -4;
	var vertIncr = 26;
	var vertLineHeig = 30;

	var paneWidt = 1150;
	var paneHeig = 680;
	var tablWidt = paneWidt - 20;
	var tablHeig = 250;
	
	var x = 10 + Math.random()*40;
	var y = 60 + Math.random()*40;
	var fram = CGRectMake(x,y, paneWidt,paneHeig);

	statPane = [[CPPanel alloc] initWithContentRect:fram styleMask:CPHUDBackgroundWindowMask|CPClosableWindowMask|CPResizableWindowMask]; 
	[statPane setFloatingPanel:YES]; 
	[statPane orderFront:self];
	[statPane setTitle:@"Panel Estadisticas"];
	
	var paneContView = [statPane contentView];
	[paneContView setBackgroundColor:coloDefaLite];
	[self addBanners:paneContView heightBlue:1. heightOrange:4.];

	fram = CGRectMake(10,10,paneWidt-10,paneHeig-10);

	var tabView = [[CPTabView alloc] initWithFrame:fram];
	//[tabView setBackgroundColor:coloDefaBrig];
	//[tabView setAutoresizingMask:CPViewWidthSizable|CPViewHeightSizable|CPViewMinXMargin];
	[tabView setDelegate:self];
	[paneContView addSubview:tabView]; 

	var labe;
	var tabViewItem;
	var view;


	// Revenue *************************************************

	tabViewItem = [[CPTabViewItem alloc] initWithIdentifier:@"revenues"];
	[tabViewItem setLabel:@"  Ventas  "];
				
	view = [[CPView alloc] initWithFrame: CGRectMake(50,50, 50,50)]; // donde se pone los controles --> cp view
	[view setBackgroundColor:coloDefaBrig];

	vertPosi = 20;

	var fram= CGRectMake(horiPos2,vertPosi, 400,tablHeig);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	orgaReveStatTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[orgaReveStatTabl setDataSource:self];
	[orgaReveStatTabl setTarget:self];
	[orgaReveStatTabl setAction:@selector(organizationRevenueTableSelection:)];
	[orgaReveStatTabl setAllowsColumnReordering:YES];
	[orgaReveStatTabl setUsesAlternatingRowBackgroundColors:YES];
	[orgaReveStatTabl setAllowsMultipleSelection:YES];
	[orgaReveStatTabl setDelegate:self];

	var colu= [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:80];
	[orgaReveStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Organization"];
	[[colu headerView] setStringValue:@"Organizacion"];
	[colu setWidth:160];
	[orgaReveStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Revenue"];
	[[colu headerView] setStringValue:@"Ventas"];
	[colu setWidth:100];
	[orgaReveStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Hours"];
	[[colu headerView] setStringValue:@"Horas"];
	[colu setWidth:80];
	[orgaReveStatTabl addTableColumn:colu];

	[scroView setDocumentView:orgaReveStatTabl];

	[view addSubview:scroView];


	fram= CGRectMake(horiPos2+500,vertPosi, 400,tablHeig);
	scroView= [[CPScrollView alloc] initWithFrame:fram];

	orgaLocaReveStatTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[orgaLocaReveStatTabl setDataSource:self];
	[orgaLocaReveStatTabl setTarget:self];
	[orgaLocaReveStatTabl setAction:@selector(organizationLocationRevenueTableSelection:)];
	[orgaLocaReveStatTabl setAllowsColumnReordering:YES];
	[orgaLocaReveStatTabl setUsesAlternatingRowBackgroundColors:YES];
	[orgaLocaReveStatTabl setAllowsMultipleSelection:YES];
	[orgaLocaReveStatTabl setDelegate:self];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:60];
	[orgaLocaReveStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Location"];
	[[colu headerView] setStringValue:@"Locacion"];
	[colu setWidth:160];
	[orgaLocaReveStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Revenue"];
	[[colu headerView] setStringValue:@"Ventas"];
	[colu setWidth:100];
	[orgaLocaReveStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Hours"];
	[[colu headerView] setStringValue:@"Horas"];
	[colu setWidth:80];
	[orgaLocaReveStatTabl addTableColumn:colu];

	[scroView setDocumentView:orgaLocaReveStatTabl];

	[view addSubview:scroView];


    vertPosi += tablHeig + 10;

    var butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2,vertPosi, 80,24)];
	[butt setTitle:"Recalcular"];
	[butt setTarget:self];
	[butt setAction:@selector(organizationRevenueStatistics:)];                
	[view addSubview:butt];


	[tabViewItem setView:view];

	[tabView addTabViewItem: tabViewItem];


	// Contracts *************************************************

	tabViewItem = [[CPTabViewItem alloc] initWithIdentifier:@"contracts"];
	[tabViewItem setLabel:@"  Contratos  "];
				
	view = [[CPView alloc] initWithFrame: CGRectMake(50,50, 50,50)]; // donde se pone los controles --> cp view
	[view setBackgroundColor:coloDefaBrig];

	vertPosi = 20;

	fram= CGRectMake(horiPos2,vertPosi, 440,tablHeig);
	scroView= [[CPScrollView alloc] initWithFrame:fram];

	orgaContStatTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[orgaContStatTabl setDataSource:self];
	[orgaContStatTabl setTarget:self];
	[orgaContStatTabl setAction:@selector(organizationContractTableSelection:)];
	[orgaContStatTabl setAllowsColumnReordering:YES];
	[orgaContStatTabl setUsesAlternatingRowBackgroundColors:YES];
	[orgaContStatTabl setAllowsMultipleSelection:YES];
	[orgaContStatTabl setDelegate:self];

	var colu= [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:80];
	[orgaContStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Organization"];
	[[colu headerView] setStringValue:@"Organizacion"];
	[colu setWidth:160];
	[orgaContStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"DateStart"];
	[[colu headerView] setStringValue:@"FechaInicio"];
	[colu setWidth:80];
	[orgaContStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"DateFinish"];
	[[colu headerView] setStringValue:@"FechaFin"];
	[colu setWidth:80];
	[orgaContStatTabl addTableColumn:colu];

	[scroView setDocumentView:orgaContStatTabl];

	[view addSubview:scroView];


	fram= CGRectMake(horiPos2+500,vertPosi, 400,tablHeig);
	scroView= [[CPScrollView alloc] initWithFrame:fram];

	orgaLocaContStatTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[orgaLocaContStatTabl setDataSource:self];
	[orgaLocaContStatTabl setTarget:self];
	[orgaLocaContStatTabl setAction:@selector(someTableSelection:)];
	[orgaLocaContStatTabl setAllowsColumnReordering:YES];
	[orgaLocaContStatTabl setUsesAlternatingRowBackgroundColors:YES];
	[orgaLocaContStatTabl setAllowsMultipleSelection:YES];
	[orgaLocaContStatTabl setDelegate:self];

	var colu= [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:60];
	[orgaLocaContStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Location"];
	[[colu headerView] setStringValue:@"Locacion"];
	[colu setWidth:160];
	[orgaLocaContStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"DateStart"];
	[[colu headerView] setStringValue:@"FechaInicio"];
	[colu setWidth:80];
	[orgaLocaContStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"DateFinish"];
	[[colu headerView] setStringValue:@"FechaFin"];
	[colu setWidth:80];
	[orgaLocaContStatTabl addTableColumn:colu];

	[scroView setDocumentView:orgaLocaContStatTabl];

	[view addSubview:scroView];


    vertPosi += tablHeig + 10;

    var butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2,vertPosi, 80,24)];
	[butt setTitle:"Recalcular"];
	[butt setTarget:self];
	[butt setAction:@selector(organizationContractStatistics:)];                
	[view addSubview:butt];


	[tabViewItem setView:view];

	[tabView addTabViewItem: tabViewItem];


	// Personnel *************************************************

	tabViewItem = [[CPTabViewItem alloc] initWithIdentifier:@"personnel"];
	[tabViewItem setLabel:@"  Personal  "];
				
	view = [[CPView alloc] initWithFrame: CGRectMake(50,50, 50,50)]; // donde se pone los controles --> cp view
	[view setBackgroundColor:coloDefaBrig];

	vertPosi = 20;

	var fram= CGRectMake(horiPos2,vertPosi, 400,tablHeig);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	orgaPersStatTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[orgaPersStatTabl setDataSource:self];
	[orgaPersStatTabl setTarget:self];
	[orgaPersStatTabl setAction:@selector(organizationPersonnelStatisticsTableSelection:)];
	[orgaPersStatTabl setAllowsColumnReordering:YES];
	[orgaPersStatTabl setUsesAlternatingRowBackgroundColors:YES];
	[orgaPersStatTabl setAllowsMultipleSelection:YES];
	[orgaPersStatTabl setDelegate:self];

	var colu= [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:80];
	[orgaPersStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"NameLast"];
	[[colu headerView] setStringValue:@"Apellidos"];
	[colu setWidth:120];
	[orgaPersStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"NameFirst"];
	[[colu headerView] setStringValue:@"Nombre"];
	[colu setWidth:120];
	[orgaPersStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Hours"];
	[[colu headerView] setStringValue:@"Horas"];
	[colu setWidth:80];
	[orgaPersStatTabl addTableColumn:colu];

	[scroView setDocumentView:orgaPersStatTabl];

	[view addSubview:scroView];

	fram= CGRectMake(horiPos2+500,vertPosi, 400,tablHeig);
	scroView= [[CPScrollView alloc] initWithFrame:fram];

	orgaPersWeekStatTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[orgaPersWeekStatTabl setDataSource:self];
	[orgaPersWeekStatTabl setTarget:self];
	[orgaPersWeekStatTabl setAction:@selector(someTableSelection:)];
	[orgaPersWeekStatTabl setAllowsColumnReordering:YES];
	[orgaPersWeekStatTabl setUsesAlternatingRowBackgroundColors:YES];
	[orgaPersWeekStatTabl setAllowsMultipleSelection:YES];
	[orgaPersWeekStatTabl setDelegate:self];

	var colu= [[CPTableColumn alloc] initWithIdentifier:@"Fecha1"];
	[[colu headerView] setStringValue:@"Fecha1"];
	[colu setWidth:120];
	[orgaPersWeekStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Fecha2"];
	[[colu headerView] setStringValue:@"Fecha2"];
	[colu setWidth:120];
	[orgaPersWeekStatTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"Horas"];
	[[colu headerView] setStringValue:@"Horas"];
	[colu setWidth:80];
	[orgaPersWeekStatTabl addTableColumn:colu];

	[scroView setDocumentView:orgaPersWeekStatTabl];

	[view addSubview:scroView];


    vertPosi += tablHeig + 10;

    var butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2,vertPosi, 80,24)];
	[butt setTitle:"Recalcular"];
	[butt setTarget:self];
	[butt setAction:@selector(organizationPersonnelStatistics:)];                
	[view addSubview:butt];


	[tabViewItem setView:view];

	[tabView addTabViewItem: tabViewItem];



	[tabView selectFirstTabViewItem:0];

}



// Contracts

- (void) organizationContractStatistics:(id)sender {
	[orgaContStatTabl reloadData];
}



- (void) organizationContractTableSelection:(id)sender {
	[orgaLocaContStatTabl reloadData];
}



// Personnel

- (void) organizationPersonnelStatistics:(id)sender {
	[orgaPersStatTabl reloadData];
	[orgaPersWeekStatTabl reloadData];
}



- (void) organizationPersonnelStatisticsTableSelection:(id)sender {
	[orgaPersWeekStatTabl reloadData];
}


// Revenue 

- (void) organizationRevenueStatistics:(id)sender {
	[orgaReveStatTabl reloadData];
}



- (void) organizationRevenueTableSelection:(id)sender {
	[orgaLocaReveStatTabl reloadData];
}





//		TAB SOURCE DELEGATE METHODS


- (void) tabView:(CPTabView)tabView willSelectTabViewItem:(CPTabViewItem)tabViewItem {
        var tabIden = [tabViewItem identifier];
        if ( [tabIden isEqualToString:@"revenue"])
        	[orgaReveStatTabl reloadData];
        else if ( [tabIden isEqualToString:@"personnel"])
        	[orgaPersStatTabl reloadData];
}



//		TABLE SOURCE DELEGATE METHODS

- (int) numberOfRowsInTableView:(CPTableView)tablView {
	var coun= 0;
	var quer;

	if ( tablView == orgaContStatTabl ) {
		quer = @"select t1.id,t1.name,substring(min(t2.start_date),1,10),substring(max(t2.end_date),1,10) from "+ dataBase + ".organizations t1, " + dataBase + ".events t2 where t2.customer=concat(t1.name,':',t1.id)  group by t1.id order by t1.name";
		orgaContStatArra = [self query:quer];
		coun = [orgaContStatArra count];
	}
	else if ( tablView == orgaLocaContStatTabl ) {
		var inde = [orgaContStatTabl selectedRow];
		if ( inde < 0 )
			return 0;
		var valuList = [orgaContStatArra[inde] valueList];
		var orga = [CPString stringWithFormat:@"%@:%@",valuList[1],valuList[0]];
		quer = [CPString stringWithFormat:@"select substring(location,locate(':',location)+1),substring(location,1,locate(':',location)-1),substring(min(start_date),1,10),substring(max(end_date),1,10) from %@.events where customer='%@'  group by location order by location",
			dataBase,orga];
		orgaLocaContStatArra = [self query:quer];
		coun = [orgaLocaContStatArra count];
	}
	else if ( tablView == orgaPersStatTabl ) {
		quer = [CPString stringWithFormat:@"select t1.id,t1.nameLast,t1.nameFirst, sum((unix_timestamp(concat(t3.end_date,':00'))-unix_timestamp(concat(t3.start_date,':00'))))/3600. hours from %@.persons t1, %@.organizationPersons t2, %@.events t3 where t2.organizationId='%@' and t1.id=t2.personId and t3.personnel like concat('%%:',t1.id,'|%%')  group by t1.nameLast,t1.nameFirst order by t1.nameLast,t1.nameFirst",
			dataBase,dataBase,dataBase,orgaCode];
		orgaPersStatArra = [self query:quer];
		coun = [orgaPersStatArra count];
	}
	else if ( tablView == orgaPersWeekStatTabl ) {
		var inde = [orgaPersStatTabl selectedRow];
		if ( inde < 0 )
			return 0;
		var valuList = [orgaPersStatArra[inde] valueList];
		var persIden = valuList[0];

		if ( orgaPersWeekStatInde == 0 ) {
			orgaPersWeekStatInde = 1;

			var dateStar = [CPDate date];
			var dateStarDesc = [dateStar description];
			var rang = CPMakeRange(0,4);
			var year = [[dateStarDesc substringWithRange:rang] intValue];
			var rang = CPMakeRange(5,2);
			var mont = [[dateStarDesc substringWithRange:rang] intValue];
			var stri = [CPString stringWithFormat:@"%04d-%02d-01 00:00:00 -0600",year,mont];

			dateStar = [[CPDate alloc] initWithString:stri];
			var quer = @"";
			for ( var i=0; i<12; i++ ) {
				mont++;
				if ( mont > 12 ) {
					year++;
					mont = 1;
				}
				dateFini = [[CPDate alloc] initWithString:[CPString stringWithFormat:@"%04d-%02d-01 00:00:00 -0600",year,mont]];
				if ( i>0 )
					quer = [CPString stringWithFormat:@"%@ union ",quer];
				var dateStarStri = [[dateStar description] substringToIndex:10] + " 00:00";
				var dateFiniStri = [[dateFini description] substringToIndex:10] + " 00:00";
				quer = [CPString stringWithFormat:@"%@select '%@','%@',sum((unix_timestamp(concat(end_date,':00'))-unix_timestamp(concat(start_date,':00'))))/3600. hours from %@.events where personnel like concat('%%:',%@,'|%%') and start_date>='%@' and end_date<='%@'",
					dataBase,quer,dateStarStri,dateFiniStri,persIden,dateStarStri,dateFiniStri];
				dateStar = dateFini;
			}
			orgaPersWeekStatArra = [self query:quer];
			coun = [orgaPersWeekStatArra count];
			//alert(quer+"   count="+coun);
		}
		else if ( orgaPersWeekStatInde == 1 ) {
			orgaPersWeekStatInde = 0;
			var dateStar = [CPDate date];
			var stri = [CPString stringWithFormat:@"%@ 00:00:00 -0600",[[dateStar description] substringToIndex:10]];
			dateStar = [[CPDate alloc] initWithString:stri];
			var day = dateStar.getDay();
			if ( day )
				dateStar = [[CPDate alloc] initWithTimeInterval:-day*24*3600. sinceDate:dateStar];
			var quer = @"";
			var timeInte = 7*24*3600.;
			for ( var i=0; i<13; i++ ) {
				var dateFini = [[CPDate alloc] initWithTimeInterval:timeInte sinceDate:dateStar];
				if ( i>0 )
					quer = [CPString stringWithFormat:@"%@ union ",quer];
				var dateStarStri = [[dateStar description] substringToIndex:10] + " 00:00";
				var dateFiniStri = [[dateFini description] substringToIndex:10] + " 00:00";
				quer = [CPString stringWithFormat:@"%@select '%@','%@',sum((unix_timestamp(concat(end_date,':00'))-unix_timestamp(concat(start_date,':00'))))/3600. hours from %@.events where personnel like concat('%%:',%@,'|%%') and start_date>='%@' and end_date<='%@'",
					quer,dateStarStri,dateFiniStri,dataBase,persIden,dateStarStri,dateFiniStri];
				dateStar = dateFini;
			}
			orgaPersWeekStatArra = [self query:quer];
			coun = [orgaPersWeekStatArra count];
		}

	}
	else if ( tablView == orgaReveStatTabl ) {
		quer = @"select substring(customer,locate(':',customer)+1),substring(customer,1,locate(':',customer)-1),sum(billing) billing,sum((unix_timestamp(concat(end_date,':00'))-unix_timestamp(concat(start_date,':00'))))/3600. hours from " + dataBase + ".events group by customer order by billing desc";
		orgaReveStatArra = [self query:quer];
		coun = [orgaReveStatArra count];
	}
	else if ( tablView == orgaLocaReveStatTabl ) {
		var inde = [orgaReveStatTabl selectedRow];
		if ( inde < 0 )
			return 0;
		var valuList = [orgaReveStatArra[inde] valueList];
		var cust = [CPString stringWithFormat:@"%@:%@",valuList[1],valuList[0]];
		quer = [CPString stringWithFormat:@"select substring(location,locate(':',location)+1),substring(location,1,locate(':',location)-1),sum(billing) billing,sum((unix_timestamp(concat(end_date,':00'))-unix_timestamp(concat(start_date,':00'))))/3600. hours from %@.events where customer='%@' group by location order by billing desc",
			dataBase,cust];
		orgaLocaReveStatArra = [self query:quer];
		coun = [orgaLocaReveStatArra count];
	}
	
	return coun;
}




- (id) tableView:(CPTableView)tablView objectValueForTableColumn:(CPTableColumn)tablColu row:(int)rowInde {
	var headStri= [[tablColu headerView] stringValue];
	var headIden= [tablColu identifier];
	var valu= @"N/A";

	if ( tablView == orgaContStatTabl ) {
		var arra= [[orgaContStatArra objectAtIndex:rowInde] valueList];
		if ( [headIden isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headIden isEqualToString:@"Organization"] )
			valu = arra[1];
		else if ( [headIden isEqualToString:@"DateStart"] )
			valu = arra[2];
		else if ( [headIden isEqualToString:@"DateFinish"] )
			valu = arra[3];
	}
	else if ( tablView == orgaLocaContStatTabl ) {
		var arra= [[orgaLocaContStatArra objectAtIndex:rowInde] valueList];
		if ( [headIden isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headIden isEqualToString:@"Location"] )
			valu = arra[1];
		else if ( [headIden isEqualToString:@"DateStart"] )
			valu = arra[2];
		else if ( [headIden isEqualToString:@"DateFinish"] )
			valu = arra[3];
	}
	else if ( tablView == orgaPersStatTabl ) {
		var arra= [[orgaPersStatArra objectAtIndex:rowInde] valueList];
		if ( [headIden isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headIden isEqualToString:@"NameLast"] )
			valu = arra[1];
		else if ( [headIden isEqualToString:@"NameFirst"] )
			valu = arra[2];
		else if ( [headIden isEqualToString:@"Hours"] )
			valu = [CPString stringWithFormat:@"%.2f",[arra[3] floatValue]];
	}
	else if ( tablView == orgaPersWeekStatTabl ) {
		var arra = [[orgaPersWeekStatArra objectAtIndex:rowInde] valueList];
		if ( [headIden isEqualToString:@"Fecha1"] )
			valu = arra[0];
		else if ( [headIden isEqualToString:@"Fecha2"] )
			valu = arra[1];
		else if ( [headIden isEqualToString:@"Horas"] )
			valu = [CPString stringWithFormat:@"%.2f",[arra[2] floatValue]];
	}
	else if ( tablView == orgaReveStatTabl ) {
		var arra = [[orgaReveStatArra objectAtIndex:rowInde] valueList];
		if ( [headIden isEqualToString:@"ID"] )
			valu = arra[0];
		else if ( [headIden isEqualToString:@"Organization"] )
			valu = arra[1];
		else if ( [headIden isEqualToString:@"Revenue"] )
			valu = arra[2];
		else if ( [headIden isEqualToString:@"Hours"] )
			valu = [CPString stringWithFormat:@"%.2f",[arra[3] floatValue]];
	}
	else if ( tablView == orgaLocaReveStatTabl ) {
		var arra= [[orgaLocaReveStatArra objectAtIndex:rowInde] valueList];
		if ( [headIden isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headIden isEqualToString:@"Location"] )
			valu= arra[1];
		else if ( [headIden isEqualToString:@"Revenue"] )
			valu= arra[2];
		else if ( [headIden isEqualToString:@"Hours"] )
			valu = [CPString stringWithFormat:@"%.2f",[arra[3] floatValue]];
	}

	return valu;
}



@end