/*
 * ServerRecord.j
 * RouteIntelligence
 *
 * Created by P. Miranda on June 29, 2010.
 * Copyright 2010, Predisoft Internacional S.A. All rights reserved.
 */



@import <Foundation/CPObject.j>

 

@implementation ServerRecord : CPObject {
	CPMutableDictionary     recoDict;
	CPArray                 keyList;
	CPArray                 valList;
	id                     chldList;
}



- (id) attached {
	return chldList;
}

- (void) attachChilds:(id)_chlds {
    // Agrega un paquete de hijos obtenidos del servidor
	chldList = _chlds;
}

- (id) initWithKeyList:(CPArray)kl valueList:(CPArray)vl {
	[super init];
	keyList = [[CPArray alloc] initWithArray:kl];
	valList = [[CPArray alloc] initWithArray:vl];
	recoDict = [[CPDictionary alloc] initWithObjects:valList forKeys:keyList];
	return self;
}



- (CPArray) keyList {
	return keyList;
}



- (CPString) valueForColumn:(CPString)_coluName {
	return [recoDict valueForKey:(_coluName)];	
}



- (CPArray) valueList {
	return valList;
}


@end