//
// RMSchedulerController
//
// Created by Alonso Villanueva


@import "../AppController.j"
@import "EmployeeAutomaticReport.j"
@import "LocationAutomaticReport.j"

@import "Organization.j"
//@import "Location.j"
//@import "Person.j"



@implementation Model : RMControllerObject {

	id emplAutoRepoDict @accessors(getter=emplAutoRepoDict, setter=emplAutoRepoDict:);
	id locaAutoRepoDict @accessors(getter=locaAutoRepoDict, setter=locaAutoRepoDict:);

	id orgaDict @accessors(getter=orgaDict, setter=orgaDict:);
	id locaDict @accessors(getter=locaDict, setter=locaDict:);
	id persDict @accessors(getter=persDict, setter=persDict:);
}



- (id) init:(id)paraAppCont {
	[super init];
 	appCont = paraAppCont;
	dataBase = [appCont getDataBase];
	emplAutoRepoDict = [[CPDictionary alloc] init];
	locaAutoRepoDict = [[CPDictionary alloc] init];

	orgaDict = [[CPDictionary alloc] init];
	locaDict = [[CPDictionary alloc] init];
	persDict = [[CPDictionary alloc] init];
	
	return self;
}


- (void)  applicationQuit {

	if (emplAutoRepoDict) { [emplAutoRepoDict  release];}

}


//Empty
- (void)  emptyEmplAutoRepoDict {
	[emplAutoRepoDict removeAllObjects];
}

- (void)  emptyLocaAutoRepoDict {
	[locaAutoRepoDict removeAllObjects];
}


- (void)  emptyOrganizationsDictionary {
	[orgaDict removeAllObjects];
}

- (void)  emptyLocationsDictionary {
	[locaDict removeAllObjects];
}


- (void)  emptyPersonsDictionary {
	[persDict removeAllObjects];
}



//GET
- (id) getEmployeesArray {
	return emplAutoRepoDict;
}

- (id) getOrganizationsDictionary {
	return orgaDict;
}

- (id) getLocationsDictionary {
	return locaDict;
}

- (id) getPersonsDictionary {
	return persDict;
}





- (void)  loadEmployeesAutomaticReport {

	var quer;
	//alert("count " + [emplAutoRepoDict count ]);
	if ( [emplAutoRepoDict count ] == 0 ) { 
	quer = "SELECT ";
	quer += "t1.id,t1.nameLast,t1.nameFirst,t1.email,t2.position, ";
	quer += "t3.initialDate,t3.daysToSend,t3.contentParameters,t3.emailList,t3.active,t3.comment2,t3.sendEmpty FROM ";
	quer += [CPString stringWithFormat:@"%@.persons t1, %@.organizationPersons t2, %@.automaticReportDefinitions t3 ",dataBase,dataBase,dataBase];
	quer += [CPString stringWithFormat:@"WHERE  t1.id IN ( select identifier from %@.automaticReportDefinitions  where typeReportId = 3) ",dataBase];
	quer += [CPString stringWithFormat:@"AND  t2.organizationId='%@' ",orgaId];
	quer += "AND t1.id=t2.personId AND t1.id=t3.identifier AND t2.active = 1 ";
	quer += "ORDER BY t1.nameLast,t1.nameFirst";
	//alert("quer = " + quer);
	var resuArra = [self query:quer];
	var coun = [resuArra count];
	for (var i = 0; i < coun; i++){
		var valu = [[resuArra objectAtIndex:i] valueList];
		var iden = valu[0];
		var nameLast = valu[1];
		var nameFirst = valu[2];
		var emai = valu[3];
		var roleTemp = valu[4];
		var initDate = valu[5];
		var days = valu[6];
		var contPara = valu[7];
		var emaiList = valu[8];
		var actiTemp = valu[9];
		var comm2 = valu[10];
		var empt = valu[11];
		
		/*var stri  = "iden " + iden + " lawId "+ lawId +  " nameLast " + nameLast + " nameFirst " + nameFirst + " posi " + posi + " Stree " + stre + " city "+ city + " stat " +  stat;
		    stri += " phone1 "+ phon1 + " phone 2" + phon2 + " email "+ emai + " note " + note + " acti "+ acti + " days" + days + " iden2 " + iden2; 
		//alert(stri );*/
		var tempObjt = [[EmployeeAutomaticReport alloc] init:iden nameLast:nameLast nameFirst:nameFirst 
						email:emai role:roleTemp initDate:initDate daysToSend:days contPara:contPara emaiList:emaiList acti:actiTemp 
						comm2:comm2 sendEmpt:empt];
						
 	 [emplAutoRepoDict setObject:tempObjt  forKey:"" + iden + "" ];
			
	 }

	}
}



- (void)  loadLocationsAutomaticReport {

	var quer;
	if ( [locaAutoRepoDict count ] == 0 ) { 
	quer = "SELECT ";
	quer += "identifier,initialDate,prevDays,active,sendEmpty,comment1,comment2  ";
	quer += [CPString stringWithFormat:@"FROM %@.automaticReportDefinitions ",dataBase];
	quer += "WHERE typeReportId = 2 AND sendFrequencyId = 4";
	//alert("quer = " + quer);
	var resuArra = [self query:quer];
	var coun = [resuArra count];
	for (var i = 0; i < coun; i++){
		var valu = [[resuArra objectAtIndex:i] valueList];
		var iden = valu[0];		
		var init = valu[1];
		var days = valu[2];
		var actiTemp = valu[3];
		var empt = valu[4];
		var c1   = valu[5];
		var c2   = valu[6];
		
		
		/*var stri  = "iden " + iden + " lawId "+ lawId +  " nameLast " + nameLast + " nameFirst " + nameFirst + " posi " + posi + " Stree " + stre + " city "+ city + " stat " +  stat;
		    stri += " phone1 "+ phon1 + " phone 2" + phon2 + " email "+ emai + " note " + note + " acti "+ acti + " days" + days + " iden2 " + iden2; 
		//alert(stri );*/
		var tempObjt = [[LocationAutomaticReport alloc] init:iden initDate:init daysPrev:days acti:actiTemp sendEmpt:empt
     						 comm1:c1 comm2:c2 ];
	 // console.log("idenLocaRepo = " + iden);
 	 [locaAutoRepoDict setObject:tempObjt  forKey:"" + iden + "" ];		
	 }
  }
}






- (void)  loadOrganizationsDictionary {

	var quer;
	if( [orgaDict count ] == 0){
		
		quer = "SELECT ";
		quer += "idPrimary,lawId,name,NameLegal,email,phone1,phone2,AddressCity,AddressState,AddressStreet,notes ";
		quer += "FROM ";
		quer += [CPString stringWithFormat:@"%@.organizations ",dataBase];
		quer += "WHERE ";
		quer += "active = 1 and deletion = 0 ";
		quer += "ORDER BY name";
		//alert(quer);
		var resuArra = [self query:quer];
		var coun = [resuArra count];
		for (var i = 0; i < coun; i++){
			var valu = [[resuArra objectAtIndex:i] valueList];
			var orga  = valu[0];
			var law   = valu[1];
			var name  = valu[2];
			var lega  = valu[3];
			var emai  = valu[4];
			var p1    = valu[5];
			var p2    = valu[6];
			var city  = valu[7];
			var state = valu[8];
			var stre  = valu[9];
			var note  = valu[10];
			
			var tempObjt = [[Organization alloc] init:orga lawId:law name:name nameLega:lega emai:emai phon1:p1 phon2:p2 cityAddr:city statAddr:state streAddr:stre note:note];
			/*
			console.log("get locations of orga = " + [tempObjt name] );
			var resu = [self loadLocationsOfOrganizationsDictionary:orga];
			if( [resu count] > 0 ){
				[tempObjt locaDict:resu];
			}			
			*/
			[orgaDict setObject:tempObjt  forKey:"" + orga + "" ];
		}	
		
	}
		
}




- (void)  loadLocationsDictionary {

	var quer;
	if( [locaDict count ] == 0){
		
		quer = "SELECT ";
		quer += "id,organizationId,name,email,phone,";
		quer += "AddressCity,AddressState,AddressStreet,AddressBuilding,AddressGate,";
		quer += "Contact0Id,Contact1Id,Contact2Id,Contact3Id,";
		quer += "ContactCorporate0Id,ContactCorporate1Id,ContactCorporate2Id,ContactCorporate3Id,";
		quer += "LocationLatitude,LocationLongitude,notes,color ";
		quer += "FROM ";
		quer += [CPString stringWithFormat:@"%@.organizationLocations ",dataBase];
		quer += "WHERE ";
		quer += "active = 1 ";
		quer += "order by name ";
		
		var resuArra = [self query:quer];
		var coun = [resuArra count];
		for (var i = 0; i < coun; i++){
			var valu = [[resuArra objectAtIndex:i] valueList];
			
			var iden = valu[0];
			var orga = valu[1];
			var name = valu[2];
			var emai = valu[3];
			var phon = valu[4];
			
			var city  = valu[5];
			var state = valu[6];
			var stre  = valu[7];
			var bui   = valu[8];
			var gate  = valu[9];
			
			var c0 = valu[10];
			var c1 = valu[11];
			var c2 = valu[12];			
			var c3 = valu[13];
			
			var c4 = valu[14];
			var c5 = valu[15];
			var c6 = valu[16];
			var c7 = valu[17];
			
			var latt = valu[18];
			var lonn = valu[19];
			
			var note = valu[20];
			var colo = valu[21];
			
			///*
			var tempObjt = [[Location alloc] init:iden idenOrga:orga name:name  emai:emai phon:phon
      			 cityAddr:city statAddr:state streAddr:stre builAddr:bui gateAddr:gate
	        	 cont0:c0 cont1:c1 cont2:c2 cont3:c3
	      		 contCor0:c4 contCor1:c5 contCor2:c6 contCor3:c7   
			     locaLati:latt locaLong:lonn    
	    	     note:note colo:colo ];
			[locaDict setObject:tempObjt  forKey:"" + iden + "" ];
		}
	}
}





- (void)  loadPersonsDictionary {

	var quer;
	if( [persDict count ] == 0){
		
		quer = "SELECT ";
		quer += "t1.id,t2.organizationId,t1.LawId,t1.NameFirst,t1.NameLast,t1.email,t2.position,t1.phone1,t1.phone2, ";
		quer += "t1.HomeAddressCity,t1.HomeAddressState,t1.HomeAddressStreet,t1.Notes ";
		quer += "FROM ";
		quer += [CPString stringWithFormat:@"%@.persons t1, %@.organizationPersons t2 ",dataBase,dataBase];
		quer += "WHERE ";
		quer += "t1.id = t2.personId AND t2.active = 1 ";
		quer += "order by t1.namelast";
		
		var resuArra = [self query:quer];
		var coun = [resuArra count];
		for (var i = 0; i < coun; i++){
			var valu = [[resuArra objectAtIndex:i] valueList];
			var iden = valu[0];
			var orga = valu[1];
			var law = valu[2];
			var name = valu[3];
			var lastName = valu[4];
			var emai = valu[5];
			var roleTemp = valu[6];
			var p1 = valu[7];
			var p2 = valu[8];
			var city = valu[9];
			var state = valu[10];
			var stre = valu[11];
			var note = valu[12];
			var tempObjt = [[Person alloc] init:iden idenOrga:orga lawId:law nameFirst:name nameLast:lastName  emai:emai
			role:roleTemp phon1:p1 phon2:p2 cityAddr:city statAddr:state streAddr:stre note:note];
			[persDict setObject:tempObjt  forKey:"" + iden + "" ];
			//console.log("idenPers = " + iden );
		}
	}
}





@end





























