@STATIC;1.0;p;13;_CGGeometry.jt;9534;@STATIC;1.0;t;9515;{var the_typedef = objj_allocateTypeDef("CGPoint");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("CGSize");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("CGRect");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("CGInset");
objj_registerTypeDef(the_typedef);
}CGPointMake = function(x, y)
{
    return {x: x, y: y};
}
CGPointMakeZero = function()
{
    return {x: 0, y: 0};
}
CGPointMakeCopy = function(aPoint)
{
    return {x: aPoint.x, y: aPoint.y};
}
CGPointCreateCopy = CGPointMakeCopy;
CGPointEqualToPoint = function(lhsPoint, rhsPoint)
{
    return lhsPoint.x == rhsPoint.x && lhsPoint.y == rhsPoint.y;
}
CGStringFromPoint = function(aPoint)
{
    return "{" + aPoint.x + ", " + aPoint.y + "}";
}
CGSizeMake = function(width, height)
{
    return {width: width, height: height};
}
CGSizeMakeZero = function()
{
    return {width: 0, height: 0};
}
CGSizeMakeCopy = function(aSize)
{
    return {width: aSize.width, height: aSize.height};
}
CGSizeCreateCopy = CGSizeMakeCopy;
CGSizeEqualToSize = function(lhsSize, rhsSize)
{
    return lhsSize.width == rhsSize.width && lhsSize.height == rhsSize.height;
}
CGStringFromSize = function(aSize)
{
    return "{" + aSize.width + ", " + aSize.height + "}";
}
CGRectMake = function(x, y, width, height)
{
    return {origin: {x: x, y: y}, size: {width: width, height: height}};
}
CGRectMakeZero = function()
{
    return {origin: {x: 0, y: 0}, size: {width: 0, height: 0}};
}
CGRectMakeCopy = function(aRect)
{
    return {origin: {x: aRect.origin.x, y: aRect.origin.y}, size: {width: aRect.size.width, height: aRect.size.height}};
}
CGRectCreateCopy = CGRectMakeCopy;
CGRectEqualToRect = function(lhsRect, rhsRect)
{
    return lhsRect.origin.x == rhsRect.origin.x && lhsRect.origin.y == rhsRect.origin.y && lhsRect.size.width == rhsRect.size.width && lhsRect.size.height == rhsRect.size.height;
}
CGStringFromRect = function(aRect)
{
    return "{" + CGStringFromPoint(aRect.origin) + ", " + CGStringFromSize(aRect.size) + "}";
}
CGRectOffset = function(aRect, dX, dY)
{
    return {origin: {x: aRect.origin.x + dX, y: aRect.origin.y + dY}, size: {width: aRect.size.width, height: aRect.size.height}};
}
CGRectInset = function(aRect, dX, dY)
{
    return {origin: {x: aRect.origin.x + dX, y: aRect.origin.y + dY}, size: {width: aRect.size.width - 2 * dX, height: aRect.size.height - 2 * dY}};
}
CGRectGetHeight = function(aRect)
{
    return aRect.size.height;
}
CGRectGetMaxX = function(aRect)
{
    return aRect.origin.x + aRect.size.width;
}
CGRectGetMaxY = function(aRect)
{
    return aRect.origin.y + aRect.size.height;
}
CGRectGetMidX = function(aRect)
{
    return aRect.origin.x + aRect.size.width / 2.0;
}
CGRectGetMidY = function(aRect)
{
    return aRect.origin.y + aRect.size.height / 2.0;
}
CGRectGetMinX = function(aRect)
{
    return aRect.origin.x;
}
CGRectGetMinY = function(aRect)
{
    return aRect.origin.y;
}
CGRectGetWidth = function(aRect)
{
    return aRect.size.width;
}
CGRectIsEmpty = function(aRect)
{
    return aRect.size.width <= 0.0 || aRect.size.height <= 0.0 || aRect.origin.x === Infinity || aRect.origin.y === Infinity;
}
CGRectIsNull = function(aRect)
{
    return aRect.origin.x === Infinity || aRect.origin.y === Infinity;
}
CGRectContainsPoint = function(aRect, aPoint)
{
    return aPoint.x >= aRect.origin.x && aPoint.y >= aRect.origin.y && aPoint.x < CGRectGetMaxX(aRect) && aPoint.y < CGRectGetMaxY(aRect);
}
CGInsetMake = function(top, right, bottom, left)
{
    return {top: top, right: right, bottom: bottom, left: left};
}
CGInsetMakeZero = function()
{
    return {top: 0, right: 0, bottom: 0, left: 0};
}
CGInsetMakeCopy = function(anInset)
{
    return {top: anInset.top, right: anInset.right, bottom: anInset.bottom, left: anInset.left};
}
CGInsetMakeInvertedCopy = function(anInset)
{
    return {top: -anInset.top, right: -anInset.right, bottom: -anInset.bottom, left: -anInset.left};
}
CGInsetIsEmpty = function(anInset)
{
    return anInset.top === 0 && anInset.right === 0 && anInset.bottom === 0 && anInset.left === 0;
}
CGInsetEqualToInset = function(lhsInset, rhsInset)
{
    return lhsInset.top === rhsInset.top && lhsInset.right === rhsInset.right && lhsInset.bottom === rhsInset.bottom && lhsInset.left === rhsInset.left;
}
CGMinXEdge = 0;
CGMinYEdge = 1;
CGMaxXEdge = 2;
CGMaxYEdge = 3;
CGRectNull = CGRectMake(Infinity, Infinity, 0.0, 0.0);
CGRectDivide = function(inRect, slice, rem, amount, edge)
{
    slice.origin = CGPointMakeCopy(inRect.origin);
    slice.size = CGSizeMakeCopy(inRect.size);
    rem.origin = CGPointMakeCopy(inRect.origin);
    rem.size = CGSizeMakeCopy(inRect.size);
    switch(edge) {
    case CGMinXEdge:
        slice.size.width = amount;
        rem.origin.x += amount;
        rem.size.width -= amount;
        break;
    case CGMaxXEdge:
        slice.origin.x = CGRectGetMaxX(slice) - amount;
        slice.size.width = amount;
        rem.size.width -= amount;
        break;
    case CGMinYEdge:
        slice.size.height = amount;
        rem.origin.y += amount;
        rem.size.height -= amount;
        break;
    case CGMaxYEdge:
        slice.origin.y = CGRectGetMaxY(slice) - amount;
        slice.size.height = amount;
        rem.size.height -= amount;
    }
}
CGRectContainsRect = function(lhsRect, rhsRect)
{
    var union = CGRectUnion(lhsRect, rhsRect);
    return CGRectEqualToRect(union, lhsRect);
}
CGRectIntersectsRect = function(lhsRect, rhsRect)
{
    var intersection = CGRectIntersection(lhsRect, rhsRect);
    return !CGRectIsEmpty(intersection);
}
CGRectIntegral = function(aRect)
{
    aRect = CGRectStandardize(aRect);
    var x = FLOOR(CGRectGetMinX(aRect)),
        y = FLOOR(CGRectGetMinY(aRect));
    aRect.size.width = CEIL(CGRectGetMaxX(aRect)) - x;
    aRect.size.height = CEIL(CGRectGetMaxY(aRect)) - y;
    aRect.origin.x = x;
    aRect.origin.y = y;
    return aRect;
}
CGRectIntersection = function(lhsRect, rhsRect)
{
    var intersection = CGRectMake(MAX(CGRectGetMinX(lhsRect), CGRectGetMinX(rhsRect)), MAX(CGRectGetMinY(lhsRect), CGRectGetMinY(rhsRect)), 0, 0);
    intersection.size.width = MIN(CGRectGetMaxX(lhsRect), CGRectGetMaxX(rhsRect)) - CGRectGetMinX(intersection);
    intersection.size.height = MIN(CGRectGetMaxY(lhsRect), CGRectGetMaxY(rhsRect)) - CGRectGetMinY(intersection);
    return CGRectIsEmpty(intersection) ? CGRectMakeZero() : intersection;
}
CGRectStandardize = function(aRect)
{
    var width = CGRectGetWidth(aRect),
        height = CGRectGetHeight(aRect),
        standardized = CGRectMakeCopy(aRect);
    if (width < 0.0)
    {
        standardized.origin.x += width;
        standardized.size.width = -width;
    }
    if (height < 0.0)
    {
        standardized.origin.y += height;
        standardized.size.height = -height;
    }
    return standardized;
}
CGRectUnion = function(lhsRect, rhsRect)
{
    var lhsRectIsNull = !lhsRect || lhsRect === CGRectNull,
        rhsRectIsNull = !rhsRect || rhsRect === CGRectNull;
    if (lhsRectIsNull)
        return rhsRectIsNull ? CGRectNull : rhsRect;
    if (rhsRectIsNull)
        return lhsRectIsNull ? CGRectNull : lhsRect;
    var minX = MIN(CGRectGetMinX(lhsRect), CGRectGetMinX(rhsRect)),
        minY = MIN(CGRectGetMinY(lhsRect), CGRectGetMinY(rhsRect)),
        maxX = MAX(CGRectGetMaxX(lhsRect), CGRectGetMaxX(rhsRect)),
        maxY = MAX(CGRectGetMaxY(lhsRect), CGRectGetMaxY(rhsRect));
    return CGRectMake(minX, minY, maxX - minX, maxY - minY);
}
CGRectInsetByInset = function(aRect, anInset)
{
    return CGRectMake(aRect.origin.x + anInset.left, aRect.origin.y + anInset.top, aRect.size.width - anInset.left - anInset.right, aRect.size.height - anInset.top - anInset.bottom);
}
CGPointFromString = function(aString)
{
    var comma = aString.indexOf(',');
    return {x: parseFloat(aString.substr(1, comma - 1)), y: parseFloat(aString.substring(comma + 1, aString.length))};
}
CGSizeFromString = function(aString)
{
    var comma = aString.indexOf(',');
    return {width: parseFloat(aString.substr(1, comma - 1)), height: parseFloat(aString.substring(comma + 1, aString.length))};
}
CGRectFromString = function(aString)
{
    var comma = aString.indexOf(',', aString.indexOf(',') + 1);
    return {origin: CGPointFromString(aString.substr(1, comma - 1)), size: CGSizeFromString(aString.substring(comma + 2, aString.length - 1))};
}
CGPointFromEvent = function(anEvent)
{
    return CGPointMake(anEvent.clientX, anEvent.clientY);
}
CGInsetUnion = function(lhsInset, rhsInset)
{
    return CGInsetMake(lhsInset.top + rhsInset.top, lhsInset.right + rhsInset.right, lhsInset.bottom + rhsInset.bottom, lhsInset.left + rhsInset.left);
}
CGInsetDifference = function(lhsInset, rhsInset)
{
    return CGInsetMake(lhsInset.top - rhsInset.top, lhsInset.right - rhsInset.right, lhsInset.bottom - rhsInset.bottom, lhsInset.left - rhsInset.left);
}
CGInsetFromString = function(aString)
{
    var numbers = (aString.substr(1, aString.length - 2)).split(',');
    return CGInsetMake(parseFloat(numbers[0]), parseFloat(numbers[1]), parseFloat(numbers[2]), parseFloat(numbers[3]));
}
CGInsetFromCPString = CGInsetFromString;
CPStringFromCGInset = function(anInset)
{
    return "{" + anInset.top + ", " + anInset.left + ", " + anInset.bottom + ", " + anInset.right + "}";
}
CGAlignStroke = function(coord, strokeWidth)
{
    return FLOOR(coord) === coord ? coord + strokeWidth / 2 : coord;
}
CGAlignCoordinate = function(coord)
{
    return FLOOR(coord);
}
p;27;_CPCollectionKVCOperators.jt;12239;@STATIC;1.0;i;10;CPObject.jt;12204;objj_executeFile("CPObject.j", YES);var _CPCollectionKVCOperatorSimpleRE = /^@(avg|count|m(ax|in)|sum|unionOfObjects|distinctUnionOfObjects|unionOfArrays|distinctUnionOfArrays|distinctUnionOfSets)(\.|$)/;
{var the_class = objj_allocateClassPair(CPObject, "_CPCollectionKVCOperator"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(meta_class, [new objj_method(sel_getUid("isSimpleCollectionOperator:"), function(self, _cmd, operator)
{
    return _CPCollectionKVCOperatorSimpleRE.test(operator);
}
,["BOOL","CPString"]), new objj_method(sel_getUid("performOperation:withCollection:propertyPath:"), function(self, _cmd, operator, aCollection, propertyPath)
{
    var selector = CPSelectorFromString(operator + "ForCollection:propertyPath:");
    if (!(self.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(self, "respondsToSelector:", selector))
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@" + operator));
    return (self.isa.method_msgSend["performSelector:withObject:withObject:"] || _objj_forward)(self, "performSelector:withObject:withObject:", selector, aCollection, propertyPath);
}
,["id","CPString","id","CPString"]), new objj_method(sel_getUid("avgForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    if (!propertyPath)
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@avg"));
    var objects = (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(aCollection, "valueForKeyPath:", propertyPath)),
        average = 0.0,
        enumerator = (objects == null ? null : (objects.isa.method_msgSend["objectEnumerator"] || _objj_forward)(objects, "objectEnumerator")),
        object;
    while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
        average += (object == null ? null : (object.isa.method_msgSend["doubleValue"] || _objj_forward)(object, "doubleValue"));
    return average / (objects == null ? null : (objects.isa.method_msgSend["count"] || _objj_forward)(objects, "count"));
}
,["double","id","CPString"]), new objj_method(sel_getUid("minForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    if (!propertyPath)
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@min"));
    var objects = (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(aCollection, "valueForKeyPath:", propertyPath));
    if ((objects == null ? null : (objects.isa.method_msgSend["count"] || _objj_forward)(objects, "count")) === 0)
        return nil;
    var enumerator = (objects == null ? null : (objects.isa.method_msgSend["objectEnumerator"] || _objj_forward)(objects, "objectEnumerator")),
        min = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject")),
        object;
    while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
    {
        if ((min == null ? null : (min.isa.method_msgSend["compare:"] || _objj_forward)(min, "compare:", object)) > 0)
            min = object;
    }
    return min;
}
,["double","id","CPString"]), new objj_method(sel_getUid("maxForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    if (!propertyPath)
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@max"));
    var objects = (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(aCollection, "valueForKeyPath:", propertyPath));
    if ((objects == null ? null : (objects.isa.method_msgSend["count"] || _objj_forward)(objects, "count")) === 0)
        return nil;
    var enumerator = (objects == null ? null : (objects.isa.method_msgSend["objectEnumerator"] || _objj_forward)(objects, "objectEnumerator")),
        max = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject")),
        object;
    while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
    {
        if ((max == null ? null : (max.isa.method_msgSend["compare:"] || _objj_forward)(max, "compare:", object)) < 0)
            max = object;
    }
    return max;
}
,["double","id","CPString"]), new objj_method(sel_getUid("sumForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    if (!propertyPath)
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@sum"));
    var objects = (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(aCollection, "valueForKeyPath:", propertyPath)),
        sum = 0.0,
        enumerator = (objects == null ? null : (objects.isa.method_msgSend["objectEnumerator"] || _objj_forward)(objects, "objectEnumerator")),
        object;
    while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
        sum += (object == null ? null : (object.isa.method_msgSend["doubleValue"] || _objj_forward)(object, "doubleValue"));
    return sum;
}
,["double","id","CPString"]), new objj_method(sel_getUid("countForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    return (aCollection == null ? null : (aCollection.isa.method_msgSend["count"] || _objj_forward)(aCollection, "count"));
}
,["int","id","CPString"]), new objj_method(sel_getUid("unionOfObjectsForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    if (!propertyPath)
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@unionOfObjects"));
    var objects = (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(aCollection, "valueForKeyPath:", propertyPath));
    if ((objects == null ? null : (objects.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(objects, "isKindOfClass:", (CPSet == null ? null : (CPSet.isa.method_msgSend["class"] || _objj_forward)(CPSet, "class")))))
        return (objects == null ? null : (objects.isa.method_msgSend["allObjects"] || _objj_forward)(objects, "allObjects"));
    return objects;
}
,["CPArray","id","CPString"]), new objj_method(sel_getUid("distinctUnionOfObjectsForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    if (!propertyPath)
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@distinctUnionOfObjects"));
    var objects = (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(aCollection, "valueForKeyPath:", propertyPath)),
        distinctObjects = (CPMutableArray == null ? null : (CPMutableArray.isa.method_msgSend["new"] || _objj_forward)(CPMutableArray, "new")),
        enumerator = (objects == null ? null : (objects.isa.method_msgSend["objectEnumerator"] || _objj_forward)(objects, "objectEnumerator")),
        object;
    while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
    {
        if ((distinctObjects == null ? null : (distinctObjects.isa.method_msgSend["indexOfObject:"] || _objj_forward)(distinctObjects, "indexOfObject:", object)) == CPNotFound)
            (distinctObjects == null ? null : (distinctObjects.isa.method_msgSend["addObject:"] || _objj_forward)(distinctObjects, "addObject:", object));
    }
    return distinctObjects;
}
,["CPArray","id","CPString"]), new objj_method(sel_getUid("unionOfArraysForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    if (!propertyPath)
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@unionOfArrays"));
    var objects = [],
        number = (aCollection == null ? null : (aCollection.isa.method_msgSend["count"] || _objj_forward)(aCollection, "count"));
    for (var i = 0; i < number; i++)
        (objects == null ? null : (objects.isa.method_msgSend["addObjectsFromArray:"] || _objj_forward)(objects, "addObjectsFromArray:", ((___r1 = aCollection[i]), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(___r1, "valueForKeyPath:", propertyPath))));
    return objects;
    var ___r1;
}
,["CPArray","id","CPString"]), new objj_method(sel_getUid("distinctUnionOfArraysForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    if (!propertyPath)
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@distinctUnionOfArrays"));
    var objects = [],
        number = (aCollection == null ? null : (aCollection.isa.method_msgSend["count"] || _objj_forward)(aCollection, "count"));
    for (var i = 0; i < number; i++)
        (objects == null ? null : (objects.isa.method_msgSend["addObjectsFromArray:"] || _objj_forward)(objects, "addObjectsFromArray:", ((___r1 = aCollection[i]), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(___r1, "valueForKeyPath:", propertyPath))));
    var distinctObjects = (CPMutableArray == null ? null : (CPMutableArray.isa.method_msgSend["new"] || _objj_forward)(CPMutableArray, "new")),
        enumerator = (objects == null ? null : (objects.isa.method_msgSend["objectEnumerator"] || _objj_forward)(objects, "objectEnumerator")),
        object;
    while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
    {
        if ((distinctObjects == null ? null : (distinctObjects.isa.method_msgSend["indexOfObject:"] || _objj_forward)(distinctObjects, "indexOfObject:", object)) == CPNotFound)
            (distinctObjects == null ? null : (distinctObjects.isa.method_msgSend["addObject:"] || _objj_forward)(distinctObjects, "addObject:", object));
    }
    return distinctObjects;
    var ___r1;
}
,["CPArray","id","CPString"]), new objj_method(sel_getUid("distinctUnionOfSetsForCollection:propertyPath:"), function(self, _cmd, aCollection, propertyPath)
{
    if (!propertyPath)
        return (aCollection == null ? null : (aCollection.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(aCollection, "valueForUndefinedKey:", "@distinctUnionOfSets"));
    var objects = (CPMutableSet == null ? null : (CPMutableSet.isa.method_msgSend["new"] || _objj_forward)(CPMutableSet, "new")),
        number = (aCollection == null ? null : (aCollection.isa.method_msgSend["count"] || _objj_forward)(aCollection, "count")),
        sets = (aCollection == null ? null : (aCollection.isa.method_msgSend["allObjects"] || _objj_forward)(aCollection, "allObjects"));
    for (var i = 0; i < number; i++)
        (objects == null ? null : (objects.isa.method_msgSend["addObjectsFromArray:"] || _objj_forward)(objects, "addObjectsFromArray:", ((___r1 = ((___r2 = sets[i]), ___r2 == null ? null : (___r2.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(___r2, "valueForKeyPath:", propertyPath))), ___r1 == null ? null : (___r1.isa.method_msgSend["allObjects"] || _objj_forward)(___r1, "allObjects"))));
    return objects;
    var ___r1, ___r2;
}
,["CPArray","id","CPString"])]);
}p;20;_CPTypeDefinitions.jt;759;@STATIC;1.0;t;741;{var the_typedef = objj_allocateTypeDef("Class");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("CPInteger");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("CPUInteger");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("DOMElement");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("JSObject");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("CPMethodSignature");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("CPPropertyListFormat");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("CPTimeInterval");
objj_registerTypeDef(the_typedef);
}p;13;CPArray+KVO.jt;30133;@STATIC;1.0;i;9;CPArray.ji;8;CPNull.ji;27;_CPCollectionKVCOperators.jt;30056;objj_executeFile("CPArray.j", YES);objj_executeFile("CPNull.j", YES);objj_executeFile("_CPCollectionKVCOperators.j", YES);{
var the_class = objj_getClass("CPObject")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPObject\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("mutableArrayValueForKey:"), function(self, _cmd, aKey)
{
    return ((___r1 = (_CPKVCArray == null ? null : (_CPKVCArray.isa.method_msgSend["alloc"] || _objj_forward)(_CPKVCArray, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithKey:forProxyObject:"] || _objj_forward)(___r1, "initWithKey:forProxyObject:", aKey, self));
    var ___r1;
}
,["id","id"]), new objj_method(sel_getUid("mutableArrayValueForKeyPath:"), function(self, _cmd, aKeyPath)
{
    var dotIndex = aKeyPath.indexOf(".");
    if (dotIndex < 0)
        return (self.isa.method_msgSend["mutableArrayValueForKey:"] || _objj_forward)(self, "mutableArrayValueForKey:", aKeyPath);
    var firstPart = aKeyPath.substring(0, dotIndex),
        lastPart = aKeyPath.substring(dotIndex + 1);
    return ((___r1 = (self.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(self, "valueForKeyPath:", firstPart)), ___r1 == null ? null : (___r1.isa.method_msgSend["mutableArrayValueForKeyPath:"] || _objj_forward)(___r1, "mutableArrayValueForKeyPath:", lastPart));
    var ___r1;
}
,["id","id"])]);
}{var the_class = objj_allocateClassPair(CPMutableArray, "_CPKVCArray"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_proxyObject", "id"), new objj_ivar("_key", "id"), new objj_ivar("_insertSEL", "SEL"), new objj_ivar("_insert", "Function"), new objj_ivar("_removeSEL", "SEL"), new objj_ivar("_remove", "Function"), new objj_ivar("_replaceSEL", "SEL"), new objj_ivar("_replace", "Function"), new objj_ivar("_insertManySEL", "SEL"), new objj_ivar("_insertMany", "Function"), new objj_ivar("_removeManySEL", "SEL"), new objj_ivar("_removeMany", "Function"), new objj_ivar("_replaceManySEL", "SEL"), new objj_ivar("_replaceMany", "Function"), new objj_ivar("_objectAtIndexSEL", "SEL"), new objj_ivar("_objectAtIndex", "Function"), new objj_ivar("_objectsAtIndexesSEL", "SEL"), new objj_ivar("_objectsAtIndexes", "Function"), new objj_ivar("_countSEL", "SEL"), new objj_ivar("_count", "Function"), new objj_ivar("_accessSEL", "SEL"), new objj_ivar("_access", "Function"), new objj_ivar("_setSEL", "SEL"), new objj_ivar("_set", "Function")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithKey:forProxyObject:"), function(self, _cmd, aKey, anObject)
{
    self = (objj_getClass("_CPKVCArray").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    self._key = aKey;
    self._proxyObject = anObject;
    var capitalizedKey = (self._key.charAt(0)).toUpperCase() + self._key.substring(1);
    self._insertSEL = sel_getName("insertObject:in" + capitalizedKey + "AtIndex:");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._insertSEL)))
        self._insert = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._insertSEL));
    self._removeSEL = sel_getName("removeObjectFrom" + capitalizedKey + "AtIndex:");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._removeSEL)))
        self._remove = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._removeSEL));
    self._replaceSEL = sel_getName("replaceObjectIn" + capitalizedKey + "AtIndex:withObject:");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._replaceSEL)))
        self._replace = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._replaceSEL));
    self._insertManySEL = sel_getName("insert" + capitalizedKey + ":atIndexes:");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._insertManySEL)))
        self._insertMany = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._insertManySEL));
    self._removeManySEL = sel_getName("remove" + capitalizedKey + "AtIndexes:");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._removeManySEL)))
        self._removeMany = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._removeManySEL));
    self._replaceManySEL = sel_getName("replace" + capitalizedKey + "AtIndexes:with" + capitalizedKey + ":");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._replaceManySEL)))
        self._replaceMany = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._replaceManySEL));
    self._objectAtIndexSEL = sel_getName("objectIn" + capitalizedKey + "AtIndex:");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._objectAtIndexSEL)))
        self._objectAtIndex = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._objectAtIndexSEL));
    self._objectsAtIndexesSEL = sel_getName(self._key + "AtIndexes:");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._objectsAtIndexesSEL)))
        self._objectsAtIndexes = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._objectsAtIndexesSEL));
    self._countSEL = sel_getName("countOf" + capitalizedKey);
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._countSEL)))
        self._count = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._countSEL));
    self._accessSEL = sel_getName(self._key);
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._accessSEL)))
        self._access = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._accessSEL));
    self._setSEL = sel_getName("set" + capitalizedKey + ":");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._setSEL)))
        self._set = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._setSEL));
    return self;
    var ___r1;
}
,["id","id","id"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    var i = 0,
        theCopy = [],
        count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
    for (; i < count; i++)
        (theCopy == null ? null : (theCopy.isa.method_msgSend["addObject:"] || _objj_forward)(theCopy, "addObject:", (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", i)));
    return theCopy;
}
,["id"]), new objj_method(sel_getUid("_representedObject"), function(self, _cmd)
{
    if (self._access)
        return self._access(self._proxyObject, self._accessSEL);
    return ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r1, "valueForKey:", self._key));
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("_setRepresentedObject:"), function(self, _cmd, anObject)
{
    if (self._set)
        return self._set(self._proxyObject, self._setSEL, anObject);
    ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(___r1, "setValue:forKey:", anObject, self._key));
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("count"), function(self, _cmd)
{
    if (self._count)
        return self._count(self._proxyObject, self._countSEL);
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
    var ___r1;
}
,["CPUInteger"]), new objj_method(sel_getUid("indexOfObject:inRange:"), function(self, _cmd, anObject, aRange)
{
    var index = aRange.location,
        count = aRange.length,
        shouldIsEqual = !!anObject.isa;
    for (; index < count; ++index)
    {
        var object = (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index);
        if (anObject === object || shouldIsEqual && !!object.isa && (anObject == null ? null : (anObject.isa.method_msgSend["isEqual:"] || _objj_forward)(anObject, "isEqual:", object)))
            return index;
    }
    return CPNotFound;
}
,["CPUInteger","id","CPRange"]), new objj_method(sel_getUid("indexOfObject:"), function(self, _cmd, anObject)
{
    return (self.isa.method_msgSend["indexOfObject:inRange:"] || _objj_forward)(self, "indexOfObject:inRange:", anObject, CPMakeRange(0, (self.isa.method_msgSend["count"] || _objj_forward)(self, "count")));
}
,["CPUInteger","id"]), new objj_method(sel_getUid("indexOfObjectIdenticalTo:inRange:"), function(self, _cmd, anObject, aRange)
{
    var index = aRange.location,
        count = aRange.length;
    for (; index < count; ++index)
        if (anObject === (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index))
            return index;
    return CPNotFound;
}
,["CPUInteger","id","CPRange"]), new objj_method(sel_getUid("indexOfObjectIdenticalTo:"), function(self, _cmd, anObject)
{
    return (self.isa.method_msgSend["indexOfObjectIdenticalTo:inRange:"] || _objj_forward)(self, "indexOfObjectIdenticalTo:inRange:", anObject, CPMakeRange(0, (self.isa.method_msgSend["count"] || _objj_forward)(self, "count")));
}
,["CPUInteger","id"]), new objj_method(sel_getUid("objectAtIndex:"), function(self, _cmd, anIndex)
{
    return ((___r1 = (self.isa.method_msgSend["objectsAtIndexes:"] || _objj_forward)(self, "objectsAtIndexes:", (CPIndexSet == null ? null : (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex)))), ___r1 == null ? null : (___r1.isa.method_msgSend["firstObject"] || _objj_forward)(___r1, "firstObject"));
    var ___r1;
}
,["id","CPUInteger"]), new objj_method(sel_getUid("objectsAtIndexes:"), function(self, _cmd, theIndexes)
{
    if (self._objectsAtIndexes)
        return self._objectsAtIndexes(self._proxyObject, self._objectsAtIndexesSEL, theIndexes);
    if (self._objectAtIndex)
    {
        var index = CPNotFound,
            objects = [];
        while ((index = (theIndexes == null ? null : (theIndexes.isa.method_msgSend["indexGreaterThanIndex:"] || _objj_forward)(theIndexes, "indexGreaterThanIndex:", index))) !== CPNotFound)
            objects.push(self._objectAtIndex(self._proxyObject, self._objectAtIndexSEL, index));
        return objects;
    }
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectsAtIndexes:"] || _objj_forward)(___r1, "objectsAtIndexes:", theIndexes));
    var ___r1;
}
,["CPArray","CPIndexSet"]), new objj_method(sel_getUid("addObject:"), function(self, _cmd, anObject)
{
    (self.isa.method_msgSend["insertObject:atIndex:"] || _objj_forward)(self, "insertObject:atIndex:", anObject, (self.isa.method_msgSend["count"] || _objj_forward)(self, "count"));
}
,["void","id"]), new objj_method(sel_getUid("addObjectsFromArray:"), function(self, _cmd, anArray)
{
    var index = 0,
        count = (anArray == null ? null : (anArray.isa.method_msgSend["count"] || _objj_forward)(anArray, "count"));
    (self.isa.method_msgSend["insertObjects:atIndexes:"] || _objj_forward)(self, "insertObjects:atIndexes:", anArray, (CPIndexSet == null ? null : (CPIndexSet.isa.method_msgSend["indexSetWithIndexesInRange:"] || _objj_forward)(CPIndexSet, "indexSetWithIndexesInRange:", CPMakeRange((self.isa.method_msgSend["count"] || _objj_forward)(self, "count"), count))));
}
,["void","CPArray"]), new objj_method(sel_getUid("insertObject:atIndex:"), function(self, _cmd, anObject, anIndex)
{
    (self.isa.method_msgSend["insertObjects:atIndexes:"] || _objj_forward)(self, "insertObjects:atIndexes:", [anObject], (CPIndexSet == null ? null : (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex)));
}
,["void","id","CPUInteger"]), new objj_method(sel_getUid("insertObjects:atIndexes:"), function(self, _cmd, theObjects, theIndexes)
{
    if (self._insertMany)
        self._insertMany(self._proxyObject, self._insertManySEL, theObjects, theIndexes);
    else if (self._insert)
    {
        var indexesArray = [];
        (theIndexes == null ? null : (theIndexes.isa.method_msgSend["getIndexes:maxCount:inIndexRange:"] || _objj_forward)(theIndexes, "getIndexes:maxCount:inIndexRange:", indexesArray, -1, nil));
        for (var index = 0; index < (indexesArray == null ? null : (indexesArray.isa.method_msgSend["count"] || _objj_forward)(indexesArray, "count")); index++)
        {
            var objectIndex = (indexesArray == null ? null : (indexesArray.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(indexesArray, "objectAtIndex:", index)),
                object = (theObjects == null ? null : (theObjects.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(theObjects, "objectAtIndex:", index));
            self._insert(self._proxyObject, self._insertSEL, object, objectIndex);
        }
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["insertObjects:atIndexes:"] || _objj_forward)(target, "insertObjects:atIndexes:", theObjects, theIndexes));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","CPArray","CPIndexSet"]), new objj_method(sel_getUid("removeObject:"), function(self, _cmd, anObject)
{
    (self.isa.method_msgSend["removeObject:inRange:"] || _objj_forward)(self, "removeObject:inRange:", anObject, CPMakeRange(0, (self.isa.method_msgSend["count"] || _objj_forward)(self, "count")));
}
,["void","id"]), new objj_method(sel_getUid("removeObjectsInArray:"), function(self, _cmd, theObjects)
{
    if (self._removeMany)
    {
        var indexes = (CPIndexSet == null ? null : (CPIndexSet.isa.method_msgSend["indexSet"] || _objj_forward)(CPIndexSet, "indexSet")),
            index = (theObjects == null ? null : (theObjects.isa.method_msgSend["count"] || _objj_forward)(theObjects, "count")),
            position = 0,
            count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
        while (index--)
        {
            while ((position = (self.isa.method_msgSend["indexOfObject:inRange:"] || _objj_forward)(self, "indexOfObject:inRange:", (theObjects == null ? null : (theObjects.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(theObjects, "objectAtIndex:", index)), CPMakeRange(position + 1, count))) !== CPNotFound)
                (indexes == null ? null : (indexes.isa.method_msgSend["addIndex:"] || _objj_forward)(indexes, "addIndex:", position));
        }
        self._removeMany(self._proxyObject, self._removeManySEL, indexes);
    }
    else if (self._remove)
    {
        var index = (theObjects == null ? null : (theObjects.isa.method_msgSend["count"] || _objj_forward)(theObjects, "count")),
            position;
        while (index--)
        {
            while ((position = (self.isa.method_msgSend["indexOfObject:"] || _objj_forward)(self, "indexOfObject:", (theObjects == null ? null : (theObjects.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(theObjects, "objectAtIndex:", index)))) !== CPNotFound)
                self._remove(self._proxyObject, self._removeSEL, position);
        }
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["removeObjectsInArray:"] || _objj_forward)(target, "removeObjectsInArray:", theObjects));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("removeObject:inRange:"), function(self, _cmd, theObject, theRange)
{
    if (self._remove)
        self._remove(self._proxyObject, self._removeSEL, (self.isa.method_msgSend["indexOfObject:inRange:"] || _objj_forward)(self, "indexOfObject:inRange:", theObject, theRange));
    else if (self._removeMany)
    {
        var index = (self.isa.method_msgSend["indexOfObject:inRange:"] || _objj_forward)(self, "indexOfObject:inRange:", theObject, theRange);
        self._removeMany(self._proxyObject, self._removeManySEL, (CPIndexSet == null ? null : (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", index)));
    }
    else
    {
        var index;
        while ((index = (self.isa.method_msgSend["indexOfObject:inRange:"] || _objj_forward)(self, "indexOfObject:inRange:", theObject, theRange)) !== CPNotFound)
        {
            (self.isa.method_msgSend["removeObjectAtIndex:"] || _objj_forward)(self, "removeObjectAtIndex:", index);
            theRange = CPIntersectionRange(CPMakeRange(index, self.length - index), theRange);
        }
    }
}
,["void","id","CPRange"]), new objj_method(sel_getUid("removeLastObject"), function(self, _cmd)
{
    (self.isa.method_msgSend["removeObjectsAtIndexes:"] || _objj_forward)(self, "removeObjectsAtIndexes:", (CPIndexSet == null ? null : (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", (self.isa.method_msgSend["count"] || _objj_forward)(self, "count") - 1)));
}
,["void"]), new objj_method(sel_getUid("removeObjectAtIndex:"), function(self, _cmd, anIndex)
{
    (self.isa.method_msgSend["removeObjectsAtIndexes:"] || _objj_forward)(self, "removeObjectsAtIndexes:", (CPIndexSet == null ? null : (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex)));
}
,["void","CPUInteger"]), new objj_method(sel_getUid("removeObjectsAtIndexes:"), function(self, _cmd, theIndexes)
{
    if (self._removeMany)
        self._removeMany(self._proxyObject, self._removeManySEL, theIndexes);
    else if (self._remove)
    {
        var index = (theIndexes == null ? null : (theIndexes.isa.method_msgSend["lastIndex"] || _objj_forward)(theIndexes, "lastIndex"));
        while (index !== CPNotFound)
        {
            self._remove(self._proxyObject, self._removeSEL, index);
            index = (theIndexes == null ? null : (theIndexes.isa.method_msgSend["indexLessThanIndex:"] || _objj_forward)(theIndexes, "indexLessThanIndex:", index));
        }
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["removeObjectsAtIndexes:"] || _objj_forward)(target, "removeObjectsAtIndexes:", theIndexes));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","CPIndexSet"]), new objj_method(sel_getUid("replaceObjectAtIndex:withObject:"), function(self, _cmd, anIndex, anObject)
{
    (self.isa.method_msgSend["replaceObjectsAtIndexes:withObjects:"] || _objj_forward)(self, "replaceObjectsAtIndexes:withObjects:", (CPIndexSet == null ? null : (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex)), [anObject]);
}
,["void","CPUInteger","id"]), new objj_method(sel_getUid("replaceObjectsAtIndexes:withObjects:"), function(self, _cmd, theIndexes, theObjects)
{
    if (self._replaceMany)
        return self._replaceMany(self._proxyObject, self._replaceManySEL, theIndexes, theObjects);
    else if (self._replace)
    {
        var i = 0,
            index = (theIndexes == null ? null : (theIndexes.isa.method_msgSend["firstIndex"] || _objj_forward)(theIndexes, "firstIndex"));
        while (index !== CPNotFound)
        {
            self._replace(self._proxyObject, self._replaceSEL, index, (theObjects == null ? null : (theObjects.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(theObjects, "objectAtIndex:", i++)));
            index = (theIndexes == null ? null : (theIndexes.isa.method_msgSend["indexGreaterThanIndex:"] || _objj_forward)(theIndexes, "indexGreaterThanIndex:", index));
        }
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["replaceObjectsAtIndexes:withObjects:"] || _objj_forward)(target, "replaceObjectsAtIndexes:withObjects:", theIndexes, theObjects));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","CPIndexSet","CPArray"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    var array = [];
    array.isa = self;
    var ivars = class_copyIvarList(self),
        count = ivars.length;
    while (count--)
        array[ivar_getName(ivars[count])] = nil;
    return array;
}
,["id"])]);
}{
var the_class = objj_getClass("CPArray")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPArray\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("valueForKey:"), function(self, _cmd, aKey)
{
    if (aKey.charAt(0) === "@")
    {
        if (aKey.indexOf(".") !== -1)
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "called valueForKey: on an array with a complex key (" + aKey + "). use valueForKeyPath:");
        if (aKey === "@count")
            return self.length;
        return (self.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(self, "valueForUndefinedKey:", aKey);
    }
    else
    {
        var newArray = [],
            enumerator = (self.isa.method_msgSend["objectEnumerator"] || _objj_forward)(self, "objectEnumerator"),
            object;
        while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
        {
            var value = (object == null ? null : (object.isa.method_msgSend["valueForKey:"] || _objj_forward)(object, "valueForKey:", aKey));
            if (value === nil || value === undefined)
                value = (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null");
            newArray.push(value);
        }
        return newArray;
    }
}
,["id","CPString"]), new objj_method(sel_getUid("valueForKeyPath:"), function(self, _cmd, aKeyPath)
{
    if (!aKeyPath)
        (self.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(self, "valueForUndefinedKey:", "<empty path>");
    if (aKeyPath.charAt(0) === "@")
    {
        var dotIndex = aKeyPath.indexOf("."),
            operator,
            parameter;
        if (dotIndex !== -1)
        {
            operator = aKeyPath.substring(1, dotIndex);
            parameter = aKeyPath.substring(dotIndex + 1);
        }
        else
            operator = aKeyPath.substring(1);
        return (_CPCollectionKVCOperator.isa.method_msgSend["performOperation:withCollection:propertyPath:"] || _objj_forward)(_CPCollectionKVCOperator, "performOperation:withCollection:propertyPath:", operator, self, parameter);
    }
    else
    {
        var newArray = [],
            enumerator = (self.isa.method_msgSend["objectEnumerator"] || _objj_forward)(self, "objectEnumerator"),
            object;
        while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
        {
            var value = (object == null ? null : (object.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(object, "valueForKeyPath:", aKeyPath));
            if (value === nil || value === undefined)
                value = (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null");
            newArray.push(value);
        }
        return newArray;
    }
}
,["id","CPString"]), new objj_method(sel_getUid("setValue:forKey:"), function(self, _cmd, aValue, aKey)
{
    var enumerator = (self.isa.method_msgSend["objectEnumerator"] || _objj_forward)(self, "objectEnumerator"),
        object;
    while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
        (object == null ? null : (object.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(object, "setValue:forKey:", aValue, aKey));
}
,["void","id","CPString"]), new objj_method(sel_getUid("setValue:forKeyPath:"), function(self, _cmd, aValue, aKeyPath)
{
    var enumerator = (self.isa.method_msgSend["objectEnumerator"] || _objj_forward)(self, "objectEnumerator"),
        object;
    while ((object = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject"))) !== nil)
        (object == null ? null : (object.isa.method_msgSend["setValue:forKeyPath:"] || _objj_forward)(object, "setValue:forKeyPath:", aValue, aKeyPath));
}
,["void","id","CPString"])]);
}{
var the_class = objj_getClass("CPArray")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPArray\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("addObserver:forKeyPath:options:context:"), function(self, _cmd, anObserver, aKeyPath, anOptions, aContext)
{
    if (aKeyPath !== "@count")
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "[CPArray " + CPStringFromSelector(_cmd) + "] is not supported. Key path: " + aKeyPath);
}
,["void","id","CPString","CPKeyValueObservingOptions","id"]), new objj_method(sel_getUid("removeObserver:forKeyPath:"), function(self, _cmd, anObserver, aKeyPath)
{
    if (aKeyPath !== "@count")
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "[CPArray " + CPStringFromSelector(_cmd) + "] is not supported. Key path: " + aKeyPath);
}
,["void","id","CPString"]), new objj_method(sel_getUid("addObserver:toObjectsAtIndexes:forKeyPath:options:context:"), function(self, _cmd, anObserver, indexes, aKeyPath, options, context)
{
    var index = (indexes == null ? null : (indexes.isa.method_msgSend["firstIndex"] || _objj_forward)(indexes, "firstIndex"));
    while (index >= 0)
    {
        ((___r1 = self[index]), ___r1 == null ? null : (___r1.isa.method_msgSend["addObserver:forKeyPath:options:context:"] || _objj_forward)(___r1, "addObserver:forKeyPath:options:context:", anObserver, aKeyPath, options, context));
        index = (indexes == null ? null : (indexes.isa.method_msgSend["indexGreaterThanIndex:"] || _objj_forward)(indexes, "indexGreaterThanIndex:", index));
    }
    var ___r1;
}
,["void","id","CPIndexSet","CPString","CPKeyValueObservingOptions","id"]), new objj_method(sel_getUid("removeObserver:fromObjectsAtIndexes:forKeyPath:"), function(self, _cmd, anObserver, indexes, aKeyPath)
{
    var index = (indexes == null ? null : (indexes.isa.method_msgSend["firstIndex"] || _objj_forward)(indexes, "firstIndex"));
    while (index >= 0)
    {
        ((___r1 = self[index]), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObserver:forKeyPath:"] || _objj_forward)(___r1, "removeObserver:forKeyPath:", anObserver, aKeyPath));
        index = (indexes == null ? null : (indexes.isa.method_msgSend["indexGreaterThanIndex:"] || _objj_forward)(indexes, "indexGreaterThanIndex:", index));
    }
    var ___r1;
}
,["void","id","CPIndexSet","CPString"])]);
}p;20;CPAttributedString.jt;29415;@STATIC;1.0;i;9;CPArray.ji;14;CPDictionary.ji;13;CPException.ji;10;CPObject.ji;9;CPRange.ji;10;CPString.jt;29302;objj_executeFile("CPArray.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPRange.j", YES);objj_executeFile("CPString.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPAttributedString"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_string", "CPString"), new objj_ivar("_rangeEntries", "CPArray")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    return (self.isa.method_msgSend["initWithString:attributes:"] || _objj_forward)(self, "initWithString:attributes:", "", nil);
}
,["id"]), new objj_method(sel_getUid("initWithString:"), function(self, _cmd, aString)
{
    return (self.isa.method_msgSend["initWithString:attributes:"] || _objj_forward)(self, "initWithString:attributes:", aString, nil);
}
,["id","CPString"]), new objj_method(sel_getUid("initWithAttributedString:"), function(self, _cmd, aString)
{
    var string = (self.isa.method_msgSend["initWithString:attributes:"] || _objj_forward)(self, "initWithString:attributes:", "", nil);
    (string == null ? null : (string.isa.method_msgSend["setAttributedString:"] || _objj_forward)(string, "setAttributedString:", aString));
    return string;
}
,["id","CPAttributedString"]), new objj_method(sel_getUid("initWithString:attributes:"), function(self, _cmd, aString, attributes)
{
    self = (objj_getClass("CPAttributedString").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        if (!attributes)
            attributes = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._string = "" + aString;
        self._rangeEntries = [makeRangeEntry(CPMakeRange(0, self._string.length), attributes)];
    }
    return self;
    var ___r1;
}
,["id","CPString","CPDictionary"]), new objj_method(sel_getUid("string"), function(self, _cmd)
{
    return self._string;
}
,["CPString"]), new objj_method(sel_getUid("mutableString"), function(self, _cmd)
{
    return (self.isa.method_msgSend["string"] || _objj_forward)(self, "string");
}
,["CPString"]), new objj_method(sel_getUid("length"), function(self, _cmd)
{
    return self._string.length;
}
,["unsigned"]), new objj_method(sel_getUid("_indexOfEntryWithIndex:"), function(self, _cmd, anIndex)
{
    if (anIndex < 0 || anIndex > self._string.length || anIndex === undefined)
        return CPNotFound;
    var sortFunction = function(index, entry)
    {
        if (CPLocationInRange(index, entry.range) || !index && !CPMaxRange(entry.range))
            return CPOrderedSame;
        else if (CPMaxRange(entry.range) <= index)
            return CPOrderedDescending;
        else
            return CPOrderedAscending;
    };
    return ((___r1 = self._rangeEntries), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:inSortedRange:options:usingComparator:"] || _objj_forward)(___r1, "indexOfObject:inSortedRange:options:usingComparator:", anIndex, nil, 0, sortFunction));
    var ___r1;
}
,["unsigned","unsigned"]), new objj_method(sel_getUid("attributesAtIndex:effectiveRange:"), function(self, _cmd, anIndex, aRange)
{
    var entryIndex = (self.isa.method_msgSend["_indexOfEntryWithIndex:"] || _objj_forward)(self, "_indexOfEntryWithIndex:", anIndex);
    if (entryIndex === CPNotFound)
        return (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    var matchingRange = self._rangeEntries[entryIndex];
    if (aRange)
    {
        aRange.location = matchingRange.range.location;
        aRange.length = matchingRange.range.length;
    }
    return matchingRange.attributes;
    var ___r1;
}
,["CPDictionary","CPUInteger","CPRangePointer"]), new objj_method(sel_getUid("attributesAtIndex:longestEffectiveRange:inRange:"), function(self, _cmd, anIndex, aRange, rangeLimit)
{
    var startingEntryIndex = (self.isa.method_msgSend["_indexOfEntryWithIndex:"] || _objj_forward)(self, "_indexOfEntryWithIndex:", anIndex);
    if (startingEntryIndex === CPNotFound)
        return (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    if (!aRange)
        return self._rangeEntries[startingEntryIndex].attributes;
    if (CPRangeInRange(self._rangeEntries[startingEntryIndex].range, rangeLimit))
    {
        aRange.location = rangeLimit.location;
        aRange.length = rangeLimit.length;
        return self._rangeEntries[startingEntryIndex].attributes;
    }
    var nextRangeIndex = startingEntryIndex - 1,
        currentEntry = self._rangeEntries[startingEntryIndex],
        comparisonDict = currentEntry.attributes;
    while (nextRangeIndex >= 0)
    {
        var nextEntry = self._rangeEntries[nextRangeIndex];
        if (CPMaxRange(nextEntry.range) > rangeLimit.location && ((___r1 = nextEntry.attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToDictionary:"] || _objj_forward)(___r1, "isEqualToDictionary:", comparisonDict)))
        {
            currentEntry = nextEntry;
            nextRangeIndex--;
        }
        else
            break;
    }
    aRange.location = MAX(currentEntry.range.location, rangeLimit.location);
    currentEntry = self._rangeEntries[startingEntryIndex];
    nextRangeIndex = startingEntryIndex + 1;
    while (nextRangeIndex < self._rangeEntries.length)
    {
        var nextEntry = self._rangeEntries[nextRangeIndex];
        if (nextEntry.range.location < CPMaxRange(rangeLimit) && ((___r1 = nextEntry.attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToDictionary:"] || _objj_forward)(___r1, "isEqualToDictionary:", comparisonDict)))
        {
            currentEntry = nextEntry;
            nextRangeIndex++;
        }
        else
            break;
    }
    aRange.length = MIN(CPMaxRange(currentEntry.range), CPMaxRange(rangeLimit)) - aRange.location;
    return comparisonDict;
    var ___r1;
}
,["CPDictionary","CPUInteger","CPRangePointer","CPRange"]), new objj_method(sel_getUid("attribute:atIndex:effectiveRange:"), function(self, _cmd, attribute, index, aRange)
{
    if (!attribute)
    {
        if (aRange)
        {
            aRange.location = 0;
            aRange.length = self._string.length;
        }
        return nil;
    }
    return ((___r1 = (self.isa.method_msgSend["attributesAtIndex:effectiveRange:"] || _objj_forward)(self, "attributesAtIndex:effectiveRange:", index, aRange)), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r1, "valueForKey:", attribute));
    var ___r1;
}
,["id","CPString","CPUInteger","CPRangePointer"]), new objj_method(sel_getUid("attribute:atIndex:longestEffectiveRange:inRange:"), function(self, _cmd, attribute, anIndex, aRange, rangeLimit)
{
    var startingEntryIndex = (self.isa.method_msgSend["_indexOfEntryWithIndex:"] || _objj_forward)(self, "_indexOfEntryWithIndex:", anIndex);
    if (startingEntryIndex === CPNotFound || !attribute)
        return nil;
    if (!aRange)
        return ((___r1 = self._rangeEntries[startingEntryIndex].attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", attribute));
    if (CPRangeInRange(self._rangeEntries[startingEntryIndex].range, rangeLimit))
    {
        aRange.location = rangeLimit.location;
        aRange.length = rangeLimit.length;
        return ((___r1 = self._rangeEntries[startingEntryIndex].attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", attribute));
    }
    var nextRangeIndex = startingEntryIndex - 1,
        currentEntry = self._rangeEntries[startingEntryIndex],
        comparisonAttribute = ((___r1 = currentEntry.attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", attribute));
    while (nextRangeIndex >= 0)
    {
        var nextEntry = self._rangeEntries[nextRangeIndex];
        if (CPMaxRange(nextEntry.range) > rangeLimit.location && isEqual(comparisonAttribute, ((___r1 = nextEntry.attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", attribute))))
        {
            currentEntry = nextEntry;
            nextRangeIndex--;
        }
        else
            break;
    }
    aRange.location = MAX(currentEntry.range.location, rangeLimit.location);
    currentEntry = self._rangeEntries[startingEntryIndex];
    nextRangeIndex = startingEntryIndex + 1;
    while (nextRangeIndex < self._rangeEntries.length)
    {
        var nextEntry = self._rangeEntries[nextRangeIndex];
        if (nextEntry.range.location < CPMaxRange(rangeLimit) && isEqual(comparisonAttribute, ((___r1 = nextEntry.attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", attribute))))
        {
            currentEntry = nextEntry;
            nextRangeIndex++;
        }
        else
            break;
    }
    aRange.length = MIN(CPMaxRange(currentEntry.range), CPMaxRange(rangeLimit)) - aRange.location;
    return comparisonAttribute;
    var ___r1;
}
,["id","CPString","CPUInteger","CPRangePointer","CPRange"]), new objj_method(sel_getUid("isEqualToAttributedString:"), function(self, _cmd, aString)
{
    if (!aString)
        return NO;
    if (self._string !== (aString == null ? null : (aString.isa.method_msgSend["string"] || _objj_forward)(aString, "string")))
        return NO;
    var myRange = CPMakeRange(),
        comparisonRange = CPMakeRange(),
        myAttributes = (self.isa.method_msgSend["attributesAtIndex:effectiveRange:"] || _objj_forward)(self, "attributesAtIndex:effectiveRange:", 0, myRange),
        comparisonAttributes = (aString == null ? null : (aString.isa.method_msgSend["attributesAtIndex:effectiveRange:"] || _objj_forward)(aString, "attributesAtIndex:effectiveRange:", 0, comparisonRange)),
        length = self._string.length;
    do
    {
        if ((CPIntersectionRange(myRange, comparisonRange)).length > 0 && !(myAttributes == null ? null : (myAttributes.isa.method_msgSend["isEqualToDictionary:"] || _objj_forward)(myAttributes, "isEqualToDictionary:", comparisonAttributes)))
        {
            return NO;
        }
        else if (CPMaxRange(myRange) < CPMaxRange(comparisonRange))
            myAttributes = (self.isa.method_msgSend["attributesAtIndex:effectiveRange:"] || _objj_forward)(self, "attributesAtIndex:effectiveRange:", CPMaxRange(myRange), myRange);
        else
            comparisonAttributes = (aString == null ? null : (aString.isa.method_msgSend["attributesAtIndex:effectiveRange:"] || _objj_forward)(aString, "attributesAtIndex:effectiveRange:", CPMaxRange(comparisonRange), comparisonRange));
    }
    while (CPMaxRange(CPUnionRange(myRange, comparisonRange)) < length);
    return YES;
}
,["BOOL","CPAttributedString"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    if (anObject === self)
        return YES;
    if ((anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"))))
        return (self.isa.method_msgSend["isEqualToAttributedString:"] || _objj_forward)(self, "isEqualToAttributedString:", anObject);
    return NO;
}
,["BOOL","id"]), new objj_method(sel_getUid("attributedSubstringFromRange:"), function(self, _cmd, aRange)
{
    if (!aRange || CPMaxRange(aRange) > self._string.length || aRange.location < 0)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPRangeException, "tried to get attributedSubstring for an invalid range: " + (aRange ? CPStringFromRange(aRange) : "nil"));
    var newString = ((___r1 = (CPAttributedString.isa.method_msgSend["alloc"] || _objj_forward)(CPAttributedString, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", self._string.substring(aRange.location, CPMaxRange(aRange)))),
        entryIndex = (self.isa.method_msgSend["_indexOfEntryWithIndex:"] || _objj_forward)(self, "_indexOfEntryWithIndex:", aRange.location);
    if (entryIndex === CPNotFound)
        _CPRaiseRangeException(self, _cmd, aRange.location, self._string.length);
    var currentRangeEntry = self._rangeEntries[entryIndex],
        lastIndex = CPMaxRange(aRange);
    newString._rangeEntries = [];
    while (currentRangeEntry && CPMaxRange(currentRangeEntry.range) < lastIndex)
    {
        var newEntry = copyRangeEntry(currentRangeEntry);
        newEntry.range.location -= aRange.location;
        if (newEntry.range.location < 0)
        {
            newEntry.range.length += newEntry.range.location;
            newEntry.range.location = 0;
        }
        newString._rangeEntries.push(newEntry);
        currentRangeEntry = self._rangeEntries[++entryIndex];
    }
    if (currentRangeEntry)
    {
        var newRangeEntry = copyRangeEntry(currentRangeEntry);
        newRangeEntry.range.length = CPMaxRange(aRange) - newRangeEntry.range.location;
        newRangeEntry.range.location -= aRange.location;
        if (newRangeEntry.range.location < 0)
        {
            newRangeEntry.range.length += newRangeEntry.range.location;
            newRangeEntry.range.location = 0;
        }
        newString._rangeEntries.push(newRangeEntry);
    }
    return newString;
    var ___r1;
}
,["CPAttributedString","CPRange"]), new objj_method(sel_getUid("replaceCharactersInRange:withString:"), function(self, _cmd, aRange, aString)
{
    if (!aString)
        aString = "";
    var lastValidIndex = MAX(self._rangeEntries.length - 1, 0),
        startingIndex = (self.isa.method_msgSend["_indexOfEntryWithIndex:"] || _objj_forward)(self, "_indexOfEntryWithIndex:", aRange.location);
    if (startingIndex < 0)
        startingIndex = lastValidIndex;
    var endingIndex = (self.isa.method_msgSend["_indexOfEntryWithIndex:"] || _objj_forward)(self, "_indexOfEntryWithIndex:", CPMaxRange(aRange));
    if (endingIndex < 0)
        endingIndex = lastValidIndex;
    var additionalLength = aString.length - aRange.length,
        patchPosition = startingIndex;
    self._string = self._string.substring(0, aRange.location) + aString + self._string.substring(CPMaxRange(aRange));
    var originalLength = self._rangeEntries[patchPosition].range.length;
    if (startingIndex === endingIndex)
        self._rangeEntries[patchPosition].range.length += additionalLength;
    else
    {
        if ((CPIntersectionRange(self._rangeEntries[patchPosition].range, aRange)).length < originalLength)
        {
            startingIndex++;
        }
        if (endingIndex > startingIndex)
        {
            var originalOffset = self._rangeEntries[startingIndex].range.location,
                offsetFromSplicing = CPMaxRange(self._rangeEntries[endingIndex].range) - originalOffset;
            self._rangeEntries.splice(startingIndex, endingIndex - startingIndex);
            self._rangeEntries[startingIndex].range = CPMakeRange(originalOffset, offsetFromSplicing);
        }
        if (patchPosition !== startingIndex)
        {
            var lhsOffset = aString.length - (CPIntersectionRange(self._rangeEntries[patchPosition].range, aRange)).length;
            self._rangeEntries[patchPosition].range.length = originalLength + lhsOffset;
            var rhsOffset = aString.length - (CPIntersectionRange(self._rangeEntries[startingIndex].range, aRange)).length;
            self._rangeEntries[startingIndex].range.location += lhsOffset;
            self._rangeEntries[startingIndex].range.length += rhsOffset;
            patchPosition = startingIndex;
        }
        else
            self._rangeEntries[patchPosition].range.length += additionalLength;
    }
    for (var patchIndex = patchPosition + 1, l = self._rangeEntries.length; patchIndex < l; patchIndex++)
        self._rangeEntries[patchIndex].range.location += additionalLength;
}
,["void","CPRange","CPString"]), new objj_method(sel_getUid("deleteCharactersInRange:"), function(self, _cmd, aRange)
{
    (self.isa.method_msgSend["replaceCharactersInRange:withString:"] || _objj_forward)(self, "replaceCharactersInRange:withString:", aRange, nil);
}
,["void","CPRange"]), new objj_method(sel_getUid("setAttributes:range:"), function(self, _cmd, aDictionary, aRange)
{
    var startingEntryIndex = (self.isa.method_msgSend["_indexOfRangeEntryForIndex:splitOnMaxIndex:"] || _objj_forward)(self, "_indexOfRangeEntryForIndex:splitOnMaxIndex:", aRange.location, YES),
        endingEntryIndex = (self.isa.method_msgSend["_indexOfRangeEntryForIndex:splitOnMaxIndex:"] || _objj_forward)(self, "_indexOfRangeEntryForIndex:splitOnMaxIndex:", CPMaxRange(aRange), YES),
        current = startingEntryIndex;
    if (current < 0)
        current = MAX(self._rangeEntries.length - 1, 0);
    if (endingEntryIndex === CPNotFound)
        endingEntryIndex = self._rangeEntries.length;
    while (current < endingEntryIndex)
        self._rangeEntries[current++].attributes = (aDictionary == null ? null : (aDictionary.isa.method_msgSend["copy"] || _objj_forward)(aDictionary, "copy"));
    (self.isa.method_msgSend["_coalesceRangeEntriesFromIndex:toIndex:"] || _objj_forward)(self, "_coalesceRangeEntriesFromIndex:toIndex:", startingEntryIndex, endingEntryIndex);
}
,["void","CPDictionary","CPRange"]), new objj_method(sel_getUid("addAttributes:range:"), function(self, _cmd, aDictionary, aRange)
{
    var startingEntryIndex = (self.isa.method_msgSend["_indexOfRangeEntryForIndex:splitOnMaxIndex:"] || _objj_forward)(self, "_indexOfRangeEntryForIndex:splitOnMaxIndex:", aRange.location, YES),
        endingEntryIndex = (self.isa.method_msgSend["_indexOfRangeEntryForIndex:splitOnMaxIndex:"] || _objj_forward)(self, "_indexOfRangeEntryForIndex:splitOnMaxIndex:", CPMaxRange(aRange), YES),
        current = startingEntryIndex;
    if (endingEntryIndex === CPNotFound)
        endingEntryIndex = self._rangeEntries.length;
    while (current < endingEntryIndex)
    {
        var keys = (aDictionary == null ? null : (aDictionary.isa.method_msgSend["allKeys"] || _objj_forward)(aDictionary, "allKeys")),
            count = (keys == null ? null : (keys.isa.method_msgSend["count"] || _objj_forward)(keys, "count"));
        while (count--)
            ((___r1 = self._rangeEntries[current].attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", (aDictionary == null ? null : (aDictionary.isa.method_msgSend["objectForKey:"] || _objj_forward)(aDictionary, "objectForKey:", keys[count])), keys[count]));
        current++;
    }
    (self.isa.method_msgSend["_coalesceRangeEntriesFromIndex:toIndex:"] || _objj_forward)(self, "_coalesceRangeEntriesFromIndex:toIndex:", startingEntryIndex, endingEntryIndex);
    var ___r1;
}
,["void","CPDictionary","CPRange"]), new objj_method(sel_getUid("addAttribute:value:range:"), function(self, _cmd, anAttribute, aValue, aRange)
{
    (self.isa.method_msgSend["addAttributes:range:"] || _objj_forward)(self, "addAttributes:range:", (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [aValue], [anAttribute])), aRange);
    var ___r1;
}
,["void","CPString","id","CPRange"]), new objj_method(sel_getUid("removeAttribute:range:"), function(self, _cmd, anAttribute, aRange)
{
    var startingEntryIndex = (self.isa.method_msgSend["_indexOfRangeEntryForIndex:splitOnMaxIndex:"] || _objj_forward)(self, "_indexOfRangeEntryForIndex:splitOnMaxIndex:", aRange.location, YES),
        endingEntryIndex = (self.isa.method_msgSend["_indexOfRangeEntryForIndex:splitOnMaxIndex:"] || _objj_forward)(self, "_indexOfRangeEntryForIndex:splitOnMaxIndex:", CPMaxRange(aRange), YES),
        current = startingEntryIndex;
    if (endingEntryIndex === CPNotFound)
        endingEntryIndex = self._rangeEntries.length;
    while (current < endingEntryIndex)
        ((___r1 = self._rangeEntries[current++].attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(___r1, "removeObjectForKey:", anAttribute));
    (self.isa.method_msgSend["_coalesceRangeEntriesFromIndex:toIndex:"] || _objj_forward)(self, "_coalesceRangeEntriesFromIndex:toIndex:", startingEntryIndex, endingEntryIndex);
    var ___r1;
}
,["void","CPString","CPRange"]), new objj_method(sel_getUid("appendAttributedString:"), function(self, _cmd, aString)
{
    (self.isa.method_msgSend["insertAttributedString:atIndex:"] || _objj_forward)(self, "insertAttributedString:atIndex:", aString, self._string.length);
}
,["void","CPAttributedString"]), new objj_method(sel_getUid("insertAttributedString:atIndex:"), function(self, _cmd, aString, anIndex)
{
    if (anIndex < 0 || anIndex > (self.isa.method_msgSend["length"] || _objj_forward)(self, "length"))
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPRangeException, "tried to insert attributed string at an invalid index: " + anIndex);
    var entryIndexOfNextEntry = (self.isa.method_msgSend["_indexOfRangeEntryForIndex:splitOnMaxIndex:"] || _objj_forward)(self, "_indexOfRangeEntryForIndex:splitOnMaxIndex:", anIndex, YES),
        otherRangeEntries = aString._rangeEntries,
        length = (aString == null ? null : (aString.isa.method_msgSend["length"] || _objj_forward)(aString, "length"));
    if (entryIndexOfNextEntry === CPNotFound)
        entryIndexOfNextEntry = self._rangeEntries.length;
    self._string = self._string.substring(0, anIndex) + aString._string + self._string.substring(anIndex);
    var current = entryIndexOfNextEntry;
    while (current < self._rangeEntries.length)
        self._rangeEntries[current++].range.location += length;
    var newRangeEntryCount = otherRangeEntries.length,
        index = 0;
    while (index < newRangeEntryCount)
    {
        var entryCopy = copyRangeEntry(otherRangeEntries[index++]);
        entryCopy.range.location += anIndex;
        self._rangeEntries.splice(entryIndexOfNextEntry - 1 + index, 0, entryCopy);
    }
    (self.isa.method_msgSend["_coalesceRangeEntriesFromIndex:toIndex:"] || _objj_forward)(self, "_coalesceRangeEntriesFromIndex:toIndex:", MAX(0, entryIndexOfNextEntry - 1), MIN(entryIndexOfNextEntry + 1, self._rangeEntries.length - 1));
}
,["void","CPAttributedString","CPUInteger"]), new objj_method(sel_getUid("replaceCharactersInRange:withAttributedString:"), function(self, _cmd, aRange, aString)
{
    (self.isa.method_msgSend["deleteCharactersInRange:"] || _objj_forward)(self, "deleteCharactersInRange:", aRange);
    (self.isa.method_msgSend["insertAttributedString:atIndex:"] || _objj_forward)(self, "insertAttributedString:atIndex:", aString, aRange.location);
}
,["void","CPRange","CPAttributedString"]), new objj_method(sel_getUid("setAttributedString:"), function(self, _cmd, aString)
{
    self._string = aString._string;
    self._rangeEntries = ((___r1 = aString._rangeEntries), ___r1 == null ? null : (___r1.isa.method_msgSend["arrayByApplyingBlock:"] || _objj_forward)(___r1, "arrayByApplyingBlock:", function(entry)
    {
        return copyRangeEntry(entry);
    }));
    var ___r1;
}
,["void","CPAttributedString"]), new objj_method(sel_getUid("_indexOfRangeEntryForIndex:splitOnMaxIndex:"), function(self, _cmd, characterIndex, split)
{
    var index = (self.isa.method_msgSend["_indexOfEntryWithIndex:"] || _objj_forward)(self, "_indexOfEntryWithIndex:", characterIndex);
    if (index === CPNotFound)
        return index;
    var rangeEntry = self._rangeEntries[index];
    if (rangeEntry.range.location === characterIndex || CPMaxRange(rangeEntry.range) - 1 === characterIndex && !split)
        return index;
    var newEntries = splitRangeEntryAtIndex(rangeEntry, characterIndex);
    self._rangeEntries.splice(index, 1, newEntries[0], newEntries[1]);
    index++;
    return index;
}
,["Number","unsigned","BOOL"]), new objj_method(sel_getUid("_coalesceRangeEntriesFromIndex:toIndex:"), function(self, _cmd, start, end)
{
    var current = start;
    if (end >= self._rangeEntries.length)
        end = self._rangeEntries.length - 1;
    while (current < end)
    {
        var a = self._rangeEntries[current],
            b = self._rangeEntries[current + 1];
        if (a && b && ((___r1 = a.attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToDictionary:"] || _objj_forward)(___r1, "isEqualToDictionary:", b.attributes)))
        {
            a.range.length = CPMaxRange(b.range) - a.range.location;
            self._rangeEntries.splice(current + 1, 1);
            end--;
        }
        else
            current++;
    }
    var ___r1;
}
,["void","unsigned","unsigned"]), new objj_method(sel_getUid("beginEditing"), function(self, _cmd)
{
}
,["void"]), new objj_method(sel_getUid("endEditing"), function(self, _cmd)
{
}
,["void"])]);
}var CPAttributedStringStringKey = "CPAttributedStringString",
    CPAttributedStringRangesKey = "CPAttributedStringRanges",
    CPAttributedStringAttributesKey = "CPAttributedStringAttributes";
{
var the_class = objj_getClass("CPAttributedString")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPAttributedString\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    self = (self == null ? null : (self.isa.method_msgSend["init"] || _objj_forward)(self, "init"));
    if (self)
    {
        self._string = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPAttributedStringStringKey));
        var decodedRanges = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPAttributedStringRangesKey)),
            decodedAttributes = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPAttributedStringAttributesKey));
        self._rangeEntries = [];
        for (var i = 0, l = decodedRanges.length; i < l; i++)
            self._rangeEntries.push(makeRangeEntry(decodedRanges[i], decodedAttributes[i]));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._string, CPAttributedStringStringKey));
    var rangesForEncoding = [],
        dictsForEncoding = [];
    for (var i = 0, l = self._rangeEntries.length; i < l; i++)
    {
        rangesForEncoding.push(self._rangeEntries[i].range);
        dictsForEncoding.push(self._rangeEntries[i].attributes);
    }
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", rangesForEncoding, CPAttributedStringRangesKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", dictsForEncoding, CPAttributedStringAttributesKey));
}
,["void","CPCoder"])]);
}{var the_class = objj_allocateClassPair(CPAttributedString, "CPMutableAttributedString"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
}var isEqual = function(a, b)
{
    if (a === b)
        return YES;
    if ((a == null ? null : (a.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(a, "respondsToSelector:", sel_getUid("isEqual:"))) && (a == null ? null : (a.isa.method_msgSend["isEqual:"] || _objj_forward)(a, "isEqual:", b)))
        return YES;
    return NO;
};
var makeRangeEntry = function(aRange, attributes)
{
    return {range: aRange, attributes: (attributes == null ? null : (attributes.isa.method_msgSend["copy"] || _objj_forward)(attributes, "copy"))};
};
var copyRangeEntry = function(aRangeEntry)
{
    return makeRangeEntry(CPMakeRangeCopy(aRangeEntry.range), ((___r1 = aRangeEntry.attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy")));
    var ___r1;
};
var splitRangeEntryAtIndex = function(aRangeEntry, anIndex)
{
    var newRangeEntry = copyRangeEntry(aRangeEntry),
        cachedIndex = CPMaxRange(aRangeEntry.range);
    aRangeEntry.range.length = anIndex - aRangeEntry.range.location;
    newRangeEntry.range.location = anIndex;
    newRangeEntry.range.length = cachedIndex - anIndex;
    newRangeEntry.attributes = ((___r1 = newRangeEntry.attributes), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
    return [aRangeEntry, newRangeEntry];
    var ___r1;
};
p;10;CPBundle.jt;8584;@STATIC;1.0;i;14;CPDictionary.ji;16;CPNotification.ji;22;CPNotificationCenter.ji;10;CPObject.jt;8483;objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPNotification.j", YES);objj_executeFile("CPNotificationCenter.j", YES);objj_executeFile("CPObject.j", YES);CPBundleDidLoadNotification = "CPBundleDidLoadNotification";
{var the_protocol = objj_allocateProtocol("CPBundleDelegate");
var aProtocol = objj_getProtocol("CPObject");
if (!aProtocol) throw new SyntaxError("*** Could not find definition for protocol \"CPBundleDelegate\"");
protocol_addProtocol(the_protocol, aProtocol);
objj_registerProtocol(the_protocol);
protocol_addMethodDescriptions(the_protocol, [new objj_method(sel_getUid("bundleDidFinishLoading:"), Nil
,["void","CPBundle"])], true, true);
}var CPBundlesForURLStrings = {};
{var the_class = objj_allocateClassPair(CPObject, "CPBundle"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_bundle", "CFBundle"), new objj_ivar("_delegate", "id")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithURL:"), function(self, _cmd, aURL)
{
    aURL = new CFURL(aURL);
    var URLString = aURL.absoluteString(),
        existingBundle = CPBundlesForURLStrings[URLString];
    if (existingBundle)
        return existingBundle;
    self = (objj_getClass("CPBundle").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._bundle = new CFBundle(aURL);
        CPBundlesForURLStrings[URLString] = self;
    }
    return self;
}
,["id","CPURL"]), new objj_method(sel_getUid("initWithPath:"), function(self, _cmd, aPath)
{
    return (self.isa.method_msgSend["initWithURL:"] || _objj_forward)(self, "initWithURL:", aPath);
}
,["id","CPString"]), new objj_method(sel_getUid("classNamed:"), function(self, _cmd, aString)
{
}
,["Class","CPString"]), new objj_method(sel_getUid("bundleURL"), function(self, _cmd)
{
    return self._bundle.bundleURL();
}
,["CPURL"]), new objj_method(sel_getUid("bundlePath"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["bundleURL"] || _objj_forward)(self, "bundleURL")), ___r1 == null ? null : (___r1.isa.method_msgSend["path"] || _objj_forward)(___r1, "path"));
    var ___r1;
}
,["CPString"]), new objj_method(sel_getUid("resourcePath"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["resourceURL"] || _objj_forward)(self, "resourceURL")), ___r1 == null ? null : (___r1.isa.method_msgSend["path"] || _objj_forward)(___r1, "path"));
    var ___r1;
}
,["CPString"]), new objj_method(sel_getUid("resourceURL"), function(self, _cmd)
{
    return self._bundle.resourcesDirectoryURL();
}
,["CPURL"]), new objj_method(sel_getUid("principalClass"), function(self, _cmd)
{
    var className = (self.isa.method_msgSend["objectForInfoDictionaryKey:"] || _objj_forward)(self, "objectForInfoDictionaryKey:", "CPPrincipalClass");
    return className ? CPClassFromString(className) : nil;
}
,["Class"]), new objj_method(sel_getUid("bundleIdentifier"), function(self, _cmd)
{
    return self._bundle.identifier();
}
,["CPString"]), new objj_method(sel_getUid("isLoaded"), function(self, _cmd)
{
    return self._bundle.isLoaded();
}
,["BOOL"]), new objj_method(sel_getUid("pathForResource:"), function(self, _cmd, aFilename)
{
    return self._bundle.pathForResource(aFilename);
}
,["CPString","CPString"]), new objj_method(sel_getUid("pathForResource:ofType:"), function(self, _cmd, aFilename, extension)
{
    return self._bundle.pathForResource(aFilename, extension);
}
,["CPString","CPString","CPString"]), new objj_method(sel_getUid("pathForResource:ofType:inDirectory:"), function(self, _cmd, aFilename, extension, subpath)
{
    return self._bundle.pathForResource(aFilename, extension, subpath);
}
,["CPString","CPString","CPString","CPString"]), new objj_method(sel_getUid("pathForResource:ofType:inDirectory:forLocalization:"), function(self, _cmd, aFilename, extension, subpath, localizationName)
{
    return self._bundle.pathForResource(aFilename, extension, subpath, localizationName);
}
,["CPString","CPString","CPString","CPString","CPString"]), new objj_method(sel_getUid("infoDictionary"), function(self, _cmd)
{
    return self._bundle.infoDictionary();
}
,["CPDictionary"]), new objj_method(sel_getUid("objectForInfoDictionaryKey:"), function(self, _cmd, aKey)
{
    return self._bundle.valueForInfoDictionaryKey(aKey);
}
,["id","CPString"]), new objj_method(sel_getUid("loadWithDelegate:"), function(self, _cmd, aDelegate)
{
    self._delegate = aDelegate;
    self._bundle.addEventListener("load", function()
    {
        ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["bundleDidFinishLoading:"] || _objj_forward)(___r1, "bundleDidFinishLoading:", self));
        ((___r1 = (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter")), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotificationName:object:userInfo:"] || _objj_forward)(___r1, "postNotificationName:object:userInfo:", CPBundleDidLoadNotification, self, nil));
        var ___r1;
    });
    self._bundle.addEventListener("error", function()
    {
        CPLog.error("Could not find bundle: " + self);
    });
    self._bundle.load(YES);
}
,["void","id"]), new objj_method(sel_getUid("staticResourceURLs"), function(self, _cmd)
{
    var staticResources = self._bundle.staticResources();
    return (staticResources == null ? null : (staticResources.isa.method_msgSend["arrayByApplyingBlock:"] || _objj_forward)(staticResources, "arrayByApplyingBlock:", function(resource)
    {
        return resource.URL();
    }));
}
,["CPArray"]), new objj_method(sel_getUid("environments"), function(self, _cmd)
{
    return self._bundle.environments();
}
,["CPArray"]), new objj_method(sel_getUid("mostEligibleEnvironment"), function(self, _cmd)
{
    return self._bundle.mostEligibleEnvironment();
}
,["CPString"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (objj_getClass("CPBundle").super_class.method_dtable["description"] || _objj_forward)(self, "description") + "(" + (self.isa.method_msgSend["bundlePath"] || _objj_forward)(self, "bundlePath") + ")";
}
,["CPString"]), new objj_method(sel_getUid("localizations"), function(self, _cmd)
{
    return CFBundleCopyBundleLocalizations(self._bundle);
}
,["CPArray"]), new objj_method(sel_getUid("localizedStringForKey:value:table:"), function(self, _cmd, aKey, aValue, aTable)
{
    return CFBundleCopyLocalizedString(self._bundle, aKey, aValue, aTable);
}
,["CPString","CPString","CPString","CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("bundleWithURL:"), function(self, _cmd, aURL)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithURL:"] || _objj_forward)(___r1, "initWithURL:", aURL));
    var ___r1;
}
,["CPBundle","CPURL"]), new objj_method(sel_getUid("bundleWithPath:"), function(self, _cmd, aPath)
{
    return (self.isa.method_msgSend["bundleWithURL:"] || _objj_forward)(self, "bundleWithURL:", aPath);
}
,["CPBundle","CPString"]), new objj_method(sel_getUid("bundleWithIdentifier:"), function(self, _cmd, anIdentifier)
{
    var bundle = CFBundle.bundleWithIdentifier(anIdentifier);
    if (bundle)
    {
        var url = bundle.bundleURL(),
            cpBundle = CPBundlesForURLStrings[url.absoluteString()];
        if (!cpBundle)
            cpBundle = (self.isa.method_msgSend["bundleWithURL:"] || _objj_forward)(self, "bundleWithURL:", url);
        return cpBundle;
    }
    return nil;
}
,["CPBundle","CPString"]), new objj_method(sel_getUid("bundleForClass:"), function(self, _cmd, aClass)
{
    return (self.isa.method_msgSend["bundleWithURL:"] || _objj_forward)(self, "bundleWithURL:", (CFBundle.bundleForClass(aClass)).bundleURL());
}
,["CPBundle","Class"]), new objj_method(sel_getUid("mainBundle"), function(self, _cmd)
{
    return (CPBundle.isa.method_msgSend["bundleWithPath:"] || _objj_forward)(CPBundle, "bundleWithPath:", (CFBundle.mainBundle()).bundleURL());
}
,["CPBundle"])]);
}CPLocalizedString = function(key, comment)
{
    return CFCopyLocalizedString(key, comment);
}
CPLocalizedStringFromTable = function(key, table, comment)
{
    return CFCopyLocalizedStringFromTable(key, table, comment);
}
CPCopyLocalizedStringFromTableInBundle = function(key, table, bundle, comment)
{
    return CFCopyLocalizedStringFromTableInBundle(key, table, bundle._bundle, comment);
}
p;22;CPByteCountFormatter.jt;14401;@STATIC;1.0;i;19;CPNumberFormatter.ji;10;CPString.jt;14342;objj_executeFile("CPNumberFormatter.j", YES);objj_executeFile("CPString.j", YES);CPByteCountFormatterUseDefault = 0;
CPByteCountFormatterUseBytes = 1 << 0;
CPByteCountFormatterUseKB = 1 << 1;
CPByteCountFormatterUseMB = 1 << 2;
CPByteCountFormatterUseGB = 1 << 3;
CPByteCountFormatterUseTB = 1 << 4;
CPByteCountFormatterUsePB = 1 << 5;
CPByteCountFormatterUseAll = 0xFFFF;
CPByteCountFormatterCountStyleFile = 0;
CPByteCountFormatterCountStyleMemory = 1;
CPByteCountFormatterCountStyleDecimal = 2;
CPByteCountFormatterCountStyleBinary = 3;
var CPByteCountFormatterUnits = ["bytes", "KB", "MB", "GB", "TB", "PB"];
{var the_class = objj_allocateClassPair(CPFormatter, "CPByteCountFormatter"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_countStyle", "int"), new objj_ivar("_allowsNonnumericFormatting", "BOOL"), new objj_ivar("_includesActualByteCount", "BOOL"), new objj_ivar("_includesCount", "BOOL"), new objj_ivar("_includesUnit", "BOOL"), new objj_ivar("_adaptive", "BOOL"), new objj_ivar("_zeroPadsFractionDigits", "BOOL"), new objj_ivar("_allowedUnits", "int"), new objj_ivar("_numberFormatter", "CPNumberFormatter")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    if (self = (objj_getClass("CPByteCountFormatter").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._adaptive = YES;
        self._allowedUnits = CPByteCountFormatterUseDefault;
        self._allowsNonnumericFormatting = YES;
        self._countStyle = CPByteCountFormatterCountStyleFile;
        self._includesActualByteCount = NO;
        self._includesCount = YES;
        self._includesUnit = YES;
        self._zeroPadsFractionDigits = NO;
        self._numberFormatter = (CPNumberFormatter.isa.method_msgSend["new"] || _objj_forward)(CPNumberFormatter, "new");
        ((___r1 = self._numberFormatter), ___r1 == null ? null : (___r1.isa.method_msgSend["setNumberStyle:"] || _objj_forward)(___r1, "setNumberStyle:", CPNumberFormatterDecimalStyle));
        ((___r1 = self._numberFormatter), ___r1 == null ? null : (___r1.isa.method_msgSend["setMinimumFractionDigits:"] || _objj_forward)(___r1, "setMinimumFractionDigits:", 0));
    }
    return self;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("stringFromByteCount:"), function(self, _cmd, byteCount)
{
    var divisor,
        exponent = 0,
        unitIndex = self._allowedUnits === 0 || self._allowedUnits & CPByteCountFormatterUseBytes ? 0 : -1,
        bytes = byteCount,
        unitBytes = bytes,
        unitCount = (CPByteCountFormatterUnits == null ? null : (CPByteCountFormatterUnits.isa.method_msgSend["count"] || _objj_forward)(CPByteCountFormatterUnits, "count"));
    if (self._countStyle === CPByteCountFormatterCountStyleFile || self._countStyle === CPByteCountFormatterCountStyleDecimal)
        divisor = 1000;
    else
        divisor = 1024;
    while (bytes >= divisor && exponent < unitCount)
    {
        bytes /= divisor;
        ++exponent;
        if (self._allowedUnits === 0 || self._allowedUnits & 1 << exponent)
        {
            unitIndex = exponent;
            unitBytes = bytes;
        }
    }
    if (unitIndex === -1)
        for (var i = 1; i < unitCount; ++i)
        {
            unitBytes /= divisor;
            if (self._allowedUnits === 0 || self._allowedUnits & 1 << i)
            {
                unitIndex = i;
                break;
            }
        }
    var minDigits = 0,
        maxDigits = CPDecimalNoScale;
    if (unitBytes >= 1.0)
    {
        if (self._adaptive)
        {
            var digits;
            if (exponent <= 1)
                digits = 0;
            else if (exponent == 2)
                digits = 1;
            else
                digits = 2;
            maxDigits = digits;
            if (self._zeroPadsFractionDigits)
                minDigits = digits;
        }
        else
        {
            if (self._zeroPadsFractionDigits)
                minDigits = 2;
            if (bytes >= 1)
                maxDigits = 2;
        }
    }
    ((___r1 = self._numberFormatter), ___r1 == null ? null : (___r1.isa.method_msgSend["setMinimumFractionDigits:"] || _objj_forward)(___r1, "setMinimumFractionDigits:", minDigits));
    ((___r1 = self._numberFormatter), ___r1 == null ? null : (___r1.isa.method_msgSend["setMaximumFractionDigits:"] || _objj_forward)(___r1, "setMaximumFractionDigits:", maxDigits));
    var parts = [];
    if (self._includesCount)
    {
        if (self._allowsNonnumericFormatting && bytes === 0)
            (parts == null ? null : (parts.isa.method_msgSend["addObject:"] || _objj_forward)(parts, "addObject:", "Zero"));
        else
            (parts == null ? null : (parts.isa.method_msgSend["addObject:"] || _objj_forward)(parts, "addObject:", ((___r1 = self._numberFormatter), ___r1 == null ? null : (___r1.isa.method_msgSend["stringFromNumber:"] || _objj_forward)(___r1, "stringFromNumber:", unitBytes))));
    }
    if (self._includesUnit)
        (parts == null ? null : (parts.isa.method_msgSend["addObject:"] || _objj_forward)(parts, "addObject:", CPByteCountFormatterUnits[unitIndex]));
    if (unitIndex > 0 && self._includesCount && self._includesUnit && self._includesActualByteCount)
    {
        ((___r1 = self._numberFormatter), ___r1 == null ? null : (___r1.isa.method_msgSend["setMaximumFractionDigits:"] || _objj_forward)(___r1, "setMaximumFractionDigits:", 0));
        (parts == null ? null : (parts.isa.method_msgSend["addObject:"] || _objj_forward)(parts, "addObject:", (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "(%s bytes)", ((___r1 = self._numberFormatter), ___r1 == null ? null : (___r1.isa.method_msgSend["stringFromNumber:"] || _objj_forward)(___r1, "stringFromNumber:", byteCount)))));
    }
    var result = (parts == null ? null : (parts.isa.method_msgSend["componentsJoinedByString:"] || _objj_forward)(parts, "componentsJoinedByString:", " "));
    if (byteCount === 1)
        return (result == null ? null : (result.isa.method_msgSend["stringByReplacingOccurrencesOfString:withString:"] || _objj_forward)(result, "stringByReplacingOccurrencesOfString:withString:", "bytes", "byte"));
    else
        return result;
    var ___r1;
}
,["CPString","int"]), new objj_method(sel_getUid("stringForObjectValue:"), function(self, _cmd, anObject)
{
    if ((anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", CPNumber)))
        return (self.isa.method_msgSend["stringFromByteCount:"] || _objj_forward)(self, "stringFromByteCount:", anObject);
    else
        return nil;
}
,["CPString","id"]), new objj_method(sel_getUid("getObjectValue:forString:errorDescription:"), function(self, _cmd, anObject, aString, anError)
{
    return NO;
}
,["BOOL","idRef","CPString","CPStringRef"]), new objj_method(sel_getUid("countStyle"), function(self, _cmd)
{
    return self._countStyle;
}
,["int"]), new objj_method(sel_getUid("setCountStyle:"), function(self, _cmd, style)
{
    self._countStyle = style;
}
,["void","int"]), new objj_method(sel_getUid("allowsNonnumericFormatting"), function(self, _cmd)
{
    return self._allowsNonnumericFormatting;
}
,["BOOL"]), new objj_method(sel_getUid("setAllowsNonnumericFormatting:"), function(self, _cmd, shouldAllowNonnumericFormatting)
{
    self._allowsNonnumericFormatting = shouldAllowNonnumericFormatting;
}
,["void","BOOL"]), new objj_method(sel_getUid("includesActualByteCount"), function(self, _cmd)
{
    return self._includesActualByteCount;
}
,["BOOL"]), new objj_method(sel_getUid("setIncludesActualByteCount:"), function(self, _cmd, shouldIncludeActualByteCount)
{
    self._includesActualByteCount = shouldIncludeActualByteCount;
}
,["void","BOOL"]), new objj_method(sel_getUid("isAdaptive"), function(self, _cmd)
{
    return self._adaptive;
}
,["BOOL"]), new objj_method(sel_getUid("setAdaptive:"), function(self, _cmd, shouldBeAdaptive)
{
    self._adaptive = shouldBeAdaptive;
}
,["void","BOOL"]), new objj_method(sel_getUid("allowedUnits"), function(self, _cmd)
{
    return self._allowedUnits;
}
,["int"]), new objj_method(sel_getUid("setAllowedUnits:"), function(self, _cmd, allowed)
{
    self._allowedUnits = allowed;
}
,["void","int"]), new objj_method(sel_getUid("includesCount"), function(self, _cmd)
{
    return self._includesCount;
}
,["BOOL"]), new objj_method(sel_getUid("setIncludesCount:"), function(self, _cmd, shouldIncludeCount)
{
    self._includesCount = shouldIncludeCount;
}
,["void","BOOL"]), new objj_method(sel_getUid("includesUnit"), function(self, _cmd)
{
    return self._includesUnit;
}
,["BOOL"]), new objj_method(sel_getUid("setIncludesUnit:"), function(self, _cmd, shouldIncludeUnit)
{
    self._includesUnit = shouldIncludeUnit;
}
,["void","BOOL"]), new objj_method(sel_getUid("zeroPadsFractionDigits"), function(self, _cmd)
{
    return self._zeroPadsFractionDigits;
}
,["BOOL"]), new objj_method(sel_getUid("setZeroPadsFractionDigits:"), function(self, _cmd, shouldZeroPad)
{
    self._zeroPadsFractionDigits = shouldZeroPad;
}
,["void","BOOL"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("stringFromByteCount:countStyle:"), function(self, _cmd, byteCount, countStyle)
{
    var formatter = (CPByteCountFormatter.isa.method_msgSend["new"] || _objj_forward)(CPByteCountFormatter, "new");
    (formatter == null ? null : (formatter.isa.method_msgSend["setCountStyle:"] || _objj_forward)(formatter, "setCountStyle:", countStyle));
    return (formatter == null ? null : (formatter.isa.method_msgSend["stringFromByteCount:"] || _objj_forward)(formatter, "stringFromByteCount:", byteCount));
}
,["CPString","int","int"])]);
}var CPByteCountFormatterCountStyleKey = "CPByteCountFormatterCountStyleKey",
    CPByteCountFormatterAllowsNonnumericFormattingKey = "CPByteCountFormatterAllowsNonnumericFormattingKey",
    CPByteCountFormatterIncludesActualByteCountKey = "CPByteCountFormatterIncludesActualByteCountKey",
    CPByteCountFormatterIncludesCountKey = "CPByteCountFormatterIncludesCountKey",
    CPByteCountFormatterIncludesUnitKey = "CPByteCountFormatterIncludesUnitKey",
    CPByteCountFormatterAdaptiveKey = "CPByteCountFormatterAdaptiveKey",
    CPByteCountFormatterZeroPadsFractionDigitsKey = "CPByteCountFormatterZeroPadsFractionDigitsKey",
    CPByteCountFormatterAllowedUnitsKey = "CPByteCountFormatterAllowedUnitsKey";
{
var the_class = objj_getClass("CPByteCountFormatter")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPByteCountFormatter\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    self = (objj_getClass("CPByteCountFormatter").super_class.method_dtable["initWithCoder:"] || _objj_forward)(self, "initWithCoder:", aCoder);
    if (self)
    {
        self._countStyle = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPByteCountFormatterCountStyleKey));
        self._allowsNonnumericFormatting = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPByteCountFormatterAllowsNonnumericFormattingKey));
        self._includesActualByteCount = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPByteCountFormatterIncludesActualByteCountKey));
        self._includesCount = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPByteCountFormatterIncludesCountKey));
        self._includesUnit = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPByteCountFormatterIncludesUnitKey));
        self._adaptive = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPByteCountFormatterAdaptiveKey));
        self._zeroPadsFractionDigits = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPByteCountFormatterZeroPadsFractionDigitsKey));
        self._allowedUnits = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPByteCountFormatterAllowedUnitsKey));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (objj_getClass("CPByteCountFormatter").super_class.method_dtable["encodeWithCoder:"] || _objj_forward)(self, "encodeWithCoder:", aCoder);
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._countStyle, CPByteCountFormatterCountStyleKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._allowsNonnumericFormatting, CPByteCountFormatterAllowsNonnumericFormattingKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._includesActualByteCount, CPByteCountFormatterIncludesActualByteCountKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._includesCount, CPByteCountFormatterIncludesCountKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._includesUnit, CPByteCountFormatterIncludesUnitKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._adaptive, CPByteCountFormatterAdaptiveKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._zeroPadsFractionDigits, CPByteCountFormatterZeroPadsFractionDigitsKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._allowedUnits, CPByteCountFormatterAllowedUnitsKey));
}
,["void","CPCoder"])]);
}p;9;CPCache.jt;13856;@STATIC;1.0;i;10;CPObject.ji;14;CPDictionary.ji;10;CPString.jt;13787;objj_executeFile("CPObject.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPString.j", YES);{var the_protocol = objj_allocateProtocol("CPCacheDelegate");
var aProtocol = objj_getProtocol("CPObject");
if (!aProtocol) throw new SyntaxError("*** Could not find definition for protocol \"CPCacheDelegate\"");
protocol_addProtocol(the_protocol, aProtocol);
objj_registerProtocol(the_protocol);
}var CPCacheDelegate_cache_willEvictObject_ = 1 << 1;
{var the_class = objj_allocateClassPair(CPObject, "CPCache"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_items", "CPDictionary"), new objj_ivar("_currentPosition", "int"), new objj_ivar("_totalCostCache", "BOOL"), new objj_ivar("_implementedDelegateMethods", "unsigned"), new objj_ivar("_name", "CPString"), new objj_ivar("_countLimit", "int"), new objj_ivar("_totalCostLimit", "int"), new objj_ivar("_delegate", "id")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("name"), function(self, _cmd)
{
    return self._name;
}
,["CPString"]), new objj_method(sel_getUid("setName:"), function(self, _cmd, newValue)
{
    self._name = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("countLimit"), function(self, _cmd)
{
    return self._countLimit;
}
,["int"]), new objj_method(sel_getUid("setCountLimit:"), function(self, _cmd, newValue)
{
    self._countLimit = newValue;
}
,["void","int"]), new objj_method(sel_getUid("totalCostLimit"), function(self, _cmd)
{
    return self._totalCostLimit;
}
,["int"]), new objj_method(sel_getUid("setTotalCostLimit:"), function(self, _cmd, newValue)
{
    self._totalCostLimit = newValue;
}
,["void","int"]), new objj_method(sel_getUid("delegate"), function(self, _cmd)
{
    return self._delegate;
}
,["id"]), new objj_method(sel_getUid("setDelegate:"), function(self, _cmd, newValue)
{
    self._delegate = newValue;
}
,["void","id"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    if (self = (objj_getClass("CPCache").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._items = ((___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._currentPosition = 0;
        self._totalCostCache = -1;
        self._implementedDelegateMethods = 0;
        self._name = "";
        self._countLimit = 0;
        self._totalCostLimit = 0;
        self._delegate = nil;
    }
    return self;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("objectForKey:"), function(self, _cmd, aKey)
{
    return ((___r1 = ((___r2 = self._items), ___r2 == null ? null : (___r2.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r2, "objectForKey:", aKey))), ___r1 == null ? null : (___r1.isa.method_msgSend["object"] || _objj_forward)(___r1, "object"));
    var ___r1, ___r2;
}
,["id","id"]), new objj_method(sel_getUid("setObject:forKey:"), function(self, _cmd, anObject, aKey)
{
    (self.isa.method_msgSend["setObject:forKey:cost:"] || _objj_forward)(self, "setObject:forKey:cost:", anObject, aKey, 0);
}
,["void","id","id"]), new objj_method(sel_getUid("setObject:forKey:cost:"), function(self, _cmd, anObject, aKey, aCost)
{
    if (((___r1 = self._items), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aKey)))
        (self.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(self, "removeObjectForKey:", aKey);
    ((___r1 = self._items), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", (_CPCacheItem == null ? null : (_CPCacheItem.isa.method_msgSend["cacheItemWithObject:cost:position:"] || _objj_forward)(_CPCacheItem, "cacheItemWithObject:cost:position:", anObject, aCost, ++self._currentPosition)), aKey));
    self._totalCostCache = -1;
    (self.isa.method_msgSend["_cleanCache"] || _objj_forward)(self, "_cleanCache");
    var ___r1;
}
,["void","id","id","int"]), new objj_method(sel_getUid("removeObjectForKey:"), function(self, _cmd, aKey)
{
    (self.isa.method_msgSend["_sendDelegateWillEvictObjectForKey:"] || _objj_forward)(self, "_sendDelegateWillEvictObjectForKey:", aKey);
    ((___r1 = self._items), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(___r1, "removeObjectForKey:", aKey));
    self._totalCostCache = -1;
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("removeAllObjects"), function(self, _cmd)
{
    var enumerator = ((___r1 = self._items), ___r1 == null ? null : (___r1.isa.method_msgSend["keyEnumerator"] || _objj_forward)(___r1, "keyEnumerator")),
        key;
    while (key = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject")))
        (self.isa.method_msgSend["_sendDelegateWillEvictObjectForKey:"] || _objj_forward)(self, "_sendDelegateWillEvictObjectForKey:", key);
    ((___r1 = self._items), ___r1 == null ? null : (___r1.isa.method_msgSend["removeAllObjects"] || _objj_forward)(___r1, "removeAllObjects"));
    self._totalCostCache = -1;
    self._currentPosition = 0;
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("setCountLimit:"), function(self, _cmd, aCountLimit)
{
    self._countLimit = aCountLimit;
    (self.isa.method_msgSend["_cleanCache"] || _objj_forward)(self, "_cleanCache");
}
,["void","int"]), new objj_method(sel_getUid("setTotalCostLimit:"), function(self, _cmd, aTotalCostLimit)
{
    self._totalCostLimit = aTotalCostLimit;
    (self.isa.method_msgSend["_cleanCache"] || _objj_forward)(self, "_cleanCache");
}
,["void","int"]), new objj_method(sel_getUid("setDelegate:"), function(self, _cmd, aDelegate)
{
    if (self._delegate === aDelegate)
        return;
    self._delegate = aDelegate;
    self._implementedDelegateMethods = 0;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("cache:willEvictObject:"))))
        self._implementedDelegateMethods |= CPCacheDelegate_cache_willEvictObject_;
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("_count"), function(self, _cmd)
{
    return ((___r1 = self._items), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
    var ___r1;
}
,["int"]), new objj_method(sel_getUid("_totalCost"), function(self, _cmd)
{
    if (self._totalCostCache >= 0)
        return self._totalCostCache;
    var enumerator = ((___r1 = self._items), ___r1 == null ? null : (___r1.isa.method_msgSend["objectEnumerator"] || _objj_forward)(___r1, "objectEnumerator")),
        value;
    self._totalCostCache = 0;
    while (value = (enumerator == null ? null : (enumerator.isa.method_msgSend["nextObject"] || _objj_forward)(enumerator, "nextObject")))
        self._totalCostCache += (value == null ? null : (value.isa.method_msgSend["cost"] || _objj_forward)(value, "cost"));
    return self._totalCostCache;
    var ___r1;
}
,["int"]), new objj_method(sel_getUid("_resequencePosition"), function(self, _cmd)
{
    self._currentPosition = 1;
    var sortedKeys = ((___r1 = ((___r2 = self._items), ___r2 == null ? null : (___r2.isa.method_msgSend["allKeys"] || _objj_forward)(___r2, "allKeys"))), ___r1 == null ? null : (___r1.isa.method_msgSend["sortedArrayUsingFunction:"] || _objj_forward)(___r1, "sortedArrayUsingFunction:", function(k1, k2)
    {
        return ((___r1 = ((___r2 = ((___r3 = self._items), ___r3 == null ? null : (___r3.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r3, "objectForKey:", k1))), ___r2 == null ? null : (___r2.isa.method_msgSend["position"] || _objj_forward)(___r2, "position"))), ___r1 == null ? null : (___r1.isa.method_msgSend["compare:"] || _objj_forward)(___r1, "compare:", ((___r2 = ((___r3 = self._items), ___r3 == null ? null : (___r3.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r3, "objectForKey:", k2))), ___r2 == null ? null : (___r2.isa.method_msgSend["position"] || _objj_forward)(___r2, "position"))));
        var ___r1, ___r2, ___r3;
    }));
    for (var i = 0; i < sortedKeys.length; ++i)
        ((___r1 = ((___r2 = self._items), ___r2 == null ? null : (___r2.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r2, "objectForKey:", sortedKeys[i]))), ___r1 == null ? null : (___r1.isa.method_msgSend["setPosition:"] || _objj_forward)(___r1, "setPosition:", self._currentPosition++));
    var ___r1, ___r2;
}
,["void"]), new objj_method(sel_getUid("_isTotalCostLimitExceeded"), function(self, _cmd)
{
    return (self.isa.method_msgSend["_totalCost"] || _objj_forward)(self, "_totalCost") > self._totalCostLimit && self._totalCostLimit > 0;
}
,["BOOL"]), new objj_method(sel_getUid("_isCountLimitExceeded"), function(self, _cmd)
{
    return (self.isa.method_msgSend["_count"] || _objj_forward)(self, "_count") > self._countLimit && self._countLimit > 0;
}
,["BOOL"]), new objj_method(sel_getUid("_cleanCache"), function(self, _cmd)
{
    if (!(self.isa.method_msgSend["_isTotalCostLimitExceeded"] || _objj_forward)(self, "_isTotalCostLimitExceeded") && !(self.isa.method_msgSend["_isCountLimitExceeded"] || _objj_forward)(self, "_isCountLimitExceeded"))
        return;
    var sortedKeys = ((___r1 = ((___r2 = self._items), ___r2 == null ? null : (___r2.isa.method_msgSend["allKeys"] || _objj_forward)(___r2, "allKeys"))), ___r1 == null ? null : (___r1.isa.method_msgSend["sortedArrayUsingFunction:"] || _objj_forward)(___r1, "sortedArrayUsingFunction:", function(k1, k2)
    {
        return ((___r1 = ((___r2 = ((___r3 = self._items), ___r3 == null ? null : (___r3.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r3, "objectForKey:", k1))), ___r2 == null ? null : (___r2.isa.method_msgSend["position"] || _objj_forward)(___r2, "position"))), ___r1 == null ? null : (___r1.isa.method_msgSend["compare:"] || _objj_forward)(___r1, "compare:", ((___r2 = ((___r3 = self._items), ___r3 == null ? null : (___r3.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r3, "objectForKey:", k2))), ___r2 == null ? null : (___r2.isa.method_msgSend["position"] || _objj_forward)(___r2, "position"))));
        var ___r1, ___r2, ___r3;
    }));
    for (var i = 0; i < sortedKeys.length; ++i)
    {
        if (!(self.isa.method_msgSend["_isTotalCostLimitExceeded"] || _objj_forward)(self, "_isTotalCostLimitExceeded") && !(self.isa.method_msgSend["_isCountLimitExceeded"] || _objj_forward)(self, "_isCountLimitExceeded"))
            break;
        (self.isa.method_msgSend["_sendDelegateWillEvictObjectForKey:"] || _objj_forward)(self, "_sendDelegateWillEvictObjectForKey:", sortedKeys[i]);
        ((___r1 = self._items), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(___r1, "removeObjectForKey:", sortedKeys[i]));
        self._totalCostCache = -1;
    }
    (self.isa.method_msgSend["_resequencePosition"] || _objj_forward)(self, "_resequencePosition");
    var ___r1, ___r2;
}
,["void"])]);
}{
var the_class = objj_getClass("CPCache")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPCache\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("_sendDelegateWillEvictObjectForKey:"), function(self, _cmd, aKey)
{
    if (self._implementedDelegateMethods & CPCacheDelegate_cache_willEvictObject_)
        ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["cache:willEvictObject:"] || _objj_forward)(___r1, "cache:willEvictObject:", self, ((___r2 = ((___r3 = self._items), ___r3 == null ? null : (___r3.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r3, "objectForKey:", aKey))), ___r2 == null ? null : (___r2.isa.method_msgSend["object"] || _objj_forward)(___r2, "object"))));
    var ___r1, ___r2, ___r3;
}
,["void","id"])]);
}{var the_class = objj_allocateClassPair(CPObject, "_CPCacheItem"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_object", "CPObject"), new objj_ivar("_cost", "int"), new objj_ivar("_position", "int")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("object"), function(self, _cmd)
{
    return self._object;
}
,["CPObject"]), new objj_method(sel_getUid("setObject:"), function(self, _cmd, newValue)
{
    self._object = newValue;
}
,["void","CPObject"]), new objj_method(sel_getUid("cost"), function(self, _cmd)
{
    return self._cost;
}
,["int"]), new objj_method(sel_getUid("setCost:"), function(self, _cmd, newValue)
{
    self._cost = newValue;
}
,["void","int"]), new objj_method(sel_getUid("position"), function(self, _cmd)
{
    return self._position;
}
,["int"]), new objj_method(sel_getUid("setPosition:"), function(self, _cmd, newValue)
{
    self._position = newValue;
}
,["void","int"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("cacheItemWithObject:cost:position:"), function(self, _cmd, anObject, aCost, aPosition)
{
    var cacheItem = ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    if (cacheItem)
    {
        (cacheItem == null ? null : (cacheItem.isa.method_msgSend["setObject:"] || _objj_forward)(cacheItem, "setObject:", anObject));
        (cacheItem == null ? null : (cacheItem.isa.method_msgSend["setCost:"] || _objj_forward)(cacheItem, "setCost:", aCost));
        (cacheItem == null ? null : (cacheItem.isa.method_msgSend["setPosition:"] || _objj_forward)(cacheItem, "setPosition:", aPosition));
    }
    return cacheItem;
    var ___r1;
}
,["id","CPObject","int","int"])]);
}p;16;CPCharacterSet.jt;42364;@STATIC;1.0;i;9;CPArray.ji;13;CPException.ji;10;CPObject.ji;10;CPString.ji;7;CPURL.jt;42272;objj_executeFile("CPArray.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPURL.j", YES);var _builtInCharacterSets = {};
{var the_class = objj_allocateClassPair(CPObject, "CPCharacterSet"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_inverted", "BOOL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPCharacterSet").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        self._inverted = NO;
    return self;
}
,["id"]), new objj_method(sel_getUid("invert"), function(self, _cmd)
{
    self._inverted = !self._inverted;
}
,["void"]), new objj_method(sel_getUid("characterIsMember:"), function(self, _cmd, aCharacter)
{
}
,["BOOL","CPString"]), new objj_method(sel_getUid("hasMemberInPlane:"), function(self, _cmd, aPlane)
{
}
,["BOOL","int"]), new objj_method(sel_getUid("_setInverted:"), function(self, _cmd, flag)
{
    self._inverted = flag;
}
,["void","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("characterSetWithCharactersInString:"), function(self, _cmd, aString)
{
    return ((___r1 = (_CPStringContentCharacterSet == null ? null : (_CPStringContentCharacterSet.isa.method_msgSend["alloc"] || _objj_forward)(_CPStringContentCharacterSet, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", aString));
    var ___r1;
}
,["id","CPString"]), new objj_method(sel_getUid("characterSetWithRange:"), function(self, _cmd, aRange)
{
    return ((___r1 = (_CPRangeCharacterSet == null ? null : (_CPRangeCharacterSet.isa.method_msgSend["alloc"] || _objj_forward)(_CPRangeCharacterSet, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithRange:"] || _objj_forward)(___r1, "initWithRange:", aRange));
    var ___r1;
}
,["id","CPRange"]), new objj_method(sel_getUid("alphanumericCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("controlCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("decimalDigitCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("decomposableCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("illegalCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("letterCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("lowercaseLetterCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("nonBaseCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("punctuationCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("uppercaseLetterCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("whitespaceAndNewlineCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("whitespaceCharacterSet"), function(self, _cmd)
{
    return (CPCharacterSet.isa.method_msgSend["_sharedCharacterSetWithName:"] || _objj_forward)(CPCharacterSet, "_sharedCharacterSetWithName:", _cmd);
}
,["id"]), new objj_method(sel_getUid("_sharedCharacterSetWithName:"), function(self, _cmd, csname)
{
    var cs = _builtInCharacterSets[csname];
    if (!cs)
    {
        var i = 0,
            ranges = (CPArray.isa.method_msgSend["array"] || _objj_forward)(CPArray, "array"),
            rangeArray = eval(csname);
        for (; i < rangeArray.length; i += 2)
        {
            var loc = rangeArray[i],
                length = rangeArray[i + 1],
                range = CPMakeRange(loc, length);
            (ranges == null ? null : (ranges.isa.method_msgSend["addObject:"] || _objj_forward)(ranges, "addObject:", range));
        }
        cs = ((___r1 = (_CPRangeCharacterSet == null ? null : (_CPRangeCharacterSet.isa.method_msgSend["alloc"] || _objj_forward)(_CPRangeCharacterSet, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithRanges:"] || _objj_forward)(___r1, "initWithRanges:", ranges));
        _builtInCharacterSets[csname] = cs;
    }
    return cs;
    var ___r1;
}
,["id","id"])]);
}var CPCharacterSetInvertedKey = "CPCharacterSetInvertedKey";
{
var the_class = objj_getClass("CPCharacterSet")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPCharacterSet\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    if (self = (objj_getClass("CPCharacterSet").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._inverted = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPCharacterSetInvertedKey));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._inverted, CPCharacterSetInvertedKey));
}
,["void","CPCoder"])]);
}{var the_class = objj_allocateClassPair(CPCharacterSet, "_CPRangeCharacterSet"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_ranges", "CPArray")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithRange:"), function(self, _cmd, r)
{
    return (self.isa.method_msgSend["initWithRanges:"] || _objj_forward)(self, "initWithRanges:", (CPArray.isa.method_msgSend["arrayWithObject:"] || _objj_forward)(CPArray, "arrayWithObject:", r));
}
,["id","CPRange"]), new objj_method(sel_getUid("initWithRanges:"), function(self, _cmd, ranges)
{
    self = (objj_getClass("_CPRangeCharacterSet").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._ranges = ranges;
    }
    return self;
}
,["id","CPArray"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    var set = ((___r1 = (_CPRangeCharacterSet.isa.method_msgSend["alloc"] || _objj_forward)(_CPRangeCharacterSet, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithRanges:"] || _objj_forward)(___r1, "initWithRanges:", self._ranges));
    (set == null ? null : (set.isa.method_msgSend["_setInverted:"] || _objj_forward)(set, "_setInverted:", self._inverted));
    return set;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("invertedSet"), function(self, _cmd)
{
    var set = ((___r1 = (_CPRangeCharacterSet.isa.method_msgSend["alloc"] || _objj_forward)(_CPRangeCharacterSet, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithRanges:"] || _objj_forward)(___r1, "initWithRanges:", self._ranges));
    (set == null ? null : (set.isa.method_msgSend["invert"] || _objj_forward)(set, "invert"));
    return set;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("characterIsMember:"), function(self, _cmd, aCharacter)
{
    var c = aCharacter.charCodeAt(0),
        enu = ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["objectEnumerator"] || _objj_forward)(___r1, "objectEnumerator")),
        range;
    while ((range = (enu == null ? null : (enu.isa.method_msgSend["nextObject"] || _objj_forward)(enu, "nextObject"))) !== nil)
    {
        if (CPLocationInRange(c, range))
            return !self._inverted;
    }
    return self._inverted;
    var ___r1;
}
,["BOOL","CPString"]), new objj_method(sel_getUid("hasMemberInPlane:"), function(self, _cmd, plane)
{
    if (plane !== 0)
        return NO;
    var enu = ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["objectEnumerator"] || _objj_forward)(___r1, "objectEnumerator")),
        range;
    while ((range = (enu == null ? null : (enu.isa.method_msgSend["nextObject"] || _objj_forward)(enu, "nextObject"))) !== nil)
    {
        if (!CPEmptyRange(range))
            return YES;
    }
    return NO;
    var ___r1;
}
,["BOOL","int"]), new objj_method(sel_getUid("addCharactersInRange:"), function(self, _cmd, aRange)
{
    ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", aRange));
    var ___r1;
}
,["void","CPRange"]), new objj_method(sel_getUid("addCharactersInString:"), function(self, _cmd, aString)
{
    var i = 0;
    for (; i < aString.length; i++)
    {
        var code = aString.charCodeAt(i),
            range = CPMakeRange(code, 1);
        ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", range));
    }
    var ___r1;
}
,["void","CPString"])]);
}{var the_class = objj_allocateClassPair(CPCharacterSet, "_CPStringContentCharacterSet"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_string", "CPString")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithString:"), function(self, _cmd, s)
{
    self = (objj_getClass("_CPStringContentCharacterSet").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._string = s;
    }
    return self;
}
,["id","CPString"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    var set = ((___r1 = (_CPStringContentCharacterSet.isa.method_msgSend["alloc"] || _objj_forward)(_CPStringContentCharacterSet, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", self._string));
    (set == null ? null : (set.isa.method_msgSend["_setInverted:"] || _objj_forward)(set, "_setInverted:", self._inverted));
    return set;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("invertedSet"), function(self, _cmd)
{
    var set = ((___r1 = (_CPStringContentCharacterSet.isa.method_msgSend["alloc"] || _objj_forward)(_CPStringContentCharacterSet, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", self._string));
    (set == null ? null : (set.isa.method_msgSend["invert"] || _objj_forward)(set, "invert"));
    return set;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("characterIsMember:"), function(self, _cmd, c)
{
    return self._string.indexOf(c.charAt(0)) !== -1 === !self._inverted;
}
,["BOOL","CPString"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (objj_getClass("_CPStringContentCharacterSet").super_class.method_dtable["description"] || _objj_forward)(self, "description") + " { string = '" + self._string + "'}";
}
,["CPString"]), new objj_method(sel_getUid("hasMemberInPlane:"), function(self, _cmd, plane)
{
    return self._string.length && plane === 0;
}
,["BOOL","int"]), new objj_method(sel_getUid("addCharactersInRange:"), function(self, _cmd, aRange)
{
    var i = aRange.location,
        count = aRange.location + aRange.length;
    for (; i < count; i++)
    {
        var s = String.fromCharCode(i);
        if (!(self.isa.method_msgSend["characterIsMember:"] || _objj_forward)(self, "characterIsMember:", s))
            self._string = ((___r1 = self._string), ___r1 == null ? null : (___r1.isa.method_msgSend["stringByAppendingString:"] || _objj_forward)(___r1, "stringByAppendingString:", s));
    }
    var ___r1;
}
,["void","CPRange"]), new objj_method(sel_getUid("addCharactersInString:"), function(self, _cmd, aString)
{
    var i = 0;
    for (; i < aString.length; i++)
    {
        var s = aString.charAt(i);
        if (!(self.isa.method_msgSend["characterIsMember:"] || _objj_forward)(self, "characterIsMember:", s))
            self._string = ((___r1 = self._string), ___r1 == null ? null : (___r1.isa.method_msgSend["stringByAppendingString:"] || _objj_forward)(___r1, "stringByAppendingString:", s));
    }
    var ___r1;
}
,["void","CPString"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, aCharacterSet)
{
    if (self === aCharacterSet)
        return YES;
    if (!aCharacterSet || !(aCharacterSet == null ? null : (aCharacterSet.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(aCharacterSet, "isKindOfClass:", (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"))))
        return NO;
    return (self.isa.method_msgSend["_isEqualToStringContentCharacterSet:"] || _objj_forward)(self, "_isEqualToStringContentCharacterSet:", aCharacterSet);
}
,["BOOL","CPCharacterSet"]), new objj_method(sel_getUid("_isEqualToStringContentCharacterSet:"), function(self, _cmd, aCharacterSet)
{
    if (!aCharacterSet)
        return NO;
    return self._string === aCharacterSet._string && self._inverted === aCharacterSet._inverted;
}
,["BOOL","_CPStringContentCharacterSet"])]);
}var _CPStringContentCharacterSetStringKey = "_CPStringContentCharacterSetStringKey";
{
var the_class = objj_getClass("_CPStringContentCharacterSet")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"_CPStringContentCharacterSet\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    if (self = (objj_getClass("_CPStringContentCharacterSet").super_class.method_dtable["initWithCoder:"] || _objj_forward)(self, "initWithCoder:", aCoder))
    {
        self._string = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", _CPStringContentCharacterSetStringKey));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (objj_getClass("_CPStringContentCharacterSet").super_class.method_dtable["encodeWithCoder:"] || _objj_forward)(self, "encodeWithCoder:", aCoder);
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._string, _CPStringContentCharacterSetStringKey));
}
,["void","CPCoder"])]);
}_CPCharacterSetTrimAtBeginning = 1 << 1;
_CPCharacterSetTrimAtEnd = 1 << 2;
{
var the_class = objj_getClass("CPString")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPString\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("componentsSeparatedByCharactersInSet:"), function(self, _cmd, separator)
{
    if (!separator)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "componentsSeparatedByCharactersInSet: the separator can't be 'nil'");
    var components = (CPMutableArray.isa.method_msgSend["array"] || _objj_forward)(CPMutableArray, "array"),
        componentRange = CPMakeRange(0, 0),
        i = 0;
    for (; i < self.length; i++)
    {
        if ((separator == null ? null : (separator.isa.method_msgSend["characterIsMember:"] || _objj_forward)(separator, "characterIsMember:", self.charAt(i))))
        {
            componentRange.length = i - componentRange.location;
            (components == null ? null : (components.isa.method_msgSend["addObject:"] || _objj_forward)(components, "addObject:", (self.isa.method_msgSend["substringWithRange:"] || _objj_forward)(self, "substringWithRange:", componentRange)));
            componentRange.location += componentRange.length + 1;
        }
    }
    componentRange.length = self.length - componentRange.location;
    (components == null ? null : (components.isa.method_msgSend["addObject:"] || _objj_forward)(components, "addObject:", (self.isa.method_msgSend["substringWithRange:"] || _objj_forward)(self, "substringWithRange:", componentRange)));
    return components;
}
,["CPArray","CPCharacterSet"]), new objj_method(sel_getUid("stringByTrimmingCharactersInSet:"), function(self, _cmd, set)
{
    return (self.isa.method_msgSend["_stringByTrimmingCharactersInSet:options:"] || _objj_forward)(self, "_stringByTrimmingCharactersInSet:options:", set, _CPCharacterSetTrimAtBeginning | _CPCharacterSetTrimAtEnd);
}
,["id","CPCharacterSet"]), new objj_method(sel_getUid("_stringByTrimmingCharactersInSet:options:"), function(self, _cmd, set, options)
{
    var str = self;
    if (options & _CPCharacterSetTrimAtBeginning)
    {
        var cutEdgeBeginning = 0;
        while (cutEdgeBeginning < self.length && (set == null ? null : (set.isa.method_msgSend["characterIsMember:"] || _objj_forward)(set, "characterIsMember:", self.charAt(cutEdgeBeginning))))
            cutEdgeBeginning++;
        str = str.substr(cutEdgeBeginning);
    }
    if (options & _CPCharacterSetTrimAtEnd)
    {
        var cutEdgeEnd = str.length;
        while (cutEdgeEnd > 0 && (set == null ? null : (set.isa.method_msgSend["characterIsMember:"] || _objj_forward)(set, "characterIsMember:", str.charAt(cutEdgeEnd - 1))))
            cutEdgeEnd--;
        str = str.substr(0, cutEdgeEnd);
    }
    return str;
}
,["id","CPCharacterSet","int"])]);
}alphanumericCharacterSet = [48, 10, 65, 26, 97, 26, 170, 1, 178, 2, 181, 1, 185, 2, 188, 3, 192, 23, 216, 31, 248, 458, 710, 12, 736, 5, 750, 1, 768, 112, 890, 4, 902, 1, 904, 3, 908, 1, 910, 20, 931, 44, 976, 38, 1015, 139, 1155, 4, 1160, 140, 1329, 38, 1369, 1, 1377, 39, 1425, 45, 1471, 1, 1473, 2, 1476, 2, 1479, 1, 1488, 27, 1520, 3, 1552, 6, 1569, 26, 1600, 31, 1632, 10, 1646, 102, 1749, 8, 1758, 11, 1770, 19, 1791, 1, 1808, 59, 1869, 33, 1920, 50, 1984, 54, 2042, 1, 2305, 57, 2364, 18, 2384, 5, 2392, 12, 2406, 10, 2427, 5, 2433, 3, 2437, 8, 2447, 2, 2451, 22, 2474, 7, 2482, 1, 2486, 4, 2492, 9, 2503, 2, 2507, 4, 2519, 1, 2524, 2, 2527, 5, 2534, 12, 2548, 6, 2561, 3, 2565, 6, 2575, 2, 2579, 22, 2602, 7, 2610, 2, 2613, 2, 2616, 2, 2620, 1, 2622, 5, 2631, 2, 2635, 3, 2649, 4, 2654, 1, 2662, 15, 2689, 3, 2693, 9, 2703, 3, 2707, 22, 2730, 7, 2738, 2, 2741, 5, 2748, 10, 2759, 3, 2763, 3, 2768, 1, 2784, 4, 2790, 10, 2817, 3, 2821, 8, 2831, 2, 2835, 22, 2858, 7, 2866, 2, 2869, 5, 2876, 8, 2887, 2, 2891, 3, 2902, 2, 2908, 2, 2911, 3, 2918, 10, 2929, 1, 2946, 2, 2949, 6, 2958, 3, 2962, 4, 2969, 2, 2972, 1, 2974, 2, 2979, 2, 2984, 3, 2990, 12, 3006, 5, 3014, 3, 3018, 4, 3031, 1, 3046, 13, 3073, 3, 3077, 8, 3086, 3, 3090, 23, 3114, 10, 3125, 5, 3134, 7, 3142, 3, 3146, 4, 3157, 2, 3168, 2, 3174, 10, 3202, 2, 3205, 8, 3214, 3, 3218, 23, 3242, 10, 3253, 5, 3260, 9, 3270, 3, 3274, 4, 3285, 2, 3294, 1, 3296, 4, 3302, 10, 3330, 2, 3333, 8, 3342, 3, 3346, 23, 3370, 16, 3390, 6, 3398, 3, 3402, 4, 3415, 1, 3424, 2, 3430, 10, 3458, 2, 3461, 18, 3482, 24, 3507, 9, 3517, 1, 3520, 7, 3530, 1, 3535, 6, 3542, 1, 3544, 8, 3570, 2, 3585, 58, 3648, 15, 3664, 10, 3713, 2, 3716, 1, 3719, 2, 3722, 1, 3725, 1, 3732, 4, 3737, 7, 3745, 3, 3749, 1, 3751, 1, 3754, 2, 3757, 13, 3771, 3, 3776, 5, 3782, 1, 3784, 6, 3792, 10, 3804, 2, 3840, 1, 3864, 2, 3872, 20, 3893, 1, 3895, 1, 3897, 1, 3902, 10, 3913, 34, 3953, 20, 3974, 6, 3984, 8, 3993, 36, 4038, 1, 4096, 34, 4131, 5, 4137, 2, 4140, 7, 4150, 4, 4160, 10, 4176, 10, 4256, 38, 4304, 43, 4348, 1, 4352, 90, 4447, 68, 4520, 82, 4608, 73, 4682, 4, 4688, 7, 4696, 1, 4698, 4, 4704, 41, 4746, 4, 4752, 33, 4786, 4, 4792, 7, 4800, 1, 4802, 4, 4808, 15, 4824, 57, 4882, 4, 4888, 67, 4959, 1, 4969, 20, 4992, 16, 5024, 85, 5121, 620, 5743, 8, 5761, 26, 5792, 75, 5870, 3, 5888, 13, 5902, 7, 5920, 21, 5952, 20, 5984, 13, 5998, 3, 6002, 2, 6016, 52, 6070, 30, 6103, 1, 6108, 2, 6112, 10, 6128, 10, 6155, 3, 6160, 10, 6176, 88, 6272, 42, 6400, 29, 6432, 12, 6448, 12, 6470, 40, 6512, 5, 6528, 42, 6576, 26, 6608, 10, 6656, 28, 6912, 76, 6992, 10, 7019, 9, 7424, 203, 7678, 158, 7840, 90, 7936, 22, 7960, 6, 7968, 38, 8008, 6, 8016, 8, 8025, 1, 8027, 1, 8029, 1, 8031, 31, 8064, 53, 8118, 7, 8126, 1, 8130, 3, 8134, 7, 8144, 4, 8150, 6, 8160, 13, 8178, 3, 8182, 7, 8304, 2, 8308, 6, 8319, 11, 8336, 5, 8400, 32, 8450, 1, 8455, 1, 8458, 10, 8469, 1, 8473, 5, 8484, 1, 8486, 1, 8488, 1, 8490, 4, 8495, 11, 8508, 4, 8517, 5, 8526, 1, 8531, 50, 9312, 60, 9450, 22, 10102, 30, 11264, 47, 11312, 47, 11360, 13, 11380, 4, 11392, 101, 11517, 1, 11520, 38, 11568, 54, 11631, 1, 11648, 23, 11680, 7, 11688, 7, 11696, 7, 11704, 7, 11712, 7, 11720, 7, 11728, 7, 11736, 7, 12293, 3, 12321, 15, 12337, 5, 12344, 5, 12353, 86, 12441, 2, 12445, 3, 12449, 90, 12540, 4, 12549, 40, 12593, 94, 12690, 4, 12704, 24, 12784, 16, 12832, 10, 12881, 15, 12928, 10, 12977, 15, 13312, 6582, 19968, 20924, 40960, 1165, 42775, 4, 43008, 40, 43072, 52, 44032, 11172, 63744, 302, 64048, 59, 64112, 106, 64256, 7, 64275, 5, 64285, 12, 64298, 13, 64312, 5, 64318, 1, 64320, 2, 64323, 2, 64326, 108, 64467, 363, 64848, 64, 64914, 54, 65008, 12, 65024, 16, 65056, 4, 65136, 5, 65142, 135, 65296, 10, 65313, 26, 65345, 26, 65382, 89, 65474, 6, 65482, 6, 65490, 6];
controlCharacterSet = [0, 32, 127, 33, 173, 1, 1536, 4, 1757, 1, 1807, 1, 6068, 2, 8203, 5, 8234, 5, 8288, 4, 8298, 6, 65279, 1];
decimalDigitCharacterSet = [48, 10, 1632, 10, 1776, 10, 1984, 10, 2406, 10, 2534, 10, 2662, 10, 2790, 10, 2918, 10, 3046, 10, 3174, 10, 3302, 10, 3430, 10, 3664, 10, 3792, 10, 3872, 10, 4160, 10, 6112, 10, 6160, 10, 6470, 10, 6608, 10, 6992, 10];
decomposableCharacterSet = [192, 6, 199, 9, 209, 6, 217, 5, 224, 6, 231, 9, 241, 6, 249, 5, 255, 17, 274, 20, 296, 9, 308, 4, 313, 6, 323, 6, 332, 6, 340, 18, 360, 23, 416, 2, 431, 2, 461, 16, 478, 6, 486, 11, 500, 2, 504, 36, 542, 2, 550, 14, 832, 2, 835, 2, 884, 1, 894, 1, 901, 6, 908, 1, 910, 3, 938, 7, 970, 5, 979, 2, 1024, 2, 1027, 1, 1031, 1, 1036, 3, 1049, 1, 1081, 1, 1104, 2, 1107, 1, 1111, 1, 1116, 3, 1142, 2, 1217, 2, 1232, 4, 1238, 2, 1242, 6, 1250, 6, 1258, 12, 1272, 2, 1570, 5, 1728, 1, 1730, 1, 1747, 1, 2345, 1, 2353, 1, 2356, 1, 2392, 8, 2507, 2, 2524, 2, 2527, 1, 2611, 1, 2614, 1, 2649, 3, 2654, 1, 2888, 1, 2891, 2, 2908, 2, 2964, 1, 3018, 3, 3144, 1, 3264, 1, 3271, 2, 3274, 2, 3402, 3, 3546, 1, 3548, 3, 3907, 1, 3917, 1, 3922, 1, 3927, 1, 3932, 1, 3945, 1, 3955, 1, 3957, 2, 3960, 1, 3969, 1, 3987, 1, 3997, 1, 4002, 1, 4007, 1, 4012, 1, 4025, 1, 4134, 1, 6918, 1, 6920, 1, 6922, 1, 6924, 1, 6926, 1, 6930, 1, 6971, 1, 6973, 1, 6976, 2, 6979, 1, 7680, 154, 7835, 1, 7840, 90, 7936, 22, 7960, 6, 7968, 38, 8008, 6, 8016, 8, 8025, 1, 8027, 1, 8029, 1, 8031, 31, 8064, 53, 8118, 7, 8126, 1, 8129, 4, 8134, 14, 8150, 6, 8157, 19, 8178, 3, 8182, 8, 8192, 2, 8486, 1, 8490, 2, 8602, 2, 8622, 1, 8653, 3, 8708, 1, 8713, 1, 8716, 1, 8740, 1, 8742, 1, 8769, 1, 8772, 1, 8775, 1, 8777, 1, 8800, 1, 8802, 1, 8813, 5, 8820, 2, 8824, 2, 8832, 2, 8836, 2, 8840, 2, 8876, 4, 8928, 4, 8938, 4, 9001, 2, 10972, 1, 12364, 1, 12366, 1, 12368, 1, 12370, 1, 12372, 1, 12374, 1, 12376, 1, 12378, 1, 12380, 1, 12382, 1, 12384, 1, 12386, 1, 12389, 1, 12391, 1, 12393, 1, 12400, 2, 12403, 2, 12406, 2, 12409, 2, 12412, 2, 12436, 1, 12446, 1, 12460, 1, 12462, 1, 12464, 1, 12466, 1, 12468, 1, 12470, 1, 12472, 1, 12474, 1, 12476, 1, 12478, 1, 12480, 1, 12482, 1, 12485, 1, 12487, 1, 12489, 1, 12496, 2, 12499, 2, 12502, 2, 12505, 2, 12508, 2, 12532, 1, 12535, 4, 12542, 1, 44032, 11172, 63744, 270, 64016, 1, 64018, 1, 64021, 10, 64032, 1, 64034, 1, 64037, 2, 64042, 4, 64048, 59, 64112, 106, 64285, 1, 64287, 1, 64298, 13, 64312, 5, 64318, 1, 64320, 2, 64323, 2];
illegalCharacterSet = [880, 4, 886, 4, 895, 5, 907, 1, 909, 1, 930, 1, 975, 1, 1159, 1, 1300, 29, 1367, 2, 1376, 1, 1416, 1, 1419, 6, 1480, 8, 1515, 5, 1525, 11, 1540, 7, 1558, 5, 1564, 2, 1568, 1, 1595, 5, 1631, 1, 1806, 1, 1867, 2, 1902, 18, 1970, 14, 2043, 262, 2362, 2, 2382, 2, 2389, 3, 2417, 10, 2432, 1, 2436, 1, 2445, 2, 2449, 2, 2473, 1, 2481, 1, 2483, 3, 2490, 2, 2501, 2, 2505, 2, 2511, 8, 2520, 4, 2526, 1, 2532, 2, 2555, 6, 2564, 1, 2571, 4, 2577, 2, 2601, 1, 2609, 1, 2612, 1, 2615, 1, 2618, 2, 2621, 1, 2627, 4, 2633, 2, 2638, 11, 2653, 1, 2655, 7, 2677, 12, 2692, 1, 2702, 1, 2706, 1, 2729, 1, 2737, 1, 2740, 1, 2746, 2, 2758, 1, 2762, 1, 2766, 2, 2769, 15, 2788, 2, 2800, 1, 2802, 15, 2820, 1, 2829, 2, 2833, 2, 2857, 1, 2865, 1, 2868, 1, 2874, 2, 2884, 3, 2889, 2, 2894, 8, 2904, 4, 2910, 1, 2914, 4, 2930, 16, 2948, 1, 2955, 3, 2961, 1, 2966, 3, 2971, 1, 2973, 1, 2976, 3, 2981, 3, 2987, 3, 3002, 4, 3011, 3, 3017, 1, 3022, 9, 3032, 14, 3067, 6, 3076, 1, 3085, 1, 3089, 1, 3113, 1, 3124, 1, 3130, 4, 3141, 1, 3145, 1, 3150, 7, 3159, 9, 3170, 4, 3184, 18, 3204, 1, 3213, 1, 3217, 1, 3241, 1, 3252, 1, 3258, 2, 3269, 1, 3273, 1, 3278, 7, 3287, 7, 3295, 1, 3300, 2, 3312, 1, 3315, 15, 3332, 1, 3341, 1, 3345, 1, 3369, 1, 3386, 4, 3396, 2, 3401, 1, 3406, 9, 3416, 8, 3426, 4, 3440, 18, 3460, 1, 3479, 3, 3506, 1, 3516, 1, 3518, 2, 3527, 3, 3531, 4, 3541, 1, 3543, 1, 3552, 18, 3573, 12, 3643, 4, 3676, 37, 3715, 1, 3717, 2, 3721, 1, 3723, 2, 3726, 6, 3736, 1, 3744, 1, 3748, 1, 3750, 1, 3752, 2, 3756, 1, 3770, 1, 3774, 2, 3781, 1, 3783, 1, 3790, 2, 3802, 2, 3806, 34, 3912, 1, 3947, 6, 3980, 4, 3992, 1, 4029, 1, 4045, 2, 4050, 46, 4130, 1, 4136, 1, 4139, 1, 4147, 3, 4154, 6, 4186, 70, 4294, 10, 4349, 3, 4442, 5, 4515, 5, 4602, 6, 4681, 1, 4686, 2, 4695, 1, 4697, 1, 4702, 2, 4745, 1, 4750, 2, 4785, 1, 4790, 2, 4799, 1, 4801, 1, 4806, 2, 4823, 1, 4881, 1, 4886, 2, 4955, 4, 4989, 3, 5018, 6, 5109, 12, 5751, 9, 5789, 3, 5873, 15, 5901, 1, 5909, 11, 5943, 9, 5972, 12, 5997, 1, 6001, 1, 6004, 12, 6110, 2, 6122, 6, 6138, 6, 6159, 1, 6170, 6, 6264, 8, 6314, 86, 6429, 3, 6444, 4, 6460, 4, 6465, 3, 6510, 2, 6517, 11, 6570, 6, 6602, 6, 6618, 4, 6684, 2, 6688, 224, 6988, 4, 7037, 387, 7627, 51, 7836, 4, 7930, 6, 7958, 2, 7966, 2, 8006, 2, 8014, 2, 8024, 1, 8026, 1, 8028, 1, 8030, 1, 8062, 2, 8117, 1, 8133, 1, 8148, 2, 8156, 1, 8176, 2, 8181, 1, 8191, 1, 8292, 6, 8306, 2, 8335, 1, 8341, 11, 8374, 26, 8432, 16, 8527, 4, 8581, 11, 9192, 24, 9255, 25, 9291, 21, 9885, 3, 9907, 78, 9989, 1, 9994, 2, 10024, 1, 10060, 1, 10062, 1, 10067, 3, 10071, 1, 10079, 2, 10133, 3, 10160, 1, 10175, 1, 10187, 5, 10220, 4, 11035, 5, 11044, 220, 11311, 1, 11359, 1, 11373, 7, 11384, 8, 11499, 14, 11558, 10, 11622, 9, 11632, 16, 11671, 9, 11687, 1, 11695, 1, 11703, 1, 11711, 1, 11719, 1, 11727, 1, 11735, 1, 11743, 33, 11800, 4, 11806, 98, 11930, 1, 12020, 12, 12246, 26, 12284, 4, 12352, 1, 12439, 2, 12544, 5, 12589, 4, 12687, 1, 12728, 8, 12752, 32, 12831, 1, 12868, 12, 13055, 1, 19894, 10, 40892, 68, 42125, 3, 42183, 569, 42779, 5, 42786, 222, 43052, 20, 43128, 904, 55204, 92, 64046, 2, 64107, 5, 64218, 38, 64263, 12, 64280, 5, 64311, 1, 64317, 1, 64319, 1, 64322, 1, 64325, 1, 64434, 33, 64832, 16, 64912, 2, 64968, 40, 65022, 2, 65050, 6, 65060, 12, 65107, 1, 65127, 1, 65132, 4, 65141, 1, 65277, 2, 65280, 1, 65471, 3, 65480, 2, 65488, 2, 65496, 2, 65501, 3, 65511, 1, 65519, 10];
letterCharacterSet = [65, 26, 97, 26, 170, 1, 181, 1, 186, 1, 192, 23, 216, 31, 248, 458, 710, 12, 736, 5, 750, 1, 768, 112, 890, 4, 902, 1, 904, 3, 908, 1, 910, 20, 931, 44, 976, 38, 1015, 139, 1155, 4, 1160, 140, 1329, 38, 1369, 1, 1377, 39, 1425, 45, 1471, 1, 1473, 2, 1476, 2, 1479, 1, 1488, 27, 1520, 3, 1552, 6, 1569, 26, 1600, 31, 1646, 102, 1749, 8, 1758, 11, 1770, 6, 1786, 3, 1791, 1, 1808, 59, 1869, 33, 1920, 50, 1994, 44, 2042, 1, 2305, 57, 2364, 18, 2384, 5, 2392, 12, 2427, 5, 2433, 3, 2437, 8, 2447, 2, 2451, 22, 2474, 7, 2482, 1, 2486, 4, 2492, 9, 2503, 2, 2507, 4, 2519, 1, 2524, 2, 2527, 5, 2544, 2, 2561, 3, 2565, 6, 2575, 2, 2579, 22, 2602, 7, 2610, 2, 2613, 2, 2616, 2, 2620, 1, 2622, 5, 2631, 2, 2635, 3, 2649, 4, 2654, 1, 2672, 5, 2689, 3, 2693, 9, 2703, 3, 2707, 22, 2730, 7, 2738, 2, 2741, 5, 2748, 10, 2759, 3, 2763, 3, 2768, 1, 2784, 4, 2817, 3, 2821, 8, 2831, 2, 2835, 22, 2858, 7, 2866, 2, 2869, 5, 2876, 8, 2887, 2, 2891, 3, 2902, 2, 2908, 2, 2911, 3, 2929, 1, 2946, 2, 2949, 6, 2958, 3, 2962, 4, 2969, 2, 2972, 1, 2974, 2, 2979, 2, 2984, 3, 2990, 12, 3006, 5, 3014, 3, 3018, 4, 3031, 1, 3073, 3, 3077, 8, 3086, 3, 3090, 23, 3114, 10, 3125, 5, 3134, 7, 3142, 3, 3146, 4, 3157, 2, 3168, 2, 3202, 2, 3205, 8, 3214, 3, 3218, 23, 3242, 10, 3253, 5, 3260, 9, 3270, 3, 3274, 4, 3285, 2, 3294, 1, 3296, 4, 3330, 2, 3333, 8, 3342, 3, 3346, 23, 3370, 16, 3390, 6, 3398, 3, 3402, 4, 3415, 1, 3424, 2, 3458, 2, 3461, 18, 3482, 24, 3507, 9, 3517, 1, 3520, 7, 3530, 1, 3535, 6, 3542, 1, 3544, 8, 3570, 2, 3585, 58, 3648, 15, 3713, 2, 3716, 1, 3719, 2, 3722, 1, 3725, 1, 3732, 4, 3737, 7, 3745, 3, 3749, 1, 3751, 1, 3754, 2, 3757, 13, 3771, 3, 3776, 5, 3782, 1, 3784, 6, 3804, 2, 3840, 1, 3864, 2, 3893, 1, 3895, 1, 3897, 1, 3902, 10, 3913, 34, 3953, 20, 3974, 6, 3984, 8, 3993, 36, 4038, 1, 4096, 34, 4131, 5, 4137, 2, 4140, 7, 4150, 4, 4176, 10, 4256, 38, 4304, 43, 4348, 1, 4352, 90, 4447, 68, 4520, 82, 4608, 73, 4682, 4, 4688, 7, 4696, 1, 4698, 4, 4704, 41, 4746, 4, 4752, 33, 4786, 4, 4792, 7, 4800, 1, 4802, 4, 4808, 15, 4824, 57, 4882, 4, 4888, 67, 4959, 1, 4992, 16, 5024, 85, 5121, 620, 5743, 8, 5761, 26, 5792, 75, 5888, 13, 5902, 7, 5920, 21, 5952, 20, 5984, 13, 5998, 3, 6002, 2, 6016, 52, 6070, 30, 6103, 1, 6108, 2, 6155, 3, 6176, 88, 6272, 42, 6400, 29, 6432, 12, 6448, 12, 6480, 30, 6512, 5, 6528, 42, 6576, 26, 6656, 28, 6912, 76, 7019, 9, 7424, 203, 7678, 158, 7840, 90, 7936, 22, 7960, 6, 7968, 38, 8008, 6, 8016, 8, 8025, 1, 8027, 1, 8029, 1, 8031, 31, 8064, 53, 8118, 7, 8126, 1, 8130, 3, 8134, 7, 8144, 4, 8150, 6, 8160, 13, 8178, 3, 8182, 7, 8305, 1, 8319, 1, 8336, 5, 8400, 32, 8450, 1, 8455, 1, 8458, 10, 8469, 1, 8473, 5, 8484, 1, 8486, 1, 8488, 1, 8490, 4, 8495, 11, 8508, 4, 8517, 5, 8526, 1, 8579, 2, 11264, 47, 11312, 47, 11360, 13, 11380, 4, 11392, 101, 11520, 38, 11568, 54, 11631, 1, 11648, 23, 11680, 7, 11688, 7, 11696, 7, 11704, 7, 11712, 7, 11720, 7, 11728, 7, 11736, 7, 12293, 2, 12330, 6, 12337, 5, 12347, 2, 12353, 86, 12441, 2, 12445, 3, 12449, 90, 12540, 4, 12549, 40, 12593, 94, 12704, 24, 12784, 16, 13312, 6582, 19968, 20924, 40960, 1165, 42775, 4, 43008, 40, 43072, 52, 44032, 11172, 63744, 302, 64048, 59, 64112, 106, 64256, 7, 64275, 5, 64285, 12, 64298, 13, 64312, 5, 64318, 1, 64320, 2, 64323, 2, 64326, 108, 64467, 363, 64848, 64, 64914, 54, 65008, 12, 65024, 16, 65056, 4, 65136, 5, 65142, 135, 65313, 26, 65345, 26, 65382, 89, 65474, 6, 65482, 6, 65490, 6];
lowercaseLetterCharacterSet = [97, 26, 170, 1, 181, 1, 186, 1, 223, 24, 248, 8, 257, 1, 259, 1, 261, 1, 263, 1, 265, 1, 267, 1, 269, 1, 271, 1, 273, 1, 275, 1, 277, 1, 279, 1, 281, 1, 283, 1, 285, 1, 287, 1, 289, 1, 291, 1, 293, 1, 295, 1, 297, 1, 299, 1, 301, 1, 303, 1, 305, 1, 307, 1, 309, 1, 311, 2, 314, 1, 316, 1, 318, 1, 320, 1, 322, 1, 324, 1, 326, 1, 328, 2, 331, 1, 333, 1, 335, 1, 337, 1, 339, 1, 341, 1, 343, 1, 345, 1, 347, 1, 349, 1, 351, 1, 353, 1, 355, 1, 357, 1, 359, 1, 361, 1, 363, 1, 365, 1, 367, 1, 369, 1, 371, 1, 373, 1, 375, 1, 378, 1, 380, 1, 382, 3, 387, 1, 389, 1, 392, 1, 396, 2, 402, 1, 405, 1, 409, 3, 414, 1, 417, 1, 419, 1, 421, 1, 424, 1, 426, 2, 429, 1, 432, 1, 436, 1, 438, 1, 441, 2, 445, 3, 454, 1, 457, 1, 460, 1, 462, 1, 464, 1, 466, 1, 468, 1, 470, 1, 472, 1, 474, 1, 476, 2, 479, 1, 481, 1, 483, 1, 485, 1, 487, 1, 489, 1, 491, 1, 493, 1, 495, 2, 499, 1, 501, 1, 505, 1, 507, 1, 509, 1, 511, 1, 513, 1, 515, 1, 517, 1, 519, 1, 521, 1, 523, 1, 525, 1, 527, 1, 529, 1, 531, 1, 533, 1, 535, 1, 537, 1, 539, 1, 541, 1, 543, 1, 545, 1, 547, 1, 549, 1, 551, 1, 553, 1, 555, 1, 557, 1, 559, 1, 561, 1, 563, 7, 572, 1, 575, 2, 578, 1, 583, 1, 585, 1, 587, 1, 589, 1, 591, 69, 661, 27, 891, 3, 912, 1, 940, 35, 976, 2, 981, 3, 985, 1, 987, 1, 989, 1, 991, 1, 993, 1, 995, 1, 997, 1, 999, 1, 1001, 1, 1003, 1, 1005, 1, 1007, 5, 1013, 1, 1016, 1, 1019, 2, 1072, 48, 1121, 1, 1123, 1, 1125, 1, 1127, 1, 1129, 1, 1131, 1, 1133, 1, 1135, 1, 1137, 1, 1139, 1, 1141, 1, 1143, 1, 1145, 1, 1147, 1, 1149, 1, 1151, 1, 1153, 1, 1163, 1, 1165, 1, 1167, 1, 1169, 1, 1171, 1, 1173, 1, 1175, 1, 1177, 1, 1179, 1, 1181, 1, 1183, 1, 1185, 1, 1187, 1, 1189, 1, 1191, 1, 1193, 1, 1195, 1, 1197, 1, 1199, 1, 1201, 1, 1203, 1, 1205, 1, 1207, 1, 1209, 1, 1211, 1, 1213, 1, 1215, 1, 1218, 1, 1220, 1, 1222, 1, 1224, 1, 1226, 1, 1228, 1, 1230, 2, 1233, 1, 1235, 1, 1237, 1, 1239, 1, 1241, 1, 1243, 1, 1245, 1, 1247, 1, 1249, 1, 1251, 1, 1253, 1, 1255, 1, 1257, 1, 1259, 1, 1261, 1, 1263, 1, 1265, 1, 1267, 1, 1269, 1, 1271, 1, 1273, 1, 1275, 1, 1277, 1, 1279, 1, 1281, 1, 1283, 1, 1285, 1, 1287, 1, 1289, 1, 1291, 1, 1293, 1, 1295, 1, 1297, 1, 1299, 1, 1377, 39, 7424, 44, 7522, 22, 7545, 34, 7681, 1, 7683, 1, 7685, 1, 7687, 1, 7689, 1, 7691, 1, 7693, 1, 7695, 1, 7697, 1, 7699, 1, 7701, 1, 7703, 1, 7705, 1, 7707, 1, 7709, 1, 7711, 1, 7713, 1, 7715, 1, 7717, 1, 7719, 1, 7721, 1, 7723, 1, 7725, 1, 7727, 1, 7729, 1, 7731, 1, 7733, 1, 7735, 1, 7737, 1, 7739, 1, 7741, 1, 7743, 1, 7745, 1, 7747, 1, 7749, 1, 7751, 1, 7753, 1, 7755, 1, 7757, 1, 7759, 1, 7761, 1, 7763, 1, 7765, 1, 7767, 1, 7769, 1, 7771, 1, 7773, 1, 7775, 1, 7777, 1, 7779, 1, 7781, 1, 7783, 1, 7785, 1, 7787, 1, 7789, 1, 7791, 1, 7793, 1, 7795, 1, 7797, 1, 7799, 1, 7801, 1, 7803, 1, 7805, 1, 7807, 1, 7809, 1, 7811, 1, 7813, 1, 7815, 1, 7817, 1, 7819, 1, 7821, 1, 7823, 1, 7825, 1, 7827, 1, 7829, 7, 7841, 1, 7843, 1, 7845, 1, 7847, 1, 7849, 1, 7851, 1, 7853, 1, 7855, 1, 7857, 1, 7859, 1, 7861, 1, 7863, 1, 7865, 1, 7867, 1, 7869, 1, 7871, 1, 7873, 1, 7875, 1, 7877, 1, 7879, 1, 7881, 1, 7883, 1, 7885, 1, 7887, 1, 7889, 1, 7891, 1, 7893, 1, 7895, 1, 7897, 1, 7899, 1, 7901, 1, 7903, 1, 7905, 1, 7907, 1, 7909, 1, 7911, 1, 7913, 1, 7915, 1, 7917, 1, 7919, 1, 7921, 1, 7923, 1, 7925, 1, 7927, 1, 7929, 1, 7936, 8, 7952, 6, 7968, 8, 7984, 8, 8000, 6, 8016, 8, 8032, 8, 8048, 14, 8064, 8, 8080, 8, 8096, 8, 8112, 5, 8118, 2, 8126, 1, 8130, 3, 8134, 2, 8144, 4, 8150, 2, 8160, 8, 8178, 3, 8182, 2, 8305, 1, 8319, 1, 8458, 1, 8462, 2, 8467, 1, 8495, 1, 8500, 1, 8505, 1, 8508, 2, 8518, 4, 8526, 1, 8580, 1, 11312, 47, 11361, 1, 11365, 2, 11368, 1, 11370, 1, 11372, 1, 11380, 1, 11382, 2, 11393, 1, 11395, 1, 11397, 1, 11399, 1, 11401, 1, 11403, 1, 11405, 1, 11407, 1, 11409, 1, 11411, 1, 11413, 1, 11415, 1, 11417, 1, 11419, 1, 11421, 1, 11423, 1, 11425, 1, 11427, 1, 11429, 1, 11431, 1, 11433, 1, 11435, 1, 11437, 1, 11439, 1, 11441, 1, 11443, 1, 11445, 1, 11447, 1, 11449, 1, 11451, 1, 11453, 1, 11455, 1, 11457, 1, 11459, 1, 11461, 1, 11463, 1, 11465, 1, 11467, 1, 11469, 1, 11471, 1, 11473, 1, 11475, 1, 11477, 1, 11479, 1, 11481, 1, 11483, 1, 11485, 1, 11487, 1, 11489, 1, 11491, 2, 11520, 38, 64256, 7, 64275, 5];
nonBaseCharacterSet = [768, 112, 1155, 4, 1160, 2, 1425, 45, 1471, 1, 1473, 2, 1476, 2, 1479, 1, 1552, 6, 1611, 20, 1648, 1, 1750, 7, 1758, 7, 1767, 2, 1770, 4, 1809, 1, 1840, 27, 1958, 11, 2027, 9, 2305, 3, 2364, 1, 2366, 16, 2385, 4, 2402, 2, 2433, 3, 2492, 1, 2494, 7, 2503, 2, 2507, 3, 2519, 1, 2530, 2, 2561, 3, 2620, 1, 2622, 5, 2631, 2, 2635, 3, 2672, 2, 2689, 3, 2748, 1, 2750, 8, 2759, 3, 2763, 3, 2786, 2, 2817, 3, 2876, 1, 2878, 6, 2887, 2, 2891, 3, 2902, 2, 2946, 1, 3006, 5, 3014, 3, 3018, 4, 3031, 1, 3073, 3, 3134, 7, 3142, 3, 3146, 4, 3157, 2, 3202, 2, 3260, 1, 3262, 7, 3270, 3, 3274, 4, 3285, 2, 3298, 2, 3330, 2, 3390, 6, 3398, 3, 3402, 4, 3415, 1, 3458, 2, 3530, 1, 3535, 6, 3542, 1, 3544, 8, 3570, 2, 3633, 1, 3636, 7, 3655, 8, 3761, 1, 3764, 6, 3771, 2, 3784, 6, 3864, 2, 3893, 1, 3895, 1, 3897, 1, 3902, 2, 3953, 20, 3974, 2, 3984, 8, 3993, 36, 4038, 1, 4140, 7, 4150, 4, 4182, 4, 4959, 1, 5906, 3, 5938, 3, 5970, 2, 6002, 2, 6070, 30, 6109, 1, 6155, 3, 6313, 1, 6432, 12, 6448, 12, 6576, 17, 6600, 2, 6679, 5, 6912, 5, 6964, 17, 7019, 9, 7616, 11, 7678, 2, 8400, 32, 12330, 6, 12441, 2, 43010, 1, 43014, 1, 43019, 1, 43043, 5, 64286, 1, 65024, 16];
punctuationCharacterSet = [33, 3, 37, 6, 44, 4, 58, 2, 63, 2, 91, 3, 95, 1, 123, 1, 125, 1, 161, 1, 171, 1, 183, 1, 187, 1, 191, 1, 894, 1, 903, 1, 1370, 6, 1417, 2, 1470, 1, 1472, 1, 1475, 1, 1478, 1, 1523, 2, 1548, 2, 1563, 1, 1566, 2, 1642, 4, 1748, 1, 1792, 14, 2039, 3, 2404, 2, 2416, 1, 3572, 1, 3663, 1, 3674, 2, 3844, 15, 3898, 4, 3973, 1, 4048, 2, 4170, 6, 4347, 1, 4961, 8, 5741, 2, 5787, 2, 5867, 3, 5941, 2, 6100, 3, 6104, 3, 6144, 11, 6468, 2, 6622, 2, 6686, 2, 7002, 7, 8208, 24, 8240, 20, 8261, 13, 8275, 12, 8317, 2, 8333, 2, 9001, 2, 10088, 14, 10181, 2, 10214, 6, 10627, 22, 10712, 4, 10748, 2, 11513, 4, 11518, 2, 11776, 24, 11804, 2, 12289, 3, 12296, 10, 12308, 12, 12336, 1, 12349, 1, 12448, 1, 12539, 1, 43124, 4, 64830, 2, 65040, 10, 65072, 35, 65108, 14, 65123, 1, 65128, 1, 65130, 2, 65281, 3, 65285, 6, 65292, 4, 65306, 2, 65311, 2, 65339, 3, 65343, 1, 65371, 1, 65373, 1];
uppercaseLetterCharacterSet = [65, 26, 192, 23, 216, 7, 256, 1, 258, 1, 260, 1, 262, 1, 264, 1, 266, 1, 268, 1, 270, 1, 272, 1, 274, 1, 276, 1, 278, 1, 280, 1, 282, 1, 284, 1, 286, 1, 288, 1, 290, 1, 292, 1, 294, 1, 296, 1, 298, 1, 300, 1, 302, 1, 304, 1, 306, 1, 308, 1, 310, 1, 313, 1, 315, 1, 317, 1, 319, 1, 321, 1, 323, 1, 325, 1, 327, 1, 330, 1, 332, 1, 334, 1, 336, 1, 338, 1, 340, 1, 342, 1, 344, 1, 346, 1, 348, 1, 350, 1, 352, 1, 354, 1, 356, 1, 358, 1, 360, 1, 362, 1, 364, 1, 366, 1, 368, 1, 370, 1, 372, 1, 374, 1, 376, 2, 379, 1, 381, 1, 385, 2, 388, 1, 390, 2, 393, 3, 398, 4, 403, 2, 406, 3, 412, 2, 415, 2, 418, 1, 420, 1, 422, 2, 425, 1, 428, 1, 430, 2, 433, 3, 437, 1, 439, 2, 444, 1, 452, 2, 455, 2, 458, 2, 461, 1, 463, 1, 465, 1, 467, 1, 469, 1, 471, 1, 473, 1, 475, 1, 478, 1, 480, 1, 482, 1, 484, 1, 486, 1, 488, 1, 490, 1, 492, 1, 494, 1, 497, 2, 500, 1, 502, 3, 506, 1, 508, 1, 510, 1, 512, 1, 514, 1, 516, 1, 518, 1, 520, 1, 522, 1, 524, 1, 526, 1, 528, 1, 530, 1, 532, 1, 534, 1, 536, 1, 538, 1, 540, 1, 542, 1, 544, 1, 546, 1, 548, 1, 550, 1, 552, 1, 554, 1, 556, 1, 558, 1, 560, 1, 562, 1, 570, 2, 573, 2, 577, 1, 579, 4, 584, 1, 586, 1, 588, 1, 590, 1, 902, 1, 904, 3, 908, 1, 910, 2, 913, 17, 931, 9, 978, 3, 984, 1, 986, 1, 988, 1, 990, 1, 992, 1, 994, 1, 996, 1, 998, 1, 1000, 1, 1002, 1, 1004, 1, 1006, 1, 1012, 1, 1015, 1, 1017, 2, 1021, 51, 1120, 1, 1122, 1, 1124, 1, 1126, 1, 1128, 1, 1130, 1, 1132, 1, 1134, 1, 1136, 1, 1138, 1, 1140, 1, 1142, 1, 1144, 1, 1146, 1, 1148, 1, 1150, 1, 1152, 1, 1162, 1, 1164, 1, 1166, 1, 1168, 1, 1170, 1, 1172, 1, 1174, 1, 1176, 1, 1178, 1, 1180, 1, 1182, 1, 1184, 1, 1186, 1, 1188, 1, 1190, 1, 1192, 1, 1194, 1, 1196, 1, 1198, 1, 1200, 1, 1202, 1, 1204, 1, 1206, 1, 1208, 1, 1210, 1, 1212, 1, 1214, 1, 1216, 2, 1219, 1, 1221, 1, 1223, 1, 1225, 1, 1227, 1, 1229, 1, 1232, 1, 1234, 1, 1236, 1, 1238, 1, 1240, 1, 1242, 1, 1244, 1, 1246, 1, 1248, 1, 1250, 1, 1252, 1, 1254, 1, 1256, 1, 1258, 1, 1260, 1, 1262, 1, 1264, 1, 1266, 1, 1268, 1, 1270, 1, 1272, 1, 1274, 1, 1276, 1, 1278, 1, 1280, 1, 1282, 1, 1284, 1, 1286, 1, 1288, 1, 1290, 1, 1292, 1, 1294, 1, 1296, 1, 1298, 1, 1329, 38, 4256, 38, 7680, 1, 7682, 1, 7684, 1, 7686, 1, 7688, 1, 7690, 1, 7692, 1, 7694, 1, 7696, 1, 7698, 1, 7700, 1, 7702, 1, 7704, 1, 7706, 1, 7708, 1, 7710, 1, 7712, 1, 7714, 1, 7716, 1, 7718, 1, 7720, 1, 7722, 1, 7724, 1, 7726, 1, 7728, 1, 7730, 1, 7732, 1, 7734, 1, 7736, 1, 7738, 1, 7740, 1, 7742, 1, 7744, 1, 7746, 1, 7748, 1, 7750, 1, 7752, 1, 7754, 1, 7756, 1, 7758, 1, 7760, 1, 7762, 1, 7764, 1, 7766, 1, 7768, 1, 7770, 1, 7772, 1, 7774, 1, 7776, 1, 7778, 1, 7780, 1, 7782, 1, 7784, 1, 7786, 1, 7788, 1, 7790, 1, 7792, 1, 7794, 1, 7796, 1, 7798, 1, 7800, 1, 7802, 1, 7804, 1, 7806, 1, 7808, 1, 7810, 1, 7812, 1, 7814, 1, 7816, 1, 7818, 1, 7820, 1, 7822, 1, 7824, 1, 7826, 1, 7828, 1, 7840, 1, 7842, 1, 7844, 1, 7846, 1, 7848, 1, 7850, 1, 7852, 1, 7854, 1, 7856, 1, 7858, 1, 7860, 1, 7862, 1, 7864, 1, 7866, 1, 7868, 1, 7870, 1, 7872, 1, 7874, 1, 7876, 1, 7878, 1, 7880, 1, 7882, 1, 7884, 1, 7886, 1, 7888, 1, 7890, 1, 7892, 1, 7894, 1, 7896, 1, 7898, 1, 7900, 1, 7902, 1, 7904, 1, 7906, 1, 7908, 1, 7910, 1, 7912, 1, 7914, 1, 7916, 1, 7918, 1, 7920, 1, 7922, 1, 7924, 1, 7926, 1, 7928, 1, 7944, 8, 7960, 6, 7976, 8, 7992, 8, 8008, 6, 8025, 1, 8027, 1, 8029, 1, 8031, 1, 8040, 8, 8072, 8, 8088, 8, 8104, 8, 8120, 5, 8136, 5, 8152, 4, 8168, 5, 8184, 5, 8450, 1, 8455, 1, 8459, 3, 8464, 3, 8469, 1, 8473, 5, 8484, 1, 8486, 1, 8488, 1, 8490, 4, 8496, 4, 8510, 2, 8517, 1, 8579, 1, 11264, 47, 11360, 1, 11362, 3, 11367, 1, 11369, 1, 11371, 1, 11381, 1, 11392, 1, 11394, 1, 11396, 1, 11398, 1, 11400, 1, 11402, 1, 11404, 1, 11406, 1, 11408, 1, 11410, 1, 11412, 1, 11414, 1, 11416, 1, 11418, 1, 11420, 1, 11422, 1, 11424, 1, 11426, 1, 11428, 1, 11430, 1, 11432, 1, 11434, 1, 11436, 1, 11438, 1, 11440, 1, 11442, 1, 11444, 1, 11446, 1, 11448, 1, 11450, 1, 11452, 1, 11454, 1, 11456, 1, 11458, 1, 11460, 1, 11462, 1, 11464, 1, 11466, 1, 11468, 1, 11470, 1, 11472, 1, 11474, 1, 11476, 1, 11478, 1, 11480, 1, 11482, 1, 11484, 1, 11486, 1, 11488, 1, 11490, 1];
whitespaceAndNewlineCharacterSet = [9, 5, 32, 1, 133, 1, 160, 1, 5760, 1, 8192, 12, 8232, 2, 8239, 1, 8287, 1];
whitespaceCharacterSet = [9, 1, 32, 1, 160, 1, 5760, 1, 8192, 12, 8239, 1, 8287, 1];
p;9;CPCoder.jt;2738;@STATIC;1.0;i;13;CPException.ji;10;CPObject.jt;2686;objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPCoder"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("allowsKeyedCoding"), function(self, _cmd)
{
    return NO;
}
,["BOOL"]), new objj_method(sel_getUid("encodeValueOfObjJType:at:"), function(self, _cmd, aType, anObject)
{
    _CPRaiseInvalidAbstractInvocation(self, _cmd);
}
,["void","CPString","id"]), new objj_method(sel_getUid("encodeDataObject:"), function(self, _cmd, aData)
{
    _CPRaiseInvalidAbstractInvocation(self, _cmd);
}
,["void","CPData"]), new objj_method(sel_getUid("encodeObject:"), function(self, _cmd, anObject)
{
}
,["void","id"]), new objj_method(sel_getUid("encodePoint:"), function(self, _cmd, aPoint)
{
    (self.isa.method_msgSend["encodeNumber:"] || _objj_forward)(self, "encodeNumber:", aPoint.x);
    (self.isa.method_msgSend["encodeNumber:"] || _objj_forward)(self, "encodeNumber:", aPoint.y);
}
,["void","CGPoint"]), new objj_method(sel_getUid("encodeRect:"), function(self, _cmd, aRect)
{
    (self.isa.method_msgSend["encodePoint:"] || _objj_forward)(self, "encodePoint:", aRect.origin);
    (self.isa.method_msgSend["encodeSize:"] || _objj_forward)(self, "encodeSize:", aRect.size);
}
,["void","CGRect"]), new objj_method(sel_getUid("encodeSize:"), function(self, _cmd, aSize)
{
    (self.isa.method_msgSend["encodeNumber:"] || _objj_forward)(self, "encodeNumber:", aSize.width);
    (self.isa.method_msgSend["encodeNumber:"] || _objj_forward)(self, "encodeNumber:", aSize.height);
}
,["void","CGSize"]), new objj_method(sel_getUid("encodePropertyList:"), function(self, _cmd, aPropertyList)
{
}
,["void","id"]), new objj_method(sel_getUid("encodeRootObject:"), function(self, _cmd, anObject)
{
    (self.isa.method_msgSend["encodeObject:"] || _objj_forward)(self, "encodeObject:", anObject);
}
,["void","id"]), new objj_method(sel_getUid("encodeBycopyObject:"), function(self, _cmd, anObject)
{
    (self.isa.method_msgSend["encodeObject:"] || _objj_forward)(self, "encodeObject:", anObject);
}
,["void","id"]), new objj_method(sel_getUid("encodeConditionalObject:"), function(self, _cmd, anObject)
{
    (self.isa.method_msgSend["encodeObject:"] || _objj_forward)(self, "encodeObject:", anObject);
}
,["void","id"])]);
}{
var the_class = objj_getClass("CPObject")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPObject\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("awakeAfterUsingCoder:"), function(self, _cmd, aDecoder)
{
    return self;
}
,["id","CPCoder"])]);
}p;14;CPCountedSet.jt;2057;@STATIC;1.0;i;10;CPObject.ji;23;_CPConcreteMutableSet.jt;1995;objj_executeFile("CPObject.j", YES);objj_executeFile("_CPConcreteMutableSet.j", YES);{var the_class = objj_allocateClassPair(_CPConcreteMutableSet, "CPCountedSet"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_counts", "Object")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("addObject:"), function(self, _cmd, anObject)
{
    if (!self._counts)
        self._counts = {};
    (objj_getClass("CPCountedSet").super_class.method_dtable["addObject:"] || _objj_forward)(self, "addObject:", anObject);
    var UID = (anObject == null ? null : (anObject.isa.method_msgSend["UID"] || _objj_forward)(anObject, "UID"));
    if (self._counts[UID] === undefined)
        self._counts[UID] = 1;
    else
        ++self._counts[UID];
}
,["void","id"]), new objj_method(sel_getUid("removeObject:"), function(self, _cmd, anObject)
{
    if (!self._counts)
        return;
    var UID = (anObject == null ? null : (anObject.isa.method_msgSend["UID"] || _objj_forward)(anObject, "UID"));
    if (self._counts[UID] === undefined)
        return;
    else
    {
        --self._counts[UID];
        if (self._counts[UID] === 0)
        {
            delete self._counts[UID];
            (objj_getClass("CPCountedSet").super_class.method_dtable["removeObject:"] || _objj_forward)(self, "removeObject:", anObject);
        }
    }
}
,["void","id"]), new objj_method(sel_getUid("removeAllObjects"), function(self, _cmd)
{
    (objj_getClass("CPCountedSet").super_class.method_dtable["removeAllObjects"] || _objj_forward)(self, "removeAllObjects");
    self._counts = {};
}
,["void"]), new objj_method(sel_getUid("countForObject:"), function(self, _cmd, anObject)
{
    if (!self._counts)
        self._counts = {};
    var UID = (anObject == null ? null : (anObject.isa.method_msgSend["UID"] || _objj_forward)(anObject, "UID"));
    if (self._counts[UID] === undefined)
        return 0;
    return self._counts[UID];
}
,["unsigned","id"])]);
}p;8;CPData.jt;7618;@STATIC;1.0;i;10;CPObject.ji;10;CPString.jt;7569;objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPData"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithRawString:"), function(self, _cmd, aString)
{
    self = (objj_getClass("CPData").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        (self == null ? null : (self.isa.method_msgSend["setRawString:"] || _objj_forward)(self, "setRawString:", aString));
    return self;
}
,["id","CPString"]), new objj_method(sel_getUid("initWithPlistObject:"), function(self, _cmd, aPlistObject)
{
    self = (objj_getClass("CPData").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        (self == null ? null : (self.isa.method_msgSend["setPlistObject:"] || _objj_forward)(self, "setPlistObject:", aPlistObject));
    return self;
}
,["id","id"]), new objj_method(sel_getUid("initWithPlistObject:format:"), function(self, _cmd, aPlistObject, aFormat)
{
    self = (objj_getClass("CPData").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        (self == null ? null : (self.isa.method_msgSend["setPlistObject:format:"] || _objj_forward)(self, "setPlistObject:format:", aPlistObject, aFormat));
    return self;
}
,["id","id","id"]), new objj_method(sel_getUid("initWithJSONObject:"), function(self, _cmd, anObject)
{
    self = (objj_getClass("CPData").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        (self == null ? null : (self.isa.method_msgSend["setJSONObject:"] || _objj_forward)(self, "setJSONObject:", anObject));
    return self;
}
,["id","Object"]), new objj_method(sel_getUid("rawString"), function(self, _cmd)
{
    return self.rawString();
}
,["CPString"]), new objj_method(sel_getUid("plistObject"), function(self, _cmd)
{
    return self.propertyList();
}
,["id"]), new objj_method(sel_getUid("JSONObject"), function(self, _cmd)
{
    return self.JSONObject();
}
,["Object"]), new objj_method(sel_getUid("bytes"), function(self, _cmd)
{
    return self.bytes();
}
,["CPArray"]), new objj_method(sel_getUid("base64"), function(self, _cmd)
{
    return self.base64();
}
,["CPString"]), new objj_method(sel_getUid("length"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["rawString"] || _objj_forward)(self, "rawString")), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
    var ___r1;
}
,["int"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return self.toString();
}
,["CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    var result = new CFMutableData();
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["id"]), new objj_method(sel_getUid("data"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    var ___r1;
}
,["CPData"]), new objj_method(sel_getUid("dataWithRawString:"), function(self, _cmd, aString)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithRawString:"] || _objj_forward)(___r1, "initWithRawString:", aString));
    var ___r1;
}
,["CPData","CPString"]), new objj_method(sel_getUid("dataWithPlistObject:"), function(self, _cmd, aPlistObject)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithPlistObject:"] || _objj_forward)(___r1, "initWithPlistObject:", aPlistObject));
    var ___r1;
}
,["CPData","id"]), new objj_method(sel_getUid("dataWithPlistObject:format:"), function(self, _cmd, aPlistObject, aFormat)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithPlistObject:format:"] || _objj_forward)(___r1, "initWithPlistObject:format:", aPlistObject, aFormat));
    var ___r1;
}
,["CPData","id","CPPropertyListFormat"]), new objj_method(sel_getUid("dataWithJSONObject:"), function(self, _cmd, anObject)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithJSONObject:"] || _objj_forward)(___r1, "initWithJSONObject:", anObject));
    var ___r1;
}
,["CPData","Object"]), new objj_method(sel_getUid("dataWithBytes:"), function(self, _cmd, bytesArray)
{
    var data = ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    data.setBytes(bytesArray);
    return data;
    var ___r1;
}
,["CPData","CPArray"]), new objj_method(sel_getUid("dataWithBase64:"), function(self, _cmd, aString)
{
    var data = ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    data.setBase64String(aString);
    return data;
    var ___r1;
}
,["CPData","CPString"])]);
}{
var the_class = objj_getClass("CPData")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPData\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("setRawString:"), function(self, _cmd, aString)
{
    self.setRawString(aString);
}
,["void","CPString"]), new objj_method(sel_getUid("setPlistObject:"), function(self, _cmd, aPlistObject)
{
    self.setPropertyList(aPlistObject);
}
,["void","id"]), new objj_method(sel_getUid("setPlistObject:format:"), function(self, _cmd, aPlistObject, aFormat)
{
    self.setPropertyList(aPlistObject, aFormat);
}
,["void","id","CPPropertyListFormat"]), new objj_method(sel_getUid("setJSONObject:"), function(self, _cmd, anObject)
{
    self.setJSONObject(anObject);
}
,["void","Object"])]);
}{
var the_class = objj_getClass("CPData")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPData\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithString:"), function(self, _cmd, aString)
{
    _CPReportLenientDeprecation(self, _cmd, sel_getUid("initWithRawString:"));
    return (self.isa.method_msgSend["initWithRawString:"] || _objj_forward)(self, "initWithRawString:", aString);
}
,["id","CPString"]), new objj_method(sel_getUid("setString:"), function(self, _cmd, aString)
{
    _CPReportLenientDeprecation(self, _cmd, sel_getUid("setRawString:"));
    (self.isa.method_msgSend["setRawString:"] || _objj_forward)(self, "setRawString:", aString);
}
,["void","CPString"]), new objj_method(sel_getUid("string"), function(self, _cmd)
{
    _CPReportLenientDeprecation(self, _cmd, sel_getUid("rawString"));
    return (self.isa.method_msgSend["rawString"] || _objj_forward)(self, "rawString");
}
,["CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("dataWithString:"), function(self, _cmd, aString)
{
    _CPReportLenientDeprecation(self, _cmd, sel_getUid("dataWithRawString:"));
    return (self.isa.method_msgSend["dataWithRawString:"] || _objj_forward)(self, "dataWithRawString:", aString);
}
,["id","CPString"])]);
}CFData.prototype.isa = CPData;
CFMutableData.prototype.isa = CPData;
p;8;CPDate.jt;10514;@STATIC;1.0;i;10;CPObject.ji;10;CPString.ji;13;CPException.jt;10446;objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPException.j", YES);var CPDateReferenceDate = new Date(Date.UTC(2001, 0, 1, 0, 0, 0, 0));
{var the_class = objj_allocateClassPair(CPObject, "CPDate"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithTimeIntervalSinceNow:"), function(self, _cmd, seconds)
{
    if (!_isNumberType(seconds))
        CPLog.warn("The parameter of the method initWithTimeIntervalSinceNow: should be an integer or a float");
    self = new Date((new Date()).getTime() + seconds * 1000);
    return self;
}
,["id","CPTimeInterval"]), new objj_method(sel_getUid("initWithTimeIntervalSince1970:"), function(self, _cmd, seconds)
{
    if (!_isNumberType(seconds))
        CPLog.warn("The parameter of the method initWithTimeIntervalSince1970: should be an integer or a float");
    self = new Date(seconds * 1000);
    return self;
}
,["id","CPTimeInterval"]), new objj_method(sel_getUid("initWithTimeIntervalSinceReferenceDate:"), function(self, _cmd, seconds)
{
    if (!_isNumberType(seconds))
        CPLog.warn("The parameter of the method initWithTimeIntervalSinceReferenceDate: should be an integer or a float");
    self = (self == null ? null : (self.isa.method_msgSend["initWithTimeInterval:sinceDate:"] || _objj_forward)(self, "initWithTimeInterval:sinceDate:", seconds, CPDateReferenceDate));
    return self;
}
,["id","CPTimeInterval"]), new objj_method(sel_getUid("initWithTimeInterval:sinceDate:"), function(self, _cmd, seconds, refDate)
{
    if (!_isNumberType(seconds))
        CPLog.warn("The parameter of the method initWithTimeInterval:sinceDate: should be an integer or a float");
    self = new Date(refDate.getTime() + seconds * 1000);
    return self;
}
,["id","CPTimeInterval","CPDate"]), new objj_method(sel_getUid("initWithString:"), function(self, _cmd, description)
{
    var format = /(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2}):(\d{2}) ([-+])(\d{2})(\d{2})/,
        d = description.match(new RegExp(format));
    if (!d || d.length != 10)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "initWithString: the string must be in YYYY-MM-DD HH:MM:SS ±HHMM format");
    var date = new Date(d[1], d[2] - 1, d[3]),
        timeZoneOffset = (Number(d[8]) * 60 + Number(d[9])) * (d[7] === '-' ? 1 : -1);
    date.setHours(d[4]);
    date.setMinutes(d[5]);
    date.setSeconds(d[6]);
    self = new Date(date.getTime() + (timeZoneOffset - date.getTimezoneOffset()) * 60 * 1000);
    return self;
}
,["id","CPString"]), new objj_method(sel_getUid("timeIntervalSinceDate:"), function(self, _cmd, anotherDate)
{
    return (self.getTime() - anotherDate.getTime()) / 1000.0;
}
,["CPTimeInterval","CPDate"]), new objj_method(sel_getUid("timeIntervalSinceNow"), function(self, _cmd)
{
    return (self.isa.method_msgSend["timeIntervalSinceDate:"] || _objj_forward)(self, "timeIntervalSinceDate:", (CPDate.isa.method_msgSend["date"] || _objj_forward)(CPDate, "date"));
}
,["CPTimeInterval"]), new objj_method(sel_getUid("timeIntervalSince1970"), function(self, _cmd)
{
    return self.getTime() / 1000.0;
}
,["CPTimeInterval"]), new objj_method(sel_getUid("timeIntervalSinceReferenceDate"), function(self, _cmd)
{
    return (self.getTime() - CPDateReferenceDate.getTime()) / 1000.0;
}
,["CPTimeInterval"]), new objj_method(sel_getUid("dateByAddingTimeInterval:"), function(self, _cmd, seconds)
{
    return ((___r1 = (CPDate.isa.method_msgSend["alloc"] || _objj_forward)(CPDate, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithTimeInterval:sinceDate:"] || _objj_forward)(___r1, "initWithTimeInterval:sinceDate:", seconds, self));
    var ___r1;
}
,["id","CPTimeInterval"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, aDate)
{
    if (self === aDate)
        return YES;
    if (!aDate || !(aDate == null ? null : (aDate.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(aDate, "isKindOfClass:", (CPDate.isa.method_msgSend["class"] || _objj_forward)(CPDate, "class"))))
        return NO;
    return (self.isa.method_msgSend["isEqualToDate:"] || _objj_forward)(self, "isEqualToDate:", aDate);
}
,["BOOL","CPDate"]), new objj_method(sel_getUid("isEqualToDate:"), function(self, _cmd, aDate)
{
    if (!aDate)
        return NO;
    return !(self < aDate || self > aDate);
}
,["BOOL","CPDate"]), new objj_method(sel_getUid("compare:"), function(self, _cmd, anotherDate)
{
    return self > anotherDate ? CPOrderedDescending : self < anotherDate ? CPOrderedAscending : CPOrderedSame;
}
,["CPComparisonResult","CPDate"]), new objj_method(sel_getUid("earlierDate:"), function(self, _cmd, anotherDate)
{
    return self < anotherDate ? self : anotherDate;
}
,["CPDate","CPDate"]), new objj_method(sel_getUid("laterDate:"), function(self, _cmd, anotherDate)
{
    return self > anotherDate ? self : anotherDate;
}
,["CPDate","CPDate"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%04d-%02d-%02d %02d:%02d:%02d %s", self.getFullYear(), self.getMonth() + 1, self.getDate(), self.getHours(), self.getMinutes(), self.getSeconds(), (CPDate.isa.method_msgSend["timezoneOffsetString:"] || _objj_forward)(CPDate, "timezoneOffsetString:", self.getTimezoneOffset()));
}
,["CPString"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    return new Date(self.getTime());
}
,["id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    var result = new Date();
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["id"]), new objj_method(sel_getUid("date"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("dateWithTimeIntervalSinceNow:"), function(self, _cmd, seconds)
{
    return ((___r1 = (CPDate.isa.method_msgSend["alloc"] || _objj_forward)(CPDate, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithTimeIntervalSinceNow:"] || _objj_forward)(___r1, "initWithTimeIntervalSinceNow:", seconds));
    var ___r1;
}
,["id","CPTimeInterval"]), new objj_method(sel_getUid("dateWithTimeIntervalSince1970:"), function(self, _cmd, seconds)
{
    return ((___r1 = (CPDate.isa.method_msgSend["alloc"] || _objj_forward)(CPDate, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithTimeIntervalSince1970:"] || _objj_forward)(___r1, "initWithTimeIntervalSince1970:", seconds));
    var ___r1;
}
,["id","CPTimeInterval"]), new objj_method(sel_getUid("dateWithTimeIntervalSinceReferenceDate:"), function(self, _cmd, seconds)
{
    return ((___r1 = (CPDate.isa.method_msgSend["alloc"] || _objj_forward)(CPDate, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithTimeIntervalSinceReferenceDate:"] || _objj_forward)(___r1, "initWithTimeIntervalSinceReferenceDate:", seconds));
    var ___r1;
}
,["id","CPTimeInterval"]), new objj_method(sel_getUid("distantPast"), function(self, _cmd)
{
    return (CPDate.isa.method_msgSend["dateWithTimeIntervalSinceReferenceDate:"] || _objj_forward)(CPDate, "dateWithTimeIntervalSinceReferenceDate:", -63113817600.0);
}
,["id"]), new objj_method(sel_getUid("distantFuture"), function(self, _cmd)
{
    return (CPDate.isa.method_msgSend["dateWithTimeIntervalSinceReferenceDate:"] || _objj_forward)(CPDate, "dateWithTimeIntervalSinceReferenceDate:", 63113990400.0);
}
,["id"]), new objj_method(sel_getUid("timeIntervalSinceReferenceDate"), function(self, _cmd)
{
    return ((___r1 = (CPDate.isa.method_msgSend["date"] || _objj_forward)(CPDate, "date")), ___r1 == null ? null : (___r1.isa.method_msgSend["timeIntervalSinceReferenceDate"] || _objj_forward)(___r1, "timeIntervalSinceReferenceDate"));
    var ___r1;
}
,["CPTimeInterval"]), new objj_method(sel_getUid("timezoneOffsetString:"), function(self, _cmd, timezoneOffset)
{
    var offset = -timezoneOffset,
        positive = offset >= 0,
        hours = positive ? FLOOR(offset / 60) : CEIL(offset / 60),
        minutes = offset - hours * 60;
    return (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%s%02d%02d", positive ? "+" : "-", ABS(hours), ABS(minutes));
}
,["CPString","int"])]);
}var CPDateTimeKey = "CPDateTimeKey";
{
var the_class = objj_getClass("CPDate")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPDate\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    if (self)
    {
        self.setTime((aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPDateTimeKey)));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self.getTime(), CPDateTimeKey));
}
,["void","CPCoder"])]);
}var numericKeys = [1, 4, 5, 6, 7, 10, 11];
Date.parseISO8601 = function(date)
{
    var timestamp,
        struct,
        minutesOffset = 0;
    timestamp = Date.parse(date);
    if (isNaN(timestamp) && (struct = /^(\d{4}|[+\-]\d{6})(?:-(\d{2})(?:-(\d{2}))?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(?:\.(\d{3}))?)?(?:(Z)|([+\-])(\d{2})(?::(\d{2}))?)?)?$/.exec(date)))
    {
        for (var i = 0, k; k = numericKeys[i]; ++i)
            struct[k] = +struct[k] || 0;
        struct[2] = (+struct[2] || 1) - 1;
        struct[3] = +struct[3] || 1;
        if (struct[8] !== 'Z' && struct[9] !== undefined)
        {
            minutesOffset = struct[10] * 60 + struct[11];
            if (struct[9] === '+')
                minutesOffset = 0 - minutesOffset;
        }
        return Date.UTC(struct[1], struct[2], struct[3], struct[4], struct[5] + minutesOffset, struct[6], struct[7]);
    }
    return timestamp;
};
Date.prototype.isa = CPDate;
_isNumberType = function(value)
{
    if (typeof value === 'number')
        return YES;
    else
        return NO;
}
p;17;CPDateFormatter.jt;108249;@STATIC;1.0;i;9;CPArray.ji;8;CPDate.ji;10;CPString.ji;13;CPFormatter.ji;12;CPTimeZone.ji;10;CPLocale.jt;108138;objj_executeFile("CPArray.j", YES);objj_executeFile("CPDate.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPFormatter.j", YES);objj_executeFile("CPTimeZone.j", YES);objj_executeFile("CPLocale.j", YES);{var the_typedef = objj_allocateTypeDef("CPDateFormatterStyle");
objj_registerTypeDef(the_typedef);
}CPDateFormatterNoStyle = 0;
CPDateFormatterShortStyle = 1;
CPDateFormatterMediumStyle = 2;
CPDateFormatterLongStyle = 3;
CPDateFormatterFullStyle = 4;
{var the_typedef = objj_allocateTypeDef("CPDateFormatterBehavior");
objj_registerTypeDef(the_typedef);
}CPDateFormatterBehaviorDefault = 0;
CPDateFormatterBehavior10_0 = 1000;
CPDateFormatterBehavior10_4 = 1040;
var defaultDateFormatterBehavior = CPDateFormatterBehavior10_4,
    relativeDateFormating,
    patternStringTokens;
{var the_class = objj_allocateClassPair(CPFormatter, "CPDateFormatter"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_allowNaturalLanguage", "BOOL"), new objj_ivar("_doesRelativeDateFormatting", "BOOL"), new objj_ivar("_defaultDate", "CPDate"), new objj_ivar("_twoDigitStartDate", "CPDate"), new objj_ivar("_formatterBehavior", "CPDateFormatterBehavior"), new objj_ivar("_dateStyle", "CPDateFormatterStyle"), new objj_ivar("_timeStyle", "CPDateFormatterStyle"), new objj_ivar("_locale", "CPLocale"), new objj_ivar("_AMSymbol", "CPString"), new objj_ivar("_dateFormat", "CPString"), new objj_ivar("_PMSymbol", "CPString"), new objj_ivar("_timeZone", "CPTimeZone"), new objj_ivar("_symbols", "CPDictionary")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("allowNaturalLanguage"), function(self, _cmd)
{
    return self._allowNaturalLanguage;
}
,["BOOL"]), new objj_method(sel_getUid("doesRelativeDateFormatting"), function(self, _cmd)
{
    return self._doesRelativeDateFormatting;
}
,["BOOL"]), new objj_method(sel_getUid("setDoesRelativeDateFormatting:"), function(self, _cmd, newValue)
{
    self._doesRelativeDateFormatting = newValue;
}
,["void","BOOL"]), new objj_method(sel_getUid("defaultDate"), function(self, _cmd)
{
    return self._defaultDate;
}
,["CPDate"]), new objj_method(sel_getUid("setDefaultDate:"), function(self, _cmd, newValue)
{
    self._defaultDate = newValue;
}
,["void","CPDate"]), new objj_method(sel_getUid("twoDigitStartDate"), function(self, _cmd)
{
    return self._twoDigitStartDate;
}
,["CPDate"]), new objj_method(sel_getUid("setTwoDigitStartDate:"), function(self, _cmd, newValue)
{
    self._twoDigitStartDate = newValue;
}
,["void","CPDate"]), new objj_method(sel_getUid("formatterBehavior"), function(self, _cmd)
{
    return self._formatterBehavior;
}
,["CPDateFormatterBehavior"]), new objj_method(sel_getUid("setFormatterBehavior:"), function(self, _cmd, newValue)
{
    self._formatterBehavior = newValue;
}
,["void","CPDateFormatterBehavior"]), new objj_method(sel_getUid("dateStyle"), function(self, _cmd)
{
    return self._dateStyle;
}
,["CPDateFormatterStyle"]), new objj_method(sel_getUid("setDateStyle:"), function(self, _cmd, newValue)
{
    self._dateStyle = newValue;
}
,["void","CPDateFormatterStyle"]), new objj_method(sel_getUid("timeStyle"), function(self, _cmd)
{
    return self._timeStyle;
}
,["CPDateFormatterStyle"]), new objj_method(sel_getUid("setTimeStyle:"), function(self, _cmd, newValue)
{
    self._timeStyle = newValue;
}
,["void","CPDateFormatterStyle"]), new objj_method(sel_getUid("locale"), function(self, _cmd)
{
    return self._locale;
}
,["CPLocale"]), new objj_method(sel_getUid("setLocale:"), function(self, _cmd, newValue)
{
    self._locale = newValue;
}
,["void","CPLocale"]), new objj_method(sel_getUid("AMSymbol"), function(self, _cmd)
{
    return self._AMSymbol;
}
,["CPString"]), new objj_method(sel_getUid("setAMSymbol:"), function(self, _cmd, newValue)
{
    self._AMSymbol = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("dateFormat"), function(self, _cmd)
{
    return self._dateFormat;
}
,["CPString"]), new objj_method(sel_getUid("setDateFormat:"), function(self, _cmd, newValue)
{
    self._dateFormat = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("PMSymbol"), function(self, _cmd)
{
    return self._PMSymbol;
}
,["CPString"]), new objj_method(sel_getUid("setPMSymbol:"), function(self, _cmd, newValue)
{
    self._PMSymbol = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("timeZone"), function(self, _cmd)
{
    return self._timeZone;
}
,["CPTimeZone"]), new objj_method(sel_getUid("setTimeZone:"), function(self, _cmd, newValue)
{
    self._timeZone = newValue;
}
,["void","CPTimeZone"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    if (self = (objj_getClass("CPDateFormatter").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._dateStyle = nil;
        self._timeStyle = nil;
        (self == null ? null : (self.isa.method_msgSend["_init"] || _objj_forward)(self, "_init"));
    }
    return self;
}
,["id"]), new objj_method(sel_getUid("initWithDateFormat:allowNaturalLanguage:"), function(self, _cmd, format, flag)
{
    if (self = (self == null ? null : (self.isa.method_msgSend["init"] || _objj_forward)(self, "init")))
    {
        self._dateFormat = format;
        self._allowNaturalLanguage = flag;
    }
    return self;
}
,["id","CPString","BOOL"]), new objj_method(sel_getUid("_init"), function(self, _cmd)
{
    var AMSymbol = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%s", "AM"),
        PMSymbol = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%s", "PM"),
        weekdaySymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"),
        shortWeekdaySymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"),
        veryShortWeekdaySymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "S", "M", "T", "W", "T", "F", "S"),
        standaloneWeekdaySymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"),
        shortStandaloneWeekdaySymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"),
        veryShortStandaloneWeekdaySymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "S", "M", "T", "W", "T", "F", "S"),
        monthSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"),
        shortMonthSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"),
        veryShortMonthSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"),
        standaloneMonthSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"),
        shortStandaloneMonthSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"),
        veryShortStandaloneMonthSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"),
        quarterSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "1st quarter", "2nd quarter", "3rd quarter", "4th quarter"),
        shortQuarterSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "Q1", "Q2", "Q3", "Q4"),
        standaloneQuarterSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "1st quarter", "2nd quarter", "3rd quarter", "4th quarter"),
        shortStandaloneQuarterSymbols = (CPArray.isa.method_msgSend["arrayWithObjects:"] || _objj_forward)(CPArray, "arrayWithObjects:", "Q1", "Q2", "Q3", "Q4");
    self._symbols = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [(___r2 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r2 == null ? null : (___r2.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r2, "initWithObjects:forKeys:", [AMSymbol, PMSymbol, weekdaySymbols, shortWeekdaySymbols, veryShortWeekdaySymbols, standaloneWeekdaySymbols, shortStandaloneWeekdaySymbols, veryShortStandaloneWeekdaySymbols, monthSymbols, shortMonthSymbols, veryShortMonthSymbols, standaloneMonthSymbols, shortStandaloneMonthSymbols, veryShortStandaloneMonthSymbols, quarterSymbols, shortQuarterSymbols, standaloneQuarterSymbols, shortStandaloneQuarterSymbols], ["AMSymbol", "PMSymbol", "weekdaySymbols", "shortWeekdaySymbols", "veryShortWeekdaySymbols", "standaloneWeekdaySymbols", "shortStandaloneWeekdaySymbols", "veryShortStandaloneWeekdaySymbols", "monthSymbols", "shortMonthSymbols", "veryShortMonthSymbols", "standaloneMonthSymbols", "shortStandaloneMonthSymbols", "veryShortStandaloneMonthSymbols", "quarterSymbols", "shortQuarterSymbols", "standaloneQuarterSymbols", "shortStandaloneQuarterSymbols"]))], ["root"]));
    self._timeZone = (CPTimeZone.isa.method_msgSend["systemTimeZone"] || _objj_forward)(CPTimeZone, "systemTimeZone");
    self._twoDigitStartDate = ((___r1 = (CPDate.isa.method_msgSend["alloc"] || _objj_forward)(CPDate, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", "1950-01-01 00:00:00 +0000"));
    self._locale = (CPLocale.isa.method_msgSend["currentLocale"] || _objj_forward)(CPLocale, "currentLocale");
    var ___r1, ___r2;
}
,["void"]), new objj_method(sel_getUid("symbolsForLanguageCode:"), function(self, _cmd, languageCode)
{
    var languageSymbols = ((___r1 = self._symbols), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r1, "valueForKey:", languageCode));
    if (!languageSymbols)
    {
        languageSymbols = (self.isa.method_msgSend["symbolsForLanguageCode:"] || _objj_forward)(self, "symbolsForLanguageCode:", "root");
        (self.isa.method_msgSend["setSymbols:forLanguageCode:"] || _objj_forward)(self, "setSymbols:forLanguageCode:", languageSymbols, languageCode);
    }
    return languageSymbols;
    var ___r1;
}
,["CPDictionary","CPString"]), new objj_method(sel_getUid("setSymbols:forLanguageCode:"), function(self, _cmd, symbols, languageCode)
{
    ((___r1 = self._symbols), ___r1 == null ? null : (___r1.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(___r1, "setValue:forKey:", symbols, languageCode));
    var ___r1;
}
,["void","CPDictionary","CPString"]), new objj_method(sel_getUid("symbolForKey:languageCode:"), function(self, _cmd, aKey, languageCode)
{
    var languageSymbols = (self.isa.method_msgSend["symbolsForLanguageCode:"] || _objj_forward)(self, "symbolsForLanguageCode:", languageCode),
        symbol = (languageSymbols == null ? null : (languageSymbols.isa.method_msgSend["valueForKey:"] || _objj_forward)(languageSymbols, "valueForKey:", aKey));
    if (!symbol)
    {
        symbol = (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", aKey, "root");
        (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", symbol, aKey, languageCode);
    }
    return symbol;
}
,["id","CPString","CPString"]), new objj_method(sel_getUid("setSymbol:forKey:languageCode:"), function(self, _cmd, aSymbol, aKey, languageCode)
{
    var languageSymbols = (self.isa.method_msgSend["symbolsForLanguageCode:"] || _objj_forward)(self, "symbolsForLanguageCode:", languageCode);
    (languageSymbols == null ? null : (languageSymbols.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(languageSymbols, "setValue:forKey:", aSymbol, aKey));
}
,["void","CPString","CPString","CPString"]), new objj_method(sel_getUid("AMSymbol"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "AMSymbol", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPString"]), new objj_method(sel_getUid("setAMSymbol:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "AMSymbol", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPString"]), new objj_method(sel_getUid("PMSymbol"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "PMSymbol", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPString"]), new objj_method(sel_getUid("setPMSymbol:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "PMSymbol", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPString"]), new objj_method(sel_getUid("weekdaySymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "weekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setWeekdaySymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "weekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("shortWeekdaySymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "shortWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setShortWeekdaySymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "shortWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("veryShortWeekdaySymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "veryShortWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setVeryShortWeekdaySymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "veryShortWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("standaloneWeekdaySymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "standaloneWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setStandaloneWeekdaySymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "standaloneWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("shortStandaloneWeekdaySymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "shortStandaloneWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setShortStandaloneWeekdaySymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "shortStandaloneWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("veryShortStandaloneWeekdaySymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "veryShortStandaloneWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setVeryShortStandaloneWeekdaySymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "veryShortStandaloneWeekdaySymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("monthSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "monthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setMonthSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "monthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("shortMonthSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "shortMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setShortMonthSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "shortMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("veryShortMonthSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "veryShortMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setVeryShortMonthSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "veryShortMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("standaloneMonthSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "standaloneMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setStandaloneMonthSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "standaloneMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("shortStandaloneMonthSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "shortStandaloneMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setShortStandaloneMonthSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "shortStandaloneMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("veryShortStandaloneMonthSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "veryShortStandaloneMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setVeryShortStandaloneMonthSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "veryShortStandaloneMonthSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("quarterSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "quarterSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setQuarterSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "quarterSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("shortQuarterSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "shortQuarterSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setShortQuarterSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "shortQuarterSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("standaloneQuarterSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "standaloneQuarterSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setStandaloneQuarterSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "standaloneQuarterSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("shortStandaloneQuarterSymbols"), function(self, _cmd)
{
    return (self.isa.method_msgSend["symbolForKey:languageCode:"] || _objj_forward)(self, "symbolForKey:languageCode:", "shortStandaloneQuarterSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("setShortStandaloneQuarterSymbols:"), function(self, _cmd, aValue)
{
    (self.isa.method_msgSend["setSymbol:forKey:languageCode:"] || _objj_forward)(self, "setSymbol:forKey:languageCode:", aValue, "shortStandaloneQuarterSymbols", ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("stringFromDate:"), function(self, _cmd, aDate)
{
    var format,
        relativeWord,
        result;
    if (!aDate)
        return;
    aDate = (aDate == null ? null : (aDate.isa.method_msgSend["copy"] || _objj_forward)(aDate, "copy"));
    (aDate == null ? null : (aDate.isa.method_msgSend["_dateWithTimeZone:"] || _objj_forward)(aDate, "_dateWithTimeZone:", self._timeZone));
    if (self._dateFormat)
        return (self.isa.method_msgSend["_stringFromDate:format:"] || _objj_forward)(self, "_stringFromDate:format:", aDate, self._dateFormat);
    switch(self._dateStyle) {
    case CPDateFormatterNoStyle:
        format = "";
        break;
    case CPDateFormatterShortStyle:
        if ((self.isa.method_msgSend["_isAmericanFormat"] || _objj_forward)(self, "_isAmericanFormat"))
            format = "M/d/yy";
        else
            format = "dd/MM/yy";
        break;
    case CPDateFormatterMediumStyle:
        if ((self.isa.method_msgSend["_isAmericanFormat"] || _objj_forward)(self, "_isAmericanFormat"))
            format = "MMM d, Y";
        else
            format = "d MMM Y";
        break;
    case CPDateFormatterLongStyle:
        if ((self.isa.method_msgSend["_isAmericanFormat"] || _objj_forward)(self, "_isAmericanFormat"))
            format = "MMMM d, Y";
        else
            format = "d MMMM Y";
        break;
    case CPDateFormatterFullStyle:
        if ((self.isa.method_msgSend["_isAmericanFormat"] || _objj_forward)(self, "_isAmericanFormat"))
            format = "EEEE, MMMM d, Y";
        else
            format = "EEEE d MMMM Y";
        break;
default:
        format = "";
    }
    if ((self.isa.method_msgSend["doesRelativeDateFormatting"] || _objj_forward)(self, "doesRelativeDateFormatting"))
    {
        var language = ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleLanguageCode)),
            relativeWords = (relativeDateFormating == null ? null : (relativeDateFormating.isa.method_msgSend["valueForKey:"] || _objj_forward)(relativeDateFormating, "valueForKey:", language));
        for (var i = 1; i < (relativeWords == null ? null : (relativeWords.isa.method_msgSend["count"] || _objj_forward)(relativeWords, "count")); i = i + 2)
        {
            var date = (CPDate.isa.method_msgSend["date"] || _objj_forward)(CPDate, "date");
            (date == null ? null : (date.isa.method_msgSend["_dateWithTimeZone:"] || _objj_forward)(date, "_dateWithTimeZone:", self._timeZone));
            date.setHours(12);
            date.setMinutes(0);
            date.setSeconds(0);
            date.setDate((relativeWords == null ? null : (relativeWords.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(relativeWords, "objectAtIndex:", i)) + date.getDate());
            if (date.getDate() == aDate.getDate() && date.getMonth() == aDate.getMonth() && date.getFullYear() == aDate.getFullYear())
            {
                relativeWord = (relativeWords == null ? null : (relativeWords.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(relativeWords, "objectAtIndex:", i - 1));
                format = "";
                break;
            }
        }
    }
    if ((relativeWord || format.length) && self._timeStyle != CPDateFormatterNoStyle)
        format += " ";
    switch(self._timeStyle) {
    case CPDateFormatterNoStyle:
        format += "";
        break;
    case CPDateFormatterShortStyle:
        if ((self.isa.method_msgSend["_isEnglishFormat"] || _objj_forward)(self, "_isEnglishFormat"))
            format += "h:mm a";
        else
            format += "H:mm";
        break;
    case CPDateFormatterMediumStyle:
        if ((self.isa.method_msgSend["_isEnglishFormat"] || _objj_forward)(self, "_isEnglishFormat"))
            format += "h:mm:ss a";
        else
            format += "H:mm:ss";
        break;
    case CPDateFormatterLongStyle:
        if ((self.isa.method_msgSend["_isEnglishFormat"] || _objj_forward)(self, "_isEnglishFormat"))
            format += "h:mm:ss a z";
        else
            format += "H:mm:ss z";
        break;
    case CPDateFormatterFullStyle:
        if ((self.isa.method_msgSend["_isEnglishFormat"] || _objj_forward)(self, "_isEnglishFormat"))
            format += "h:mm:ss a zzzz";
        else
            format += "h:mm:ss zzzz";
        break;
default:
        format += "";
    }
    result = (self.isa.method_msgSend["_stringFromDate:format:"] || _objj_forward)(self, "_stringFromDate:format:", aDate, format);
    if (relativeWord)
        result = relativeWord + result;
    return result;
    var ___r1;
}
,["CPString","CPDate"]), new objj_method(sel_getUid("stringForObjectValue:"), function(self, _cmd, anObject)
{
    if ((anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", (CPDate.isa.method_msgSend["class"] || _objj_forward)(CPDate, "class"))))
        return (self.isa.method_msgSend["stringFromDate:"] || _objj_forward)(self, "stringFromDate:", anObject);
    else
        return nil;
}
,["CPString","id"]), new objj_method(sel_getUid("editingStringForObjectValue:"), function(self, _cmd, anObject)
{
    return (self.isa.method_msgSend["stringForObjectValue:"] || _objj_forward)(self, "stringForObjectValue:", anObject);
}
,["CPString","id"]), new objj_method(sel_getUid("_stringFromDate:format:"), function(self, _cmd, aDate, aFormat)
{
    var length = (aFormat == null ? null : (aFormat.isa.method_msgSend["length"] || _objj_forward)(aFormat, "length")),
        currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new"),
        isTextToken = NO,
        result = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
    for (var i = 0; i < length; i++)
    {
        var character = (aFormat == null ? null : (aFormat.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(aFormat, "characterAtIndex:", i));
        if (isTextToken)
        {
            if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "'")))
            {
                isTextToken = NO;
                result += currentToken;
                currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
            }
            else
            {
                currentToken += character;
            }
            continue;
        }
        if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "'")))
        {
            if (!isTextToken)
            {
                isTextToken = YES;
                result += currentToken;
                currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
            }
            continue;
        }
        if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", ",")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", ":")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "/")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "-")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", " ")))
        {
            result += (self.isa.method_msgSend["_stringFromToken:date:"] || _objj_forward)(self, "_stringFromToken:date:", currentToken, aDate);
            result += character;
            currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
        }
        else
        {
            if ((currentToken == null ? null : (currentToken.isa.method_msgSend["length"] || _objj_forward)(currentToken, "length")) && !((___r1 = (currentToken == null ? null : (currentToken.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(currentToken, "characterAtIndex:", 0))), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToString:"] || _objj_forward)(___r1, "isEqualToString:", character)))
            {
                result += (self.isa.method_msgSend["_stringFromToken:date:"] || _objj_forward)(self, "_stringFromToken:date:", currentToken, aDate);
                currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
            }
            currentToken += character;
            if (i == length - 1)
                result += (self.isa.method_msgSend["_stringFromToken:date:"] || _objj_forward)(self, "_stringFromToken:date:", currentToken, aDate);
        }
    }
    return result;
    var ___r1;
}
,["CPString","CPDate","CPString"]), new objj_method(sel_getUid("_stringFromToken:date:"), function(self, _cmd, aToken, aDate)
{
    if (!(aToken == null ? null : (aToken.isa.method_msgSend["length"] || _objj_forward)(aToken, "length")))
        return aToken;
    var character = (aToken == null ? null : (aToken.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(aToken, "characterAtIndex:", 0)),
        length = (aToken == null ? null : (aToken.isa.method_msgSend["length"] || _objj_forward)(aToken, "length")),
        timeZone = self._timeZone;
    switch(character) {
    case "G":
        CPLog.warn("Token not yet implemented " + aToken);
        return (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
    case "y":
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", aDate.getFullYear())), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", aDate.getFullYear(), length == 2 ? length : currentLength);
    case "Y":
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", aDate.getFullYear())), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", aDate.getFullYear(), length == 2 ? length : currentLength);
    case "u":
        CPLog.warn("Token not yet implemented " + aToken);
        return (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
    case "U":
        CPLog.warn("Token not yet implemented " + aToken);
        return (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
    case "Q":
        var quarter = 1;
        if (aDate.getMonth() < 6 && aDate.getMonth() > 2)
            quarter = 2;
        if (aDate.getMonth() > 5 && aDate.getMonth() < 9)
            quarter = 3;
        if (aDate.getMonth() >= 9)
            quarter = 4;
        if (length <= 2)
            return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", quarter, MIN(2, length));
        if (length == 3)
            return ((___r1 = (self.isa.method_msgSend["shortQuarterSymbols"] || _objj_forward)(self, "shortQuarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", quarter - 1));
        if (length >= 4)
            return ((___r1 = (self.isa.method_msgSend["quarterSymbols"] || _objj_forward)(self, "quarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", quarter - 1));
    case "q":
        var quarter = 1;
        if (aDate.getMonth() < 6 && aDate.getMonth() > 2)
            quarter = 2;
        if (aDate.getMonth() > 5 && aDate.getMonth() < 9)
            quarter = 3;
        if (aDate.getMonth() >= 9)
            quarter = 4;
        if (length <= 2)
            return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", quarter, MIN(2, length));
        if (length == 3)
            return ((___r1 = (self.isa.method_msgSend["shortStandaloneQuarterSymbols"] || _objj_forward)(self, "shortStandaloneQuarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", quarter - 1));
        if (length >= 4)
            return ((___r1 = (self.isa.method_msgSend["standaloneQuarterSymbols"] || _objj_forward)(self, "standaloneQuarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", quarter - 1));
    case "M":
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", aDate.getMonth() + 1)), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        if (length <= 2)
            return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", aDate.getMonth() + 1, MAX(currentLength, length));
        if (length == 3)
            return ((___r1 = (self.isa.method_msgSend["shortMonthSymbols"] || _objj_forward)(self, "shortMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", aDate.getMonth()));
        if (length == 4)
            return ((___r1 = (self.isa.method_msgSend["monthSymbols"] || _objj_forward)(self, "monthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", aDate.getMonth()));
        if (length >= 5)
            return ((___r1 = (self.isa.method_msgSend["veryShortMonthSymbols"] || _objj_forward)(self, "veryShortMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", aDate.getMonth()));
    case "L":
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", aDate.getMonth() + 1)), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        if (length <= 2)
            return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", aDate.getMonth() + 1, MAX(currentLength, length));
        if (length == 3)
            return ((___r1 = (self.isa.method_msgSend["shortStandaloneMonthSymbols"] || _objj_forward)(self, "shortStandaloneMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", aDate.getMonth()));
        if (length == 4)
            return ((___r1 = (self.isa.method_msgSend["standaloneMonthSymbols"] || _objj_forward)(self, "standaloneMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", aDate.getMonth()));
        if (length >= 5)
            return ((___r1 = (self.isa.method_msgSend["veryShortStandaloneMonthSymbols"] || _objj_forward)(self, "veryShortStandaloneMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", aDate.getMonth()));
    case "I":
        CPLog.warn("Depreacted - Token not yet implemented " + aToken);
        return (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
    case "w":
        var d = (aDate == null ? null : (aDate.isa.method_msgSend["copy"] || _objj_forward)(aDate, "copy"));
        d.setHours(0, 0, 0);
        d.setDate(d.getDate() + 4 - (d.getDay() || 7));
        var yearStart = new Date(d.getFullYear(), 0, 1),
            weekOfYear = Math.ceil(((d - yearStart) / 86400000 + 1) / 7);
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", weekOfYear + 1, MAX(2, length));
    case "W":
        var firstDay = (new Date(aDate.getFullYear(), aDate.getMonth(), 1)).getDay(),
            weekOfMonth = Math.ceil((aDate.getDate() + firstDay) / 7);
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", weekOfMonth, 1);
    case "d":
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", aDate.getDate())), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", aDate.getDate(), MAX(length, currentLength));
    case "D":
        var oneJan = new Date(aDate.getFullYear(), 0, 1),
            dayOfYear = Math.ceil((aDate - oneJan) / 86400000),
            currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", dayOfYear)), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", dayOfYear, MAX(currentLength, MIN(3, length)));
    case "F":
        var dayOfWeek = 1,
            day = aDate.getDate();
        if (day > 7 && day < 15)
            dayOfWeek = 2;
        if (day > 14 && day < 22)
            dayOfWeek = 3;
        if (day > 21 && day < 29)
            dayOfWeek = 4;
        if (day > 28)
            dayOfWeek = 5;
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", dayOfWeek, 1);
    case "g":
        CPLog.warn("Token not yet implemented " + aToken);
        return (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
    case "E":
        var day = aDate.getDay();
        if (length <= 3)
            return ((___r1 = (self.isa.method_msgSend["shortWeekdaySymbols"] || _objj_forward)(self, "shortWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", day));
        if (length == 4)
            return ((___r1 = (self.isa.method_msgSend["weekdaySymbols"] || _objj_forward)(self, "weekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", day));
        if (length >= 5)
            return ((___r1 = (self.isa.method_msgSend["veryShortWeekdaySymbols"] || _objj_forward)(self, "veryShortWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", day));
    case "e":
        var day = aDate.getDay();
        if (length <= 2)
            return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", day + 1, MIN(2, length));
        if (length == 3)
            return ((___r1 = (self.isa.method_msgSend["shortWeekdaySymbols"] || _objj_forward)(self, "shortWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", day));
        if (length == 4)
            return ((___r1 = (self.isa.method_msgSend["weekdaySymbols"] || _objj_forward)(self, "weekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", day));
        if (length >= 5)
            return ((___r1 = (self.isa.method_msgSend["veryShortWeekdaySymbols"] || _objj_forward)(self, "veryShortWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", day));
    case "c":
        var day = aDate.getDay();
        if (length <= 2)
            return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", day + 1, ((aDate.getDay()).toString()).length);
        if (length == 3)
            return ((___r1 = (self.isa.method_msgSend["shortStandaloneWeekdaySymbols"] || _objj_forward)(self, "shortStandaloneWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", day));
        if (length == 4)
            return ((___r1 = (self.isa.method_msgSend["standaloneWeekdaySymbols"] || _objj_forward)(self, "standaloneWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", day));
        if (length >= 5)
            return ((___r1 = (self.isa.method_msgSend["veryShortStandaloneWeekdaySymbols"] || _objj_forward)(self, "veryShortStandaloneWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", day));
    case "a":
        if (aDate.getHours() > 11)
            return (self.isa.method_msgSend["PMSymbol"] || _objj_forward)(self, "PMSymbol");
        else
            return (self.isa.method_msgSend["AMSymbol"] || _objj_forward)(self, "AMSymbol");
    case "h":
        var hours = aDate.getHours();
        if ((self.isa.method_msgSend["_isAmericanFormat"] || _objj_forward)(self, "_isAmericanFormat") || (self.isa.method_msgSend["_isEnglishFormat"] || _objj_forward)(self, "_isEnglishFormat"))
        {
            if (hours == 0)
                hours = 12;
            else if (hours > 12)
                hours = hours - 12;
        }
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", hours)), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", hours, MAX(currentLength, MIN(2, length)));
    case "H":
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", aDate.getHours())), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", aDate.getHours(), MAX(currentLength, MIN(2, length)));
    case "K":
        var hours = aDate.getHours();
        if (hours > 12)
            hours -= 12;
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", hours)), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", hours, MAX(currentLength, MIN(2, length)));
    case "k":
        var hours = aDate.getHours();
        if (aDate.getHours() == 0)
            hours = 24;
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", hours)), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", hours, MAX(currentLength, MIN(2, length)));
    case "j":
        CPLog.warn("Token not yet implemented " + aToken);
        return (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
    case "m":
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", aDate.getMinutes())), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", aDate.getMinutes(), MAX(currentLength, MIN(2, length)));
    case "s":
        var currentLength = ((___r1 = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", aDate.getMinutes())), ___r1 == null ? null : (___r1.isa.method_msgSend["length"] || _objj_forward)(___r1, "length"));
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", aDate.getSeconds(), MIN(2, length));
    case "S":
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", aDate.getMilliseconds(), length);
    case "A":
        var value = aDate.getHours() * 60 * 60 * 1000 + aDate.getMinutes() * 60 * 1000 + aDate.getSeconds() * 1000 + aDate.getMilliseconds();
        return (self.isa.method_msgSend["_stringValueForValue:length:"] || _objj_forward)(self, "_stringValueForValue:length:", value, (value.toString()).length);
    case "z":
        if (length <= 3)
            return (timeZone == null ? null : (timeZone.isa.method_msgSend["localizedName:locale:"] || _objj_forward)(timeZone, "localizedName:locale:", CPTimeZoneNameStyleShortDaylightSaving, self._locale));
        else
            return (timeZone == null ? null : (timeZone.isa.method_msgSend["localizedName:locale:"] || _objj_forward)(timeZone, "localizedName:locale:", CPTimeZoneNameStyleDaylightSaving, self._locale));
    case "Z":
        var seconds = (timeZone == null ? null : (timeZone.isa.method_msgSend["secondsFromGMT"] || _objj_forward)(timeZone, "secondsFromGMT")),
            minutes = seconds / 60,
            hours = minutes / 60,
            result,
            diffMinutes = (hours - parseInt(hours)) * 100 * 60 / 100;
        if (length <= 3)
        {
            result = diffMinutes.toString();
            while ((result == null ? null : (result.isa.method_msgSend["length"] || _objj_forward)(result, "length")) < 2)
                result = "0" + result;
            result = ABS(parseInt(hours)) + result;
            while ((result == null ? null : (result.isa.method_msgSend["length"] || _objj_forward)(result, "length")) < 4)
                result = "0" + result;
            if (seconds > 0)
                result = "+" + result;
            else
                result = "-" + result;
            return result;
        }
        else if (length == 4)
        {
            result = diffMinutes.toString();
            while ((result == null ? null : (result.isa.method_msgSend["length"] || _objj_forward)(result, "length")) < 2)
                result = "0" + result;
            result = ":" + result;
            result = ABS(parseInt(hours)) + result;
            while ((result == null ? null : (result.isa.method_msgSend["length"] || _objj_forward)(result, "length")) < 5)
                result = "0" + result;
            if (seconds > 0)
                result = "+" + result;
            else
                result = "-" + result;
            return "GMT" + result;
        }
        else
        {
            result = diffMinutes.toString();
            while ((result == null ? null : (result.isa.method_msgSend["length"] || _objj_forward)(result, "length")) < 2)
                result = "0" + result;
            result = ":" + result;
            result = ABS(parseInt(hours)) + result;
            while ((result == null ? null : (result.isa.method_msgSend["length"] || _objj_forward)(result, "length")) < 5)
                result = "0" + result;
            if (seconds > 0)
                result = "+" + result;
            else
                result = "-" + result;
            return result;
        }
    case "v":
        if (length == 1)
            return (timeZone == null ? null : (timeZone.isa.method_msgSend["localizedName:locale:"] || _objj_forward)(timeZone, "localizedName:locale:", CPTimeZoneNameStyleShortGeneric, self._locale));
        else if (length == 4)
            return (timeZone == null ? null : (timeZone.isa.method_msgSend["localizedName:locale:"] || _objj_forward)(timeZone, "localizedName:locale:", CPTimeZoneNameStyleGeneric, self._locale));
        return " ";
    case "V":
        if (length == 1)
        {
            return (timeZone == null ? null : (timeZone.isa.method_msgSend["localizedName:locale:"] || _objj_forward)(timeZone, "localizedName:locale:", CPTimeZoneNameStyleShortDaylightSaving, self._locale));
        }
        else if (length == 4)
        {
            CPLog.warn("No pattern found for " + aToken);
            return "";
        }
        return " ";
default:
        CPLog.warn("No pattern found for " + aToken);
        return aToken;
    }
    return (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
    var ___r1;
}
,["CPString","CPString","CPDate"]), new objj_method(sel_getUid("dateFromString:"), function(self, _cmd, aString)
{
    var format;
    if (self._dateFormat != nil)
        return (self.isa.method_msgSend["_dateFromString:format:"] || _objj_forward)(self, "_dateFromString:format:", aString, self._dateFormat);
    switch(self._dateStyle) {
    case CPDateFormatterNoStyle:
        format = "";
        break;
    case CPDateFormatterShortStyle:
        if ((self.isa.method_msgSend["_isAmericanFormat"] || _objj_forward)(self, "_isAmericanFormat"))
            format = "M/d/yy";
        else
            format = "dd/MM/yy";
        break;
    case CPDateFormatterMediumStyle:
        if ((self.isa.method_msgSend["_isAmericanFormat"] || _objj_forward)(self, "_isAmericanFormat"))
            format = "MMM d, Y";
        else
            format = "d MMM Y";
        break;
    case CPDateFormatterLongStyle:
        if ((self.isa.method_msgSend["_isAmericanFormat"] || _objj_forward)(self, "_isAmericanFormat"))
            format = "MMMM d, Y";
        else
            format = "d MMMM Y";
        break;
    case CPDateFormatterFullStyle:
        if ((self.isa.method_msgSend["_isAmericanFormat"] || _objj_forward)(self, "_isAmericanFormat"))
            format = "EEEE, MMMM d, Y";
        else
            format = "EEEE d MMMM Y";
        break;
default:
        format = "";
    }
    switch(self._timeStyle) {
    case CPDateFormatterNoStyle:
        format += "";
        break;
    case CPDateFormatterShortStyle:
        if ((self.isa.method_msgSend["_isEnglishFormat"] || _objj_forward)(self, "_isEnglishFormat"))
            format += " h:mm a";
        else
            format += " H:mm";
        break;
    case CPDateFormatterMediumStyle:
        if ((self.isa.method_msgSend["_isEnglishFormat"] || _objj_forward)(self, "_isEnglishFormat"))
            format += " h:mm:ss a";
        else
            format += " H:mm:ss";
        break;
    case CPDateFormatterLongStyle:
        if ((self.isa.method_msgSend["_isEnglishFormat"] || _objj_forward)(self, "_isEnglishFormat"))
            format += " h:mm:ss a z";
        else
            format += " H:mm:ss z";
        break;
    case CPDateFormatterFullStyle:
        if ((self.isa.method_msgSend["_isEnglishFormat"] || _objj_forward)(self, "_isEnglishFormat"))
            format += " h:mm:ss a zzzz";
        else
            format += " h:mm:ss zzzz";
        break;
default:
        format += "";
    }
    return (self.isa.method_msgSend["_dateFromString:format:"] || _objj_forward)(self, "_dateFromString:format:", aString, format);
}
,["CPDate","CPString"]), new objj_method(sel_getUid("getObjectValue:forString:errorDescription:"), function(self, _cmd, anObject, aString, anError)
{
    var value = (self.isa.method_msgSend["dateFromString:"] || _objj_forward)(self, "dateFromString:", aString);
    (anObject)(value);
    if (!value)
    {
        if (anError)
            (anError)("The value \"" + aString + "\" is invalid.");
        return NO;
    }
    return YES;
}
,["BOOL","idRef","CPString","CPStringRef"]), new objj_method(sel_getUid("_dateFromString:format:"), function(self, _cmd, aString, aFormat)
{
    if (!aString)
        return ((___r1 = (CPDate.isa.method_msgSend["alloc"] || _objj_forward)(CPDate, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithTimeIntervalSinceReferenceDate:"] || _objj_forward)(___r1, "initWithTimeIntervalSinceReferenceDate:", -31622400));
    if (aFormat == nil)
        return nil;
    var currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new"),
        isTextToken = NO,
        tokens = (CPArray.isa.method_msgSend["array"] || _objj_forward)(CPArray, "array"),
        dateComponents = (CPArray.isa.method_msgSend["array"] || _objj_forward)(CPArray, "array"),
        patternTokens = (CPArray.isa.method_msgSend["array"] || _objj_forward)(CPArray, "array");
    for (var i = 0; i < (aFormat == null ? null : (aFormat.isa.method_msgSend["length"] || _objj_forward)(aFormat, "length")); i++)
    {
        var character = (aFormat == null ? null : (aFormat.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(aFormat, "characterAtIndex:", i));
        if (isTextToken)
        {
            if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "'")))
                currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
            continue;
        }
        if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "'")))
        {
            if (!isTextToken)
                isTextToken = YES;
            continue;
        }
        if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", ",")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", ":")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "/")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "-")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", " ")))
        {
            (tokens == null ? null : (tokens.isa.method_msgSend["addObject:"] || _objj_forward)(tokens, "addObject:", currentToken));
            if ((patternStringTokens == null ? null : (patternStringTokens.isa.method_msgSend["containsObject:"] || _objj_forward)(patternStringTokens, "containsObject:", currentToken)))
                (patternTokens == null ? null : (patternTokens.isa.method_msgSend["addObject:"] || _objj_forward)(patternTokens, "addObject:", (tokens == null ? null : (tokens.isa.method_msgSend["count"] || _objj_forward)(tokens, "count")) - 1));
            currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
        }
        else
        {
            if ((currentToken == null ? null : (currentToken.isa.method_msgSend["length"] || _objj_forward)(currentToken, "length")) && !((___r1 = (currentToken == null ? null : (currentToken.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(currentToken, "characterAtIndex:", 0))), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToString:"] || _objj_forward)(___r1, "isEqualToString:", character)))
            {
                (tokens == null ? null : (tokens.isa.method_msgSend["addObject:"] || _objj_forward)(tokens, "addObject:", currentToken));
                if ((patternStringTokens == null ? null : (patternStringTokens.isa.method_msgSend["containsObject:"] || _objj_forward)(patternStringTokens, "containsObject:", currentToken)))
                    (patternTokens == null ? null : (patternTokens.isa.method_msgSend["addObject:"] || _objj_forward)(patternTokens, "addObject:", (tokens == null ? null : (tokens.isa.method_msgSend["count"] || _objj_forward)(tokens, "count")) - 1));
                currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
            }
            currentToken += character;
            if (i == (aFormat == null ? null : (aFormat.isa.method_msgSend["length"] || _objj_forward)(aFormat, "length")) - 1)
            {
                (tokens == null ? null : (tokens.isa.method_msgSend["addObject:"] || _objj_forward)(tokens, "addObject:", currentToken));
                if ((patternStringTokens == null ? null : (patternStringTokens.isa.method_msgSend["containsObject:"] || _objj_forward)(patternStringTokens, "containsObject:", currentToken)))
                    (patternTokens == null ? null : (patternTokens.isa.method_msgSend["addObject:"] || _objj_forward)(patternTokens, "addObject:", (tokens == null ? null : (tokens.isa.method_msgSend["count"] || _objj_forward)(tokens, "count")) - 1));
            }
        }
    }
    isTextToken = NO;
    currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
    var currentIndexSpecialPattern = 0;
    if ((patternTokens == null ? null : (patternTokens.isa.method_msgSend["count"] || _objj_forward)(patternTokens, "count")) == 0)
        (patternTokens == null ? null : (patternTokens.isa.method_msgSend["addObject:"] || _objj_forward)(patternTokens, "addObject:", CPNotFound));
    for (var i = 0; i < (aString == null ? null : (aString.isa.method_msgSend["length"] || _objj_forward)(aString, "length")); i++)
    {
        var character = (aString == null ? null : (aString.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(aString, "characterAtIndex:", i));
        if (isTextToken)
        {
            if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "'")))
                currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
            continue;
        }
        if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "'")))
        {
            if (!isTextToken)
                isTextToken = YES;
            continue;
        }
        if ((dateComponents == null ? null : (dateComponents.isa.method_msgSend["count"] || _objj_forward)(dateComponents, "count")) == (patternTokens == null ? null : (patternTokens.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(patternTokens, "objectAtIndex:", currentIndexSpecialPattern)))
        {
            var j = (self.isa.method_msgSend["_lastIndexMatchedString:token:index:"] || _objj_forward)(self, "_lastIndexMatchedString:token:index:", aString, (tokens == null ? null : (tokens.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(tokens, "objectAtIndex:", (dateComponents == null ? null : (dateComponents.isa.method_msgSend["count"] || _objj_forward)(dateComponents, "count")))), i);
            if (j == CPNotFound)
                return nil;
            currentIndexSpecialPattern++;
            (dateComponents == null ? null : (dateComponents.isa.method_msgSend["addObject:"] || _objj_forward)(dateComponents, "addObject:", (aString == null ? null : (aString.isa.method_msgSend["substringWithRange:"] || _objj_forward)(aString, "substringWithRange:", CPMakeRange(i, j - i)))));
            i = j;
            continue;
        }
        if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", ",")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", ":")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "/")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "-")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", " ")))
        {
            (dateComponents == null ? null : (dateComponents.isa.method_msgSend["addObject:"] || _objj_forward)(dateComponents, "addObject:", currentToken));
            currentToken = (CPString.isa.method_msgSend["new"] || _objj_forward)(CPString, "new");
        }
        else
        {
            currentToken += character;
            if (i == (aString == null ? null : (aString.isa.method_msgSend["length"] || _objj_forward)(aString, "length")) - 1)
                (dateComponents == null ? null : (dateComponents.isa.method_msgSend["addObject:"] || _objj_forward)(dateComponents, "addObject:", currentToken));
        }
    }
    if ((dateComponents == null ? null : (dateComponents.isa.method_msgSend["count"] || _objj_forward)(dateComponents, "count")) != (tokens == null ? null : (tokens.isa.method_msgSend["count"] || _objj_forward)(tokens, "count")))
        return nil;
    return (self.isa.method_msgSend["_dateFromTokens:dateComponents:"] || _objj_forward)(self, "_dateFromTokens:dateComponents:", tokens, dateComponents);
    var ___r1;
}
,["CPDate","CPString","CPString"]), new objj_method(sel_getUid("_dateFromTokens:dateComponents:"), function(self, _cmd, tokens, dateComponents)
{
    var timeZoneseconds = ((___r1 = self._timeZone), ___r1 == null ? null : (___r1.isa.method_msgSend["secondsFromGMT"] || _objj_forward)(___r1, "secondsFromGMT")),
        dateArray = [2000, 01, 01, 00, 00, 00, "+0000"],
        isPM = NO,
        dayOfYear,
        dayIndexInWeek,
        weekOfYear,
        weekOfMonth;
    for (var i = 0; i < (tokens == null ? null : (tokens.isa.method_msgSend["count"] || _objj_forward)(tokens, "count")); i++)
    {
        var token = (tokens == null ? null : (tokens.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(tokens, "objectAtIndex:", i)),
            dateComponent = (dateComponents == null ? null : (dateComponents.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(dateComponents, "objectAtIndex:", i)),
            character = (token == null ? null : (token.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(token, "characterAtIndex:", 0)),
            length = (token == null ? null : (token.isa.method_msgSend["length"] || _objj_forward)(token, "length"));
        switch(character) {
        case "G":
            CPLog.warn("Token not yet implemented " + token);
            break;
        case "y":
            var u = self._twoDigitStartDate.getFullYear() % 10,
                d = parseInt(self._twoDigitStartDate.getFullYear() / 10) % 10,
                c = parseInt(self._twoDigitStartDate.getFullYear() / 100) % 10,
                m = parseInt(self._twoDigitStartDate.getFullYear() / 1000) % 10;
            if (length == 2 && dateComponent.length == 2)
            {
                if (u + d * 10 >= parseInt(dateComponent))
                    dateArray[0] = (c + 1) * 100 + m * 1000 + parseInt(dateComponent);
                else
                    dateArray[0] = c * 100 + m * 1000 + parseInt(dateComponent);
            }
            else
            {
                dateArray[0] = parseInt(dateComponent);
            }
            break;
        case "Y":
            var u = self._twoDigitStartDate.getFullYear() % 10,
                d = parseInt(self._twoDigitStartDate.getFullYear() / 10) % 10,
                c = parseInt(self._twoDigitStartDate.getFullYear() / 100) % 10,
                m = parseInt(self._twoDigitStartDate.getFullYear() / 1000) % 10;
            if (length == 2 && dateComponent.length == 2)
            {
                if (u + d * 10 >= parseInt(dateComponent))
                    dateArray[0] = (c + 1) * 100 + m * 1000 + parseInt(dateComponent);
                else
                    dateArray[0] = c * 100 + m * 1000 + parseInt(dateComponent);
            }
            else
            {
                dateArray[0] = parseInt(dateComponent);
            }
            break;
        case "u":
            CPLog.warn("Token not yet implemented " + token);
            break;
        case "U":
            CPLog.warn("Token not yet implemented " + token);
            break;
        case "Q":
            var month;
            if (length <= 2)
                month = (parseInt(dateComponent) - 1) * 3;
            if (length == 3)
            {
                if (!((___r1 = (self.isa.method_msgSend["shortQuarterSymbols"] || _objj_forward)(self, "shortQuarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", dateComponent)))
                    return nil;
                month = ((___r1 = (self.isa.method_msgSend["shortQuarterSymbols"] || _objj_forward)(self, "shortQuarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent)) * 3;
            }
            if (length >= 4)
            {
                if (!((___r1 = (self.isa.method_msgSend["quarterSymbols"] || _objj_forward)(self, "quarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", dateComponent)))
                    return nil;
                month = ((___r1 = (self.isa.method_msgSend["quarterSymbols"] || _objj_forward)(self, "quarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent)) * 3;
            }
            if (month > 11)
                return nil;
            dateArray[1] = month + 1;
            break;
        case "q":
            var month;
            if (length <= 2)
                month = (parseInt(dateComponent) - 1) * 3;
            if (length == 3)
            {
                if (!((___r1 = (self.isa.method_msgSend["shortQuarterSymbols"] || _objj_forward)(self, "shortQuarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", dateComponent)))
                    return nil;
                month = ((___r1 = (self.isa.method_msgSend["shortQuarterSymbols"] || _objj_forward)(self, "shortQuarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent)) * 3;
            }
            if (length >= 4)
            {
                if (!((___r1 = (self.isa.method_msgSend["quarterSymbols"] || _objj_forward)(self, "quarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", dateComponent)))
                    return nil;
                month = ((___r1 = (self.isa.method_msgSend["quarterSymbols"] || _objj_forward)(self, "quarterSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent)) * 3;
            }
            if (month > 11)
                return nil;
            dateArray[1] = month + 1;
            break;
        case "M":
            var month;
            if (length <= 2)
                month = parseInt(dateComponent);
            if (length == 3)
            {
                if (!((___r1 = (self.isa.method_msgSend["shortMonthSymbols"] || _objj_forward)(self, "shortMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", dateComponent)))
                    return nil;
                month = ((___r1 = (self.isa.method_msgSend["shortMonthSymbols"] || _objj_forward)(self, "shortMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent)) + 1;
            }
            if (length == 4)
            {
                if (!((___r1 = (self.isa.method_msgSend["monthSymbols"] || _objj_forward)(self, "monthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", dateComponent)))
                    return nil;
                month = ((___r1 = (self.isa.method_msgSend["monthSymbols"] || _objj_forward)(self, "monthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent)) + 1;
            }
            if (month > 12 || length >= 5)
                return nil;
            dateArray[1] = month;
            break;
        case "L":
            var month;
            if (length <= 2)
                month = parseInt(dateComponent);
            if (length == 3)
            {
                if (!((___r1 = (self.isa.method_msgSend["shortStandaloneMonthSymbols"] || _objj_forward)(self, "shortStandaloneMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", dateComponent)))
                    return nil;
                month = ((___r1 = (self.isa.method_msgSend["shortStandaloneMonthSymbols"] || _objj_forward)(self, "shortStandaloneMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent)) + 1;
            }
            if (length == 4)
            {
                if (!((___r1 = (self.isa.method_msgSend["standaloneMonthSymbols"] || _objj_forward)(self, "standaloneMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", dateComponent)))
                    return nil;
                month = ((___r1 = (self.isa.method_msgSend["standaloneMonthSymbols"] || _objj_forward)(self, "standaloneMonthSymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent)) + 1;
            }
            if (month > 12 || length >= 5)
                return nil;
            dateArray[1] = month;
            break;
        case "I":
            CPLog.warn("Depreacted - Token not yet implemented " + token);
            break;
        case "w":
            if (dateComponent > 52)
                return nil;
            weekOfYear = dateComponent;
            break;
        case "W":
            if (dateComponent > 52)
                return nil;
            weekOfMonth = dateComponent;
            break;
        case "d":
            dateArray[2] = parseInt(dateComponent);
            break;
        case "D":
            if (isNaN(parseInt(dateComponent)) || parseInt(dateComponent) > 345)
                return nil;
            dayOfYear = parseInt(dateComponent);
            break;
        case "F":
            if (isNaN(parseInt(dateComponent)) || parseInt(dateComponent) > 5 || parseInt(dateComponent) == 0)
                return nil;
            if (parseInt(dateComponent) == 1)
                dateArray[2] = 1;
            if (parseInt(dateComponent) == 2)
                dateArray[2] = 8;
            if (parseInt(dateComponent) == 3)
                dateArray[2] = 15;
            if (parseInt(dateComponent) == 4)
                dateArray[2] = 22;
            if (parseInt(dateComponent) == 5)
                dateArray[2] = 29;
            break;
        case "g":
            CPLog.warn("Token not yet implemented " + token);
            break;
        case "E":
            if (length <= 3)
                dayIndexInWeek = ((___r1 = (self.isa.method_msgSend["shortWeekdaySymbols"] || _objj_forward)(self, "shortWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent));
            if (length == 4)
                dayIndexInWeek = ((___r1 = (self.isa.method_msgSend["weekdaySymbols"] || _objj_forward)(self, "weekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent));
            if (dayIndexInWeek == CPNotFound || length >= 5)
                return nil;
            break;
        case "e":
            if (length <= 2 && isNaN(parseInt(dateComponent)))
                return nil;
            if (length <= 2)
                dayIndexInWeek = parseInt(dateComponent);
            if (length == 3)
                dayIndexInWeek = ((___r1 = (self.isa.method_msgSend["shortWeekdaySymbols"] || _objj_forward)(self, "shortWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent));
            if (length == 4)
                dayIndexInWeek = ((___r1 = (self.isa.method_msgSend["weekdaySymbols"] || _objj_forward)(self, "weekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent));
            if (dayIndexInWeek == CPNotFound || length >= 5)
                return nil;
            break;
        case "c":
            if (length <= 2 && isNaN(parseInt(dateComponent)))
                return nil;
            if (length <= 2)
                dayIndexInWeek = dateComponent;
            if (length == 3)
                dayIndexInWeek = ((___r1 = (self.isa.method_msgSend["shortStandaloneWeekdaySymbols"] || _objj_forward)(self, "shortStandaloneWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent));
            if (length == 4)
                dayIndexInWeek = ((___r1 = (self.isa.method_msgSend["standaloneWeekdaySymbols"] || _objj_forward)(self, "standaloneWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent));
            if (length == 5)
                dayIndexInWeek = ((___r1 = (self.isa.method_msgSend["veryShortStandaloneWeekdaySymbols"] || _objj_forward)(self, "veryShortStandaloneWeekdaySymbols")), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", dateComponent));
            if (dayIndexInWeek == CPNotFound || length >= 5)
                return nil;
            break;
        case "a":
            if (!(dateComponent == null ? null : (dateComponent.isa.method_msgSend["isEqualToString:"] || _objj_forward)(dateComponent, "isEqualToString:", (self.isa.method_msgSend["PMSymbol"] || _objj_forward)(self, "PMSymbol"))) && !(dateComponent == null ? null : (dateComponent.isa.method_msgSend["isEqualToString:"] || _objj_forward)(dateComponent, "isEqualToString:", (self.isa.method_msgSend["AMSymbol"] || _objj_forward)(self, "AMSymbol"))))
                return nil;
            if ((dateComponent == null ? null : (dateComponent.isa.method_msgSend["isEqualToString:"] || _objj_forward)(dateComponent, "isEqualToString:", (self.isa.method_msgSend["PMSymbol"] || _objj_forward)(self, "PMSymbol"))))
                isPM = YES;
            break;
        case "h":
            if (parseInt(dateComponent) < 0 || parseInt(dateComponent) > 12)
                return nil;
            dateArray[3] = parseInt(dateComponent);
            break;
        case "H":
            if (parseInt(dateComponent) < 0 || parseInt(dateComponent) > 23)
                return nil;
            dateArray[3] = parseInt(dateComponent);
            break;
        case "K":
            if (parseInt(dateComponent) < 0 || parseInt(dateComponent) > 11)
                return nil;
            dateArray[3] = parseInt(dateComponent);
            break;
        case "k":
            if (parseInt(dateComponent) < 0 || parseInt(dateComponent) > 12)
                return nil;
            dateArray[3] = parseInt(dateComponent);
            break;
        case "j":
            CPLog.warn("Token not yet implemented " + token);
            break;
        case "m":
            var minutes = parseInt(dateComponent);
            if (minutes > 59)
                return nil;
            dateArray[4] = minutes;
            break;
        case "s":
            var seconds = parseInt(dateComponent);
            if (seconds > 59)
                return nil;
            dateArray[5] = seconds;
            break;
        case "S":
            if (isNaN(parseInt(dateComponent)))
                return nil;
            break;
        case "A":
            if (isNaN(parseInt(dateComponent)))
                return nil;
            var millisecondsInDay = parseInt(dateComponent),
                tmpDate = new Date();
            tmpDate.setHours(0);
            tmpDate.setMinutes(0);
            tmpDate.setSeconds(0);
            tmpDate.setMilliseconds(0);
            tmpDate.setMilliseconds(millisecondsInDay);
            dateArray[3] = tmpDate.getHours();
            dateArray[4] = tmpDate.getMinutes();
            dateArray[5] = tmpDate.getSeconds();
            break;
        case "z":
            if (length < 4)
                timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneString:style:"] || _objj_forward)(self, "_secondsFromTimeZoneString:style:", dateComponent, CPTimeZoneNameStyleShortDaylightSaving);
            else
                timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneString:style:"] || _objj_forward)(self, "_secondsFromTimeZoneString:style:", dateComponent, CPTimeZoneNameStyleDaylightSaving);
            if (!timeZoneseconds)
                timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneDefaultFormatString:"] || _objj_forward)(self, "_secondsFromTimeZoneDefaultFormatString:", dateComponent);
            if (!timeZoneseconds)
                return nil;
            timeZoneseconds = timeZoneseconds + 60 * 60;
            break;
        case "Z":
            timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneDefaultFormatString:"] || _objj_forward)(self, "_secondsFromTimeZoneDefaultFormatString:", dateComponent);
            if (!timeZoneseconds)
                return nil;
            timeZoneseconds = timeZoneseconds + 60 * 60;
            break;
        case "v":
            if (length <= 3)
                timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneString:style:"] || _objj_forward)(self, "_secondsFromTimeZoneString:style:", dateComponent, CPTimeZoneNameStyleShortGeneric);
            else
                timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneString:style:"] || _objj_forward)(self, "_secondsFromTimeZoneString:style:", dateComponent, CPTimeZoneNameStyleGeneric);
            if (!timeZoneseconds && length == 4)
                timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneDefaultFormatString:"] || _objj_forward)(self, "_secondsFromTimeZoneDefaultFormatString:", dateComponent);
            if (!timeZoneseconds)
                return nil;
            timeZoneseconds = timeZoneseconds + 60 * 60;
            break;
        case "V":
            if (length <= 3)
                timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneString:style:"] || _objj_forward)(self, "_secondsFromTimeZoneString:style:", dateComponent, CPTimeZoneNameStyleShortStandard);
            else
                timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneString:style:"] || _objj_forward)(self, "_secondsFromTimeZoneString:style:", dateComponent, CPTimeZoneNameStyleStandard);
            if (!timeZoneseconds)
                timeZoneseconds = (self.isa.method_msgSend["_secondsFromTimeZoneDefaultFormatString:"] || _objj_forward)(self, "_secondsFromTimeZoneDefaultFormatString:", dateComponent);
            if (!timeZoneseconds)
                return nil;
            timeZoneseconds = timeZoneseconds + 60 * 60;
            break;
default:
            CPLog.warn("No pattern found for " + token);
            return nil;
        }
    }
    if (dayOfYear)
    {
        var tmpDate = new Date();
        tmpDate.setFullYear(dateArray[0]);
        tmpDate.setMonth(0);
        tmpDate.setDate(dayOfYear);
        dateArray[1] = tmpDate.getMonth() + 1;
        dateArray[2] = tmpDate.getDate();
    }
    if (weekOfMonth)
        dateArray[2] = (weekOfMonth - 1) * 7 + 1;
    if (weekOfYear)
    {
        var tmpDate = new Date();
        tmpDate.setFullYear(dateArray[0]);
        tmpDate.setMonth(0);
        tmpDate.setDate(1);
        while (tmpDate.getDay() != 0)
            tmpDate.setDate(tmpDate.getDate() + 1);
        tmpDate.setDate(tmpDate.getDate() + (weekOfYear - 1) * 7);
        dateArray[1] = tmpDate.getMonth() + 1;
        dateArray[2] = tmpDate.getDate() - 1;
    }
    var tmpDate = new Date();
    tmpDate.setMonth(dateArray[1] - 1);
    tmpDate.setFullYear(dateArray[0]);
    if (dateArray[2] <= 0 || dateArray[2] > (tmpDate == null ? null : (tmpDate.isa.method_msgSend["_daysInMonth"] || _objj_forward)(tmpDate, "_daysInMonth")))
        return nil;
    if (isPM)
        dateArray[3] += 12;
    if (isNaN(parseInt(dateArray[0])) || isNaN(parseInt(dateArray[1])) || isNaN(parseInt(dateArray[2])) || isNaN(parseInt(dateArray[3])) || isNaN(parseInt(dateArray[4])) || isNaN(parseInt(dateArray[5])) || isNaN(parseInt(dateArray[6])))
        return nil;
    var dateResult = ((___r1 = (CPDate.isa.method_msgSend["alloc"] || _objj_forward)(CPDate, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%04d-%02d-%02d %02d:%02d:%02d %s", dateArray[0], dateArray[1], dateArray[2], dateArray[3], dateArray[4], dateArray[5], dateArray[6])));
    dateResult.setSeconds(dateResult.getSeconds() - timeZoneseconds + 60 * 60);
    return dateResult;
    var ___r1;
}
,["CPDate","CPArray","CPArray"]), new objj_method(sel_getUid("_stringValueForValue:length:"), function(self, _cmd, aValue, length)
{
    var string = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%i", aValue);
    if ((string == null ? null : (string.isa.method_msgSend["length"] || _objj_forward)(string, "length")) == length)
        return string;
    if ((string == null ? null : (string.isa.method_msgSend["length"] || _objj_forward)(string, "length")) > length)
        return (string == null ? null : (string.isa.method_msgSend["substringFromIndex:"] || _objj_forward)(string, "substringFromIndex:", (string == null ? null : (string.isa.method_msgSend["length"] || _objj_forward)(string, "length")) - length));
    while ((string == null ? null : (string.isa.method_msgSend["length"] || _objj_forward)(string, "length")) < length)
        string = (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "0%s", string);
    return string;
}
,["CPString","id","int"]), new objj_method(sel_getUid("_isAmericanFormat"), function(self, _cmd)
{
    return ((___r1 = ((___r2 = self._locale), ___r2 == null ? null : (___r2.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r2, "objectForKey:", CPLocaleCountryCode))), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToString:"] || _objj_forward)(___r1, "isEqualToString:", "US"));
    var ___r1, ___r2;
}
,["BOOL"]), new objj_method(sel_getUid("_isEnglishFormat"), function(self, _cmd)
{
    return ((___r1 = ((___r2 = self._locale), ___r2 == null ? null : (___r2.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r2, "objectForKey:", CPLocaleLanguageCode))), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToString:"] || _objj_forward)(___r1, "isEqualToString:", "en"));
    var ___r1, ___r2;
}
,["BOOL"]), new objj_method(sel_getUid("_secondsFromTimeZoneDefaultFormatString:"), function(self, _cmd, aTimeZoneFormatString)
{
    var format = /\w*([HPG-GMT])?([+-])(\d{1,2})([:])?(\d{2})\w*/,
        result = aTimeZoneFormatString.match(new RegExp(format)),
        seconds = 0;
    if (!result)
        return nil;
    seconds = result[3] * 60 * 60 + result[5] * 60;
    if (((___r1 = result[2]), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToString:"] || _objj_forward)(___r1, "isEqualToString:", "-")))
        seconds = -seconds;
    return seconds;
    var ___r1;
}
,["int","CPString"]), new objj_method(sel_getUid("_secondsFromTimeZoneString:style:"), function(self, _cmd, aTimeZoneString, aStyle)
{
    var timeZone = (CPTimeZone.isa.method_msgSend["_timeZoneFromString:style:locale:"] || _objj_forward)(CPTimeZone, "_timeZoneFromString:style:locale:", aTimeZoneString, aStyle, self._locale);
    if (!timeZone)
        return nil;
    return (timeZone == null ? null : (timeZone.isa.method_msgSend["secondsFromGMT"] || _objj_forward)(timeZone, "secondsFromGMT"));
}
,["int","CPString","NSTimeZoneNameStyle"]), new objj_method(sel_getUid("_lastIndexMatchedString:token:index:"), function(self, _cmd, aString, aToken, anIndex)
{
    var character = (aToken == null ? null : (aToken.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(aToken, "characterAtIndex:", 0)),
        length = (aToken == null ? null : (aToken.isa.method_msgSend["length"] || _objj_forward)(aToken, "length")),
        targetedArray,
        format = /\w*([HPG-GMT])?([+-])(\d{1,2})([:])?(\d{2})\w*/,
        result = aString.match(new RegExp(format));
    switch(character) {
    case "Q":
        if (length == 3)
            targetedArray = (self.isa.method_msgSend["shortQuarterSymbols"] || _objj_forward)(self, "shortQuarterSymbols");
        if (length >= 4)
            targetedArray = (self.isa.method_msgSend["quarterSymbols"] || _objj_forward)(self, "quarterSymbols");
        break;
    case "q":
        if (length == 3)
            targetedArray = (self.isa.method_msgSend["shortStandaloneQuarterSymbols"] || _objj_forward)(self, "shortStandaloneQuarterSymbols");
        if (length >= 4)
            targetedArray = (self.isa.method_msgSend["standaloneQuarterSymbols"] || _objj_forward)(self, "standaloneQuarterSymbols");
        break;
    case "M":
        if (length == 3)
            targetedArray = (self.isa.method_msgSend["shortMonthSymbols"] || _objj_forward)(self, "shortMonthSymbols");
        if (length == 4)
            targetedArray = (self.isa.method_msgSend["monthSymbols"] || _objj_forward)(self, "monthSymbols");
        if (length >= 5)
            targetedArray = (self.isa.method_msgSend["veryShortMonthSymbols"] || _objj_forward)(self, "veryShortMonthSymbols");
        break;
    case "L":
        if (length == 3)
            targetedArray = (self.isa.method_msgSend["shortStandaloneMonthSymbols"] || _objj_forward)(self, "shortStandaloneMonthSymbols");
        if (length == 4)
            targetedArray = (self.isa.method_msgSend["standaloneMonthSymbols"] || _objj_forward)(self, "standaloneMonthSymbols");
        if (length >= 5)
            targetedArray = (self.isa.method_msgSend["veryShortStandaloneMonthSymbols"] || _objj_forward)(self, "veryShortStandaloneMonthSymbols");
        break;
    case "E":
        if (length <= 3)
            targetedArray = (self.isa.method_msgSend["shortWeekdaySymbols"] || _objj_forward)(self, "shortWeekdaySymbols");
        if (length == 4)
            targetedArray = (self.isa.method_msgSend["weekdaySymbols"] || _objj_forward)(self, "weekdaySymbols");
        if (length >= 5)
            targetedArray = (self.isa.method_msgSend["veryShortWeekdaySymbols"] || _objj_forward)(self, "veryShortWeekdaySymbols");
        break;
    case "e":
        if (length == 3)
            targetedArray = (self.isa.method_msgSend["shortWeekdaySymbols"] || _objj_forward)(self, "shortWeekdaySymbols");
        if (length == 4)
            targetedArray = (self.isa.method_msgSend["weekdaySymbols"] || _objj_forward)(self, "weekdaySymbols");
        if (length >= 5)
            targetedArray = (self.isa.method_msgSend["veryShortWeekdaySymbols"] || _objj_forward)(self, "veryShortWeekdaySymbols");
        break;
    case "c":
        if (length == 3)
            targetedArray = (self.isa.method_msgSend["shortStandaloneWeekdaySymbols"] || _objj_forward)(self, "shortStandaloneWeekdaySymbols");
        if (length == 4)
            targetedArray = (self.isa.method_msgSend["standaloneWeekdaySymbols"] || _objj_forward)(self, "standaloneWeekdaySymbols");
        if (length >= 5)
            targetedArray = (self.isa.method_msgSend["veryShortStandaloneWeekdaySymbols"] || _objj_forward)(self, "veryShortStandaloneWeekdaySymbols");
        break;
    case "a":
        targetedArray = [(self.isa.method_msgSend["PMSymbol"] || _objj_forward)(self, "PMSymbol"), (self.isa.method_msgSend["AMSymbol"] || _objj_forward)(self, "AMSymbol")];
        break;
    case "z":
        if (length <= 3)
            targetedArray = (CPTimeZone.isa.method_msgSend["_namesForStyle:locale:"] || _objj_forward)(CPTimeZone, "_namesForStyle:locale:", CPTimeZoneNameStyleShortDaylightSaving, self._locale);
        else
            targetedArray = (CPTimeZone.isa.method_msgSend["_namesForStyle:locale:"] || _objj_forward)(CPTimeZone, "_namesForStyle:locale:", CPTimeZoneNameStyleDaylightSaving, self._locale);
        if (result)
            return anIndex + (result == null ? null : (result.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(result, "objectAtIndex:", 0)).length;
        break;
    case "Z":
        if (result)
            return anIndex + (result == null ? null : (result.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(result, "objectAtIndex:", 0)).length;
        return CPNotFound;
    case "v":
        if (length == 1)
            targetedArray = (CPTimeZone.isa.method_msgSend["_namesForStyle:locale:"] || _objj_forward)(CPTimeZone, "_namesForStyle:locale:", CPTimeZoneNameStyleShortGeneric, self._locale);
        else if (length == 4)
            targetedArray = (CPTimeZone.isa.method_msgSend["_namesForStyle:locale:"] || _objj_forward)(CPTimeZone, "_namesForStyle:locale:", CPTimeZoneNameStyleGeneric, self._locale);
        if (result)
            return anIndex + (result == null ? null : (result.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(result, "objectAtIndex:", 0)).length;
        break;
    case "V":
        if (length == 1)
            targetedArray = (CPTimeZone.isa.method_msgSend["_namesForStyle:locale:"] || _objj_forward)(CPTimeZone, "_namesForStyle:locale:", CPTimeZoneNameStyleShortStandard, self._locale);
        if (result)
            return anIndex + (result == null ? null : (result.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(result, "objectAtIndex:", 0)).length;
        break;
default:
        CPLog.warn("No pattern found for " + aToken);
        return CPNotFound;
    }
    for (var i = 0; i < (targetedArray == null ? null : (targetedArray.isa.method_msgSend["count"] || _objj_forward)(targetedArray, "count")); i++)
    {
        var currentObject = (targetedArray == null ? null : (targetedArray.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(targetedArray, "objectAtIndex:", i)),
            range = (aString == null ? null : (aString.isa.method_msgSend["rangeOfString:"] || _objj_forward)(aString, "rangeOfString:", currentObject));
        if (range.length == 0)
            continue;
        character = (aString == null ? null : (aString.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(aString, "characterAtIndex:", anIndex + range.length));
        if ((character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "'")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", ",")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", ":")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "/")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "-")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", " ")) || (character == null ? null : (character.isa.method_msgSend["isEqualToString:"] || _objj_forward)(character, "isEqualToString:", "")))
            return anIndex + range.length;
    }
    return CPNotFound;
}
,["int","CPString","CPString","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("initialize"), function(self, _cmd)
{
    if (self !== (CPDateFormatter.isa.method_msgSend["class"] || _objj_forward)(CPDateFormatter, "class"))
        return;
    relativeDateFormating = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [["demain", 1, "apr" + String.fromCharCode(233) + "s-demain", 2, "apr" + String.fromCharCode(233) + "s-apr" + String.fromCharCode(233) + "s-demain", 3, "hier", -1, "avant-hier", -2, "avant-avant-hier", -3], ["tomorrow", 1, "yesterday", -1], [], []], ["fr", "en", "de", "es"]));
    patternStringTokens = ["QQQ", "qqq", "QQQQ", "qqqq", "MMM", "MMMM", "LLL", "LLLL", "E", "EE", "EEE", "eee", "eeee", "eeeee", "a", "z", "zz", "zzz", "zzzz", "Z", "ZZ", "ZZZ", "ZZZZ", "ZZZZZ", "v", "vv", "vvv", "vvvv", "V", "VV", "VVV", "VVVV"];
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("localizedStringFromDate:dateStyle:timeStyle:"), function(self, _cmd, date, dateStyle, timeStyle)
{
    var formatter = ((___r1 = (CPDateFormatter.isa.method_msgSend["alloc"] || _objj_forward)(CPDateFormatter, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    (formatter == null ? null : (formatter.isa.method_msgSend["setFormatterBehavior:"] || _objj_forward)(formatter, "setFormatterBehavior:", CPDateFormatterBehavior10_4));
    (formatter == null ? null : (formatter.isa.method_msgSend["setDateStyle:"] || _objj_forward)(formatter, "setDateStyle:", dateStyle));
    (formatter == null ? null : (formatter.isa.method_msgSend["setTimeStyle:"] || _objj_forward)(formatter, "setTimeStyle:", timeStyle));
    return (formatter == null ? null : (formatter.isa.method_msgSend["stringForObjectValue:"] || _objj_forward)(formatter, "stringForObjectValue:", date));
    var ___r1;
}
,["CPString","CPDate","CPDateFormatterStyle","CPDateFormatterStyle"]), new objj_method(sel_getUid("dateFormatFromTemplate:options:locale:"), function(self, _cmd, template, opts, locale)
{
}
,["CPString","CPString","CPUInteger","CPLocale"]), new objj_method(sel_getUid("defaultFormatterBehavior"), function(self, _cmd)
{
    return defaultDateFormatterBehavior;
}
,["CPDateFormatterBehavior"]), new objj_method(sel_getUid("setDefaultFormatterBehavior:"), function(self, _cmd, behavior)
{
    defaultDateFormatterBehavior = behavior;
}
,["void","CPDateFormatterBehavior"])]);
}var CPDateFormatterDateStyleKey = "CPDateFormatterDateStyle",
    CPDateFormatterTimeStyleKey = "CPDateFormatterTimeStyleKey",
    CPDateFormatterFormatterBehaviorKey = "CPDateFormatterFormatterBehaviorKey",
    CPDateFormatterDoseRelativeDateFormattingKey = "CPDateFormatterDoseRelativeDateFormattingKey",
    CPDateFormatterDateFormatKey = "CPDateFormatterDateFormatKey",
    CPDateFormatterAllowNaturalLanguageKey = "CPDateFormatterAllowNaturalLanguageKey",
    CPDateFormatterLocaleKey = "CPDateFormatterLocaleKey";
{
var the_class = objj_getClass("CPDateFormatter")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPDateFormatter\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    self = (objj_getClass("CPDateFormatter").super_class.method_dtable["initWithCoder:"] || _objj_forward)(self, "initWithCoder:", aCoder);
    if (self)
    {
        self._allowNaturalLanguage = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPDateFormatterAllowNaturalLanguageKey));
        self._dateFormat = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPDateFormatterDateFormatKey));
        self._dateStyle = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPDateFormatterDateStyleKey));
        self._doesRelativeDateFormatting = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPDateFormatterDoseRelativeDateFormattingKey));
        self._formatterBehavior = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPDateFormatterFormatterBehaviorKey));
        self._locale = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPDateFormatterLocaleKey));
        self._timeStyle = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPDateFormatterTimeStyleKey));
    }
    (self == null ? null : (self.isa.method_msgSend["_init"] || _objj_forward)(self, "_init"));
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (objj_getClass("CPDateFormatter").super_class.method_dtable["encodeWithCoder:"] || _objj_forward)(self, "encodeWithCoder:", aCoder);
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._allowNaturalLanguage, CPDateFormatterAllowNaturalLanguageKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._dateStyle, CPDateFormatterDateStyleKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._dateFormat, CPDateFormatterDateFormatKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._doesRelativeDateFormatting, CPDateFormatterDoseRelativeDateFormattingKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._formatterBehavior, CPDateFormatterFormatterBehaviorKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._locale, CPDateFormatterLocaleKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._timeStyle, CPDateFormatterTimeStyleKey));
}
,["void","CPCoder"])]);
}{
var the_class = objj_getClass("CPDate")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPDate\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("_dateWithTimeZone:"), function(self, _cmd, aTimeZone)
{
    if (!aTimeZone)
        return;
    self.setSeconds(self.getSeconds() - (aTimeZone == null ? null : (aTimeZone.isa.method_msgSend["secondsFromGMTForDate:"] || _objj_forward)(aTimeZone, "secondsFromGMTForDate:", self)));
    self.setSeconds(self.getSeconds() + (aTimeZone == null ? null : (aTimeZone.isa.method_msgSend["secondsFromGMT"] || _objj_forward)(aTimeZone, "secondsFromGMT")));
}
,["void","CPTimeZone"])]);
}p;11;CPDecimal.jt;28620;@STATIC;1.0;i;9;CPArray.ji;10;CPNumber.jt;28572;objj_executeFile("CPArray.j", YES);objj_executeFile("CPNumber.j", YES);{var the_typedef = objj_allocateTypeDef("CPDecimal");
objj_registerTypeDef(the_typedef);
}CPDecimalMaxDigits = 38;
CPDecimalMaxExponent = 127;
CPDecimalMinExponent = -128;
CPDecimalNoScale = 128;
CPCalculationNoError = 0;
CPCalculationLossOfPrecision = 1;
CPCalculationOverflow = 2;
CPCalculationUnderflow = 3;
CPCalculationDivideByZero = 4;
{var the_typedef = objj_allocateTypeDef("CPRoundingMode");
objj_registerTypeDef(the_typedef);
}CPRoundPlain = 1;
CPRoundDown = 2;
CPRoundUp = 3;
CPRoundBankers = 4;
_CPRoundHalfDown = 5;
CPDecimalNumberOverflowException = "CPDecimalNumberOverflowException";
CPDecimalNumberUnderflowException = "CPDecimalNumberUnderflowException";
CPDecimalNumberExactnessException = "CPDecimalNumberExactnessException";
CPDecimalNumberDivideByZeroException = "CPDecimalNumberDivideByZeroException";
CPDecimalMakeWithString = function(string, locale)
{
    if (!string)
        return CPDecimalMakeNaN();
    var matches = string.match(/^([+\-]?)((?:0|[0-9]\d*)?)(?:\.(\d*))?(?:[eE]([+\-]?)(\d+))?$/);
    if (!matches)
        return CPDecimalMakeNaN();
    var ds = matches[1],
        intpart = matches[2],
        decpart = matches[3],
        es = matches[4],
        exp = matches[5];
    var isNegative = NO;
    if (ds && ds === "-")
        isNegative = YES;
    var exponent = 0;
    if (exp)
        exponent = parseInt(exp) * (es && es === "-" ? -1 : 1);
    if (decpart)
        exponent -= decpart.length;
    var inputlength = (intpart ? intpart.length : 0) + (decpart ? decpart.length : 0);
    if (inputlength > CPDecimalMaxDigits)
    {
        exponent += inputlength - CPDecimalMaxDigits;
    }
    else if (inputlength === 0)
    {
        return CPDecimalMakeNaN();
    }
    if (exponent > CPDecimalMaxExponent || exponent < CPDecimalMinExponent)
        return CPDecimalMakeNaN();
    var m = [],
        i = 0;
    for (; i < (intpart ? intpart.length : 0); i++)
    {
        if (i >= CPDecimalMaxDigits)
            break;
        Array.prototype.push.call(m, parseInt(intpart.charAt(i)));
    }
    var j = 0;
    for (; j < (decpart ? decpart.length : 0); j++)
    {
        if (i + j >= CPDecimalMaxDigits)
            break;
        Array.prototype.push.call(m, parseInt(decpart.charAt(j)));
    }
    var dcm = {_exponent: exponent, _isNegative: isNegative, _isCompact: NO, _isNaN: NO, _mantissa: m};
    CPDecimalCompact(dcm);
    return dcm;
}
CPDecimalMakeWithParts = function(mantissa, exponent)
{
    var m = [],
        isNegative = NO;
    if (mantissa < 0)
    {
        isNegative = YES;
        mantissa = ABS(mantissa);
    }
    if (mantissa == 0)
        Array.prototype.push.call(m, 0);
    if (exponent > CPDecimalMaxExponent || exponent < CPDecimalMinExponent)
        return CPDecimalMakeNaN();
    while (mantissa > 0 && m.length < CPDecimalMaxDigits)
    {
        Array.prototype.unshift.call(m, parseInt(mantissa % 10));
        mantissa = FLOOR(mantissa / 10);
    }
    var dcm = {_exponent: exponent, _isNegative: isNegative, _isCompact: YES, _isNaN: NO, _mantissa: m};
    CPDecimalCompact(dcm);
    return dcm;
}
CPDecimalMakeZero = function()
{
    return CPDecimalMakeWithParts(0, 0);
}
CPDecimalMakeOne = function()
{
    return CPDecimalMakeWithParts(1, 0);
}
CPDecimalMakeNaN = function()
{
    var d = CPDecimalMakeWithParts(0, 0);
    d._isNaN = YES;
    return d;
}
_CPDecimalMakeMaximum = function()
{
    var s = "",
        i = 0;
    for (; i < CPDecimalMaxDigits; i++)
        s += "9";
    s += "e" + CPDecimalMaxExponent;
    return CPDecimalMakeWithString(s);
}
_CPDecimalMakeMinimum = function()
{
    var s = "-",
        i = 0;
    for (; i < CPDecimalMaxDigits; i++)
        s += "9";
    s += "e" + CPDecimalMaxExponent;
    return CPDecimalMakeWithString(s);
}
CPDecimalIsZero = function(dcm)
{
    if (!dcm._isNaN)
    {
        for (var i = 0; i < dcm._mantissa.length; i++)
            if (dcm._mantissa[i] !== 0)
                return NO;
        return YES;
    }
    return NO;
}
CPDecimalIsOne = function(dcm)
{
    CPDecimalCompact(dcm);
    if (!dcm._isNaN)
    {
        if (dcm._mantissa && dcm._mantissa.length == 1 && dcm._mantissa[0] == 1)
            return YES;
    }
    return NO;
}
_CPDecimalSet = function(t, s)
{
    t._exponent = s._exponent;
    t._isNegative = s._isNegative;
    t._isCompact = s._isCompact;
    t._isNaN = s._isNaN;
    t._mantissa = Array.prototype.slice.call(s._mantissa, 0);
}
_CPDecimalSetZero = function(result)
{
    result._mantissa = [0];
    result._exponent = 0;
    result._isNegative = NO;
    result._isCompact = YES;
    result._isNaN = NO;
}
_CPDecimalSetOne = function(result)
{
    result._mantissa = [1];
    result._exponent = 0;
    result._isNegative = NO;
    result._isCompact = YES;
    result._isNaN = NO;
}
CPDecimalIsNotANumber = function(dcm)
{
    return dcm._isNaN ? YES : NO;
}
CPDecimalCopy = function(dcm)
{
    return {_exponent: dcm._exponent, _isNegative: dcm._isNegative, _isCompact: dcm._isCompact, _isNaN: dcm._isNaN, _mantissa: Array.prototype.slice.call(dcm._mantissa, 0)};
}
CPDecimalCompare = function(leftOperand, rightOperand)
{
    if (leftOperand._isNaN && rightOperand._isNaN)
        return CPOrderedSame;
    if (leftOperand._isNegative != rightOperand._isNegative)
    {
        if (rightOperand._isNegative)
            return CPOrderedDescending;
        else
            return CPOrderedAscending;
    }
    var leftIsZero = leftOperand._mantissa.length == 1 && leftOperand._mantissa[0] == 0,
        rightIsZero = rightOperand._mantissa.length == 1 && rightOperand._mantissa[0] == 0,
        s1 = leftOperand._exponent + leftOperand._mantissa.length,
        s2 = rightOperand._exponent + rightOperand._mantissa.length;
    if (leftIsZero && rightIsZero)
        return CPOrderedSame;
    if (leftIsZero || s1 < s2 && !rightIsZero)
    {
        if (rightOperand._isNegative)
            return CPOrderedDescending;
        else
            return CPOrderedAscending;
    }
    if (rightIsZero || s1 > s2 && !leftIsZero)
    {
        if (leftOperand._isNegative)
            return CPOrderedAscending;
        else
            return CPOrderedDescending;
    }
    var l = MIN(leftOperand._mantissa.length, rightOperand._mantissa.length),
        i = 0;
    for (; i < l; i++)
    {
        var d = rightOperand._mantissa[i] - leftOperand._mantissa[i];
        if (d > 0)
        {
            if (rightOperand._isNegative)
                return CPOrderedDescending;
            else
                return CPOrderedAscending;
        }
        if (d < 0)
        {
            if (rightOperand._isNegative)
                return CPOrderedAscending;
            else
                return CPOrderedDescending;
        }
    }
    if (leftOperand._mantissa.length > rightOperand._mantissa.length)
    {
        if (rightOperand._isNegative)
            return CPOrderedAscending;
        else
            return CPOrderedDescending;
    }
    if (leftOperand._mantissa.length < rightOperand._mantissa.length)
    {
        if (rightOperand._isNegative)
            return CPOrderedDescending;
        else
            return CPOrderedAscending;
    }
    return CPOrderedSame;
}
_SimpleAdd = function(result, leftOperand, rightOperand, roundingMode, longMode)
{
    var factor = longMode ? 2 : 1;
    _CPDecimalSet(result, leftOperand);
    var j = leftOperand._mantissa.length - rightOperand._mantissa.length,
        l = rightOperand._mantissa.length,
        i = l - 1,
        carry = 0,
        error = CPCalculationNoError;
    for (; i >= 0; i--)
    {
        var d = rightOperand._mantissa[i] + result._mantissa[i + j] + carry;
        if (d >= 10)
        {
            d = d % 10;
            carry = 1;
        }
        else
            carry = 0;
        result._mantissa[i + j] = d;
    }
    if (carry)
    {
        for (i = j - 1; i >= 0; i--)
        {
            if (result._mantissa[i] != 9)
            {
                result._mantissa[i]++;
                carry = 0;
                break;
            }
            result._mantissa[i] = 0;
        }
        if (carry)
        {
            Array.prototype.splice.call(result._mantissa, 0, 0, 1);
            if (CPDecimalMaxDigits * factor == leftOperand._mantissa.length)
            {
                var scale = -result._exponent - 1;
                CPDecimalRound(result, result, scale, roundingMode);
            }
            if (CPDecimalMaxExponent < result._exponent)
            {
                result._isNaN = YES;
                error = CPCalculationOverflow;
                result._exponent = CPDecimalMaxExponent;
            }
        }
    }
    return error;
}
CPDecimalAdd = function(result, leftOperand, rightOperand, roundingMode, longMode)
{
    if (leftOperand._isNaN || rightOperand._isNaN)
    {
        result._isNaN = YES;
        return CPCalculationNoError;
    }
    if (CPDecimalIsZero(leftOperand))
    {
        _CPDecimalSet(result, rightOperand);
        return CPCalculationNoError;
    }
    if (CPDecimalIsZero(rightOperand))
    {
        _CPDecimalSet(result, leftOperand);
        return CPCalculationNoError;
    }
    var n1 = CPDecimalCopy(leftOperand),
        n2 = CPDecimalCopy(rightOperand);
    if (leftOperand._isNegative != rightOperand._isNegative)
    {
        if (leftOperand._isNegative)
        {
            n1._isNegative = NO;
            return CPDecimalSubtract(result, rightOperand, n1, roundingMode);
        }
        else
        {
            n2._isNegative = NO;
            return CPDecimalSubtract(result, leftOperand, n2, roundingMode);
        }
    }
    var normerror = CPDecimalNormalize(n1, n2, roundingMode, longMode);
    var comp = 0,
        ll = n1._mantissa.length,
        lr = n2._mantissa.length;
    if (ll == lr)
        comp = CPOrderedSame;
    else if (ll > lr)
        comp = CPOrderedDescending;
    else
        comp = CPOrderedAscending;
    if (leftOperand._isNegative)
    {
        n1._isNegative = NO;
        n2._isNegative = NO;
        if (comp == CPOrderedDescending)
        {
            adderror = _SimpleAdd(result, n1, n2, roundingMode, longMode);
        }
        else
        {
            adderror = _SimpleAdd(result, n2, n1, roundingMode, longMode);
        }
        result._isNegative = YES;
        if (CPCalculationUnderflow == adderror)
            adderror = CPCalculationOverflow;
        else if (CPCalculationUnderflow == adderror)
            adderror = CPCalculationUnderflow;
    }
    else
    {
        if (comp == CPOrderedAscending)
        {
            adderror = _SimpleAdd(result, n2, n1, roundingMode, longMode);
        }
        else
        {
            adderror = _SimpleAdd(result, n1, n2, roundingMode, longMode);
        }
    }
    CPDecimalCompact(result);
    if (adderror == CPCalculationNoError)
        return normerror;
    else
        return adderror;
}
_SimpleSubtract = function(result, leftOperand, rightOperand, roundingMode)
{
    var error = CPCalculationNoError,
        borrow = 0,
        l = rightOperand._mantissa.length,
        j = leftOperand._mantissa.length - l,
        i = l - 1;
    _CPDecimalSet(result, leftOperand);
    for (; i >= 0; i--)
    {
        var d = result._mantissa[i + j] - rightOperand._mantissa[i] - borrow;
        if (d < 0)
        {
            d = d + 10;
            borrow = 1;
        }
        else
            borrow = 0;
        result._mantissa[i + j] = d;
    }
    if (borrow)
    {
        for (i = j - 1; i >= 0; i--)
        {
            if (result._mantissa[i] != 0)
            {
                result._mantissa[i]--;
                break;
            }
            result._mantissa[i] = 9;
        }
        if (-1 == i)
        {
            error = nil;
        }
    }
    return error;
}
CPDecimalSubtract = function(result, leftOperand, rightOperand, roundingMode)
{
    if (leftOperand._isNaN || rightOperand._isNaN)
    {
        result._isNaN = YES;
        return CPCalculationNoError;
    }
    if (CPDecimalIsZero(leftOperand))
    {
        _CPDecimalSet(result, rightOperand);
        result._isNegative = !result._isNegative;
        return CPCalculationNoError;
    }
    if (CPDecimalIsZero(rightOperand))
    {
        _CPDecimalSet(result, leftOperand);
        return CPCalculationNoError;
    }
    var n1 = CPDecimalCopy(leftOperand),
        n2 = CPDecimalCopy(rightOperand),
        error1 = CPCalculationNoError;
    if (leftOperand._isNegative != rightOperand._isNegative)
    {
        if (leftOperand._isNegative)
        {
            n1._isNegative = NO;
            error1 = CPDecimalAdd(result, n1, rightOperand, roundingMode);
            result._isNegative = YES;
            if (error1 == CPCalculationUnderflow)
                error1 = CPCalculationOverflow;
            else if (error1 == CPCalculationOverflow)
                error1 = CPCalculationUnderflow;
            return error1;
        }
        else
        {
            n2._isNegative = NO;
            return CPDecimalAdd(result, leftOperand, n2, roundingMode);
        }
    }
    var error = CPDecimalNormalize(n1, n2, roundingMode),
        comp = CPDecimalCompare(leftOperand, rightOperand);
    if (comp == CPOrderedSame)
    {
        _CPDecimalSetZero(result);
        return CPCalculationNoError;
    }
    if (leftOperand._isNegative)
    {
        n1._isNegative = NO;
        n2._isNegative = NO;
        if (comp == CPOrderedAscending)
        {
            error1 = _SimpleSubtract(result, n1, n2, roundingMode);
            result._isNegative = YES;
        }
        else
        {
            error1 = _SimpleSubtract(result, n2, n1, roundingMode);
        }
    }
    else
    {
        if (comp == CPOrderedAscending)
        {
            error1 = _SimpleSubtract(result, n2, n1, roundingMode);
            result._isNegative = YES;
        }
        else
        {
            error1 = _SimpleSubtract(result, n1, n2, roundingMode);
        }
    }
    CPDecimalCompact(result);
    if (error1 == CPCalculationNoError)
        return error;
    else
        return error1;
}
_SimpleDivide = function(result, leftOperand, rightOperand, roundingMode)
{
    var error = CPCalculationNoError,
        n1 = CPDecimalMakeZero(),
        k = 0,
        firsttime = YES,
        stopk = CPDecimalMaxDigits + 1,
        used = 0;
    _CPDecimalSetZero(result);
    n1._mantissa = [];
    while (used < leftOperand._mantissa.length || n1._mantissa.length && !(n1._mantissa.length == 1 && n1._mantissa[0] == 0))
    {
        while (CPOrderedAscending == CPDecimalCompare(n1, rightOperand))
        {
            if (stopk == k)
                break;
            if (n1._exponent)
            {
                Array.prototype.push.call(n1._mantissa, 0);
                n1._exponent--;
                n1._isCompact = NO;
            }
            else
            {
                if (used < leftOperand._mantissa.length)
                {
                    if (n1._mantissa.length || leftOperand._mantissa[used])
                    {
                        Array.prototype.push.call(n1._mantissa, leftOperand._mantissa[used]);
                        n1._isCompact = NO;
                    }
                    used++;
                }
                else
                {
                    if (result._exponent == CPDecimalMinExponent)
                    {
                        k = stopk;
                        break;
                    }
                    Array.prototype.push.call(n1._mantissa, 0);
                    result._exponent--;
                }
                if (!firsttime)
                {
                    k++;
                    result._mantissa[k - 1] = 0;
                }
            }
        }
        if (stopk == k)
        {
            error = CPCalculationLossOfPrecision;
            break;
        }
        if (firsttime)
        {
            firsttime = NO;
            k++;
        }
        error1 = CPDecimalSubtract(n1, n1, rightOperand, roundingMode);
        if (error1 != CPCalculationNoError)
            error = error1;
        result._mantissa[k - 1]++;
    }
    return error;
}
CPDecimalDivide = function(result, leftOperand, rightOperand, roundingMode)
{
    var error = CPCalculationNoError,
        exp = leftOperand._exponent - rightOperand._exponent,
        neg = leftOperand._isNegative != rightOperand._isNegative;
    if (leftOperand._isNaN || rightOperand._isNaN)
    {
        result._isNaN = YES;
        return CPCalculationNoError;
    }
    if (CPDecimalIsZero(rightOperand))
    {
        result._isNaN = YES;
        return CPCalculationDivideByZero;
    }
    if (CPDecimalIsZero(leftOperand))
    {
        _CPDecimalSetZero(result);
        return CPCalculationNoError;
    }
    var n1 = CPDecimalCopy(leftOperand),
        n2 = CPDecimalCopy(rightOperand);
    n1._exponent = 0;
    n1._isNegative = NO;
    n2._exponent = 0;
    n2._isNegative = NO;
    error = _SimpleDivide(result, n1, n2, roundingMode);
    CPDecimalCompact(result);
    if (result._exponent + exp > CPDecimalMaxExponent)
    {
        result._isNaN = YES;
        if (neg)
            return CPCalculationUnderflow;
        else
            return CPCalculationOverflow;
    }
    else if (result._exponent + exp < CPDecimalMinExponent)
    {
        CPDecimalRound(result, result, exp + CPDecimalMaxExponent + 1, roundingMode);
        error = CPCalculationLossOfPrecision;
        if (result._exponent + exp < CPDecimalMinExponent)
        {
            CPDecimalSetZero(result);
            return error;
        }
    }
    result._exponent += exp;
    result._isNegative = neg;
    return error;
}
_SimpleMultiply = function(result, leftOperand, rightOperand, roundingMode, powerMode)
{
    var error = CPCalculationNoError,
        carry = 0,
        exp = 0,
        n = CPDecimalMakeZero();
    _CPDecimalSetZero(result);
    for (var i = 0; i < rightOperand._mantissa.length; i++)
    {
        _CPDecimalSetZero(n);
        n._exponent = rightOperand._mantissa.length - i - 1;
        carry = 0;
        d = rightOperand._mantissa[i];
        if (d == 0)
            continue;
        for (var j = leftOperand._mantissa.length - 1; j >= 0; j--)
        {
            e = leftOperand._mantissa[j] * d + carry;
            if (e >= 10)
            {
                carry = FLOOR(e / 10);
                e = e % 10;
            }
            else
                carry = 0;
            n._mantissa[j + 1] = e;
        }
        n._mantissa[0] = carry;
        CPDecimalCompact(n);
        error1 = CPDecimalAdd(result, result, n, roundingMode, YES);
        if (error1 != CPCalculationNoError)
            error = error1;
    }
    if (result._exponent + exp > CPDecimalMaxExponent)
    {
        result._isNaN = YES;
        return CPCalculationOverflow;
    }
    result._exponent += exp;
    if (result._mantissa.length > CPDecimalMaxDigits && !powerMode)
    {
        result._isCompact = NO;
        var scale = CPDecimalMaxDigits - (result._mantissa.length + result._exponent);
        CPDecimalRound(result, result, scale, roundingMode);
        error = CPCalculationLossOfPrecision;
    }
    return error;
}
CPDecimalMultiply = function(result, leftOperand, rightOperand, roundingMode, powerMode)
{
    var error = CPCalculationNoError,
        exp = leftOperand._exponent + rightOperand._exponent,
        neg = leftOperand._isNegative != rightOperand._isNegative;
    if (leftOperand._isNaN || rightOperand._isNaN)
    {
        result._isNaN = YES;
        return CPCalculationNoError;
    }
    if (CPDecimalIsZero(rightOperand) || CPDecimalIsZero(leftOperand))
    {
        _CPDecimalSetZero(result);
        return CPCalculationNoError;
    }
    if (exp > CPDecimalMaxExponent)
    {
        result._isNaN = YES;
        if (neg)
            return CPCalculationUnderflow;
        else
            return CPCalculationOverflow;
    }
    var n1 = CPDecimalCopy(leftOperand),
        n2 = CPDecimalCopy(rightOperand);
    n1._exponent = 0;
    n2._exponent = 0;
    n1._isNegative = NO;
    n2._isNegative = NO;
    var comp = 0,
        ll = n1._mantissa.length,
        lr = n2._mantissa.length;
    if (ll == lr)
        comp = CPOrderedSame;
    else if (ll > lr)
        comp = CPOrderedDescending;
    else
        comp = CPOrderedAscending;
    if (comp == CPOrderedDescending)
    {
        error = _SimpleMultiply(result, n1, n2, roundingMode, powerMode);
    }
    else
    {
        error = _SimpleMultiply(result, n2, n1, roundingMode, powerMode);
    }
    CPDecimalCompact(result);
    if (result._exponent + exp > CPDecimalMaxExponent)
    {
        result._isNaN = YES;
        if (neg)
            return CPCalculationUnderflow;
        else
            return CPCalculationOverflow;
    }
    else if (result._exponent + exp < CPDecimalMinExponent)
    {
        CPDecimalRound(result, result, exp + CPDecimalMaxExponent + 1, roundingMode);
        error = CPCalculationLossOfPrecision;
        if (result._exponent + exp < CPDecimalMinExponent)
        {
            _CPDecimalSetZero(result);
            return error;
        }
    }
    result._exponent += exp;
    result._isNegative = neg;
    return error;
}
CPDecimalMultiplyByPowerOf10 = function(result, dcm, power, roundingMode)
{
    _CPDecimalSet(result, dcm);
    var p = result._exponent + power;
    if (p > CPDecimalMaxExponent)
    {
        result._isNaN = YES;
        return CPCalculationOverflow;
    }
    if (p < CPDecimalMinExponent)
    {
        result._isNaN = YES;
        return CPCalculationUnderflow;
    }
    result._exponent += power;
    return CPCalculationNoError;
}
CPDecimalPower = function(result, dcm, power, roundingMode)
{
    var error = CPCalculationNoError,
        neg = dcm._isNegative && power % 2,
        n1 = CPDecimalCopy(dcm);
    n1._isNegative = NO;
    _CPDecimalSetOne(result);
    var e = power;
    while (e)
    {
        if (e & 1)
        {
            error = CPDecimalMultiply(result, result, n1, roundingMode);
        }
        error = CPDecimalMultiply(n1, n1, n1, roundingMode);
        e >>= 1;
        if (error > CPCalculationLossOfPrecision)
            break;
    }
    result._isNegative = neg;
    CPDecimalCompact(result);
    return error;
}
CPDecimalNormalize = function(dcm1, dcm2, roundingMode, longMode)
{
    var factor = longMode ? 2 : 1;
    if (dcm1._isNaN || dcm2._isNaN)
        return CPCalculationNoError;
    if (!dcm1._isCompact)
        CPDecimalCompact(dcm1);
    if (!dcm2._isCompact)
        CPDecimalCompact(dcm2);
    if (dcm1._exponent == dcm2._exponent)
        return CPCalculationNoError;
    var e1 = dcm1._exponent,
        e2 = dcm2._exponent;
    var l2 = dcm2._mantissa.length,
        l1 = dcm1._mantissa.length,
        l = 0;
    var e = 0;
    if (e2 > e1 && e1 >= 0 && e2 >= 0)
        e = e2 - e1;
    else if (e2 > e1 && e1 < 0 && e2 >= 0)
        e = e2 - e1;
    else if (e2 > e1 && e1 < 0 && e2 < 0)
        e = e2 - e1;
    else if (e2 < e1 && e1 >= 0 && e2 >= 0)
        e = e1 - e2;
    else if (e2 < e1 && e1 >= 0 && e2 < 0)
        e = e1 - e2;
    else if (e2 < e1 && e1 < 0 && e2 < 0)
        e = e1 - e2;
    if (e2 > e1)
        l = MIN(CPDecimalMaxDigits * factor - l2, e);
    else
        l = MIN(CPDecimalMaxDigits * factor - l1, e);
    for (var i = 0; i < l; i++)
    {
        if (e2 > e1)
            Array.prototype.push.call(dcm2._mantissa, 0);
        else
            Array.prototype.push.call(dcm1._mantissa, 0);
    }
    if (e2 > e1)
    {
        dcm2._exponent -= l;
        dcm2._isCompact = NO;
    }
    else
    {
        dcm1._exponent -= l;
        dcm1._isCompact = NO;
    }
    if (l != ABS(e2 - e1))
    {
        if (e2 > e1)
        {
            CPDecimalRound(dcm1, dcm1, -dcm2._exponent, roundingMode);
            l1 = CPDecimalIsZero(dcm1);
        }
        else
        {
            CPDecimalRound(dcm2, dcm2, -dcm1._exponent, roundingMode);
            l2 = CPDecimalIsZero(dcm2);
        }
        if (dcm1._exponent != dcm2._exponent && (!l1 || !l2))
        {
            if (e2 > e1)
            {
                l1 = dcm1._mantissa.length;
                l = MIN(CPDecimalMaxDigits * factor - l1, ABS(dcm1._exponent - dcm2._exponent));
                for (var i = 0; i < l; i++)
                {
                    dcm1._mantissa[i + l1] = 0;
                }
                dcm1._isCompact = NO;
                dcm1._exponent = dcm2._exponent;
            }
            else
            {
                l2 = dcm2._mantissa.length;
                l = MIN(CPDecimalMaxDigits * factor - l2, ABS(dcm2._exponent - dcm1._exponent));
                for (var i = 0; i < l; i++)
                {
                    dcm2._mantissa[i + l2] = 0;
                }
                dcm2._exponent = dcm1._exponent;
                dcm2._isCompact = NO;
            }
        }
        return CPCalculationLossOfPrecision;
    }
    return CPCalculationNoError;
}
CPDecimalRound = function(result, dcm, scale, roundingMode)
{
    _CPDecimalSet(result, dcm);
    if (dcm._isNaN)
        return;
    if (!dcm._isCompact)
        CPDecimalCompact(dcm);
    if (scale == CPDecimalNoScale)
        return;
    var mc = result._mantissa.length,
        l = mc + scale + result._exponent;
    if (mc <= l)
        return;
    else if (l <= 0)
    {
        _CPDecimalSetZero(result);
        return;
    }
    else
    {
        var c = 0,
            n = 0,
            up = 0;
        result._exponent += mc - l;
        switch(roundingMode) {
        case CPRoundDown:
            up = result._isNegative;
            break;
        case CPRoundUp:
            up = !result._isNegative;
            break;
        case CPRoundPlain:
            n = result._mantissa[l];
            up = n >= 5;
            break;
        case _CPRoundHalfDown:
            n = result._mantissa[l];
            up = n > 5;
            break;
        case CPRoundBankers:
            n = result._mantissa[l];
            if (n > 5)
                up = YES;
            else if (n < 5)
                up = NO;
            else
            {
                if (l == 0)
                    c = 0;
                else
                    c = result._mantissa[l - 1];
                up = c % 2 != 0;
            }
            break;
default:
            up = NO;
            break;
        }
        result._mantissa = Array.prototype.slice.call(result._mantissa, 0, l);
        if (up)
        {
            for (var i = l - 1; i >= 0; i--)
            {
                if (result._mantissa[i] != 9)
                {
                    result._mantissa[i]++;
                    break;
                }
                result._mantissa[i] = 0;
            }
            if (i == -1)
            {
                result._mantissa[0] = 1;
                if (result._exponent >= CPDecimalMaxExponent)
                {
                    Array.prototype.push.call(result._mantissa, 0);
                }
                else
                    result._exponent++;
            }
        }
    }
    CPDecimalCompact(result);
}
CPDecimalCompact = function(dcm)
{
    if (!dcm || dcm._mantissa.length == 0 || CPDecimalIsNotANumber(dcm))
        return;
    if (CPDecimalIsZero(dcm))
    {
        _CPDecimalSetZero(dcm);
        return;
    }
    while (dcm._mantissa[0] === 0)
        Array.prototype.shift.call(dcm._mantissa);
    while (dcm._mantissa[dcm._mantissa.length - 1] === 0)
    {
        Array.prototype.pop.call(dcm._mantissa);
        dcm._exponent++;
        if (dcm._exponent + 1 > CPDecimalMaxExponent)
        {
            break;
        }
    }
    dcm._isCompact = YES;
}
CPDecimalString = function(dcm, locale)
{
    if (dcm._isNaN)
        return "NaN";
    var string = "",
        i = 0;
    if (dcm._isNegative)
        string += "-";
    var k = dcm._mantissa.length,
        l = (dcm._exponent < 0 ? dcm._exponent : 0) + k;
    if (l < 0)
    {
        string += "0.";
        for (i = 0; i < ABS(l); i++)
        {
            string += "0";
        }
        l = k;
    }
    else if (l == 0)
    {
        string += "0";
    }
    for (i = 0; i < l; i++)
    {
        string += dcm._mantissa[i];
    }
    if (l < k)
    {
        string += ".";
        for (i = l; i < k; i++)
        {
            string += dcm._mantissa[i];
        }
    }
    for (i = 0; i < dcm._exponent; i++)
    {
        string += "0";
    }
    return string;
}
p;17;CPDecimalNumber.jt;41752;@STATIC;1.0;i;11;CPDecimal.ji;13;CPException.ji;10;CPNumber.ji;10;CPObject.ji;10;CPString.jt;41653;objj_executeFile("CPDecimal.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPNumber.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);var CPDefaultDcmHandler = nil,
    CPDecimalNumberUIDs = new CFMutableDictionary();
{var the_class = objj_allocateClassPair(CPObject, "CPDecimalNumberHandler"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_roundingMode", "CPRoundingMode"), new objj_ivar("_scale", "short"), new objj_ivar("_raiseOnExactness", "BOOL"), new objj_ivar("_raiseOnOverflow", "BOOL"), new objj_ivar("_raiseOnUnderflow", "BOOL"), new objj_ivar("_raiseOnDivideByZero", "BOOL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    return (self.isa.method_msgSend["initWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:"] || _objj_forward)(self, "initWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:", CPRoundPlain, 0, NO, YES, YES, YES);
}
,["id"]), new objj_method(sel_getUid("initWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:"), function(self, _cmd, roundingMode, scale, exact, overflow, underflow, divideByZero)
{
    if (self = (objj_getClass("CPDecimalNumberHandler").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._roundingMode = roundingMode;
        self._scale = scale;
        self._raiseOnExactness = exact;
        self._raiseOnOverflow = overflow;
        self._raiseOnUnderflow = underflow;
        self._raiseOnDivideByZero = divideByZero;
    }
    return self;
}
,["id","CPRoundingMode","short","BOOL","BOOL","BOOL","BOOL"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("decimalNumberHandlerWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:"), function(self, _cmd, roundingMode, scale, exact, overflow, underflow, divideByZero)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:"] || _objj_forward)(___r1, "initWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:", roundingMode, scale, exact, overflow, underflow, divideByZero));
    var ___r1;
}
,["id","CPRoundingMode","short","BOOL","BOOL","BOOL","BOOL"]), new objj_method(sel_getUid("defaultDecimalNumberHandler"), function(self, _cmd)
{
    if (!CPDefaultDcmHandler)
        CPDefaultDcmHandler = ((___r1 = (CPDecimalNumberHandler.isa.method_msgSend["alloc"] || _objj_forward)(CPDecimalNumberHandler, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    return CPDefaultDcmHandler;
    var ___r1;
}
,["id"])]);
}{var the_protocol = objj_allocateProtocol("CPDecimalNumberBehaviors");
objj_registerProtocol(the_protocol);
protocol_addMethodDescriptions(the_protocol, [new objj_method(sel_getUid("roundingMode"), Nil
,["CPRoundingMode"]), new objj_method(sel_getUid("scale"), Nil
,["short"]), new objj_method(sel_getUid("exceptionDuringOperation:error:leftOperand:rightOperand:"), Nil
,["CPDecimalNumber","SEL","CPCalculationError","CPDecimalNumber","CPDecimalNumber"])], true, true);
}{
var the_class = objj_getClass("CPDecimalNumberHandler")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPDecimalNumberHandler\"");
var meta_class = the_class.isa;
var aProtocol = objj_getProtocol("CPDecimalNumberBehaviors");
if (!aProtocol) throw new SyntaxError("*** Could not find definition for protocol \"CPDecimalNumberBehaviors\"");
class_addProtocol(the_class, aProtocol);class_addMethods(the_class, [new objj_method(sel_getUid("roundingMode"), function(self, _cmd)
{
    return self._roundingMode;
}
,["CPRoundingMode"]), new objj_method(sel_getUid("scale"), function(self, _cmd)
{
    return self._scale;
}
,["short"]), new objj_method(sel_getUid("exceptionDuringOperation:error:leftOperand:rightOperand:"), function(self, _cmd, operation, error, leftOperand, rightOperand)
{
    switch(error) {
    case CPCalculationNoError:
        break;
    case CPCalculationOverflow:
        if (self._raiseOnOverflow)
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPDecimalNumberOverflowException, "A CPDecimalNumber overflow has occurred. (Left operand= '" + (leftOperand == null ? null : (leftOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(leftOperand, "descriptionWithLocale:", nil)) + "' Right operand= '" + (rightOperand == null ? null : (rightOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(rightOperand, "descriptionWithLocale:", nil)) + "' Selector= '" + operation + "')");
        else
            return (CPDecimalNumber == null ? null : (CPDecimalNumber.isa.method_msgSend["notANumber"] || _objj_forward)(CPDecimalNumber, "notANumber"));
        break;
    case CPCalculationUnderflow:
        if (self._raiseOnUnderflow)
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPDecimalNumberUnderflowException, "A CPDecimalNumber underflow has occurred. (Left operand= '" + (leftOperand == null ? null : (leftOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(leftOperand, "descriptionWithLocale:", nil)) + "' Right operand= '" + (rightOperand == null ? null : (rightOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(rightOperand, "descriptionWithLocale:", nil)) + "' Selector= '" + operation + "')");
        else
            return (CPDecimalNumber == null ? null : (CPDecimalNumber.isa.method_msgSend["notANumber"] || _objj_forward)(CPDecimalNumber, "notANumber"));
        break;
    case CPCalculationLossOfPrecision:
        if (self._raiseOnExactness)
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPDecimalNumberExactnessException, "A CPDecimalNumber has been rounded off during a calculation. (Left operand= '" + (leftOperand == null ? null : (leftOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(leftOperand, "descriptionWithLocale:", nil)) + "' Right operand= '" + (rightOperand == null ? null : (rightOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(rightOperand, "descriptionWithLocale:", nil)) + "' Selector= '" + operation + "')");
        break;
    case CPCalculationDivideByZero:
        if (self._raiseOnDivideByZero)
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPDecimalNumberDivideByZeroException, "A CPDecimalNumber divide by zero has occurred. (Left operand= '" + (leftOperand == null ? null : (leftOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(leftOperand, "descriptionWithLocale:", nil)) + "' Right operand= '" + (rightOperand == null ? null : (rightOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(rightOperand, "descriptionWithLocale:", nil)) + "' Selector= '" + operation + "')");
        else
            return (CPDecimalNumber == null ? null : (CPDecimalNumber.isa.method_msgSend["notANumber"] || _objj_forward)(CPDecimalNumber, "notANumber"));
        break;
default:
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "An unknown CPDecimalNumber error has occurred. (Left operand= '" + (leftOperand == null ? null : (leftOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(leftOperand, "descriptionWithLocale:", nil)) + "' Right operand= '" + (rightOperand == null ? null : (rightOperand.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(rightOperand, "descriptionWithLocale:", nil)) + "' Selector= '" + operation + "')");
    }
    return nil;
}
,["CPDecimalNumber","SEL","CPCalculationError","CPDecimalNumber","CPDecimalNumber"])]);
}var CPDecimalNumberHandlerRoundingModeKey = "CPDecimalNumberHandlerRoundingModeKey",
    CPDecimalNumberHandlerScaleKey = "CPDecimalNumberHandlerScaleKey",
    CPDecimalNumberHandlerRaiseOnExactKey = "CPDecimalNumberHandlerRaiseOnExactKey",
    CPDecimalNumberHandlerRaiseOnOverflowKey = "CPDecimalNumberHandlerRaiseOnOverflowKey",
    CPDecimalNumberHandlerRaiseOnUnderflowKey = "CPDecimalNumberHandlerRaiseOnUnderflowKey",
    CPDecimalNumberHandlerDivideByZeroKey = "CPDecimalNumberHandlerDivideByZeroKey";
{
var the_class = objj_getClass("CPDecimalNumberHandler")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPDecimalNumberHandler\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    if (self)
    {
        (self.isa.method_msgSend["initWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:"] || _objj_forward)(self, "initWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:", (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPDecimalNumberHandlerRoundingModeKey)), (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPDecimalNumberHandlerScaleKey)), (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPDecimalNumberHandlerRaiseOnExactKey)), (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPDecimalNumberHandlerRaiseOnOverflowKey)), (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPDecimalNumberHandlerRaiseOnUnderflowKey)), (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPDecimalNumberHandlerDivideByZeroKey)));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", (self.isa.method_msgSend["roundingMode"] || _objj_forward)(self, "roundingMode"), CPDecimalNumberHandlerRoundingModeKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", (self.isa.method_msgSend["scale"] || _objj_forward)(self, "scale"), CPDecimalNumberHandlerScaleKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._raiseOnExactness, CPDecimalNumberHandlerRaiseOnExactKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._raiseOnOverflow, CPDecimalNumberHandlerRaiseOnOverflowKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._raiseOnUnderflow, CPDecimalNumberHandlerRaiseOnUnderflowKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._raiseOnDivideByZero, CPDecimalNumberHandlerDivideByZeroKey));
}
,["void","CPCoder"])]);
}{var the_class = objj_allocateClassPair(CPNumber, "CPDecimalNumber"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_data", "CPDecimal")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    return (self.isa.method_msgSend["initWithDecimal:"] || _objj_forward)(self, "initWithDecimal:", CPDecimalMakeNaN());
}
,["id"]), new objj_method(sel_getUid("initWithDecimal:"), function(self, _cmd, dcm)
{
    if (self = (objj_getClass("CPDecimalNumber").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
        self._data = CPDecimalCopy(dcm);
    return self;
}
,["id","CPDecimal"]), new objj_method(sel_getUid("initWithMantissa:exponent:isNegative:"), function(self, _cmd, mantissa, exponent, flag)
{
    if (self = (self == null ? null : (self.isa.method_msgSend["init"] || _objj_forward)(self, "init")))
    {
        if (flag)
            mantissa *= -1;
        self._data = CPDecimalMakeWithParts(mantissa, exponent);
    }
    return self;
}
,["id","unsigned long long","short","BOOL"]), new objj_method(sel_getUid("initWithString:"), function(self, _cmd, numberValue)
{
    return (self.isa.method_msgSend["initWithString:locale:"] || _objj_forward)(self, "initWithString:locale:", numberValue, nil);
}
,["id","CPString"]), new objj_method(sel_getUid("initWithString:locale:"), function(self, _cmd, numberValue, locale)
{
    if (self = (self == null ? null : (self.isa.method_msgSend["init"] || _objj_forward)(self, "init")))
    {
        self._data = CPDecimalMakeWithString(numberValue, locale);
    }
    return self;
}
,["id","CPString","CPDictionary"]), new objj_method(sel_getUid("UID"), function(self, _cmd)
{
    var UID = CPDecimalNumberUIDs.valueForKey(self);
    if (!UID)
    {
        UID = objj_generateObjectUID();
        CPDecimalNumberUIDs.setValueForKey(self, UID);
    }
    return UID + "";
}
,["CPString"]), new objj_method(sel_getUid("decimalNumberByAdding:"), function(self, _cmd, decimalNumber)
{
    return (self.isa.method_msgSend["decimalNumberByAdding:withBehavior:"] || _objj_forward)(self, "decimalNumberByAdding:withBehavior:", decimalNumber, (CPDecimalNumber.isa.method_msgSend["defaultBehavior"] || _objj_forward)(CPDecimalNumber, "defaultBehavior"));
}
,["CPDecimalNumber","CPDecimalNumber"]), new objj_method(sel_getUid("decimalNumberByAdding:withBehavior:"), function(self, _cmd, decimalNumber, behavior)
{
    var result = CPDecimalMakeZero(),
        error = CPDecimalAdd(result, (self.isa.method_msgSend["decimalValue"] || _objj_forward)(self, "decimalValue"), (decimalNumber == null ? null : (decimalNumber.isa.method_msgSend["decimalValue"] || _objj_forward)(decimalNumber, "decimalValue")), (behavior == null ? null : (behavior.isa.method_msgSend["roundingMode"] || _objj_forward)(behavior, "roundingMode")));
    if (error > CPCalculationNoError)
    {
        var res = (behavior == null ? null : (behavior.isa.method_msgSend["exceptionDuringOperation:error:leftOperand:rightOperand:"] || _objj_forward)(behavior, "exceptionDuringOperation:error:leftOperand:rightOperand:", _cmd, error, self, decimalNumber));
        if (res != nil)
            return res;
    }
    return (CPDecimalNumber.isa.method_msgSend["decimalNumberWithDecimal:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithDecimal:", result);
}
,["CPDecimalNumber","CPDecimalNumber","id"]), new objj_method(sel_getUid("decimalNumberBySubtracting:"), function(self, _cmd, decimalNumber)
{
    return (self.isa.method_msgSend["decimalNumberBySubtracting:withBehavior:"] || _objj_forward)(self, "decimalNumberBySubtracting:withBehavior:", decimalNumber, (CPDecimalNumber.isa.method_msgSend["defaultBehavior"] || _objj_forward)(CPDecimalNumber, "defaultBehavior"));
}
,["CPDecimalNumber","CPDecimalNumber"]), new objj_method(sel_getUid("decimalNumberBySubtracting:withBehavior:"), function(self, _cmd, decimalNumber, behavior)
{
    var result = CPDecimalMakeZero(),
        error = CPDecimalSubtract(result, (self.isa.method_msgSend["decimalValue"] || _objj_forward)(self, "decimalValue"), (decimalNumber == null ? null : (decimalNumber.isa.method_msgSend["decimalValue"] || _objj_forward)(decimalNumber, "decimalValue")), (behavior == null ? null : (behavior.isa.method_msgSend["roundingMode"] || _objj_forward)(behavior, "roundingMode")));
    if (error > CPCalculationNoError)
    {
        var res = (behavior == null ? null : (behavior.isa.method_msgSend["exceptionDuringOperation:error:leftOperand:rightOperand:"] || _objj_forward)(behavior, "exceptionDuringOperation:error:leftOperand:rightOperand:", _cmd, error, self, decimalNumber));
        if (res != nil)
            return res;
    }
    return (CPDecimalNumber.isa.method_msgSend["decimalNumberWithDecimal:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithDecimal:", result);
}
,["CPDecimalNumber","CPDecimalNumber","id"]), new objj_method(sel_getUid("decimalNumberByDividingBy:"), function(self, _cmd, decimalNumber)
{
    return (self.isa.method_msgSend["decimalNumberByDividingBy:withBehavior:"] || _objj_forward)(self, "decimalNumberByDividingBy:withBehavior:", decimalNumber, (CPDecimalNumber.isa.method_msgSend["defaultBehavior"] || _objj_forward)(CPDecimalNumber, "defaultBehavior"));
}
,["CPDecimalNumber","CPDecimalNumber"]), new objj_method(sel_getUid("decimalNumberByDividingBy:withBehavior:"), function(self, _cmd, decimalNumber, behavior)
{
    var result = CPDecimalMakeZero(),
        error = CPDecimalDivide(result, (self.isa.method_msgSend["decimalValue"] || _objj_forward)(self, "decimalValue"), (decimalNumber == null ? null : (decimalNumber.isa.method_msgSend["decimalValue"] || _objj_forward)(decimalNumber, "decimalValue")), (behavior == null ? null : (behavior.isa.method_msgSend["roundingMode"] || _objj_forward)(behavior, "roundingMode")));
    if (error > CPCalculationNoError)
    {
        var res = (behavior == null ? null : (behavior.isa.method_msgSend["exceptionDuringOperation:error:leftOperand:rightOperand:"] || _objj_forward)(behavior, "exceptionDuringOperation:error:leftOperand:rightOperand:", _cmd, error, self, decimalNumber));
        if (res != nil)
            return res;
    }
    return (CPDecimalNumber.isa.method_msgSend["decimalNumberWithDecimal:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithDecimal:", result);
}
,["CPDecimalNumber","CPDecimalNumber","id"]), new objj_method(sel_getUid("decimalNumberByMultiplyingBy:"), function(self, _cmd, decimalNumber)
{
    return (self.isa.method_msgSend["decimalNumberByMultiplyingBy:withBehavior:"] || _objj_forward)(self, "decimalNumberByMultiplyingBy:withBehavior:", decimalNumber, (CPDecimalNumber.isa.method_msgSend["defaultBehavior"] || _objj_forward)(CPDecimalNumber, "defaultBehavior"));
}
,["CPDecimalNumber","CPDecimalNumber"]), new objj_method(sel_getUid("decimalNumberByMultiplyingBy:withBehavior:"), function(self, _cmd, decimalNumber, behavior)
{
    var result = CPDecimalMakeZero(),
        error = CPDecimalMultiply(result, (self.isa.method_msgSend["decimalValue"] || _objj_forward)(self, "decimalValue"), (decimalNumber == null ? null : (decimalNumber.isa.method_msgSend["decimalValue"] || _objj_forward)(decimalNumber, "decimalValue")), (behavior == null ? null : (behavior.isa.method_msgSend["roundingMode"] || _objj_forward)(behavior, "roundingMode")));
    if (error > CPCalculationNoError)
    {
        var res = (behavior == null ? null : (behavior.isa.method_msgSend["exceptionDuringOperation:error:leftOperand:rightOperand:"] || _objj_forward)(behavior, "exceptionDuringOperation:error:leftOperand:rightOperand:", _cmd, error, self, decimalNumber));
        if (res != nil)
            return res;
    }
    return (CPDecimalNumber.isa.method_msgSend["decimalNumberWithDecimal:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithDecimal:", result);
}
,["CPDecimalNumber","CPDecimalNumber","id"]), new objj_method(sel_getUid("decimalNumberByMultiplyingByPowerOf10:"), function(self, _cmd, power)
{
    return (self.isa.method_msgSend["decimalNumberByMultiplyingByPowerOf10:withBehavior:"] || _objj_forward)(self, "decimalNumberByMultiplyingByPowerOf10:withBehavior:", power, (CPDecimalNumber.isa.method_msgSend["defaultBehavior"] || _objj_forward)(CPDecimalNumber, "defaultBehavior"));
}
,["CPDecimalNumber","short"]), new objj_method(sel_getUid("decimalNumberByMultiplyingByPowerOf10:withBehavior:"), function(self, _cmd, power, behavior)
{
    var result = CPDecimalMakeZero(),
        error = CPDecimalMultiplyByPowerOf10(result, (self.isa.method_msgSend["decimalValue"] || _objj_forward)(self, "decimalValue"), power, (behavior == null ? null : (behavior.isa.method_msgSend["roundingMode"] || _objj_forward)(behavior, "roundingMode")));
    if (error > CPCalculationNoError)
    {
        var res = (behavior == null ? null : (behavior.isa.method_msgSend["exceptionDuringOperation:error:leftOperand:rightOperand:"] || _objj_forward)(behavior, "exceptionDuringOperation:error:leftOperand:rightOperand:", _cmd, error, self, (CPDecimalNumber.isa.method_msgSend["decimalNumberWithString:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithString:", power.toString())));
        if (res != nil)
            return res;
    }
    return (CPDecimalNumber.isa.method_msgSend["decimalNumberWithDecimal:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithDecimal:", result);
}
,["CPDecimalNumber","short","id"]), new objj_method(sel_getUid("decimalNumberByRaisingToPower:"), function(self, _cmd, power)
{
    return (self.isa.method_msgSend["decimalNumberByRaisingToPower:withBehavior:"] || _objj_forward)(self, "decimalNumberByRaisingToPower:withBehavior:", power, (CPDecimalNumber.isa.method_msgSend["defaultBehavior"] || _objj_forward)(CPDecimalNumber, "defaultBehavior"));
}
,["CPDecimalNumber","unsigned"]), new objj_method(sel_getUid("decimalNumberByRaisingToPower:withBehavior:"), function(self, _cmd, power, behavior)
{
    if (power < 0)
        return (behavior == null ? null : (behavior.isa.method_msgSend["exceptionDuringOperation:error:leftOperand:rightOperand:"] || _objj_forward)(behavior, "exceptionDuringOperation:error:leftOperand:rightOperand:", _cmd, -1, self, (CPDecimalNumber.isa.method_msgSend["decimalNumberWithString:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithString:", power.toString())));
    var result = CPDecimalMakeZero(),
        error = CPDecimalPower(result, (self.isa.method_msgSend["decimalValue"] || _objj_forward)(self, "decimalValue"), power, (behavior == null ? null : (behavior.isa.method_msgSend["roundingMode"] || _objj_forward)(behavior, "roundingMode")));
    if (error > CPCalculationNoError)
    {
        var res = (behavior == null ? null : (behavior.isa.method_msgSend["exceptionDuringOperation:error:leftOperand:rightOperand:"] || _objj_forward)(behavior, "exceptionDuringOperation:error:leftOperand:rightOperand:", _cmd, error, self, (CPDecimalNumber.isa.method_msgSend["decimalNumberWithString:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithString:", power.toString())));
        if (res != nil)
            return res;
    }
    return (CPDecimalNumber.isa.method_msgSend["decimalNumberWithDecimal:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithDecimal:", result);
}
,["CPDecimalNumber","unsigned","id"]), new objj_method(sel_getUid("decimalNumberByRoundingAccordingToBehavior:"), function(self, _cmd, behavior)
{
    var result = CPDecimalMakeZero();
    CPDecimalRound(result, (self.isa.method_msgSend["decimalValue"] || _objj_forward)(self, "decimalValue"), (behavior == null ? null : (behavior.isa.method_msgSend["scale"] || _objj_forward)(behavior, "scale")), (behavior == null ? null : (behavior.isa.method_msgSend["roundingMode"] || _objj_forward)(behavior, "roundingMode")));
    return (CPDecimalNumber.isa.method_msgSend["decimalNumberWithDecimal:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithDecimal:", result);
}
,["CPDecimalNumber","id"]), new objj_method(sel_getUid("compare:"), function(self, _cmd, aNumber)
{
    if (!(aNumber == null ? null : (aNumber.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(aNumber, "isKindOfClass:", (CPDecimalNumber.isa.method_msgSend["class"] || _objj_forward)(CPDecimalNumber, "class"))))
        aNumber = (CPDecimalNumber.isa.method_msgSend["decimalNumberWithString:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithString:", aNumber.toString());
    return CPDecimalCompare((self.isa.method_msgSend["decimalValue"] || _objj_forward)(self, "decimalValue"), (aNumber == null ? null : (aNumber.isa.method_msgSend["decimalValue"] || _objj_forward)(aNumber, "decimalValue")));
}
,["CPComparisonResult","CPNumber"]), new objj_method(sel_getUid("objCType"), function(self, _cmd)
{
    return "d";
}
,["CPString"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (self.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(self, "descriptionWithLocale:", nil);
}
,["CPString"]), new objj_method(sel_getUid("descriptionWithLocale:"), function(self, _cmd, locale)
{
    return CPDecimalString(self._data, locale);
}
,["CPString","CPDictionary"]), new objj_method(sel_getUid("stringValue"), function(self, _cmd)
{
    return (self.isa.method_msgSend["description"] || _objj_forward)(self, "description");
}
,["CPString"]), new objj_method(sel_getUid("decimalValue"), function(self, _cmd)
{
    return CPDecimalCopy(self._data);
}
,["CPDecimal"]), new objj_method(sel_getUid("doubleValue"), function(self, _cmd)
{
    return parseFloat((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["double"]), new objj_method(sel_getUid("boolValue"), function(self, _cmd)
{
    return CPDecimalIsZero(self._data) ? NO : YES;
}
,["BOOL"]), new objj_method(sel_getUid("charValue"), function(self, _cmd)
{
    return parseInt((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["char"]), new objj_method(sel_getUid("floatValue"), function(self, _cmd)
{
    return parseFloat((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["float"]), new objj_method(sel_getUid("intValue"), function(self, _cmd)
{
    return parseInt((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["int"]), new objj_method(sel_getUid("longLongValue"), function(self, _cmd)
{
    return parseInt((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["long long"]), new objj_method(sel_getUid("longValue"), function(self, _cmd)
{
    return parseInt((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["long"]), new objj_method(sel_getUid("shortValue"), function(self, _cmd)
{
    return parseInt((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["short"]), new objj_method(sel_getUid("unsignedCharValue"), function(self, _cmd)
{
    return parseInt((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["unsigned char"]), new objj_method(sel_getUid("unsignedIntValue"), function(self, _cmd)
{
    return parseInt((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["unsigned int"]), new objj_method(sel_getUid("unsignedLongValue"), function(self, _cmd)
{
    return parseInt((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["unsigned long"]), new objj_method(sel_getUid("unsignedShortValue"), function(self, _cmd)
{
    return parseInt((self.isa.method_msgSend["stringValue"] || _objj_forward)(self, "stringValue"));
}
,["unsigned short"]), new objj_method(sel_getUid("isEqualToNumber:"), function(self, _cmd, aNumber)
{
    return CPDecimalCompare(CPDecimalMakeWithString(aNumber.toString(), nil), self._data) == CPOrderedSame ? YES : NO;
}
,["BOOL","CPNumber"]), new objj_method(sel_getUid("initWithBool:"), function(self, _cmd, value)
{
    if (self = (self == null ? null : (self.isa.method_msgSend["init"] || _objj_forward)(self, "init")))
        self._data = CPDecimalMakeWithParts(value ? 1 : 0, 0);
    return self;
}
,["id","BOOL"]), new objj_method(sel_getUid("initWithChar:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","char"]), new objj_method(sel_getUid("initWithDouble:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","double"]), new objj_method(sel_getUid("initWithFloat:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","float"]), new objj_method(sel_getUid("initWithInt:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","int"]), new objj_method(sel_getUid("initWithLong:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","long"]), new objj_method(sel_getUid("initWithLongLong:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","long long"]), new objj_method(sel_getUid("initWithShort:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","short"]), new objj_method(sel_getUid("initWithUnsignedChar:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","unsigned char"]), new objj_method(sel_getUid("initWithUnsignedInt:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","unsigned"]), new objj_method(sel_getUid("initWithUnsignedLong:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","unsigned long"]), new objj_method(sel_getUid("initWithUnsignedLongLong:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","unsigned long long"]), new objj_method(sel_getUid("initWithUnsignedShort:"), function(self, _cmd, value)
{
    return (self.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(self, "_initWithJSNumber:", value);
}
,["id","unsigned short"]), new objj_method(sel_getUid("_initWithJSNumber:"), function(self, _cmd, value)
{
    if (self = (self == null ? null : (self.isa.method_msgSend["init"] || _objj_forward)(self, "init")))
        self._data = CPDecimalMakeWithString(value.toString(), nil);
    return self;
}
,["id","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    return class_createInstance(self);
}
,["id"]), new objj_method(sel_getUid("decimalNumberWithDecimal:"), function(self, _cmd, dcm)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDecimal:"] || _objj_forward)(___r1, "initWithDecimal:", dcm));
    var ___r1;
}
,["CPDecimalNumber","CPDecimal"]), new objj_method(sel_getUid("decimalNumberWithMantissa:exponent:isNegative:"), function(self, _cmd, mantissa, exponent, flag)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithMantissa:exponent:isNegative:"] || _objj_forward)(___r1, "initWithMantissa:exponent:isNegative:", mantissa, exponent, flag));
    var ___r1;
}
,["CPDecimalNumber","unsigned long long","short","BOOL"]), new objj_method(sel_getUid("decimalNumberWithString:"), function(self, _cmd, numberValue)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", numberValue));
    var ___r1;
}
,["CPDecimalNumber","CPString"]), new objj_method(sel_getUid("decimalNumberWithString:locale:"), function(self, _cmd, numberValue, locale)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:locale:"] || _objj_forward)(___r1, "initWithString:locale:", numberValue, locale));
    var ___r1;
}
,["CPDecimalNumber","CPString","CPDictionary"]), new objj_method(sel_getUid("defaultBehavior"), function(self, _cmd)
{
    return (CPDecimalNumberHandler.isa.method_msgSend["defaultDecimalNumberHandler"] || _objj_forward)(CPDecimalNumberHandler, "defaultDecimalNumberHandler");
}
,["id"]), new objj_method(sel_getUid("setDefaultBehavior:"), function(self, _cmd, behavior)
{
    CPDefaultDcmHandler = behavior;
}
,["void","id"]), new objj_method(sel_getUid("maximumDecimalNumber"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDecimal:"] || _objj_forward)(___r1, "initWithDecimal:", _CPDecimalMakeMaximum()));
    var ___r1;
}
,["CPDecimalNumber"]), new objj_method(sel_getUid("minimumDecimalNumber"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDecimal:"] || _objj_forward)(___r1, "initWithDecimal:", _CPDecimalMakeMinimum()));
    var ___r1;
}
,["CPDecimalNumber"]), new objj_method(sel_getUid("notANumber"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDecimal:"] || _objj_forward)(___r1, "initWithDecimal:", CPDecimalMakeNaN()));
    var ___r1;
}
,["CPDecimalNumber"]), new objj_method(sel_getUid("zero"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDecimal:"] || _objj_forward)(___r1, "initWithDecimal:", CPDecimalMakeZero()));
    var ___r1;
}
,["CPDecimalNumber"]), new objj_method(sel_getUid("one"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDecimal:"] || _objj_forward)(___r1, "initWithDecimal:", CPDecimalMakeOne()));
    var ___r1;
}
,["CPDecimalNumber"]), new objj_method(sel_getUid("numberWithBool:"), function(self, _cmd, aBoolean)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithBool:"] || _objj_forward)(___r1, "initWithBool:", aBoolean));
    var ___r1;
}
,["id","BOOL"]), new objj_method(sel_getUid("numberWithChar:"), function(self, _cmd, aChar)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithChar:"] || _objj_forward)(___r1, "initWithChar:", aChar));
    var ___r1;
}
,["id","char"]), new objj_method(sel_getUid("numberWithDouble:"), function(self, _cmd, aDouble)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDouble:"] || _objj_forward)(___r1, "initWithDouble:", aDouble));
    var ___r1;
}
,["id","double"]), new objj_method(sel_getUid("numberWithFloat:"), function(self, _cmd, aFloat)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithFloat:"] || _objj_forward)(___r1, "initWithFloat:", aFloat));
    var ___r1;
}
,["id","float"]), new objj_method(sel_getUid("numberWithInt:"), function(self, _cmd, anInt)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithInt:"] || _objj_forward)(___r1, "initWithInt:", anInt));
    var ___r1;
}
,["id","int"]), new objj_method(sel_getUid("numberWithLong:"), function(self, _cmd, aLong)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithLong:"] || _objj_forward)(___r1, "initWithLong:", aLong));
    var ___r1;
}
,["id","long"]), new objj_method(sel_getUid("numberWithLongLong:"), function(self, _cmd, aLongLong)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithLongLong:"] || _objj_forward)(___r1, "initWithLongLong:", aLongLong));
    var ___r1;
}
,["id","long long"]), new objj_method(sel_getUid("numberWithShort:"), function(self, _cmd, aShort)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithShort:"] || _objj_forward)(___r1, "initWithShort:", aShort));
    var ___r1;
}
,["id","short"]), new objj_method(sel_getUid("numberWithUnsignedChar:"), function(self, _cmd, aChar)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithUnsignedChar:"] || _objj_forward)(___r1, "initWithUnsignedChar:", aChar));
    var ___r1;
}
,["id","unsigned char"]), new objj_method(sel_getUid("numberWithUnsignedInt:"), function(self, _cmd, anUnsignedInt)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithUnsignedInt:"] || _objj_forward)(___r1, "initWithUnsignedInt:", anUnsignedInt));
    var ___r1;
}
,["id","unsigned"]), new objj_method(sel_getUid("numberWithUnsignedLong:"), function(self, _cmd, anUnsignedLong)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithUnsignedLong:"] || _objj_forward)(___r1, "initWithUnsignedLong:", anUnsignedLong));
    var ___r1;
}
,["id","unsigned long"]), new objj_method(sel_getUid("numberWithUnsignedLongLong:"), function(self, _cmd, anUnsignedLongLong)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithUnsignedLongLong:"] || _objj_forward)(___r1, "initWithUnsignedLongLong:", anUnsignedLongLong));
    var ___r1;
}
,["id","unsigned long"]), new objj_method(sel_getUid("numberWithUnsignedShort:"), function(self, _cmd, anUnsignedShort)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithUnsignedShort:"] || _objj_forward)(___r1, "initWithUnsignedShort:", anUnsignedShort));
    var ___r1;
}
,["id","unsigned short"])]);
}var CPDecimalNumberDecimalExponent = "CPDecimalNumberDecimalExponent",
    CPDecimalNumberDecimalIsNegative = "CPDecimalNumberDecimalIsNegative",
    CPDecimalNumberDecimalIsCompact = "CPDecimalNumberDecimalIsCompact",
    CPDecimalNumberDecimalIsNaN = "CPDecimalNumberDecimalIsNaN",
    CPDecimalNumberDecimalMantissa = "CPDecimalNumberDecimalMantissa";
{
var the_class = objj_getClass("CPDecimalNumber")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPDecimalNumber\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    if (self)
    {
        var dcm = CPDecimalMakeZero();
        dcm._exponent = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPDecimalNumberDecimalExponent));
        dcm._isNegative = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPDecimalNumberDecimalIsNegative));
        dcm._isCompact = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPDecimalNumberDecimalIsCompact));
        dcm._isNaN = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPDecimalNumberDecimalIsNaN));
        dcm._mantissa = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPDecimalNumberDecimalMantissa));
        (self.isa.method_msgSend["initWithDecimal:"] || _objj_forward)(self, "initWithDecimal:", dcm);
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._data._exponent, CPDecimalNumberDecimalExponent));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._data._isNegative, CPDecimalNumberDecimalIsNegative));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._data._isCompact, CPDecimalNumberDecimalIsCompact));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._data._isNaN, CPDecimalNumberDecimalIsNaN));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._data._mantissa, CPDecimalNumberDecimalMantissa));
}
,["void","CPCoder"])]);
}p;18;CPDelayedPerform.jt;7937;@STATIC;1.0;i;10;CPObject.ji;11;CPRunLoop.ji;10;CPString.jt;7872;objj_executeFile("CPObject.j", YES);objj_executeFile("CPRunLoop.j", YES);objj_executeFile("CPString.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPDelayedPerform"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_object", "id"), new objj_ivar("_selector", "SEL"), new objj_ivar("_argument", "id")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithObject:selector:argument:"), function(self, _cmd, anObject, aSelector, anArgument)
{
    if (self = (objj_getClass("CPDelayedPerform").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._object = anObject;
        self._selector = aSelector;
        self._argument = anArgument;
    }
    return self;
}
,["id","id","SEL","id"]), new objj_method(sel_getUid("isEqualToPerform:"), function(self, _cmd, anOther)
{
    if (!anOther || !anOther.isa)
        return NO;
    if (self._object !== anOther._object)
        return NO;
    if (!self._selector || !anOther._selector)
        return YES;
    if (self._selector !== anOther._selector)
        return NO;
    if (self._argument !== anOther._argument)
        return NO;
    return YES;
}
,["BOOL","CPDelayedPerform"]), new objj_method(sel_getUid("perform"), function(self, _cmd)
{
    try    {
        ((___r1 = self._object), ___r1 == null ? null : (___r1.isa.method_msgSend["performSelector:withObject:"] || _objj_forward)(___r1, "performSelector:withObject:", self._selector, self._argument));
    }
    catch(ex)     {
        CPLog("exception %@ raised during delayed perform", ex);
    }    var ___r1;
}
,["void"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("delayedPerformWithObject:selector:argument:"), function(self, _cmd, anObject, aSelector, anArgument)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObject:selector:argument:"] || _objj_forward)(___r1, "initWithObject:selector:argument:", anObject, aSelector, anArgument));
    var ___r1;
}
,["CPDelayedPerform","id","SEL","id"])]);
}{
var the_class = objj_getClass("CPRunLoop")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPRunLoop\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("invalidateTimerWithDelayedPerform:"), function(self, _cmd, aDelayedPerform)
{
    for (var aKey in self._timersForModes)
    {
        if (!self._timersForModes.hasOwnProperty(aKey))
            continue;
        var timersForMode = self._timersForModes[aKey];
        for (var i = 0, count = (timersForMode == null ? null : (timersForMode.isa.method_msgSend["count"] || _objj_forward)(timersForMode, "count")); i < count; i++)
        {
            var aTimer = (timersForMode == null ? null : (timersForMode.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(timersForMode, "objectAtIndex:", i)),
                userInfo = (aTimer == null ? null : (aTimer.isa.method_msgSend["userInfo"] || _objj_forward)(aTimer, "userInfo"));
            if ((userInfo == null ? null : (userInfo.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(userInfo, "isKindOfClass:", CPDelayedPerform)) && (userInfo == null ? null : (userInfo.isa.method_msgSend["isEqualToPerform:"] || _objj_forward)(userInfo, "isEqualToPerform:", aDelayedPerform)))
                (aTimer == null ? null : (aTimer.isa.method_msgSend["invalidate"] || _objj_forward)(aTimer, "invalidate"));
        }
    }
}
,["void","CPDelayedPerform"])]);
}{
var the_class = objj_getClass("CPObject")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPObject\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("performSelector:withObject:afterDelay:"), function(self, _cmd, selector, object, delay)
{
    ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["object:performSelector:withObject:afterDelay:inModes:"] || _objj_forward)(___r1, "object:performSelector:withObject:afterDelay:inModes:", self, selector, object, delay, (CPArray.isa.method_msgSend["arrayWithObject:"] || _objj_forward)(CPArray, "arrayWithObject:", CPDefaultRunLoopMode)));
    var ___r1;
}
,["void","SEL","id","CPTimeInterval"]), new objj_method(sel_getUid("performSelector:withObject:afterDelay:inModes:"), function(self, _cmd, selector, object, delay, modes)
{
    ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["object:performSelector:withObject:afterDelay:inModes:"] || _objj_forward)(___r1, "object:performSelector:withObject:afterDelay:inModes:", self, selector, object, delay, modes));
    var ___r1;
}
,["void","SEL","id","CPTimeInterval","CPArray"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("cancelPreviousPerformRequestsWithTarget:selector:object:"), function(self, _cmd, target, selector, argument)
{
    var aDelayedPerform = (CPDelayedPerform.isa.method_msgSend["delayedPerformWithObject:selector:argument:"] || _objj_forward)(CPDelayedPerform, "delayedPerformWithObject:selector:argument:", target, selector, argument);
    ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["invalidateTimerWithDelayedPerform:"] || _objj_forward)(___r1, "invalidateTimerWithDelayedPerform:", aDelayedPerform));
    var ___r1;
}
,["void","id","SEL","id"]), new objj_method(sel_getUid("cancelPreviousPerformRequestsWithTarget:"), function(self, _cmd, target)
{
    var aDelayedPerform = (CPDelayedPerform.isa.method_msgSend["delayedPerformWithObject:selector:argument:"] || _objj_forward)(CPDelayedPerform, "delayedPerformWithObject:selector:argument:", target, NULL, nil);
    ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["invalidateTimerWithDelayedPerform:"] || _objj_forward)(___r1, "invalidateTimerWithDelayedPerform:", aDelayedPerform));
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("_delayedPerform:"), function(self, _cmd, aTimer)
{
    var aDelayedPerform = (aTimer == null ? null : (aTimer.isa.method_msgSend["userInfo"] || _objj_forward)(aTimer, "userInfo"));
    (aDelayedPerform == null ? null : (aDelayedPerform.isa.method_msgSend["perform"] || _objj_forward)(aDelayedPerform, "perform"));
}
,["void","CPTimer"]), new objj_method(sel_getUid("object:performSelector:withObject:afterDelay:inModes:"), function(self, _cmd, object, selector, argument, delay, modes)
{
    var aDelayedPerform = (CPDelayedPerform.isa.method_msgSend["delayedPerformWithObject:selector:argument:"] || _objj_forward)(CPDelayedPerform, "delayedPerformWithObject:selector:argument:", object, selector, argument),
        aTimer = (CPTimer.isa.method_msgSend["timerWithTimeInterval:target:selector:userInfo:repeats:"] || _objj_forward)(CPTimer, "timerWithTimeInterval:target:selector:userInfo:repeats:", delay, (CPObject.isa.method_msgSend["class"] || _objj_forward)(CPObject, "class"), sel_getUid("_delayedPerform:"), aDelayedPerform, NO);
    for (var i = 0, count = (modes == null ? null : (modes.isa.method_msgSend["count"] || _objj_forward)(modes, "count")); i < count; i++)
        ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["addTimer:forMode:"] || _objj_forward)(___r1, "addTimer:forMode:", aTimer, (modes == null ? null : (modes.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(modes, "objectAtIndex:", i))));
    var ___r1;
}
,["void","id","SEL","id","CPTimeInterval","CPArray"])]);
}p;14;CPDictionary.jt;21199;@STATIC;1.0;i;9;CPArray.ji;14;CPEnumerator.ji;13;CPException.ji;8;CPNull.ji;10;CPObject.jt;21102;objj_executeFile("CPArray.j", YES);objj_executeFile("CPEnumerator.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPNull.j", YES);objj_executeFile("CPObject.j", YES);var CPDictionaryMaxDescriptionRecursion = 10;
{var the_class = objj_allocateClassPair(CPObject, "CPDictionary"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithDictionary:"), function(self, _cmd, aDictionary)
{
    var key = "",
        dictionary = ((___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    for (key in aDictionary._buckets)
        (dictionary == null ? null : (dictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(dictionary, "setObject:forKey:", (aDictionary == null ? null : (aDictionary.isa.method_msgSend["objectForKey:"] || _objj_forward)(aDictionary, "objectForKey:", key)), key));
    return dictionary;
    var ___r1;
}
,["id","CPDictionary"]), new objj_method(sel_getUid("initWithObjects:forKeys:"), function(self, _cmd, objects, keyArray)
{
    self = (objj_getClass("CPDictionary").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    var i = (keyArray == null ? null : (keyArray.isa.method_msgSend["count"] || _objj_forward)(keyArray, "count"));
    if ((objects == null ? null : (objects.isa.method_msgSend["count"] || _objj_forward)(objects, "count")) != i)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "Counts are different.(%d != %d)", (objects == null ? null : (objects.isa.method_msgSend["count"] || _objj_forward)(objects, "count")), (keyArray == null ? null : (keyArray.isa.method_msgSend["count"] || _objj_forward)(keyArray, "count"))));
    if (self)
    {
        while (i--)
        {
            var value = objects[i],
                key = keyArray[i];
            if (value === nil)
                (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Attempt to insert nil object from objects[" + i + "]");
            if (key === nil)
                (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Attempt to insert nil key from keys[" + i + "]");
            (self == null ? null : (self.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(self, "setObject:forKey:", value, key));
        }
    }
    return self;
}
,["id","CPArray","CPArray"]), new objj_method(sel_getUid("initWithObjectsAndKeys:"), function(self, _cmd, firstObject)
{
    var argCount = arguments.length;
    if (argCount % 2 !== 0)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Key-value count is mismatched. (" + argCount + " arguments passed)");
    self = (objj_getClass("CPDictionary").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        while (argCount-- > 2)
        {
            var key = arguments[argCount--],
                value = arguments[argCount];
            if (value === nil)
                (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Attempt to insert nil object from objects[" + (argCount / 2 - 1) + "]");
            if (key === nil)
                (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Attempt to insert nil key from keys[" + (argCount / 2 - 1) + "]");
            (self == null ? null : (self.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(self, "setObject:forKey:", value, key));
        }
    }
    return self;
}
,["id","id"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    return (CPDictionary.isa.method_msgSend["dictionaryWithDictionary:"] || _objj_forward)(CPDictionary, "dictionaryWithDictionary:", self);
}
,["CPDictionary"]), new objj_method(sel_getUid("count"), function(self, _cmd)
{
    return self._count;
}
,["int"]), new objj_method(sel_getUid("allKeys"), function(self, _cmd)
{
    return ((___r1 = self._keys), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("allValues"), function(self, _cmd)
{
    var keys = self._keys,
        index = keys.length,
        values = [];
    while (index--)
        values.push(self.valueForKey(keys[index]));
    return values;
}
,["CPArray"]), new objj_method(sel_getUid("allKeysForObject:"), function(self, _cmd, anObject)
{
    var keys = self._keys,
        count = keys.length,
        index = 0,
        matchingKeys = [],
        key = nil,
        value = nil;
    for (; index < count; ++index)
    {
        key = keys[index];
        value = self._buckets[key];
        if (value.isa && anObject && anObject.isa && (value == null ? null : (value.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(value, "respondsToSelector:", sel_getUid("isEqual:"))) && (value == null ? null : (value.isa.method_msgSend["isEqual:"] || _objj_forward)(value, "isEqual:", anObject)))
            matchingKeys.push(key);
        else if (value === anObject)
            matchingKeys.push(key);
    }
    return matchingKeys;
}
,["CPArray","id"]), new objj_method(sel_getUid("keysOfEntriesPassingTest:"), function(self, _cmd, predicate)
{
    return (self.isa.method_msgSend["keysOfEntriesWithOptions:passingTest:"] || _objj_forward)(self, "keysOfEntriesWithOptions:passingTest:", CPEnumerationNormal, predicate);
}
,["CPArray","Function"]), new objj_method(sel_getUid("keysOfEntriesWithOptions:passingTest:"), function(self, _cmd, options, predicate)
{
    var keys = self._keys;
    if (options & CPEnumerationReverse)
    {
        var index = (keys == null ? null : (keys.isa.method_msgSend["count"] || _objj_forward)(keys, "count")) - 1,
            stop = -1,
            increment = -1;
    }
    else
    {
        var index = 0,
            stop = (keys == null ? null : (keys.isa.method_msgSend["count"] || _objj_forward)(keys, "count")),
            increment = 1;
    }
    var matchingKeys = [],
        key = nil,
        value = nil,
        shouldStop = NO,
        stopRef = function(__input) { if (arguments.length) return shouldStop = __input; return shouldStop; };
    for (; index !== stop; index += increment)
    {
        key = keys[index];
        value = self._buckets[key];
        if (predicate(key, value, stopRef))
            matchingKeys.push(key);
        if (shouldStop)
            break;
    }
    return matchingKeys;
}
,["CPArray","CPEnumerationOptions","Function"]), new objj_method(sel_getUid("keysSortedByValueUsingComparator:"), function(self, _cmd, comparator)
{
    return ((___r1 = (self.isa.method_msgSend["allKeys"] || _objj_forward)(self, "allKeys")), ___r1 == null ? null : (___r1.isa.method_msgSend["sortedArrayUsingFunction:"] || _objj_forward)(___r1, "sortedArrayUsingFunction:", function(a, b)
    {
        a = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", a);
        b = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", b);
        return comparator(a, b);
    }));
    var ___r1;
}
,["CPArray","Function"]), new objj_method(sel_getUid("keysSortedByValueUsingSelector:"), function(self, _cmd, theSelector)
{
    return ((___r1 = (self.isa.method_msgSend["allKeys"] || _objj_forward)(self, "allKeys")), ___r1 == null ? null : (___r1.isa.method_msgSend["sortedArrayUsingFunction:"] || _objj_forward)(___r1, "sortedArrayUsingFunction:", function(a, b)
    {
        a = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", a);
        b = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", b);
        return (a == null ? null : (a.isa.method_msgSend["performSelector:withObject:"] || _objj_forward)(a, "performSelector:withObject:", theSelector, b));
    }));
    var ___r1;
}
,["CPArray","SEL"]), new objj_method(sel_getUid("keyEnumerator"), function(self, _cmd)
{
    return ((___r1 = self._keys), ___r1 == null ? null : (___r1.isa.method_msgSend["objectEnumerator"] || _objj_forward)(___r1, "objectEnumerator"));
    var ___r1;
}
,["CPEnumerator"]), new objj_method(sel_getUid("objectEnumerator"), function(self, _cmd)
{
    return ((___r1 = (_CPDictionaryValueEnumerator == null ? null : (_CPDictionaryValueEnumerator.isa.method_msgSend["alloc"] || _objj_forward)(_CPDictionaryValueEnumerator, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDictionary:"] || _objj_forward)(___r1, "initWithDictionary:", self));
    var ___r1;
}
,["CPEnumerator"]), new objj_method(sel_getUid("isEqualToDictionary:"), function(self, _cmd, aDictionary)
{
    if (self === aDictionary)
        return YES;
    var count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
    if (count !== (aDictionary == null ? null : (aDictionary.isa.method_msgSend["count"] || _objj_forward)(aDictionary, "count")))
        return NO;
    var index = count,
        keys = self._keys;
    while (index--)
    {
        var currentKey = keys[index],
            lhsObject = self._buckets[currentKey],
            rhsObject = aDictionary._buckets[currentKey];
        if (lhsObject === rhsObject)
            continue;
        if (lhsObject && lhsObject.isa && rhsObject && rhsObject.isa && (lhsObject == null ? null : (lhsObject.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(lhsObject, "respondsToSelector:", sel_getUid("isEqual:"))) && (lhsObject == null ? null : (lhsObject.isa.method_msgSend["isEqual:"] || _objj_forward)(lhsObject, "isEqual:", rhsObject)))
            continue;
        return NO;
    }
    return YES;
}
,["BOOL","CPDictionary"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    if (self === anObject)
        return YES;
    if (!(anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", (CPDictionary.isa.method_msgSend["class"] || _objj_forward)(CPDictionary, "class"))))
        return NO;
    return (self.isa.method_msgSend["isEqualToDictionary:"] || _objj_forward)(self, "isEqualToDictionary:", anObject);
}
,["BOOL","id"]), new objj_method(sel_getUid("objectForKey:"), function(self, _cmd, aKey)
{
    var object = self._buckets[aKey];
    return object === undefined ? nil : object;
}
,["id","id"]), new objj_method(sel_getUid("removeAllObjects"), function(self, _cmd)
{
    self.removeAllValues();
}
,["void"]), new objj_method(sel_getUid("removeObjectForKey:"), function(self, _cmd, aKey)
{
    self.removeValueForKey(aKey);
}
,["void","id"]), new objj_method(sel_getUid("removeObjectsForKeys:"), function(self, _cmd, keysForRemoval)
{
    var index = keysForRemoval.length;
    while (index--)
        (self.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(self, "removeObjectForKey:", keysForRemoval[index]);
}
,["void","CPArray"]), new objj_method(sel_getUid("setObject:forKey:"), function(self, _cmd, anObject, aKey)
{
    if (aKey === nil)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "key cannot be nil");
    if (anObject === nil)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "object cannot be nil (key: " + aKey + ")");
    self.setValueForKey(aKey, anObject);
}
,["void","id","id"]), new objj_method(sel_getUid("addEntriesFromDictionary:"), function(self, _cmd, aDictionary)
{
    if (!aDictionary)
        return;
    var keys = (aDictionary == null ? null : (aDictionary.isa.method_msgSend["allKeys"] || _objj_forward)(aDictionary, "allKeys")),
        index = (keys == null ? null : (keys.isa.method_msgSend["count"] || _objj_forward)(keys, "count"));
    while (index--)
    {
        var key = keys[index];
        (self.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(self, "setObject:forKey:", (aDictionary == null ? null : (aDictionary.isa.method_msgSend["objectForKey:"] || _objj_forward)(aDictionary, "objectForKey:", key)), key);
    }
}
,["void","CPDictionary"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    var string = "@{",
        keys = (self.isa.method_msgSend["allKeys"] || _objj_forward)(self, "allKeys"),
        index = 0,
        count = self._count;
    keys.sort();
    for (; index < count; ++index)
    {
        if (index === 0)
            string += "\n";
        var key = keys[index],
            value = self.valueForKey(key);
        string += "    @\"" + key + "\": " + ((CPDescriptionOfObject(value, CPDictionaryMaxDescriptionRecursion)).split("\n")).join("\n    ") + (index + 1 < count ? "," : "") + "\n";
    }
    return string + "}";
}
,["CPString"]), new objj_method(sel_getUid("containsKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    return value !== nil && value !== undefined;
}
,["BOOL","id"]), new objj_method(sel_getUid("enumerateKeysAndObjectsUsingBlock:"), function(self, _cmd, aFunction)
{
    var shouldStop = NO,
        shouldStopRef = function(__input) { if (arguments.length) return shouldStop = __input; return shouldStop; },
        keys = self._keys,
        count = self._count;
    for (var index = 0; index < count; index++)
    {
        var key = keys[index],
            value = self.valueForKey(key);
        aFunction(key, value, shouldStopRef);
        if (shouldStop)
            return;
    }
}
,["void","Function"]), new objj_method(sel_getUid("enumerateKeysAndObjectsWithOptions:usingBlock:"), function(self, _cmd, opts, aFunction)
{
    (self.isa.method_msgSend["enumerateKeysAndObjectsUsingBlock:"] || _objj_forward)(self, "enumerateKeysAndObjectsUsingBlock:", aFunction);
}
,["void","CPEnumerationOptions","Function"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    var result = new CFMutableDictionary();
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["id"]), new objj_method(sel_getUid("dictionary"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("dictionaryWithDictionary:"), function(self, _cmd, aDictionary)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDictionary:"] || _objj_forward)(___r1, "initWithDictionary:", aDictionary));
    var ___r1;
}
,["id","CPDictionary"]), new objj_method(sel_getUid("dictionaryWithObject:forKey:"), function(self, _cmd, anObject, aKey)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [anObject], [aKey]));
    var ___r1;
}
,["id","id","id"]), new objj_method(sel_getUid("dictionaryWithObjects:forKeys:"), function(self, _cmd, objects, keys)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", objects, keys));
    var ___r1;
}
,["id","CPArray","CPArray"]), new objj_method(sel_getUid("dictionaryWithJSObject:"), function(self, _cmd, object)
{
    return (self.isa.method_msgSend["dictionaryWithJSObject:recursively:"] || _objj_forward)(self, "dictionaryWithJSObject:recursively:", object, NO);
}
,["id","JSObject"]), new objj_method(sel_getUid("dictionaryWithJSObject:recursively:"), function(self, _cmd, object, recursively)
{
    var key = "",
        dictionary = ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    for (key in object)
    {
        if (!object.hasOwnProperty(key))
            continue;
        var value = object[key];
        if (value === null)
        {
            (dictionary == null ? null : (dictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(dictionary, "setObject:forKey:", (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null"), key));
            continue;
        }
        if (recursively)
        {
            if (value.constructor === Object)
                value = (CPDictionary.isa.method_msgSend["dictionaryWithJSObject:recursively:"] || _objj_forward)(CPDictionary, "dictionaryWithJSObject:recursively:", value, YES);
            else if ((value == null ? null : (value.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(value, "isKindOfClass:", CPArray)))
            {
                var newValue = [],
                    i = 0,
                    count = value.length;
                for (; i < count; i++)
                {
                    var thisValue = value[i];
                    if (thisValue === null)
                    {
                        newValue.push((CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null"));
                    }
                    else
                    {
                        if (thisValue.constructor === Object)
                            newValue.push((CPDictionary.isa.method_msgSend["dictionaryWithJSObject:recursively:"] || _objj_forward)(CPDictionary, "dictionaryWithJSObject:recursively:", thisValue, YES));
                        else
                            newValue.push(thisValue);
                    }
                }
                value = newValue;
            }
        }
        (dictionary == null ? null : (dictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(dictionary, "setObject:forKey:", value, key));
    }
    return dictionary;
    var ___r1;
}
,["id","JSObject","BOOL"]), new objj_method(sel_getUid("dictionaryWithObjectsAndKeys:"), function(self, _cmd, firstObject)
{
    arguments[0] = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc");
    arguments[1] = sel_getUid("initWithObjectsAndKeys:");
    return objj_msgSend.apply(this, arguments);
}
,["id","id"])]);
}{
var the_class = objj_getClass("CPDictionary")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPDictionary\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    return (aCoder == null ? null : (aCoder.isa.method_msgSend["_decodeDictionaryOfObjectsForKey:"] || _objj_forward)(aCoder, "_decodeDictionaryOfObjectsForKey:", "CP.objects"));
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["_encodeDictionaryOfObjects:forKey:"] || _objj_forward)(aCoder, "_encodeDictionaryOfObjects:forKey:", self, "CP.objects"));
}
,["void","CPCoder"])]);
}{var the_class = objj_allocateClassPair(CPEnumerator, "_CPDictionaryValueEnumerator"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_keyEnumerator", "CPEnumerator"), new objj_ivar("_dictionary", "CPDictionary")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithDictionary:"), function(self, _cmd, aDictionary)
{
    self = (objj_getClass("_CPDictionaryValueEnumerator").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._keyEnumerator = (aDictionary == null ? null : (aDictionary.isa.method_msgSend["keyEnumerator"] || _objj_forward)(aDictionary, "keyEnumerator"));
        self._dictionary = aDictionary;
    }
    return self;
}
,["id","CPDictionary"]), new objj_method(sel_getUid("nextObject"), function(self, _cmd)
{
    var key = ((___r1 = self._keyEnumerator), ___r1 == null ? null : (___r1.isa.method_msgSend["nextObject"] || _objj_forward)(___r1, "nextObject"));
    if (key === nil)
        return nil;
    return ((___r1 = self._dictionary), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", key));
    var ___r1;
}
,["id"])]);
}{var the_class = objj_allocateClassPair(CPDictionary, "CPMutableDictionary"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
}CFDictionary.prototype.isa = CPDictionary;
CFMutableDictionary.prototype.isa = CPMutableDictionary;
p;14;CPEnumerator.jt;420;@STATIC;1.0;i;10;CPObject.jt;387;objj_executeFile("CPObject.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPEnumerator"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("nextObject"), function(self, _cmd)
{
    return nil;
}
,["id"]), new objj_method(sel_getUid("allObjects"), function(self, _cmd)
{
    return [];
}
,["CPArray"])]);
}p;9;CPError.jt;5159;@STATIC;1.0;i;14;CPDictionary.ji;10;CPObject.ji;10;CPString.jt;5091;objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);CPCappuccinoErrorDomain = kCFErrorDomainCappuccino;
CPCocoaErrorDomain = kCFErrorDomainCappuccino;
CPUnderlyingErrorKey = kCFErrorUnderlyingErrorKey;
CPLocalizedDescriptionKey = kCFErrorLocalizedDescriptionKey;
CPLocalizedFailureReasonErrorKey = kCFErrorLocalizedFailureReasonKey;
CPLocalizedRecoverySuggestionErrorKey = kCFErrorLocalizedRecoverySuggestionKey;
CPLocalizedRecoveryOptionsErrorKey = "CPLocalizedRecoveryOptionsErrorKey";
CPRecoveryAttempterErrorKey = "CPRecoveryAttempterErrorKey";
CPHelpAnchorErrorKey = "CPHelpAnchorErrorKey";
CPStringEncodingErrorKey = "CPStringEncodingErrorKey";
CPURLErrorKey = kCFErrorURLKey;
CPFilePathErrorKey = kCFErrorFilePathKey;
{var the_class = objj_allocateClassPair(CPObject, "CPError"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithDomain:code:userInfo:"), function(self, _cmd, aDomain, aCode, aDict)
{
    var result = new CFError(aDomain, aCode, aDict);
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["id","CPString","CPInteger","CPDictionary"]), new objj_method(sel_getUid("code"), function(self, _cmd)
{
    return self.code();
}
,["CPInteger"]), new objj_method(sel_getUid("userInfo"), function(self, _cmd)
{
    return self.userInfo();
}
,["CPString"]), new objj_method(sel_getUid("domain"), function(self, _cmd)
{
    return self.domain();
}
,["CPString"]), new objj_method(sel_getUid("localizedDescription"), function(self, _cmd)
{
    return self.description();
}
,["CPString"]), new objj_method(sel_getUid("localizedFailureReason"), function(self, _cmd)
{
    return self.failureReason();
}
,["CPString"]), new objj_method(sel_getUid("localizedRecoveryOptions"), function(self, _cmd)
{
    var userInfo = self.userInfo(),
        recoveryOptions = userInfo.valueForKey(CPLocalizedRecoveryOptionsErrorKey);
    return recoveryOptions;
}
,["CPArray"]), new objj_method(sel_getUid("localizedRecoverySuggestion"), function(self, _cmd)
{
    return self.recoverySuggestion();
}
,["CPString"]), new objj_method(sel_getUid("recoveryAttempter"), function(self, _cmd)
{
    var userInfo = self.userInfo(),
        recoveryAttempter = userInfo.valueForKey(CPRecoveryAttempterErrorKey);
    return recoveryAttempter;
}
,["id"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "Error Domain=%@ Code=%d \"%@\" UserInfo=%@", self.domain(), self.code(), self.description(), self.userInfo());
}
,["CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    var obj = new CFError();
    obj.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return obj;
}
,["id"]), new objj_method(sel_getUid("errorWithDomain:code:userInfo:"), function(self, _cmd, aDomain, aCode, aDict)
{
    return ((___r1 = (CPError.isa.method_msgSend["alloc"] || _objj_forward)(CPError, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithDomain:code:userInfo:"] || _objj_forward)(___r1, "initWithDomain:code:userInfo:", aDomain, aCode, aDict));
    var ___r1;
}
,["id","CPString","CPInteger","CPDictionary"])]);
}var CPErrorCodeKey = "CPErrorCodeKey",
    CPErrorDomainKey = "CPErrorDomainKey",
    CPErrorUserInfoKey = "CPErrorUserInfoKey";
{
var the_class = objj_getClass("CPError")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPError\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    var code = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPErrorCodeKey)),
        domain = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPErrorDomainKey)),
        userInfo = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPErrorUserInfoKey));
    return (self.isa.method_msgSend["initWithDomain:code:userInfo:"] || _objj_forward)(self, "initWithDomain:code:userInfo:", domain, code, userInfo);
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self.domain(), CPErrorDomainKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self.code(), CPErrorCodeKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self.userInfo(), CPErrorUserInfoKey));
}
,["void","CPCoder"])]);
}CFError.prototype.isa = CPError;
p;13;CPException.jt;8332;@STATIC;1.0;i;9;CPCoder.ji;10;CPObject.ji;10;CPString.jt;8270;objj_executeFile("CPCoder.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);CPInvalidArgumentException = "CPInvalidArgumentException";
CPUnsupportedMethodException = "CPUnsupportedMethodException";
CPRangeException = "CPRangeException";
CPInternalInconsistencyException = "CPInternalInconsistencyException";
CPGenericException = "CPGenericException";
{var the_class = objj_allocateClassPair(CPObject, "CPException"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_userInfo", "id"), new objj_ivar("name", "CPString"), new objj_ivar("message", "CPString")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithName:reason:userInfo:"), function(self, _cmd, aName, aReason, aUserInfo)
{
    self = (objj_getClass("CPException").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self.name = aName;
        self.message = aReason;
        self._userInfo = aUserInfo;
    }
    return self;
}
,["id","CPString","CPString","CPDictionary"]), new objj_method(sel_getUid("name"), function(self, _cmd)
{
    return self.name;
}
,["CPString"]), new objj_method(sel_getUid("reason"), function(self, _cmd)
{
    return self.message;
}
,["CPString"]), new objj_method(sel_getUid("userInfo"), function(self, _cmd)
{
    return self._userInfo;
}
,["CPDictionary"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return self.message;
}
,["CPString"]), new objj_method(sel_getUid("raise"), function(self, _cmd)
{
    throw self;
}
,["void"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    if (!anObject || !anObject.isa)
        return NO;
    return (anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", CPException)) && self.name === (anObject == null ? null : (anObject.isa.method_msgSend["name"] || _objj_forward)(anObject, "name")) && self.message === (anObject == null ? null : (anObject.isa.method_msgSend["message"] || _objj_forward)(anObject, "message")) && (self._userInfo === (anObject == null ? null : (anObject.isa.method_msgSend["userInfo"] || _objj_forward)(anObject, "userInfo")) || ((___r1 = self._userInfo), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqual:"] || _objj_forward)(___r1, "isEqual:", (anObject == null ? null : (anObject.isa.method_msgSend["userInfo"] || _objj_forward)(anObject, "userInfo")))));
    var ___r1;
}
,["BOOL","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    var result = new Error();
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["id"]), new objj_method(sel_getUid("raise:reason:"), function(self, _cmd, aName, aReason)
{
    ((___r1 = (self.isa.method_msgSend["exceptionWithName:reason:userInfo:"] || _objj_forward)(self, "exceptionWithName:reason:userInfo:", aName, aReason, nil)), ___r1 == null ? null : (___r1.isa.method_msgSend["raise"] || _objj_forward)(___r1, "raise"));
    var ___r1;
}
,["void","CPString","CPString"]), new objj_method(sel_getUid("raise:format:"), function(self, _cmd, aName, aFormat)
{
    if (!aFormat)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "raise:format: the format can't be 'nil'");
    var aReason = ObjectiveJ.sprintf.apply(this, Array.prototype.slice.call(arguments, 3));
    ((___r1 = (self.isa.method_msgSend["exceptionWithName:reason:userInfo:"] || _objj_forward)(self, "exceptionWithName:reason:userInfo:", aName, aReason, nil)), ___r1 == null ? null : (___r1.isa.method_msgSend["raise"] || _objj_forward)(___r1, "raise"));
    var ___r1;
}
,["void","CPString","CPString"]), new objj_method(sel_getUid("exceptionWithName:reason:userInfo:"), function(self, _cmd, aName, aReason, aUserInfo)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithName:reason:userInfo:"] || _objj_forward)(___r1, "initWithName:reason:userInfo:", aName, aReason, aUserInfo));
    var ___r1;
}
,["CPException","CPString","CPString","CPDictionary"])]);
}{
var the_class = objj_getClass("CPException")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPException\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["exceptionWithName:reason:userInfo:"] || _objj_forward)(___r1, "exceptionWithName:reason:userInfo:", self.name, self.message, self._userInfo));
    var ___r1;
}
,["id"])]);
}var CPExceptionNameKey = "CPExceptionNameKey",
    CPExceptionReasonKey = "CPExceptionReasonKey",
    CPExceptionUserInfoKey = "CPExceptionUserInfoKey";
{
var the_class = objj_getClass("CPException")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPException\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    if (self = (objj_getClass("CPException").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self.name = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPExceptionNameKey));
        self.message = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPExceptionReasonKey));
        self._userInfo = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPExceptionUserInfoKey));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self.name, CPExceptionNameKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self.message, CPExceptionReasonKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._userInfo, CPExceptionUserInfoKey));
}
,["void","CPCoder"])]);
}Error.prototype.isa = CPException;
Error.prototype._userInfo = null;
(CPException.isa.method_msgSend["initialize"] || _objj_forward)(CPException, "initialize");
_CPRaiseInvalidAbstractInvocation = function(anObject, aSelector)
{
    (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "*** -" + sel_getName(aSelector) + " cannot be sent to an abstract object of class " + (anObject == null ? null : (anObject.isa.method_msgSend["className"] || _objj_forward)(anObject, "className")) + ": Create a concrete instance!");
}
_CPRaiseInvalidArgumentException = function(anObject, aSelector, aMessage)
{
    (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, (class_isMetaClass(anObject.isa) ? "+" : "-") + "[" + (anObject == null ? null : (anObject.isa.method_msgSend["className"] || _objj_forward)(anObject, "className")) + " " + aSelector + "]: " + aMessage);
}
_CPRaiseRangeException = function(anObject, aSelector, anIndex, aCount)
{
    (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPRangeException, (class_isMetaClass(anObject.isa) ? "+" : "-") + "[" + (anObject == null ? null : (anObject.isa.method_msgSend["className"] || _objj_forward)(anObject, "className")) + " " + aSelector + "]: " + "index (" + anIndex + ") beyond bounds (" + aCount + ")");
}
_CPReportLenientDeprecation = function(aClass, oldSelector, newSelector)
{
    CPLog.warn("[" + CPStringFromClass(aClass) + " " + CPStringFromSelector(oldSelector) + "] is deprecated, using " + CPStringFromSelector(newSelector) + " instead.");
}
p;13;CPFormatter.jt;2343;@STATIC;1.0;i;13;CPException.ji;10;CPObject.jt;2291;objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPFormatter"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("stringForObjectValue:"), function(self, _cmd, anObject)
{
    _CPRaiseInvalidAbstractInvocation(self, _cmd);
    return nil;
}
,["CPString","id"]), new objj_method(sel_getUid("editingStringForObjectValue:"), function(self, _cmd, anObject)
{
    return (self.isa.method_msgSend["stringForObjectValue:"] || _objj_forward)(self, "stringForObjectValue:", anObject);
}
,["CPString","id"]), new objj_method(sel_getUid("getObjectValue:forString:errorDescription:"), function(self, _cmd, anObject, aString, anError)
{
    _CPRaiseInvalidAbstractInvocation(self, _cmd);
    return NO;
}
,["BOOL","idRef","CPString","CPStringRef"]), new objj_method(sel_getUid("isPartialStringValid:newEditingString:errorDescription:"), function(self, _cmd, aPartialString, aNewString, anError)
{
    (aPartialString)(nil);
    if (anError)
        (anError)(nil);
    return YES;
}
,["BOOL","CPString","CPStringRef","CPStringRef"]), new objj_method(sel_getUid("isPartialStringValid:proposedSelectedRange:originalString:originalSelectedRange:errorDescription:"), function(self, _cmd, aPartialStringRef, aProposedSelectedRangeRef, originalString, originalSelectedRange, anError)
{
    var newString = nil,
        valid = (self.isa.method_msgSend["isPartialStringValid:newEditingString:errorDescription:"] || _objj_forward)(self, "isPartialStringValid:newEditingString:errorDescription:", aPartialStringRef, function(__input) { if (arguments.length) return newString = __input; return newString; }, anError);
    if (!valid)
    {
        (aPartialStringRef)(newString);
        if (newString !== nil)
            (aProposedSelectedRangeRef)(CPMakeRange(newString.length, 0));
    }
    return valid;
}
,["BOOL","CPStringRef","CPRangeRef","CPString","CPRange","CPStringRef"]), new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    return (self.isa.method_msgSend["init"] || _objj_forward)(self, "init");
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
}
,["void","CPCoder"])]);
}p;21;CPFunctionOperation.jt;2285;@STATIC;1.0;i;9;CPArray.ji;10;CPObject.ji;13;CPOperation.jt;2220;objj_executeFile("CPArray.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPOperation.j", YES);{var the_class = objj_allocateClassPair(CPOperation, "CPFunctionOperation"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_functions", "CPArray")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("main"), function(self, _cmd)
{
    if (self._functions && ((___r1 = self._functions), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")) > 0)
    {
        var i = 0,
            count = ((___r1 = self._functions), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
        for (; i < count; i++)
        {
            var func = ((___r1 = self._functions), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", i));
            func();
        }
    }
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPFunctionOperation").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._functions = [];
    }
    return self;
}
,["id"]), new objj_method(sel_getUid("addExecutionFunction:"), function(self, _cmd, jsFunction)
{
    ((___r1 = self._functions), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", jsFunction));
    var ___r1;
}
,["void","JSObject"]), new objj_method(sel_getUid("executionFunctions"), function(self, _cmd)
{
    return self._functions;
}
,["CPArray"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("functionOperationWithFunction:"), function(self, _cmd, jsFunction)
{
    functionOp = ((___r1 = (CPFunctionOperation.isa.method_msgSend["alloc"] || _objj_forward)(CPFunctionOperation, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    (functionOp == null ? null : (functionOp.isa.method_msgSend["addExecutionFunction:"] || _objj_forward)(functionOp, "addExecutionFunction:", jsFunction));
    return functionOp;
    var ___r1;
}
,["id","JSObject"])]);
}p;12;CPGeometry.jt;1741;@STATIC;1.0;i;13;_CGGeometry.jt;1704;objj_executeFile("_CGGeometry.j", YES);{var the_typedef = objj_allocateTypeDef("CPRectEdge");
objj_registerTypeDef(the_typedef);
}CPMinXEdge = 0;
CPMinYEdge = 1;
CPMaxXEdge = 2;
CPMaxYEdge = 3;
CPMakePoint = CGPointMake;
CPMakeSize = CGSizeMake;
CPMakeRect = CGRectMake;
CPPointCreateCopy = CGPointMakeCopy;
CPPointEqualToPoint = CGPointEqualToPoint;
CPPointInRect = function(aPoint, aRect)
{
    return CGRectContainsPoint(aRect, aPoint);
};
CPRectEqualToRect = CGRectEqualToRect;
CPRectIsEmpty = CGRectIsEmpty;
CPRectContainsRect = CGRectContainsRect;
CPRectIntersection = CGRectIntersection;
CPPointMake = CGPointMake;
CPRectInset = CGRectInset;
CPRectIntegral = CGRectIntegral;
CPRectCreateCopy = CGRectCreateCopy;
CPRectMake = CGRectMake;
CPRectOffset = CGRectOffset;
CPRectStandardize = CGRectStandardize;
CPRectUnion = CGRectUnion;
CPSizeCreateCopy = CGSizeCreateCopy;
CPSizeMake = CGSizeMake;
CPRectContainsPoint = CGRectContainsPoint;
CPRectGetHeight = CGRectGetHeight;
CPRectGetMaxX = CGRectGetMaxX;
CPRectGetMaxY = CGRectGetMaxY;
CPRectGetMidX = CGRectGetMidX;
CPRectGetMidY = CGRectGetMidY;
CPRectGetMinX = CGRectGetMinX;
CPRectGetMinY = CGRectGetMinY;
CPRectGetWidth = CGRectGetWidth;
CPRectIntersectsRect = CGRectIntersectsRect;
CPRectIsNull = CGRectIsNull;
CPDivideRect = CGRectDivide;
CPSizeEqualToSize = CGSizeEqualToSize;
CPStringFromPoint = CGStringFromPoint;
CPStringFromSize = CGStringFromSize;
CPStringFromRect = CGStringFromRect;
CPPointFromString = CGPointFromString;
CPSizeFromString = CGSizeFromString;
CPRectFromString = CGRectFromString;
CPPointFromEvent = CGPointFromEvent;
CPSizeMakeZero = CGSizeMakeZero;
CPRectMakeZero = CGRectMakeZero;
CPPointMakeZero = CGPointMakeZero;
p;13;CPIndexPath.jt;7410;@STATIC;1.0;i;9;CPArray.ji;13;CPException.ji;10;CPObject.ji;9;CPRange.ji;18;CPSortDescriptor.jt;7309;objj_executeFile("CPArray.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPRange.j", YES);objj_executeFile("CPSortDescriptor.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPIndexPath"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_indexes", "CPArray")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("indexes"), function(self, _cmd)
{
    return self._indexes;
}
,["CPArray"]), new objj_method(sel_getUid("setIndexes:"), function(self, _cmd, newValue)
{
    self._indexes = newValue;
}
,["void","CPArray"]), new objj_method(sel_getUid("initWithIndexes:length:"), function(self, _cmd, indexes, length)
{
    self = (objj_getClass("CPIndexPath").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        self._indexes = (indexes == null ? null : (indexes.isa.method_msgSend["subarrayWithRange:"] || _objj_forward)(indexes, "subarrayWithRange:", CPMakeRange(0, length)));
    return self;
}
,["id","CPArray","int"]), new objj_method(sel_getUid("initWithIndexes:"), function(self, _cmd, indexes)
{
    self = (objj_getClass("CPIndexPath").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        self._indexes = (indexes == null ? null : (indexes.isa.method_msgSend["copy"] || _objj_forward)(indexes, "copy"));
    return self;
}
,["id","CPArray"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (objj_getClass("CPIndexPath").super_class.method_dtable["description"] || _objj_forward)(self, "description") + " " + self._indexes;
}
,["CPString"]), new objj_method(sel_getUid("length"), function(self, _cmd)
{
    return ((___r1 = self._indexes), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("indexAtPosition:"), function(self, _cmd, position)
{
    return ((___r1 = self._indexes), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", position));
    var ___r1;
}
,["int","int"]), new objj_method(sel_getUid("setIndexes:"), function(self, _cmd, theIndexes)
{
    self._indexes = (theIndexes == null ? null : (theIndexes.isa.method_msgSend["copy"] || _objj_forward)(theIndexes, "copy"));
}
,["void","CPArray"]), new objj_method(sel_getUid("indexes"), function(self, _cmd)
{
    return ((___r1 = self._indexes), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("indexPathByAddingIndex:"), function(self, _cmd, index)
{
    return (CPIndexPath.isa.method_msgSend["indexPathWithIndexes:"] || _objj_forward)(CPIndexPath, "indexPathWithIndexes:", ((___r1 = self._indexes), ___r1 == null ? null : (___r1.isa.method_msgSend["arrayByAddingObject:"] || _objj_forward)(___r1, "arrayByAddingObject:", index)));
    var ___r1;
}
,["CPIndexPath","int"]), new objj_method(sel_getUid("indexPathByRemovingLastIndex"), function(self, _cmd)
{
    return (CPIndexPath.isa.method_msgSend["indexPathWithIndexes:length:"] || _objj_forward)(CPIndexPath, "indexPathWithIndexes:length:", self._indexes, (self.isa.method_msgSend["length"] || _objj_forward)(self, "length") - 1);
}
,["CPIndexPath"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    if (anObject === self)
        return YES;
    if ((anObject == null ? null : (anObject.isa.method_msgSend["class"] || _objj_forward)(anObject, "class")) !== (CPIndexPath.isa.method_msgSend["class"] || _objj_forward)(CPIndexPath, "class"))
        return NO;
    return ((___r1 = self._indexes), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToArray:"] || _objj_forward)(___r1, "isEqualToArray:", (anObject == null ? null : (anObject.isa.method_msgSend["indexes"] || _objj_forward)(anObject, "indexes"))));
    var ___r1;
}
,["BOOL","id"]), new objj_method(sel_getUid("compare:"), function(self, _cmd, anIndexPath)
{
    if (!anIndexPath)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "indexPath to " + self + " was nil");
    var lhsIndexes = (self.isa.method_msgSend["indexes"] || _objj_forward)(self, "indexes"),
        rhsIndexes = (anIndexPath == null ? null : (anIndexPath.isa.method_msgSend["indexes"] || _objj_forward)(anIndexPath, "indexes")),
        lhsCount = (lhsIndexes == null ? null : (lhsIndexes.isa.method_msgSend["count"] || _objj_forward)(lhsIndexes, "count")),
        rhsCount = (rhsIndexes == null ? null : (rhsIndexes.isa.method_msgSend["count"] || _objj_forward)(rhsIndexes, "count"));
    var index = 0,
        count = MIN(lhsCount, rhsCount);
    for (; index < count; ++index)
    {
        var lhs = lhsIndexes[index],
            rhs = rhsIndexes[index];
        if (lhs < rhs)
            return CPOrderedAscending;
        else if (lhs > rhs)
            return CPOrderedDescending;
    }
    if (lhsCount === rhsCount)
        return CPOrderedSame;
    if (lhsCount === count)
        return CPOrderedAscending;
    return CPOrderedDescending;
}
,["CPComparisonResult","CPIndexPath"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("indexPathWithIndex:"), function(self, _cmd, index)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithIndexes:length:"] || _objj_forward)(___r1, "initWithIndexes:length:", [index], 1));
    var ___r1;
}
,["id","int"]), new objj_method(sel_getUid("indexPathWithIndexes:length:"), function(self, _cmd, indexes, length)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithIndexes:length:"] || _objj_forward)(___r1, "initWithIndexes:length:", indexes, length));
    var ___r1;
}
,["id","CPArray","int"]), new objj_method(sel_getUid("indexPathWithIndexes:"), function(self, _cmd, indexes)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithIndexes:"] || _objj_forward)(___r1, "initWithIndexes:", indexes));
    var ___r1;
}
,["id","CPArray"])]);
}var CPIndexPathIndexesKey = "CPIndexPathIndexes";
{
var the_class = objj_getClass("CPIndexPath")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPIndexPath\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, theCoder)
{
    if (self = (self == null ? null : (self.isa.method_msgSend["init"] || _objj_forward)(self, "init")))
    {
        self._indexes = (theCoder == null ? null : (theCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(theCoder, "decodeObjectForKey:", CPIndexPathIndexesKey));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, theCoder)
{
    (theCoder == null ? null : (theCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(theCoder, "encodeObject:forKey:", self._indexes, CPIndexPathIndexesKey));
}
,["void","CPCoder"])]);
}p;12;CPIndexSet.jt;31046;@STATIC;1.0;i;9;CPArray.ji;10;CPObject.ji;9;CPRange.jt;30985;objj_executeFile("CPArray.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPRange.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPIndexSet"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_count", "unsigned"), new objj_ivar("_ranges", "CPArray")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    return (self.isa.method_msgSend["initWithIndexesInRange:"] || _objj_forward)(self, "initWithIndexesInRange:", CPMakeRange(0, 0));
}
,["id"]), new objj_method(sel_getUid("initWithIndex:"), function(self, _cmd, anIndex)
{
    if (!(!isNaN(parseFloat(anIndex)) && isFinite(anIndex)))
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Invalid index");
    return (self.isa.method_msgSend["initWithIndexesInRange:"] || _objj_forward)(self, "initWithIndexesInRange:", CPMakeRange(anIndex, 1));
}
,["id","CPInteger"]), new objj_method(sel_getUid("initWithIndexesInRange:"), function(self, _cmd, aRange)
{
    if (aRange.location < 0)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Range " + CPStringFromRange(aRange) + " is out of bounds.");
    self = (objj_getClass("CPIndexSet").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._count = MAX(0, aRange.length);
        if (self._count > 0)
            self._ranges = [aRange];
        else
            self._ranges = [];
    }
    return self;
}
,["id","CPRange"]), new objj_method(sel_getUid("initWithIndexSet:"), function(self, _cmd, anIndexSet)
{
    self = (objj_getClass("CPIndexSet").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._count = (anIndexSet == null ? null : (anIndexSet.isa.method_msgSend["count"] || _objj_forward)(anIndexSet, "count"));
        self._ranges = [];
        var otherRanges = anIndexSet._ranges,
            otherRangesCount = otherRanges.length;
        while (otherRangesCount--)
            self._ranges[otherRangesCount] = CPMakeRangeCopy(otherRanges[otherRangesCount]);
    }
    return self;
}
,["id","CPIndexSet"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    if (self === anObject)
        return YES;
    if (!anObject || !(anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", (CPIndexSet.isa.method_msgSend["class"] || _objj_forward)(CPIndexSet, "class"))))
        return NO;
    return (self.isa.method_msgSend["isEqualToIndexSet:"] || _objj_forward)(self, "isEqualToIndexSet:", anObject);
}
,["BOOL","id"]), new objj_method(sel_getUid("isEqualToIndexSet:"), function(self, _cmd, anIndexSet)
{
    if (!anIndexSet)
        return NO;
    if (self === anIndexSet)
        return YES;
    var rangesCount = self._ranges.length,
        otherRanges = anIndexSet._ranges;
    if (rangesCount !== otherRanges.length || self._count !== anIndexSet._count)
        return NO;
    while (rangesCount--)
        if (!CPEqualRanges(self._ranges[rangesCount], otherRanges[rangesCount]))
            return NO;
    return YES;
}
,["BOOL","CPIndexSet"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    return self === anObject || (anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"))) && (self.isa.method_msgSend["isEqualToIndexSet:"] || _objj_forward)(self, "isEqualToIndexSet:", anObject);
}
,["BOOL","id"]), new objj_method(sel_getUid("containsIndex:"), function(self, _cmd, anIndex)
{
    return positionOfIndex(self._ranges, anIndex) !== CPNotFound;
}
,["BOOL","CPInteger"]), new objj_method(sel_getUid("containsIndexesInRange:"), function(self, _cmd, aRange)
{
    if (aRange.length <= 0)
        return NO;
    if (self._count < aRange.length)
        return NO;
    var rangeIndex = positionOfIndex(self._ranges, aRange.location);
    if (rangeIndex === CPNotFound)
        return NO;
    var range = self._ranges[rangeIndex];
    return (CPIntersectionRange(range, aRange)).length === aRange.length;
}
,["BOOL","CPRange"]), new objj_method(sel_getUid("containsIndexes:"), function(self, _cmd, anIndexSet)
{
    var otherCount = anIndexSet._count;
    if (otherCount <= 0)
        return YES;
    if (self._count < otherCount)
        return NO;
    var otherRanges = anIndexSet._ranges,
        otherRangesCount = otherRanges.length;
    while (otherRangesCount--)
        if (!(self.isa.method_msgSend["containsIndexesInRange:"] || _objj_forward)(self, "containsIndexesInRange:", otherRanges[otherRangesCount]))
            return NO;
    return YES;
}
,["BOOL","CPIndexSet"]), new objj_method(sel_getUid("intersectsIndexesInRange:"), function(self, _cmd, aRange)
{
    if (self._count <= 0)
        return NO;
    var lhsRangeIndex = assumedPositionOfIndex(self._ranges, aRange.location);
    if (FLOOR(lhsRangeIndex) === lhsRangeIndex)
        return YES;
    var rhsRangeIndex = assumedPositionOfIndex(self._ranges, CPMaxRange(aRange) - 1);
    if (FLOOR(rhsRangeIndex) === rhsRangeIndex)
        return YES;
    return lhsRangeIndex !== rhsRangeIndex;
}
,["BOOL","CPRange"]), new objj_method(sel_getUid("count"), function(self, _cmd)
{
    return self._count;
}
,["int"]), new objj_method(sel_getUid("firstIndex"), function(self, _cmd)
{
    if (self._count > 0)
        return self._ranges[0].location;
    return CPNotFound;
}
,["CPInteger"]), new objj_method(sel_getUid("lastIndex"), function(self, _cmd)
{
    if (self._count > 0)
        return CPMaxRange(self._ranges[self._ranges.length - 1]) - 1;
    return CPNotFound;
}
,["CPInteger"]), new objj_method(sel_getUid("indexGreaterThanIndex:"), function(self, _cmd, anIndex)
{
    ++anIndex;
    var rangeIndex = assumedPositionOfIndex(self._ranges, anIndex);
    if (rangeIndex === CPNotFound)
        return CPNotFound;
    rangeIndex = CEIL(rangeIndex);
    if (rangeIndex >= self._ranges.length)
        return CPNotFound;
    var range = self._ranges[rangeIndex];
    if (CPLocationInRange(anIndex, range))
        return anIndex;
    return range.location;
}
,["CPInteger","CPInteger"]), new objj_method(sel_getUid("indexLessThanIndex:"), function(self, _cmd, anIndex)
{
    --anIndex;
    var rangeIndex = assumedPositionOfIndex(self._ranges, anIndex);
    if (rangeIndex === CPNotFound)
        return CPNotFound;
    rangeIndex = FLOOR(rangeIndex);
    if (rangeIndex < 0)
        return CPNotFound;
    var range = self._ranges[rangeIndex];
    if (CPLocationInRange(anIndex, range))
        return anIndex;
    return CPMaxRange(range) - 1;
}
,["CPInteger","CPInteger"]), new objj_method(sel_getUid("indexGreaterThanOrEqualToIndex:"), function(self, _cmd, anIndex)
{
    return (self.isa.method_msgSend["indexGreaterThanIndex:"] || _objj_forward)(self, "indexGreaterThanIndex:", anIndex - 1);
}
,["CPInteger","CPInteger"]), new objj_method(sel_getUid("indexLessThanOrEqualToIndex:"), function(self, _cmd, anIndex)
{
    return (self.isa.method_msgSend["indexLessThanIndex:"] || _objj_forward)(self, "indexLessThanIndex:", anIndex + 1);
}
,["CPInteger","CPInteger"]), new objj_method(sel_getUid("getIndexes:maxCount:inIndexRange:"), function(self, _cmd, anArray, aMaxCount, aRange)
{
    if (!self._count || aMaxCount === 0 || aRange && !aRange.length)
    {
        if (aRange)
            aRange.length = 0;
        return 0;
    }
    var total = 0;
    if (aRange)
    {
        var firstIndex = aRange.location,
            lastIndex = CPMaxRange(aRange) - 1,
            rangeIndex = CEIL(assumedPositionOfIndex(self._ranges, firstIndex)),
            lastRangeIndex = FLOOR(assumedPositionOfIndex(self._ranges, lastIndex));
    }
    else
    {
        var firstIndex = (self.isa.method_msgSend["firstIndex"] || _objj_forward)(self, "firstIndex"),
            lastIndex = (self.isa.method_msgSend["lastIndex"] || _objj_forward)(self, "lastIndex"),
            rangeIndex = 0,
            lastRangeIndex = self._ranges.length - 1;
    }
    while (rangeIndex <= lastRangeIndex)
    {
        var range = self._ranges[rangeIndex],
            index = MAX(firstIndex, range.location),
            maxRange = MIN(lastIndex + 1, CPMaxRange(range));
        for (; index < maxRange; ++index)
        {
            anArray[total++] = index;
            if (total === aMaxCount)
            {
                if (aRange)
                {
                    aRange.location = index + 1;
                    aRange.length = lastIndex + 1 - index - 1;
                }
                return aMaxCount;
            }
        }
        ++rangeIndex;
    }
    if (aRange)
    {
        aRange.location = CPNotFound;
        aRange.length = 0;
    }
    return total;
}
,["CPInteger","CPArray","CPInteger","CPRange"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    var description = (objj_getClass("CPIndexSet").super_class.method_dtable["description"] || _objj_forward)(self, "description");
    if (self._count)
    {
        var index = 0,
            count = self._ranges.length;
        description += "[number of indexes: " + self._count + " (in " + count;
        if (count === 1)
            description += " range), indexes: (";
        else
            description += " ranges), indexes: (";
        for (; index < count; ++index)
        {
            var range = self._ranges[index];
            description += range.location;
            if (range.length > 1)
                description += "-" + (CPMaxRange(range) - 1);
            if (index + 1 < count)
                description += " ";
        }
        description += ")]";
    }
    else
        description += "(no indexes)";
    return description;
}
,["CPString"]), new objj_method(sel_getUid("enumerateIndexesUsingBlock:"), function(self, _cmd, aFunction)
{
    (self.isa.method_msgSend["enumerateIndexesWithOptions:usingBlock:"] || _objj_forward)(self, "enumerateIndexesWithOptions:usingBlock:", CPEnumerationNormal, aFunction);
}
,["void","Function"]), new objj_method(sel_getUid("enumerateIndexesWithOptions:usingBlock:"), function(self, _cmd, options, aFunction)
{
    if (!self._count)
        return;
    (self.isa.method_msgSend["enumerateIndexesInRange:options:usingBlock:"] || _objj_forward)(self, "enumerateIndexesInRange:options:usingBlock:", CPMakeRange(0, CPMaxRange(self._ranges[self._ranges.length - 1])), options, aFunction);
}
,["void","CPEnumerationOptions","Function"]), new objj_method(sel_getUid("enumerateIndexesInRange:options:usingBlock:"), function(self, _cmd, enumerationRange, options, aFunction)
{
    if (!self._count || CPEmptyRange(enumerationRange))
        return;
    var shouldStop = NO,
        index,
        stop,
        increment;
    if (options & CPEnumerationReverse)
    {
        (index = self._ranges.length - 1, stop = -1, increment = -1);
    }
    else
    {
        index = 0;
        stop = self._ranges.length;
        increment = 1;
    }
    for (; index !== stop; index += increment)
    {
        var range = self._ranges[index],
            rangeIndex,
            rangeStop,
            rangeIncrement;
        if (options & CPEnumerationReverse)
        {
            rangeIndex = CPMaxRange(range) - 1;
            rangeStop = range.location - 1;
            rangeIncrement = -1;
        }
        else
        {
            rangeIndex = range.location;
            rangeStop = CPMaxRange(range);
            rangeIncrement = 1;
        }
        for (; rangeIndex !== rangeStop; rangeIndex += rangeIncrement)
        {
            if (CPLocationInRange(rangeIndex, enumerationRange))
            {
                aFunction(rangeIndex, function(__input) { if (arguments.length) return shouldStop = __input; return shouldStop; });
                if (shouldStop)
                    return;
            }
        }
    }
}
,["void","CPRange","CPEnumerationOptions","Function"]), new objj_method(sel_getUid("indexPassingTest:"), function(self, _cmd, aPredicate)
{
    return (self.isa.method_msgSend["indexWithOptions:passingTest:"] || _objj_forward)(self, "indexWithOptions:passingTest:", CPEnumerationNormal, aPredicate);
}
,["unsigned","Function"]), new objj_method(sel_getUid("indexesPassingTest:"), function(self, _cmd, aPredicate)
{
    return (self.isa.method_msgSend["indexesWithOptions:passingTest:"] || _objj_forward)(self, "indexesWithOptions:passingTest:", CPEnumerationNormal, aPredicate);
}
,["CPIndexSet","Function"]), new objj_method(sel_getUid("indexWithOptions:passingTest:"), function(self, _cmd, anOptions, aPredicate)
{
    if (!self._count)
        return CPNotFound;
    return (self.isa.method_msgSend["indexInRange:options:passingTest:"] || _objj_forward)(self, "indexInRange:options:passingTest:", CPMakeRange(0, CPMaxRange(self._ranges[self._ranges.length - 1])), anOptions, aPredicate);
}
,["unsigned","CPEnumerationOptions","Function"]), new objj_method(sel_getUid("indexesWithOptions:passingTest:"), function(self, _cmd, anOptions, aPredicate)
{
    if (!self._count)
        return (CPIndexSet.isa.method_msgSend["indexSet"] || _objj_forward)(CPIndexSet, "indexSet");
    return (self.isa.method_msgSend["indexesInRange:options:passingTest:"] || _objj_forward)(self, "indexesInRange:options:passingTest:", CPMakeRange(0, CPMaxRange(self._ranges[self._ranges.length - 1])), anOptions, aPredicate);
}
,["CPIndexSet","CPEnumerationOptions","Function"]), new objj_method(sel_getUid("indexInRange:options:passingTest:"), function(self, _cmd, aRange, anOptions, aPredicate)
{
    if (!self._count || CPEmptyRange(aRange))
        return CPNotFound;
    var shouldStop = NO,
        index,
        stop,
        increment;
    if (anOptions & CPEnumerationReverse)
    {
        (index = self._ranges.length - 1, stop = -1, increment = -1);
    }
    else
    {
        index = 0;
        stop = self._ranges.length;
        increment = 1;
    }
    for (; index !== stop; index += increment)
    {
        var range = self._ranges[index],
            rangeIndex,
            rangeStop,
            rangeIncrement;
        if (anOptions & CPEnumerationReverse)
        {
            rangeIndex = CPMaxRange(range) - 1;
            rangeStop = range.location - 1;
            rangeIncrement = -1;
        }
        else
        {
            rangeIndex = range.location;
            rangeStop = CPMaxRange(range);
            rangeIncrement = 1;
        }
        for (; rangeIndex !== rangeStop; rangeIndex += rangeIncrement)
        {
            if (CPLocationInRange(rangeIndex, aRange))
            {
                if (aPredicate(rangeIndex, function(__input) { if (arguments.length) return shouldStop = __input; return shouldStop; }))
                    return rangeIndex;
                if (shouldStop)
                    return CPNotFound;
            }
        }
    }
    return CPNotFound;
}
,["unsigned","CPRange","CPEnumerationOptions","Function"]), new objj_method(sel_getUid("indexesInRange:options:passingTest:"), function(self, _cmd, aRange, anOptions, aPredicate)
{
    if (!self._count || CPEmptyRange(aRange))
        return (CPIndexSet.isa.method_msgSend["indexSet"] || _objj_forward)(CPIndexSet, "indexSet");
    var shouldStop = NO,
        index,
        stop,
        increment;
    if (anOptions & CPEnumerationReverse)
    {
        (index = self._ranges.length - 1, stop = -1, increment = -1);
    }
    else
    {
        index = 0;
        stop = self._ranges.length;
        increment = 1;
    }
    var indexesPassingTest = (CPMutableIndexSet == null ? null : (CPMutableIndexSet.isa.method_msgSend["indexSet"] || _objj_forward)(CPMutableIndexSet, "indexSet"));
    for (; index !== stop; index += increment)
    {
        var range = self._ranges[index],
            rangeIndex,
            rangeStop,
            rangeIncrement;
        if (anOptions & CPEnumerationReverse)
        {
            rangeIndex = CPMaxRange(range) - 1;
            rangeStop = range.location - 1;
            rangeIncrement = -1;
        }
        else
        {
            rangeIndex = range.location;
            rangeStop = CPMaxRange(range);
            rangeIncrement = 1;
        }
        for (; rangeIndex !== rangeStop; rangeIndex += rangeIncrement)
        {
            if (CPLocationInRange(rangeIndex, aRange))
            {
                if (aPredicate(rangeIndex, function(__input) { if (arguments.length) return shouldStop = __input; return shouldStop; }))
                    (indexesPassingTest == null ? null : (indexesPassingTest.isa.method_msgSend["addIndex:"] || _objj_forward)(indexesPassingTest, "addIndex:", rangeIndex));
                if (shouldStop)
                    return indexesPassingTest;
            }
        }
    }
    return indexesPassingTest;
}
,["CPIndexSet","CPRange","CPEnumerationOptions","Function"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("indexSet"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("indexSetWithIndex:"), function(self, _cmd, anIndex)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithIndex:"] || _objj_forward)(___r1, "initWithIndex:", anIndex));
    var ___r1;
}
,["id","int"]), new objj_method(sel_getUid("indexSetWithIndexesInRange:"), function(self, _cmd, aRange)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithIndexesInRange:"] || _objj_forward)(___r1, "initWithIndexesInRange:", aRange));
    var ___r1;
}
,["id","CPRange"])]);
}{
var the_class = objj_getClass("CPIndexSet")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPIndexSet\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("addIndex:"), function(self, _cmd, anIndex)
{
    (self.isa.method_msgSend["addIndexesInRange:"] || _objj_forward)(self, "addIndexesInRange:", CPMakeRange(anIndex, 1));
}
,["void","CPInteger"]), new objj_method(sel_getUid("addIndexes:"), function(self, _cmd, anIndexSet)
{
    var otherRanges = anIndexSet._ranges,
        otherRangesCount = otherRanges.length;
    while (otherRangesCount--)
        (self.isa.method_msgSend["addIndexesInRange:"] || _objj_forward)(self, "addIndexesInRange:", otherRanges[otherRangesCount]);
}
,["void","CPIndexSet"]), new objj_method(sel_getUid("addIndexesInRange:"), function(self, _cmd, aRange)
{
    if (aRange.location < 0)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Range " + CPStringFromRange(aRange) + " is out of bounds.");
    if (aRange.length <= 0)
        return;
    if (self._count <= 0)
    {
        self._count = aRange.length;
        self._ranges = [aRange];
        return;
    }
    var rangeCount = self._ranges.length,
        lhsRangeIndex = assumedPositionOfIndex(self._ranges, aRange.location - 1),
        lhsRangeIndexCEIL = CEIL(lhsRangeIndex);
    if (lhsRangeIndexCEIL === lhsRangeIndex && lhsRangeIndexCEIL < rangeCount)
        aRange = CPUnionRange(aRange, self._ranges[lhsRangeIndexCEIL]);
    var rhsRangeIndex = assumedPositionOfIndex(self._ranges, CPMaxRange(aRange)),
        rhsRangeIndexFLOOR = FLOOR(rhsRangeIndex);
    if (rhsRangeIndexFLOOR === rhsRangeIndex && rhsRangeIndexFLOOR >= 0)
        aRange = CPUnionRange(aRange, self._ranges[rhsRangeIndexFLOOR]);
    var removalCount = rhsRangeIndexFLOOR - lhsRangeIndexCEIL + 1;
    if (removalCount === self._ranges.length)
    {
        self._ranges = [aRange];
        self._count = aRange.length;
    }
    else if (removalCount === 1)
    {
        if (lhsRangeIndexCEIL < self._ranges.length)
            self._count -= self._ranges[lhsRangeIndexCEIL].length;
        self._count += aRange.length;
        self._ranges[lhsRangeIndexCEIL] = aRange;
    }
    else
    {
        if (removalCount > 0)
        {
            var removal = lhsRangeIndexCEIL,
                lastRemoval = lhsRangeIndexCEIL + removalCount - 1;
            for (; removal <= lastRemoval; ++removal)
                self._count -= self._ranges[removal].length;
            ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObjectsInRange:"] || _objj_forward)(___r1, "removeObjectsInRange:", CPMakeRange(lhsRangeIndexCEIL, removalCount)));
        }
        ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["insertObject:atIndex:"] || _objj_forward)(___r1, "insertObject:atIndex:", aRange, lhsRangeIndexCEIL));
        self._count += aRange.length;
    }
    var ___r1;
}
,["void","CPRange"]), new objj_method(sel_getUid("removeIndex:"), function(self, _cmd, anIndex)
{
    (self.isa.method_msgSend["removeIndexesInRange:"] || _objj_forward)(self, "removeIndexesInRange:", CPMakeRange(anIndex, 1));
}
,["void","CPInteger"]), new objj_method(sel_getUid("removeIndexes:"), function(self, _cmd, anIndexSet)
{
    var otherRanges = anIndexSet._ranges,
        otherRangesCount = otherRanges.length;
    while (otherRangesCount--)
        (self.isa.method_msgSend["removeIndexesInRange:"] || _objj_forward)(self, "removeIndexesInRange:", otherRanges[otherRangesCount]);
}
,["void","CPIndexSet"]), new objj_method(sel_getUid("removeAllIndexes"), function(self, _cmd)
{
    self._ranges = [];
    self._count = 0;
}
,["void"]), new objj_method(sel_getUid("removeIndexesInRange:"), function(self, _cmd, aRange)
{
    if (aRange.length <= 0)
        return;
    if (self._count <= 0)
        return;
    var rangeCount = self._ranges.length,
        lhsRangeIndex = assumedPositionOfIndex(self._ranges, aRange.location),
        lhsRangeIndexCEIL = CEIL(lhsRangeIndex);
    if (lhsRangeIndex === lhsRangeIndexCEIL && lhsRangeIndexCEIL < rangeCount)
    {
        var existingRange = self._ranges[lhsRangeIndexCEIL];
        if (aRange.location !== existingRange.location)
        {
            var maxRange = CPMaxRange(aRange),
                existingMaxRange = CPMaxRange(existingRange);
            existingRange.length = aRange.location - existingRange.location;
            if (maxRange < existingMaxRange)
            {
                self._count -= aRange.length;
                ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["insertObject:atIndex:"] || _objj_forward)(___r1, "insertObject:atIndex:", CPMakeRange(maxRange, existingMaxRange - maxRange), lhsRangeIndexCEIL + 1));
                return;
            }
            else
            {
                self._count -= existingMaxRange - aRange.location;
                lhsRangeIndexCEIL += 1;
            }
        }
    }
    var rhsRangeIndex = assumedPositionOfIndex(self._ranges, CPMaxRange(aRange) - 1),
        rhsRangeIndexFLOOR = FLOOR(rhsRangeIndex);
    if (rhsRangeIndex === rhsRangeIndexFLOOR && rhsRangeIndexFLOOR >= 0)
    {
        var maxRange = CPMaxRange(aRange),
            existingRange = self._ranges[rhsRangeIndexFLOOR],
            existingMaxRange = CPMaxRange(existingRange);
        if (maxRange !== existingMaxRange)
        {
            self._count -= maxRange - existingRange.location;
            rhsRangeIndexFLOOR -= 1;
            existingRange.location = maxRange;
            existingRange.length = existingMaxRange - maxRange;
        }
    }
    var removalCount = rhsRangeIndexFLOOR - lhsRangeIndexCEIL + 1;
    if (removalCount > 0)
    {
        var removal = lhsRangeIndexCEIL,
            lastRemoval = lhsRangeIndexCEIL + removalCount - 1;
        for (; removal <= lastRemoval; ++removal)
            self._count -= self._ranges[removal].length;
        ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObjectsInRange:"] || _objj_forward)(___r1, "removeObjectsInRange:", CPMakeRange(lhsRangeIndexCEIL, removalCount)));
    }
    var ___r1;
}
,["void","CPRange"]), new objj_method(sel_getUid("shiftIndexesStartingAtIndex:by:"), function(self, _cmd, anIndex, aDelta)
{
    if (!self._count || aDelta == 0)
        return;
    var i = self._ranges.length - 1,
        shifted = CPMakeRange(CPNotFound, 0);
    for (; i >= 0; --i)
    {
        var range = self._ranges[i],
            maximum = CPMaxRange(range);
        if (anIndex >= maximum)
            break;
        if (anIndex > range.location)
        {
            shifted = CPMakeRange(anIndex + aDelta, maximum - anIndex);
            range.length = anIndex - range.location;
            if (aDelta > 0)
                ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["insertObject:atIndex:"] || _objj_forward)(___r1, "insertObject:atIndex:", shifted, i + 1));
            else if (shifted.location < 0)
            {
                shifted.length = CPMaxRange(shifted);
                shifted.location = 0;
            }
            break;
        }
        if ((range.location += aDelta) < 0)
        {
            self._count -= range.length - CPMaxRange(range);
            range.length = CPMaxRange(range);
            range.location = 0;
        }
    }
    if (aDelta < 0)
    {
        var j = i + 1,
            count = self._ranges.length,
            shifts = [];
        for (; j < count; ++j)
        {
            (shifts == null ? null : (shifts.isa.method_msgSend["addObject:"] || _objj_forward)(shifts, "addObject:", self._ranges[j]));
            self._count -= self._ranges[j].length;
        }
        if ((j = i + 1) < count)
        {
            ((___r1 = self._ranges), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObjectsInRange:"] || _objj_forward)(___r1, "removeObjectsInRange:", CPMakeRange(j, count - j)));
            for ((j = 0, count = shifts.length); j < count; ++j)
                (self.isa.method_msgSend["addIndexesInRange:"] || _objj_forward)(self, "addIndexesInRange:", shifts[j]);
        }
        if (shifted.location != CPNotFound)
            (self.isa.method_msgSend["addIndexesInRange:"] || _objj_forward)(self, "addIndexesInRange:", shifted);
    }
    var ___r1;
}
,["void","CPInteger","int"])]);
}var CPIndexSetCountKey = "CPIndexSetCountKey",
    CPIndexSetRangeStringsKey = "CPIndexSetRangeStringsKey";
{
var the_class = objj_getClass("CPIndexSet")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPIndexSet\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    self = (objj_getClass("CPIndexSet").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._count = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPIndexSetCountKey));
        var rangeStrings = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPIndexSetRangeStringsKey));
        self._ranges = (rangeStrings == null ? null : (rangeStrings.isa.method_msgSend["arrayByApplyingBlock:"] || _objj_forward)(rangeStrings, "arrayByApplyingBlock:", function(range)
        {
            return CPRangeFromString(range);
        }));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._count, CPIndexSetCountKey));
    var index = 0,
        count = self._ranges.length,
        rangeStrings = [];
    for (; index < count; ++index)
        rangeStrings[index] = CPStringFromRange(self._ranges[index]);
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", rangeStrings, CPIndexSetRangeStringsKey));
}
,["void","CPCoder"])]);
}{
var the_class = objj_getClass("CPIndexSet")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPIndexSet\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    return ((___r1 = ((___r2 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r2 == null ? null : (___r2.isa.method_msgSend["alloc"] || _objj_forward)(___r2, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithIndexSet:"] || _objj_forward)(___r1, "initWithIndexSet:", self));
    var ___r1, ___r2;
}
,["id"]), new objj_method(sel_getUid("mutableCopy"), function(self, _cmd)
{
    return ((___r1 = ((___r2 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r2 == null ? null : (___r2.isa.method_msgSend["alloc"] || _objj_forward)(___r2, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithIndexSet:"] || _objj_forward)(___r1, "initWithIndexSet:", self));
    var ___r1, ___r2;
}
,["id"])]);
}{var the_class = objj_allocateClassPair(CPIndexSet, "CPMutableIndexSet"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
}var positionOfIndex = function(ranges, anIndex)
{
    var low = 0,
        high = ranges.length - 1;
    while (low <= high)
    {
        var middle = FLOOR(low + (high - low) / 2),
            range = ranges[middle];
        if (anIndex < range.location)
            high = middle - 1;
        else if (anIndex >= CPMaxRange(range))
            low = middle + 1;
        else
            return middle;
    }
    return CPNotFound;
};
var assumedPositionOfIndex = function(ranges, anIndex)
{
    var count = ranges.length;
    if (count <= 0)
        return CPNotFound;
    var low = 0,
        high = count * 2;
    while (low <= high)
    {
        var middle = FLOOR(low + (high - low) / 2),
            position = middle / 2,
            positionFLOOR = FLOOR(position);
        if (position === positionFLOOR)
        {
            if (positionFLOOR - 1 >= 0 && anIndex < CPMaxRange(ranges[positionFLOOR - 1]))
                high = middle - 1;
            else if (positionFLOOR < count && anIndex >= ranges[positionFLOOR].location)
                low = middle + 1;
            else
                return positionFLOOR - 0.5;
        }
        else
        {
            var range = ranges[positionFLOOR];
            if (anIndex < range.location)
                high = middle - 1;
            else if (anIndex >= CPMaxRange(range))
                low = middle + 1;
            else
                return positionFLOOR;
        }
    }
    return CPNotFound;
};
p;14;CPInvocation.jt;3998;@STATIC;1.0;i;10;CPObject.ji;9;CPArray.jt;3951;objj_executeFile("CPObject.j", YES);objj_executeFile("CPArray.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPInvocation"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_returnValue", "id"), new objj_ivar("_arguments", "CPMutableArray"), new objj_ivar("_methodSignature", "CPMethodSignature")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithMethodSignature:"), function(self, _cmd, aMethodSignature)
{
    self = (objj_getClass("CPInvocation").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._arguments = [];
        self._methodSignature = aMethodSignature;
    }
    return self;
}
,["id","CPMethodSignature"]), new objj_method(sel_getUid("setSelector:"), function(self, _cmd, aSelector)
{
    self._arguments[1] = aSelector;
}
,["void","SEL"]), new objj_method(sel_getUid("selector"), function(self, _cmd)
{
    return self._arguments[1];
}
,["SEL"]), new objj_method(sel_getUid("setTarget:"), function(self, _cmd, aTarget)
{
    self._arguments[0] = aTarget;
}
,["void","id"]), new objj_method(sel_getUid("target"), function(self, _cmd)
{
    return self._arguments[0];
}
,["id"]), new objj_method(sel_getUid("setArgument:atIndex:"), function(self, _cmd, anArgument, anIndex)
{
    self._arguments[anIndex] = anArgument;
}
,["void","id","CPUInteger"]), new objj_method(sel_getUid("argumentAtIndex:"), function(self, _cmd, anIndex)
{
    return self._arguments[anIndex];
}
,["id","CPUInteger"]), new objj_method(sel_getUid("setReturnValue:"), function(self, _cmd, aReturnValue)
{
    self._returnValue = aReturnValue;
}
,["void","id"]), new objj_method(sel_getUid("returnValue"), function(self, _cmd)
{
    return self._returnValue;
}
,["id"]), new objj_method(sel_getUid("invoke"), function(self, _cmd)
{
    self._returnValue = objj_msgSend.apply(objj_msgSend, self._arguments);
}
,["void"]), new objj_method(sel_getUid("invokeWithTarget:"), function(self, _cmd, aTarget)
{
    self._arguments[0] = aTarget;
    self._returnValue = objj_msgSend.apply(objj_msgSend, self._arguments);
}
,["void","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("invocationWithMethodSignature:"), function(self, _cmd, aMethodSignature)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithMethodSignature:"] || _objj_forward)(___r1, "initWithMethodSignature:", aMethodSignature));
    var ___r1;
}
,["id","CPMethodSignature"])]);
}var CPInvocationArguments = "CPInvocationArguments",
    CPInvocationReturnValue = "CPInvocationReturnValue";
{
var the_class = objj_getClass("CPInvocation")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPInvocation\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    self = (objj_getClass("CPInvocation").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._returnValue = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPInvocationReturnValue));
        self._arguments = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPInvocationArguments));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._returnValue, CPInvocationReturnValue));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._arguments, CPInvocationArguments));
}
,["void","CPCoder"])]);
}p;23;CPInvocationOperation.jt;2565;@STATIC;1.0;i;14;CPInvocation.ji;10;CPObject.ji;13;CPOperation.jt;2494;objj_executeFile("CPInvocation.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPOperation.j", YES);{var the_class = objj_allocateClassPair(CPOperation, "CPInvocationOperation"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_invocation", "CPInvocation")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("main"), function(self, _cmd)
{
    if (self._invocation)
    {
        ((___r1 = self._invocation), ___r1 == null ? null : (___r1.isa.method_msgSend["invoke"] || _objj_forward)(___r1, "invoke"));
    }
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    if (self = (objj_getClass("CPInvocationOperation").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._invocation = nil;
    }
    return self;
}
,["id"]), new objj_method(sel_getUid("initWithInvocation:"), function(self, _cmd, inv)
{
    if (self = (self == null ? null : (self.isa.method_msgSend["init"] || _objj_forward)(self, "init")))
    {
        self._invocation = inv;
    }
    return self;
}
,["id","CPInvocation"]), new objj_method(sel_getUid("initWithTarget:selector:object:"), function(self, _cmd, target, sel, arg)
{
    var inv = ((___r1 = (CPInvocation.isa.method_msgSend["alloc"] || _objj_forward)(CPInvocation, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithMethodSignature:"] || _objj_forward)(___r1, "initWithMethodSignature:", nil));
    (inv == null ? null : (inv.isa.method_msgSend["setTarget:"] || _objj_forward)(inv, "setTarget:", target));
    (inv == null ? null : (inv.isa.method_msgSend["setSelector:"] || _objj_forward)(inv, "setSelector:", sel));
    (inv == null ? null : (inv.isa.method_msgSend["setArgument:atIndex:"] || _objj_forward)(inv, "setArgument:atIndex:", arg, 2));
    return (self.isa.method_msgSend["initWithInvocation:"] || _objj_forward)(self, "initWithInvocation:", inv);
    var ___r1;
}
,["id","id","SEL","id"]), new objj_method(sel_getUid("invocation"), function(self, _cmd)
{
    return self._invocation;
}
,["CPInvocation"]), new objj_method(sel_getUid("result"), function(self, _cmd)
{
    if ((self.isa.method_msgSend["isFinished"] || _objj_forward)(self, "isFinished") && self._invocation)
    {
        return ((___r1 = self._invocation), ___r1 == null ? null : (___r1.isa.method_msgSend["returnValue"] || _objj_forward)(___r1, "returnValue"));
    }
    return nil;
    var ___r1;
}
,["id"])]);
}p;19;CPJSONPConnection.jt;7289;@STATIC;1.0;i;13;CPException.ji;10;CPObject.ji;11;CPRunLoop.ji;14;CPURLRequest.jt;7202;objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPRunLoop.j", YES);objj_executeFile("CPURLRequest.j", YES);CPJSONPConnectionCallbacks = {};
CPJSONPCallbackReplacementString = "${JSONP_CALLBACK}";
{var the_class = objj_allocateClassPair(CPObject, "CPJSONPConnection"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_request", "CPURLRequest"), new objj_ivar("_delegate", "id"), new objj_ivar("_callbackParameter", "CPString"), new objj_ivar("_scriptTag", "DOMElement")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithRequest:callback:delegate:"), function(self, _cmd, aRequest, aString, aDelegate)
{
    return (self.isa.method_msgSend["initWithRequest:callback:delegate:startImmediately:"] || _objj_forward)(self, "initWithRequest:callback:delegate:startImmediately:", aRequest, aString, aDelegate, NO);
}
,["id","CPURLRequest","CPString","id"]), new objj_method(sel_getUid("initWithRequest:callback:delegate:startImmediately:"), function(self, _cmd, aRequest, aString, aDelegate, shouldStartImmediately)
{
    self = (objj_getClass("CPJSONPConnection").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._request = aRequest;
        self._delegate = aDelegate;
        self._callbackParameter = aString;
        if (!self._callbackParameter && ((___r1 = ((___r2 = self._request), ___r2 == null ? null : (___r2.isa.method_msgSend["URL"] || _objj_forward)(___r2, "URL"))), ___r1 == null ? null : (___r1.isa.method_msgSend["absoluteString"] || _objj_forward)(___r1, "absoluteString")).indexOf(CPJSONPCallbackReplacementString) < 0)
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "JSONP source specified without callback parameter or CPJSONPCallbackReplacementString in URL.");
        if (shouldStartImmediately)
            (self == null ? null : (self.isa.method_msgSend["start"] || _objj_forward)(self, "start"));
    }
    return self;
    var ___r1, ___r2;
}
,["id","CPURLRequest","CPString","id","BOOL"]), new objj_method(sel_getUid("start"), function(self, _cmd)
{
    try    {
        CPJSONPConnectionCallbacks["callback" + (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID")] = function(data)
        {
            if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("connection:didReceiveData:"))))
                ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["connection:didReceiveData:"] || _objj_forward)(___r1, "connection:didReceiveData:", self, data));
            if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("connectionDidFinishLoading:"))))
                ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["connectionDidFinishLoading:"] || _objj_forward)(___r1, "connectionDidFinishLoading:", self));
            (self.isa.method_msgSend["removeScriptTag"] || _objj_forward)(self, "removeScriptTag");
            ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["limitDateForMode:"] || _objj_forward)(___r1, "limitDateForMode:", CPDefaultRunLoopMode));
            var ___r1;
        };
        var head = (document.getElementsByTagName("head")).item(0),
            source = ((___r1 = ((___r2 = self._request), ___r2 == null ? null : (___r2.isa.method_msgSend["URL"] || _objj_forward)(___r2, "URL"))), ___r1 == null ? null : (___r1.isa.method_msgSend["absoluteString"] || _objj_forward)(___r1, "absoluteString"));
        if (self._callbackParameter)
        {
            source += source.indexOf('?') < 0 ? "?" : "&";
            source += self._callbackParameter + "=CPJSONPConnectionCallbacks.callback" + (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID");
        }
        else if (source.indexOf(CPJSONPCallbackReplacementString) >= 0)
        {
            source = (source == null ? null : (source.isa.method_msgSend["stringByReplacingOccurrencesOfString:withString:"] || _objj_forward)(source, "stringByReplacingOccurrencesOfString:withString:", CPJSONPCallbackReplacementString, "CPJSONPConnectionCallbacks.callback" + (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID")));
        }
        else
            return;
        self._scriptTag = document.createElement("script");
        self._scriptTag.setAttribute("type", "text/javascript");
        self._scriptTag.setAttribute("charset", "utf-8");
        self._scriptTag.setAttribute("src", source);
        head.appendChild(self._scriptTag);
    }
    catch(exception)     {
        if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("connection:didFailWithError:"))))
            ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["connection:didFailWithError:"] || _objj_forward)(___r1, "connection:didFailWithError:", self, exception));
        (self.isa.method_msgSend["removeScriptTag"] || _objj_forward)(self, "removeScriptTag");
        var ___r1;
    }    var ___r1, ___r2;
}
,["void"]), new objj_method(sel_getUid("removeScriptTag"), function(self, _cmd)
{
    var head = (document.getElementsByTagName("head")).item(0);
    if (self._scriptTag && self._scriptTag.parentNode == head)
        head.removeChild(self._scriptTag);
    CPJSONPConnectionCallbacks["callback" + (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID")] = nil;
    delete CPJSONPConnectionCallbacks["callback" + (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID")];
}
,["void"]), new objj_method(sel_getUid("cancel"), function(self, _cmd)
{
    (self.isa.method_msgSend["removeScriptTag"] || _objj_forward)(self, "removeScriptTag");
}
,["void"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("sendRequest:callback:delegate:"), function(self, _cmd, aRequest, callbackParameter, aDelegate)
{
    return (self.isa.method_msgSend["connectionWithRequest:callback:delegate:"] || _objj_forward)(self, "connectionWithRequest:callback:delegate:", aRequest, callbackParameter, aDelegate);
}
,["CPJSONPConnection","CPURLRequest","CPString","id"]), new objj_method(sel_getUid("connectionWithRequest:callback:delegate:"), function(self, _cmd, aRequest, callbackParameter, aDelegate)
{
    return ((___r1 = ((___r2 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r2 == null ? null : (___r2.isa.method_msgSend["alloc"] || _objj_forward)(___r2, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithRequest:callback:delegate:startImmediately:"] || _objj_forward)(___r1, "initWithRequest:callback:delegate:startImmediately:", aRequest, callbackParameter, aDelegate, YES));
    var ___r1, ___r2;
}
,["CPJSONPConnection","CPURLRequest","CPString","id"])]);
}p;17;CPKeyedArchiver.jt;25327;@STATIC;1.0;i;9;CPArray.ji;9;CPCoder.ji;8;CPData.ji;14;CPDictionary.ji;10;CPNumber.ji;10;CPString.ji;9;CPValue.ji;13;_CGGeometry.jt;25189;objj_executeFile("CPArray.j", YES);objj_executeFile("CPCoder.j", YES);objj_executeFile("CPData.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPNumber.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPValue.j", YES);objj_executeFile("_CGGeometry.j", YES);var CPArchiverReplacementClassNames = nil;
var _CPKeyedArchiverDidEncodeObjectSelector = 1,
    _CPKeyedArchiverWillEncodeObjectSelector = 2,
    _CPKeyedArchiverWillReplaceObjectWithObjectSelector = 4,
    _CPKeyedArchiverDidFinishEncodingSelector = 8,
    _CPKeyedArchiverWillFinishEncodingSelector = 16;
var _CPKeyedArchiverNullString = "$null",
    _CPKeyedArchiverNullReference = nil,
    _CPKeyedArchiverUIDKey = "CP$UID",
    _CPKeyedArchiverTopKey = "$top",
    _CPKeyedArchiverObjectsKey = "$objects",
    _CPKeyedArchiverArchiverKey = "$archiver",
    _CPKeyedArchiverVersionKey = "$version",
    _CPKeyedArchiverClassNameKey = "$classname",
    _CPKeyedArchiverClassesKey = "$classes",
    _CPKeyedArchiverClassKey = "$class";
var _CPKeyedArchiverStringClass = Nil,
    _CPKeyedArchiverNumberClass = Nil;
{var the_class = objj_allocateClassPair(CPValue, "_CPKeyedArchiverValue"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
}{var the_class = objj_allocateClassPair(CPCoder, "CPKeyedArchiver"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_delegate", "id"), new objj_ivar("_delegateSelectors", "unsigned"), new objj_ivar("_data", "CPData"), new objj_ivar("_objects", "CPArray"), new objj_ivar("_UIDs", "CPDictionary"), new objj_ivar("_conditionalUIDs", "CPDictionary"), new objj_ivar("_replacementObjects", "CPDictionary"), new objj_ivar("_replacementClassNames", "CPDictionary"), new objj_ivar("_plistObject", "id"), new objj_ivar("_plistObjects", "CPMutableArray"), new objj_ivar("_outputFormat", "CPPropertyListFormat")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initForWritingWithMutableData:"), function(self, _cmd, data)
{
    self = (objj_getClass("CPKeyedArchiver").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._data = data;
        self._objects = [];
        self._UIDs = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._conditionalUIDs = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._replacementObjects = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._plistObject = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._plistObjects = (CPArray.isa.method_msgSend["arrayWithObject:"] || _objj_forward)(CPArray, "arrayWithObject:", _CPKeyedArchiverNullString);
    }
    return self;
    var ___r1;
}
,["id","CPMutableData"]), new objj_method(sel_getUid("finishEncoding"), function(self, _cmd)
{
    if (self._delegate && self._delegateSelectors & _CPKeyedArchiverDidFinishEncodingSelector)
        ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["archiverWillFinish:"] || _objj_forward)(___r1, "archiverWillFinish:", self));
    var i = 0,
        topObject = self._plistObject,
        classes = [];
    for (; i < self._objects.length; ++i)
    {
        var object = self._objects[i];
        self._plistObject = self._plistObjects[((___r1 = self._UIDs), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", (object == null ? null : (object.isa.method_msgSend["UID"] || _objj_forward)(object, "UID"))))];
        (object == null ? null : (object.isa.method_msgSend["encodeWithCoder:"] || _objj_forward)(object, "encodeWithCoder:", self));
        if (self._delegate && self._delegateSelectors & _CPKeyedArchiverDidEncodeObjectSelector)
            ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["archiver:didEncodeObject:"] || _objj_forward)(___r1, "archiver:didEncodeObject:", self, object));
    }
    self._plistObject = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", topObject, _CPKeyedArchiverTopKey));
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", self._plistObjects, _CPKeyedArchiverObjectsKey));
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", (self.isa.method_msgSend["className"] || _objj_forward)(self, "className"), _CPKeyedArchiverArchiverKey));
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", "100000", _CPKeyedArchiverVersionKey));
    ((___r1 = self._data), ___r1 == null ? null : (___r1.isa.method_msgSend["setPlistObject:"] || _objj_forward)(___r1, "setPlistObject:", self._plistObject));
    if (self._delegate && self._delegateSelectors & _CPKeyedArchiverDidFinishEncodingSelector)
        ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["archiverDidFinish:"] || _objj_forward)(___r1, "archiverDidFinish:", self));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("outputFormat"), function(self, _cmd)
{
    return self._outputFormat;
}
,["CPPropertyListFormat"]), new objj_method(sel_getUid("setOutputFormat:"), function(self, _cmd, aPropertyListFormat)
{
    self._outputFormat = aPropertyListFormat;
}
,["void","CPPropertyListFormat"]), new objj_method(sel_getUid("encodeBool:forKey:"), function(self, _cmd, aBOOL, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, aBOOL, NO), aKey));
    var ___r1;
}
,["void","BOOL","CPString"]), new objj_method(sel_getUid("encodeDouble:forKey:"), function(self, _cmd, aDouble, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, aDouble, NO), aKey));
    var ___r1;
}
,["void","double","CPString"]), new objj_method(sel_getUid("encodeFloat:forKey:"), function(self, _cmd, aFloat, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, aFloat, NO), aKey));
    var ___r1;
}
,["void","float","CPString"]), new objj_method(sel_getUid("encodeInt:forKey:"), function(self, _cmd, anInt, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, anInt, NO), aKey));
    var ___r1;
}
,["void","float","CPString"]), new objj_method(sel_getUid("setDelegate:"), function(self, _cmd, aDelegate)
{
    self._delegate = aDelegate;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("archiver:didEncodeObject:"))))
        self._delegateSelectors |= _CPKeyedArchiverDidEncodeObjectSelector;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("archiver:willEncodeObject:"))))
        self._delegateSelectors |= _CPKeyedArchiverWillEncodeObjectSelector;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("archiver:willReplaceObject:withObject:"))))
        self._delegateSelectors |= _CPKeyedArchiverWillReplaceObjectWithObjectSelector;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("archiver:didFinishEncoding:"))))
        self._delegateSelectors |= _CPKeyedArchiverDidFinishEncodingSelector;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("archiver:willFinishEncoding:"))))
        self._delegateSelectors |= _CPKeyedArchiverWillFinishEncodingSelector;
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("delegate"), function(self, _cmd)
{
    return self._delegate;
}
,["id"]), new objj_method(sel_getUid("encodePoint:forKey:"), function(self, _cmd, aPoint, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, CGStringFromPoint(aPoint), NO), aKey));
    var ___r1;
}
,["void","CGPoint","CPString"]), new objj_method(sel_getUid("encodeRect:forKey:"), function(self, _cmd, aRect, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, CGStringFromRect(aRect), NO), aKey));
    var ___r1;
}
,["void","CGRect","CPString"]), new objj_method(sel_getUid("encodeSize:forKey:"), function(self, _cmd, aSize, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, CGStringFromSize(aSize), NO), aKey));
    var ___r1;
}
,["void","CGSize","CPString"]), new objj_method(sel_getUid("encodeConditionalObject:forKey:"), function(self, _cmd, anObject, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, anObject, YES), aKey));
    var ___r1;
}
,["void","id","CPString"]), new objj_method(sel_getUid("encodeNumber:forKey:"), function(self, _cmd, aNumber, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, aNumber, NO), aKey));
    var ___r1;
}
,["void","CPNumber","CPString"]), new objj_method(sel_getUid("encodeObject:forKey:"), function(self, _cmd, anObject, aKey)
{
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, anObject, NO), aKey));
    var ___r1;
}
,["void","id","CPString"]), new objj_method(sel_getUid("_encodeArrayOfObjects:forKey:"), function(self, _cmd, objects, aKey)
{
    var references = (objects == null ? null : (objects.isa.method_msgSend["arrayByApplyingBlock:"] || _objj_forward)(objects, "arrayByApplyingBlock:", function(object)
    {
        return _CPKeyedArchiverEncodeObject(self, object, NO);
    }));
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", references, aKey));
    var ___r1;
}
,["void","CPArray","CPString"]), new objj_method(sel_getUid("_encodeDictionaryOfObjects:forKey:"), function(self, _cmd, aDictionary, aKey)
{
    var key,
        keys = (aDictionary == null ? null : (aDictionary.isa.method_msgSend["keyEnumerator"] || _objj_forward)(aDictionary, "keyEnumerator")),
        references = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    while ((key = (keys == null ? null : (keys.isa.method_msgSend["nextObject"] || _objj_forward)(keys, "nextObject"))) !== nil)
        (references == null ? null : (references.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(references, "setObject:forKey:", _CPKeyedArchiverEncodeObject(self, (aDictionary == null ? null : (aDictionary.isa.method_msgSend["objectForKey:"] || _objj_forward)(aDictionary, "objectForKey:", key)), NO), key));
    ((___r1 = self._plistObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", references, aKey));
    var ___r1;
}
,["void","CPDictionary","CPString"]), new objj_method(sel_getUid("setClassName:forClass:"), function(self, _cmd, aClassName, aClass)
{
    if (!self._replacementClassNames)
        self._replacementClassNames = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    ((___r1 = self._replacementClassNames), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", aClassName, CPStringFromClass(aClass)));
    var ___r1;
}
,["void","CPString","Class"]), new objj_method(sel_getUid("classNameForClass:"), function(self, _cmd, aClass)
{
    if (!self._replacementClassNames)
        return aClass.name;
    var className = ((___r1 = self._replacementClassNames), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPStringFromClass(aClass)));
    return className ? className : aClass.name;
    var ___r1;
}
,["CPString","Class"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("initialize"), function(self, _cmd)
{
    if (self !== (CPKeyedArchiver.isa.method_msgSend["class"] || _objj_forward)(CPKeyedArchiver, "class"))
        return;
    _CPKeyedArchiverStringClass = (CPString.isa.method_msgSend["class"] || _objj_forward)(CPString, "class");
    _CPKeyedArchiverNumberClass = (CPNumber.isa.method_msgSend["class"] || _objj_forward)(CPNumber, "class");
    _CPKeyedArchiverNullReference = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [0], [_CPKeyedArchiverUIDKey]));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("allowsKeyedCoding"), function(self, _cmd)
{
    return YES;
}
,["BOOL"]), new objj_method(sel_getUid("archivedDataWithRootObject:"), function(self, _cmd, anObject)
{
    var data = (CPData.isa.method_msgSend["dataWithPlistObject:"] || _objj_forward)(CPData, "dataWithPlistObject:", nil),
        archiver = ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initForWritingWithMutableData:"] || _objj_forward)(___r1, "initForWritingWithMutableData:", data));
    (archiver == null ? null : (archiver.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(archiver, "encodeObject:forKey:", anObject, "root"));
    (archiver == null ? null : (archiver.isa.method_msgSend["finishEncoding"] || _objj_forward)(archiver, "finishEncoding"));
    return data;
    var ___r1;
}
,["CPData","id"]), new objj_method(sel_getUid("setClassName:forClass:"), function(self, _cmd, aClassName, aClass)
{
    if (!CPArchiverReplacementClassNames)
        CPArchiverReplacementClassNames = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    (CPArchiverReplacementClassNames == null ? null : (CPArchiverReplacementClassNames.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(CPArchiverReplacementClassNames, "setObject:forKey:", aClassName, CPStringFromClass(aClass)));
    var ___r1;
}
,["void","CPString","Class"]), new objj_method(sel_getUid("classNameForClass:"), function(self, _cmd, aClass)
{
    if (!CPArchiverReplacementClassNames)
        return aClass.name;
    var className = (CPArchiverReplacementClassNames == null ? null : (CPArchiverReplacementClassNames.isa.method_msgSend["objectForKey:"] || _objj_forward)(CPArchiverReplacementClassNames, "objectForKey:", CPStringFromClass(aClass)));
    return className ? className : aClass.name;
}
,["CPString","Class"])]);
}var _CPKeyedArchiverEncodeObject = function(self, anObject, isConditional)
{
    if (anObject !== nil && anObject !== undefined && !anObject.isa)
        anObject = (_CPKeyedArchiverValue.isa.method_msgSend["valueWithJSObject:"] || _objj_forward)(_CPKeyedArchiverValue, "valueWithJSObject:", anObject);
    var GUID = (anObject == null ? null : (anObject.isa.method_msgSend["UID"] || _objj_forward)(anObject, "UID")),
        object = ((___r1 = self._replacementObjects), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", GUID));
    if (object === nil)
    {
        object = (anObject == null ? null : (anObject.isa.method_msgSend["replacementObjectForKeyedArchiver:"] || _objj_forward)(anObject, "replacementObjectForKeyedArchiver:", self));
        if (self._delegate)
        {
            if (object !== anObject && self._delegateSelectors & _CPKeyedArchiverWillReplaceObjectWithObjectSelector)
                ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["archiver:willReplaceObject:withObject:"] || _objj_forward)(___r1, "archiver:willReplaceObject:withObject:", self, anObject, object));
            if (self._delegateSelectors & _CPKeyedArchiverWillEncodeObjectSelector)
            {
                anObject = ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["archiver:willEncodeObject:"] || _objj_forward)(___r1, "archiver:willEncodeObject:", self, object));
                if (anObject !== object && self._delegateSelectors & _CPKeyedArchiverWillReplaceObjectWithObjectSelector)
                    ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["archiver:willReplaceObject:withObject:"] || _objj_forward)(___r1, "archiver:willReplaceObject:withObject:", self, object, anObject));
                object = anObject;
            }
        }
        if (object != nil && GUID != nil)
            ((___r1 = self._replacementObjects), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", object, GUID));
    }
    if (object === nil)
        return _CPKeyedArchiverNullReference;
    var UID = ((___r1 = self._UIDs), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", GUID = (object == null ? null : (object.isa.method_msgSend["UID"] || _objj_forward)(object, "UID"))));
    if (UID === nil)
    {
        if (isConditional)
        {
            if ((UID = ((___r1 = self._conditionalUIDs), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", GUID))) === nil)
            {
                ((___r1 = self._conditionalUIDs), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", UID = ((___r2 = self._plistObjects), ___r2 == null ? null : (___r2.isa.method_msgSend["count"] || _objj_forward)(___r2, "count")), GUID));
                ((___r1 = self._plistObjects), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", _CPKeyedArchiverNullString));
            }
        }
        else
        {
            var theClass = (object == null ? null : (object.isa.method_msgSend["classForKeyedArchiver"] || _objj_forward)(object, "classForKeyedArchiver")),
                plistObject = nil;
            if (theClass === _CPKeyedArchiverStringClass || theClass === _CPKeyedArchiverNumberClass)
                plistObject = object;
            else
            {
                plistObject = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
                ((___r1 = self._objects), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", object));
                var className = (self == null ? null : (self.isa.method_msgSend["classNameForClass:"] || _objj_forward)(self, "classNameForClass:", theClass));
                if (!className)
                    className = ((___r1 = (self == null ? null : (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"))), ___r1 == null ? null : (___r1.isa.method_msgSend["classNameForClass:"] || _objj_forward)(___r1, "classNameForClass:", theClass));
                if (!className)
                    className = theClass.name;
                else
                    theClass = CPClassFromString(className);
                var classUID = ((___r1 = self._UIDs), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", className));
                if (!classUID)
                {
                    var plistClass = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init")),
                        hierarchy = [];
                    (plistClass == null ? null : (plistClass.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(plistClass, "setObject:forKey:", className, _CPKeyedArchiverClassNameKey));
                    do
                    {
                        (hierarchy == null ? null : (hierarchy.isa.method_msgSend["addObject:"] || _objj_forward)(hierarchy, "addObject:", CPStringFromClass(theClass)));
                    }
                    while (theClass = (theClass == null ? null : (theClass.isa.method_msgSend["superclass"] || _objj_forward)(theClass, "superclass")));
                    (plistClass == null ? null : (plistClass.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(plistClass, "setObject:forKey:", hierarchy, _CPKeyedArchiverClassesKey));
                    classUID = ((___r1 = self._plistObjects), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
                    ((___r1 = self._plistObjects), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", plistClass));
                    ((___r1 = self._UIDs), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", classUID, className));
                }
                (plistObject == null ? null : (plistObject.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(plistObject, "setObject:forKey:", (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [classUID], [_CPKeyedArchiverUIDKey])), _CPKeyedArchiverClassKey));
            }
            UID = ((___r1 = self._conditionalUIDs), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", GUID));
            if (UID !== nil)
            {
                ((___r1 = self._UIDs), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", UID, GUID));
                ((___r1 = self._plistObjects), ___r1 == null ? null : (___r1.isa.method_msgSend["replaceObjectAtIndex:withObject:"] || _objj_forward)(___r1, "replaceObjectAtIndex:withObject:", UID, plistObject));
            }
            else
            {
                ((___r1 = self._UIDs), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", UID = ((___r2 = self._plistObjects), ___r2 == null ? null : (___r2.isa.method_msgSend["count"] || _objj_forward)(___r2, "count")), GUID));
                ((___r1 = self._plistObjects), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", plistObject));
            }
        }
    }
    return (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [UID], [_CPKeyedArchiverUIDKey]));
    var ___r1, ___r2;
};
p;19;CPKeyedUnarchiver.jt;17540;@STATIC;1.0;i;9;CPArray.ji;9;CPCoder.ji;8;CPData.ji;14;CPDictionary.ji;13;CPException.ji;17;CPKeyedArchiver.ji;8;CPNull.ji;10;CPNumber.ji;10;CPString.jt;17381;objj_executeFile("CPArray.j", YES);objj_executeFile("CPCoder.j", YES);objj_executeFile("CPData.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPKeyedArchiver.j", YES);objj_executeFile("CPNull.j", YES);objj_executeFile("CPNumber.j", YES);objj_executeFile("CPString.j", YES);CPInvalidUnarchiveOperationException = "CPInvalidUnarchiveOperationException";
var _CPKeyedUnarchiverCannotDecodeObjectOfClassNameOriginalClassesSelector = 1 << 0,
    _CPKeyedUnarchiverDidDecodeObjectSelector = 1 << 1,
    _CPKeyedUnarchiverWillReplaceObjectWithObjectSelector = 1 << 2,
    _CPKeyedUnarchiverWillFinishSelector = 1 << 3,
    _CPKeyedUnarchiverDidFinishSelector = 1 << 4,
    CPKeyedUnarchiverDelegate_unarchiver_cannotDecodeObjectOfClassName_originalClasses_ = 1 << 5;
var _CPKeyedArchiverNullString = "$null",
    _CPKeyedArchiverUIDKey = "CP$UID",
    _CPKeyedArchiverTopKey = "$top",
    _CPKeyedArchiverObjectsKey = "$objects",
    _CPKeyedArchiverArchiverKey = "$archiver",
    _CPKeyedArchiverVersionKey = "$version",
    _CPKeyedArchiverClassNameKey = "$classname",
    _CPKeyedArchiverClassesKey = "$classes",
    _CPKeyedArchiverClassKey = "$class";
var CPArrayClass = Nil,
    CPMutableArrayClass = Nil,
    CPStringClass = Nil,
    CPDictionaryClass = Nil,
    CPMutableDictionaryClass = Nil,
    CPNumberClass = Nil,
    CPDataClass = Nil,
    _CPKeyedArchiverValueClass = Nil;
{var the_class = objj_allocateClassPair(CPCoder, "CPKeyedUnarchiver"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_delegate", "id"), new objj_ivar("_delegateSelectors", "unsigned"), new objj_ivar("_data", "CPData"), new objj_ivar("_replacementClasses", "CPDictionary"), new objj_ivar("_objects", "CPArray"), new objj_ivar("_archive", "CPDictionary"), new objj_ivar("_plistObject", "CPDictionary"), new objj_ivar("_plistObjects", "CPArray")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initForReadingWithData:"), function(self, _cmd, data)
{
    self = (objj_getClass("CPKeyedUnarchiver").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._archive = (data == null ? null : (data.isa.method_msgSend["plistObject"] || _objj_forward)(data, "plistObject"));
        self._objects = [(CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null")];
        self._plistObject = ((___r1 = self._archive), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", _CPKeyedArchiverTopKey));
        self._plistObjects = ((___r1 = self._archive), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", _CPKeyedArchiverObjectsKey));
        self._replacementClasses = new CFMutableDictionary();
    }
    return self;
    var ___r1;
}
,["id","CPData"]), new objj_method(sel_getUid("containsValueForKey:"), function(self, _cmd, aKey)
{
    return self._plistObject.valueForKey(aKey) != nil;
}
,["BOOL","CPString"]), new objj_method(sel_getUid("_decodeDictionaryOfObjectsForKey:"), function(self, _cmd, aKey)
{
    var object = self._plistObject.valueForKey(aKey),
        objectClass = object != nil && object.isa;
    if (objectClass === CPDictionaryClass || objectClass === CPMutableDictionaryClass)
    {
        var keys = object.keys(),
            index = 0,
            count = keys.length,
            dictionary = new CFMutableDictionary();
        for (; index < count; ++index)
        {
            var key = keys[index];
            dictionary.setValueForKey(key, _CPKeyedUnarchiverDecodeObjectAtIndex(self, (object.valueForKey(key)).valueForKey(_CPKeyedArchiverUIDKey)));
        }
        return dictionary;
    }
    return nil;
}
,["CPDictionary","CPString"]), new objj_method(sel_getUid("decodeBoolForKey:"), function(self, _cmd, aKey)
{
    return !!(self.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(self, "decodeObjectForKey:", aKey);
}
,["BOOL","CPString"]), new objj_method(sel_getUid("decodeFloatForKey:"), function(self, _cmd, aKey)
{
    var f = (self.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(self, "decodeObjectForKey:", aKey);
    return f === nil ? 0.0 : f;
}
,["float","CPString"]), new objj_method(sel_getUid("decodeDoubleForKey:"), function(self, _cmd, aKey)
{
    var d = (self.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(self, "decodeObjectForKey:", aKey);
    return d === nil ? 0.0 : d;
}
,["double","CPString"]), new objj_method(sel_getUid("decodeIntForKey:"), function(self, _cmd, aKey)
{
    var i = (self.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(self, "decodeObjectForKey:", aKey);
    return i === nil ? 0 : i;
}
,["int","CPString"]), new objj_method(sel_getUid("decodePointForKey:"), function(self, _cmd, aKey)
{
    var object = (self.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(self, "decodeObjectForKey:", aKey);
    if (object)
        return CGPointFromString(object);
    else
        return CGPointMakeZero();
}
,["CGPoint","CPString"]), new objj_method(sel_getUid("decodeRectForKey:"), function(self, _cmd, aKey)
{
    var object = (self.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(self, "decodeObjectForKey:", aKey);
    if (object)
        return CGRectFromString(object);
    else
        return CGRectMakeZero();
}
,["CGRect","CPString"]), new objj_method(sel_getUid("decodeSizeForKey:"), function(self, _cmd, aKey)
{
    var object = (self.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(self, "decodeObjectForKey:", aKey);
    if (object)
        return CGSizeFromString(object);
    else
        return CGSizeMakeZero();
}
,["CGSize","CPString"]), new objj_method(sel_getUid("decodeObjectForKey:"), function(self, _cmd, aKey)
{
    var object = self._plistObject && self._plistObject.valueForKey(aKey),
        objectClass = object != nil && object.isa;
    if (objectClass === CPDictionaryClass || objectClass === CPMutableDictionaryClass)
        return _CPKeyedUnarchiverDecodeObjectAtIndex(self, object.valueForKey(_CPKeyedArchiverUIDKey));
    else if (objectClass === CPNumberClass || objectClass === CPDataClass || objectClass === CPStringClass)
        return object;
    else if (objectClass === _CPJavaScriptArray)
    {
        var index = 0,
            count = object.length,
            array = [];
        for (; index < count; ++index)
            array[index] = _CPKeyedUnarchiverDecodeObjectAtIndex(self, object[index].valueForKey(_CPKeyedArchiverUIDKey));
        return array;
    }
    return nil;
}
,["id","CPString"]), new objj_method(sel_getUid("decodeBytesForKey:"), function(self, _cmd, aKey)
{
    var data = (self.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(self, "decodeObjectForKey:", aKey);
    if (!data)
        return nil;
    var objectClass = data.isa;
    if (objectClass === CPDataClass)
        return data.bytes();
    return nil;
}
,["id","CPString"]), new objj_method(sel_getUid("finishDecoding"), function(self, _cmd)
{
    if (self._delegateSelectors & _CPKeyedUnarchiverWillFinishSelector)
        ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["unarchiverWillFinish:"] || _objj_forward)(___r1, "unarchiverWillFinish:", self));
    if (self._delegateSelectors & _CPKeyedUnarchiverDidFinishSelector)
        ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["unarchiverDidFinish:"] || _objj_forward)(___r1, "unarchiverDidFinish:", self));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("delegate"), function(self, _cmd)
{
    return self._delegate;
}
,["id"]), new objj_method(sel_getUid("setDelegate:"), function(self, _cmd, aDelegate)
{
    self._delegate = aDelegate;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("unarchiver:cannotDecodeObjectOfClassName:originalClasses:"))))
        self._delegateSelectors |= _CPKeyedUnarchiverCannotDecodeObjectOfClassNameOriginalClassesSelector;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("unarchiver:didDecodeObject:"))))
        self._delegateSelectors |= _CPKeyedUnarchiverDidDecodeObjectSelector;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("unarchiver:willReplaceObject:withObject:"))))
        self._delegateSelectors |= _CPKeyedUnarchiverWillReplaceObjectWithObjectSelector;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("unarchiverWillFinish:"))))
        self._delegateSelectors |= _CPKeyedUnarchiverWillFinishSelector;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("unarchiverDidFinish:"))))
        self._delegateSelectors |= _CPKeyedUnarchiverDidFinishSelector;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("unarchiver:cannotDecodeObjectOfClassName:originalClasses:"))))
        self._delegateSelectors |= CPKeyedUnarchiverDelegate_unarchiver_cannotDecodeObjectOfClassName_originalClasses_;
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("setClass:forClassName:"), function(self, _cmd, aClass, aClassName)
{
    self._replacementClasses.setValueForKey(aClassName, aClass);
}
,["void","Class","CPString"]), new objj_method(sel_getUid("classForClassName:"), function(self, _cmd, aClassName)
{
    return self._replacementClasses.valueForKey(aClassName);
}
,["Class","CPString"]), new objj_method(sel_getUid("allowsKeyedCoding"), function(self, _cmd)
{
    return YES;
}
,["BOOL"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("initialize"), function(self, _cmd)
{
    if (self !== (CPKeyedUnarchiver.isa.method_msgSend["class"] || _objj_forward)(CPKeyedUnarchiver, "class"))
        return;
    CPArrayClass = (CPArray.isa.method_msgSend["class"] || _objj_forward)(CPArray, "class");
    CPMutableArrayClass = (CPMutableArray.isa.method_msgSend["class"] || _objj_forward)(CPMutableArray, "class");
    CPStringClass = (CPString.isa.method_msgSend["class"] || _objj_forward)(CPString, "class");
    CPDictionaryClass = (CPDictionary.isa.method_msgSend["class"] || _objj_forward)(CPDictionary, "class");
    CPMutableDictionaryClass = (CPMutableDictionary.isa.method_msgSend["class"] || _objj_forward)(CPMutableDictionary, "class");
    CPNumberClass = (CPNumber.isa.method_msgSend["class"] || _objj_forward)(CPNumber, "class");
    CPDataClass = (CPData.isa.method_msgSend["class"] || _objj_forward)(CPData, "class");
    _CPKeyedArchiverValueClass = (_CPKeyedArchiverValue.isa.method_msgSend["class"] || _objj_forward)(_CPKeyedArchiverValue, "class");
}
,["void"]), new objj_method(sel_getUid("unarchiveObjectWithData:"), function(self, _cmd, aData)
{
    if (!aData)
    {
        CPLog.error("Null data passed to -[CPKeyedUnarchiver unarchiveObjectWithData:].");
        return nil;
    }
    var unarchiver = ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initForReadingWithData:"] || _objj_forward)(___r1, "initForReadingWithData:", aData)),
        object = (unarchiver == null ? null : (unarchiver.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(unarchiver, "decodeObjectForKey:", "root"));
    (unarchiver == null ? null : (unarchiver.isa.method_msgSend["finishDecoding"] || _objj_forward)(unarchiver, "finishDecoding"));
    return object;
    var ___r1;
}
,["id","CPData"]), new objj_method(sel_getUid("unarchiveObjectWithFile:"), function(self, _cmd, aFilePath)
{
}
,["id","CPString"]), new objj_method(sel_getUid("unarchiveObjectWithFile:asynchronously:"), function(self, _cmd, aFilePath, aFlag)
{
}
,["id","CPString","BOOL"])]);
}var _CPKeyedUnarchiverDecodeObjectAtIndex = function(self, anIndex)
{
    var object = self._objects[anIndex];
    if (object)
    {
        if (object === self._objects[0])
            return nil;
    }
    else
    {
        var plistObject = self._plistObjects[anIndex],
            plistObjectClass = plistObject.isa;
        if (plistObjectClass === CPDictionaryClass || plistObjectClass === CPMutableDictionaryClass)
        {
            var plistClass = self._plistObjects[(plistObject.valueForKey(_CPKeyedArchiverClassKey)).valueForKey(_CPKeyedArchiverUIDKey)],
                className = plistClass.valueForKey(_CPKeyedArchiverClassNameKey),
                classes = plistClass.valueForKey(_CPKeyedArchiverClassesKey),
                theClass = (self == null ? null : (self.isa.method_msgSend["classForClassName:"] || _objj_forward)(self, "classForClassName:", className));
            if (!theClass)
                theClass = CPClassFromString(className);
            if (!theClass && self._delegateSelectors & CPKeyedUnarchiverDelegate_unarchiver_cannotDecodeObjectOfClassName_originalClasses_)
            {
                theClass = ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["unarchiver:cannotDecodeObjectOfClassName:originalClasses:"] || _objj_forward)(___r1, "unarchiver:cannotDecodeObjectOfClassName:originalClasses:", self, className, classes));
            }
            if (!theClass)
                (CPException.isa.method_msgSend["raise:format:"] || _objj_forward)(CPException, "raise:format:", CPInvalidUnarchiveOperationException, "-[CPKeyedUnarchiver decodeObjectForKey:]: cannot decode object of class (%@)", className);
            var savedPlistObject = self._plistObject;
            self._plistObject = plistObject;
            object = (theClass == null ? null : (theClass.isa.method_msgSend["allocWithCoder:"] || _objj_forward)(theClass, "allocWithCoder:", self));
            self._objects[anIndex] = object;
            var processedObject = (object == null ? null : (object.isa.method_msgSend["initWithCoder:"] || _objj_forward)(object, "initWithCoder:", self));
            self._plistObject = savedPlistObject;
            if (processedObject !== object)
            {
                if (self._delegateSelectors & _CPKeyedUnarchiverWillReplaceObjectWithObjectSelector)
                    ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["unarchiver:willReplaceObject:withObject:"] || _objj_forward)(___r1, "unarchiver:willReplaceObject:withObject:", self, object, processedObject));
                object = processedObject;
                self._objects[anIndex] = processedObject;
            }
            processedObject = (object == null ? null : (object.isa.method_msgSend["awakeAfterUsingCoder:"] || _objj_forward)(object, "awakeAfterUsingCoder:", self));
            if (processedObject !== object)
            {
                if (self._delegateSelectors & _CPKeyedUnarchiverWillReplaceObjectWithObjectSelector)
                    ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["unarchiver:willReplaceObject:withObject:"] || _objj_forward)(___r1, "unarchiver:willReplaceObject:withObject:", self, object, processedObject));
                object = processedObject;
                self._objects[anIndex] = processedObject;
            }
            if (self._delegate)
            {
                if (self._delegateSelectors & _CPKeyedUnarchiverDidDecodeObjectSelector)
                    processedObject = ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["unarchiver:didDecodeObject:"] || _objj_forward)(___r1, "unarchiver:didDecodeObject:", self, object));
                if (processedObject && processedObject != object)
                {
                    if (self._delegateSelectors & _CPKeyedUnarchiverWillReplaceObjectWithObjectSelector)
                        ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["unarchiver:willReplaceObject:withObject:"] || _objj_forward)(___r1, "unarchiver:willReplaceObject:withObject:", self, object, processedObject));
                    object = processedObject;
                    self._objects[anIndex] = processedObject;
                }
            }
        }
        else
        {
            self._objects[anIndex] = object = plistObject;
            if ((object == null ? null : (object.isa.method_msgSend["class"] || _objj_forward)(object, "class")) === CPStringClass)
            {
                if (object === _CPKeyedArchiverNullString)
                {
                    self._objects[anIndex] = self._objects[0];
                    return nil;
                }
                else
                    self._objects[anIndex] = object = plistObject;
            }
        }
    }
    if (object != nil && object.isa === _CPKeyedArchiverValueClass)
        object = (object == null ? null : (object.isa.method_msgSend["JSObject"] || _objj_forward)(object, "JSObject"));
    return object;
    var ___r1;
};
p;18;CPKeyValueCoding.jt;20208;@STATIC;1.0;i;9;CPArray.ji;14;CPDictionary.ji;13;CPException.ji;12;CPIndexSet.ji;8;CPNull.ji;10;CPObject.ji;7;CPSet.ji;21;CPKeyValueObserving.jt;20057;objj_executeFile("CPArray.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPIndexSet.j", YES);objj_executeFile("CPNull.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPSet.j", YES);CPUndefinedKeyException = "CPUndefinedKeyException";
CPTargetObjectUserInfoKey = "CPTargetObjectUserInfoKey";
CPUnknownUserInfoKey = "CPUnknownUserInfoKey";
var CPObjectAccessorsForClassKey = "$CPObjectAccessorsForClassKey",
    CPObjectModifiersForClassKey = "$CPObjectModifiersForClassKey";
{
var the_class = objj_getClass("CPObject")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPObject\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("valueForKey:"), function(self, _cmd, aKey)
{
    var theClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        accessor = nil,
        accessors = theClass[CPObjectAccessorsForClassKey];
    if (!accessors)
        accessors = theClass[CPObjectAccessorsForClassKey] = {};
    if (accessors.hasOwnProperty(aKey))
        accessor = accessors[aKey];
    else
    {
        var string = nil,
            capitalizedKey = (aKey.charAt(0)).toUpperCase() + aKey.substr(1),
            underscoreKey = nil,
            isKey = nil;
        if ((theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", string = sel_getUid("get" + capitalizedKey))) || (theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", string = sel_getUid(aKey))) || (theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", string = sel_getUid(isKey = "is" + capitalizedKey))) || (theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", string = sel_getUid("_get" + capitalizedKey))) || (theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", string = sel_getUid(underscoreKey = "_" + aKey))) || (theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", string = sel_getUid("_" + isKey))))
            accessor = accessors[aKey] = [0, string];
        else if ((theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", sel_getUid("countOf" + capitalizedKey))))
        {
            if ((theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", sel_getUid("objectIn" + capitalizedKey + "AtIndex:"))) || (theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", sel_getUid(aKey + "AtIndexes:"))))
                accessor = accessors[aKey] = [1];
            else if ((theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", sel_getUid("enumeratorOf" + capitalizedKey))) && (theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", sel_getUid("memberOf" + capitalizedKey + ":"))))
                accessor = accessors[aKey] = [2];
        }
        if (!accessor)
        {
            if (class_getInstanceVariable(theClass, string = underscoreKey) || class_getInstanceVariable(theClass, string = "_" + isKey) || class_getInstanceVariable(theClass, string = aKey) || class_getInstanceVariable(theClass, string = isKey))
                accessor = accessors[aKey] = [3, string];
            else
                accessor = accessors[aKey] = [];
        }
    }
    switch(accessor[0]) {
    case 0:
        return self.isa.objj_msgSend0(self, accessor[1]);
    case 1:
        return ((___r1 = (_CPKeyValueCodingArray == null ? null : (_CPKeyValueCodingArray.isa.method_msgSend["alloc"] || _objj_forward)(_CPKeyValueCodingArray, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithTarget:key:"] || _objj_forward)(___r1, "initWithTarget:key:", self, aKey));
    case 2:
        return ((___r1 = (_CPKeyValueCodingSet == null ? null : (_CPKeyValueCodingSet.isa.method_msgSend["alloc"] || _objj_forward)(_CPKeyValueCodingSet, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithTarget:key:"] || _objj_forward)(___r1, "initWithTarget:key:", self, aKey));
    case 3:
        if ((theClass == null ? null : (theClass.isa.method_msgSend["accessInstanceVariablesDirectly"] || _objj_forward)(theClass, "accessInstanceVariablesDirectly")))
            return self[accessor[1]];
    }
    return (self.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(self, "valueForUndefinedKey:", aKey);
    var ___r1;
}
,["id","CPString"]), new objj_method(sel_getUid("valueForKeyPath:"), function(self, _cmd, aKeyPath)
{
    var firstDotIndex = aKeyPath.indexOf(".");
    if (firstDotIndex === CPNotFound)
        return (self.isa.method_msgSend["valueForKey:"] || _objj_forward)(self, "valueForKey:", aKeyPath);
    var firstKeyComponent = aKeyPath.substring(0, firstDotIndex),
        remainingKeyPath = aKeyPath.substring(firstDotIndex + 1),
        value = (self.isa.method_msgSend["valueForKey:"] || _objj_forward)(self, "valueForKey:", firstKeyComponent);
    return (value == null ? null : (value.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(value, "valueForKeyPath:", remainingKeyPath));
}
,["id","CPString"]), new objj_method(sel_getUid("dictionaryWithValuesForKeys:"), function(self, _cmd, keys)
{
    var index = 0,
        count = keys.length,
        dictionary = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    for (; index < count; ++index)
    {
        var key = keys[index],
            value = (self.isa.method_msgSend["valueForKey:"] || _objj_forward)(self, "valueForKey:", key);
        if (value === nil)
            (dictionary == null ? null : (dictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(dictionary, "setObject:forKey:", (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null"), key));
        else
            (dictionary == null ? null : (dictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(dictionary, "setObject:forKey:", value, key));
    }
    return dictionary;
    var ___r1;
}
,["CPDictionary","CPArray"]), new objj_method(sel_getUid("valueForUndefinedKey:"), function(self, _cmd, aKey)
{
    ((___r1 = (CPException.isa.method_msgSend["exceptionWithName:reason:userInfo:"] || _objj_forward)(CPException, "exceptionWithName:reason:userInfo:", CPUndefinedKeyException, (self.isa.method_msgSend["_objectDescription"] || _objj_forward)(self, "_objectDescription") + " is not key value coding-compliant for the key " + aKey, (___r2 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r2 == null ? null : (___r2.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r2, "initWithObjects:forKeys:", [self, aKey], [CPTargetObjectUserInfoKey, CPUnknownUserInfoKey])))), ___r1 == null ? null : (___r1.isa.method_msgSend["raise"] || _objj_forward)(___r1, "raise"));
    var ___r1, ___r2;
}
,["id","CPString"]), new objj_method(sel_getUid("setValue:forKeyPath:"), function(self, _cmd, aValue, aKeyPath)
{
    if (!aKeyPath)
        aKeyPath = "self";
    var firstDotIndex = aKeyPath.indexOf(".");
    if (firstDotIndex === CPNotFound)
        return (self.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(self, "setValue:forKey:", aValue, aKeyPath);
    var firstKeyComponent = aKeyPath.substring(0, firstDotIndex),
        remainingKeyPath = aKeyPath.substring(firstDotIndex + 1),
        value = (self.isa.method_msgSend["valueForKey:"] || _objj_forward)(self, "valueForKey:", firstKeyComponent);
    return (value == null ? null : (value.isa.method_msgSend["setValue:forKeyPath:"] || _objj_forward)(value, "setValue:forKeyPath:", aValue, remainingKeyPath));
}
,["void","id","CPString"]), new objj_method(sel_getUid("setValue:forKey:"), function(self, _cmd, aValue, aKey)
{
    if (aValue && aValue.isa && (aValue == null ? null : (aValue.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(aValue, "isKindOfClass:", CPValue)))
        aValue = (aValue == null ? null : (aValue.isa.method_msgSend["JSObject"] || _objj_forward)(aValue, "JSObject"));
    var theClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        modifier = nil,
        modifiers = theClass[CPObjectModifiersForClassKey];
    if (!modifiers)
        modifiers = theClass[CPObjectModifiersForClassKey] = {};
    if (modifiers.hasOwnProperty(aKey))
        modifier = modifiers[aKey];
    else
    {
        var string = nil,
            capitalizedKey = (aKey.charAt(0)).toUpperCase() + aKey.substr(1),
            isKey = nil;
        if ((theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", string = sel_getUid("set" + capitalizedKey + ":"))) || (theClass == null ? null : (theClass.isa.method_msgSend["instancesRespondToSelector:"] || _objj_forward)(theClass, "instancesRespondToSelector:", string = sel_getUid("_set" + capitalizedKey + ":"))))
            modifier = modifiers[aKey] = [0, string];
        else if (class_getInstanceVariable(theClass, string = "_" + aKey) || class_getInstanceVariable(theClass, string = "_" + (isKey = "is" + capitalizedKey)) || class_getInstanceVariable(theClass, string = aKey) || class_getInstanceVariable(theClass, string = isKey))
            modifier = modifiers[aKey] = [1, string];
        else
            modifier = modifiers[aKey] = [];
    }
    switch(modifier[0]) {
    case 0:
        return self.isa.objj_msgSend1(self, modifier[1], aValue);
    case 1:
        if ((theClass == null ? null : (theClass.isa.method_msgSend["accessInstanceVariablesDirectly"] || _objj_forward)(theClass, "accessInstanceVariablesDirectly")))
        {
            (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", aKey);
            self[modifier[1]] = aValue;
            return (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", aKey);
        }
    }
    return (self.isa.method_msgSend["setValue:forUndefinedKey:"] || _objj_forward)(self, "setValue:forUndefinedKey:", aValue, aKey);
}
,["void","id","CPString"]), new objj_method(sel_getUid("setValuesForKeysWithDictionary:"), function(self, _cmd, keyedValues)
{
    var value,
        key,
        keyEnumerator = (keyedValues == null ? null : (keyedValues.isa.method_msgSend["keyEnumerator"] || _objj_forward)(keyedValues, "keyEnumerator"));
    while ((key = (keyEnumerator == null ? null : (keyEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(keyEnumerator, "nextObject"))) !== nil)
    {
        value = (keyedValues == null ? null : (keyedValues.isa.method_msgSend["objectForKey:"] || _objj_forward)(keyedValues, "objectForKey:", key));
        if (value === (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null"))
            (self.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(self, "setValue:forKey:", nil, key);
        else
            (self.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(self, "setValue:forKey:", value, key);
    }
}
,["void","CPDictionary"]), new objj_method(sel_getUid("setValue:forUndefinedKey:"), function(self, _cmd, aValue, aKey)
{
    ((___r1 = (CPException.isa.method_msgSend["exceptionWithName:reason:userInfo:"] || _objj_forward)(CPException, "exceptionWithName:reason:userInfo:", CPUndefinedKeyException, (self.isa.method_msgSend["_objectDescription"] || _objj_forward)(self, "_objectDescription") + " is not key value coding-compliant for the key " + aKey, (___r2 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r2 == null ? null : (___r2.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r2, "initWithObjects:forKeys:", [self, aKey], [CPTargetObjectUserInfoKey, CPUnknownUserInfoKey])))), ___r1 == null ? null : (___r1.isa.method_msgSend["raise"] || _objj_forward)(___r1, "raise"));
    var ___r1, ___r2;
}
,["void","id","CPString"]), new objj_method(sel_getUid("_objectDescription"), function(self, _cmd)
{
    return "<" + (self.isa.method_msgSend["className"] || _objj_forward)(self, "className") + " 0x" + (CPString.isa.method_msgSend["stringWithHash:"] || _objj_forward)(CPString, "stringWithHash:", (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID")) + ">";
}
,["CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("accessInstanceVariablesDirectly"), function(self, _cmd)
{
    return YES;
}
,["BOOL"])]);
}{
var the_class = objj_getClass("CPDictionary")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPDictionary\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("valueForKey:"), function(self, _cmd, aKey)
{
    if ((aKey == null ? null : (aKey.isa.method_msgSend["hasPrefix:"] || _objj_forward)(aKey, "hasPrefix:", "@")))
        return (objj_getClass("CPDictionary").super_class.method_dtable["valueForKey:"] || _objj_forward)(self, "valueForKey:", aKey.substr(1));
    return (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
}
,["id","CPString"]), new objj_method(sel_getUid("setValue:forKey:"), function(self, _cmd, aValue, aKey)
{
    if (aValue !== nil)
        (self.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(self, "setObject:forKey:", aValue, aKey);
    else
        (self.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(self, "removeObjectForKey:", aKey);
}
,["void","id","CPString"])]);
}{
var the_class = objj_getClass("CPNull")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPNull\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("valueForKey:"), function(self, _cmd, aKey)
{
    return self;
}
,["id","CPString"])]);
}{var the_class = objj_allocateClassPair(CPArray, "_CPKeyValueCodingArray"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_target", "id"), new objj_ivar("_countOfSelector", "SEL"), new objj_ivar("_objectInAtIndexSelector", "SEL"), new objj_ivar("_atIndexesSelector", "SEL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithTarget:key:"), function(self, _cmd, aTarget, aKey)
{
    self = (objj_getClass("_CPKeyValueCodingArray").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        var capitalizedKey = (aKey.charAt(0)).toUpperCase() + aKey.substr(1);
        self._target = aTarget;
        self._countOfSelector = CPSelectorFromString("countOf" + capitalizedKey);
        self._objectInAtIndexSelector = CPSelectorFromString("objectIn" + capitalizedKey + "AtIndex:");
        if (!((___r1 = self._target), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._objectInAtIndexSelector)))
            self._objectInAtIndexSelector = nil;
        self._atIndexesSelector = CPSelectorFromString(aKey + "AtIndexes:");
        if (!((___r1 = self._target), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._atIndexesSelector)))
            self._atIndexesSelector = nil;
    }
    return self;
    var ___r1;
}
,["id","id","CPString"]), new objj_method(sel_getUid("count"), function(self, _cmd)
{
    return self._target == nil ? nil : self._target.isa.objj_msgSend0(self._target, self._countOfSelector);
}
,["CPUInteger"]), new objj_method(sel_getUid("objectAtIndex:"), function(self, _cmd, anIndex)
{
    if (self._objectInAtIndexSelector)
        return self._target == nil ? nil : self._target.isa.objj_msgSend1(self._target, self._objectInAtIndexSelector, anIndex);
    return self._target == nil ? nil : (self._target.isa.objj_msgSend1(self._target, self._atIndexesSelector, (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex)))[0];
}
,["id","CPUInteger"]), new objj_method(sel_getUid("objectsAtIndexes:"), function(self, _cmd, indexes)
{
    if (self._atIndexesSelector)
        return self._target == nil ? nil : self._target.isa.objj_msgSend1(self._target, self._atIndexesSelector, indexes);
    return (objj_getClass("_CPKeyValueCodingArray").super_class.method_dtable["objectsAtIndexes:"] || _objj_forward)(self, "objectsAtIndexes:", indexes);
}
,["CPArray","CPIndexSet"]), new objj_method(sel_getUid("classForCoder"), function(self, _cmd)
{
    return (CPArray.isa.method_msgSend["class"] || _objj_forward)(CPArray, "class");
}
,["Class"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    return (CPArray.isa.method_msgSend["arrayWithArray:"] || _objj_forward)(CPArray, "arrayWithArray:", self);
}
,["id"])]);
}{var the_class = objj_allocateClassPair(CPSet, "_CPKeyValueCodingSet"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_target", "id"), new objj_ivar("_countOfSelector", "SEL"), new objj_ivar("_enumeratorOfSelector", "SEL"), new objj_ivar("_memberOfSelector", "SEL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithObjects:count:"), function(self, _cmd, objects, aCount)
{
    return ((___r1 = (CPSet.isa.method_msgSend["alloc"] || _objj_forward)(CPSet, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:count:"] || _objj_forward)(___r1, "initWithObjects:count:", objects, aCount));
    var ___r1;
}
,["id","CPArray","CPUInteger"]), new objj_method(sel_getUid("initWithTarget:key:"), function(self, _cmd, aTarget, aKey)
{
    self = (objj_getClass("_CPKeyValueCodingSet").super_class.method_dtable["initWithObjects:count:"] || _objj_forward)(self, "initWithObjects:count:", nil, 0);
    if (self)
    {
        var capitalizedKey = (aKey.charAt(0)).toUpperCase() + aKey.substr(1);
        self._target = aTarget;
        self._countOfSelector = CPSelectorFromString("countOf" + capitalizedKey);
        self._enumeratorOfSelector = CPSelectorFromString("enumeratorOf" + capitalizedKey);
        self._memberOfSelector = CPSelectorFromString("memberOf" + capitalizedKey + ":");
    }
    return self;
}
,["id","id","CPString"]), new objj_method(sel_getUid("count"), function(self, _cmd)
{
    return self._target == nil ? nil : self._target.isa.objj_msgSend0(self._target, self._countOfSelector);
}
,["CPUInteger"]), new objj_method(sel_getUid("objectEnumerator"), function(self, _cmd)
{
    return self._target == nil ? nil : self._target.isa.objj_msgSend0(self._target, self._enumeratorOfSelector);
}
,["CPEnumerator"]), new objj_method(sel_getUid("member:"), function(self, _cmd, anObject)
{
    return self._target == nil ? nil : self._target.isa.objj_msgSend1(self._target, self._memberOfSelector, anObject);
}
,["id","id"]), new objj_method(sel_getUid("classForCoder"), function(self, _cmd)
{
    return (CPSet.isa.method_msgSend["class"] || _objj_forward)(CPSet, "class");
}
,["Class"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    return (CPSet.isa.method_msgSend["setWithSet:"] || _objj_forward)(CPSet, "setWithSet:", self);
}
,["id"])]);
}objj_executeFile("CPKeyValueObserving.j", YES);p;21;CPKeyValueObserving.jt;67461;@STATIC;1.0;i;9;CPArray.ji;14;CPDictionary.ji;13;CPException.ji;12;CPIndexSet.ji;8;CPNull.ji;10;CPObject.ji;7;CPSet.ji;13;CPArray+KVO.ji;11;CPSet+KVO.jt;67302;objj_executeFile("CPArray.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPIndexSet.j", YES);objj_executeFile("CPNull.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPSet.j", YES);{
var the_class = objj_getClass("CPObject")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPObject\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("willChangeValueForKey:"), function(self, _cmd, aKey)
{
    if (!aKey)
        return;
    if (!self[KVOProxyKey])
    {
        if (!self._willChangeMessageCounter)
            self._willChangeMessageCounter = new Object();
        if (!self._willChangeMessageCounter[aKey])
            self._willChangeMessageCounter[aKey] = 1;
        else
            self._willChangeMessageCounter[aKey] += 1;
    }
}
,["void","CPString"]), new objj_method(sel_getUid("didChangeValueForKey:"), function(self, _cmd, aKey)
{
    if (!aKey)
        return;
    if (!self[KVOProxyKey])
    {
        if (self._willChangeMessageCounter && self._willChangeMessageCounter[aKey])
        {
            self._willChangeMessageCounter[aKey] -= 1;
            if (!self._willChangeMessageCounter[aKey])
                delete self._willChangeMessageCounter[aKey];
        }
        else
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", "CPKeyValueObservingException", "'didChange...' message called without prior call of 'willChange...'");
    }
}
,["void","CPString"]), new objj_method(sel_getUid("willChange:valuesAtIndexes:forKey:"), function(self, _cmd, aChange, indexes, aKey)
{
    if (!aKey)
        return;
    if (!self[KVOProxyKey])
    {
        if (!self._willChangeMessageCounter)
            self._willChangeMessageCounter = new Object();
        if (!self._willChangeMessageCounter[aKey])
            self._willChangeMessageCounter[aKey] = 1;
        else
            self._willChangeMessageCounter[aKey] += 1;
    }
}
,["void","CPKeyValueChange","CPIndexSet","CPString"]), new objj_method(sel_getUid("didChange:valuesAtIndexes:forKey:"), function(self, _cmd, aChange, indexes, aKey)
{
    if (!aKey)
        return;
    if (!self[KVOProxyKey])
    {
        if (self._willChangeMessageCounter && self._willChangeMessageCounter[aKey])
        {
            self._willChangeMessageCounter[aKey] -= 1;
            if (!self._willChangeMessageCounter[aKey])
                delete self._willChangeMessageCounter[aKey];
        }
        else
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", "CPKeyValueObservingException", "'didChange...' message called without prior call of 'willChange...'");
    }
}
,["void","CPKeyValueChange","CPIndexSet","CPString"]), new objj_method(sel_getUid("willChangeValueForKey:withSetMutation:usingObjects:"), function(self, _cmd, aKey, aMutationKind, objects)
{
    if (!aKey)
        return;
    if (!self[KVOProxyKey])
    {
        if (!self._willChangeMessageCounter)
            self._willChangeMessageCounter = new Object();
        if (!self._willChangeMessageCounter[aKey])
            self._willChangeMessageCounter[aKey] = 1;
        else
            self._willChangeMessageCounter[aKey] += 1;
    }
}
,["void","CPString","CPKeyValueSetMutationKind","CPSet"]), new objj_method(sel_getUid("didChangeValueForKey:withSetMutation:usingObjects:"), function(self, _cmd, aKey, aMutationKind, objects)
{
    if (!self[KVOProxyKey])
    {
        if (self._willChangeMessageCounter && self._willChangeMessageCounter[aKey])
        {
            self._willChangeMessageCounter[aKey] -= 1;
            if (!self._willChangeMessageCounter[aKey])
                delete self._willChangeMessageCounter[aKey];
        }
        else
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", "CPKeyValueObservingException", "'didChange...' message called without prior call of 'willChange...'");
    }
}
,["void","CPString","CPKeyValueSetMutationKind","CPSet"]), new objj_method(sel_getUid("addObserver:forKeyPath:options:context:"), function(self, _cmd, anObserver, aPath, options, aContext)
{
    if (!anObserver || !aPath)
        return;
    ((___r1 = (_CPKVOProxy == null ? null : (_CPKVOProxy.isa.method_msgSend["proxyForObject:"] || _objj_forward)(_CPKVOProxy, "proxyForObject:", self))), ___r1 == null ? null : (___r1.isa.method_msgSend["_addObserver:forKeyPath:options:context:"] || _objj_forward)(___r1, "_addObserver:forKeyPath:options:context:", anObserver, aPath, options, aContext));
    var ___r1;
}
,["void","id","CPString","CPKeyValueObservingOptions","id"]), new objj_method(sel_getUid("removeObserver:forKeyPath:"), function(self, _cmd, anObserver, aPath)
{
    if (!anObserver || !aPath)
        return;
    ((___r1 = self[KVOProxyKey]), ___r1 == null ? null : (___r1.isa.method_msgSend["_removeObserver:forKeyPath:"] || _objj_forward)(___r1, "_removeObserver:forKeyPath:", anObserver, aPath));
    var ___r1;
}
,["void","id","CPString"]), new objj_method(sel_getUid("applyChange:toKeyPath:"), function(self, _cmd, aChange, aKeyPath)
{
    var changeKind = (aChange == null ? null : (aChange.isa.method_msgSend["objectForKey:"] || _objj_forward)(aChange, "objectForKey:", CPKeyValueChangeKindKey)),
        oldValue = (aChange == null ? null : (aChange.isa.method_msgSend["objectForKey:"] || _objj_forward)(aChange, "objectForKey:", CPKeyValueChangeOldKey)),
        newValue = (aChange == null ? null : (aChange.isa.method_msgSend["objectForKey:"] || _objj_forward)(aChange, "objectForKey:", CPKeyValueChangeNewKey));
    if (newValue === (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null"))
        newValue = nil;
    if (changeKind === CPKeyValueChangeSetting)
        return (self.isa.method_msgSend["setValue:forKeyPath:"] || _objj_forward)(self, "setValue:forKeyPath:", newValue, aKeyPath);
    var indexes = (aChange == null ? null : (aChange.isa.method_msgSend["objectForKey:"] || _objj_forward)(aChange, "objectForKey:", CPKeyValueChangeIndexesKey));
    if (indexes)
    {
        if (changeKind === CPKeyValueChangeInsertion)
            ((___r1 = (self.isa.method_msgSend["mutableArrayValueForKeyPath:"] || _objj_forward)(self, "mutableArrayValueForKeyPath:", aKeyPath)), ___r1 == null ? null : (___r1.isa.method_msgSend["insertObjects:atIndexes:"] || _objj_forward)(___r1, "insertObjects:atIndexes:", newValue, indexes));
        else if (changeKind === CPKeyValueChangeRemoval)
            ((___r1 = (self.isa.method_msgSend["mutableArrayValueForKeyPath:"] || _objj_forward)(self, "mutableArrayValueForKeyPath:", aKeyPath)), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObjectsAtIndexes:"] || _objj_forward)(___r1, "removeObjectsAtIndexes:", indexes));
        else if (changeKind === CPKeyValueChangeReplacement)
            ((___r1 = (self.isa.method_msgSend["mutableArrayValueForKeyPath:"] || _objj_forward)(self, "mutableArrayValueForKeyPath:", aKeyPath)), ___r1 == null ? null : (___r1.isa.method_msgSend["replaceObjectAtIndexes:withObjects:"] || _objj_forward)(___r1, "replaceObjectAtIndexes:withObjects:", indexes, newValue));
    }
    else
    {
        if (changeKind === CPKeyValueChangeInsertion)
            ((___r1 = (self.isa.method_msgSend["mutableSetValueForKeyPath:"] || _objj_forward)(self, "mutableSetValueForKeyPath:", aKeyPath)), ___r1 == null ? null : (___r1.isa.method_msgSend["unionSet:"] || _objj_forward)(___r1, "unionSet:", newValue));
        else if (changeKind === CPKeyValueChangeRemoval)
            ((___r1 = (self.isa.method_msgSend["mutableSetValueForKeyPath:"] || _objj_forward)(self, "mutableSetValueForKeyPath:", aKeyPath)), ___r1 == null ? null : (___r1.isa.method_msgSend["minusSet:"] || _objj_forward)(___r1, "minusSet:", oldValue));
        else if (changeKind === CPKeyValueChangeReplacement)
            ((___r1 = (self.isa.method_msgSend["mutableSetValueForKeyPath:"] || _objj_forward)(self, "mutableSetValueForKeyPath:", aKeyPath)), ___r1 == null ? null : (___r1.isa.method_msgSend["setSet:"] || _objj_forward)(___r1, "setSet:", newValue));
    }
    var ___r1;
}
,["void","CPDictionary","CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("automaticallyNotifiesObserversForKey:"), function(self, _cmd, aKey)
{
    var capitalizedKey = (aKey.charAt(0)).toUpperCase() + aKey.substring(1),
        selector = "automaticallyNotifiesObserversOf" + capitalizedKey,
        aClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    if ((aClass == null ? null : (aClass.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(aClass, "respondsToSelector:", selector)))
        return aClass.isa.objj_msgSend0(aClass, selector);
    return YES;
}
,["BOOL","CPString"]), new objj_method(sel_getUid("keyPathsForValuesAffectingValueForKey:"), function(self, _cmd, aKey)
{
    var capitalizedKey = (aKey.charAt(0)).toUpperCase() + aKey.substring(1),
        selector = "keyPathsForValuesAffecting" + capitalizedKey,
        aClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    if ((aClass == null ? null : (aClass.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(aClass, "respondsToSelector:", selector)))
        return aClass.isa.objj_msgSend0(aClass, selector);
    return (CPSet.isa.method_msgSend["set"] || _objj_forward)(CPSet, "set");
}
,["CPSet","CPString"])]);
}{
var the_class = objj_getClass("CPDictionary")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPDictionary\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("inverseChangeDictionary"), function(self, _cmd)
{
    var inverseChangeDictionary = (self.isa.method_msgSend["mutableCopy"] || _objj_forward)(self, "mutableCopy"),
        changeKind = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", CPKeyValueChangeKindKey);
    if (changeKind === CPKeyValueChangeSetting || changeKind === CPKeyValueChangeReplacement)
    {
        (inverseChangeDictionary == null ? null : (inverseChangeDictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(inverseChangeDictionary, "setObject:forKey:", (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", CPKeyValueChangeOldKey), CPKeyValueChangeNewKey));
        (inverseChangeDictionary == null ? null : (inverseChangeDictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(inverseChangeDictionary, "setObject:forKey:", (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", CPKeyValueChangeNewKey), CPKeyValueChangeOldKey));
    }
    else if (changeKind === CPKeyValueChangeInsertion)
    {
        (inverseChangeDictionary == null ? null : (inverseChangeDictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(inverseChangeDictionary, "setObject:forKey:", CPKeyValueChangeRemoval, CPKeyValueChangeKindKey));
        (inverseChangeDictionary == null ? null : (inverseChangeDictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(inverseChangeDictionary, "setObject:forKey:", (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", CPKeyValueChangeNewKey), CPKeyValueChangeOldKey));
        (inverseChangeDictionary == null ? null : (inverseChangeDictionary.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(inverseChangeDictionary, "removeObjectForKey:", CPKeyValueChangeNewKey));
    }
    else if (changeKind === CPKeyValueChangeRemoval)
    {
        (inverseChangeDictionary == null ? null : (inverseChangeDictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(inverseChangeDictionary, "setObject:forKey:", CPKeyValueChangeInsertion, CPKeyValueChangeKindKey));
        (inverseChangeDictionary == null ? null : (inverseChangeDictionary.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(inverseChangeDictionary, "setObject:forKey:", (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", CPKeyValueChangeOldKey), CPKeyValueChangeNewKey));
        (inverseChangeDictionary == null ? null : (inverseChangeDictionary.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(inverseChangeDictionary, "removeObjectForKey:", CPKeyValueChangeOldKey));
    }
    return inverseChangeDictionary;
}
,["CPDictionary"])]);
}CPKeyValueObservingOptionNew = 1 << 0;
CPKeyValueObservingOptionOld = 1 << 1;
CPKeyValueObservingOptionInitial = 1 << 2;
CPKeyValueObservingOptionPrior = 1 << 3;
CPKeyValueChangeKindKey = "CPKeyValueChangeKindKey";
CPKeyValueChangeNewKey = "CPKeyValueChangeNewKey";
CPKeyValueChangeOldKey = "CPKeyValueChangeOldKey";
CPKeyValueChangeIndexesKey = "CPKeyValueChangeIndexesKey";
CPKeyValueChangeNotificationIsPriorKey = "CPKeyValueChangeNotificationIsPriorKey";
CPKeyValueChangeSetting = 1;
CPKeyValueChangeInsertion = 2;
CPKeyValueChangeRemoval = 3;
CPKeyValueChangeReplacement = 4;
CPKeyValueUnionSetMutation = 1;
CPKeyValueMinusSetMutation = 2;
CPKeyValueIntersectSetMutation = 3;
CPKeyValueSetSetMutation = 4;
_CPKeyValueChangeSetMutationObjectsKey = "_CPKeyValueChangeSetMutationObjectsKey";
_CPKeyValueChangeSetMutationKindKey = "_CPKeyValueChangeSetMutationKindKey";
_CPKeyValueChangeSetMutationNewValueKey = "_CPKeyValueChangeSetMutationNewValueKey";
var _changeKindForSetMutationKind = function(mutationKind)
{
    switch(mutationKind) {
    case CPKeyValueUnionSetMutation:
        return CPKeyValueChangeInsertion;
    case CPKeyValueMinusSetMutation:
        return CPKeyValueChangeRemoval;
    case CPKeyValueIntersectSetMutation:
        return CPKeyValueChangeRemoval;
    case CPKeyValueSetSetMutation:
        return CPKeyValueChangeReplacement;
    }
};
var kvoNewAndOld = CPKeyValueObservingOptionNew | CPKeyValueObservingOptionOld,
    DependentKeysKey = "$KVODEPENDENT",
    KVOProxyKey = "$KVOPROXY";
{var the_class = objj_allocateClassPair(CPObject, "_CPKVOProxy"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_targetObject", "id"), new objj_ivar("_nativeClass", "Class"), new objj_ivar("_changesForKey", "CPDictionary"), new objj_ivar("_nestingForKey", "CPDictionary"), new objj_ivar("_minOptionsForKey", "CPDictionary"), new objj_ivar("_observersForKey", "Object"), new objj_ivar("_observersForKeyLength", "int"), new objj_ivar("_replacedKeys", "CPSet"), new objj_ivar("_adding", "BOOL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("adding"), function(self, _cmd)
{
    return self._adding;
}
,["BOOL"]), new objj_method(sel_getUid("setAdding:"), function(self, _cmd, newValue)
{
    self._adding = newValue;
}
,["void","BOOL"]), new objj_method(sel_getUid("initWithTarget:"), function(self, _cmd, aTarget)
{
    if (self = (objj_getClass("_CPKVOProxy").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._targetObject = aTarget;
        self._nativeClass = (aTarget == null ? null : (aTarget.isa.method_msgSend["class"] || _objj_forward)(aTarget, "class"));
        self._observersForKey = {};
        self._changesForKey = {};
        self._nestingForKey = {};
        self._minOptionsForKey = {};
        self._observersForKeyLength = 0;
        (self == null ? null : (self.isa.method_msgSend["_replaceClass"] || _objj_forward)(self, "_replaceClass"));
        aTarget[KVOProxyKey] = self;
    }
    return self;
}
,["id","id"]), new objj_method(sel_getUid("_replaceClass"), function(self, _cmd)
{
    var currentClass = self._nativeClass,
        kvoClassName = "$KVO_" + class_getName(self._nativeClass),
        existingKVOClass = objj_lookUpClass(kvoClassName);
    if (existingKVOClass)
    {
        self._targetObject.isa = existingKVOClass;
        self._replacedKeys = existingKVOClass._replacedKeys;
        return;
    }
    var kvoClass = objj_allocateClassPair(currentClass, kvoClassName);
    objj_registerClassPair(kvoClass);
    self._replacedKeys = (CPSet.isa.method_msgSend["set"] || _objj_forward)(CPSet, "set");
    kvoClass._replacedKeys = self._replacedKeys;
    var methods = class_copyMethodList(_CPKVOModelSubclass);
    if (((___r1 = self._targetObject), ___r1 == null ? null : (___r1.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(___r1, "isKindOfClass:", (CPDictionary.isa.method_msgSend["class"] || _objj_forward)(CPDictionary, "class"))))
        methods = methods.concat(class_copyMethodList(_CPKVOModelDictionarySubclass));
    class_addMethods(kvoClass, methods);
    self._targetObject.isa = kvoClass;
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("_replaceModifiersForKey:"), function(self, _cmd, aKey)
{
    if (((___r1 = self._replacedKeys), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", aKey)) || !((___r1 = self._nativeClass), ___r1 == null ? null : (___r1.isa.method_msgSend["automaticallyNotifiesObserversForKey:"] || _objj_forward)(___r1, "automaticallyNotifiesObserversForKey:", aKey)))
        return;
    ((___r1 = self._replacedKeys), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", aKey));
    var theClass = self._nativeClass,
        KVOClass = self._targetObject.isa,
        capitalizedKey = (aKey.charAt(0)).toUpperCase() + aKey.substring(1);
    var setKey_selector = sel_getUid("set" + capitalizedKey + ":"),
        setKey_method = class_getInstanceMethod(theClass, setKey_selector);
    if (setKey_method)
    {
        var setKey_method_imp = setKey_method.method_imp;
        class_addMethod(KVOClass, setKey_selector, function(self, _cmd, anObject)
        {
            (self == null ? null : (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", aKey));
            setKey_method_imp(self, _cmd, anObject);
            (self == null ? null : (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", aKey));
        }, setKey_method.method_types);
    }
    var _setKey_selector = sel_getUid("_set" + capitalizedKey + ":"),
        _setKey_method = class_getInstanceMethod(theClass, _setKey_selector);
    if (_setKey_method)
    {
        var _setKey_method_imp = _setKey_method.method_imp;
        class_addMethod(KVOClass, _setKey_selector, function(self, _cmd, anObject)
        {
            (self == null ? null : (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", aKey));
            _setKey_method_imp(self, _cmd, anObject);
            (self == null ? null : (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", aKey));
        }, _setKey_method.method_types);
    }
    var insertObject_inKeyAtIndex_selector = sel_getUid("insertObject:in" + capitalizedKey + "AtIndex:"),
        insertObject_inKeyAtIndex_method = class_getInstanceMethod(theClass, insertObject_inKeyAtIndex_selector),
        insertKey_atIndexes_selector = sel_getUid("insert" + capitalizedKey + ":atIndexes:"),
        insertKey_atIndexes_method = class_getInstanceMethod(theClass, insertKey_atIndexes_selector),
        removeObjectFromKeyAtIndex_selector = sel_getUid("removeObjectFrom" + capitalizedKey + "AtIndex:"),
        removeObjectFromKeyAtIndex_method = class_getInstanceMethod(theClass, removeObjectFromKeyAtIndex_selector),
        removeKeyAtIndexes_selector = sel_getUid("remove" + capitalizedKey + "AtIndexes:"),
        removeKeyAtIndexes_method = class_getInstanceMethod(theClass, removeKeyAtIndexes_selector);
    if ((insertObject_inKeyAtIndex_method || insertKey_atIndexes_method) && (removeObjectFromKeyAtIndex_method || removeKeyAtIndexes_method))
    {
        if (insertObject_inKeyAtIndex_method)
        {
            var insertObject_inKeyAtIndex_method_imp = insertObject_inKeyAtIndex_method.method_imp;
            class_addMethod(KVOClass, insertObject_inKeyAtIndex_selector, function(self, _cmd, anObject, anIndex)
            {
                (self == null ? null : (self.isa.method_msgSend["willChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "willChange:valuesAtIndexes:forKey:", CPKeyValueChangeInsertion, (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex), aKey));
                insertObject_inKeyAtIndex_method_imp(self, _cmd, anObject, anIndex);
                (self == null ? null : (self.isa.method_msgSend["didChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "didChange:valuesAtIndexes:forKey:", CPKeyValueChangeInsertion, (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex), aKey));
            }, insertObject_inKeyAtIndex_method.method_types);
        }
        if (insertKey_atIndexes_method)
        {
            var insertKey_atIndexes_method_imp = insertKey_atIndexes_method.method_imp;
            class_addMethod(KVOClass, insertKey_atIndexes_selector, function(self, _cmd, objects, indexes)
            {
                (self == null ? null : (self.isa.method_msgSend["willChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "willChange:valuesAtIndexes:forKey:", CPKeyValueChangeInsertion, (indexes == null ? null : (indexes.isa.method_msgSend["copy"] || _objj_forward)(indexes, "copy")), aKey));
                insertKey_atIndexes_method_imp(self, _cmd, objects, indexes);
                (self == null ? null : (self.isa.method_msgSend["didChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "didChange:valuesAtIndexes:forKey:", CPKeyValueChangeInsertion, (indexes == null ? null : (indexes.isa.method_msgSend["copy"] || _objj_forward)(indexes, "copy")), aKey));
            }, insertKey_atIndexes_method.method_types);
        }
        if (removeObjectFromKeyAtIndex_method)
        {
            var removeObjectFromKeyAtIndex_method_imp = removeObjectFromKeyAtIndex_method.method_imp;
            class_addMethod(KVOClass, removeObjectFromKeyAtIndex_selector, function(self, _cmd, anIndex)
            {
                (self == null ? null : (self.isa.method_msgSend["willChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "willChange:valuesAtIndexes:forKey:", CPKeyValueChangeRemoval, (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex), aKey));
                removeObjectFromKeyAtIndex_method_imp(self, _cmd, anIndex);
                (self == null ? null : (self.isa.method_msgSend["didChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "didChange:valuesAtIndexes:forKey:", CPKeyValueChangeRemoval, (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex), aKey));
            }, removeObjectFromKeyAtIndex_method.method_types);
        }
        if (removeKeyAtIndexes_method)
        {
            var removeKeyAtIndexes_method_imp = removeKeyAtIndexes_method.method_imp;
            class_addMethod(KVOClass, removeKeyAtIndexes_selector, function(self, _cmd, indexes)
            {
                (self == null ? null : (self.isa.method_msgSend["willChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "willChange:valuesAtIndexes:forKey:", CPKeyValueChangeRemoval, (indexes == null ? null : (indexes.isa.method_msgSend["copy"] || _objj_forward)(indexes, "copy")), aKey));
                removeKeyAtIndexes_method_imp(self, _cmd, indexes);
                (self == null ? null : (self.isa.method_msgSend["didChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "didChange:valuesAtIndexes:forKey:", CPKeyValueChangeRemoval, (indexes == null ? null : (indexes.isa.method_msgSend["copy"] || _objj_forward)(indexes, "copy")), aKey));
            }, removeKeyAtIndexes_method.method_types);
        }
        var replaceObjectInKeyAtIndex_withObject_selector = sel_getUid("replaceObjectIn" + capitalizedKey + "AtIndex:withObject:"),
            replaceObjectInKeyAtIndex_withObject_method = class_getInstanceMethod(theClass, replaceObjectInKeyAtIndex_withObject_selector);
        if (replaceObjectInKeyAtIndex_withObject_method)
        {
            var replaceObjectInKeyAtIndex_withObject_method_imp = replaceObjectInKeyAtIndex_withObject_method.method_imp;
            class_addMethod(KVOClass, replaceObjectInKeyAtIndex_withObject_selector, function(self, _cmd, anIndex, anObject)
            {
                (self == null ? null : (self.isa.method_msgSend["willChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "willChange:valuesAtIndexes:forKey:", CPKeyValueChangeReplacement, (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex), aKey));
                replaceObjectInKeyAtIndex_withObject_method_imp(self, _cmd, anIndex, anObject);
                (self == null ? null : (self.isa.method_msgSend["didChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "didChange:valuesAtIndexes:forKey:", CPKeyValueChangeReplacement, (CPIndexSet.isa.method_msgSend["indexSetWithIndex:"] || _objj_forward)(CPIndexSet, "indexSetWithIndex:", anIndex), aKey));
            }, replaceObjectInKeyAtIndex_withObject_method.method_types);
        }
        var replaceKeyAtIndexes_withKey_selector = sel_getUid("replace" + capitalizedKey + "AtIndexes:with" + capitalizedKey + ":"),
            replaceKeyAtIndexes_withKey_method = class_getInstanceMethod(theClass, replaceKeyAtIndexes_withKey_selector);
        if (replaceKeyAtIndexes_withKey_method)
        {
            var replaceKeyAtIndexes_withKey_method_imp = replaceKeyAtIndexes_withKey_method.method_imp;
            class_addMethod(KVOClass, replaceKeyAtIndexes_withKey_selector, function(self, _cmd, indexes, objects)
            {
                (self == null ? null : (self.isa.method_msgSend["willChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "willChange:valuesAtIndexes:forKey:", CPKeyValueChangeReplacement, (indexes == null ? null : (indexes.isa.method_msgSend["copy"] || _objj_forward)(indexes, "copy")), aKey));
                replaceObjectInKeyAtIndex_withObject_method_imp(self, _cmd, indexes, objects);
                (self == null ? null : (self.isa.method_msgSend["didChange:valuesAtIndexes:forKey:"] || _objj_forward)(self, "didChange:valuesAtIndexes:forKey:", CPKeyValueChangeReplacement, (indexes == null ? null : (indexes.isa.method_msgSend["copy"] || _objj_forward)(indexes, "copy")), aKey));
            }, replaceKeyAtIndexes_withKey_method.method_types);
        }
    }
    var addKeyObject_selector = sel_getUid("add" + capitalizedKey + "Object:"),
        addKeyObject_method = class_getInstanceMethod(theClass, addKeyObject_selector),
        addKey_selector = sel_getUid("add" + capitalizedKey + ":"),
        addKey_method = class_getInstanceMethod(theClass, addKey_selector),
        removeKeyObject_selector = sel_getUid("remove" + capitalizedKey + "Object:"),
        removeKeyObject_method = class_getInstanceMethod(theClass, removeKeyObject_selector),
        removeKey_selector = sel_getUid("remove" + capitalizedKey + ":"),
        removeKey_method = class_getInstanceMethod(theClass, removeKey_selector);
    if ((addKeyObject_method || addKey_method) && (removeKeyObject_method || removeKey_method))
    {
        if (addKeyObject_method)
        {
            var addKeyObject_method_imp = addKeyObject_method.method_imp;
            class_addMethod(KVOClass, addKeyObject_selector, function(self, _cmd, anObject)
            {
                (self == null ? null : (self.isa.method_msgSend["willChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "willChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueUnionSetMutation, (CPSet.isa.method_msgSend["setWithObject:"] || _objj_forward)(CPSet, "setWithObject:", anObject)));
                addKeyObject_method_imp(self, _cmd, anObject);
                (self == null ? null : (self.isa.method_msgSend["didChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "didChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueUnionSetMutation, (CPSet.isa.method_msgSend["setWithObject:"] || _objj_forward)(CPSet, "setWithObject:", anObject)));
            }, addKeyObject_method.method_types);
        }
        if (addKey_method)
        {
            var addKey_method_imp = addKey_method.method_imp;
            class_addMethod(KVOClass, addKey_selector, function(self, _cmd, objects)
            {
                (self == null ? null : (self.isa.method_msgSend["willChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "willChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueUnionSetMutation, (objects == null ? null : (objects.isa.method_msgSend["copy"] || _objj_forward)(objects, "copy"))));
                addKey_method_imp(self, _cmd, objects);
                (self == null ? null : (self.isa.method_msgSend["didChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "didChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueUnionSetMutation, (objects == null ? null : (objects.isa.method_msgSend["copy"] || _objj_forward)(objects, "copy"))));
            }, addKey_method.method_types);
        }
        if (removeKeyObject_method)
        {
            var removeKeyObject_method_imp = removeKeyObject_method.method_imp;
            class_addMethod(KVOClass, removeKeyObject_selector, function(self, _cmd, anObject)
            {
                (self == null ? null : (self.isa.method_msgSend["willChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "willChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueMinusSetMutation, (CPSet.isa.method_msgSend["setWithObject:"] || _objj_forward)(CPSet, "setWithObject:", anObject)));
                removeKeyObject_method_imp(self, _cmd, anObject);
                (self == null ? null : (self.isa.method_msgSend["didChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "didChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueMinusSetMutation, (CPSet.isa.method_msgSend["setWithObject:"] || _objj_forward)(CPSet, "setWithObject:", anObject)));
            }, removeKeyObject_method.method_types);
        }
        if (removeKey_method)
        {
            var removeKey_method_imp = removeKey_method.method_imp;
            class_addMethod(KVOClass, removeKey_selector, function(self, _cmd, objects)
            {
                (self == null ? null : (self.isa.method_msgSend["willChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "willChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueMinusSetMutation, (objects == null ? null : (objects.isa.method_msgSend["copy"] || _objj_forward)(objects, "copy"))));
                removeKey_method_imp(self, _cmd, objects);
                (self == null ? null : (self.isa.method_msgSend["didChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "didChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueMinusSetMutation, (objects == null ? null : (objects.isa.method_msgSend["copy"] || _objj_forward)(objects, "copy"))));
            }, removeKey_method.method_types);
        }
        var intersectKey_selector = sel_getUid("intersect" + capitalizedKey + ":"),
            intersectKey_method = class_getInstanceMethod(theClass, intersectKey_selector);
        if (intersectKey_method)
        {
            var intersectKey_method_imp = intersectKey_method.method_imp;
            class_addMethod(KVOClass, intersectKey_selector, function(self, _cmd, aSet)
            {
                (self == null ? null : (self.isa.method_msgSend["willChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "willChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueIntersectSetMutation, (aSet == null ? null : (aSet.isa.method_msgSend["copy"] || _objj_forward)(aSet, "copy"))));
                intersectKey_method_imp(self, _cmd, aSet);
                (self == null ? null : (self.isa.method_msgSend["didChangeValueForKey:withSetMutation:usingObjects:"] || _objj_forward)(self, "didChangeValueForKey:withSetMutation:usingObjects:", aKey, CPKeyValueIntersectSetMutation, (aSet == null ? null : (aSet.isa.method_msgSend["copy"] || _objj_forward)(aSet, "copy"))));
            }, intersectKey_method.method_types);
        }
    }
    var affectingKeys = ((___r1 = ((___r2 = self._nativeClass), ___r2 == null ? null : (___r2.isa.method_msgSend["keyPathsForValuesAffectingValueForKey:"] || _objj_forward)(___r2, "keyPathsForValuesAffectingValueForKey:", aKey))), ___r1 == null ? null : (___r1.isa.method_msgSend["allObjects"] || _objj_forward)(___r1, "allObjects")),
        affectingKeysCount = affectingKeys ? affectingKeys.length : 0;
    if (!affectingKeysCount)
        return;
    var dependentKeysForClass = self._nativeClass[DependentKeysKey];
    if (!dependentKeysForClass)
    {
        dependentKeysForClass = {};
        self._nativeClass[DependentKeysKey] = dependentKeysForClass;
    }
    while (affectingKeysCount--)
    {
        var affectingKey = affectingKeys[affectingKeysCount],
            affectedKeys = dependentKeysForClass[affectingKey];
        if (!affectedKeys)
        {
            affectedKeys = (CPSet.isa.method_msgSend["new"] || _objj_forward)(CPSet, "new");
            dependentKeysForClass[affectingKey] = affectedKeys;
        }
        (affectedKeys == null ? null : (affectedKeys.isa.method_msgSend["addObject:"] || _objj_forward)(affectedKeys, "addObject:", aKey));
        if (affectingKey.indexOf(".") !== -1)
            ((___r1 = self._targetObject), ___r1 == null ? null : (___r1.isa.method_msgSend["addObserver:forKeyPath:options:context:"] || _objj_forward)(___r1, "addObserver:forKeyPath:options:context:", self, affectingKey, CPKeyValueObservingOptionPrior | kvoNewAndOld, nil));
        else
            (self.isa.method_msgSend["_replaceModifiersForKey:"] || _objj_forward)(self, "_replaceModifiersForKey:", affectingKey);
    }
    var ___r1, ___r2;
}
,["void","CPString"]), new objj_method(sel_getUid("observeValueForKeyPath:ofObject:change:context:"), function(self, _cmd, theKeyPath, theObject, theChanges, theContext)
{
    var dependentKeysForClass = self._nativeClass[DependentKeysKey],
        dependantKeys = ((___r1 = dependentKeysForClass[theKeyPath]), ___r1 == null ? null : (___r1.isa.method_msgSend["allObjects"] || _objj_forward)(___r1, "allObjects")),
        isBeforeFlag = !!(theChanges == null ? null : (theChanges.isa.method_msgSend["objectForKey:"] || _objj_forward)(theChanges, "objectForKey:", CPKeyValueChangeNotificationIsPriorKey));
    for (var i = 0; i < (dependantKeys == null ? null : (dependantKeys.isa.method_msgSend["count"] || _objj_forward)(dependantKeys, "count")); i++)
    {
        var dependantKey = (dependantKeys == null ? null : (dependantKeys.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(dependantKeys, "objectAtIndex:", i));
        (self.isa.method_msgSend["_sendNotificationsForKey:changeOptions:isBefore:"] || _objj_forward)(self, "_sendNotificationsForKey:changeOptions:isBefore:", dependantKey, theChanges, isBeforeFlag);
    }
    var ___r1;
}
,["void","CPString","id","CPDictionary","id"]), new objj_method(sel_getUid("_addObserver:forKeyPath:options:context:"), function(self, _cmd, anObserver, aPath, options, aContext)
{
    if (!anObserver)
        return;
    var forwarder = nil;
    if (aPath.indexOf('.') !== CPNotFound && aPath.charAt(0) !== '@')
        forwarder = ((___r1 = (_CPKVOForwardingObserver == null ? null : (_CPKVOForwardingObserver.isa.method_msgSend["alloc"] || _objj_forward)(_CPKVOForwardingObserver, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithKeyPath:object:observer:options:context:"] || _objj_forward)(___r1, "initWithKeyPath:object:observer:options:context:", aPath, self._targetObject, anObserver, options, aContext));
    else
        (self.isa.method_msgSend["_replaceModifiersForKey:"] || _objj_forward)(self, "_replaceModifiersForKey:", aPath);
    var observers = self._observersForKey[aPath];
    if (!observers)
    {
        observers = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._observersForKey[aPath] = observers;
        self._observersForKeyLength++;
    }
    (observers == null ? null : (observers.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(observers, "setObject:forKey:", _CPKVOInfoMake(anObserver, options, aContext, forwarder), (anObserver == null ? null : (anObserver.isa.method_msgSend["UID"] || _objj_forward)(anObserver, "UID"))));
    if (options & CPKeyValueObservingOptionInitial)
    {
        var changes;
        if (options & CPKeyValueObservingOptionNew)
        {
            var newValue = ((___r1 = self._targetObject), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(___r1, "valueForKeyPath:", aPath));
            if (newValue == nil)
                newValue = (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null");
            changes = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [CPKeyValueChangeSetting, newValue], [CPKeyValueChangeKindKey, CPKeyValueChangeNewKey]));
        }
        else
        {
            changes = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [CPKeyValueChangeSetting], [CPKeyValueChangeKindKey]));
        }
        (anObserver == null ? null : (anObserver.isa.method_msgSend["observeValueForKeyPath:ofObject:change:context:"] || _objj_forward)(anObserver, "observeValueForKeyPath:ofObject:change:context:", aPath, self._targetObject, changes, aContext));
    }
    var ___r1;
}
,["void","id","CPString","CPKeyValueObservingOptions","id"]), new objj_method(sel_getUid("_removeObserver:forKeyPath:"), function(self, _cmd, anObserver, aPath)
{
    var observers = self._observersForKey[aPath];
    if (!observers)
    {
        if (!self._adding)
            CPLog.warn("Cannot remove an observer %@ for the key path \"%@\" from %@ because it is not registered as an observer.", self._targetObject, aPath, anObserver);
        return;
    }
    if (aPath.indexOf('.') != CPNotFound)
    {
        var observer = (observers == null ? null : (observers.isa.method_msgSend["objectForKey:"] || _objj_forward)(observers, "objectForKey:", (anObserver == null ? null : (anObserver.isa.method_msgSend["UID"] || _objj_forward)(anObserver, "UID")))),
            forwarder = observer ? observer.forwarder : nil;
        (forwarder == null ? null : (forwarder.isa.method_msgSend["finalize"] || _objj_forward)(forwarder, "finalize"));
    }
    (observers == null ? null : (observers.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(observers, "removeObjectForKey:", (anObserver == null ? null : (anObserver.isa.method_msgSend["UID"] || _objj_forward)(anObserver, "UID"))));
    if (!(observers == null ? null : (observers.isa.method_msgSend["count"] || _objj_forward)(observers, "count")))
    {
        self._observersForKeyLength--;
        delete self._observersForKey[aPath];
    }
    if (!self._observersForKeyLength)
    {
        self._targetObject.isa = self._nativeClass;
        delete self._targetObject[KVOProxyKey];
    }
}
,["void","id","CPString"]), new objj_method(sel_getUid("_sendNotificationsForKey:changeOptions:isBefore:"), function(self, _cmd, aKey, changeOptions, isBefore)
{
    var changes = self._changesForKey[aKey],
        observers = ((___r1 = self._observersForKey[aKey]), ___r1 == null ? null : (___r1.isa.method_msgSend["allValues"] || _objj_forward)(___r1, "allValues")),
        observersMinimumOptions = 0;
    if (isBefore)
    {
        if (changes)
        {
            var level = self._nestingForKey[aKey];
            if (!level)
                (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInternalInconsistencyException, "_changesForKey without _nestingForKey");
            self._nestingForKey[aKey] = level + 1;
            return;
        }
        self._nestingForKey[aKey] = 1;
        var count = observers ? observers.length : 0;
        while (count--)
        {
            var observerInfo = observers[count];
            observersMinimumOptions |= observerInfo.options & kvoNewAndOld;
        }
        self._minOptionsForKey[aKey] = observersMinimumOptions;
        changes = changeOptions;
        if (observersMinimumOptions & CPKeyValueObservingOptionOld)
        {
            var indexes = (changes == null ? null : (changes.isa.method_msgSend["objectForKey:"] || _objj_forward)(changes, "objectForKey:", CPKeyValueChangeIndexesKey)),
                setMutationKind = changes[_CPKeyValueChangeSetMutationKindKey];
            if (setMutationKind)
            {
                var setMutationObjects = ((___r1 = changes[_CPKeyValueChangeSetMutationObjectsKey]), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy")),
                    setExistingObjects = ((___r1 = ((___r2 = self._targetObject), ___r2 == null ? null : (___r2.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r2, "valueForKey:", aKey))), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
                if (setMutationKind == CPKeyValueMinusSetMutation)
                {
                    (setExistingObjects == null ? null : (setExistingObjects.isa.method_msgSend["intersectSet:"] || _objj_forward)(setExistingObjects, "intersectSet:", setMutationObjects));
                    (changes == null ? null : (changes.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(changes, "setValue:forKey:", setExistingObjects, CPKeyValueChangeOldKey));
                }
                else if (setMutationKind === CPKeyValueIntersectSetMutation || setMutationKind === CPKeyValueSetSetMutation)
                {
                    (setExistingObjects == null ? null : (setExistingObjects.isa.method_msgSend["minusSet:"] || _objj_forward)(setExistingObjects, "minusSet:", setMutationObjects));
                    (changes == null ? null : (changes.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(changes, "setValue:forKey:", setExistingObjects, CPKeyValueChangeOldKey));
                }
                if (setMutationKind === CPKeyValueUnionSetMutation || setMutationKind === CPKeyValueSetSetMutation)
                {
                    (setMutationObjects == null ? null : (setMutationObjects.isa.method_msgSend["minusSet:"] || _objj_forward)(setMutationObjects, "minusSet:", setExistingObjects));
                    changes[_CPKeyValueChangeSetMutationNewValueKey] = setMutationObjects;
                }
            }
            else if (indexes)
            {
                var type = (changes == null ? null : (changes.isa.method_msgSend["objectForKey:"] || _objj_forward)(changes, "objectForKey:", CPKeyValueChangeKindKey));
                if (type === CPKeyValueChangeReplacement || type === CPKeyValueChangeRemoval)
                {
                    var newValues = ((___r1 = ((___r2 = self._targetObject), ___r2 == null ? null : (___r2.isa.method_msgSend["mutableArrayValueForKeyPath:"] || _objj_forward)(___r2, "mutableArrayValueForKeyPath:", aKey))), ___r1 == null ? null : (___r1.isa.method_msgSend["objectsAtIndexes:"] || _objj_forward)(___r1, "objectsAtIndexes:", indexes));
                    (changes == null ? null : (changes.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(changes, "setValue:forKey:", newValues, CPKeyValueChangeOldKey));
                }
            }
            else
            {
                var oldValue = ((___r1 = self._targetObject), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r1, "valueForKey:", aKey));
                if (oldValue === nil || oldValue === undefined)
                    oldValue = (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null");
                (changes == null ? null : (changes.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(changes, "setObject:forKey:", oldValue, CPKeyValueChangeOldKey));
            }
        }
        (changes == null ? null : (changes.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(changes, "setObject:forKey:", 1, CPKeyValueChangeNotificationIsPriorKey));
        self._changesForKey[aKey] = changes;
        observersMinimumOptions &= ~CPKeyValueObservingOptionNew;
    }
    else
    {
        var level = self._nestingForKey[aKey];
        if (!changes || !level)
        {
            if (self._targetObject._willChangeMessageCounter && self._targetObject._willChangeMessageCounter[aKey])
            {
                self._targetObject._willChangeMessageCounter[aKey] -= 1;
                if (!self._targetObject._willChangeMessageCounter[aKey])
                    delete self._targetObject._willChangeMessageCounter[aKey];
                return;
            }
            else
                (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", "CPKeyValueObservingException", "'didChange...' message called without prior call of 'willChange...'");
        }
        self._nestingForKey[aKey] = level - 1;
        if (level - 1 > 0)
        {
            return;
        }
        delete self._nestingForKey[aKey];
        (changes == null ? null : (changes.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(changes, "removeObjectForKey:", CPKeyValueChangeNotificationIsPriorKey));
        observersMinimumOptions = self._minOptionsForKey[aKey];
        if (observersMinimumOptions & CPKeyValueObservingOptionNew)
        {
            var indexes = (changes == null ? null : (changes.isa.method_msgSend["objectForKey:"] || _objj_forward)(changes, "objectForKey:", CPKeyValueChangeIndexesKey)),
                setMutationKind = changes[_CPKeyValueChangeSetMutationKindKey];
            if (setMutationKind)
            {
                var newValue = changes[_CPKeyValueChangeSetMutationNewValueKey];
                (changes == null ? null : (changes.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(changes, "setValue:forKey:", newValue, CPKeyValueChangeNewKey));
                delete changes[_CPKeyValueChangeSetMutationNewValueKey];
                delete changes[_CPKeyValueChangeSetMutationObjectsKey];
                delete changes[_CPKeyValueChangeSetMutationKindKey];
            }
            else if (indexes)
            {
                var type = (changes == null ? null : (changes.isa.method_msgSend["objectForKey:"] || _objj_forward)(changes, "objectForKey:", CPKeyValueChangeKindKey));
                if (type == CPKeyValueChangeReplacement || type == CPKeyValueChangeInsertion)
                {
                    var newValues = ((___r1 = ((___r2 = self._targetObject), ___r2 == null ? null : (___r2.isa.method_msgSend["mutableArrayValueForKeyPath:"] || _objj_forward)(___r2, "mutableArrayValueForKeyPath:", aKey))), ___r1 == null ? null : (___r1.isa.method_msgSend["objectsAtIndexes:"] || _objj_forward)(___r1, "objectsAtIndexes:", indexes));
                    (changes == null ? null : (changes.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(changes, "setValue:forKey:", newValues, CPKeyValueChangeNewKey));
                }
            }
            else
            {
                var newValue = ((___r1 = self._targetObject), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r1, "valueForKey:", aKey));
                if (newValue === nil || newValue === undefined)
                    newValue = (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null");
                (changes == null ? null : (changes.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(changes, "setObject:forKey:", newValue, CPKeyValueChangeNewKey));
            }
        }
        delete self._minOptionsForKey[aKey];
        delete self._changesForKey[aKey];
    }
    var count = observers ? observers.length : 0,
        changesCache = {};
    while (count--)
    {
        var observerInfo = observers[count],
            options = observerInfo.options,
            onlyNewAndOldOptions = options & kvoNewAndOld,
            observerChanges = nil;
        if (isBefore)
        {
            if (options & CPKeyValueObservingOptionPrior)
            {
                observerChanges = changes;
                onlyNewAndOldOptions &= ~CPKeyValueObservingOptionNew;
            }
        }
        else
        {
            observerChanges = changes;
        }
        if (observerChanges)
        {
            if (onlyNewAndOldOptions !== observersMinimumOptions)
            {
                observerChanges = changesCache[onlyNewAndOldOptions];
                if (!observerChanges)
                {
                    changesCache[onlyNewAndOldOptions] = observerChanges = (changes == null ? null : (changes.isa.method_msgSend["mutableCopy"] || _objj_forward)(changes, "mutableCopy"));
                    if (!(onlyNewAndOldOptions & CPKeyValueObservingOptionOld))
                        (observerChanges == null ? null : (observerChanges.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(observerChanges, "removeObjectForKey:", CPKeyValueChangeOldKey));
                    if (!(onlyNewAndOldOptions & CPKeyValueObservingOptionNew))
                        (observerChanges == null ? null : (observerChanges.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(observerChanges, "removeObjectForKey:", CPKeyValueChangeNewKey));
                }
            }
            ((___r1 = observerInfo.observer), ___r1 == null ? null : (___r1.isa.method_msgSend["observeValueForKeyPath:ofObject:change:context:"] || _objj_forward)(___r1, "observeValueForKeyPath:ofObject:change:context:", aKey, self._targetObject, observerChanges, observerInfo.context));
        }
    }
    var dependentKeysMap = self._nativeClass[DependentKeysKey];
    if (!dependentKeysMap)
        return;
    var dependentKeyPaths = ((___r1 = dependentKeysMap[aKey]), ___r1 == null ? null : (___r1.isa.method_msgSend["allObjects"] || _objj_forward)(___r1, "allObjects"));
    if (!dependentKeyPaths)
        return;
    var index = 0,
        count = (dependentKeyPaths == null ? null : (dependentKeyPaths.isa.method_msgSend["count"] || _objj_forward)(dependentKeyPaths, "count"));
    for (; index < count; ++index)
    {
        var keyPath = dependentKeyPaths[index];
        (self.isa.method_msgSend["_sendNotificationsForKey:changeOptions:isBefore:"] || _objj_forward)(self, "_sendNotificationsForKey:changeOptions:isBefore:", keyPath, isBefore ? (changeOptions == null ? null : (changeOptions.isa.method_msgSend["copy"] || _objj_forward)(changeOptions, "copy")) : self._changesForKey[keyPath], isBefore);
    }
    var ___r1, ___r2;
}
,["void","CPString","CPDictionary","BOOL"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("proxyForObject:"), function(self, _cmd, anObject)
{
    var proxy = anObject[KVOProxyKey];
    if (proxy)
        return proxy;
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithTarget:"] || _objj_forward)(___r1, "initWithTarget:", anObject));
    var ___r1;
}
,["id","CPObject"])]);
}{var the_class = objj_allocateClassPair(CPObject, "_CPKVOModelSubclass"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("willChangeValueForKey:"), function(self, _cmd, aKey)
{
    var superClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        methodSelector = sel_getUid("willChangeValueForKey:"),
        methodImp = class_getMethodImplementation(superClass, methodSelector);
    methodImp(self, methodSelector, aKey);
    if (!aKey)
        return;
    var changeOptions = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [CPKeyValueChangeSetting], [CPKeyValueChangeKindKey]));
    ((___r1 = (_CPKVOProxy.isa.method_msgSend["proxyForObject:"] || _objj_forward)(_CPKVOProxy, "proxyForObject:", self)), ___r1 == null ? null : (___r1.isa.method_msgSend["_sendNotificationsForKey:changeOptions:isBefore:"] || _objj_forward)(___r1, "_sendNotificationsForKey:changeOptions:isBefore:", aKey, changeOptions, YES));
    var ___r1;
}
,["void","CPString"]), new objj_method(sel_getUid("didChangeValueForKey:"), function(self, _cmd, aKey)
{
    var superClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        methodSelector = sel_getUid("didChangeValueForKey:"),
        methodImp = class_getMethodImplementation(superClass, methodSelector);
    methodImp(self, methodSelector, aKey);
    if (!aKey)
        return;
    ((___r1 = (_CPKVOProxy.isa.method_msgSend["proxyForObject:"] || _objj_forward)(_CPKVOProxy, "proxyForObject:", self)), ___r1 == null ? null : (___r1.isa.method_msgSend["_sendNotificationsForKey:changeOptions:isBefore:"] || _objj_forward)(___r1, "_sendNotificationsForKey:changeOptions:isBefore:", aKey, nil, NO));
    var ___r1;
}
,["void","CPString"]), new objj_method(sel_getUid("willChange:valuesAtIndexes:forKey:"), function(self, _cmd, change, indexes, aKey)
{
    var superClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        methodSelector = sel_getUid("willChange:valuesAtIndexes:forKey:"),
        methodImp = class_getMethodImplementation(superClass, methodSelector);
    methodImp(self, methodSelector, change, indexes, aKey);
    if (!aKey)
        return;
    var changeOptions = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [change, indexes], [CPKeyValueChangeKindKey, CPKeyValueChangeIndexesKey]));
    ((___r1 = (_CPKVOProxy.isa.method_msgSend["proxyForObject:"] || _objj_forward)(_CPKVOProxy, "proxyForObject:", self)), ___r1 == null ? null : (___r1.isa.method_msgSend["_sendNotificationsForKey:changeOptions:isBefore:"] || _objj_forward)(___r1, "_sendNotificationsForKey:changeOptions:isBefore:", aKey, changeOptions, YES));
    var ___r1;
}
,["void","CPKeyValueChange","CPIndexSet","CPString"]), new objj_method(sel_getUid("didChange:valuesAtIndexes:forKey:"), function(self, _cmd, change, indexes, aKey)
{
    var superClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        methodSelector = sel_getUid("didChange:valuesAtIndexes:forKey:"),
        methodImp = class_getMethodImplementation(superClass, methodSelector);
    methodImp(self, methodSelector, change, indexes, aKey);
    if (!aKey)
        return;
    ((___r1 = (_CPKVOProxy.isa.method_msgSend["proxyForObject:"] || _objj_forward)(_CPKVOProxy, "proxyForObject:", self)), ___r1 == null ? null : (___r1.isa.method_msgSend["_sendNotificationsForKey:changeOptions:isBefore:"] || _objj_forward)(___r1, "_sendNotificationsForKey:changeOptions:isBefore:", aKey, nil, NO));
    var ___r1;
}
,["void","CPKeyValueChange","CPIndexSet","CPString"]), new objj_method(sel_getUid("willChangeValueForKey:withSetMutation:usingObjects:"), function(self, _cmd, aKey, mutationKind, objects)
{
    var superClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        methodSelector = sel_getUid("willChangeValueForKey:withSetMutation:usingObjects:"),
        methodImp = class_getMethodImplementation(superClass, methodSelector);
    methodImp(self, methodSelector, aKey, mutationKind, objects);
    if (!aKey)
        return;
    var changeKind = _changeKindForSetMutationKind(mutationKind),
        changeOptions = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [changeKind], [CPKeyValueChangeKindKey]));
    changeOptions[_CPKeyValueChangeSetMutationObjectsKey] = objects;
    changeOptions[_CPKeyValueChangeSetMutationKindKey] = mutationKind;
    ((___r1 = (_CPKVOProxy.isa.method_msgSend["proxyForObject:"] || _objj_forward)(_CPKVOProxy, "proxyForObject:", self)), ___r1 == null ? null : (___r1.isa.method_msgSend["_sendNotificationsForKey:changeOptions:isBefore:"] || _objj_forward)(___r1, "_sendNotificationsForKey:changeOptions:isBefore:", aKey, changeOptions, YES));
    var ___r1;
}
,["void","CPString","CPKeyValueSetMutationKind","CPSet"]), new objj_method(sel_getUid("didChangeValueForKey:withSetMutation:usingObjects:"), function(self, _cmd, aKey, mutationKind, objects)
{
    var superClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        methodSelector = sel_getUid("didChangeValueForKey:withSetMutation:usingObjects:"),
        methodImp = class_getMethodImplementation(superClass, methodSelector);
    methodImp(self, methodSelector, aKey, mutationKind, objects);
    if (!aKey)
        return;
    ((___r1 = (_CPKVOProxy.isa.method_msgSend["proxyForObject:"] || _objj_forward)(_CPKVOProxy, "proxyForObject:", self)), ___r1 == null ? null : (___r1.isa.method_msgSend["_sendNotificationsForKey:changeOptions:isBefore:"] || _objj_forward)(___r1, "_sendNotificationsForKey:changeOptions:isBefore:", aKey, nil, NO));
    var ___r1;
}
,["void","CPString","CPKeyValueSetMutationKind","CPSet"]), new objj_method(sel_getUid("class"), function(self, _cmd)
{
    return self[KVOProxyKey]._nativeClass;
}
,["Class"]), new objj_method(sel_getUid("superclass"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["superclass"] || _objj_forward)(___r1, "superclass"));
    var ___r1;
}
,["Class"]), new objj_method(sel_getUid("isKindOfClass:"), function(self, _cmd, aClass)
{
    return ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["isSubclassOfClass:"] || _objj_forward)(___r1, "isSubclassOfClass:", aClass));
    var ___r1;
}
,["BOOL","Class"]), new objj_method(sel_getUid("isMemberOfClass:"), function(self, _cmd, aClass)
{
    return (self.isa.method_msgSend["class"] || _objj_forward)(self, "class") == aClass;
}
,["BOOL","Class"]), new objj_method(sel_getUid("className"), function(self, _cmd)
{
    return (self.isa.method_msgSend["class"] || _objj_forward)(self, "class").name;
}
,["CPString"])]);
}{var the_class = objj_allocateClassPair(CPObject, "_CPKVOModelDictionarySubclass"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("removeAllObjects"), function(self, _cmd)
{
    var keys = (self.isa.method_msgSend["allKeys"] || _objj_forward)(self, "allKeys"),
        count = (keys == null ? null : (keys.isa.method_msgSend["count"] || _objj_forward)(keys, "count")),
        i = 0;
    for (; i < count; i++)
        (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", keys[i]);
    var superClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        methodSelector = sel_getUid("removeAllObjects"),
        methodImp = class_getMethodImplementation(superClass, methodSelector);
    methodImp(self, methodSelector);
    for (i = 0; i < count; i++)
        (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", keys[i]);
}
,["void"]), new objj_method(sel_getUid("removeObjectForKey:"), function(self, _cmd, aKey)
{
    (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", aKey);
    var superClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        methodSelector = sel_getUid("removeObjectForKey:"),
        methodImp = class_getMethodImplementation(superClass, methodSelector);
    methodImp(self, methodSelector, aKey);
    (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", aKey);
}
,["void","id"]), new objj_method(sel_getUid("setObject:forKey:"), function(self, _cmd, anObject, aKey)
{
    (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", aKey);
    var superClass = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class"),
        methodSelector = sel_getUid("setObject:forKey:"),
        methodImp = class_getMethodImplementation(superClass, methodSelector);
    methodImp(self, methodSelector, anObject, aKey);
    (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", aKey);
}
,["void","id","id"])]);
}{var the_class = objj_allocateClassPair(CPObject, "_CPKVOForwardingObserver"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_object", "id"), new objj_ivar("_observer", "id"), new objj_ivar("_context", "id"), new objj_ivar("_options", "unsigned"), new objj_ivar("_firstPart", "CPString"), new objj_ivar("_secondPart", "CPString"), new objj_ivar("_value", "id")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithKeyPath:object:observer:options:context:"), function(self, _cmd, aKeyPath, anObject, anObserver, options, aContext)
{
    self = (objj_getClass("_CPKVOForwardingObserver").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    self._context = aContext;
    self._observer = anObserver;
    self._object = anObject;
    self._options = options;
    var dotIndex = aKeyPath.indexOf('.');
    if (dotIndex === CPNotFound)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Created _CPKVOForwardingObserver without compound key path: " + aKeyPath);
    self._firstPart = aKeyPath.substring(0, dotIndex);
    self._secondPart = aKeyPath.substring(dotIndex + 1);
    ((___r1 = self._object), ___r1 == null ? null : (___r1.isa.method_msgSend["addObserver:forKeyPath:options:context:"] || _objj_forward)(___r1, "addObserver:forKeyPath:options:context:", self, self._firstPart, self._options, nil));
    self._value = ((___r1 = self._object), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r1, "valueForKey:", self._firstPart));
    if (self._value)
        ((___r1 = self._value), ___r1 == null ? null : (___r1.isa.method_msgSend["addObserver:forKeyPath:options:context:"] || _objj_forward)(___r1, "addObserver:forKeyPath:options:context:", self, self._secondPart, self._options, nil));
    return self;
    var ___r1;
}
,["id","CPString","id","id","unsigned","id"]), new objj_method(sel_getUid("observeValueForKeyPath:ofObject:change:context:"), function(self, _cmd, aKeyPath, anObject, changes, aContext)
{
    if (aKeyPath === self._firstPart)
    {
        var pathChanges = (CPMutableDictionary.isa.method_msgSend["dictionaryWithObject:forKey:"] || _objj_forward)(CPMutableDictionary, "dictionaryWithObject:forKey:", CPKeyValueChangeSetting, CPKeyValueChangeKindKey);
        if (self._options & CPKeyValueObservingOptionOld)
        {
            var oldValue = ((___r1 = self._value), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(___r1, "valueForKeyPath:", self._secondPart));
            (pathChanges == null ? null : (pathChanges.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(pathChanges, "setObject:forKey:", oldValue != null ? oldValue : (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null"), CPKeyValueChangeOldKey));
        }
        if (self._options & CPKeyValueObservingOptionNew)
        {
            var newValue = ((___r1 = self._object), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(___r1, "valueForKeyPath:", self._firstPart + "." + self._secondPart));
            (pathChanges == null ? null : (pathChanges.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(pathChanges, "setObject:forKey:", newValue != null ? newValue : (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null"), CPKeyValueChangeNewKey));
        }
        ((___r1 = self._observer), ___r1 == null ? null : (___r1.isa.method_msgSend["observeValueForKeyPath:ofObject:change:context:"] || _objj_forward)(___r1, "observeValueForKeyPath:ofObject:change:context:", self._firstPart + "." + self._secondPart, self._object, pathChanges, self._context));
        if (self._value)
            ((___r1 = self._value), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObserver:forKeyPath:"] || _objj_forward)(___r1, "removeObserver:forKeyPath:", self, self._secondPart));
        self._value = ((___r1 = self._object), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r1, "valueForKey:", self._firstPart));
        if (self._value)
            ((___r1 = self._value), ___r1 == null ? null : (___r1.isa.method_msgSend["addObserver:forKeyPath:options:context:"] || _objj_forward)(___r1, "addObserver:forKeyPath:options:context:", self, self._secondPart, self._options, nil));
    }
    else
    {
        ((___r1 = self._observer), ___r1 == null ? null : (___r1.isa.method_msgSend["observeValueForKeyPath:ofObject:change:context:"] || _objj_forward)(___r1, "observeValueForKeyPath:ofObject:change:context:", self._firstPart + "." + aKeyPath, self._object, changes, self._context));
    }
    var ___r1;
}
,["void","CPString","id","CPDictionary","id"]), new objj_method(sel_getUid("finalize"), function(self, _cmd)
{
    if (self._value)
        ((___r1 = self._value), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObserver:forKeyPath:"] || _objj_forward)(___r1, "removeObserver:forKeyPath:", self, self._secondPart));
    ((___r1 = self._object), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObserver:forKeyPath:"] || _objj_forward)(___r1, "removeObserver:forKeyPath:", self, self._firstPart));
    self._object = nil;
    self._observer = nil;
    self._context = nil;
    self._value = nil;
    var ___r1;
}
,["void"])]);
}var _CPKVOInfoMake = function(anObserver, theOptions, aContext, aForwarder)
{
    return {observer: anObserver, options: theOptions, context: aContext, forwarder: aForwarder};
};
objj_executeFile("CPArray+KVO.j", YES);objj_executeFile("CPSet+KVO.j", YES);p;10;CPLocale.jt;8621;@STATIC;1.0;i;10;CPObject.jt;8587;objj_executeFile("CPObject.j", YES);CPLocaleIdentifier = "CPLocaleIdentifier";
CPLocaleLanguageCode = "CPLocaleLanguageCode";
CPLocaleCountryCode = "CPLocaleCountryCode";
CPLocaleScriptCode = "CPLocaleScriptCode";
CPLocaleVariantCode = "CPLocaleVariantCode";
CPLocaleExemplarCharacterSet = "CPLocaleExemplarCharacterSet";
CPLocaleCalendar = "CPLocaleCalendar";
CPLocaleCollationIdentifier = "CPLocaleCollationIdentifier";
CPLocaleUsesMetricSystem = "CPLocaleUsesMetricSystem";
CPLocaleMeasurementSystem = "CPLocaleMeasurementSystem";
CPLocaleDecimalSeparator = "CPLocaleDecimalSeparator";
CPLocaleGroupingSeparator = "CPLocaleGroupingSeparator";
CPLocaleCurrencySymbol = "CPLocaleCurrencySymbol";
CPLocaleCurrencyCode = "CPLocaleCurrencyCode";
CPLocaleCollatorIdentifier = "CPLocaleCollatorIdentifier";
CPLocaleQuotationBeginDelimiterKey = "CPLocaleQuotationBeginDelimiterKey";
CPLocaleQuotationEndDelimiterKey = "CPLocaleQuotationEndDelimiterKey";
CPLocaleAlternateQuotationBeginDelimiterKey = "CPLocaleAlternateQuotationBeginDelimiterKey";
CPLocaleAlternateQuotationEndDelimiterKey = "CPLocaleAlternateQuotationEndDelimiterKey";
CPGregorianCalendar = "CPGregorianCalendar";
CPBuddhistCalendar = "CPBuddhistCalendar";
CPChineseCalendar = "CPChineseCalendar";
CPHebrewCalendar = "CPHebrewCalendar";
CPIslamicCalendar = "CPIslamicCalendar";
CPIslamicCivilCalendar = "CPIslamicCivilCalendar";
CPJapaneseCalendar = "CPJapaneseCalendar";
CPRepublicOfChinaCalendar = "CPRepublicOfChinaCalendar";
CPPersianCalendar = "CPPersianCalendar";
CPIndianCalendar = "CPIndianCalendar";
CPISO8601Calendar = "CPISO8601Calendar";
CPLocaleLanguageDirectionUnknown = "CPLocaleLanguageDirectionUnknown";
CPLocaleLanguageDirectionLeftToRight = "CPLocaleLanguageDirectionLeftToRight";
CPLocaleLanguageDirectionRightToLeft = "CPLocaleLanguageDirectionRightToLeft";
CPLocaleLanguageDirectionTopToBottom = "CPLocaleLanguageDirectionTopToBottom";
CPLocaleLanguageDirectionBottomToTop = "CPLocaleLanguageDirectionBottomToTop";
var countryCodes = ["DE", "FR", "ES", "GB", "US"],
    languageCodes = ["en", "de", "es", "fr"],
    availableLocaleIdentifiers = ["de_DE", "en_GB", "en_US", "es_ES", "fr_FR"];
var sharedSystemLocale = nil,
    sharedCurrentLocale = nil;
{var the_class = objj_allocateClassPair(CPObject, "CPLocale"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_locale", "CPDictionary")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithLocaleIdentifier:"), function(self, _cmd, anIdentifier)
{
    if (self == (objj_getClass("CPLocale").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        var parts = (anIdentifier == null ? null : (anIdentifier.isa.method_msgSend["componentsSeparatedByString:"] || _objj_forward)(anIdentifier, "componentsSeparatedByString:", "_")),
            language = (parts == null ? null : (parts.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(parts, "objectAtIndex:", 0)),
            country = nil;
        if ((parts == null ? null : (parts.isa.method_msgSend["count"] || _objj_forward)(parts, "count")) > 1)
            country = (parts == null ? null : (parts.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(parts, "objectAtIndex:", 1));
        else
            country = anIdentifier;
        self._locale = ((___r1 = (CPDictionary == null ? null : (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", anIdentifier, CPLocaleIdentifier));
        ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", language, CPLocaleLanguageCode));
        ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", country, CPLocaleCountryCode));
        if (((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("_platformLocaleAdditionalDescriptionForIdentifier:"))))
        {
            var info = ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["performSelector:withObject:"] || _objj_forward)(___r1, "performSelector:withObject:", sel_getUid("_platformLocaleAdditionalDescriptionForIdentifier:"), anIdentifier));
            ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["addEntriesFromDictionary:"] || _objj_forward)(___r1, "addEntriesFromDictionary:", info));
        }
        else
        {
            ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", CPGregorianCalendar, CPLocaleCalendar));
        }
    }
    return self;
    var ___r1;
}
,["id","CPString"]), new objj_method(sel_getUid("localeIdentifier"), function(self, _cmd)
{
    return ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPLocaleIdentifier));
    var ___r1;
}
,["CPString"]), new objj_method(sel_getUid("objectForKey:"), function(self, _cmd, aKey)
{
    return ((___r1 = self._locale), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aKey));
    var ___r1;
}
,["id","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("systemLocale"), function(self, _cmd)
{
    if (!sharedSystemLocale)
        sharedSystemLocale = ((___r1 = (CPLocale.isa.method_msgSend["alloc"] || _objj_forward)(CPLocale, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithLocaleIdentifier:"] || _objj_forward)(___r1, "initWithLocaleIdentifier:", "en_US"));
    return sharedSystemLocale;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("currentLocale"), function(self, _cmd)
{
    if (!sharedCurrentLocale)
    {
        var localeIdentifier = "en_US",
            language;
        if (typeof navigator !== "undefined")
        {
            language = typeof navigator.language !== "undefined" ? navigator.language : navigator.userLanguage;
            if (language)
            {
                language = (language.replace("-", "_")).substring(0, 5);
                language = (language.substring(0, 3)).toLowerCase() + (language.substring(3, 5)).toUpperCase();
                if ((availableLocaleIdentifiers == null ? null : (availableLocaleIdentifiers.isa.method_msgSend["indexOfObject:"] || _objj_forward)(availableLocaleIdentifiers, "indexOfObject:", language)) !== CPNotFound)
                    localeIdentifier = language;
            }
        }
        sharedCurrentLocale = ((___r1 = (CPLocale.isa.method_msgSend["alloc"] || _objj_forward)(CPLocale, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithLocaleIdentifier:"] || _objj_forward)(___r1, "initWithLocaleIdentifier:", localeIdentifier));
    }
    return sharedCurrentLocale;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("availableLocaleIdentifiers"), function(self, _cmd)
{
    return availableLocaleIdentifiers;
}
,["CPArray"]), new objj_method(sel_getUid("ISOCountryCodes"), function(self, _cmd)
{
    return countryCodes;
}
,["CPArray"]), new objj_method(sel_getUid("ISOLanguageCodes"), function(self, _cmd)
{
    return languageCodes;
}
,["CPArray"])]);
}var CPLocaleIdentifierLocaleKey = "CPLocaleIdentifierLocaleKey";
{
var the_class = objj_getClass("CPLocale")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPLocale\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    if (self)
    {
        self._locale = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPLocaleIdentifierLocaleKey));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._locale, CPLocaleIdentifierLocaleKey));
}
,["void","CPCoder"])]);
}p;7;CPLog.jt;19;@STATIC;1.0;t;3;1;
p;16;CPNotification.jt;2422;@STATIC;1.0;i;13;CPException.ji;10;CPObject.ji;14;CPDictionary.jt;2351;objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPDictionary.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPNotification"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_name", "CPString"), new objj_ivar("_object", "id"), new objj_ivar("_userInfo", "CPDictionary")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPUnsupportedMethodException, "CPNotification's init method should not be used");
}
,["id"]), new objj_method(sel_getUid("initWithName:object:userInfo:"), function(self, _cmd, aNotificationName, anObject, aUserInfo)
{
    self = (objj_getClass("CPNotification").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._name = aNotificationName;
        self._object = anObject;
        self._userInfo = aUserInfo;
    }
    return self;
}
,["id","CPString","id","CPDictionary"]), new objj_method(sel_getUid("name"), function(self, _cmd)
{
    return self._name;
}
,["CPString"]), new objj_method(sel_getUid("object"), function(self, _cmd)
{
    return self._object;
}
,["id"]), new objj_method(sel_getUid("userInfo"), function(self, _cmd)
{
    return self._userInfo;
}
,["CPDictionary"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("notificationWithName:object:userInfo:"), function(self, _cmd, aNotificationName, anObject, aUserInfo)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithName:object:userInfo:"] || _objj_forward)(___r1, "initWithName:object:userInfo:", aNotificationName, anObject, aUserInfo));
    var ___r1;
}
,["CPNotification","CPString","id","CPDictionary"]), new objj_method(sel_getUid("notificationWithName:object:"), function(self, _cmd, aNotificationName, anObject)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithName:object:userInfo:"] || _objj_forward)(___r1, "initWithName:object:userInfo:", aNotificationName, anObject, nil));
    var ___r1;
}
,["CPNotification","CPString","id"])]);
}p;22;CPNotificationCenter.jt;20618;@STATIC;1.0;i;9;CPArray.ji;14;CPDictionary.ji;13;CPException.ji;16;CPNotification.ji;8;CPNull.ji;18;CPOperationQueue.ji;13;CPOperation.ji;7;CPSet.jt;20463;objj_executeFile("CPArray.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPNotification.j", YES);objj_executeFile("CPNull.j", YES);objj_executeFile("CPOperationQueue.j", YES);objj_executeFile("CPOperation.j", YES);objj_executeFile("CPSet.j", YES);var CPNotificationDefaultCenter = nil;
{var the_class = objj_allocateClassPair(CPObject, "CPNotificationCenter"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_namedRegistries", "CPMutableDictionary"), new objj_ivar("_unnamedRegistry", "_CPNotificationRegistry")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPNotificationCenter").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._namedRegistries = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._unnamedRegistry = ((___r1 = (_CPNotificationRegistry == null ? null : (_CPNotificationRegistry.isa.method_msgSend["alloc"] || _objj_forward)(_CPNotificationRegistry, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    }
    return self;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("addObserver:selector:name:object:"), function(self, _cmd, anObserver, aSelector, aNotificationName, anObject)
{
    var registry = (self.isa.method_msgSend["_registryForNotificationName:"] || _objj_forward)(self, "_registryForNotificationName:", aNotificationName),
        observer = ((___r1 = (_CPNotificationObserver == null ? null : (_CPNotificationObserver.isa.method_msgSend["alloc"] || _objj_forward)(_CPNotificationObserver, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObserver:selector:"] || _objj_forward)(___r1, "initWithObserver:selector:", anObserver, aSelector));
    (registry == null ? null : (registry.isa.method_msgSend["addObserver:object:"] || _objj_forward)(registry, "addObserver:object:", observer, anObject));
    var ___r1;
}
,["void","id","SEL","CPString","id"]), new objj_method(sel_getUid("addObserverForName:object:queue:usingBlock:"), function(self, _cmd, aNotificationName, anObject, queue, block)
{
    var registry = (self.isa.method_msgSend["_registryForNotificationName:"] || _objj_forward)(self, "_registryForNotificationName:", aNotificationName),
        observer = ((___r1 = (_CPNotificationObserver == null ? null : (_CPNotificationObserver.isa.method_msgSend["alloc"] || _objj_forward)(_CPNotificationObserver, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithBlock:queue:"] || _objj_forward)(___r1, "initWithBlock:queue:", block, queue));
    (registry == null ? null : (registry.isa.method_msgSend["addObserver:object:"] || _objj_forward)(registry, "addObserver:object:", observer, anObject));
    return observer;
    var ___r1;
}
,["id","CPString","id","CPOperationQueue","Function"]), new objj_method(sel_getUid("_registryForNotificationName:"), function(self, _cmd, aNotificationName)
{
    var registry;
    if (aNotificationName == nil)
        registry = self._unnamedRegistry;
    else if (!(registry = ((___r1 = self._namedRegistries), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aNotificationName))))
    {
        registry = ((___r1 = (_CPNotificationRegistry == null ? null : (_CPNotificationRegistry.isa.method_msgSend["alloc"] || _objj_forward)(_CPNotificationRegistry, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        ((___r1 = self._namedRegistries), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", registry, aNotificationName));
    }
    return registry;
    var ___r1;
}
,["_CPNotificationRegistry","CPString"]), new objj_method(sel_getUid("removeObserver:"), function(self, _cmd, anObserver)
{
    var name = nil,
        names = ((___r1 = self._namedRegistries), ___r1 == null ? null : (___r1.isa.method_msgSend["keyEnumerator"] || _objj_forward)(___r1, "keyEnumerator"));
    while ((name = (names == null ? null : (names.isa.method_msgSend["nextObject"] || _objj_forward)(names, "nextObject"))) !== nil)
        ((___r1 = ((___r2 = self._namedRegistries), ___r2 == null ? null : (___r2.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r2, "objectForKey:", name))), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObserver:object:"] || _objj_forward)(___r1, "removeObserver:object:", anObserver, nil));
    ((___r1 = self._unnamedRegistry), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObserver:object:"] || _objj_forward)(___r1, "removeObserver:object:", anObserver, nil));
    var ___r1, ___r2;
}
,["void","id"]), new objj_method(sel_getUid("removeObserver:name:object:"), function(self, _cmd, anObserver, aNotificationName, anObject)
{
    if (aNotificationName == nil)
    {
        var name = nil,
            names = ((___r1 = self._namedRegistries), ___r1 == null ? null : (___r1.isa.method_msgSend["keyEnumerator"] || _objj_forward)(___r1, "keyEnumerator"));
        while ((name = (names == null ? null : (names.isa.method_msgSend["nextObject"] || _objj_forward)(names, "nextObject"))) !== nil)
            ((___r1 = ((___r2 = self._namedRegistries), ___r2 == null ? null : (___r2.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r2, "objectForKey:", name))), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObserver:object:"] || _objj_forward)(___r1, "removeObserver:object:", anObserver, anObject));
        ((___r1 = self._unnamedRegistry), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObserver:object:"] || _objj_forward)(___r1, "removeObserver:object:", anObserver, anObject));
    }
    else
        ((___r1 = ((___r2 = self._namedRegistries), ___r2 == null ? null : (___r2.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r2, "objectForKey:", aNotificationName))), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObserver:object:"] || _objj_forward)(___r1, "removeObserver:object:", anObserver, anObject));
    var ___r1, ___r2;
}
,["void","id","CPString","id"]), new objj_method(sel_getUid("postNotification:"), function(self, _cmd, aNotification)
{
    if (!aNotification)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "postNotification: does not except 'nil' notifications");
    _CPNotificationCenterPostNotification(self, aNotification);
}
,["void","CPNotification"]), new objj_method(sel_getUid("postNotificationName:object:userInfo:"), function(self, _cmd, aNotificationName, anObject, aUserInfo)
{
    _CPNotificationCenterPostNotification(self, ((___r1 = (CPNotification.isa.method_msgSend["alloc"] || _objj_forward)(CPNotification, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithName:object:userInfo:"] || _objj_forward)(___r1, "initWithName:object:userInfo:", aNotificationName, anObject, aUserInfo)));
    var ___r1;
}
,["void","CPString","id","CPDictionary"]), new objj_method(sel_getUid("postNotificationName:object:"), function(self, _cmd, aNotificationName, anObject)
{
    _CPNotificationCenterPostNotification(self, ((___r1 = (CPNotification.isa.method_msgSend["alloc"] || _objj_forward)(CPNotification, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithName:object:userInfo:"] || _objj_forward)(___r1, "initWithName:object:userInfo:", aNotificationName, anObject, nil)));
    var ___r1;
}
,["void","CPString","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("defaultCenter"), function(self, _cmd)
{
    if (!CPNotificationDefaultCenter)
        CPNotificationDefaultCenter = ((___r1 = (CPNotificationCenter.isa.method_msgSend["alloc"] || _objj_forward)(CPNotificationCenter, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    return CPNotificationDefaultCenter;
    var ___r1;
}
,["CPNotificationCenter"])]);
}var _CPNotificationCenterPostNotification = function(self, aNotification)
{
    ((___r1 = self._unnamedRegistry), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotification:"] || _objj_forward)(___r1, "postNotification:", aNotification));
    ((___r1 = ((___r2 = self._namedRegistries), ___r2 == null ? null : (___r2.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r2, "objectForKey:", (aNotification == null ? null : (aNotification.isa.method_msgSend["name"] || _objj_forward)(aNotification, "name"))))), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotification:"] || _objj_forward)(___r1, "postNotification:", aNotification));
    var ___r1, ___r2;
};
{var the_class = objj_allocateClassPair(CPObject, "_CPNotificationRegistry"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_objectObservers", "CPDictionary")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("_CPNotificationRegistry").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._objectObservers = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    }
    return self;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("addObserver:object:"), function(self, _cmd, anObserver, anObject)
{
    if (!anObject)
        anObject = (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null");
    var observers = ((___r1 = self._objectObservers), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", (anObject == null ? null : (anObject.isa.method_msgSend["UID"] || _objj_forward)(anObject, "UID"))));
    if (!observers)
    {
        observers = (CPMutableSet.isa.method_msgSend["set"] || _objj_forward)(CPMutableSet, "set");
        ((___r1 = self._objectObservers), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", observers, (anObject == null ? null : (anObject.isa.method_msgSend["UID"] || _objj_forward)(anObject, "UID"))));
    }
    (observers == null ? null : (observers.isa.method_msgSend["addObject:"] || _objj_forward)(observers, "addObject:", anObserver));
    var ___r1;
}
,["void","_CPNotificationObserver","id"]), new objj_method(sel_getUid("removeObserver:object:"), function(self, _cmd, anObserver, anObject)
{
    var removedKeys = [];
    if (anObject == nil)
    {
        var key = nil,
            keys = ((___r1 = self._objectObservers), ___r1 == null ? null : (___r1.isa.method_msgSend["keyEnumerator"] || _objj_forward)(___r1, "keyEnumerator"));
        while ((key = (keys == null ? null : (keys.isa.method_msgSend["nextObject"] || _objj_forward)(keys, "nextObject"))) !== nil)
        {
            var observers = ((___r1 = self._objectObservers), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", key)),
                observer = nil,
                observersEnumerator = (observers == null ? null : (observers.isa.method_msgSend["objectEnumerator"] || _objj_forward)(observers, "objectEnumerator"));
            while ((observer = (observersEnumerator == null ? null : (observersEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(observersEnumerator, "nextObject"))) !== nil)
                if ((observer == null ? null : (observer.isa.method_msgSend["observer"] || _objj_forward)(observer, "observer")) == anObserver || (observer == null ? null : (observer.isa.method_msgSend["block"] || _objj_forward)(observer, "block")) && (anObserver == null ? null : (anObserver.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(anObserver, "respondsToSelector:", sel_getUid("block"))) && (observer == null ? null : (observer.isa.method_msgSend["block"] || _objj_forward)(observer, "block")) == (anObserver == null ? null : (anObserver.isa.method_msgSend["block"] || _objj_forward)(anObserver, "block")))
                    (observers == null ? null : (observers.isa.method_msgSend["removeObject:"] || _objj_forward)(observers, "removeObject:", observer));
            if (!(observers == null ? null : (observers.isa.method_msgSend["count"] || _objj_forward)(observers, "count")))
                removedKeys.push(key);
        }
    }
    else
    {
        var key = (anObject == null ? null : (anObject.isa.method_msgSend["UID"] || _objj_forward)(anObject, "UID")),
            observers = ((___r1 = self._objectObservers), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", key)),
            observer = nil,
            observersEnumerator = (observers == null ? null : (observers.isa.method_msgSend["objectEnumerator"] || _objj_forward)(observers, "objectEnumerator"));
        while ((observer = (observersEnumerator == null ? null : (observersEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(observersEnumerator, "nextObject"))) !== nil)
            if ((observer == null ? null : (observer.isa.method_msgSend["observer"] || _objj_forward)(observer, "observer")) == anObserver || (observer == null ? null : (observer.isa.method_msgSend["block"] || _objj_forward)(observer, "block")) && (anObserver == null ? null : (anObserver.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(anObserver, "respondsToSelector:", sel_getUid("block"))) && (observer == null ? null : (observer.isa.method_msgSend["block"] || _objj_forward)(observer, "block")) == (anObserver == null ? null : (anObserver.isa.method_msgSend["block"] || _objj_forward)(anObserver, "block")))
                (observers == null ? null : (observers.isa.method_msgSend["removeObject:"] || _objj_forward)(observers, "removeObject:", observer));
        if (!(observers == null ? null : (observers.isa.method_msgSend["count"] || _objj_forward)(observers, "count")))
            removedKeys.push(key);
    }
    var count = removedKeys.length;
    while (count--)
        ((___r1 = self._objectObservers), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(___r1, "removeObjectForKey:", removedKeys[count]));
    var ___r1;
}
,["void","id","id"]), new objj_method(sel_getUid("postNotification:"), function(self, _cmd, aNotification)
{
    var object = (aNotification == null ? null : (aNotification.isa.method_msgSend["object"] || _objj_forward)(aNotification, "object")),
        currentObservers = nil;
    if (object != nil && (currentObservers = ((___r1 = self._objectObservers), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", (object == null ? null : (object.isa.method_msgSend["UID"] || _objj_forward)(object, "UID"))))))
    {
        var observers = (currentObservers == null ? null : (currentObservers.isa.method_msgSend["copy"] || _objj_forward)(currentObservers, "copy")),
            observer = nil,
            observersEnumerator = (observers == null ? null : (observers.isa.method_msgSend["objectEnumerator"] || _objj_forward)(observers, "objectEnumerator"));
        while ((observer = (observersEnumerator == null ? null : (observersEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(observersEnumerator, "nextObject"))) !== nil)
        {
            if ((currentObservers == null ? null : (currentObservers.isa.method_msgSend["containsObject:"] || _objj_forward)(currentObservers, "containsObject:", observer)))
                (observer == null ? null : (observer.isa.method_msgSend["postNotification:"] || _objj_forward)(observer, "postNotification:", aNotification));
        }
    }
    currentObservers = ((___r1 = self._objectObservers), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", ((___r2 = (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null")), ___r2 == null ? null : (___r2.isa.method_msgSend["UID"] || _objj_forward)(___r2, "UID"))));
    if (!currentObservers)
        return;
    var observers = (currentObservers == null ? null : (currentObservers.isa.method_msgSend["copy"] || _objj_forward)(currentObservers, "copy")),
        observersEnumerator = (observers == null ? null : (observers.isa.method_msgSend["objectEnumerator"] || _objj_forward)(observers, "objectEnumerator"));
    while ((observer = (observersEnumerator == null ? null : (observersEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(observersEnumerator, "nextObject"))) !== nil)
    {
        if ((currentObservers == null ? null : (currentObservers.isa.method_msgSend["containsObject:"] || _objj_forward)(currentObservers, "containsObject:", observer)))
            (observer == null ? null : (observer.isa.method_msgSend["postNotification:"] || _objj_forward)(observer, "postNotification:", aNotification));
    }
    var ___r1, ___r2;
}
,["void","CPNotification"]), new objj_method(sel_getUid("count"), function(self, _cmd)
{
    return ((___r1 = self._objectObservers), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
    var ___r1;
}
,["unsigned"])]);
}{var the_class = objj_allocateClassPair(CPObject, "_CPNotificationObserver"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_operationQueue", "CPOperationQueue"), new objj_ivar("_observer", "id"), new objj_ivar("_block", "Function"), new objj_ivar("_selector", "SEL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithObserver:selector:"), function(self, _cmd, anObserver, aSelector)
{
    if (self)
    {
        self._observer = anObserver;
        self._selector = aSelector;
    }
    return self;
}
,["id","id","SEL"]), new objj_method(sel_getUid("initWithBlock:queue:"), function(self, _cmd, aBlock, aQueue)
{
    if (self)
    {
        self._block = aBlock;
        self._operationQueue = aQueue;
    }
    return self;
}
,["id","Function","CPOperationQueue"]), new objj_method(sel_getUid("observer"), function(self, _cmd)
{
    return self._observer;
}
,["id"]), new objj_method(sel_getUid("block"), function(self, _cmd)
{
    return self._block;
}
,["id"]), new objj_method(sel_getUid("postNotification:"), function(self, _cmd, aNotification)
{
    if (self._block)
    {
        if (!self._operationQueue)
            self._block(aNotification);
        else
            ((___r1 = self._operationQueue), ___r1 == null ? null : (___r1.isa.method_msgSend["addOperation:"] || _objj_forward)(___r1, "addOperation:", ((___r2 = (_CPNotificationObserverOperation == null ? null : (_CPNotificationObserverOperation.isa.method_msgSend["alloc"] || _objj_forward)(_CPNotificationObserverOperation, "alloc"))), ___r2 == null ? null : (___r2.isa.method_msgSend["initWithBlock:notification:"] || _objj_forward)(___r2, "initWithBlock:notification:", self._block, aNotification))));
        return;
    }
    ((___r1 = self._observer), ___r1 == null ? null : (___r1.isa.method_msgSend["performSelector:withObject:"] || _objj_forward)(___r1, "performSelector:withObject:", self._selector, aNotification));
    var ___r1, ___r2;
}
,["void","CPNotification"])]);
}{var the_class = objj_allocateClassPair(CPOperation, "_CPNotificationObserverOperation"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_notification", "CPNotification"), new objj_ivar("_block", "Function")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithBlock:notification:"), function(self, _cmd, aBlock, aNotification)
{
    self = (objj_getClass("_CPNotificationObserverOperation").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._block = aBlock;
        self._notification = aNotification;
    }
    return self;
}
,["id","Function","CPNotification"]), new objj_method(sel_getUid("main"), function(self, _cmd)
{
    self._block(self._notification);
}
,["void"]), new objj_method(sel_getUid("isReady"), function(self, _cmd)
{
    return YES;
}
,["BOOL"])]);
}p;21;CPNotificationQueue.jt;11195;@STATIC;1.0;i;10;CPObject.ji;16;CPNotification.ji;22;CPNotificationCenter.jt;11112;objj_executeFile("CPObject.j", YES);objj_executeFile("CPNotification.j", YES);objj_executeFile("CPNotificationCenter.j", YES);{var the_typedef = objj_allocateTypeDef("CPPostingStyle");
objj_registerTypeDef(the_typedef);
}CPPostWhenIdle = 1;
CPPostASAP = 2;
CPPostNow = 3;
{var the_typedef = objj_allocateTypeDef("CPNotificationCoalescing");
objj_registerTypeDef(the_typedef);
}CPNotificationNoCoalescing = 1 << 0;
CPNotificationCoalescingOnName = 1 << 1;
CPNotificationCoalescingOnSender = 1 << 2;
var CPNotificationDefaultQueue;
var runLoop = (CPRunLoop.isa.method_msgSend["mainRunLoop"] || _objj_forward)(CPRunLoop, "mainRunLoop");
{var the_class = objj_allocateClassPair(CPObject, "CPNotificationQueue"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_runLoopLaunched", "BOOL"), new objj_ivar("_postNowNotifications", "CPMutableArray"), new objj_ivar("_postIdleNotifications", "CPMutableArray"), new objj_ivar("_postASAPNotifications", "CPMutableArray"), new objj_ivar("_notificationCenter", "CPNotificationCenter")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithNotificationCenter:"), function(self, _cmd, aNotificationCenter)
{
    if (self = (objj_getClass("CPNotificationQueue").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._notificationCenter = aNotificationCenter;
        self._postNowNotifications = (CPMutableArray.isa.method_msgSend["new"] || _objj_forward)(CPMutableArray, "new");
        self._postIdleNotifications = (CPMutableArray.isa.method_msgSend["new"] || _objj_forward)(CPMutableArray, "new");
        self._postASAPNotifications = (CPMutableArray.isa.method_msgSend["new"] || _objj_forward)(CPMutableArray, "new");
    }
    return self;
}
,["id","CPNotificationCenter"]), new objj_method(sel_getUid("enqueueNotification:postingStyle:"), function(self, _cmd, notification, postingStyle)
{
    (self.isa.method_msgSend["enqueueNotification:postingStyle:coalesceMask:forModes:"] || _objj_forward)(self, "enqueueNotification:postingStyle:coalesceMask:forModes:", notification, postingStyle, CPNotificationCoalescingOnName | CPNotificationCoalescingOnSender, [CPDefaultRunLoopMode]);
}
,["void","CPNotification","CPPostingStyle"]), new objj_method(sel_getUid("enqueueNotification:postingStyle:coalesceMask:forModes:"), function(self, _cmd, notification, postingStyle, coalesceMask, modes)
{
    (self.isa.method_msgSend["_removeNotification:coalesceMask:"] || _objj_forward)(self, "_removeNotification:coalesceMask:", notification, coalesceMask);
    switch(postingStyle) {
    case CPPostWhenIdle:
        ((___r1 = self._postIdleNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", notification));
        break;
    case CPPostASAP:
        ((___r1 = self._postASAPNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", notification));
        break;
    case CPPostNow:
        ((___r1 = self._postNowNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", notification));
        break;
    }
    if (((___r1 = self._postIdleNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")) || ((___r1 = self._postASAPNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")) || ((___r1 = self._postNowNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")))
        (self.isa.method_msgSend["_runRunLoop"] || _objj_forward)(self, "_runRunLoop");
    if (postingStyle == CPPostNow)
    {
        for (var i = (modes == null ? null : (modes.isa.method_msgSend["count"] || _objj_forward)(modes, "count")) - 1; i >= 0; i--)
            ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["limitDateForMode:"] || _objj_forward)(___r1, "limitDateForMode:", modes[i]));
    }
    var ___r1;
}
,["void","CPNotification","CPPostingStyle","CPNotificationCoalescing","CPArray"]), new objj_method(sel_getUid("dequeueNotificationsMatching:coalesceMask:"), function(self, _cmd, notification, coalesceMask)
{
    (self.isa.method_msgSend["_removeNotification:coalesceMask:"] || _objj_forward)(self, "_removeNotification:coalesceMask:", notification, coalesceMask);
}
,["void","CPNotification","CPUInteger"]), new objj_method(sel_getUid("_runRunLoop"), function(self, _cmd)
{
    if (!self._runLoopLaunched)
    {
        (runLoop == null ? null : (runLoop.isa.method_msgSend["performSelector:target:argument:order:modes:"] || _objj_forward)(runLoop, "performSelector:target:argument:order:modes:", sel_getUid("_launchNotificationsInQueue"), self, nil, 0, [CPDefaultRunLoopMode]));
        self._runLoopLaunched = YES;
    }
}
,["void"]), new objj_method(sel_getUid("_launchNotificationsInQueue"), function(self, _cmd)
{
    self._runLoopLaunched = NO;
    if (((___r1 = self._postNowNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")))
    {
        (self.isa.method_msgSend["_launchNotificationsForArray:"] || _objj_forward)(self, "_launchNotificationsForArray:", self._postNowNotifications);
        (self.isa.method_msgSend["_runRunLoop"] || _objj_forward)(self, "_runRunLoop");
        return;
    }
    if (((___r1 = self._postASAPNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")))
    {
        (self.isa.method_msgSend["_launchNotificationsForArray:"] || _objj_forward)(self, "_launchNotificationsForArray:", self._postASAPNotifications);
        (self.isa.method_msgSend["_runRunLoop"] || _objj_forward)(self, "_runRunLoop");
        return;
    }
    if (((___r1 = self._postIdleNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")))
    {
        (self.isa.method_msgSend["_launchNotificationsForArray:"] || _objj_forward)(self, "_launchNotificationsForArray:", self._postIdleNotifications);
        (self.isa.method_msgSend["_runRunLoop"] || _objj_forward)(self, "_runRunLoop");
        return;
    }
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("_launchNotificationsForArray:"), function(self, _cmd, anArray)
{
    for (var i = (anArray == null ? null : (anArray.isa.method_msgSend["count"] || _objj_forward)(anArray, "count")) - 1; i >= 0; i--)
    {
        var notification = anArray[i];
        ((___r1 = self._notificationCenter), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotification:"] || _objj_forward)(___r1, "postNotification:", notification));
    }
    (anArray == null ? null : (anArray.isa.method_msgSend["removeAllObjects"] || _objj_forward)(anArray, "removeAllObjects"));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("_removeNotification:coalesceMask:"), function(self, _cmd, notification, coalesceMask)
{
    (self.isa.method_msgSend["_removeNotification:coalesceMask:inNotifications:"] || _objj_forward)(self, "_removeNotification:coalesceMask:inNotifications:", notification, coalesceMask, self._postNowNotifications);
    (self.isa.method_msgSend["_removeNotification:coalesceMask:inNotifications:"] || _objj_forward)(self, "_removeNotification:coalesceMask:inNotifications:", notification, coalesceMask, self._postASAPNotifications);
    (self.isa.method_msgSend["_removeNotification:coalesceMask:inNotifications:"] || _objj_forward)(self, "_removeNotification:coalesceMask:inNotifications:", notification, coalesceMask, self._postIdleNotifications);
}
,["void","CPNotification","CPUInteger"]), new objj_method(sel_getUid("_removeNotification:coalesceMask:inNotifications:"), function(self, _cmd, aNotification, coalesceMask, notifications)
{
    var notificationsToRemove = [],
        name = (aNotification == null ? null : (aNotification.isa.method_msgSend["name"] || _objj_forward)(aNotification, "name")),
        sender = (aNotification == null ? null : (aNotification.isa.method_msgSend["object"] || _objj_forward)(aNotification, "object"));
    for (var i = (notifications == null ? null : (notifications.isa.method_msgSend["count"] || _objj_forward)(notifications, "count")) - 1; i >= 0; i--)
    {
        var notification = notifications[i];
        if (notification == aNotification)
        {
            (notificationsToRemove == null ? null : (notificationsToRemove.isa.method_msgSend["addObject:"] || _objj_forward)(notificationsToRemove, "addObject:", notification));
            continue;
        }
        if (coalesceMask & CPNotificationNoCoalescing)
            continue;
        if (coalesceMask & CPNotificationCoalescingOnName && coalesceMask & CPNotificationCoalescingOnSender)
        {
            if ((notification == null ? null : (notification.isa.method_msgSend["object"] || _objj_forward)(notification, "object")) == sender && (notification == null ? null : (notification.isa.method_msgSend["name"] || _objj_forward)(notification, "name")) == name)
                (notificationsToRemove == null ? null : (notificationsToRemove.isa.method_msgSend["addObject:"] || _objj_forward)(notificationsToRemove, "addObject:", notification));
            continue;
        }
        if (coalesceMask & CPNotificationCoalescingOnName)
        {
            if ((notification == null ? null : (notification.isa.method_msgSend["name"] || _objj_forward)(notification, "name")) == name)
                (notificationsToRemove == null ? null : (notificationsToRemove.isa.method_msgSend["addObject:"] || _objj_forward)(notificationsToRemove, "addObject:", notification));
            continue;
        }
        if (coalesceMask & CPNotificationCoalescingOnSender)
        {
            if ((notification == null ? null : (notification.isa.method_msgSend["object"] || _objj_forward)(notification, "object")) == sender)
                (notificationsToRemove == null ? null : (notificationsToRemove.isa.method_msgSend["addObject:"] || _objj_forward)(notificationsToRemove, "addObject:", notification));
            continue;
        }
    }
    (notifications == null ? null : (notifications.isa.method_msgSend["removeObjectsInArray:"] || _objj_forward)(notifications, "removeObjectsInArray:", notificationsToRemove));
}
,["void","CPNotification","CPUInteger","CPArray"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("defaultQueue"), function(self, _cmd)
{
    if (!CPNotificationDefaultQueue)
        CPNotificationDefaultQueue = ((___r1 = (CPNotificationQueue.isa.method_msgSend["alloc"] || _objj_forward)(CPNotificationQueue, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithNotificationCenter:"] || _objj_forward)(___r1, "initWithNotificationCenter:", (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter")));
    return CPNotificationDefaultQueue;
    var ___r1;
}
,["id"])]);
}p;8;CPNull.jt;1260;@STATIC;1.0;i;10;CPObject.jt;1226;objj_executeFile("CPObject.j", YES);var CPNullSharedNull = nil;
{var the_class = objj_allocateClassPair(CPObject, "CPNull"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    if (self === anObject)
        return YES;
    return (anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", (CPNull.isa.method_msgSend["class"] || _objj_forward)(CPNull, "class")));
}
,["BOOL","id"]), new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    return (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null");
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
}
,["void","CPCoder"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("null"), function(self, _cmd)
{
    if (!CPNullSharedNull)
        CPNullSharedNull = ((___r1 = (CPNull.isa.method_msgSend["alloc"] || _objj_forward)(CPNull, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    return CPNullSharedNull;
    var ___r1;
}
,["CPNull"])]);
}p;10;CPNumber.jt;8175;@STATIC;1.0;i;13;CPException.ji;8;CPNull.ji;10;CPObject.ji;15;CPObjJRuntime.jt;8091;objj_executeFile("CPException.j", YES);objj_executeFile("CPNull.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPObjJRuntime.j", YES);var CPNumberUIDs = new CFMutableDictionary();
{var the_class = objj_allocateClassPair(CPObject, "CPNumber"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithBool:"), function(self, _cmd, aBoolean)
{
    return aBoolean;
}
,["id","BOOL"]), new objj_method(sel_getUid("initWithChar:"), function(self, _cmd, aChar)
{
    if (aChar.charCodeAt)
        return aChar.charCodeAt(0);
    return aChar;
}
,["id","char"]), new objj_method(sel_getUid("initWithDouble:"), function(self, _cmd, aDouble)
{
    return aDouble;
}
,["id","double"]), new objj_method(sel_getUid("initWithFloat:"), function(self, _cmd, aFloat)
{
    return aFloat;
}
,["id","float"]), new objj_method(sel_getUid("initWithInt:"), function(self, _cmd, anInt)
{
    return anInt;
}
,["id","int"]), new objj_method(sel_getUid("initWithLong:"), function(self, _cmd, aLong)
{
    return aLong;
}
,["id","long"]), new objj_method(sel_getUid("initWithLongLong:"), function(self, _cmd, aLongLong)
{
    return aLongLong;
}
,["id","long long"]), new objj_method(sel_getUid("initWithShort:"), function(self, _cmd, aShort)
{
    return aShort;
}
,["id","short"]), new objj_method(sel_getUid("initWithUnsignedChar:"), function(self, _cmd, aChar)
{
    if (aChar.charCodeAt)
        return aChar.charCodeAt(0);
    return aChar;
}
,["id","unsigned char"]), new objj_method(sel_getUid("initWithUnsignedInt:"), function(self, _cmd, anUnsignedInt)
{
    return anUnsignedInt;
}
,["id","unsigned"]), new objj_method(sel_getUid("initWithUnsignedLong:"), function(self, _cmd, anUnsignedLong)
{
    return anUnsignedLong;
}
,["id","unsigned long"]), new objj_method(sel_getUid("initWithUnsignedShort:"), function(self, _cmd, anUnsignedShort)
{
    return anUnsignedShort;
}
,["id","unsigned short"]), new objj_method(sel_getUid("UID"), function(self, _cmd)
{
    var UID = CPNumberUIDs.valueForKey(self);
    if (!UID)
    {
        UID = objj_generateObjectUID();
        CPNumberUIDs.setValueForKey(self, UID);
    }
    return UID + "";
}
,["CPString"]), new objj_method(sel_getUid("boolValue"), function(self, _cmd)
{
    return self ? true : false;
}
,["BOOL"]), new objj_method(sel_getUid("charValue"), function(self, _cmd)
{
    return String.fromCharCode(self);
}
,["char"]), new objj_method(sel_getUid("decimalValue"), function(self, _cmd)
{
    throw new Error("decimalValue: NOT YET IMPLEMENTED");
}
,["CPDecimal"]), new objj_method(sel_getUid("descriptionWithLocale:"), function(self, _cmd, aDictionary)
{
    if (!aDictionary)
        return self.toString();
    throw new Error("descriptionWithLocale: NOT YET IMPLEMENTED");
}
,["CPString","CPDictionary"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (self.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(self, "descriptionWithLocale:", nil);
}
,["CPString"]), new objj_method(sel_getUid("doubleValue"), function(self, _cmd)
{
    if (typeof self == "boolean")
        return self ? 1 : 0;
    return self;
}
,["double"]), new objj_method(sel_getUid("floatValue"), function(self, _cmd)
{
    if (typeof self == "boolean")
        return self ? 1 : 0;
    return self;
}
,["float"]), new objj_method(sel_getUid("intValue"), function(self, _cmd)
{
    return self >= 0 ? Math.floor(self) : Math.ceil(self);
}
,["int"]), new objj_method(sel_getUid("integerValue"), function(self, _cmd)
{
    return self >= 0 ? Math.floor(self) : Math.ceil(self);
}
,["int"]), new objj_method(sel_getUid("longLongValue"), function(self, _cmd)
{
    return self >= 0 ? Math.floor(self) : Math.ceil(self);
}
,["long long"]), new objj_method(sel_getUid("longValue"), function(self, _cmd)
{
    return self >= 0 ? Math.floor(self) : Math.ceil(self);
}
,["long"]), new objj_method(sel_getUid("shortValue"), function(self, _cmd)
{
    return self >= 0 ? Math.floor(self) : Math.ceil(self);
}
,["short"]), new objj_method(sel_getUid("stringValue"), function(self, _cmd)
{
    return self.toString();
}
,["CPString"]), new objj_method(sel_getUid("unsignedCharValue"), function(self, _cmd)
{
    return String.fromCharCode(self);
}
,["unsigned char"]), new objj_method(sel_getUid("unsignedIntValue"), function(self, _cmd)
{
    return self >= 0 ? Math.floor(self) : Math.ceil(self);
}
,["unsigned int"]), new objj_method(sel_getUid("unsignedLongValue"), function(self, _cmd)
{
    return self >= 0 ? Math.floor(self) : Math.ceil(self);
}
,["unsigned long"]), new objj_method(sel_getUid("unsignedShortValue"), function(self, _cmd)
{
    return self >= 0 ? Math.floor(self) : Math.ceil(self);
}
,["unsigned short"]), new objj_method(sel_getUid("compare:"), function(self, _cmd, aNumber)
{
    if (aNumber === nil || aNumber['isa'] === CPNull)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "nil argument");
    if (self > aNumber)
        return CPOrderedDescending;
    else if (self < aNumber)
        return CPOrderedAscending;
    return CPOrderedSame;
}
,["CPComparisonResult","CPNumber"]), new objj_method(sel_getUid("isEqualToNumber:"), function(self, _cmd, aNumber)
{
    return self == aNumber;
}
,["BOOL","CPNumber"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    var result = new Number();
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["id"]), new objj_method(sel_getUid("numberWithBool:"), function(self, _cmd, aBoolean)
{
    return aBoolean ? 1 : 0;
}
,["id","BOOL"]), new objj_method(sel_getUid("numberWithChar:"), function(self, _cmd, aChar)
{
    if (aChar.charCodeAt)
        return aChar.charCodeAt(0);
    return aChar;
}
,["id","char"]), new objj_method(sel_getUid("numberWithDouble:"), function(self, _cmd, aDouble)
{
    return aDouble;
}
,["id","double"]), new objj_method(sel_getUid("numberWithFloat:"), function(self, _cmd, aFloat)
{
    return aFloat;
}
,["id","float"]), new objj_method(sel_getUid("numberWithInt:"), function(self, _cmd, anInt)
{
    return anInt;
}
,["id","int"]), new objj_method(sel_getUid("numberWithLong:"), function(self, _cmd, aLong)
{
    return aLong;
}
,["id","long"]), new objj_method(sel_getUid("numberWithLongLong:"), function(self, _cmd, aLongLong)
{
    return aLongLong;
}
,["id","long long"]), new objj_method(sel_getUid("numberWithShort:"), function(self, _cmd, aShort)
{
    return aShort;
}
,["id","short"]), new objj_method(sel_getUid("numberWithUnsignedChar:"), function(self, _cmd, aChar)
{
    if (aChar.charCodeAt)
        return aChar.charCodeAt(0);
    return aChar;
}
,["id","unsigned char"]), new objj_method(sel_getUid("numberWithUnsignedInt:"), function(self, _cmd, anUnsignedInt)
{
    return anUnsignedInt;
}
,["id","unsigned"]), new objj_method(sel_getUid("numberWithUnsignedLong:"), function(self, _cmd, anUnsignedLong)
{
    return anUnsignedLong;
}
,["id","unsigned long"]), new objj_method(sel_getUid("numberWithUnsignedShort:"), function(self, _cmd, anUnsignedShort)
{
    return anUnsignedShort;
}
,["id","unsigned short"])]);
}{
var the_class = objj_getClass("CPNumber")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPNumber\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    return (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeNumber"] || _objj_forward)(aCoder, "decodeNumber"));
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeNumber:forKey:"] || _objj_forward)(aCoder, "encodeNumber:forKey:", self, "self"));
}
,["void","CPCoder"])]);
}Number.prototype.isa = CPNumber;
Boolean.prototype.isa = CPNumber;
(CPNumber.isa.method_msgSend["initialize"] || _objj_forward)(CPNumber, "initialize");
p;19;CPNumberFormatter.jt;18421;@STATIC;1.0;i;10;CPString.ji;13;CPFormatter.ji;17;CPDecimalNumber.jt;18346;objj_executeFile("CPString.j", YES);objj_executeFile("CPFormatter.j", YES);objj_executeFile("CPDecimalNumber.j", YES);{var the_typedef = objj_allocateTypeDef("CPNumberFormatterStyle");
objj_registerTypeDef(the_typedef);
}CPNumberFormatterNoStyle = 0;
CPNumberFormatterDecimalStyle = 1;
CPNumberFormatterCurrencyStyle = 2;
CPNumberFormatterPercentStyle = 3;
CPNumberFormatterScientificStyle = 4;
CPNumberFormatterSpellOutStyle = 5;
{var the_typedef = objj_allocateTypeDef("CPNumberFormatterRoundingMode");
objj_registerTypeDef(the_typedef);
}CPNumberFormatterRoundCeiling = CPRoundUp;
CPNumberFormatterRoundFloor = CPRoundDown;
CPNumberFormatterRoundDown = CPRoundDown;
CPNumberFormatterRoundUp = CPRoundUp;
CPNumberFormatterRoundHalfEven = CPRoundBankers;
CPNumberFormatterRoundHalfDown = _CPRoundHalfDown;
CPNumberFormatterRoundHalfUp = CPRoundPlain;
var NumberRegex = new RegExp('(-)?(\\d*)(\\.(\\d*))?');
{var the_class = objj_allocateClassPair(CPFormatter, "CPNumberFormatter"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_numberStyle", "CPNumberFormatterStyle"), new objj_ivar("_perMillSymbol", "CPString"), new objj_ivar("_groupingSeparator", "CPString"), new objj_ivar("_roundingMode", "CPNumberFormatterRoundingMode"), new objj_ivar("_minimumFractionDigits", "CPUInteger"), new objj_ivar("_maximumFractionDigits", "CPUInteger"), new objj_ivar("_minimum", "CPUInteger"), new objj_ivar("_maximum", "CPUInteger"), new objj_ivar("_currencyCode", "CPString"), new objj_ivar("_currencySymbol", "CPString"), new objj_ivar("_generatesDecimalNumbers", "BOOL"), new objj_ivar("_numberHandler", "CPDecimalNumberHandler")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("numberStyle"), function(self, _cmd)
{
    return self._numberStyle;
}
,["CPNumberFormatterStyle"]), new objj_method(sel_getUid("setNumberStyle:"), function(self, _cmd, newValue)
{
    self._numberStyle = newValue;
}
,["void","CPNumberFormatterStyle"]), new objj_method(sel_getUid("perMillSymbol"), function(self, _cmd)
{
    return self._perMillSymbol;
}
,["CPString"]), new objj_method(sel_getUid("setPerMillSymbol:"), function(self, _cmd, newValue)
{
    self._perMillSymbol = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("groupingSeparator"), function(self, _cmd)
{
    return self._groupingSeparator;
}
,["CPString"]), new objj_method(sel_getUid("setGroupingSeparator:"), function(self, _cmd, newValue)
{
    self._groupingSeparator = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("roundingMode"), function(self, _cmd)
{
    return self._roundingMode;
}
,["CPNumberFormatterRoundingMode"]), new objj_method(sel_getUid("setRoundingMode:"), function(self, _cmd, newValue)
{
    self._roundingMode = newValue;
}
,["void","CPNumberFormatterRoundingMode"]), new objj_method(sel_getUid("minimumFractionDigits"), function(self, _cmd)
{
    return self._minimumFractionDigits;
}
,["CPUInteger"]), new objj_method(sel_getUid("setMinimumFractionDigits:"), function(self, _cmd, newValue)
{
    self._minimumFractionDigits = newValue;
}
,["void","CPUInteger"]), new objj_method(sel_getUid("maximumFractionDigits"), function(self, _cmd)
{
    return self._maximumFractionDigits;
}
,["CPUInteger"]), new objj_method(sel_getUid("setMaximumFractionDigits:"), function(self, _cmd, newValue)
{
    self._maximumFractionDigits = newValue;
}
,["void","CPUInteger"]), new objj_method(sel_getUid("minimum"), function(self, _cmd)
{
    return self._minimum;
}
,["CPUInteger"]), new objj_method(sel_getUid("setMinimum:"), function(self, _cmd, newValue)
{
    self._minimum = newValue;
}
,["void","CPUInteger"]), new objj_method(sel_getUid("maximum"), function(self, _cmd)
{
    return self._maximum;
}
,["CPUInteger"]), new objj_method(sel_getUid("setMaximum:"), function(self, _cmd, newValue)
{
    self._maximum = newValue;
}
,["void","CPUInteger"]), new objj_method(sel_getUid("currencyCode"), function(self, _cmd)
{
    return self._currencyCode;
}
,["CPString"]), new objj_method(sel_getUid("setCurrencyCode:"), function(self, _cmd, newValue)
{
    self._currencyCode = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("currencySymbol"), function(self, _cmd)
{
    return self._currencySymbol;
}
,["CPString"]), new objj_method(sel_getUid("setCurrencySymbol:"), function(self, _cmd, newValue)
{
    self._currencySymbol = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("generatesDecimalNumbers"), function(self, _cmd)
{
    return self._generatesDecimalNumbers;
}
,["BOOL"]), new objj_method(sel_getUid("setGeneratesDecimalNumbers:"), function(self, _cmd, newValue)
{
    self._generatesDecimalNumbers = newValue;
}
,["void","BOOL"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    if (self = (objj_getClass("CPNumberFormatter").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._roundingMode = CPNumberFormatterRoundHalfEven;
        self._minimumFractionDigits = 0;
        self._maximumFractionDigits = 0;
        self._groupingSeparator = ",";
        self._generatesDecimalNumbers = YES;
        self._minimum = nil;
        self._maximum = nil;
        self._currencyCode = "USD";
        self._currencySymbol = "$";
    }
    return self;
}
,["id"]), new objj_method(sel_getUid("stringFromNumber:"), function(self, _cmd, number)
{
    if (self._numberStyle == CPNumberFormatterPercentStyle)
    {
        number *= 100.0;
    }
    var dcmn = (number == null ? null : (number.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(number, "isKindOfClass:", CPDecimalNumber)) ? number : ((___r1 = (CPDecimalNumber.isa.method_msgSend["alloc"] || _objj_forward)(CPDecimalNumber, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["_initWithJSNumber:"] || _objj_forward)(___r1, "_initWithJSNumber:", number));
    switch(self._numberStyle) {
    case CPNumberFormatterCurrencyStyle:
    case CPNumberFormatterDecimalStyle:
    case CPNumberFormatterPercentStyle:
        (self.isa.method_msgSend["_updateNumberHandlerIfNecessary"] || _objj_forward)(self, "_updateNumberHandlerIfNecessary");
        dcmn = (dcmn == null ? null : (dcmn.isa.method_msgSend["decimalNumberByRoundingAccordingToBehavior:"] || _objj_forward)(dcmn, "decimalNumberByRoundingAccordingToBehavior:", self._numberHandler));
        var output = (dcmn == null ? null : (dcmn.isa.method_msgSend["descriptionWithLocale:"] || _objj_forward)(dcmn, "descriptionWithLocale:", nil)),
            parts = output.match(NumberRegex) || ["", undefined, "", undefined, undefined],
            negativePrefix = parts[1] || "",
            preFraction = parts[2] || "",
            fraction = parts[4] || "",
            preFractionLength = (preFraction == null ? null : (preFraction.isa.method_msgSend["length"] || _objj_forward)(preFraction, "length")),
            commaPosition = 3;
        while (fraction.length < self._minimumFractionDigits)
            fraction += "0";
        if (self._groupingSeparator)
        {
            for (var commaPosition = 3, prefLength = (preFraction == null ? null : (preFraction.isa.method_msgSend["length"] || _objj_forward)(preFraction, "length")); commaPosition < prefLength; commaPosition += 4)
            {
                preFraction = (preFraction == null ? null : (preFraction.isa.method_msgSend["stringByReplacingCharactersInRange:withString:"] || _objj_forward)(preFraction, "stringByReplacingCharactersInRange:withString:", CPMakeRange(prefLength - commaPosition, 0), self._groupingSeparator));
                prefLength += 1;
            }
        }
        var string = preFraction;
        if (fraction)
            string += "." + fraction;
        if (self._numberStyle === CPNumberFormatterCurrencyStyle)
        {
            if (self._currencySymbol)
                string = self._currencySymbol + string;
            else
                string = self._currencyCode + string;
        }
        if (self._numberStyle == CPNumberFormatterPercentStyle)
            string += "%";
        if (negativePrefix)
            string = negativePrefix + string;
        return string;
default:
        return (number == null ? null : (number.isa.method_msgSend["description"] || _objj_forward)(number, "description"));
    }
    var ___r1;
}
,["CPString","CPNumber"]), new objj_method(sel_getUid("numberFromString:"), function(self, _cmd, aString)
{
    if (self._generatesDecimalNumbers)
        return (CPDecimalNumber.isa.method_msgSend["decimalNumberWithString:"] || _objj_forward)(CPDecimalNumber, "decimalNumberWithString:", aString);
    else
        return parseFloat(aString);
}
,["CPNumber","CPString"]), new objj_method(sel_getUid("stringForObjectValue:"), function(self, _cmd, anObject)
{
    if ((anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", (CPNumber.isa.method_msgSend["class"] || _objj_forward)(CPNumber, "class"))))
        return (self.isa.method_msgSend["stringFromNumber:"] || _objj_forward)(self, "stringFromNumber:", anObject);
    else
        return (anObject == null ? null : (anObject.isa.method_msgSend["description"] || _objj_forward)(anObject, "description"));
}
,["CPString","id"]), new objj_method(sel_getUid("editingStringForObjectValue:"), function(self, _cmd, anObject)
{
    return (self.isa.method_msgSend["stringForObjectValue:"] || _objj_forward)(self, "stringForObjectValue:", anObject);
}
,["CPString","id"]), new objj_method(sel_getUid("getObjectValue:forString:errorDescription:"), function(self, _cmd, anObjectRef, aString, anErrorRef)
{
    if (aString === "")
    {
        (anObjectRef)(nil);
        return YES;
    }
    var value = (self.isa.method_msgSend["numberFromString:"] || _objj_forward)(self, "numberFromString:", aString),
        error = "";
    if (!isFinite(value))
        error = "Value is not a number";
    else if (self._minimum !== nil && value < self._minimum)
        error = "Value is less than the minimum allowed value";
    else if (self._maximum !== nil && value > self._maximum)
        error = "Value is greater than the maximum allowed value";
    if (error)
    {
        if (anErrorRef)
            (anErrorRef)(error);
        return NO;
    }
    (anObjectRef)(value);
    return YES;
}
,["BOOL","idRef","CPString","CPStringRef"]), new objj_method(sel_getUid("setNumberStyle:"), function(self, _cmd, aStyle)
{
    self._numberStyle = aStyle;
    switch(aStyle) {
    case CPNumberFormatterDecimalStyle:
        self._minimumFractionDigits = 0;
        self._maximumFractionDigits = 3;
        self._numberHandler = nil;
        break;
    case CPNumberFormatterCurrencyStyle:
        self._minimumFractionDigits = 2;
        self._maximumFractionDigits = 2;
        self._numberHandler = nil;
        break;
    }
}
,["void","CPNumberFormatterStyle"]), new objj_method(sel_getUid("setRoundingMode:"), function(self, _cmd, aRoundingMode)
{
    self._roundingMode = aRoundingMode;
    self._numberHandler = nil;
}
,["void","CPNumberFormatterRoundingMode"]), new objj_method(sel_getUid("setMinimumFractionDigits:"), function(self, _cmd, aNumber)
{
    self._minimumFractionDigits = aNumber;
    self._numberHandler = nil;
}
,["void","CPUInteger"]), new objj_method(sel_getUid("setMaximumFractionDigits:"), function(self, _cmd, aNumber)
{
    self._maximumFractionDigits = aNumber;
    self._numberHandler = nil;
}
,["void","CPUInteger"]), new objj_method(sel_getUid("setMinimum:"), function(self, _cmd, aNumber)
{
    self._minimum = aNumber;
    self._numberHandler = nil;
}
,["void","CPUInteger"]), new objj_method(sel_getUid("setMaximum:"), function(self, _cmd, aNumber)
{
    self._maximum = aNumber;
    self._numberHandler = nil;
}
,["void","CPUInteger"]), new objj_method(sel_getUid("_updateNumberHandlerIfNecessary"), function(self, _cmd)
{
    if (!self._numberHandler)
        self._numberHandler = (CPDecimalNumberHandler.isa.method_msgSend["decimalNumberHandlerWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:"] || _objj_forward)(CPDecimalNumberHandler, "decimalNumberHandlerWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:", self._roundingMode, self._maximumFractionDigits, NO, NO, NO, YES);
}
,["void"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("localizedStringFromNumber:numberStyle:"), function(self, _cmd, num, localizationStyle)
{
    var formatter = ((___r1 = (CPNumberFormatter.isa.method_msgSend["alloc"] || _objj_forward)(CPNumberFormatter, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    (formatter == null ? null : (formatter.isa.method_msgSend["setNumberStyle:"] || _objj_forward)(formatter, "setNumberStyle:", localizationStyle));
    return (formatter == null ? null : (formatter.isa.method_msgSend["stringFromNumber:"] || _objj_forward)(formatter, "stringFromNumber:", num));
    var ___r1;
}
,["CPString","CPNumber","CPNumberFormatterStyle"])]);
}var CPNumberFormatterStyleKey = "CPNumberFormatterStyleKey",
    CPNumberFormatterMinimumFractionDigitsKey = "CPNumberFormatterMinimumFractionDigitsKey",
    CPNumberFormatterMaximumFractionDigitsKey = "CPNumberFormatterMaximumFractionDigitsKey",
    CPNumberFormatterMinimumKey = "CPNumberFormatterMinimumKey",
    CPNumberFormatterMaximumKey = "CPNumberFormatterMaximumKey",
    CPNumberFormatterRoundingModeKey = "CPNumberFormatterRoundingModeKey",
    CPNumberFormatterGroupingSeparatorKey = "CPNumberFormatterGroupingSeparatorKey",
    CPNumberFormatterCurrencyCodeKey = "CPNumberFormatterCurrencyCodeKey",
    CPNumberFormatterCurrencySymbolKey = "CPNumberFormatterCurrencySymbolKey",
    CPNumberFormatterGeneratesDecimalNumbers = "CPNumberFormatterGeneratesDecimalNumbers";
{
var the_class = objj_getClass("CPNumberFormatter")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPNumberFormatter\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    self = (objj_getClass("CPNumberFormatter").super_class.method_dtable["initWithCoder:"] || _objj_forward)(self, "initWithCoder:", aCoder);
    if (self)
    {
        self._numberStyle = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPNumberFormatterStyleKey));
        self._minimumFractionDigits = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPNumberFormatterMinimumFractionDigitsKey));
        self._maximumFractionDigits = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPNumberFormatterMaximumFractionDigitsKey));
        self._roundingMode = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeIntForKey:"] || _objj_forward)(aCoder, "decodeIntForKey:", CPNumberFormatterRoundingModeKey));
        self._groupingSeparator = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPNumberFormatterGroupingSeparatorKey));
        self._currencyCode = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPNumberFormatterCurrencyCodeKey));
        self._currencySymbol = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPNumberFormatterCurrencySymbolKey));
        self._generatesDecimalNumbers = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPNumberFormatterGeneratesDecimalNumbers));
        self._minimum = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPNumberFormatterMinimumKey));
        self._maximum = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPNumberFormatterMaximumKey));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (objj_getClass("CPNumberFormatter").super_class.method_dtable["encodeWithCoder:"] || _objj_forward)(self, "encodeWithCoder:", aCoder);
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._numberStyle, CPNumberFormatterStyleKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._minimumFractionDigits, CPNumberFormatterMinimumFractionDigitsKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._maximumFractionDigits, CPNumberFormatterMaximumFractionDigitsKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._minimum, CPNumberFormatterMinimumKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._maximum, CPNumberFormatterMaximumKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._roundingMode, CPNumberFormatterRoundingModeKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._groupingSeparator, CPNumberFormatterGroupingSeparatorKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._currencyCode, CPNumberFormatterCurrencyCodeKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._currencySymbol, CPNumberFormatterCurrencySymbolKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._generatesDecimalNumbers, CPNumberFormatterGeneratesDecimalNumbers));
}
,["void","CPCoder"])]);
}p;10;CPObject.jt;14393;@STATIC;1.0;i;20;_CPTypeDefinitions.jt;14348;objj_executeFile("_CPTypeDefinitions.j", YES);{var the_protocol = objj_allocateProtocol("CPObject");
objj_registerProtocol(the_protocol);
protocol_addMethodDescriptions(the_protocol, [new objj_method(sel_getUid("isEqual:"), Nil
,["BOOL","id"]), new objj_method(sel_getUid("hash"), Nil
,["CPUInteger"]), new objj_method(sel_getUid("superclass"), Nil
,["Class"]), new objj_method(sel_getUid("class"), Nil
,["Class"]), new objj_method(sel_getUid("self"), Nil
,["id"]), new objj_method(sel_getUid("performSelector:"), Nil
,["id","SEL"]), new objj_method(sel_getUid("performSelector:withObject:"), Nil
,["id","SEL","id"]), new objj_method(sel_getUid("performSelector:withObject:withObject:"), Nil
,["id","SEL","id","id"]), new objj_method(sel_getUid("isProxy"), Nil
,["BOOL"]), new objj_method(sel_getUid("isKindOfClass:"), Nil
,["BOOL","Class"]), new objj_method(sel_getUid("isMemberOfClass:"), Nil
,["BOOL","Class"]), new objj_method(sel_getUid("conformsToProtocol:"), Nil
,["BOOL","Protocol"]), new objj_method(sel_getUid("respondsToSelector:"), Nil
,["BOOL","SEL"]), new objj_method(sel_getUid("description"), Nil
,["CPString"])], true, true);
}{var the_protocol = objj_allocateProtocol("CPCoding");
objj_registerProtocol(the_protocol);
protocol_addMethodDescriptions(the_protocol, [new objj_method(sel_getUid("encodeWithCoder:"), Nil
,["void","CPCoder"]), new objj_method(sel_getUid("initWithCoder:"), Nil
,["id","CPCoder"])], true, true);
}{var the_class = objj_allocateClassPair(Nil, "CPObject"),
meta_class = the_class.isa;
var aProtocol = objj_getProtocol("CPObject");
if (!aProtocol) throw new SyntaxError("*** Could not find definition for protocol \"CPObject\"");
class_addProtocol(the_class, aProtocol);class_addIvars(the_class, [new objj_ivar("isa", "id")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    return self;
}
,["id"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    return self;
}
,["id"]), new objj_method(sel_getUid("mutableCopy"), function(self, _cmd)
{
    return (self.isa.method_msgSend["copy"] || _objj_forward)(self, "copy");
}
,["id"]), new objj_method(sel_getUid("dealloc"), function(self, _cmd)
{
}
,["void"]), new objj_method(sel_getUid("class"), function(self, _cmd)
{
    return self.isa;
}
,["Class"]), new objj_method(sel_getUid("isKindOfClass:"), function(self, _cmd, aClass)
{
    return ((___r1 = self.isa), ___r1 == null ? null : (___r1.isa.method_msgSend["isSubclassOfClass:"] || _objj_forward)(___r1, "isSubclassOfClass:", aClass));
    var ___r1;
}
,["BOOL","Class"]), new objj_method(sel_getUid("isMemberOfClass:"), function(self, _cmd, aClass)
{
    return self.isa === aClass;
}
,["BOOL","Class"]), new objj_method(sel_getUid("isProxy"), function(self, _cmd)
{
    return NO;
}
,["BOOL"]), new objj_method(sel_getUid("respondsToSelector:"), function(self, _cmd, aSelector)
{
    return !!class_getInstanceMethod(self.isa, aSelector);
}
,["BOOL","SEL"]), new objj_method(sel_getUid("implementsSelector:"), function(self, _cmd, aSelector)
{
    var methods = class_copyMethodList(self.isa),
        count = methods.length;
    while (count--)
        if (method_getName(methods[count]) === aSelector)
            return YES;
    return NO;
}
,["BOOL","SEL"]), new objj_method(sel_getUid("conformsToProtocol:"), function(self, _cmd, aProtocol)
{
    return class_conformsToProtocol(self.isa, aProtocol);
}
,["BOOL","Protocol"]), new objj_method(sel_getUid("methodForSelector:"), function(self, _cmd, aSelector)
{
    return class_getMethodImplementation(self.isa, aSelector);
}
,["IMP","SEL"]), new objj_method(sel_getUid("methodSignatureForSelector:"), function(self, _cmd, aSelector)
{
    return nil;
}
,["CPMethodSignature","SEL"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return "<" + class_getName(self.isa) + " 0x" + (CPString == null ? null : (CPString.isa.method_msgSend["stringWithHash:"] || _objj_forward)(CPString, "stringWithHash:", (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID"))) + ">";
}
,["CPString"]), new objj_method(sel_getUid("performSelector:"), function(self, _cmd, aSelector)
{
    return self.isa.objj_msgSend0(self, aSelector);
}
,["id","SEL"]), new objj_method(sel_getUid("performSelector:withObject:"), function(self, _cmd, aSelector, anObject)
{
    return self.isa.objj_msgSend1(self, aSelector, anObject);
}
,["id","SEL","id"]), new objj_method(sel_getUid("performSelector:withObject:withObject:"), function(self, _cmd, aSelector, anObject, anotherObject)
{
    return self.isa.objj_msgSend2(self, aSelector, anObject, anotherObject);
}
,["id","SEL","id","id"]), new objj_method(sel_getUid("performSelector:withObjects:"), function(self, _cmd, aSelector, anObject)
{
    var params = [self, aSelector].concat(Array.prototype.slice.apply(arguments, [3]));
    return objj_msgSend.apply(this, params);
}
,["id","SEL","id"]), new objj_method(sel_getUid("forwardingTargetForSelector:"), function(self, _cmd, aSelector)
{
    return nil;
}
,["id","SEL"]), new objj_method(sel_getUid("forwardInvocation:"), function(self, _cmd, anInvocation)
{
    (self.isa.method_msgSend["doesNotRecognizeSelector:"] || _objj_forward)(self, "doesNotRecognizeSelector:", (anInvocation == null ? null : (anInvocation.isa.method_msgSend["selector"] || _objj_forward)(anInvocation, "selector")));
}
,["void","CPInvocation"]), new objj_method(sel_getUid("doesNotRecognizeSelector:"), function(self, _cmd, aSelector)
{
    (CPException == null ? null : (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, (class_isMetaClass(self.isa) ? "+" : "-") + " [" + (self.isa.method_msgSend["className"] || _objj_forward)(self, "className") + " " + aSelector + "] unrecognized selector sent to " + (class_isMetaClass(self.isa) ? "class " + class_getName(self.isa) : "instance 0x" + (CPString == null ? null : (CPString.isa.method_msgSend["stringWithHash:"] || _objj_forward)(CPString, "stringWithHash:", (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID"))))));
}
,["void","SEL"]), new objj_method(sel_getUid("awakeAfterUsingCoder:"), function(self, _cmd, aCoder)
{
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("classForKeyedArchiver"), function(self, _cmd)
{
    return (self.isa.method_msgSend["classForCoder"] || _objj_forward)(self, "classForCoder");
}
,["Class"]), new objj_method(sel_getUid("classForCoder"), function(self, _cmd)
{
    return (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
}
,["Class"]), new objj_method(sel_getUid("replacementObjectForArchiver:"), function(self, _cmd, anArchiver)
{
    return (self.isa.method_msgSend["replacementObjectForCoder:"] || _objj_forward)(self, "replacementObjectForCoder:", anArchiver);
}
,["id","CPArchiver"]), new objj_method(sel_getUid("replacementObjectForKeyedArchiver:"), function(self, _cmd, anArchiver)
{
    return (self.isa.method_msgSend["replacementObjectForCoder:"] || _objj_forward)(self, "replacementObjectForCoder:", anArchiver);
}
,["id","CPKeyedArchiver"]), new objj_method(sel_getUid("replacementObjectForCoder:"), function(self, _cmd, aCoder)
{
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("className"), function(self, _cmd)
{
    return self.isa.name;
}
,["CPString"]), new objj_method(sel_getUid("autorelease"), function(self, _cmd)
{
    return self;
}
,["id"]), new objj_method(sel_getUid("hash"), function(self, _cmd)
{
    return (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID");
}
,["unsigned"]), new objj_method(sel_getUid("UID"), function(self, _cmd)
{
    if (typeof self._UID === "undefined")
        self._UID = objj_generateObjectUID();
    return self._UID + "";
}
,["CPString"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    return self === anObject || (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID") === (anObject == null ? null : (anObject.isa.method_msgSend["UID"] || _objj_forward)(anObject, "UID"));
}
,["BOOL","id"]), new objj_method(sel_getUid("retain"), function(self, _cmd)
{
    return self;
}
,["id"]), new objj_method(sel_getUid("release"), function(self, _cmd)
{
}
,["void"]), new objj_method(sel_getUid("self"), function(self, _cmd)
{
    return self;
}
,["id"]), new objj_method(sel_getUid("superclass"), function(self, _cmd)
{
    return self.isa.super_class;
}
,["Class"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("load"), function(self, _cmd)
{
}
,["void"]), new objj_method(sel_getUid("initialize"), function(self, _cmd)
{
}
,["void"]), new objj_method(sel_getUid("new"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    return class_createInstance(self);
}
,["id"]), new objj_method(sel_getUid("allocWithCoder:"), function(self, _cmd, aCoder)
{
    return (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc");
}
,["id","CPCoder"]), new objj_method(sel_getUid("class"), function(self, _cmd)
{
    return self;
}
,["Class"]), new objj_method(sel_getUid("superclass"), function(self, _cmd)
{
    return self.super_class;
}
,["Class"]), new objj_method(sel_getUid("isSubclassOfClass:"), function(self, _cmd, aClass)
{
    var theClass = self;
    for (; theClass; theClass = theClass.super_class)
        if (theClass === aClass)
            return YES;
    return NO;
}
,["BOOL","Class"]), new objj_method(sel_getUid("isKindOfClass:"), function(self, _cmd, aClass)
{
    return (self.isa.method_msgSend["isSubclassOfClass:"] || _objj_forward)(self, "isSubclassOfClass:", aClass);
}
,["BOOL","Class"]), new objj_method(sel_getUid("isMemberOfClass:"), function(self, _cmd, aClass)
{
    return self === aClass;
}
,["BOOL","Class"]), new objj_method(sel_getUid("instancesRespondToSelector:"), function(self, _cmd, aSelector)
{
    return !!class_getInstanceMethod(self, aSelector);
}
,["BOOL","SEL"]), new objj_method(sel_getUid("conformsToProtocol:"), function(self, _cmd, aProtocol)
{
    return class_conformsToProtocol(self, aProtocol);
}
,["BOOL","Protocol"]), new objj_method(sel_getUid("instanceMethodForSelector:"), function(self, _cmd, aSelector)
{
    return class_getMethodImplementation(self, aSelector);
}
,["IMP","SEL"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return class_getName(self.isa);
}
,["CPString"]), new objj_method(sel_getUid("setVersion:"), function(self, _cmd, aVersion)
{
    class_setVersion(self, aVersion);
}
,["void","int"]), new objj_method(sel_getUid("version"), function(self, _cmd)
{
    return class_getVersion(self);
}
,["int"])]);
}CPDescriptionOfObject = function(anObject, maximumRecursionDepth)
{
    if (anObject === nil)
        return "nil";
    if (anObject === undefined)
        return "undefined";
    if (anObject === window)
        return "window";
    if (maximumRecursionDepth === 0)
        return "...";
    if (anObject.isa)
    {
        if ((anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", CPString)))
            return '@"' + (anObject == null ? null : (anObject.isa.method_msgSend["description"] || _objj_forward)(anObject, "description")) + '"';
        if ((anObject == null ? null : (anObject.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(anObject, "respondsToSelector:", sel_getUid("_descriptionWithMaximumDepth:"))))
            return (anObject == null ? null : (anObject.isa.method_msgSend["_descriptionWithMaximumDepth:"] || _objj_forward)(anObject, "_descriptionWithMaximumDepth:", maximumRecursionDepth !== undefined ? maximumRecursionDepth - 1 : maximumRecursionDepth));
        return (anObject == null ? null : (anObject.isa.method_msgSend["description"] || _objj_forward)(anObject, "description"));
    }
    if (typeof anObject !== "object")
        return String(anObject);
    var properties = [],
        desc;
    for (var property in anObject)
        if (anObject.hasOwnProperty(property))
            properties.push(property);
    properties.sort();
    if (properties.length === 2 && anObject.hasOwnProperty("width") && anObject.hasOwnProperty("height"))
        desc = (CPString == null ? null : (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "CGSize: (%f, %f)", anObject.width, anObject.height));
    else if (properties.length === 2 && anObject.hasOwnProperty("x") && anObject.hasOwnProperty("y"))
        desc = (CPString == null ? null : (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "CGPoint: (%f, %f)", anObject.x, anObject.y));
    else if (properties.length === 2 && anObject.hasOwnProperty("origin") && anObject.hasOwnProperty("size"))
        desc = (CPString == null ? null : (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "CGRect: (%f, %f), (%f, %f)", anObject.origin.x, anObject.origin.y, anObject.size.width, anObject.size.height));
    else if (properties.length === 4 && anObject.hasOwnProperty("top") && anObject.hasOwnProperty("right") && anObject.hasOwnProperty("bottom") && anObject.hasOwnProperty("left"))
        desc = (CPString == null ? null : (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "CGInset: { top:%f, right:%f, bottom:%f, left:%f }", anObject.top, anObject.right, anObject.bottom, anObject.left));
    else
    {
        desc = "{";
        for (var i = 0; i < properties.length; ++i)
        {
            if (i === 0)
                desc += "\n";
            var value = anObject[properties[i]],
                valueDescription = ((CPDescriptionOfObject(value, maximumRecursionDepth !== undefined ? maximumRecursionDepth - 1 : maximumRecursionDepth)).split("\n")).join("\n    ");
            desc += "    " + properties[i] + ": " + valueDescription;
            if (i < properties.length - 1)
                desc += ",\n";
            else
                desc += "\n";
        }
        desc += "}";
    }
    return desc;
}
p;15;CPObjJRuntime.jt;439;@STATIC;1.0;t;421;CPStringFromSelector = function(aSelector)
{
    return sel_getName(aSelector);
}
CPSelectorFromString = function(aSelectorName)
{
    return sel_registerName(aSelectorName);
}
CPClassFromString = function(aClassName)
{
    return objj_getClass(aClassName);
}
CPStringFromClass = function(aClass)
{
    return class_getName(aClass);
}
CPOrderedAscending = -1;
CPOrderedSame = 0;
CPOrderedDescending = 1;
CPNotFound = -1;
p;13;CPOperation.jt;7372;@STATIC;1.0;i;9;CPArray.ji;10;CPObject.jt;7325;objj_executeFile("CPArray.j", YES);objj_executeFile("CPObject.j", YES);CPOperationQueuePriorityVeryLow = -8;
CPOperationQueuePriorityLow = -4;
CPOperationQueuePriorityNormal = 0;
CPOperationQueuePriorityHigh = 4;
CPOperationQueuePriorityVeryHigh = 8;
{var the_class = objj_allocateClassPair(CPObject, "CPOperation"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("operations", "CPArray"), new objj_ivar("_cancelled", "BOOL"), new objj_ivar("_executing", "BOOL"), new objj_ivar("_finished", "BOOL"), new objj_ivar("_ready", "BOOL"), new objj_ivar("_queuePriority", "int"), new objj_ivar("_completionFunction", "JSObject"), new objj_ivar("_dependencies", "CPArray")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("main"), function(self, _cmd)
{
}
,["void"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPOperation").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._cancelled = NO;
        self._executing = NO;
        self._finished = NO;
        self._ready = YES;
        self._dependencies = ((___r1 = (CPArray.isa.method_msgSend["alloc"] || _objj_forward)(CPArray, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._queuePriority = CPOperationQueuePriorityNormal;
    }
    return self;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("start"), function(self, _cmd)
{
    if (!self._cancelled)
    {
        (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", "isExecuting");
        self._executing = YES;
        (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", "isExecuting");
        (self.isa.method_msgSend["main"] || _objj_forward)(self, "main");
        if (self._completionFunction)
        {
            self._completionFunction();
        }
        (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", "isExecuting");
        self._executing = NO;
        (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", "isExecuting");
    }
    (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", "isFinished");
    self._finished = YES;
    (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", "isFinished");
}
,["void"]), new objj_method(sel_getUid("isCancelled"), function(self, _cmd)
{
    return self._cancelled;
}
,["BOOL"]), new objj_method(sel_getUid("isExecuting"), function(self, _cmd)
{
    return self._executing;
}
,["BOOL"]), new objj_method(sel_getUid("isFinished"), function(self, _cmd)
{
    return self._finished;
}
,["BOOL"]), new objj_method(sel_getUid("isConcurrent"), function(self, _cmd)
{
    return NO;
}
,["BOOL"]), new objj_method(sel_getUid("isReady"), function(self, _cmd)
{
    return self._ready;
}
,["BOOL"]), new objj_method(sel_getUid("completionFunction"), function(self, _cmd)
{
    return self._completionFunction;
}
,["JSObject"]), new objj_method(sel_getUid("setCompletionFunction:"), function(self, _cmd, aJavaScriptFunction)
{
    self._completionFunction = aJavaScriptFunction;
}
,["void","JSObject"]), new objj_method(sel_getUid("addDependency:"), function(self, _cmd, anOperation)
{
    (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", "dependencies");
    (anOperation == null ? null : (anOperation.isa.method_msgSend["addObserver:forKeyPath:options:context:"] || _objj_forward)(anOperation, "addObserver:forKeyPath:options:context:", self, "isFinished", CPKeyValueObservingOptionNew, NULL));
    ((___r1 = self._dependencies), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", anOperation));
    (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", "dependencies");
    (self.isa.method_msgSend["_updateIsReadyState"] || _objj_forward)(self, "_updateIsReadyState");
    var ___r1;
}
,["void","CPOperation"]), new objj_method(sel_getUid("removeDependency:"), function(self, _cmd, anOperation)
{
    (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", "dependencies");
    ((___r1 = self._dependencies), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObject:"] || _objj_forward)(___r1, "removeObject:", anOperation));
    (anOperation == null ? null : (anOperation.isa.method_msgSend["removeObserver:forKeyPath:"] || _objj_forward)(anOperation, "removeObserver:forKeyPath:", self, "isFinished"));
    (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", "dependencies");
    (self.isa.method_msgSend["_updateIsReadyState"] || _objj_forward)(self, "_updateIsReadyState");
    var ___r1;
}
,["void","CPOperation"]), new objj_method(sel_getUid("dependencies"), function(self, _cmd)
{
    return self._dependencies;
}
,["CPArray"]), new objj_method(sel_getUid("waitUntilFinished"), function(self, _cmd)
{
}
,["void"]), new objj_method(sel_getUid("cancel"), function(self, _cmd)
{
    (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", "isCancelled");
    self._cancelled = YES;
    (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", "isCancelled");
}
,["void"]), new objj_method(sel_getUid("setQueuePriority:"), function(self, _cmd, priority)
{
    self._queuePriority = priority;
}
,["void","int"]), new objj_method(sel_getUid("queuePriority"), function(self, _cmd)
{
    return self._queuePriority;
}
,["int"]), new objj_method(sel_getUid("observeValueForKeyPath:ofObject:change:context:"), function(self, _cmd, keyPath, object, change, context)
{
    if (keyPath == "isFinished")
    {
        (self.isa.method_msgSend["_updateIsReadyState"] || _objj_forward)(self, "_updateIsReadyState");
    }
}
,["void","CPString","id","CPDictionary","void"]), new objj_method(sel_getUid("_updateIsReadyState"), function(self, _cmd)
{
    var newReady = YES;
    if (self._dependencies && ((___r1 = self._dependencies), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")) > 0)
    {
        var i = 0;
        for (i = 0; i < ((___r1 = self._dependencies), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")); i++)
        {
            if (!((___r1 = ((___r2 = self._dependencies), ___r2 == null ? null : (___r2.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r2, "objectAtIndex:", i))), ___r1 == null ? null : (___r1.isa.method_msgSend["isFinished"] || _objj_forward)(___r1, "isFinished")))
            {
                newReady = NO;
            }
        }
    }
    if (newReady != self._ready)
    {
        (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", "isReady");
        self._ready = newReady;
        (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", "isReady");
    }
    var ___r1, ___r2;
}
,["void"])]);
}p;18;CPOperationQueue.jt;10757;@STATIC;1.0;i;9;CPArray.ji;21;CPFunctionOperation.ji;23;CPInvocationOperation.ji;10;CPObject.ji;13;CPOperation.ji;10;CPString.ji;9;CPTimer.jt;10609;objj_executeFile("CPArray.j", YES);objj_executeFile("CPFunctionOperation.j", YES);objj_executeFile("CPInvocationOperation.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPOperation.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPTimer.j", YES);var cpOperationMainQueue = nil;
{var the_class = objj_allocateClassPair(CPObject, "CPOperationQueue"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_operations", "CPArray"), new objj_ivar("_suspended", "BOOL"), new objj_ivar("_name", "CPString"), new objj_ivar("_timer", "CPTimer")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("name"), function(self, _cmd)
{
    return self._name;
}
,["CPString"]), new objj_method(sel_getUid("setName:"), function(self, _cmd, newValue)
{
    self._name = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPOperationQueue").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._operations = ((___r1 = (CPArray.isa.method_msgSend["alloc"] || _objj_forward)(CPArray, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._suspended = NO;
        self._timer = (CPTimer.isa.method_msgSend["scheduledTimerWithTimeInterval:target:selector:userInfo:repeats:"] || _objj_forward)(CPTimer, "scheduledTimerWithTimeInterval:target:selector:userInfo:repeats:", 0.01, self, sel_getUid("_runNextOpsInQueue"), nil, YES);
    }
    return self;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("_runNextOpsInQueue"), function(self, _cmd)
{
    if (!self._suspended && (self.isa.method_msgSend["operationCount"] || _objj_forward)(self, "operationCount") > 0)
    {
        var i = 0,
            count = ((___r1 = self._operations), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
        for (; i < count; i++)
        {
            var op = ((___r1 = self._operations), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", i));
            if ((op == null ? null : (op.isa.method_msgSend["isReady"] || _objj_forward)(op, "isReady")) && !(op == null ? null : (op.isa.method_msgSend["isFinished"] || _objj_forward)(op, "isFinished")) && !(op == null ? null : (op.isa.method_msgSend["isExecuting"] || _objj_forward)(op, "isExecuting")))
            {
                (op == null ? null : (op.isa.method_msgSend["start"] || _objj_forward)(op, "start"));
            }
        }
    }
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("_enableTimer:"), function(self, _cmd, enable)
{
    if (!enable)
    {
        if (self._timer)
        {
            ((___r1 = self._timer), ___r1 == null ? null : (___r1.isa.method_msgSend["invalidate"] || _objj_forward)(___r1, "invalidate"));
            self._timer = nil;
        }
    }
    else
    {
        if (!self._timer)
        {
            self._timer = (CPTimer.isa.method_msgSend["scheduledTimerWithTimeInterval:target:selector:userInfo:repeats:"] || _objj_forward)(CPTimer, "scheduledTimerWithTimeInterval:target:selector:userInfo:repeats:", 0.01, self, sel_getUid("_runNextOpsInQueue"), nil, YES);
        }
    }
    var ___r1;
}
,["void","BOOL"]), new objj_method(sel_getUid("addOperation:"), function(self, _cmd, anOperation)
{
    (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", "operations");
    (self.isa.method_msgSend["willChangeValueForKey:"] || _objj_forward)(self, "willChangeValueForKey:", "operationCount");
    ((___r1 = self._operations), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", anOperation));
    (self.isa.method_msgSend["_sortOpsByPriority:"] || _objj_forward)(self, "_sortOpsByPriority:", self._operations);
    (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", "operations");
    (self.isa.method_msgSend["didChangeValueForKey:"] || _objj_forward)(self, "didChangeValueForKey:", "operationCount");
    var ___r1;
}
,["void","CPOperation"]), new objj_method(sel_getUid("addOperations:waitUntilFinished:"), function(self, _cmd, ops, wait)
{
    if (ops)
    {
        if (wait)
        {
            (self.isa.method_msgSend["_sortOpsByPriority:"] || _objj_forward)(self, "_sortOpsByPriority:", ops);
            (self.isa.method_msgSend["_runOpsSynchronously:"] || _objj_forward)(self, "_runOpsSynchronously:", ops);
        }
        ((___r1 = self._operations), ___r1 == null ? null : (___r1.isa.method_msgSend["addObjectsFromArray:"] || _objj_forward)(___r1, "addObjectsFromArray:", ops));
        (self.isa.method_msgSend["_sortOpsByPriority:"] || _objj_forward)(self, "_sortOpsByPriority:", self._operations);
    }
    var ___r1;
}
,["void","CPArray","BOOL"]), new objj_method(sel_getUid("addOperationWithFunction:"), function(self, _cmd, aFunction)
{
    (self.isa.method_msgSend["addOperation:"] || _objj_forward)(self, "addOperation:", (CPFunctionOperation.isa.method_msgSend["functionOperationWithFunction:"] || _objj_forward)(CPFunctionOperation, "functionOperationWithFunction:", aFunction));
}
,["void","JSObject"]), new objj_method(sel_getUid("operations"), function(self, _cmd)
{
    return self._operations;
}
,["CPArray"]), new objj_method(sel_getUid("operationCount"), function(self, _cmd)
{
    if (self._operations)
    {
        return ((___r1 = self._operations), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
    }
    return 0;
    var ___r1;
}
,["int"]), new objj_method(sel_getUid("cancelAllOperations"), function(self, _cmd)
{
    if (self._operations)
    {
        var i = 0,
            count = ((___r1 = self._operations), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
        for (; i < count; i++)
        {
            ((___r1 = ((___r2 = self._operations), ___r2 == null ? null : (___r2.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r2, "objectAtIndex:", i))), ___r1 == null ? null : (___r1.isa.method_msgSend["cancel"] || _objj_forward)(___r1, "cancel"));
        }
    }
    var ___r1, ___r2;
}
,["void"]), new objj_method(sel_getUid("waitUntilAllOperationsAreFinished"), function(self, _cmd)
{
    (self.isa.method_msgSend["_enableTimer:"] || _objj_forward)(self, "_enableTimer:", NO);
    (self.isa.method_msgSend["_runOpsSynchronously:"] || _objj_forward)(self, "_runOpsSynchronously:", self._operations);
    if (!self._suspended)
    {
        (self.isa.method_msgSend["_enableTimer:"] || _objj_forward)(self, "_enableTimer:", YES);
    }
}
,["void"]), new objj_method(sel_getUid("maxConcurrentOperationCount"), function(self, _cmd)
{
    return 1;
}
,["int"]), new objj_method(sel_getUid("setSuspended:"), function(self, _cmd, suspend)
{
    self._suspended = suspend;
    (self.isa.method_msgSend["_enableTimer:"] || _objj_forward)(self, "_enableTimer:", !suspend);
}
,["void","BOOL"]), new objj_method(sel_getUid("isSuspended"), function(self, _cmd)
{
    return self._suspended;
}
,["BOOL"]), new objj_method(sel_getUid("_sortOpsByPriority:"), function(self, _cmd, someOps)
{
    if (someOps)
    {
        (someOps == null ? null : (someOps.isa.method_msgSend["sortUsingFunction:context:"] || _objj_forward)(someOps, "sortUsingFunction:context:", function(lhs, rhs)
        {
            if ((lhs == null ? null : (lhs.isa.method_msgSend["queuePriority"] || _objj_forward)(lhs, "queuePriority")) < (rhs == null ? null : (rhs.isa.method_msgSend["queuePriority"] || _objj_forward)(rhs, "queuePriority")))
            {
                return 1;
            }
            else
            {
                if ((lhs == null ? null : (lhs.isa.method_msgSend["queuePriority"] || _objj_forward)(lhs, "queuePriority")) > (rhs == null ? null : (rhs.isa.method_msgSend["queuePriority"] || _objj_forward)(rhs, "queuePriority")))
                {
                    return -1;
                }
                else
                {
                    return 0;
                }
            }
        }, nil));
    }
}
,["void","CPArray"]), new objj_method(sel_getUid("_runOpsSynchronously:"), function(self, _cmd, ops)
{
    if (ops)
    {
        var keepGoing = YES;
        while (keepGoing)
        {
            var i = 0,
                count = (ops == null ? null : (ops.isa.method_msgSend["count"] || _objj_forward)(ops, "count"));
            keepGoing = NO;
            for (; i < count; i++)
            {
                var op = (ops == null ? null : (ops.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(ops, "objectAtIndex:", i));
                if ((op == null ? null : (op.isa.method_msgSend["isReady"] || _objj_forward)(op, "isReady")) && !(op == null ? null : (op.isa.method_msgSend["isFinished"] || _objj_forward)(op, "isFinished")) && !(op == null ? null : (op.isa.method_msgSend["isExecuting"] || _objj_forward)(op, "isExecuting")))
                {
                    (op == null ? null : (op.isa.method_msgSend["start"] || _objj_forward)(op, "start"));
                }
            }
            for (i = 0; i < count; i++)
            {
                var op = (ops == null ? null : (ops.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(ops, "objectAtIndex:", i));
                if (!(op == null ? null : (op.isa.method_msgSend["isFinished"] || _objj_forward)(op, "isFinished")) && !(op == null ? null : (op.isa.method_msgSend["isCancelled"] || _objj_forward)(op, "isCancelled")))
                {
                    keepGoing = YES;
                }
            }
        }
    }
}
,["void","CPArray"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("mainQueue"), function(self, _cmd)
{
    if (!cpOperationMainQueue)
    {
        cpOperationMainQueue = ((___r1 = (CPOperationQueue.isa.method_msgSend["alloc"] || _objj_forward)(CPOperationQueue, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        (cpOperationMainQueue == null ? null : (cpOperationMainQueue.isa.method_msgSend["setName:"] || _objj_forward)(cpOperationMainQueue, "setName:", "main"));
    }
    return cpOperationMainQueue;
    var ___r1;
}
,["CPOperationQueue"]), new objj_method(sel_getUid("currentQueue"), function(self, _cmd)
{
    return (CPOperationQueue.isa.method_msgSend["mainQueue"] || _objj_forward)(CPOperationQueue, "mainQueue");
}
,["CPOperationQueue"])]);
}p;29;CPPropertyListSerialization.jt;2055;@STATIC;1.0;i;13;CPException.ji;10;CPObject.jt;2003;objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);CPPropertyListUnknownFormat = 0;
CPPropertyListOpenStepFormat = kCFPropertyListOpenStepFormat;
CPPropertyListXMLFormat_v1_0 = kCFPropertyListXMLFormat_v1_0;
CPPropertyListBinaryFormat_v1_0 = kCFPropertyListBinaryFormat_v1_0;
CPPropertyList280NorthFormat_v1_0 = kCFPropertyList280NorthFormat_v1_0;
{var the_class = objj_allocateClassPair(CPObject, "CPPropertyListSerialization"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(meta_class, [new objj_method(sel_getUid("dataFromPropertyList:format:"), function(self, _cmd, aPlist, aFormat)
{
    return CPPropertyListCreateData(aPlist, aFormat);
}
,["CPData","id","CPPropertyListFormat"]), new objj_method(sel_getUid("propertyListFromData:format:"), function(self, _cmd, data, aFormat)
{
    return CPPropertyListCreateFromData(data, aFormat);
}
,["id","CPData","CPPropertyListFormat"])]);
}{
var the_class = objj_getClass("CPPropertyListSerialization")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPPropertyListSerialization\"");
var meta_class = the_class.isa;class_addMethods(meta_class, [new objj_method(sel_getUid("dataFromPropertyList:format:errorDescription:"), function(self, _cmd, aPlist, aFormat, anErrorString)
{
    _CPReportLenientDeprecation(self, _cmd, sel_getUid("dataFromPropertyList:format:"));
    return (self.isa.method_msgSend["dataFromPropertyList:format:"] || _objj_forward)(self, "dataFromPropertyList:format:", aPlist, aFormat);
}
,["CPData","id","CPPropertyListFormat","id"]), new objj_method(sel_getUid("propertyListFromData:format:errorDescription:"), function(self, _cmd, data, aFormat, errorString)
{
    _CPReportLenientDeprecation(self, _cmd, sel_getUid("propertyListFromData:format:"));
    return (self.isa.method_msgSend["propertyListFromData:format:"] || _objj_forward)(self, "propertyListFromData:format:", data, aFormat);
}
,["id","CPData","CPPropertyListFormat","id"])]);
}p;9;CPProxy.jt;5557;@STATIC;1.0;i;13;CPException.ji;14;CPInvocation.ji;10;CPObject.ji;10;CPString.jt;5471;objj_executeFile("CPException.j", YES);objj_executeFile("CPInvocation.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);{var the_class = objj_allocateClassPair(Nil, "CPProxy"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("isa", "Class")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("methodSignatureForSelector:"), function(self, _cmd, aSelector)
{
    (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "-methodSignatureForSelector: called on abstract CPProxy class.");
}
,["CPMethodSignature","SEL"]), new objj_method(sel_getUid("forwardInvocation:"), function(self, _cmd, anInvocation)
{
    (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "-forwardInvocation: called on abstract CPProxy class.");
}
,["void","CPInvocation"]), new objj_method(sel_getUid("forward::"), function(self, _cmd, aSelector, args)
{
    return (CPObject.isa.method_msgSend["methodForSelector:"] || _objj_forward)(CPObject, "methodForSelector:", _cmd)(self, _cmd, aSelector, args);
}
,["void","SEL","marg_list"]), new objj_method(sel_getUid("hash"), function(self, _cmd)
{
    return (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID");
}
,["unsigned"]), new objj_method(sel_getUid("UID"), function(self, _cmd)
{
    if (typeof self._UID === "undefined")
        self._UID = objj_generateObjectUID();
    return self._UID;
}
,["unsigned"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    return self === anObject;
}
,["BOOL","id"]), new objj_method(sel_getUid("self"), function(self, _cmd)
{
    return self;
}
,["id"]), new objj_method(sel_getUid("class"), function(self, _cmd)
{
    return self.isa;
}
,["Class"]), new objj_method(sel_getUid("superclass"), function(self, _cmd)
{
    return class_getSuperclass(self.isa);
}
,["Class"]), new objj_method(sel_getUid("performSelector:"), function(self, _cmd, aSelector)
{
    return self.isa.objj_msgSend0(self, aSelector);
}
,["id","SEL"]), new objj_method(sel_getUid("performSelector:withObject:"), function(self, _cmd, aSelector, anObject)
{
    return self.isa.objj_msgSend1(self, aSelector, anObject);
}
,["id","SEL","id"]), new objj_method(sel_getUid("performSelector:withObject:withObject:"), function(self, _cmd, aSelector, anObject, anotherObject)
{
    return self.isa.objj_msgSend2(self, aSelector, anObject, anotherObject);
}
,["id","SEL","id","id"]), new objj_method(sel_getUid("isProxy"), function(self, _cmd)
{
    return YES;
}
,["BOOL"]), new objj_method(sel_getUid("isKindOfClass:"), function(self, _cmd, aClass)
{
    var signature = (self.isa.method_msgSend["methodSignatureForSelector:"] || _objj_forward)(self, "methodSignatureForSelector:", _cmd),
        invocation = (CPInvocation.isa.method_msgSend["invocationWithMethodSignature:"] || _objj_forward)(CPInvocation, "invocationWithMethodSignature:", signature);
    (self.isa.method_msgSend["forwardInvocation:"] || _objj_forward)(self, "forwardInvocation:", invocation);
    return (invocation == null ? null : (invocation.isa.method_msgSend["returnValue"] || _objj_forward)(invocation, "returnValue"));
}
,["BOOL","Class"]), new objj_method(sel_getUid("isMemberOfClass:"), function(self, _cmd, aClass)
{
    var signature = (self.isa.method_msgSend["methodSignatureForSelector:"] || _objj_forward)(self, "methodSignatureForSelector:", _cmd),
        invocation = (CPInvocation.isa.method_msgSend["invocationWithMethodSignature:"] || _objj_forward)(CPInvocation, "invocationWithMethodSignature:", signature);
    (self.isa.method_msgSend["forwardInvocation:"] || _objj_forward)(self, "forwardInvocation:", invocation);
    return (invocation == null ? null : (invocation.isa.method_msgSend["returnValue"] || _objj_forward)(invocation, "returnValue"));
}
,["BOOL","Class"]), new objj_method(sel_getUid("respondsToSelector:"), function(self, _cmd, aSelector)
{
    var signature = (self.isa.method_msgSend["methodSignatureForSelector:"] || _objj_forward)(self, "methodSignatureForSelector:", _cmd),
        invocation = (CPInvocation.isa.method_msgSend["invocationWithMethodSignature:"] || _objj_forward)(CPInvocation, "invocationWithMethodSignature:", signature);
    (self.isa.method_msgSend["forwardInvocation:"] || _objj_forward)(self, "forwardInvocation:", invocation);
    return (invocation == null ? null : (invocation.isa.method_msgSend["returnValue"] || _objj_forward)(invocation, "returnValue"));
}
,["BOOL","SEL"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return "<" + class_getName(self.isa) + " 0x" + (CPString.isa.method_msgSend["stringWithHash:"] || _objj_forward)(CPString, "stringWithHash:", (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID")) + ">";
}
,["CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("load"), function(self, _cmd)
{
}
,["void"]), new objj_method(sel_getUid("initialize"), function(self, _cmd)
{
}
,["void"]), new objj_method(sel_getUid("class"), function(self, _cmd)
{
    return self;
}
,["Class"]), new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    return class_createInstance(self);
}
,["id"]), new objj_method(sel_getUid("respondsToSelector:"), function(self, _cmd, selector)
{
    return !!class_getInstanceMethod(isa, aSelector);
}
,["BOOL","SEL"])]);
}p;9;CPRange.jt;1719;@STATIC;1.0;t;1700;{var the_typedef = objj_allocateTypeDef("CPRange");
objj_registerTypeDef(the_typedef);
}CPMakeRange = function(location, length)
{
    return {location: location, length: length};
}
CPMakeRangeCopy = function(aRange)
{
    return {location: aRange.location, length: aRange.length};
}
CPEmptyRange = function(aRange)
{
    return aRange.length === 0;
}
CPMaxRange = function(aRange)
{
    return aRange.location + aRange.length;
}
CPEqualRanges = function(lhsRange, rhsRange)
{
    return lhsRange.location === rhsRange.location && lhsRange.length === rhsRange.length;
}
CPLocationInRange = function(aLocation, aRange)
{
    return aLocation >= aRange.location && aLocation < CPMaxRange(aRange);
}
CPUnionRange = function(lhsRange, rhsRange)
{
    var location = MIN(lhsRange.location, rhsRange.location);
    return CPMakeRange(location, MAX(CPMaxRange(lhsRange), CPMaxRange(rhsRange)) - location);
}
CPIntersectionRange = function(lhsRange, rhsRange)
{
    if (CPMaxRange(lhsRange) < rhsRange.location || CPMaxRange(rhsRange) < lhsRange.location)
        return CPMakeRange(0, 0);
    var location = MAX(lhsRange.location, rhsRange.location);
    return CPMakeRange(location, MIN(CPMaxRange(lhsRange), CPMaxRange(rhsRange)) - location);
}
CPRangeInRange = function(lhsRange, rhsRange)
{
    return lhsRange.location <= rhsRange.location && CPMaxRange(lhsRange) >= CPMaxRange(rhsRange);
}
CPStringFromRange = function(aRange)
{
    return "{" + aRange.location + ", " + aRange.length + "}";
}
CPRangeFromString = function(aString)
{
    var comma = aString.indexOf(',');
    return {location: parseInt(aString.substr(1, comma - 1)), length: parseInt(aString.substring(comma + 1, aString.length))};
}
p;11;CPRunLoop.jt;15054;@STATIC;1.0;i;9;CPArray.ji;8;CPDate.ji;10;CPObject.ji;10;CPString.jt;14979;objj_executeFile("CPArray.j", YES);objj_executeFile("CPDate.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);CPDefaultRunLoopMode = "CPDefaultRunLoopMode";
_CPRunLoopPerformCompare = function(lhs, rhs)
{
    return (rhs == null ? null : (rhs.isa.method_msgSend["order"] || _objj_forward)(rhs, "order")) - (lhs == null ? null : (lhs.isa.method_msgSend["order"] || _objj_forward)(lhs, "order"));
}
var _CPRunLoopPerformPool = [],
    _CPRunLoopPerformPoolCapacity = 5;
{var the_class = objj_allocateClassPair(CPObject, "_CPRunLoopPerform"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_block", "Function"), new objj_ivar("_target", "id"), new objj_ivar("_selector", "SEL"), new objj_ivar("_argument", "id"), new objj_ivar("_order", "unsigned"), new objj_ivar("_runLoopModes", "CPArray"), new objj_ivar("_isValid", "BOOL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithSelector:target:argument:order:modes:"), function(self, _cmd, aSelector, aTarget, anArgument, anOrder, modes)
{
    self = (objj_getClass("_CPRunLoopPerform").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._selector = aSelector;
        self._target = aTarget;
        self._argument = anArgument;
        self._order = anOrder;
        self._runLoopModes = modes;
        self._isValid = YES;
    }
    return self;
}
,["id","SEL","SEL","id","unsigned","CPArray"]), new objj_method(sel_getUid("initWithBlock:argument:order:modes:"), function(self, _cmd, aBlock, anArgument, anOrder, modes)
{
    self = (objj_getClass("_CPRunLoopPerform").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._block = aBlock;
        self._argument = anArgument;
        self._order = anOrder;
        self._runLoopModes = modes;
        self._isValid = YES;
    }
    return self;
}
,["id","Function","id","unsigned","CPArray"]), new objj_method(sel_getUid("selector"), function(self, _cmd)
{
    return self._selector;
}
,["SEL"]), new objj_method(sel_getUid("target"), function(self, _cmd)
{
    return self._target;
}
,["id"]), new objj_method(sel_getUid("argument"), function(self, _cmd)
{
    return self._argument;
}
,["id"]), new objj_method(sel_getUid("order"), function(self, _cmd)
{
    return self._order;
}
,["unsigned"]), new objj_method(sel_getUid("fireInMode:"), function(self, _cmd, aRunLoopMode)
{
    if (!self._isValid)
        return YES;
    if (((___r1 = self._runLoopModes), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", aRunLoopMode)))
    {
        if (self._block)
            self._block(self._argument);
        else
            ((___r1 = self._target), ___r1 == null ? null : (___r1.isa.method_msgSend["performSelector:withObject:"] || _objj_forward)(___r1, "performSelector:withObject:", self._selector, self._argument));
        return YES;
    }
    return NO;
    var ___r1;
}
,["BOOL","CPString"]), new objj_method(sel_getUid("invalidate"), function(self, _cmd)
{
    self._isValid = NO;
}
,["void"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("_poolPerform:"), function(self, _cmd, aPerform)
{
    if (!aPerform || _CPRunLoopPerformPool.length >= _CPRunLoopPerformPoolCapacity)
        return;
    _CPRunLoopPerformPool.push(aPerform);
}
,["void","_CPRunLoopPerform"]), new objj_method(sel_getUid("performWithSelector:target:argument:order:modes:"), function(self, _cmd, aSelector, aTarget, anArgument, anOrder, modes)
{
    if (_CPRunLoopPerformPool.length)
    {
        var perform = _CPRunLoopPerformPool.pop();
        perform._block = nil;
        perform._target = aTarget;
        perform._selector = aSelector;
        perform._argument = anArgument;
        perform._order = anOrder;
        perform._runLoopModes = modes;
        perform._isValid = YES;
        return perform;
    }
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithSelector:target:argument:order:modes:"] || _objj_forward)(___r1, "initWithSelector:target:argument:order:modes:", aSelector, aTarget, anArgument, anOrder, modes));
    var ___r1;
}
,["_CPRunLoopPerform","SEL","id","id","unsigned","CPArray"]), new objj_method(sel_getUid("performWithBlock:argument:order:modes:"), function(self, _cmd, aBlock, anArgument, anOrder, modes)
{
    if (_CPRunLoopPerformPool.length)
    {
        var perform = _CPRunLoopPerformPool.pop();
        perform._target = nil;
        perform._selector = nil;
        perform._block = aBlock;
        perform._argument = anArgument;
        perform._order = anOrder;
        perform._runLoopModes = modes;
        perform._isValid = YES;
        return perform;
    }
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithBlock:argument:order:modes:"] || _objj_forward)(___r1, "initWithBlock:argument:order:modes:", aBlock, anArgument, anOrder, modes));
    var ___r1;
}
,["_CPRunLoopPerform","Function","id","unsigned","CPArray"])]);
}var CPRunLoopLastNativeRunLoop = 0;
{var the_class = objj_allocateClassPair(CPObject, "CPRunLoop"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_runLoopLock", "BOOL"), new objj_ivar("_timersForModes", "Object"), new objj_ivar("_nativeTimersForModes", "Object"), new objj_ivar("_nextTimerFireDatesForModes", "CPDate"), new objj_ivar("_didAddTimer", "BOOL"), new objj_ivar("_effectiveDate", "CPDate"), new objj_ivar("_orderedPerforms", "CPArray"), new objj_ivar("_runLoopInsuranceTimer", "int")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPRunLoop").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._orderedPerforms = [];
        self._timersForModes = {};
        self._nativeTimersForModes = {};
        self._nextTimerFireDatesForModes = {};
    }
    return self;
}
,["id"]), new objj_method(sel_getUid("performSelector:target:argument:order:modes:"), function(self, _cmd, aSelector, aTarget, anArgument, anOrder, modes)
{
    var perform = (_CPRunLoopPerform.isa.method_msgSend["performWithSelector:target:argument:order:modes:"] || _objj_forward)(_CPRunLoopPerform, "performWithSelector:target:argument:order:modes:", aSelector, aTarget, anArgument, anOrder, modes),
        count = self._orderedPerforms.length;
    while (count--)
        if (anOrder < ((___r1 = self._orderedPerforms[count]), ___r1 == null ? null : (___r1.isa.method_msgSend["order"] || _objj_forward)(___r1, "order")))
            break;
    self._orderedPerforms.splice(count + 1, 0, perform);
    var ___r1;
}
,["void","SEL","id","id","int","CPArray"]), new objj_method(sel_getUid("performBlock:argument:order:modes:"), function(self, _cmd, aBlock, anArgument, anOrder, modes)
{
    var perform = (_CPRunLoopPerform.isa.method_msgSend["performWithBlock:argument:order:modes:"] || _objj_forward)(_CPRunLoopPerform, "performWithBlock:argument:order:modes:", aBlock, anArgument, anOrder, modes),
        count = self._orderedPerforms.length;
    while (count--)
        if (anOrder < ((___r1 = self._orderedPerforms[count]), ___r1 == null ? null : (___r1.isa.method_msgSend["order"] || _objj_forward)(___r1, "order")))
            break;
    self._orderedPerforms.splice(count + 1, 0, perform);
    var ___r1;
}
,["void","Function","id","int","CPArray"]), new objj_method(sel_getUid("cancelPerformSelector:target:argument:"), function(self, _cmd, aSelector, aTarget, anArgument)
{
    var count = self._orderedPerforms.length;
    while (count--)
    {
        var perform = self._orderedPerforms[count];
        if ((perform == null ? null : (perform.isa.method_msgSend["selector"] || _objj_forward)(perform, "selector")) === aSelector && (perform == null ? null : (perform.isa.method_msgSend["target"] || _objj_forward)(perform, "target")) == aTarget && (perform == null ? null : (perform.isa.method_msgSend["argument"] || _objj_forward)(perform, "argument")) == anArgument)
            ((___r1 = self._orderedPerforms[count]), ___r1 == null ? null : (___r1.isa.method_msgSend["invalidate"] || _objj_forward)(___r1, "invalidate"));
    }
    var ___r1;
}
,["void","SEL","id","id"]), new objj_method(sel_getUid("performSelectors"), function(self, _cmd)
{
    (self.isa.method_msgSend["limitDateForMode:"] || _objj_forward)(self, "limitDateForMode:", CPDefaultRunLoopMode);
}
,["void"]), new objj_method(sel_getUid("addTimer:forMode:"), function(self, _cmd, aTimer, aMode)
{
    if (self._timersForModes[aMode])
        self._timersForModes[aMode].push(aTimer);
    else
        self._timersForModes[aMode] = [aTimer];
    self._didAddTimer = YES;
    if (!aTimer._lastNativeRunLoopsForModes)
        aTimer._lastNativeRunLoopsForModes = {};
    aTimer._lastNativeRunLoopsForModes[aMode] = CPRunLoopLastNativeRunLoop;
    if (((___r1 = CFBundle.environments()), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", "Browser")) !== CPNotFound)
    {
        if (!self._runLoopInsuranceTimer)
            self._runLoopInsuranceTimer = window.setNativeTimeout(function()
            {
                (self.isa.method_msgSend["limitDateForMode:"] || _objj_forward)(self, "limitDateForMode:", CPDefaultRunLoopMode);
            }, 0);
    }
    var ___r1;
}
,["void","CPTimer","CPString"]), new objj_method(sel_getUid("limitDateForMode:"), function(self, _cmd, aMode)
{
    if (self._runLoopLock)
        return;
    self._runLoopLock = YES;
    if (((___r1 = CFBundle.environments()), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", "Browser")) !== CPNotFound)
    {
        if (self._runLoopInsuranceTimer)
        {
            window.clearNativeTimeout(self._runLoopInsuranceTimer);
            self._runLoopInsuranceTimer = nil;
        }
    }
    var now = self._effectiveDate ? ((___r1 = self._effectiveDate), ___r1 == null ? null : (___r1.isa.method_msgSend["laterDate:"] || _objj_forward)(___r1, "laterDate:", (CPDate.isa.method_msgSend["date"] || _objj_forward)(CPDate, "date"))) : (CPDate.isa.method_msgSend["date"] || _objj_forward)(CPDate, "date"),
        nextFireDate = nil,
        nextTimerFireDate = self._nextTimerFireDatesForModes[aMode];
    if (self._didAddTimer || nextTimerFireDate && nextTimerFireDate <= now)
    {
        self._didAddTimer = NO;
        if (self._nativeTimersForModes[aMode] !== nil)
        {
            window.clearNativeTimeout(self._nativeTimersForModes[aMode]);
            self._nativeTimersForModes[aMode] = nil;
        }
        var timers = self._timersForModes[aMode],
            index = timers.length;
        self._timersForModes[aMode] = nil;
        var hasNativeTimers = ((___r1 = CFBundle.environments()), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", "Browser")) !== CPNotFound;
        while (index--)
        {
            var timer = timers[index];
            if ((!hasNativeTimers || timer._lastNativeRunLoopsForModes[aMode] < CPRunLoopLastNativeRunLoop) && timer._isValid && timer._fireDate <= now)
                (timer == null ? null : (timer.isa.method_msgSend["fire"] || _objj_forward)(timer, "fire"));
            if (timer._isValid)
                nextFireDate = nextFireDate === nil ? timer._fireDate : (nextFireDate == null ? null : (nextFireDate.isa.method_msgSend["earlierDate:"] || _objj_forward)(nextFireDate, "earlierDate:", timer._fireDate));
            else
            {
                timer._lastNativeRunLoopsForModes[aMode] = 0;
                timers.splice(index, 1);
            }
        }
        var newTimers = self._timersForModes[aMode];
        if (newTimers && newTimers.length)
        {
            index = newTimers.length;
            while (index--)
            {
                var timer = newTimers[index];
                if ((timer == null ? null : (timer.isa.method_msgSend["isValid"] || _objj_forward)(timer, "isValid")))
                    nextFireDate = nextFireDate === nil ? timer._fireDate : (nextFireDate == null ? null : (nextFireDate.isa.method_msgSend["earlierDate:"] || _objj_forward)(nextFireDate, "earlierDate:", timer._fireDate));
                else
                    newTimers.splice(index, 1);
            }
            self._timersForModes[aMode] = newTimers.concat(timers);
        }
        else
            self._timersForModes[aMode] = timers;
        self._nextTimerFireDatesForModes[aMode] = nextFireDate;
        if (self._nextTimerFireDatesForModes[aMode] !== nil)
            self._nativeTimersForModes[aMode] = window.setNativeTimeout(function()
            {
                self._effectiveDate = nextFireDate;
                self._nativeTimersForModes[aMode] = nil;
                ++CPRunLoopLastNativeRunLoop;
                (self.isa.method_msgSend["limitDateForMode:"] || _objj_forward)(self, "limitDateForMode:", aMode);
                self._effectiveDate = nil;
            }, MAX(0, (nextFireDate == null ? null : (nextFireDate.isa.method_msgSend["timeIntervalSinceNow"] || _objj_forward)(nextFireDate, "timeIntervalSinceNow")) * 1000));
    }
    var performs = self._orderedPerforms,
        index = performs.length;
    self._orderedPerforms = [];
    while (index--)
    {
        var perform = performs[index];
        if ((perform == null ? null : (perform.isa.method_msgSend["fireInMode:"] || _objj_forward)(perform, "fireInMode:", CPDefaultRunLoopMode)))
        {
            (_CPRunLoopPerform.isa.method_msgSend["_poolPerform:"] || _objj_forward)(_CPRunLoopPerform, "_poolPerform:", perform);
            performs.splice(index, 1);
        }
    }
    if (self._orderedPerforms.length)
    {
        self._orderedPerforms = self._orderedPerforms.concat(performs);
        self._orderedPerforms.sort(_CPRunLoopPerformCompare);
    }
    else
        self._orderedPerforms = performs;
    self._runLoopLock = NO;
    return nextFireDate;
    var ___r1;
}
,["CPDate","CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("initialize"), function(self, _cmd)
{
    if (self !== (CPRunLoop.isa.method_msgSend["class"] || _objj_forward)(CPRunLoop, "class"))
        return;
    CPMainRunLoop = ((___r1 = (CPRunLoop.isa.method_msgSend["alloc"] || _objj_forward)(CPRunLoop, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("currentRunLoop"), function(self, _cmd)
{
    return CPMainRunLoop;
}
,["CPRunLoop"]), new objj_method(sel_getUid("mainRunLoop"), function(self, _cmd)
{
    return CPMainRunLoop;
}
,["CPRunLoop"])]);
}p;11;CPScanner.jt;12873;@STATIC;1.0;i;16;CPCharacterSet.ji;14;CPDictionary.ji;10;CPString.jt;12798;objj_executeFile("CPCharacterSet.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPString.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPScanner"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_string", "CPString"), new objj_ivar("_locale", "CPDictionary"), new objj_ivar("_scanLocation", "int"), new objj_ivar("_caseSensitive", "BOOL"), new objj_ivar("_charactersToBeSkipped", "CPCharacterSet")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithString:"), function(self, _cmd, aString)
{
    if (self = (objj_getClass("CPScanner").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._string = (aString == null ? null : (aString.isa.method_msgSend["copy"] || _objj_forward)(aString, "copy"));
        self._scanLocation = 0;
        self._charactersToBeSkipped = (CPCharacterSet.isa.method_msgSend["whitespaceCharacterSet"] || _objj_forward)(CPCharacterSet, "whitespaceCharacterSet");
        self._caseSensitive = NO;
    }
    return self;
}
,["id","CPString"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    var copy = ((___r1 = (CPScanner.isa.method_msgSend["alloc"] || _objj_forward)(CPScanner, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", (self.isa.method_msgSend["string"] || _objj_forward)(self, "string")));
    (copy == null ? null : (copy.isa.method_msgSend["setCharactersToBeSkipped:"] || _objj_forward)(copy, "setCharactersToBeSkipped:", (self.isa.method_msgSend["charactersToBeSkipped"] || _objj_forward)(self, "charactersToBeSkipped")));
    (copy == null ? null : (copy.isa.method_msgSend["setCaseSensitive:"] || _objj_forward)(copy, "setCaseSensitive:", (self.isa.method_msgSend["caseSensitive"] || _objj_forward)(self, "caseSensitive")));
    (copy == null ? null : (copy.isa.method_msgSend["setLocale:"] || _objj_forward)(copy, "setLocale:", (self.isa.method_msgSend["locale"] || _objj_forward)(self, "locale")));
    (copy == null ? null : (copy.isa.method_msgSend["setScanLocation:"] || _objj_forward)(copy, "setScanLocation:", (self.isa.method_msgSend["scanLocation"] || _objj_forward)(self, "scanLocation")));
    return copy;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("locale"), function(self, _cmd)
{
    return self._locale;
}
,["CPDictionary"]), new objj_method(sel_getUid("setLocale:"), function(self, _cmd, aLocale)
{
    self._locale = aLocale;
}
,["void","CPDictionary"]), new objj_method(sel_getUid("setCaseSensitive:"), function(self, _cmd, flag)
{
    self._caseSensitive = flag;
}
,["void","BOOL"]), new objj_method(sel_getUid("caseSensitive"), function(self, _cmd)
{
    return self._caseSensitive;
}
,["BOOL"]), new objj_method(sel_getUid("string"), function(self, _cmd)
{
    return self._string;
}
,["CPString"]), new objj_method(sel_getUid("charactersToBeSkipped"), function(self, _cmd)
{
    return self._charactersToBeSkipped;
}
,["CPCharacterSet"]), new objj_method(sel_getUid("setCharactersToBeSkipped:"), function(self, _cmd, c)
{
    self._charactersToBeSkipped = c;
}
,["void","CPCharacterSet"]), new objj_method(sel_getUid("isAtEnd"), function(self, _cmd)
{
    return self._scanLocation == self._string.length;
}
,["BOOL"]), new objj_method(sel_getUid("scanLocation"), function(self, _cmd)
{
    return self._scanLocation;
}
,["int"]), new objj_method(sel_getUid("setScanLocation:"), function(self, _cmd, aLocation)
{
    if (aLocation > self._string.length)
        aLocation = self._string.length;
    else if (aLocation < 0)
        aLocation = 0;
    self._scanLocation = aLocation;
}
,["void","int"]), new objj_method(sel_getUid("_performScanWithSelector:withObject:into:"), function(self, _cmd, s, arg, ref)
{
    var ret = (self.isa.method_msgSend["performSelector:withObject:"] || _objj_forward)(self, "performSelector:withObject:", s, arg);
    if (ret == nil)
        return NO;
    if (ref != nil)
        ref(ret);
    return YES;
}
,["BOOL","SEL","id","id"]), new objj_method(sel_getUid("scanCharactersFromSet:intoString:"), function(self, _cmd, scanSet, ref)
{
    return (self.isa.method_msgSend["_performScanWithSelector:withObject:into:"] || _objj_forward)(self, "_performScanWithSelector:withObject:into:", sel_getUid("scanCharactersFromSet:"), scanSet, ref);
}
,["BOOL","CPCharacterSet","id"]), new objj_method(sel_getUid("scanCharactersFromSet:"), function(self, _cmd, scanSet)
{
    return (self.isa.method_msgSend["_scanWithSet:breakFlag:"] || _objj_forward)(self, "_scanWithSet:breakFlag:", scanSet, NO);
}
,["CPString","CPCharacterSet"]), new objj_method(sel_getUid("scanUpToCharactersFromSet:intoString:"), function(self, _cmd, scanSet, ref)
{
    return (self.isa.method_msgSend["_performScanWithSelector:withObject:into:"] || _objj_forward)(self, "_performScanWithSelector:withObject:into:", sel_getUid("scanUpToCharactersFromSet:"), scanSet, ref);
}
,["BOOL","CPCharacterSet","id"]), new objj_method(sel_getUid("scanUpToCharactersFromSet:"), function(self, _cmd, scanSet)
{
    return (self.isa.method_msgSend["_scanWithSet:breakFlag:"] || _objj_forward)(self, "_scanWithSet:breakFlag:", scanSet, YES);
}
,["CPString","CPCharacterSet"]), new objj_method(sel_getUid("_scanWithSet:breakFlag:"), function(self, _cmd, scanSet, stop)
{
    if ((self.isa.method_msgSend["isAtEnd"] || _objj_forward)(self, "isAtEnd"))
        return nil;
    var current = (self.isa.method_msgSend["scanLocation"] || _objj_forward)(self, "scanLocation"),
        str = nil;
    while (current < self._string.length)
    {
        var c = self._string.charAt(current);
        if ((scanSet == null ? null : (scanSet.isa.method_msgSend["characterIsMember:"] || _objj_forward)(scanSet, "characterIsMember:", c)) == stop)
            break;
        if (!((___r1 = self._charactersToBeSkipped), ___r1 == null ? null : (___r1.isa.method_msgSend["characterIsMember:"] || _objj_forward)(___r1, "characterIsMember:", c)))
        {
            if (!str)
                str = '';
            str += c;
        }
        current++;
    }
    if (str)
        (self.isa.method_msgSend["setScanLocation:"] || _objj_forward)(self, "setScanLocation:", current);
    return str;
    var ___r1;
}
,["CPString","CPCharacterSet","BOOL"]), new objj_method(sel_getUid("_movePastCharactersToBeSkipped"), function(self, _cmd)
{
    var current = (self.isa.method_msgSend["scanLocation"] || _objj_forward)(self, "scanLocation"),
        string = (self.isa.method_msgSend["string"] || _objj_forward)(self, "string"),
        toSkip = (self.isa.method_msgSend["charactersToBeSkipped"] || _objj_forward)(self, "charactersToBeSkipped");
    while (current < string.length)
    {
        if (!(toSkip == null ? null : (toSkip.isa.method_msgSend["characterIsMember:"] || _objj_forward)(toSkip, "characterIsMember:", string.charAt(current))))
            break;
        current++;
    }
    (self.isa.method_msgSend["setScanLocation:"] || _objj_forward)(self, "setScanLocation:", current);
}
,["void"]), new objj_method(sel_getUid("scanString:intoString:"), function(self, _cmd, aString, ref)
{
    return (self.isa.method_msgSend["_performScanWithSelector:withObject:into:"] || _objj_forward)(self, "_performScanWithSelector:withObject:into:", sel_getUid("scanString:"), aString, ref);
}
,["BOOL","CPString","id"]), new objj_method(sel_getUid("scanString:"), function(self, _cmd, s)
{
    (self.isa.method_msgSend["_movePastCharactersToBeSkipped"] || _objj_forward)(self, "_movePastCharactersToBeSkipped");
    if ((self.isa.method_msgSend["isAtEnd"] || _objj_forward)(self, "isAtEnd"))
        return nil;
    var currentStr = (self.isa.method_msgSend["string"] || _objj_forward)(self, "string").substr((self.isa.method_msgSend["scanLocation"] || _objj_forward)(self, "scanLocation"), s.length);
    if (self._caseSensitive && currentStr != s || !self._caseSensitive && currentStr.toLowerCase() != s.toLowerCase())
    {
        return nil;
    }
    else
    {
        (self.isa.method_msgSend["setScanLocation:"] || _objj_forward)(self, "setScanLocation:", (self.isa.method_msgSend["scanLocation"] || _objj_forward)(self, "scanLocation") + s.length);
        return s;
    }
}
,["CPString","CPString"]), new objj_method(sel_getUid("scanUpToString:intoString:"), function(self, _cmd, aString, ref)
{
    return (self.isa.method_msgSend["_performScanWithSelector:withObject:into:"] || _objj_forward)(self, "_performScanWithSelector:withObject:into:", sel_getUid("scanUpToString:"), aString, ref);
}
,["BOOL","CPString","id"]), new objj_method(sel_getUid("scanUpToString:"), function(self, _cmd, s)
{
    var current = (self.isa.method_msgSend["scanLocation"] || _objj_forward)(self, "scanLocation"),
        str = (self.isa.method_msgSend["string"] || _objj_forward)(self, "string"),
        captured = nil;
    while (current < str.length)
    {
        var currentStr = str.substr(current, s.length);
        if (currentStr == s || !self._caseSensitive && currentStr.toLowerCase() == s.toLowerCase())
            break;
        if (!captured)
            captured = '';
        captured += str.charAt(current);
        current++;
    }
    if (captured)
        (self.isa.method_msgSend["setScanLocation:"] || _objj_forward)(self, "setScanLocation:", current);
    if ((self.isa.method_msgSend["charactersToBeSkipped"] || _objj_forward)(self, "charactersToBeSkipped"))
        captured = (captured == null ? null : (captured.isa.method_msgSend["_stringByTrimmingCharactersInSet:options:"] || _objj_forward)(captured, "_stringByTrimmingCharactersInSet:options:", (self.isa.method_msgSend["charactersToBeSkipped"] || _objj_forward)(self, "charactersToBeSkipped"), _CPCharacterSetTrimAtBeginning));
    return captured;
}
,["CPString","CPString"]), new objj_method(sel_getUid("scanWithParseFunction:"), function(self, _cmd, parseFunction)
{
    (self.isa.method_msgSend["_movePastCharactersToBeSkipped"] || _objj_forward)(self, "_movePastCharactersToBeSkipped");
    var str = (self.isa.method_msgSend["string"] || _objj_forward)(self, "string"),
        loc = (self.isa.method_msgSend["scanLocation"] || _objj_forward)(self, "scanLocation");
    if ((self.isa.method_msgSend["isAtEnd"] || _objj_forward)(self, "isAtEnd"))
        return 0;
    var s = str.substring(loc, str.length),
        f = parseFunction(s);
    if (isNaN(f))
        return nil;
    loc += ("" + f).length;
    var i = 0;
    while (!isNaN(parseFloat(str.substring(loc + i, str.length))))
    {
        i++;
    }
    (self.isa.method_msgSend["setScanLocation:"] || _objj_forward)(self, "setScanLocation:", loc + i);
    return f;
}
,["float","Function"]), new objj_method(sel_getUid("scanFloat"), function(self, _cmd)
{
    return (self.isa.method_msgSend["scanWithParseFunction:"] || _objj_forward)(self, "scanWithParseFunction:", parseFloat);
}
,["float"]), new objj_method(sel_getUid("scanInt"), function(self, _cmd)
{
    return (self.isa.method_msgSend["scanWithParseFunction:"] || _objj_forward)(self, "scanWithParseFunction:", parseInt);
}
,["int"]), new objj_method(sel_getUid("scanInt:"), function(self, _cmd, intoInt)
{
    return (self.isa.method_msgSend["_performScanWithSelector:withObject:into:"] || _objj_forward)(self, "_performScanWithSelector:withObject:into:", sel_getUid("scanInt"), nil, intoInt);
}
,["BOOL","int"]), new objj_method(sel_getUid("scanFloat:"), function(self, _cmd, intoFloat)
{
    return (self.isa.method_msgSend["_performScanWithSelector:withObject:into:"] || _objj_forward)(self, "_performScanWithSelector:withObject:into:", sel_getUid("scanFloat"), nil, intoFloat);
}
,["BOOL","float"]), new objj_method(sel_getUid("scanDouble:"), function(self, _cmd, intoDouble)
{
    return (self.isa.method_msgSend["scanFloat:"] || _objj_forward)(self, "scanFloat:", intoDouble);
}
,["BOOL","float"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (objj_getClass("CPScanner").super_class.method_dtable["description"] || _objj_forward)(self, "description") + " {" + CPStringFromClass((self.isa.method_msgSend["class"] || _objj_forward)(self, "class")) + ", state = '" + ((self.isa.method_msgSend["string"] || _objj_forward)(self, "string").substr(0, self._scanLocation) + "{{ SCAN LOCATION ->}}" + (self.isa.method_msgSend["string"] || _objj_forward)(self, "string").substr(self._scanLocation)) + "'; }";
}
,["CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("scannerWithString:"), function(self, _cmd, aString)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", aString));
    var ___r1;
}
,["id","CPString"])]);
}p;11;CPSet+KVO.jt;23645;@STATIC;1.0;i;13;CPException.ji;10;CPObject.ji;14;CPMutableSet.ji;8;CPNull.ji;27;_CPCollectionKVCOperators.jt;23529;objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPMutableSet.j", YES);objj_executeFile("CPNull.j", YES);objj_executeFile("_CPCollectionKVCOperators.j", YES);{
var the_class = objj_getClass("CPObject")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPObject\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("mutableSetValueForKey:"), function(self, _cmd, aKey)
{
    return ((___r1 = (_CPKVCSet == null ? null : (_CPKVCSet.isa.method_msgSend["alloc"] || _objj_forward)(_CPKVCSet, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithKey:forProxyObject:"] || _objj_forward)(___r1, "initWithKey:forProxyObject:", aKey, self));
    var ___r1;
}
,["id","id"]), new objj_method(sel_getUid("mutableSetValueForKeyPath:"), function(self, _cmd, aKeyPath)
{
    var dotIndex = aKeyPath.indexOf(".");
    if (dotIndex < 0)
        return (self.isa.method_msgSend["mutableSetValueForKey:"] || _objj_forward)(self, "mutableSetValueForKey:", aKeyPath);
    var firstPart = aKeyPath.substring(0, dotIndex),
        lastPart = aKeyPath.substring(dotIndex + 1);
    return ((___r1 = (self.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(self, "valueForKeyPath:", firstPart)), ___r1 == null ? null : (___r1.isa.method_msgSend["mutableSetValueForKeyPath:"] || _objj_forward)(___r1, "mutableSetValueForKeyPath:", lastPart));
    var ___r1;
}
,["id","id"])]);
}{var the_class = objj_allocateClassPair(CPMutableSet, "_CPKVCSet"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_proxyObject", "id"), new objj_ivar("_key", "id"), new objj_ivar("_accessSEL", "SEL"), new objj_ivar("_access", "Function"), new objj_ivar("_setSEL", "SEL"), new objj_ivar("_set", "Function"), new objj_ivar("_countSEL", "SEL"), new objj_ivar("_count", "Function"), new objj_ivar("_enumeratorSEL", "SEL"), new objj_ivar("_enumerator", "Function"), new objj_ivar("_memberSEL", "SEL"), new objj_ivar("_member", "Function"), new objj_ivar("_addSEL", "SEL"), new objj_ivar("_add", "Function"), new objj_ivar("_addManySEL", "SEL"), new objj_ivar("_addMany", "Function"), new objj_ivar("_removeSEL", "SEL"), new objj_ivar("_remove", "Function"), new objj_ivar("_removeManySEL", "SEL"), new objj_ivar("_removeMany", "Function"), new objj_ivar("_intersectSEL", "SEL"), new objj_ivar("_intersect", "Function")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithKey:forProxyObject:"), function(self, _cmd, aKey, anObject)
{
    self = (objj_getClass("_CPKVCSet").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    self._key = aKey;
    self._proxyObject = anObject;
    var capitalizedKey = (self._key.charAt(0)).toUpperCase() + self._key.substring(1);
    self._accessSEL = sel_getName(self._key);
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._accessSEL)))
        self._access = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._accessSEL));
    self._setSEL = sel_getName("set" + capitalizedKey + ":");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._setSEL)))
        self._set = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._setSEL));
    self._countSEL = sel_getName("countOf" + capitalizedKey);
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._countSEL)))
        self._count = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._countSEL));
    self._enumeratorSEL = sel_getName("enumeratorOf" + capitalizedKey);
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._enumeratorSEL)))
        self._enumerator = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._enumeratorSEL));
    self._memberSEL = sel_getName("memberOf" + capitalizedKey + ":");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._memberSEL)))
        self._member = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._memberSEL));
    self._addSEL = sel_getName("add" + capitalizedKey + "Object:");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._addSEL)))
        self._add = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._addSEL));
    self._addManySEL = sel_getName("add" + capitalizedKey + ":");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._addManySEL)))
        self._addMany = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._addManySEL));
    self._removeSEL = sel_getName("remove" + capitalizedKey + "Object:");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._removeSEL)))
        self._remove = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._removeSEL));
    self._removeManySEL = sel_getName("remove" + capitalizedKey + ":");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._removeManySEL)))
        self._removeMany = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._removeManySEL));
    self._intersectSEL = sel_getName("intersect" + capitalizedKey + ":");
    if (((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", self._intersectSEL)))
        self._intersect = ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["methodForSelector:"] || _objj_forward)(___r1, "methodForSelector:", self._intersectSEL));
    return self;
    var ___r1;
}
,["id","id","id"]), new objj_method(sel_getUid("_representedObject"), function(self, _cmd)
{
    if (self._access)
        return self._access(self._proxyObject, self._accessSEL);
    return ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r1, "valueForKey:", self._key));
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("_setRepresentedObject:"), function(self, _cmd, anObject)
{
    if (self._set)
        return self._set(self._proxyObject, self._setSEL, anObject);
    ((___r1 = self._proxyObject), ___r1 == null ? null : (___r1.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(___r1, "setValue:forKey:", anObject, self._key));
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("count"), function(self, _cmd)
{
    if (self._count)
        return self._count(self._proxyObject, self._countSEL);
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count"));
    var ___r1;
}
,["CPUInteger"]), new objj_method(sel_getUid("objectEnumerator"), function(self, _cmd)
{
    if (self._enumerator)
        return self._enumerator(self._proxyObject, self._enumeratorSEL);
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["objectEnumerator"] || _objj_forward)(___r1, "objectEnumerator"));
    var ___r1;
}
,["CPEnumerator"]), new objj_method(sel_getUid("member:"), function(self, _cmd, anObject)
{
    if (self._member)
        return self._member(self._proxyObject, self._memberSEL, anObject);
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["member:"] || _objj_forward)(___r1, "member:", anObject));
    var ___r1;
}
,["id","id"]), new objj_method(sel_getUid("addObject:"), function(self, _cmd, anObject)
{
    if (self._add)
        self._add(self._proxyObject, self._addSEL, anObject);
    else if (self._addMany)
    {
        var objectSet = (CPSet.isa.method_msgSend["setWithObject:"] || _objj_forward)(CPSet, "setWithObject:", anObject);
        self._addMany(self._proxyObject, self._addManySEL, objectSet);
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["addObject:"] || _objj_forward)(target, "addObject:", anObject));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("addObjectsFromArray:"), function(self, _cmd, objects)
{
    if (self._addMany)
    {
        var objectSet = (CPSet.isa.method_msgSend["setWithArray:"] || _objj_forward)(CPSet, "setWithArray:", objects);
        self._addMany(self._proxyObject, self._addManySEL, objectSet);
    }
    else if (self._add)
    {
        var object,
            objectEnumerator = (objects == null ? null : (objects.isa.method_msgSend["objectEnumerator"] || _objj_forward)(objects, "objectEnumerator"));
        while ((object = (objectEnumerator == null ? null : (objectEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(objectEnumerator, "nextObject"))) !== nil)
            self._add(self._proxyObject, self._addSEL, object);
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["addObjectsFromArray:"] || _objj_forward)(target, "addObjectsFromArray:", objects));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("unionSet:"), function(self, _cmd, aSet)
{
    if (self._addMany)
        self._addMany(self._proxyObject, self._addManySEL, aSet);
    else if (self._add)
    {
        var object,
            objectEnumerator = (aSet == null ? null : (aSet.isa.method_msgSend["objectEnumerator"] || _objj_forward)(aSet, "objectEnumerator"));
        while ((object = (objectEnumerator == null ? null : (objectEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(objectEnumerator, "nextObject"))) !== nil)
            self._add(self._proxyObject, self._addSEL, object);
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["unionSet:"] || _objj_forward)(target, "unionSet:", aSet));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","CPSet"]), new objj_method(sel_getUid("removeObject:"), function(self, _cmd, anObject)
{
    if (self._remove)
        self._remove(self._proxyObject, self._removeSEL, anObject);
    else if (self._removeMany)
    {
        var objectSet = (CPSet.isa.method_msgSend["setWithObject:"] || _objj_forward)(CPSet, "setWithObject:", anObject);
        self._removeMany(self._proxyObject, self._removeManySEL, objectSet);
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["removeObject:"] || _objj_forward)(target, "removeObject:", anObject));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("minusSet:"), function(self, _cmd, aSet)
{
    if (self._removeMany)
        self._removeMany(self._proxyObject, self._removeManySEL, aSet);
    else if (self._remove)
    {
        var object,
            objectEnumerator = (aSet == null ? null : (aSet.isa.method_msgSend["objectEnumerator"] || _objj_forward)(aSet, "objectEnumerator"));
        while ((object = (objectEnumerator == null ? null : (objectEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(objectEnumerator, "nextObject"))) !== nil)
            self._remove(self._proxyObject, self._removeSEL, object);
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["minusSet:"] || _objj_forward)(target, "minusSet:", aSet));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","CPSet"]), new objj_method(sel_getUid("removeObjectsInArray:"), function(self, _cmd, objects)
{
    if (self._removeMany)
    {
        var objectSet = (CPSet.isa.method_msgSend["setWithArray:"] || _objj_forward)(CPSet, "setWithArray:", objects);
        self._removeMany(self._proxyObject, self._removeManySEL, objectSet);
    }
    else if (self._remove)
    {
        var object,
            objectEnumerator = (objects == null ? null : (objects.isa.method_msgSend["objectEnumerator"] || _objj_forward)(objects, "objectEnumerator"));
        while ((object = (objectEnumerator == null ? null : (objectEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(objectEnumerator, "nextObject"))) !== nil)
            self._remove(self._proxyObject, self._removeSEL, object);
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["removeObjectsInArray:"] || _objj_forward)(target, "removeObjectsInArray:", objects));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("removeAllObjects"), function(self, _cmd)
{
    if (self._removeMany)
    {
        var allObjectsSet = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        self._removeMany(self._proxyObject, self._removeManySEL, allObjectsSet);
    }
    else if (self._remove)
    {
        var object,
            objectEnumerator = ((___r1 = ((___r2 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r2 == null ? null : (___r2.isa.method_msgSend["copy"] || _objj_forward)(___r2, "copy"))), ___r1 == null ? null : (___r1.isa.method_msgSend["objectEnumerator"] || _objj_forward)(___r1, "objectEnumerator"));
        while ((object = (objectEnumerator == null ? null : (objectEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(objectEnumerator, "nextObject"))) !== nil)
            self._remove(self._proxyObject, self._removeSEL, object);
    }
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["removeAllObjects"] || _objj_forward)(target, "removeAllObjects"));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1, ___r2;
}
,["void"]), new objj_method(sel_getUid("intersectSet:"), function(self, _cmd, aSet)
{
    if (self._intersect)
        self._intersect(self._proxyObject, self._intersectSEL, aSet);
    else
    {
        var target = ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
        (target == null ? null : (target.isa.method_msgSend["intersectSet:"] || _objj_forward)(target, "intersectSet:", aSet));
        (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", target);
    }
    var ___r1;
}
,["void","CPSet"]), new objj_method(sel_getUid("setSet:"), function(self, _cmd, set)
{
    (self.isa.method_msgSend["_setRepresentedObject:"] || _objj_forward)(self, "_setRepresentedObject:", set);
}
,["void","CPSet"]), new objj_method(sel_getUid("allObjects"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["allObjects"] || _objj_forward)(___r1, "allObjects"));
    var ___r1;
}
,["CPArray"]), new objj_method(sel_getUid("anyObject"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["anyObject"] || _objj_forward)(___r1, "anyObject"));
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("containsObject:"), function(self, _cmd, anObject)
{
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["containsObject:"] || _objj_forward)(___r1, "containsObject:", anObject));
    var ___r1;
}
,["BOOL","id"]), new objj_method(sel_getUid("intersectsSet:"), function(self, _cmd, aSet)
{
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["intersectsSet:"] || _objj_forward)(___r1, "intersectsSet:", aSet));
    var ___r1;
}
,["BOOL","CPSet"]), new objj_method(sel_getUid("isEqualToSet:"), function(self, _cmd, aSet)
{
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToSet:"] || _objj_forward)(___r1, "isEqualToSet:", aSet));
    var ___r1;
}
,["BOOL","CPSet"]), new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["_representedObject"] || _objj_forward)(self, "_representedObject")), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
    var ___r1;
}
,["id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    var set = (CPMutableSet.isa.method_msgSend["set"] || _objj_forward)(CPMutableSet, "set");
    set.isa = self;
    var ivars = class_copyIvarList(self),
        count = ivars.length;
    while (count--)
        set[ivar_getName(ivars[count])] = nil;
    return set;
}
,["id"])]);
}{
var the_class = objj_getClass("CPSet")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPSet\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("valueForKeyPath:"), function(self, _cmd, aKeyPath)
{
    if (!aKeyPath)
        (self.isa.method_msgSend["valueForUndefinedKey:"] || _objj_forward)(self, "valueForUndefinedKey:", "<empty path>");
    if (aKeyPath.charAt(0) === "@")
    {
        var dotIndex = aKeyPath.indexOf("."),
            operator,
            parameter;
        if (dotIndex !== -1)
        {
            operator = aKeyPath.substring(1, dotIndex);
            parameter = aKeyPath.substring(dotIndex + 1);
        }
        else
            operator = aKeyPath.substring(1);
        return (_CPCollectionKVCOperator.isa.method_msgSend["performOperation:withCollection:propertyPath:"] || _objj_forward)(_CPCollectionKVCOperator, "performOperation:withCollection:propertyPath:", operator, self, parameter);
    }
    else
    {
        var valuesForKeySet = (CPSet.isa.method_msgSend["set"] || _objj_forward)(CPSet, "set"),
            containedObject,
            containedObjectValue,
            containedObjectEnumerator = (self.isa.method_msgSend["objectEnumerator"] || _objj_forward)(self, "objectEnumerator");
        while ((containedObject = (containedObjectEnumerator == null ? null : (containedObjectEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(containedObjectEnumerator, "nextObject"))) !== nil)
        {
            containedObjectValue = (containedObject == null ? null : (containedObject.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(containedObject, "valueForKeyPath:", aKeyPath));
            if (containedObjectValue === nil || containedObjectValue === undefined)
                containedObjectValue = (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null");
            (valuesForKeySet == null ? null : (valuesForKeySet.isa.method_msgSend["addObject:"] || _objj_forward)(valuesForKeySet, "addObject:", containedObjectValue));
        }
        return valuesForKeySet;
    }
}
,["id","CPString"]), new objj_method(sel_getUid("setValue:forKey:"), function(self, _cmd, aValue, aKey)
{
    var containedObject,
        containedObjectEnumerator = (self.isa.method_msgSend["objectEnumerator"] || _objj_forward)(self, "objectEnumerator");
    while ((containedObject = (containedObjectEnumerator == null ? null : (containedObjectEnumerator.isa.method_msgSend["nextObject"] || _objj_forward)(containedObjectEnumerator, "nextObject"))) !== nil)
        (containedObject == null ? null : (containedObject.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(containedObject, "setValue:forKey:", aValue, aKey));
}
,["void","id","CPString"])]);
}p;18;CPSortDescriptor.jt;5845;@STATIC;1.0;i;10;CPObject.ji;15;CPObjJRuntime.ji;10;CPString.jt;5776;objj_executeFile("CPObject.j", YES);objj_executeFile("CPObjJRuntime.j", YES);objj_executeFile("CPString.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPSortDescriptor"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_key", "CPString"), new objj_ivar("_selector", "SEL"), new objj_ivar("_ascending", "BOOL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithKey:ascending:"), function(self, _cmd, aKey, isAscending)
{
    return (self.isa.method_msgSend["initWithKey:ascending:selector:"] || _objj_forward)(self, "initWithKey:ascending:selector:", aKey, isAscending, sel_getUid("compare:"));
}
,["id","CPString","BOOL"]), new objj_method(sel_getUid("initWithKey:ascending:selector:"), function(self, _cmd, aKey, isAscending, aSelector)
{
    self = (objj_getClass("CPSortDescriptor").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._key = aKey;
        self._ascending = isAscending;
        self._selector = aSelector;
    }
    return self;
}
,["id","CPString","BOOL","SEL"]), new objj_method(sel_getUid("ascending"), function(self, _cmd)
{
    return self._ascending;
}
,["BOOL"]), new objj_method(sel_getUid("key"), function(self, _cmd)
{
    return self._key;
}
,["CPString"]), new objj_method(sel_getUid("selector"), function(self, _cmd)
{
    return self._selector;
}
,["SEL"]), new objj_method(sel_getUid("compareObject:withObject:"), function(self, _cmd, lhsObject, rhsObject)
{
    return (self._ascending ? 1 : -1) * ((___r1 = (lhsObject == null ? null : (lhsObject.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(lhsObject, "valueForKeyPath:", self._key))), ___r1 == null ? null : (___r1.isa.method_msgSend["performSelector:withObject:"] || _objj_forward)(___r1, "performSelector:withObject:", self._selector, (rhsObject == null ? null : (rhsObject.isa.method_msgSend["valueForKeyPath:"] || _objj_forward)(rhsObject, "valueForKeyPath:", self._key))));
    var ___r1;
}
,["CPComparisonResult","id","id"]), new objj_method(sel_getUid("reversedSortDescriptor"), function(self, _cmd)
{
    return ((___r1 = ((___r2 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r2 == null ? null : (___r2.isa.method_msgSend["alloc"] || _objj_forward)(___r2, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithKey:ascending:selector:"] || _objj_forward)(___r1, "initWithKey:ascending:selector:", self._key, !self._ascending, self._selector));
    var ___r1, ___r2;
}
,["id"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (CPString == null ? null : (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "(%@, %@, %@)", (self.isa.method_msgSend["key"] || _objj_forward)(self, "key"), (self.isa.method_msgSend["ascending"] || _objj_forward)(self, "ascending") ? "ascending" : "descending", CPStringFromSelector((self.isa.method_msgSend["selector"] || _objj_forward)(self, "selector"))));
}
,["CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("sortDescriptorWithKey:ascending:"), function(self, _cmd, aKey, isAscending)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithKey:ascending:"] || _objj_forward)(___r1, "initWithKey:ascending:", aKey, isAscending));
    var ___r1;
}
,["id","CPString","BOOL"]), new objj_method(sel_getUid("sortDescriptorWithKey:ascending:selector:"), function(self, _cmd, aKey, isAscending, aSelector)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithKey:ascending:selector:"] || _objj_forward)(___r1, "initWithKey:ascending:selector:", aKey, isAscending, aSelector));
    var ___r1;
}
,["id","CPString","BOOL","SEL"])]);
}var CPSortDescriptorKeyKey = "CPSortDescriptorKeyKey",
    CPSortDescriptorAscendingKey = "CPSortDescriptorAscendingKey",
    CPSortDescriptorSelectorKey = "CPSortDescriptorSelectorKey";
{
var the_class = objj_getClass("CPSortDescriptor")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPSortDescriptor\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    if (self = (objj_getClass("CPSortDescriptor").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._key = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPSortDescriptorKeyKey));
        self._ascending = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPSortDescriptorAscendingKey));
        self._selector = CPSelectorFromString((aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPSortDescriptorSelectorKey)));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._key, CPSortDescriptorKeyKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._ascending, CPSortDescriptorAscendingKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", CPStringFromSelector(self._selector), CPSortDescriptorSelectorKey));
}
,["void","CPCoder"])]);
}p;10;CPString.jt;22220;@STATIC;1.0;i;13;CPException.ji;10;CPObject.ji;15;CPObjJRuntime.ji;9;CPRange.ji;18;CPSortDescriptor.ji;7;CPURL.ji;9;CPValue.ji;8;CPNull.jt;22075;objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPObjJRuntime.j", YES);objj_executeFile("CPRange.j", YES);objj_executeFile("CPSortDescriptor.j", YES);objj_executeFile("CPURL.j", YES);objj_executeFile("CPValue.j", YES);objj_executeFile("CPNull.j", YES);CPCaseInsensitiveSearch = 1;
CPLiteralSearch = 2;
CPBackwardsSearch = 4;
CPAnchoredSearch = 8;
CPNumericSearch = 64;
CPDiacriticInsensitiveSearch = 128;
var CPStringUIDs = new CFMutableDictionary(),
    CPStringRegexSpecialCharacters = ['/', '.', '*', '+', '?', '|', '$', '^', '(', ')', '[', ']', '{', '}', '\\'],
    CPStringRegexEscapeExpression = new RegExp("(\\" + CPStringRegexSpecialCharacters.join("|\\") + ")", 'g'),
    CPStringRegexTrimWhitespace = new RegExp("(^\\s+|\\s+$)", 'g');
{var the_class = objj_allocateClassPair(CPObject, "CPString"),
meta_class = the_class.isa;var CPStringNull = (CPNull.isa.method_msgSend["null"] || _objj_forward)(CPNull, "null");
objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithString:"), function(self, _cmd, aString)
{
    if ((self.isa.method_msgSend["class"] || _objj_forward)(self, "class") === CPString)
        return String(aString);
    var result = new String(aString);
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["id","CPString"]), new objj_method(sel_getUid("initWithFormat:"), function(self, _cmd, format)
{
    if (!format)
        (CPException == null ? null : (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "initWithFormat: the format can't be 'nil'"));
    self = ObjectiveJ.sprintf.apply(this, Array.prototype.slice.call(arguments, 2));
    return self;
}
,["id","CPString"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return self;
}
,["CPString"]), new objj_method(sel_getUid("length"), function(self, _cmd)
{
    return self.length;
}
,["int"]), new objj_method(sel_getUid("characterAtIndex:"), function(self, _cmd, anIndex)
{
    return self.charAt(anIndex);
}
,["CPString","CPUInteger"]), new objj_method(sel_getUid("stringByAppendingFormat:"), function(self, _cmd, format)
{
    if (!format)
        (CPException == null ? null : (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "initWithFormat: the format can't be 'nil'"));
    return self + ObjectiveJ.sprintf.apply(this, Array.prototype.slice.call(arguments, 2));
}
,["CPString","CPString"]), new objj_method(sel_getUid("stringByAppendingString:"), function(self, _cmd, aString)
{
    return self + aString;
}
,["CPString","CPString"]), new objj_method(sel_getUid("stringByPaddingToLength:withString:startingAtIndex:"), function(self, _cmd, aLength, aString, anIndex)
{
    if (self.length == aLength)
        return self;
    if (aLength < self.length)
        return self.substr(0, aLength);
    var string = self,
        substring = aString.substring(anIndex),
        difference = aLength - self.length;
    while ((difference -= substring.length) >= 0)
        string += substring;
    if (-difference < substring.length)
        string += substring.substring(0, -difference);
    return string;
}
,["CPString","unsigned","CPString","CPUInteger"]), new objj_method(sel_getUid("componentsSeparatedByString:"), function(self, _cmd, aString)
{
    return self.split(aString);
}
,["CPArray","CPString"]), new objj_method(sel_getUid("substringFromIndex:"), function(self, _cmd, anIndex)
{
    return self.substr(anIndex);
}
,["CPString","unsigned"]), new objj_method(sel_getUid("substringWithRange:"), function(self, _cmd, aRange)
{
    if (aRange.location < 0 || CPMaxRange(aRange) > self.length)
        (CPException == null ? null : (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPRangeException, "aRange out of bounds"));
    return self.substr(aRange.location, aRange.length);
}
,["CPString","CPRange"]), new objj_method(sel_getUid("substringToIndex:"), function(self, _cmd, anIndex)
{
    if (anIndex > self.length)
        (CPException == null ? null : (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPRangeException, "index out of bounds"));
    return self.substring(0, anIndex);
}
,["CPString","unsigned"]), new objj_method(sel_getUid("rangeOfString:"), function(self, _cmd, aString)
{
    return (self.isa.method_msgSend["rangeOfString:options:"] || _objj_forward)(self, "rangeOfString:options:", aString, 0);
}
,["CPRange","CPString"]), new objj_method(sel_getUid("rangeOfString:options:"), function(self, _cmd, aString, aMask)
{
    return (self.isa.method_msgSend["rangeOfString:options:range:"] || _objj_forward)(self, "rangeOfString:options:range:", aString, aMask, nil);
}
,["CPRange","CPString","int"]), new objj_method(sel_getUid("rangeOfString:options:range:"), function(self, _cmd, aString, aMask, aRange)
{
    if (!aString)
        return CPMakeRange(CPNotFound, 0);
    var string = aRange == nil ? self : (self.isa.method_msgSend["substringWithRange:"] || _objj_forward)(self, "substringWithRange:", aRange),
        location = CPNotFound;
    if (aMask & CPCaseInsensitiveSearch)
    {
        string = string.toLowerCase();
        aString = aString.toLowerCase();
    }
    if (aMask & CPDiacriticInsensitiveSearch)
    {
        string = string.stripDiacritics();
        aString = aString.stripDiacritics();
    }
    if (aMask & CPBackwardsSearch)
    {
        location = string.lastIndexOf(aString);
        if (aMask & CPAnchoredSearch && location + aString.length != string.length)
            location = CPNotFound;
    }
    else if (aMask & CPAnchoredSearch)
        location = (string.substr(0, aString.length)).indexOf(aString) != CPNotFound ? 0 : CPNotFound;
    else
        location = string.indexOf(aString);
    if (location == CPNotFound)
        return CPMakeRange(CPNotFound, 0);
    return CPMakeRange(location + (aRange ? aRange.location : 0), aString.length);
}
,["CPRange","CPString","int","CPrange"]), new objj_method(sel_getUid("stringByEscapingRegexControlCharacters"), function(self, _cmd)
{
    return self.replace(CPStringRegexEscapeExpression, "\\$1");
}
,["CPString"]), new objj_method(sel_getUid("stringByReplacingOccurrencesOfString:withString:"), function(self, _cmd, target, replacement)
{
    return self.replace(new RegExp((target == null ? null : (target.isa.method_msgSend["stringByEscapingRegexControlCharacters"] || _objj_forward)(target, "stringByEscapingRegexControlCharacters")), "g"), replacement);
}
,["CPString","CPString","CPString"]), new objj_method(sel_getUid("stringByReplacingOccurrencesOfString:withString:options:range:"), function(self, _cmd, target, replacement, options, searchRange)
{
    var start = self.substring(0, searchRange.location),
        stringSegmentToSearch = self.substr(searchRange.location, searchRange.length),
        end = self.substring(searchRange.location + searchRange.length, self.length),
        target = (target == null ? null : (target.isa.method_msgSend["stringByEscapingRegexControlCharacters"] || _objj_forward)(target, "stringByEscapingRegexControlCharacters")),
        regExp;
    if (options & CPCaseInsensitiveSearch)
        regExp = new RegExp(target, "gi");
    else
        regExp = new RegExp(target, "g");
    return start + '' + stringSegmentToSearch.replace(regExp, replacement) + '' + end;
}
,["CPString","CPString","CPString","int","CPRange"]), new objj_method(sel_getUid("stringByReplacingCharactersInRange:withString:"), function(self, _cmd, range, replacement)
{
    return '' + self.substring(0, range.location) + replacement + self.substring(range.location + range.length, self.length);
}
,["CPString","CPRange","CPString"]), new objj_method(sel_getUid("stringByTrimmingWhitespace"), function(self, _cmd)
{
    return self.replace(CPStringRegexTrimWhitespace, "");
}
,["CPString"]), new objj_method(sel_getUid("compare:"), function(self, _cmd, aString)
{
    return (self.isa.method_msgSend["compare:options:"] || _objj_forward)(self, "compare:options:", aString, nil);
}
,["CPComparisonResult","CPString"]), new objj_method(sel_getUid("caseInsensitiveCompare:"), function(self, _cmd, aString)
{
    return (self.isa.method_msgSend["compare:options:"] || _objj_forward)(self, "compare:options:", aString, CPCaseInsensitiveSearch);
}
,["CPComparisonResult","CPString"]), new objj_method(sel_getUid("compare:options:"), function(self, _cmd, aString, aMask)
{
    if (aString === nil)
        return CPOrderedDescending;
    if (aString === CPStringNull)
        (CPException == null ? null : (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "compare: argument can't be 'CPNull'"));
    var lhs = self,
        rhs = aString;
    if (aMask & CPCaseInsensitiveSearch)
    {
        lhs = lhs.toLowerCase();
        rhs = rhs.toLowerCase();
    }
    if (aMask & CPDiacriticInsensitiveSearch)
    {
        lhs = lhs.stripDiacritics();
        rhs = rhs.stripDiacritics();
    }
    if (lhs < rhs)
        return CPOrderedAscending;
    if (lhs > rhs)
        return CPOrderedDescending;
    return CPOrderedSame;
}
,["CPComparisonResult","CPString","int"]), new objj_method(sel_getUid("compare:options:range:"), function(self, _cmd, aString, aMask, range)
{
    var lhs = (self.isa.method_msgSend["substringWithRange:"] || _objj_forward)(self, "substringWithRange:", range),
        rhs = aString;
    return (lhs == null ? null : (lhs.isa.method_msgSend["compare:options:"] || _objj_forward)(lhs, "compare:options:", rhs, aMask));
}
,["CPComparisonResult","CPString","int","CPRange"]), new objj_method(sel_getUid("hasPrefix:"), function(self, _cmd, aString)
{
    return aString && aString != "" && self.indexOf(aString) == 0;
}
,["BOOL","CPString"]), new objj_method(sel_getUid("hasSuffix:"), function(self, _cmd, aString)
{
    return aString && aString != "" && self.length >= aString.length && self.lastIndexOf(aString) == self.length - aString.length;
}
,["BOOL","CPString"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    if (self === anObject)
        return YES;
    if (!anObject || !(anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", (CPString.isa.method_msgSend["class"] || _objj_forward)(CPString, "class"))))
        return NO;
    return (self.isa.method_msgSend["isEqualToString:"] || _objj_forward)(self, "isEqualToString:", anObject);
}
,["BOOL","id"]), new objj_method(sel_getUid("isEqualToString:"), function(self, _cmd, aString)
{
    return self == String(aString);
}
,["BOOL","CPString"]), new objj_method(sel_getUid("UID"), function(self, _cmd)
{
    var UID = CPStringUIDs.valueForKey(self);
    if (!UID)
    {
        UID = objj_generateObjectUID();
        CPStringUIDs.setValueForKey(self, UID);
    }
    return UID + "";
}
,["CPString"]), new objj_method(sel_getUid("commonPrefixWithString:"), function(self, _cmd, aString)
{
    return (self.isa.method_msgSend["commonPrefixWithString:options:"] || _objj_forward)(self, "commonPrefixWithString:options:", aString, 0);
}
,["CPString","CPString"]), new objj_method(sel_getUid("commonPrefixWithString:options:"), function(self, _cmd, aString, aMask)
{
    var len = 0,
        lhs = self,
        rhs = aString,
        min = MIN((lhs == null ? null : (lhs.isa.method_msgSend["length"] || _objj_forward)(lhs, "length")), (rhs == null ? null : (rhs.isa.method_msgSend["length"] || _objj_forward)(rhs, "length")));
    if (aMask & CPCaseInsensitiveSearch)
    {
        lhs = (lhs == null ? null : (lhs.isa.method_msgSend["lowercaseString"] || _objj_forward)(lhs, "lowercaseString"));
        rhs = (rhs == null ? null : (rhs.isa.method_msgSend["lowercaseString"] || _objj_forward)(rhs, "lowercaseString"));
    }
    for (; len < min; len++)
    {
        if ((lhs == null ? null : (lhs.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(lhs, "characterAtIndex:", len)) !== (rhs == null ? null : (rhs.isa.method_msgSend["characterAtIndex:"] || _objj_forward)(rhs, "characterAtIndex:", len)))
            break;
    }
    return (self.isa.method_msgSend["substringToIndex:"] || _objj_forward)(self, "substringToIndex:", len);
}
,["CPString","CPString","int"]), new objj_method(sel_getUid("capitalizedString"), function(self, _cmd)
{
    var parts = self.split(/\b/g),
        i = 0,
        count = parts.length;
    for (; i < count; i++)
    {
        if (i == 0 || /\s$/.test(parts[i - 1]))
            parts[i] = (parts[i].substring(0, 1)).toUpperCase() + (parts[i].substring(1)).toLowerCase();
        else
            parts[i] = parts[i].toLowerCase();
    }
    return parts.join("");
}
,["CPString"]), new objj_method(sel_getUid("lowercaseString"), function(self, _cmd)
{
    return self.toLowerCase();
}
,["CPString"]), new objj_method(sel_getUid("uppercaseString"), function(self, _cmd)
{
    return self.toUpperCase();
}
,["CPString"]), new objj_method(sel_getUid("stripDiacritics"), function(self, _cmd)
{
    return self.stripDiacritics();
}
,["CPString"]), new objj_method(sel_getUid("doubleValue"), function(self, _cmd)
{
    return parseFloat(self, 10);
}
,["double"]), new objj_method(sel_getUid("boolValue"), function(self, _cmd)
{
    var replaceRegExp = new RegExp("^\\s*[\\+,\\-]?0*");
    return (RegExp("^[Y,y,t,T,1-9]")).test(self.replace(replaceRegExp, ''));
}
,["BOOL"]), new objj_method(sel_getUid("floatValue"), function(self, _cmd)
{
    return parseFloat(self, 10);
}
,["float"]), new objj_method(sel_getUid("intValue"), function(self, _cmd)
{
    return parseInt(self, 10);
}
,["int"]), new objj_method(sel_getUid("integerValue"), function(self, _cmd)
{
    return parseInt(self, 10);
}
,["int"]), new objj_method(sel_getUid("pathComponents"), function(self, _cmd)
{
    if (self.length === 0)
        return [""];
    if (self === "/")
        return ["/"];
    var result = self.split('/');
    if (result[0] === "")
        result[0] = "/";
    var index = result.length - 1;
    if (index > 0)
    {
        if (result[index] === "")
            result[index] = "/";
        while (index--)
        {
            while (result[index] === "")
                result.splice(index--, 1);
        }
    }
    return result;
}
,["CPArray"]), new objj_method(sel_getUid("pathExtension"), function(self, _cmd)
{
    if (self.lastIndexOf('.') === CPNotFound)
        return "";
    return self.substr(self.lastIndexOf('.') + 1);
}
,["CPString"]), new objj_method(sel_getUid("lastPathComponent"), function(self, _cmd)
{
    var components = (self.isa.method_msgSend["pathComponents"] || _objj_forward)(self, "pathComponents"),
        lastIndex = components.length - 1,
        lastComponent = components[lastIndex];
    return lastIndex > 0 && lastComponent === "/" ? components[lastIndex - 1] : lastComponent;
}
,["CPString"]), new objj_method(sel_getUid("stringByAppendingPathComponent:"), function(self, _cmd, aString)
{
    var components = (self.isa.method_msgSend["pathComponents"] || _objj_forward)(self, "pathComponents"),
        addComponents = aString && aString !== "/" ? (aString == null ? null : (aString.isa.method_msgSend["pathComponents"] || _objj_forward)(aString, "pathComponents")) : [];
    return (CPString.isa.method_msgSend["pathWithComponents:"] || _objj_forward)(CPString, "pathWithComponents:", components.concat(addComponents));
}
,["CPString","CPString"]), new objj_method(sel_getUid("stringByAppendingPathExtension:"), function(self, _cmd, ext)
{
    if (ext.indexOf('/') >= 0 || self.length === 0 || self === "/")
        return self;
    var components = (self.isa.method_msgSend["pathComponents"] || _objj_forward)(self, "pathComponents"),
        last = components.length - 1;
    if (last > 0 && components[last] === "/")
        components.splice(last--, 1);
    components[last] = components[last] + "." + ext;
    return (CPString.isa.method_msgSend["pathWithComponents:"] || _objj_forward)(CPString, "pathWithComponents:", components);
}
,["CPString","CPString"]), new objj_method(sel_getUid("stringByDeletingLastPathComponent"), function(self, _cmd)
{
    if (self.length === 0)
        return "";
    else if (self === "/")
        return "/";
    var components = (self.isa.method_msgSend["pathComponents"] || _objj_forward)(self, "pathComponents"),
        last = components.length - 1;
    if (components[last] === "/")
        last--;
    components.splice(last, components.length - last);
    return (CPString.isa.method_msgSend["pathWithComponents:"] || _objj_forward)(CPString, "pathWithComponents:", components);
}
,["CPString"]), new objj_method(sel_getUid("stringByDeletingPathExtension"), function(self, _cmd)
{
    var extension = (self.isa.method_msgSend["pathExtension"] || _objj_forward)(self, "pathExtension");
    if (extension === "")
        return self;
    else if (self.lastIndexOf('.') < 1)
        return self;
    return self.substr(0, (self.isa.method_msgSend["length"] || _objj_forward)(self, "length") - (extension.length + 1));
}
,["CPString"]), new objj_method(sel_getUid("stringByStandardizingPath"), function(self, _cmd)
{
    return ((___r1 = (CPURL == null ? null : (CPURL.isa.method_msgSend["URLWithString:"] || _objj_forward)(CPURL, "URLWithString:", self))), ___r1 == null ? null : (___r1.isa.method_msgSend["absoluteString"] || _objj_forward)(___r1, "absoluteString"));
    var ___r1;
}
,["CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    if ((self.isa.method_msgSend["class"] || _objj_forward)(self, "class") !== CPString)
        return (objj_getMetaClass("CPString").super_class.method_dtable["alloc"] || _objj_forward)(self, "alloc");
    return new String();
}
,["id"]), new objj_method(sel_getUid("string"), function(self, _cmd)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("stringWithHash:"), function(self, _cmd, aHash)
{
    var hashString = (parseInt(aHash, 10)).toString(16);
    return "000000".substring(0, MAX(6 - hashString.length, 0)) + hashString;
}
,["id","unsigned"]), new objj_method(sel_getUid("stringWithString:"), function(self, _cmd, aString)
{
    if (!aString)
        (CPException == null ? null : (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "stringWithString: the string can't be 'nil'"));
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", aString));
    var ___r1;
}
,["id","CPString"]), new objj_method(sel_getUid("stringWithFormat:"), function(self, _cmd, format)
{
    if (!format)
        (CPException == null ? null : (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "initWithFormat: the format can't be 'nil'"));
    return ObjectiveJ.sprintf.apply(this, Array.prototype.slice.call(arguments, 2));
}
,["id","CPString"]), new objj_method(sel_getUid("pathWithComponents:"), function(self, _cmd, components)
{
    var size = components.length,
        result = "",
        i = -1,
        firstRound = true,
        firstIsSlash = false;
    while (++i < size)
    {
        var component = components[i],
            lenMinusOne = component.length - 1;
        if (lenMinusOne >= 0 && (component !== "/" || firstRound))
        {
            if (lenMinusOne > 0 && component.indexOf("/", lenMinusOne) === lenMinusOne)
                component = component.substring(0, lenMinusOne);
            if (firstRound)
            {
                if (component === "/")
                    firstIsSlash = true;
                firstRound = false;
            }
            else if (!firstIsSlash)
                result += "/";
            else
                firstIsSlash = false;
            result += component;
        }
    }
    return result;
}
,["CPString","CPArray"])]);
}{
var the_class = objj_getClass("CPString")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPString\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("objectFromJSON"), function(self, _cmd)
{
    return JSON.parse(self);
}
,["JSObject"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("JSONFromObject:"), function(self, _cmd, anObject)
{
    return JSON.stringify(anObject);
}
,["CPString","JSObject"])]);
}{
var the_class = objj_getClass("CPString")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPString\"");
var meta_class = the_class.isa;class_addMethods(meta_class, [new objj_method(sel_getUid("UUID"), function(self, _cmd)
{
    var g = "",
        i = 0;
    for (; i < 32; i++)
        g += (FLOOR(RAND() * 0xF)).toString(0xF);
    return g;
}
,["CPString"])]);
}var diacritics = [[192, 198], [200, 203], [204, 207], [210, 214], [217, 220], [224, 230], [231, 231], [232, 235], [236, 239], [242, 246], [249, 252]],
    normalized = [65, 69, 73, 79, 85, 97, 99, 101, 105, 111, 117];
String.prototype.stripDiacritics = function()
{
    var output = "";
    for (var indexSource = 0; indexSource < this.length; indexSource++)
    {
        var code = this.charCodeAt(indexSource);
        for (var i = 0; i < diacritics.length; i++)
        {
            var drange = diacritics[i];
            if (code >= drange[0] && code <= drange[drange.length - 1])
            {
                code = normalized[i];
                break;
            }
        }
        output += String.fromCharCode(code);
    }
    return output;
};
String.prototype.isa = CPString;
p;9;CPTimer.jt;10938;@STATIC;1.0;i;8;CPDate.ji;14;CPInvocation.ji;10;CPObject.ji;11;CPRunLoop.jt;10856;objj_executeFile("CPDate.j", YES);objj_executeFile("CPInvocation.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPRunLoop.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPTimer"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_timeInterval", "CPTimeInterval"), new objj_ivar("_invocation", "CPInvocation"), new objj_ivar("_callback", "Function"), new objj_ivar("_repeats", "BOOL"), new objj_ivar("_isValid", "BOOL"), new objj_ivar("_fireDate", "CPDate"), new objj_ivar("_userInfo", "id")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithFireDate:interval:invocation:repeats:"), function(self, _cmd, aDate, seconds, anInvocation, shouldRepeat)
{
    self = (objj_getClass("CPTimer").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._timeInterval = seconds <= 0 ? 0.1 : seconds;
        self._invocation = anInvocation;
        self._repeats = shouldRepeat;
        self._isValid = YES;
        self._fireDate = aDate;
    }
    return self;
}
,["id","CPDate","CPTimeInterval","CPInvocation","BOOL"]), new objj_method(sel_getUid("initWithFireDate:interval:target:selector:userInfo:repeats:"), function(self, _cmd, aDate, seconds, aTarget, aSelector, userInfo, shouldRepeat)
{
    var invocation = (CPInvocation.isa.method_msgSend["invocationWithMethodSignature:"] || _objj_forward)(CPInvocation, "invocationWithMethodSignature:", 1);
    (invocation == null ? null : (invocation.isa.method_msgSend["setTarget:"] || _objj_forward)(invocation, "setTarget:", aTarget));
    (invocation == null ? null : (invocation.isa.method_msgSend["setSelector:"] || _objj_forward)(invocation, "setSelector:", aSelector));
    (invocation == null ? null : (invocation.isa.method_msgSend["setArgument:atIndex:"] || _objj_forward)(invocation, "setArgument:atIndex:", self, 2));
    self = (self == null ? null : (self.isa.method_msgSend["initWithFireDate:interval:invocation:repeats:"] || _objj_forward)(self, "initWithFireDate:interval:invocation:repeats:", aDate, seconds, invocation, shouldRepeat));
    if (self)
        self._userInfo = userInfo;
    return self;
}
,["id","CPDate","CPTimeInterval","id","SEL","id","BOOL"]), new objj_method(sel_getUid("initWithFireDate:interval:callback:repeats:"), function(self, _cmd, aDate, seconds, aFunction, shouldRepeat)
{
    self = (objj_getClass("CPTimer").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._timeInterval = seconds <= 0 ? 0.1 : seconds;
        self._callback = aFunction;
        self._repeats = shouldRepeat;
        self._isValid = YES;
        self._fireDate = aDate;
    }
    return self;
}
,["id","CPDate","CPTimeInterval","Function","BOOL"]), new objj_method(sel_getUid("timeInterval"), function(self, _cmd)
{
    return self._timeInterval;
}
,["CPTimeInterval"]), new objj_method(sel_getUid("fireDate"), function(self, _cmd)
{
    return self._fireDate;
}
,["CPDate"]), new objj_method(sel_getUid("setFireDate:"), function(self, _cmd, aDate)
{
    self._fireDate = aDate;
}
,["void","CPDate"]), new objj_method(sel_getUid("fire"), function(self, _cmd)
{
    if (!self._isValid)
        return;
    if (self._callback)
        self._callback();
    else
        ((___r1 = self._invocation), ___r1 == null ? null : (___r1.isa.method_msgSend["invoke"] || _objj_forward)(___r1, "invoke"));
    if (!self._isValid)
        return;
    if (self._repeats)
        self._fireDate = (CPDate.isa.method_msgSend["dateWithTimeIntervalSinceNow:"] || _objj_forward)(CPDate, "dateWithTimeIntervalSinceNow:", self._timeInterval);
    else
        (self.isa.method_msgSend["invalidate"] || _objj_forward)(self, "invalidate");
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("isValid"), function(self, _cmd)
{
    return self._isValid;
}
,["BOOL"]), new objj_method(sel_getUid("invalidate"), function(self, _cmd)
{
    self._isValid = NO;
    self._userInfo = nil;
    self._invocation = nil;
    self._callback = nil;
}
,["void"]), new objj_method(sel_getUid("userInfo"), function(self, _cmd)
{
    return self._userInfo;
}
,["id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("scheduledTimerWithTimeInterval:invocation:repeats:"), function(self, _cmd, seconds, anInvocation, shouldRepeat)
{
    var timer = ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithFireDate:interval:invocation:repeats:"] || _objj_forward)(___r1, "initWithFireDate:interval:invocation:repeats:", (CPDate.isa.method_msgSend["dateWithTimeIntervalSinceNow:"] || _objj_forward)(CPDate, "dateWithTimeIntervalSinceNow:", seconds), seconds, anInvocation, shouldRepeat));
    ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["addTimer:forMode:"] || _objj_forward)(___r1, "addTimer:forMode:", timer, CPDefaultRunLoopMode));
    return timer;
    var ___r1;
}
,["CPTimer","CPTimeInterval","CPInvocation","BOOL"]), new objj_method(sel_getUid("scheduledTimerWithTimeInterval:target:selector:userInfo:repeats:"), function(self, _cmd, seconds, aTarget, aSelector, userInfo, shouldRepeat)
{
    var timer = ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithFireDate:interval:target:selector:userInfo:repeats:"] || _objj_forward)(___r1, "initWithFireDate:interval:target:selector:userInfo:repeats:", (CPDate.isa.method_msgSend["dateWithTimeIntervalSinceNow:"] || _objj_forward)(CPDate, "dateWithTimeIntervalSinceNow:", seconds), seconds, aTarget, aSelector, userInfo, shouldRepeat));
    ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["addTimer:forMode:"] || _objj_forward)(___r1, "addTimer:forMode:", timer, CPDefaultRunLoopMode));
    return timer;
    var ___r1;
}
,["CPTimer","CPTimeInterval","id","SEL","id","BOOL"]), new objj_method(sel_getUid("scheduledTimerWithTimeInterval:callback:repeats:"), function(self, _cmd, seconds, aFunction, shouldRepeat)
{
    var timer = ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithFireDate:interval:callback:repeats:"] || _objj_forward)(___r1, "initWithFireDate:interval:callback:repeats:", (CPDate.isa.method_msgSend["dateWithTimeIntervalSinceNow:"] || _objj_forward)(CPDate, "dateWithTimeIntervalSinceNow:", seconds), seconds, aFunction, shouldRepeat));
    ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["addTimer:forMode:"] || _objj_forward)(___r1, "addTimer:forMode:", timer, CPDefaultRunLoopMode));
    return timer;
    var ___r1;
}
,["CPTimer","CPTimeInterval","Function","BOOL"]), new objj_method(sel_getUid("timerWithTimeInterval:invocation:repeats:"), function(self, _cmd, seconds, anInvocation, shouldRepeat)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithFireDate:interval:invocation:repeats:"] || _objj_forward)(___r1, "initWithFireDate:interval:invocation:repeats:", (CPDate.isa.method_msgSend["dateWithTimeIntervalSinceNow:"] || _objj_forward)(CPDate, "dateWithTimeIntervalSinceNow:", seconds), seconds, anInvocation, shouldRepeat));
    var ___r1;
}
,["CPTimer","CPTimeInterval","CPInvocation","BOOL"]), new objj_method(sel_getUid("timerWithTimeInterval:target:selector:userInfo:repeats:"), function(self, _cmd, seconds, aTarget, aSelector, userInfo, shouldRepeat)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithFireDate:interval:target:selector:userInfo:repeats:"] || _objj_forward)(___r1, "initWithFireDate:interval:target:selector:userInfo:repeats:", (CPDate.isa.method_msgSend["dateWithTimeIntervalSinceNow:"] || _objj_forward)(CPDate, "dateWithTimeIntervalSinceNow:", seconds), seconds, aTarget, aSelector, userInfo, shouldRepeat));
    var ___r1;
}
,["CPTimer","CPTimeInterval","id","SEL","id","BOOL"]), new objj_method(sel_getUid("timerWithTimeInterval:callback:repeats:"), function(self, _cmd, seconds, aFunction, shouldRepeat)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithFireDate:interval:callback:repeats:"] || _objj_forward)(___r1, "initWithFireDate:interval:callback:repeats:", (CPDate.isa.method_msgSend["dateWithTimeIntervalSinceNow:"] || _objj_forward)(CPDate, "dateWithTimeIntervalSinceNow:", seconds), seconds, aFunction, shouldRepeat));
    var ___r1;
}
,["CPTimer","CPTimeInterval","Function","BOOL"])]);
}var CPTimersTimeoutID = 1000,
    CPTimersForTimeoutIDs = {};
var _CPTimerBridgeTimer = function(codeOrFunction, aDelay, shouldRepeat, functionArgs)
{
    var timeoutID = CPTimersTimeoutID++,
        theFunction = nil;
    if (typeof codeOrFunction === "string")
    {
        theFunction = function()
        {
            (new Function(codeOrFunction))();
            if (!shouldRepeat)
                CPTimersForTimeoutIDs[timeoutID] = nil;
        };
    }
    else
    {
        if (!functionArgs)
            functionArgs = [];
        theFunction = function()
        {
            codeOrFunction.apply(window, functionArgs);
            if (!shouldRepeat)
                CPTimersForTimeoutIDs[timeoutID] = nil;
        };
    }
    aDelay = aDelay | 0.0;
    CPTimersForTimeoutIDs[timeoutID] = (CPTimer.isa.method_msgSend["scheduledTimerWithTimeInterval:callback:repeats:"] || _objj_forward)(CPTimer, "scheduledTimerWithTimeInterval:callback:repeats:", aDelay / 1000, theFunction, shouldRepeat);
    return timeoutID;
};
if (typeof window !== 'undefined')
{
    window.setTimeout = function(codeOrFunction, aDelay)
    {
        return _CPTimerBridgeTimer(codeOrFunction, aDelay, NO, Array.prototype.slice.apply(arguments, [2]));
    };
    window.clearTimeout = function(aTimeoutID)
    {
        var timer = CPTimersForTimeoutIDs[aTimeoutID];
        if (timer)
            (timer == null ? null : (timer.isa.method_msgSend["invalidate"] || _objj_forward)(timer, "invalidate"));
        CPTimersForTimeoutIDs[aTimeoutID] = nil;
    };
    window.setInterval = function(codeOrFunction, aDelay, functionArgs)
    {
        return _CPTimerBridgeTimer(codeOrFunction, aDelay, YES, Array.prototype.slice.apply(arguments, [2]));
    };
    window.clearInterval = function(aTimeoutID)
    {
        window.clearTimeout(aTimeoutID);
    };
}p;12;CPTimeZone.jt;24211;@STATIC;1.0;i;10;CPObject.ji;10;CPString.ji;8;CPDate.ji;10;CPLocale.jt;24134;objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPDate.j", YES);objj_executeFile("CPLocale.j", YES);CPTimeZoneNameStyleStandard = 0;
CPTimeZoneNameStyleShortStandard = 1;
CPTimeZoneNameStyleDaylightSaving = 2;
CPTimeZoneNameStyleShortDaylightSaving = 3;
CPTimeZoneNameStyleGeneric = 4;
CPTimeZoneNameStyleShortGeneric = 5;
CPSystemTimeZoneDidChangeNotification = "CPSystemTimeZoneDidChangeNotification";
var abbreviationDictionary,
    timeDifferenceFromUTC,
    knownTimeZoneNames,
    defaultTimeZone,
    localTimeZone,
    systemTimeZone,
    timeZoneDataVersion,
    localizedName;
{var the_class = objj_allocateClassPair(CPObject, "CPTimeZone"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_data", "CPData"), new objj_ivar("_secondsFromGMT", "CPInteger"), new objj_ivar("_abbreviation", "CPString"), new objj_ivar("_name", "CPString")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("data"), function(self, _cmd)
{
    return self._data;
}
,["CPData"]), new objj_method(sel_getUid("secondFromGMT"), function(self, _cmd)
{
    return self._secondsFromGMT;
}
,["CPInteger"]), new objj_method(sel_getUid("abbreviation"), function(self, _cmd)
{
    return self._abbreviation;
}
,["CPString"]), new objj_method(sel_getUid("name"), function(self, _cmd)
{
    return self._name;
}
,["CPString"]), new objj_method(sel_getUid("_initWithName:abbreviation:"), function(self, _cmd, tzName, abbreviation)
{
    if (!tzName)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Invalid value provided for tzName");
    if (!(knownTimeZoneNames == null ? null : (knownTimeZoneNames.isa.method_msgSend["containsObject:"] || _objj_forward)(knownTimeZoneNames, "containsObject:", tzName)) || !abbreviation)
        return nil;
    if (self = (objj_getClass("CPTimeZone").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._name = tzName;
        self._abbreviation = abbreviation;
    }
    return self;
}
,["id","CPString","CPString"]), new objj_method(sel_getUid("initWithName:"), function(self, _cmd, tzName)
{
    if (!tzName)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "Invalid value provided for tzName");
    if (!(knownTimeZoneNames == null ? null : (knownTimeZoneNames.isa.method_msgSend["containsObject:"] || _objj_forward)(knownTimeZoneNames, "containsObject:", tzName)))
        return nil;
    if (self = (objj_getClass("CPTimeZone").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        self._name = tzName;
        var keys = (abbreviationDictionary == null ? null : (abbreviationDictionary.isa.method_msgSend["keyEnumerator"] || _objj_forward)(abbreviationDictionary, "keyEnumerator")),
            key;
        while (key = (keys == null ? null : (keys.isa.method_msgSend["nextObject"] || _objj_forward)(keys, "nextObject")))
        {
            var value = (abbreviationDictionary == null ? null : (abbreviationDictionary.isa.method_msgSend["valueForKey:"] || _objj_forward)(abbreviationDictionary, "valueForKey:", key));
            if ((value == null ? null : (value.isa.method_msgSend["isEqualToString:"] || _objj_forward)(value, "isEqualToString:", self._name)))
            {
                self._abbreviation = key;
                break;
            }
        }
    }
    return self;
}
,["id","CPString"]), new objj_method(sel_getUid("initWithName:data:"), function(self, _cmd, tzName, data)
{
    if (self = (self == null ? null : (self.isa.method_msgSend["initWithName:"] || _objj_forward)(self, "initWithName:", tzName)))
    {
        self._data = data;
    }
    return self;
}
,["id","CPString","CPData"]), new objj_method(sel_getUid("abbreviationForDate:"), function(self, _cmd, date)
{
    if (!date)
        return nil;
    return ((String(((String(date)).split("("))[1])).split(")"))[0];
}
,["CPString","CPDate"]), new objj_method(sel_getUid("secondsFromGMTForDate:"), function(self, _cmd, date)
{
    if (!date)
        return nil;
    var abbreviation = ((String(((String(date)).split("("))[1])).split(")"))[0];
    return (timeDifferenceFromUTC == null ? null : (timeDifferenceFromUTC.isa.method_msgSend["valueForKey:"] || _objj_forward)(timeDifferenceFromUTC, "valueForKey:", abbreviation)) * 60;
}
,["CPInteger","CPDate"]), new objj_method(sel_getUid("secondsFromGMT"), function(self, _cmd)
{
    return (timeDifferenceFromUTC == null ? null : (timeDifferenceFromUTC.isa.method_msgSend["valueForKey:"] || _objj_forward)(timeDifferenceFromUTC, "valueForKey:", self._abbreviation)) * 60;
}
,["CPInteger"]), new objj_method(sel_getUid("isEqualToTimeZone:"), function(self, _cmd, aTimeZone)
{
    return ((___r1 = (aTimeZone == null ? null : (aTimeZone.isa.method_msgSend["name"] || _objj_forward)(aTimeZone, "name"))), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqualToString:"] || _objj_forward)(___r1, "isEqualToString:", self._name)) && (aTimeZone == null ? null : (aTimeZone.isa.method_msgSend["data"] || _objj_forward)(aTimeZone, "data")) == self._data;
    var ___r1;
}
,["BOOL","CPTimeZone"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (CPString.isa.method_msgSend["stringWithFormat:"] || _objj_forward)(CPString, "stringWithFormat:", "%s (%s) offset %i", self._name, self._abbreviation, (self.isa.method_msgSend["secondsFromGMT"] || _objj_forward)(self, "secondsFromGMT"));
}
,["CPString"]), new objj_method(sel_getUid("localizedName:locale:"), function(self, _cmd, style, locale)
{
    if (style > 5)
        return nil;
    return ((___r1 = ((___r2 = (localizedName == null ? null : (localizedName.isa.method_msgSend["valueForKey:"] || _objj_forward)(localizedName, "valueForKey:", (locale == null ? null : (locale.isa.method_msgSend["objectForKey:"] || _objj_forward)(locale, "objectForKey:", CPLocaleLanguageCode))))), ___r2 == null ? null : (___r2.isa.method_msgSend["valueForKey:"] || _objj_forward)(___r2, "valueForKey:", self._abbreviation))), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", style));
    var ___r1, ___r2;
}
,["CPString","NSTimeZoneNameStyle","CPLocale"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("initialize"), function(self, _cmd)
{
    if (self !== (CPTimeZone.isa.method_msgSend["class"] || _objj_forward)(CPTimeZone, "class"))
        return;
    knownTimeZoneNames = ["America/Halifax", "America/Juneau", "America/Juneau", "America/Argentina/Buenos_Aires", "America/Halifax", "Asia/Dhaka", "America/Sao_Paulo", "America/Sao_Paulo", "Europe/London", "Africa/Harare", "America/Chicago", "Europe/Paris", "Europe/Paris", "America/Santiago", "America/Santiago", "America/Bogota", "America/Chicago", "Africa/Addis_Ababa", "America/New_York", "Europe/Istanbul", "Europe/Istanbul", "America/New_York", "GMT", "Asia/Dubai", "Asia/Hong_Kong", "Pacific/Honolulu", "Asia/Bangkok", "Asia/Tehran", "Asia/Calcutta", "Asia/Tokyo", "Asia/Seoul", "America/Denver", "Europe/Moscow", "Europe/Moscow", "America/Denver", "Pacific/Auckland", "Pacific/Auckland", "America/Los_Angeles", "America/Lima", "Asia/Manila", "Asia/Karachi", "America/Los_Angeles", "Asia/Singapore", "UTC", "Africa/Lagos", "Europe/Lisbon", "Europe/Lisbon", "Asia/Jakarta"];
    abbreviationDictionary = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", ["America/Halifax", "America/Juneau", "America/Juneau", "America/Argentina/Buenos_Aires", "America/Halifax", "Asia/Dhaka", "America/Sao_Paulo", "America/Sao_Paulo", "Europe/London", "Africa/Harare", "America/Chicago", "Europe/Paris", "Europe/Paris", "America/Santiago", "America/Santiago", "America/Bogota", "America/Chicago", "Africa/Addis_Ababa", "America/New_York", "Europe/Istanbul", "Europe/Istanbul", "America/New_York", "GMT", "Asia/Dubai", "Asia/Hong_Kong", "Pacific/Honolulu", "Asia/Bangkok", "Asia/Tehran", "Asia/Calcutta", "Asia/Tokyo", "Asia/Seoul", "America/Denver", "Europe/Moscow", "Europe/Moscow", "America/Denver", "Pacific/Auckland", "Pacific/Auckland", "America/Los_Angeles", "America/Lima", "Asia/Manila", "Asia/Karachi", "America/Los_Angeles", "Asia/Singapore", "UTC", "Africa/Lagos", "Europe/Lisbon", "Europe/Lisbon", "Asia/Jakarta"], ["ADT", "AKDT", "AKST", "ART", "AST", "BDT", "BRST", "BRT", "BST", "CAT", "CDT", "CEST", "CET", "CLST", "CLT", "COT", "CST", "EAT", "EDT", "EEST", "EET", "EST", "GMT", "GST", "HKT", "HST", "ICT", "IRST", "IST", "JST", "KST", "MDT", "MSD", "MSK", "MST", "NZDT", "NZST", "PDT", "PET", "PHT", "PKT", "PST", "SGT", "UTC", "WAT", "WEST", "WET", "WIT"]));
    timeDifferenceFromUTC = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [-180, -480, -540, -180, -240, 360, -120, -180, 60, 120, -300, 120, 60, -180, -240, -300, -360, 180, -240, 180, 120, -300, 0, 240, 480, -600, 420, 210, 330, 540, 540, -300, 240, 240, -420, 900, 900, -420, -300, 480, 300, -480, 480, 0, -540, 60, 0, 540], ["ADT", "AKDT", "AKST", "ART", "AST", "BDT", "BRST", "BRT", "BST", "CAT", "CDT", "CEST", "CET", "CLST", "CLT", "COT", "CST", "EAT", "EDT", "EEST", "EET", "EST", "GMT", "GST", "HKT", "HST", "ICT", "IRST", "IST", "JST", "KST", "MDT", "MSD", "MSK", "MST", "NZDT", "NZST", "PDT", "PET", "PHT", "PKT", "PST", "SGT", "UTC", "WAT", "WEST", "WET", "WIT"]));
    var englishLocalizedName = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [["Eastern Standard Time", "EST", "Eastern Daylight Time", "EDT", "Eastern Time", "ET"], ["GMT", "GMT", "GMT", "GMT", "GMT", "GMT"], ["Atlantic Standard Time", "AST", "Atlantic Daylight Time", "ADT", "Atlantic Time", "AT"], ["Iran Standard Time", "GMT+03:30", "Iran Daylight Time", "GMT+03:30", "Iran Time", "Iran Time"], ["Indochina Time", "GMT+07:00", "GMT+07:00", "GMT+07:00", "Indochina Time", "Thailand Time"], ["Peru Standard Time", "GMT-05:00", "Peru Summer Time", "GMT-05:00", "Peru Standard Time", "Peru Time"], ["Korean Standard Time", "GMT+09:00", "Korean Daylight Time", "GMT+09:00", "Korean Standard Time", "South Korea Time"], ["Pacific Standard Time", "PST", "Pacific Daylight Time", "PDT", "Pacific Time", "PT"], ["Central Standard Time", "CST", "Central Daylight Time", "CDT", "Central Time", "CT"], ["Eastern European Standard Time", "GMT+02:00", "Eastern European Summer Time", "GMT+03:00", "Eastern European Time", "Turkey Time"], ["New Zealand Standard Time", "GMT+12:00", "New Zealand Daylight Time", "GMT+13:00", "New Zealand Time", "New Zealand Time (Auckland)"], ["Western European Standard Time", "GMT", "Western European Summer Time", "GMT+01:00", "Western European Time", "Portugal Time (Lisbon)"], ["East Africa Time", "GMT+03:00", "GMT+03:00", "GMT+03:00", "East Africa Time", "Ethiopia Time"], ["Hong Kong Standard Time", "GMT+08:00", "Hong Kong Summer Time", "GMT+08:00", "Hong Kong Standard Time", "Hong Kong SAR China Time"], ["India Standard Time", "GMT+05:30", "GMT+05:30", "GMT+05:30", "India Standard Time", "India Time"], ["Mountain Standard Time", "MST", "Mountain Daylight Time", "MDT", "Mountain Time", "MT"], ["New Zealand Standard Time", "GMT+12:00", "New Zealand Daylight Time", "GMT+13:00", "New Zealand Time", "New Zealand Time (Auckland)"], ["Western Indonesia Time", "GMT+07:00", "GMT+07:00", "GMT+07:00", "Western Indonesia Time", "Indonesia Time (Jakarta)"], ["Atlantic Standard Time", "AST", "Atlantic Daylight Time", "ADT", "Atlantic Time", "AT"], ["Greenwich Mean Time", "GMT", "British Summer Time", "GMT+01:00", "United Kingdom Time", "United Kingdom Time"], ["Argentina Standard Time", "GMT-03:00", "Argentina Summer Time", "GMT-03:00", "Argentina Standard Time", "Argentina Time (Buenos Aires)"], ["Central Africa Time", "GMT+02:00", "GMT+02:00", "GMT+02:00", "Central Africa Time", "Zimbabwe Time"], ["Gulf Standard Time", "GMT+04:00", "GMT+04:00", "GMT+04:00", "Gulf Standard Time", "United Arab Emirates Time"], ["Pacific Standard Time", "PST", "Pacific Daylight Time", "PDT", "Pacific Time", "PT"], ["Singapore Standard Time", "GMT+08:00", "GMT+08:00", "GMT+08:00", "Singapore Standard Time", "Singapore Time"], ["Colombia Standard Time", "GMT-05:00", "Colombia Summer Time", "GMT-05:00", "Colombia Standard Time", "Colombia Time"], ["Pakistan Standard Time", "GMT+05:00", "Pakistan Summer Time", "GMT+05:00", "Pakistan Standard Time", "Pakistan Time"], ["Eastern European Standard Time", "GMT+02:00", "Eastern European Summer Time", "GMT+03:00", "Eastern European Time", "Turkey Time"], ["GMT", "GMT", "GMT", "GMT", "GMT", "GMT"], ["West Africa Standard Time", "GMT+01:00", "West Africa Summer Time", "GMT+01:00", "West Africa Standard Time", "Nigeria Time"], ["Eastern Standard Time", "EST", "Eastern Daylight Time", "EDT", "Eastern Time", "ET"], ["Japan Standard Time", "GMT+09:00", "Japan Daylight Time", "GMT+09:00", "Japan Standard Time", "Japan Time"], ["Chile Standard Time", "GMT-04:00", "Chile Summer Time", "GMT-04:00", "Chile Time", "Chile Time (Santiago)"], ["Central European Standard Time", "GMT+01:00", "Central European Summer Time", "GMT+02:00", "Central European Time", "France Time"], ["Bangladesh Standard Time", "GMT+06:00", "Bangladesh Summer Time", "GMT+06:00", "Bangladesh Standard Time", "Bangladesh Time"], ["Moscow Standard Time", "GMT+04:00", "Moscow Summer Time", "GMT+04:00", "Moscow Standard Time", "Russia Time (Moscow)"], ["Alaska Standard Time", "AKST", "Alaska Daylight Time", "AKDT", "Alaska Time", "AKT"], ["Chile Standard Time", "GMT-04:00", "Chile Summer Time", "GMT-04:00", "Chile Time", "Chile Time (Santiago)"], ["Alaska Standard Time", "AKST", "Alaska Daylight Time", "AKDT", "Alaska Time", "AKT"], ["Brasilia Standard Time", "GMT-03:00", "Brasilia Summer Time", "GMT-03:00", "Brasilia Time", "Brazil Time (Sao Paulo)"], ["Brasilia Standard Time", "GMT-03:00", "Brasilia Summer Time", "GMT-03:00", "Brasilia Time", "Brazil Time (Sao Paulo)"], ["Central European Standard Time", "GMT+01:00", "Central European Summer Time", "GMT+02:00", "Central European Time", "France Time"], ["Central Standard Time", "CST", "Central Daylight Time", "CDT", "Central Time", "CT"], ["Hawaii-Aleutian Standard Time", "HST", "Hawaii-Aleutian Daylight Time", "HDT", "Hawaii-Aleutian Standard Time", "HST"], ["Moscow Standard Time", "GMT+04:00", "Moscow Summer Time", "GMT+04:00", "Moscow Standard Time", "Russia Time (Moscow)"], ["Mountain Standard Time", "MST", "Mountain Daylight Time", "MDT", "Mountain Time", "MT"], ["Philippine Standard Time", "GMT+08:00", "Philippine Summer Time", "GMT+08:00", "Philippine Standard Time", "Philippines Time"], ["Western European Standard Time", "GMT", "Western European Summer Time", "GMT+01:00", "Western European Time", "Portugal Time (Lisbon)"]], ["EDT", "GMT", "AST", "IRST", "ICT", "PET", "KST", "PST", "CDT", "EEST", "NZDT", "WEST", "EAT", "HKT", "IST", "MDT", "NZST", "WIT", "ADT", "BST", "ART", "CAT", "GST", "PDT", "SGT", "COT", "PKT", "EET", "UTC", "WAT", "EST", "JST", "CLST", "CET", "BDT", "MSK", "AKDT", "CLT", "AKST", "BRST", "BRT", "CEST", "CST", "HST", "MSD", "MST", "PHT", "WET"]));
    var date = (CPDate.isa.method_msgSend["date"] || _objj_forward)(CPDate, "date"),
        abbreviation = ((String(((String(date)).split("("))[1])).split(")"))[0];
    localTimeZone = (self.isa.method_msgSend["timeZoneWithAbbreviation:"] || _objj_forward)(self, "timeZoneWithAbbreviation:", abbreviation);
    systemTimeZone = (self.isa.method_msgSend["timeZoneWithAbbreviation:"] || _objj_forward)(self, "timeZoneWithAbbreviation:", abbreviation);
    defaultTimeZone = (self.isa.method_msgSend["timeZoneWithAbbreviation:"] || _objj_forward)(self, "timeZoneWithAbbreviation:", abbreviation);
    localizedName = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithObjects:forKeys:"] || _objj_forward)(___r1, "initWithObjects:forKeys:", [englishLocalizedName, (___r2 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r2 == null ? null : (___r2.isa.method_msgSend["init"] || _objj_forward)(___r2, "init")), (___r2 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r2 == null ? null : (___r2.isa.method_msgSend["init"] || _objj_forward)(___r2, "init")), (___r2 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r2 == null ? null : (___r2.isa.method_msgSend["init"] || _objj_forward)(___r2, "init"))], ["en", "fr", "de", "es"]));
    timeZoneDataVersion = nil;
    var ___r1, ___r2;
}
,["void"]), new objj_method(sel_getUid("timeZoneWithAbbreviation:"), function(self, _cmd, abbreviation)
{
    if (!(abbreviationDictionary == null ? null : (abbreviationDictionary.isa.method_msgSend["containsKey:"] || _objj_forward)(abbreviationDictionary, "containsKey:", abbreviation)))
        return nil;
    return ((___r1 = (CPTimeZone.isa.method_msgSend["alloc"] || _objj_forward)(CPTimeZone, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["_initWithName:abbreviation:"] || _objj_forward)(___r1, "_initWithName:abbreviation:", (abbreviationDictionary == null ? null : (abbreviationDictionary.isa.method_msgSend["valueForKey:"] || _objj_forward)(abbreviationDictionary, "valueForKey:", abbreviation)), abbreviation));
    var ___r1;
}
,["id","CPString"]), new objj_method(sel_getUid("timeZoneWithName:"), function(self, _cmd, tzName)
{
    return ((___r1 = (CPTimeZone.isa.method_msgSend["alloc"] || _objj_forward)(CPTimeZone, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithName:"] || _objj_forward)(___r1, "initWithName:", tzName));
    var ___r1;
}
,["id","CPString"]), new objj_method(sel_getUid("timeZoneWithName:data:"), function(self, _cmd, tzName, data)
{
    return ((___r1 = (CPTimeZone.isa.method_msgSend["alloc"] || _objj_forward)(CPTimeZone, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithName:data:"] || _objj_forward)(___r1, "initWithName:data:", tzName, data));
    var ___r1;
}
,["id","CPString","CPData"]), new objj_method(sel_getUid("timeZoneForSecondsFromGMT:"), function(self, _cmd, seconds)
{
    var minutes = seconds / 60,
        keys = (timeDifferenceFromUTC == null ? null : (timeDifferenceFromUTC.isa.method_msgSend["keyEnumerator"] || _objj_forward)(timeDifferenceFromUTC, "keyEnumerator")),
        key,
        abbreviation = nil;
    while (key = (keys == null ? null : (keys.isa.method_msgSend["nextObject"] || _objj_forward)(keys, "nextObject")))
    {
        var value = (timeDifferenceFromUTC == null ? null : (timeDifferenceFromUTC.isa.method_msgSend["valueForKey:"] || _objj_forward)(timeDifferenceFromUTC, "valueForKey:", key));
        if (value == minutes)
        {
            abbreviation = key;
            break;
        }
    }
    if (!abbreviation)
        return nil;
    return (self.isa.method_msgSend["timeZoneWithAbbreviation:"] || _objj_forward)(self, "timeZoneWithAbbreviation:", abbreviation);
}
,["id","CPInteger"]), new objj_method(sel_getUid("_timeZoneFromString:style:locale:"), function(self, _cmd, aTimeZoneString, style, _locale)
{
    if ((abbreviationDictionary == null ? null : (abbreviationDictionary.isa.method_msgSend["containsKey:"] || _objj_forward)(abbreviationDictionary, "containsKey:", aTimeZoneString)))
        return (self.isa.method_msgSend["timeZoneWithAbbreviation:"] || _objj_forward)(self, "timeZoneWithAbbreviation:", aTimeZoneString);
    var dict = (localizedName == null ? null : (localizedName.isa.method_msgSend["valueForKey:"] || _objj_forward)(localizedName, "valueForKey:", (_locale == null ? null : (_locale.isa.method_msgSend["objectForKey:"] || _objj_forward)(_locale, "objectForKey:", CPLocaleLanguageCode)))),
        keys = (dict == null ? null : (dict.isa.method_msgSend["keyEnumerator"] || _objj_forward)(dict, "keyEnumerator")),
        key;
    while (key = (keys == null ? null : (keys.isa.method_msgSend["nextObject"] || _objj_forward)(keys, "nextObject")))
    {
        var value = ((___r1 = (dict == null ? null : (dict.isa.method_msgSend["valueForKey:"] || _objj_forward)(dict, "valueForKey:", key))), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", style));
        if ((value == null ? null : (value.isa.method_msgSend["isEqualToString:"] || _objj_forward)(value, "isEqualToString:", aTimeZoneString)))
            return (self.isa.method_msgSend["timeZoneWithAbbreviation:"] || _objj_forward)(self, "timeZoneWithAbbreviation:", key);
    }
    return nil;
    var ___r1;
}
,["id","CPString","NSTimeZoneNameStyle","CPLocale"]), new objj_method(sel_getUid("_namesForStyle:locale:"), function(self, _cmd, style, aLocale)
{
    var array = (CPArray.isa.method_msgSend["array"] || _objj_forward)(CPArray, "array"),
        dict = (localizedName == null ? null : (localizedName.isa.method_msgSend["valueForKey:"] || _objj_forward)(localizedName, "valueForKey:", (aLocale == null ? null : (aLocale.isa.method_msgSend["objectForKey:"] || _objj_forward)(aLocale, "objectForKey:", CPLocaleLanguageCode)))),
        keys = (dict == null ? null : (dict.isa.method_msgSend["keyEnumerator"] || _objj_forward)(dict, "keyEnumerator")),
        key;
    while (key = (keys == null ? null : (keys.isa.method_msgSend["nextObject"] || _objj_forward)(keys, "nextObject")))
        (array == null ? null : (array.isa.method_msgSend["addObject:"] || _objj_forward)(array, "addObject:", ((___r1 = (dict == null ? null : (dict.isa.method_msgSend["valueForKey:"] || _objj_forward)(dict, "valueForKey:", key))), ___r1 == null ? null : (___r1.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(___r1, "objectAtIndex:", style))));
    return array;
    var ___r1;
}
,["CPArray","NSTimeZoneNameStyle","CPLocale"]), new objj_method(sel_getUid("timeZoneDataVersion"), function(self, _cmd)
{
    return timeZoneDataVersion;
}
,["CPString"]), new objj_method(sel_getUid("localTimeZone"), function(self, _cmd)
{
    return localTimeZone;
}
,["CPTimeZone"]), new objj_method(sel_getUid("defaultTimeZone"), function(self, _cmd)
{
    return defaultTimeZone;
}
,["CPTimeZone"]), new objj_method(sel_getUid("setDefaultTimeZone:"), function(self, _cmd, aTimeZone)
{
    defaultTimeZone = aTimeZone;
}
,["void","CPTimeZone"]), new objj_method(sel_getUid("resetSystemTimeZone"), function(self, _cmd)
{
    var date = (CPDate.isa.method_msgSend["date"] || _objj_forward)(CPDate, "date"),
        abbreviation = ((String(((String(date)).split("("))[1])).split(")"))[0];
    systemTimeZone = (self.isa.method_msgSend["timeZoneWithAbbreviation:"] || _objj_forward)(self, "timeZoneWithAbbreviation:", abbreviation);
    ((___r1 = (CPNotification.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotification, "defaultCenter")), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(___r1, "postNotificationName:object:", CPSystemTimeZoneDidChangeNotification, systemTimeZone));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("systemTimeZone"), function(self, _cmd)
{
    return systemTimeZone;
}
,["CPTimeZone"]), new objj_method(sel_getUid("abbreviationDictionary"), function(self, _cmd)
{
    return abbreviationDictionary;
}
,["CPDictionary"]), new objj_method(sel_getUid("setAbbreviationDictionary:"), function(self, _cmd, dict)
{
    abbreviationDictionary = dict;
}
,["void","CPDictionary"]), new objj_method(sel_getUid("knownTimeZoneNames"), function(self, _cmd)
{
    return knownTimeZoneNames;
}
,["CPArray"])]);
}p;15;CPUndoManager.jt;33706;@STATIC;1.0;i;9;CPArray.ji;13;CPException.ji;14;CPInvocation.ji;22;CPNotificationCenter.ji;10;CPObject.ji;9;CPProxy.ji;21;CPKeyValueObserving.ji;11;CPRunLoop.jt;33539;objj_executeFile("CPArray.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPInvocation.j", YES);objj_executeFile("CPNotificationCenter.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPProxy.j", YES);objj_executeFile("CPKeyValueObserving.j", YES);objj_executeFile("CPRunLoop.j", YES);var CPUndoManagerNormal = 0,
    CPUndoManagerUndoing = 1,
    CPUndoManagerRedoing = 2;
CPUndoManagerCheckpointNotification = "CPUndoManagerCheckpointNotification";
CPUndoManagerDidOpenUndoGroupNotification = "CPUndoManagerDidOpenUndoGroupNotification";
CPUndoManagerDidCloseUndoGroupNotification = "CPUndoManagerDidCloseUndoGroupNotification";
CPUndoManagerDidRedoChangeNotification = "CPUndoManagerDidRedoChangeNotification";
CPUndoManagerDidUndoChangeNotification = "CPUndoManagerDidUndoChangeNotification";
CPUndoManagerWillCloseUndoGroupNotification = "CPUndoManagerWillCloseUndoGroupNotification";
CPUndoManagerWillRedoChangeNotification = "CPUndoManagerWillRedoChangeNotification";
CPUndoManagerWillUndoChangeNotification = "CPUndoManagerWillUndoChangeNotification";
CPUndoCloseGroupingRunLoopOrdering = 350000;
var _CPUndoGroupingPool = [],
    _CPUndoGroupingPoolCapacity = 5;
{var the_class = objj_allocateClassPair(CPObject, "_CPUndoGrouping"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_parent", "id"), new objj_ivar("_invocations", "CPMutableArray"), new objj_ivar("_actionName", "CPString")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithParent:"), function(self, _cmd, anUndoGrouping)
{
    self = (objj_getClass("_CPUndoGrouping").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._parent = anUndoGrouping;
        self._invocations = [];
        self._actionName = "";
    }
    return self;
}
,["id","_CPUndoGrouping"]), new objj_method(sel_getUid("parent"), function(self, _cmd)
{
    return self._parent;
}
,["_CPUndoGrouping"]), new objj_method(sel_getUid("addInvocation:"), function(self, _cmd, anInvocation)
{
    self._invocations.push(anInvocation);
}
,["void","CPInvocation"]), new objj_method(sel_getUid("addInvocationsFromArray:"), function(self, _cmd, invocations)
{
    ((___r1 = self._invocations), ___r1 == null ? null : (___r1.isa.method_msgSend["addObjectsFromArray:"] || _objj_forward)(___r1, "addObjectsFromArray:", invocations));
    var ___r1;
}
,["void","CPArray"]), new objj_method(sel_getUid("removeInvocationsWithTarget:"), function(self, _cmd, aTarget)
{
    var index = self._invocations.length;
    while (index--)
        if (((___r1 = self._invocations[index]), ___r1 == null ? null : (___r1.isa.method_msgSend["target"] || _objj_forward)(___r1, "target")) == aTarget)
            self._invocations.splice(index, 1);
    var ___r1;
}
,["BOOL","id"]), new objj_method(sel_getUid("invocations"), function(self, _cmd)
{
    return self._invocations;
}
,["CPArray"]), new objj_method(sel_getUid("invoke"), function(self, _cmd)
{
    var index = self._invocations.length;
    while (index--)
        ((___r1 = self._invocations[index]), ___r1 == null ? null : (___r1.isa.method_msgSend["invoke"] || _objj_forward)(___r1, "invoke"));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("setActionName:"), function(self, _cmd, aName)
{
    self._actionName = aName;
}
,["void","CPString"]), new objj_method(sel_getUid("actionName"), function(self, _cmd)
{
    return self._actionName;
}
,["CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("_poolUndoGrouping:"), function(self, _cmd, anUndoGrouping)
{
    if (!anUndoGrouping || _CPUndoGroupingPool.length >= _CPUndoGroupingPoolCapacity)
        return;
    _CPUndoGroupingPool.push(anUndoGrouping);
}
,["void","_CPUndoGrouping"]), new objj_method(sel_getUid("undoGroupingWithParent:"), function(self, _cmd, anUndoGrouping)
{
    if (_CPUndoGroupingPool.length)
    {
        var grouping = _CPUndoGroupingPool.pop();
        grouping._parent = anUndoGrouping;
        if (grouping._invocations.length)
            grouping._invocations = [];
        return grouping;
    }
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithParent:"] || _objj_forward)(___r1, "initWithParent:", anUndoGrouping));
    var ___r1;
}
,["id","_CPUndoGrouping"])]);
}var _CPUndoGroupingParentKey = "_CPUndoGroupingParentKey",
    _CPUndoGroupingInvocationsKey = "_CPUndoGroupingInvocationsKey",
    _CPUndoGroupingActionNameKey = "_CPUndoGroupingActionNameKey";
{
var the_class = objj_getClass("_CPUndoGrouping")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"_CPUndoGrouping\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    self = (objj_getClass("_CPUndoGrouping").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._parent = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", _CPUndoGroupingParentKey));
        self._invocations = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", _CPUndoGroupingInvocationsKey));
        self._actionName = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", _CPUndoGroupingActionNameKey));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._parent, _CPUndoGroupingParentKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._invocations, _CPUndoGroupingInvocationsKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._actionName, _CPUndoGroupingActionNameKey));
}
,["void","CPCoder"])]);
}{var the_class = objj_allocateClassPair(CPObject, "CPUndoManager"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_redoStack", "CPMutableArray"), new objj_ivar("_undoStack", "CPMutableArray"), new objj_ivar("_groupsByEvent", "BOOL"), new objj_ivar("_disableCount", "int"), new objj_ivar("_levelsOfUndo", "int"), new objj_ivar("_currentGrouping", "id"), new objj_ivar("_state", "int"), new objj_ivar("_preparedTarget", "id"), new objj_ivar("_undoManagerProxy", "id"), new objj_ivar("_runLoopModes", "CPArray"), new objj_ivar("_registeredWithRunLoop", "BOOL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPUndoManager").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._redoStack = [];
        self._undoStack = [];
        self._disableCount = 0;
        self._state = CPUndoManagerNormal;
        (self == null ? null : (self.isa.method_msgSend["setRunLoopModes:"] || _objj_forward)(self, "setRunLoopModes:", [CPDefaultRunLoopMode]));
        (self == null ? null : (self.isa.method_msgSend["setGroupsByEvent:"] || _objj_forward)(self, "setGroupsByEvent:", YES));
        self._undoManagerProxy = (_CPUndoManagerProxy == null ? null : (_CPUndoManagerProxy.isa.method_msgSend["alloc"] || _objj_forward)(_CPUndoManagerProxy, "alloc"));
        self._undoManagerProxy._undoManager = self;
    }
    return self;
}
,["id"]), new objj_method(sel_getUid("_addUndoInvocation:"), function(self, _cmd, anInvocation)
{
    if (!self._currentGrouping)
        if ((self.isa.method_msgSend["groupsByEvent"] || _objj_forward)(self, "groupsByEvent"))
            (self.isa.method_msgSend["_beginUndoGroupingForEvent"] || _objj_forward)(self, "_beginUndoGroupingForEvent");
        else
            (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInternalInconsistencyException, "No undo group is currently open");
    ((___r1 = self._currentGrouping), ___r1 == null ? null : (___r1.isa.method_msgSend["addInvocation:"] || _objj_forward)(___r1, "addInvocation:", anInvocation));
    if (self._state === CPUndoManagerNormal)
        ((___r1 = self._redoStack), ___r1 == null ? null : (___r1.isa.method_msgSend["removeAllObjects"] || _objj_forward)(___r1, "removeAllObjects"));
    var ___r1;
}
,["void","CPInvocation"]), new objj_method(sel_getUid("registerUndoWithTarget:selector:object:"), function(self, _cmd, aTarget, aSelector, anObject)
{
    if (self._disableCount > 0)
        return;
    var invocation = (CPInvocation.isa.method_msgSend["invocationWithMethodSignature:"] || _objj_forward)(CPInvocation, "invocationWithMethodSignature:", nil);
    (invocation == null ? null : (invocation.isa.method_msgSend["setTarget:"] || _objj_forward)(invocation, "setTarget:", aTarget));
    (invocation == null ? null : (invocation.isa.method_msgSend["setSelector:"] || _objj_forward)(invocation, "setSelector:", aSelector));
    (invocation == null ? null : (invocation.isa.method_msgSend["setArgument:atIndex:"] || _objj_forward)(invocation, "setArgument:atIndex:", anObject, 2));
    (self.isa.method_msgSend["_addUndoInvocation:"] || _objj_forward)(self, "_addUndoInvocation:", invocation);
}
,["void","id","SEL","id"]), new objj_method(sel_getUid("prepareWithInvocationTarget:"), function(self, _cmd, aTarget)
{
    self._preparedTarget = aTarget;
    return self._undoManagerProxy;
}
,["id","id"]), new objj_method(sel_getUid("_methodSignatureOfPreparedTargetForSelector:"), function(self, _cmd, aSelector)
{
    if (((___r1 = self._preparedTarget), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", aSelector)))
        return 1;
    return nil;
    var ___r1;
}
,["CPMethodSignature","SEL"]), new objj_method(sel_getUid("_forwardInvocationToPreparedTarget:"), function(self, _cmd, anInvocation)
{
    if (self._disableCount > 0)
        return;
    (anInvocation == null ? null : (anInvocation.isa.method_msgSend["setTarget:"] || _objj_forward)(anInvocation, "setTarget:", self._preparedTarget));
    (self.isa.method_msgSend["_addUndoInvocation:"] || _objj_forward)(self, "_addUndoInvocation:", anInvocation);
    self._preparedTarget = nil;
}
,["void","CPInvocation"]), new objj_method(sel_getUid("canRedo"), function(self, _cmd)
{
    ((___r1 = (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter")), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(___r1, "postNotificationName:object:", CPUndoManagerCheckpointNotification, self));
    return ((___r1 = self._redoStack), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")) > 0;
    var ___r1;
}
,["BOOL"]), new objj_method(sel_getUid("canUndo"), function(self, _cmd)
{
    if (self._undoStack.length > 0)
        return YES;
    return ((___r1 = ((___r2 = self._currentGrouping), ___r2 == null ? null : (___r2.isa.method_msgSend["invocations"] || _objj_forward)(___r2, "invocations"))), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")) > 0;
    var ___r1, ___r2;
}
,["BOOL"]), new objj_method(sel_getUid("undo"), function(self, _cmd)
{
    if ((self.isa.method_msgSend["groupingLevel"] || _objj_forward)(self, "groupingLevel") === 1)
        (self.isa.method_msgSend["endUndoGrouping"] || _objj_forward)(self, "endUndoGrouping");
    (self.isa.method_msgSend["undoNestedGroup"] || _objj_forward)(self, "undoNestedGroup");
}
,["void"]), new objj_method(sel_getUid("undoNestedGroup"), function(self, _cmd)
{
    if (((___r1 = self._undoStack), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")) <= 0)
        return;
    var defaultCenter = (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter");
    (defaultCenter == null ? null : (defaultCenter.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(defaultCenter, "postNotificationName:object:", CPUndoManagerCheckpointNotification, self));
    (defaultCenter == null ? null : (defaultCenter.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(defaultCenter, "postNotificationName:object:", CPUndoManagerWillUndoChangeNotification, self));
    var undoGrouping = self._undoStack.pop(),
        actionName = (undoGrouping == null ? null : (undoGrouping.isa.method_msgSend["actionName"] || _objj_forward)(undoGrouping, "actionName"));
    self._state = CPUndoManagerUndoing;
    (self.isa.method_msgSend["_beginUndoGrouping"] || _objj_forward)(self, "_beginUndoGrouping");
    (undoGrouping == null ? null : (undoGrouping.isa.method_msgSend["invoke"] || _objj_forward)(undoGrouping, "invoke"));
    (self.isa.method_msgSend["endUndoGrouping"] || _objj_forward)(self, "endUndoGrouping");
    (_CPUndoGrouping.isa.method_msgSend["_poolUndoGrouping:"] || _objj_forward)(_CPUndoGrouping, "_poolUndoGrouping:", undoGrouping);
    self._state = CPUndoManagerNormal;
    ((___r1 = ((___r2 = self._redoStack), ___r2 == null ? null : (___r2.isa.method_msgSend["lastObject"] || _objj_forward)(___r2, "lastObject"))), ___r1 == null ? null : (___r1.isa.method_msgSend["setActionName:"] || _objj_forward)(___r1, "setActionName:", actionName));
    (defaultCenter == null ? null : (defaultCenter.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(defaultCenter, "postNotificationName:object:", CPUndoManagerDidUndoChangeNotification, self));
    var ___r1, ___r2;
}
,["void"]), new objj_method(sel_getUid("redo"), function(self, _cmd)
{
    if (((___r1 = self._redoStack), ___r1 == null ? null : (___r1.isa.method_msgSend["count"] || _objj_forward)(___r1, "count")) <= 0)
        return;
    var defaultCenter = (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter");
    (defaultCenter == null ? null : (defaultCenter.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(defaultCenter, "postNotificationName:object:", CPUndoManagerCheckpointNotification, self));
    (defaultCenter == null ? null : (defaultCenter.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(defaultCenter, "postNotificationName:object:", CPUndoManagerWillRedoChangeNotification, self));
    var oldUndoGrouping = self._currentGrouping,
        undoGrouping = self._redoStack.pop(),
        actionName = (undoGrouping == null ? null : (undoGrouping.isa.method_msgSend["actionName"] || _objj_forward)(undoGrouping, "actionName"));
    self._currentGrouping = nil;
    self._state = CPUndoManagerRedoing;
    (self.isa.method_msgSend["_beginUndoGrouping"] || _objj_forward)(self, "_beginUndoGrouping");
    (undoGrouping == null ? null : (undoGrouping.isa.method_msgSend["invoke"] || _objj_forward)(undoGrouping, "invoke"));
    (self.isa.method_msgSend["endUndoGrouping"] || _objj_forward)(self, "endUndoGrouping");
    (_CPUndoGrouping.isa.method_msgSend["_poolUndoGrouping:"] || _objj_forward)(_CPUndoGrouping, "_poolUndoGrouping:", undoGrouping);
    self._currentGrouping = oldUndoGrouping;
    self._state = CPUndoManagerNormal;
    ((___r1 = ((___r2 = self._undoStack), ___r2 == null ? null : (___r2.isa.method_msgSend["lastObject"] || _objj_forward)(___r2, "lastObject"))), ___r1 == null ? null : (___r1.isa.method_msgSend["setActionName:"] || _objj_forward)(___r1, "setActionName:", actionName));
    (defaultCenter == null ? null : (defaultCenter.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(defaultCenter, "postNotificationName:object:", CPUndoManagerDidRedoChangeNotification, self));
    var ___r1, ___r2;
}
,["void"]), new objj_method(sel_getUid("beginUndoGrouping"), function(self, _cmd)
{
    if (!self._currentGrouping && (self.isa.method_msgSend["groupsByEvent"] || _objj_forward)(self, "groupsByEvent"))
        (self.isa.method_msgSend["_beginUndoGroupingForEvent"] || _objj_forward)(self, "_beginUndoGroupingForEvent");
    ((___r1 = (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter")), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(___r1, "postNotificationName:object:", CPUndoManagerCheckpointNotification, self));
    (self.isa.method_msgSend["_beginUndoGrouping"] || _objj_forward)(self, "_beginUndoGrouping");
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("_beginUndoGroupingForEvent"), function(self, _cmd)
{
    (self.isa.method_msgSend["_beginUndoGrouping"] || _objj_forward)(self, "_beginUndoGrouping");
    (self.isa.method_msgSend["_registerWithRunLoop"] || _objj_forward)(self, "_registerWithRunLoop");
}
,["void"]), new objj_method(sel_getUid("_beginUndoGrouping"), function(self, _cmd)
{
    self._currentGrouping = (_CPUndoGrouping.isa.method_msgSend["undoGroupingWithParent:"] || _objj_forward)(_CPUndoGrouping, "undoGroupingWithParent:", self._currentGrouping);
}
,["void"]), new objj_method(sel_getUid("endUndoGrouping"), function(self, _cmd)
{
    if (!self._currentGrouping)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInternalInconsistencyException, "endUndoGrouping. No undo group is currently open.");
    var defaultCenter = (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter");
    (defaultCenter == null ? null : (defaultCenter.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(defaultCenter, "postNotificationName:object:", CPUndoManagerCheckpointNotification, self));
    var parent = ((___r1 = self._currentGrouping), ___r1 == null ? null : (___r1.isa.method_msgSend["parent"] || _objj_forward)(___r1, "parent"));
    if (!parent && ((___r1 = self._currentGrouping), ___r1 == null ? null : (___r1.isa.method_msgSend["invocations"] || _objj_forward)(___r1, "invocations")).length > 0)
    {
        (defaultCenter == null ? null : (defaultCenter.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(defaultCenter, "postNotificationName:object:", CPUndoManagerWillCloseUndoGroupNotification, self));
        var stack = self._state === CPUndoManagerUndoing ? self._redoStack : self._undoStack;
        stack.push(self._currentGrouping);
        if (self._levelsOfUndo > 0 && stack.length > self._levelsOfUndo)
            stack.splice(0, 1);
        (defaultCenter == null ? null : (defaultCenter.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(defaultCenter, "postNotificationName:object:", CPUndoManagerDidCloseUndoGroupNotification, self));
    }
    else
    {
        (parent == null ? null : (parent.isa.method_msgSend["addInvocationsFromArray:"] || _objj_forward)(parent, "addInvocationsFromArray:", ((___r1 = self._currentGrouping), ___r1 == null ? null : (___r1.isa.method_msgSend["invocations"] || _objj_forward)(___r1, "invocations"))));
        (_CPUndoGrouping.isa.method_msgSend["_poolUndoGrouping:"] || _objj_forward)(_CPUndoGrouping, "_poolUndoGrouping:", self._currentGrouping);
    }
    self._currentGrouping = parent;
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("enableUndoRegistration"), function(self, _cmd)
{
    if (self._disableCount <= 0)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInternalInconsistencyException, "enableUndoRegistration. There are no disable messages in effect right now.");
    self._disableCount--;
}
,["void"]), new objj_method(sel_getUid("groupsByEvent"), function(self, _cmd)
{
    return self._groupsByEvent;
}
,["BOOL"]), new objj_method(sel_getUid("setGroupsByEvent:"), function(self, _cmd, aFlag)
{
    aFlag = !!aFlag;
    if (self._groupsByEvent === aFlag)
        return;
    self._groupsByEvent = aFlag;
    if (!(self.isa.method_msgSend["groupsByEvent"] || _objj_forward)(self, "groupsByEvent"))
        (self.isa.method_msgSend["_unregisterWithRunLoop"] || _objj_forward)(self, "_unregisterWithRunLoop");
}
,["void","BOOL"]), new objj_method(sel_getUid("groupingLevel"), function(self, _cmd)
{
    var grouping = self._currentGrouping,
        level = self._currentGrouping ? 1 : 0;
    while (grouping = (grouping == null ? null : (grouping.isa.method_msgSend["parent"] || _objj_forward)(grouping, "parent")))
        ++level;
    return level;
}
,["unsigned"]), new objj_method(sel_getUid("disableUndoRegistration"), function(self, _cmd)
{
    ++self._disableCount;
}
,["void"]), new objj_method(sel_getUid("isUndoRegistrationEnabled"), function(self, _cmd)
{
    return self._disableCount == 0;
}
,["BOOL"]), new objj_method(sel_getUid("isUndoing"), function(self, _cmd)
{
    return self._state === CPUndoManagerUndoing;
}
,["BOOL"]), new objj_method(sel_getUid("isRedoing"), function(self, _cmd)
{
    return self._state === CPUndoManagerRedoing;
}
,["BOOL"]), new objj_method(sel_getUid("removeAllActions"), function(self, _cmd)
{
    while (self._currentGrouping)
        (self.isa.method_msgSend["endUndoGrouping"] || _objj_forward)(self, "endUndoGrouping");
    (self.isa.method_msgSend["_unregisterWithRunLoop"] || _objj_forward)(self, "_unregisterWithRunLoop");
    self._state = CPUndoManagerNormal;
    self._redoStack = [];
    self._undoStack = [];
    self._disableCount = 0;
}
,["void"]), new objj_method(sel_getUid("removeAllActionsWithTarget:"), function(self, _cmd, aTarget)
{
    ((___r1 = self._currentGrouping), ___r1 == null ? null : (___r1.isa.method_msgSend["removeInvocationsWithTarget:"] || _objj_forward)(___r1, "removeInvocationsWithTarget:", aTarget));
    var index = self._redoStack.length;
    while (index--)
    {
        var grouping = self._redoStack[index];
        (grouping == null ? null : (grouping.isa.method_msgSend["removeInvocationsWithTarget:"] || _objj_forward)(grouping, "removeInvocationsWithTarget:", aTarget));
        if (!(grouping == null ? null : (grouping.isa.method_msgSend["invocations"] || _objj_forward)(grouping, "invocations")).length)
            self._redoStack.splice(index, 1);
    }
    index = self._undoStack.length;
    while (index--)
    {
        var grouping = self._undoStack[index];
        (grouping == null ? null : (grouping.isa.method_msgSend["removeInvocationsWithTarget:"] || _objj_forward)(grouping, "removeInvocationsWithTarget:", aTarget));
        if (!(grouping == null ? null : (grouping.isa.method_msgSend["invocations"] || _objj_forward)(grouping, "invocations")).length)
            self._undoStack.splice(index, 1);
    }
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("setActionName:"), function(self, _cmd, anActionName)
{
    if (anActionName !== nil && self._currentGrouping)
        ((___r1 = self._currentGrouping), ___r1 == null ? null : (___r1.isa.method_msgSend["setActionName:"] || _objj_forward)(___r1, "setActionName:", anActionName));
    var ___r1;
}
,["void","CPString"]), new objj_method(sel_getUid("redoActionName"), function(self, _cmd)
{
    if (!(self.isa.method_msgSend["canRedo"] || _objj_forward)(self, "canRedo"))
        return nil;
    return ((___r1 = ((___r2 = self._redoStack), ___r2 == null ? null : (___r2.isa.method_msgSend["lastObject"] || _objj_forward)(___r2, "lastObject"))), ___r1 == null ? null : (___r1.isa.method_msgSend["actionName"] || _objj_forward)(___r1, "actionName"));
    var ___r1, ___r2;
}
,["CPString"]), new objj_method(sel_getUid("redoMenuItemTitle"), function(self, _cmd)
{
    return (self.isa.method_msgSend["redoMenuTitleForUndoActionName:"] || _objj_forward)(self, "redoMenuTitleForUndoActionName:", (self.isa.method_msgSend["redoActionName"] || _objj_forward)(self, "redoActionName"));
}
,["CPString"]), new objj_method(sel_getUid("redoMenuTitleForUndoActionName:"), function(self, _cmd, anActionName)
{
    if (anActionName || anActionName === 0)
        return "Redo " + anActionName;
    return "Redo";
}
,["CPString","CPString"]), new objj_method(sel_getUid("undoActionName"), function(self, _cmd)
{
    if (!(self.isa.method_msgSend["canUndo"] || _objj_forward)(self, "canUndo"))
        return nil;
    return ((___r1 = ((___r2 = self._undoStack), ___r2 == null ? null : (___r2.isa.method_msgSend["lastObject"] || _objj_forward)(___r2, "lastObject"))), ___r1 == null ? null : (___r1.isa.method_msgSend["actionName"] || _objj_forward)(___r1, "actionName"));
    var ___r1, ___r2;
}
,["CPString"]), new objj_method(sel_getUid("undoMenuItemTitle"), function(self, _cmd)
{
    return (self.isa.method_msgSend["undoMenuTitleForUndoActionName:"] || _objj_forward)(self, "undoMenuTitleForUndoActionName:", (self.isa.method_msgSend["undoActionName"] || _objj_forward)(self, "undoActionName"));
}
,["CPString"]), new objj_method(sel_getUid("undoMenuTitleForUndoActionName:"), function(self, _cmd, anActionName)
{
    if (anActionName || anActionName === 0)
        return "Undo " + anActionName;
    return "Undo";
}
,["CPString","CPString"]), new objj_method(sel_getUid("runLoopModes"), function(self, _cmd)
{
    return self._runLoopModes;
}
,["CPArray"]), new objj_method(sel_getUid("setRunLoopModes:"), function(self, _cmd, modes)
{
    self._runLoopModes = (modes == null ? null : (modes.isa.method_msgSend["copy"] || _objj_forward)(modes, "copy"));
    if (self._registeredWithRunLoop)
    {
        (self.isa.method_msgSend["_unregisterWithRunLoop"] || _objj_forward)(self, "_unregisterWithRunLoop");
        (self.isa.method_msgSend["_registerWithRunLoop"] || _objj_forward)(self, "_registerWithRunLoop");
    }
}
,["void","CPArray"]), new objj_method(sel_getUid("_runLoopEndUndoGrouping"), function(self, _cmd)
{
    (self.isa.method_msgSend["endUndoGrouping"] || _objj_forward)(self, "endUndoGrouping");
    self._registeredWithRunLoop = NO;
}
,["void"]), new objj_method(sel_getUid("_registerWithRunLoop"), function(self, _cmd)
{
    if (self._registeredWithRunLoop)
        return;
    self._registeredWithRunLoop = YES;
    ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["performSelector:target:argument:order:modes:"] || _objj_forward)(___r1, "performSelector:target:argument:order:modes:", sel_getUid("_runLoopEndUndoGrouping"), self, nil, CPUndoCloseGroupingRunLoopOrdering, self._runLoopModes));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("_unregisterWithRunLoop"), function(self, _cmd)
{
    if (!self._registeredWithRunLoop)
        return;
    self._registeredWithRunLoop = NO;
    ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["cancelPerformSelector:target:argument:"] || _objj_forward)(___r1, "cancelPerformSelector:target:argument:", sel_getUid("_runLoopEndUndoGrouping"), self, nil));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("observeChangesForKeyPath:ofObject:"), function(self, _cmd, aKeyPath, anObject)
{
    (anObject == null ? null : (anObject.isa.method_msgSend["addObserver:forKeyPath:options:context:"] || _objj_forward)(anObject, "addObserver:forKeyPath:options:context:", self, aKeyPath, CPKeyValueObservingOptionOld | CPKeyValueObservingOptionNew, NULL));
}
,["void","CPString","id"]), new objj_method(sel_getUid("stopObservingChangesForKeyPath:ofObject:"), function(self, _cmd, aKeyPath, anObject)
{
    (anObject == null ? null : (anObject.isa.method_msgSend["removeObserver:forKeyPath:"] || _objj_forward)(anObject, "removeObserver:forKeyPath:", self, aKeyPath));
}
,["void","CPString","id"]), new objj_method(sel_getUid("observeValueForKeyPath:ofObject:change:context:"), function(self, _cmd, aKeyPath, anObject, aChange, aContext)
{
    var before = (aChange == null ? null : (aChange.isa.method_msgSend["valueForKey:"] || _objj_forward)(aChange, "valueForKey:", CPKeyValueChangeOldKey)),
        after = (aChange == null ? null : (aChange.isa.method_msgSend["valueForKey:"] || _objj_forward)(aChange, "valueForKey:", CPKeyValueChangeNewKey));
    if (before === after || before !== nil && before.isa && (after === nil || after.isa) && (before == null ? null : (before.isa.method_msgSend["isEqual:"] || _objj_forward)(before, "isEqual:", after)))
        return;
    ((___r1 = (self.isa.method_msgSend["prepareWithInvocationTarget:"] || _objj_forward)(self, "prepareWithInvocationTarget:", anObject)), ___r1 == null ? null : (___r1.isa.method_msgSend["applyChange:toKeyPath:"] || _objj_forward)(___r1, "applyChange:toKeyPath:", (aChange == null ? null : (aChange.isa.method_msgSend["inverseChangeDictionary"] || _objj_forward)(aChange, "inverseChangeDictionary")), aKeyPath));
    var ___r1;
}
,["void","CPString","id","CPDictionary","id"])]);
}var CPUndoManagerRedoStackKey = "CPUndoManagerRedoStackKey",
    CPUndoManagerUndoStackKey = "CPUndoManagerUndoStackKey",
    CPUndoManagerLevelsOfUndoKey = "CPUndoManagerLevelsOfUndoKey",
    CPUndoManagerActionNameKey = "CPUndoManagerActionNameKey",
    CPUndoManagerCurrentGroupingKey = "CPUndoManagerCurrentGroupingKey",
    CPUndoManagerRunLoopModesKey = "CPUndoManagerRunLoopModesKey",
    CPUndoManagerGroupsByEventKey = "CPUndoManagerGroupsByEventKey";
{
var the_class = objj_getClass("CPUndoManager")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPUndoManager\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    self = (objj_getClass("CPUndoManager").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._redoStack = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPUndoManagerRedoStackKey));
        self._undoStack = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPUndoManagerUndoStackKey));
        self._levelsOfUndo = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPUndoManagerLevelsOfUndoKey));
        self._currentGrouping = (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPUndoManagerCurrentGroupingKey));
        self._state = CPUndoManagerNormal;
        (self == null ? null : (self.isa.method_msgSend["setRunLoopModes:"] || _objj_forward)(self, "setRunLoopModes:", (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPUndoManagerRunLoopModesKey))));
        (self == null ? null : (self.isa.method_msgSend["setGroupsByEvent:"] || _objj_forward)(self, "setGroupsByEvent:", (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeBoolForKey:"] || _objj_forward)(aCoder, "decodeBoolForKey:", CPUndoManagerGroupsByEventKey))));
    }
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._redoStack, CPUndoManagerRedoStackKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._undoStack, CPUndoManagerUndoStackKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeInt:forKey:"] || _objj_forward)(aCoder, "encodeInt:forKey:", self._levelsOfUndo, CPUndoManagerLevelsOfUndoKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._currentGrouping, CPUndoManagerCurrentGroupingKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._runLoopModes, CPUndoManagerRunLoopModesKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeBool:forKey:"] || _objj_forward)(aCoder, "encodeBool:forKey:", self._groupsByEvent, CPUndoManagerGroupsByEventKey));
}
,["void","CPCoder"])]);
}{var the_class = objj_allocateClassPair(CPProxy, "_CPUndoManagerProxy"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_undoManager", "CPUndoManager")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("methodSignatureForSelector:"), function(self, _cmd, aSelector)
{
    return ((___r1 = self._undoManager), ___r1 == null ? null : (___r1.isa.method_msgSend["_methodSignatureOfPreparedTargetForSelector:"] || _objj_forward)(___r1, "_methodSignatureOfPreparedTargetForSelector:", aSelector));
    var ___r1;
}
,["CPMethodSignature","SEL"]), new objj_method(sel_getUid("forwardInvocation:"), function(self, _cmd, anInvocation)
{
    ((___r1 = self._undoManager), ___r1 == null ? null : (___r1.isa.method_msgSend["_forwardInvocationToPreparedTarget:"] || _objj_forward)(___r1, "_forwardInvocationToPreparedTarget:", anInvocation));
    var ___r1;
}
,["void","CPInvocation"])]);
}p;7;CPURL.jt;9376;@STATIC;1.0;i;10;CPObject.ji;10;CPString.jt;9327;objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);CPURLNameKey = "CPURLNameKey";
CPURLLocalizedNameKey = "CPURLLocalizedNameKey";
CPURLIsRegularFileKey = "CPURLIsRegularFileKey";
CPURLIsDirectoryKey = "CPURLIsDirectoryKey";
CPURLIsSymbolicLinkKey = "CPURLIsSymbolicLinkKey";
CPURLIsVolumeKey = "CPURLIsVolumeKey";
CPURLIsPackageKey = "CPURLIsPackageKey";
CPURLIsSystemImmutableKey = "CPURLIsSystemImmutableKey";
CPURLIsUserImmutableKey = "CPURLIsUserImmutableKey";
CPURLIsHiddenKey = "CPURLIsHiddenKey";
CPURLHasHiddenExtensionKey = "CPURLHasHiddenExtensionKey";
CPURLCreationDateKey = "CPURLCreationDateKey";
CPURLContentAccessDateKey = "CPURLContentAccessDateKey";
CPURLContentModificationDateKey = "CPURLContentModificationDateKey";
CPURLAttributeModificationDateKey = "CPURLAttributeModificationDateKey";
CPURLLinkCountKey = "CPURLLinkCountKey";
CPURLParentDirectoryURLKey = "CPURLParentDirectoryURLKey";
CPURLVolumeURLKey = "CPURLTypeIdentifierKey";
CPURLTypeIdentifierKey = "CPURLTypeIdentifierKey";
CPURLLocalizedTypeDescriptionKey = "CPURLLocalizedTypeDescriptionKey";
CPURLLabelNumberKey = "CPURLLabelNumberKey";
CPURLLabelColorKey = "CPURLLabelColorKey";
CPURLLocalizedLabelKey = "CPURLLocalizedLabelKey";
CPURLEffectiveIconKey = "CPURLEffectiveIconKey";
CPURLCustomIconKey = "CPURLCustomIconKey";
{var the_class = objj_allocateClassPair(CPObject, "CPURL"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    return nil;
}
,["id"]), new objj_method(sel_getUid("initWithScheme:host:path:"), function(self, _cmd, aScheme, aHost, aPath)
{
    var URLString = (aScheme ? aScheme + ":" : "") + (aHost ? aHost + "//" : "") + (aPath || "");
    return (self.isa.method_msgSend["initWithString:"] || _objj_forward)(self, "initWithString:", URLString);
}
,["id","CPString","CPString","CPString"]), new objj_method(sel_getUid("initWithString:"), function(self, _cmd, URLString)
{
    return (self.isa.method_msgSend["initWithString:relativeToURL:"] || _objj_forward)(self, "initWithString:relativeToURL:", URLString, nil);
}
,["id","CPString"]), new objj_method(sel_getUid("initWithString:relativeToURL:"), function(self, _cmd, URLString, aBaseURL)
{
    var result = new CFURL(URLString, aBaseURL);
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["id","CPString","CPURL"]), new objj_method(sel_getUid("absoluteURL"), function(self, _cmd)
{
    return self.absoluteURL();
}
,["CPURL"]), new objj_method(sel_getUid("baseURL"), function(self, _cmd)
{
    return self.baseURL();
}
,["CPURL"]), new objj_method(sel_getUid("absoluteString"), function(self, _cmd)
{
    return self.absoluteString();
}
,["CPString"]), new objj_method(sel_getUid("relativeString"), function(self, _cmd)
{
    return self.string();
}
,["CPString"]), new objj_method(sel_getUid("path"), function(self, _cmd)
{
    return (self.isa.method_msgSend["absoluteURL"] || _objj_forward)(self, "absoluteURL").path();
}
,["CPString"]), new objj_method(sel_getUid("pathComponents"), function(self, _cmd)
{
    var components = self.pathComponents();
    return (components == null ? null : (components.isa.method_msgSend["copy"] || _objj_forward)(components, "copy"));
}
,["CPArray"]), new objj_method(sel_getUid("relativePath"), function(self, _cmd)
{
    return self.path();
}
,["CPString"]), new objj_method(sel_getUid("scheme"), function(self, _cmd)
{
    return self.scheme();
}
,["CPString"]), new objj_method(sel_getUid("user"), function(self, _cmd)
{
    return (self.isa.method_msgSend["absoluteURL"] || _objj_forward)(self, "absoluteURL").user();
}
,["CPString"]), new objj_method(sel_getUid("password"), function(self, _cmd)
{
    return (self.isa.method_msgSend["absoluteURL"] || _objj_forward)(self, "absoluteURL").password();
}
,["CPString"]), new objj_method(sel_getUid("host"), function(self, _cmd)
{
    return (self.isa.method_msgSend["absoluteURL"] || _objj_forward)(self, "absoluteURL").domain();
}
,["CPString"]), new objj_method(sel_getUid("port"), function(self, _cmd)
{
    var portNumber = (self.isa.method_msgSend["absoluteURL"] || _objj_forward)(self, "absoluteURL").portNumber();
    if (portNumber === -1)
        return nil;
    return portNumber;
}
,["Number"]), new objj_method(sel_getUid("parameterString"), function(self, _cmd)
{
    return self.queryString();
}
,["CPString"]), new objj_method(sel_getUid("fragment"), function(self, _cmd)
{
    return self.fragment();
}
,["CPString"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    if (self === anObject)
        return YES;
    if (!anObject || !(anObject == null ? null : (anObject.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anObject, "isKindOfClass:", (CPURL.isa.method_msgSend["class"] || _objj_forward)(CPURL, "class"))))
        return NO;
    return (self.isa.method_msgSend["isEqualToURL:"] || _objj_forward)(self, "isEqualToURL:", anObject);
}
,["BOOL","id"]), new objj_method(sel_getUid("isEqualToURL:"), function(self, _cmd, aURL)
{
    if (self === aURL)
        return YES;
    return ((___r1 = (self.isa.method_msgSend["absoluteString"] || _objj_forward)(self, "absoluteString")), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqual:"] || _objj_forward)(___r1, "isEqual:", (aURL == null ? null : (aURL.isa.method_msgSend["absoluteString"] || _objj_forward)(aURL, "absoluteString"))));
    var ___r1;
}
,["BOOL","id"]), new objj_method(sel_getUid("lastPathComponent"), function(self, _cmd)
{
    return (self.isa.method_msgSend["absoluteURL"] || _objj_forward)(self, "absoluteURL").lastPathComponent();
}
,["CPString"]), new objj_method(sel_getUid("pathExtension"), function(self, _cmd)
{
    return self.pathExtension();
}
,["CPString"]), new objj_method(sel_getUid("URLByDeletingLastPathComponent"), function(self, _cmd)
{
    var result = self.createCopyDeletingLastPathComponent();
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["CPURL"]), new objj_method(sel_getUid("standardizedURL"), function(self, _cmd)
{
    return self.standardizedURL();
}
,["CPURL"]), new objj_method(sel_getUid("isFileURL"), function(self, _cmd)
{
    return (self.isa.method_msgSend["scheme"] || _objj_forward)(self, "scheme") === "file";
}
,["BOOL"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (self.isa.method_msgSend["absoluteString"] || _objj_forward)(self, "absoluteString");
}
,["CPString"]), new objj_method(sel_getUid("resourceValueForKey:"), function(self, _cmd, aKey)
{
    return self.resourcePropertyForKey(aKey);
}
,["id","CPString"]), new objj_method(sel_getUid("setResourceValue:forKey:"), function(self, _cmd, anObject, aKey)
{
    return self.setResourcePropertyForKey(aKey, anObject);
}
,["id","id","CPString"]), new objj_method(sel_getUid("staticResourceData"), function(self, _cmd)
{
    return self.staticResourceData();
}
,["CPData"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("alloc"), function(self, _cmd)
{
    var result = new CFURL();
    result.isa = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class");
    return result;
}
,["id"]), new objj_method(sel_getUid("URLWithString:"), function(self, _cmd, URLString)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:"] || _objj_forward)(___r1, "initWithString:", URLString));
    var ___r1;
}
,["id","CPString"]), new objj_method(sel_getUid("URLWithString:relativeToURL:"), function(self, _cmd, URLString, aBaseURL)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithString:relativeToURL:"] || _objj_forward)(___r1, "initWithString:relativeToURL:", URLString, aBaseURL));
    var ___r1;
}
,["id","CPString","CPURL"])]);
}var CPURLURLStringKey = "CPURLURLStringKey",
    CPURLBaseURLKey = "CPURLBaseURLKey";
{
var the_class = objj_getClass("CPURL")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPURL\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    return (self.isa.method_msgSend["initWithString:relativeToURL:"] || _objj_forward)(self, "initWithString:relativeToURL:", (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPURLURLStringKey)), (aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPURLBaseURLKey)));
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._baseURL, CPURLBaseURLKey));
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", self._string, CPURLURLStringKey));
}
,["void","CPCoder"])]);
}CFURL.prototype.isa = (CPURL.isa.method_msgSend["class"] || _objj_forward)(CPURL, "class");
p;17;CPURLConnection.jt;19415;@STATIC;1.0;i;8;CPData.ji;10;CPObject.ji;11;CPRunLoop.ji;14;CPURLRequest.ji;15;CPURLResponse.ji;18;CPOperationQueue.ji;13;CPOperation.jt;19272;objj_executeFile("CPData.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPRunLoop.j", YES);objj_executeFile("CPURLRequest.j", YES);objj_executeFile("CPURLResponse.j", YES);objj_executeFile("CPOperationQueue.j", YES);objj_executeFile("CPOperation.j", YES);{var the_protocol = objj_allocateProtocol("CPURLConnectionDelegate");
var aProtocol = objj_getProtocol("CPObject");
if (!aProtocol) throw new SyntaxError("*** Could not find definition for protocol \"CPURLConnectionDelegate\"");
protocol_addProtocol(the_protocol, aProtocol);
objj_registerProtocol(the_protocol);
protocol_addMethodDescriptions(the_protocol, [new objj_method(sel_getUid("connection:didFailWithError:"), Nil
,["void","CPURLConnection","CPException"]), new objj_method(sel_getUid("connection:didReceiveData:"), Nil
,["void","CPURLConnection","CPString"]), new objj_method(sel_getUid("connection:didReceiveResponse:"), Nil
,["void","CPURLConnection","CPString"]), new objj_method(sel_getUid("connectionDidFinishLoading:"), Nil
,["void","CPURLConnection"]), new objj_method(sel_getUid("connectionDidReceiveAuthenticationChallenge:"), Nil
,["void","CPURLConnection"])], true, true);
}{var the_typedef = objj_allocateTypeDef("HTTPRequest");
objj_registerTypeDef(the_typedef);
}var CPURLConnectionDelegate = nil;
{var the_class = objj_allocateClassPair(CPObject, "CPURLConnection"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_originalRequest", "CPURLRequest"), new objj_ivar("_request", "CPURLRequest"), new objj_ivar("_delegate", "id"), new objj_ivar("_isCanceled", "BOOL"), new objj_ivar("_isLocalFileConnection", "BOOL"), new objj_ivar("_HTTPRequest", "HTTPRequest"), new objj_ivar("_operationQueue", "CPOperationQueue"), new objj_ivar("_connectionOperation", "CPOperation")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("originalRequest"), function(self, _cmd)
{
    return self._originalRequest;
}
,["CPURLRequest"]), new objj_method(sel_getUid("currentRequest"), function(self, _cmd)
{
    return self._request;
}
,["CPURLRequest"]), new objj_method(sel_getUid("operation"), function(self, _cmd)
{
    return self._connectionOperation;
}
,["CPOperation"]), new objj_method(sel_getUid("initWithRequest:delegate:startImmediately:"), function(self, _cmd, aRequest, aDelegate, shouldStartImmediately)
{
    self = (objj_getClass("CPURLConnection").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._delegate = aDelegate;
        self._operationQueue = nil;
        self._connectionOperation = nil;
        (self == null ? null : (self.isa.method_msgSend["_initWithRequest:"] || _objj_forward)(self, "_initWithRequest:", aRequest));
    }
    if (shouldStartImmediately)
        (self == null ? null : (self.isa.method_msgSend["start"] || _objj_forward)(self, "start"));
    return self;
}
,["id","CPURLRequest","id","BOOL"]), new objj_method(sel_getUid("_initWithRequest:"), function(self, _cmd, aRequest)
{
    self._request = aRequest;
    self._originalRequest = (aRequest == null ? null : (aRequest.isa.method_msgSend["copy"] || _objj_forward)(aRequest, "copy"));
    self._isCanceled = NO;
    var URL = ((___r1 = self._request), ___r1 == null ? null : (___r1.isa.method_msgSend["URL"] || _objj_forward)(___r1, "URL")),
        scheme = (URL == null ? null : (URL.isa.method_msgSend["scheme"] || _objj_forward)(URL, "scheme"));
    self._isLocalFileConnection = scheme === "file" || (scheme === "http" || scheme === "https") && window.location && (window.location.protocol === "file:" || window.location.protocol === "app:");
    self._HTTPRequest = new CFHTTPRequest();
    self._HTTPRequest.setTimeout((aRequest == null ? null : (aRequest.isa.method_msgSend["timeoutInterval"] || _objj_forward)(aRequest, "timeoutInterval")) * 1000);
    self._HTTPRequest.setWithCredentials((aRequest == null ? null : (aRequest.isa.method_msgSend["withCredentials"] || _objj_forward)(aRequest, "withCredentials")));
    var ___r1;
}
,["void","CPURLRequest"]), new objj_method(sel_getUid("_initWithRequest:queue:completionHandler:"), function(self, _cmd, aRequest, aQueue, aHandler)
{
    self = (objj_getClass("CPURLConnection").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._delegate = nil;
        self._operationQueue = aQueue;
        self._connectionOperation = ((___r1 = (_AsynchronousConnectionOperation == null ? null : (_AsynchronousConnectionOperation.isa.method_msgSend["alloc"] || _objj_forward)(_AsynchronousConnectionOperation, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithFunction:"] || _objj_forward)(___r1, "initWithFunction:", aHandler));
        (self == null ? null : (self.isa.method_msgSend["_initWithRequest:"] || _objj_forward)(self, "_initWithRequest:", aRequest));
        (self == null ? null : (self.isa.method_msgSend["start"] || _objj_forward)(self, "start"));
    }
    return self;
    var ___r1;
}
,["id","CPURLRequest","CPOperationQueue","Function"]), new objj_method(sel_getUid("initWithRequest:delegate:"), function(self, _cmd, aRequest, aDelegate)
{
    return (self.isa.method_msgSend["initWithRequest:delegate:startImmediately:"] || _objj_forward)(self, "initWithRequest:delegate:startImmediately:", aRequest, aDelegate, YES);
}
,["id","CPURLRequest","id"]), new objj_method(sel_getUid("delegate"), function(self, _cmd)
{
    return self._delegate;
}
,["id"]), new objj_method(sel_getUid("start"), function(self, _cmd)
{
    self._isCanceled = NO;
    try    {
        self._HTTPRequest.open(((___r1 = self._request), ___r1 == null ? null : (___r1.isa.method_msgSend["HTTPMethod"] || _objj_forward)(___r1, "HTTPMethod")), ((___r1 = ((___r2 = self._request), ___r2 == null ? null : (___r2.isa.method_msgSend["URL"] || _objj_forward)(___r2, "URL"))), ___r1 == null ? null : (___r1.isa.method_msgSend["absoluteString"] || _objj_forward)(___r1, "absoluteString")), YES);
        self._HTTPRequest.onreadystatechange = function()
        {
            (self.isa.method_msgSend["_readyStateDidChange"] || _objj_forward)(self, "_readyStateDidChange");
        };
        self._HTTPRequest.ontimeout = function()
        {
            (self.isa.method_msgSend["_didTimeout"] || _objj_forward)(self, "_didTimeout");
        };
        var fields = ((___r1 = self._request), ___r1 == null ? null : (___r1.isa.method_msgSend["allHTTPHeaderFields"] || _objj_forward)(___r1, "allHTTPHeaderFields")),
            key = nil,
            keys = (fields == null ? null : (fields.isa.method_msgSend["keyEnumerator"] || _objj_forward)(fields, "keyEnumerator"));
        while ((key = (keys == null ? null : (keys.isa.method_msgSend["nextObject"] || _objj_forward)(keys, "nextObject"))) !== nil)
            self._HTTPRequest.setRequestHeader(key, (fields == null ? null : (fields.isa.method_msgSend["objectForKey:"] || _objj_forward)(fields, "objectForKey:", key)));
        self._HTTPRequest.send(((___r1 = self._request), ___r1 == null ? null : (___r1.isa.method_msgSend["HTTPBody"] || _objj_forward)(___r1, "HTTPBody")));
    }
    catch(anException)     {
        (self.isa.method_msgSend["_sendDelegateDidFailWithError:"] || _objj_forward)(self, "_sendDelegateDidFailWithError:", anException);
    }    var ___r1, ___r2;
}
,["void"]), new objj_method(sel_getUid("_sendDelegateDidFailWithError:"), function(self, _cmd, anException)
{
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("connection:didFailWithError:"))))
        ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["connection:didFailWithError:"] || _objj_forward)(___r1, "connection:didFailWithError:", self, anException));
    else if (self._connectionOperation !== nil)
        (self.isa.method_msgSend["_connectionOperationDidReceiveResponse:data:error:"] || _objj_forward)(self, "_connectionOperationDidReceiveResponse:data:error:", nil, nil, anException);
    var ___r1;
}
,["void","CPException"]), new objj_method(sel_getUid("cancel"), function(self, _cmd)
{
    self._isCanceled = YES;
    try    {
        self._HTTPRequest.abort();
        if (self._connectionOperation)
            ((___r1 = self._connectionOperation), ___r1 == null ? null : (___r1.isa.method_msgSend["cancel"] || _objj_forward)(___r1, "cancel"));
    }
    catch(anException)     {
    }    var ___r1;
}
,["void"]), new objj_method(sel_getUid("isLocalFileConnection"), function(self, _cmd)
{
    return self._isLocalFileConnection;
}
,["BOOL"]), new objj_method(sel_getUid("_didTimeout"), function(self, _cmd)
{
    var exception = (CPException.isa.method_msgSend["exceptionWithName:reason:userInfo:"] || _objj_forward)(CPException, "exceptionWithName:reason:userInfo:", "Timeout exception", "The request timed out.", (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init")));
    (self.isa.method_msgSend["_sendDelegateDidFailWithError:"] || _objj_forward)(self, "_sendDelegateDidFailWithError:", exception);
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("_readyStateDidChange"), function(self, _cmd)
{
    if (self._HTTPRequest.readyState() === CFHTTPRequest.CompleteState && !self._HTTPRequest.isTimeoutRequest())
    {
        var statusCode = self._HTTPRequest.status(),
            URL = ((___r1 = self._request), ___r1 == null ? null : (___r1.isa.method_msgSend["URL"] || _objj_forward)(___r1, "URL"));
        if (statusCode === 401 && (CPURLConnectionDelegate == null ? null : (CPURLConnectionDelegate.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(CPURLConnectionDelegate, "respondsToSelector:", sel_getUid("connectionDidReceiveAuthenticationChallenge:"))))
            (CPURLConnectionDelegate == null ? null : (CPURLConnectionDelegate.isa.method_msgSend["connectionDidReceiveAuthenticationChallenge:"] || _objj_forward)(CPURLConnectionDelegate, "connectionDidReceiveAuthenticationChallenge:", self));
        else
        {
            var response;
            if (self._isLocalFileConnection)
                response = ((___r1 = (CPURLResponse.isa.method_msgSend["alloc"] || _objj_forward)(CPURLResponse, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithURL:"] || _objj_forward)(___r1, "initWithURL:", URL));
            else
            {
                response = ((___r1 = (CPHTTPURLResponse.isa.method_msgSend["alloc"] || _objj_forward)(CPHTTPURLResponse, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithURL:"] || _objj_forward)(___r1, "initWithURL:", URL));
                (response == null ? null : (response.isa.method_msgSend["_setStatusCode:"] || _objj_forward)(response, "_setStatusCode:", statusCode));
                (response == null ? null : (response.isa.method_msgSend["_setAllResponseHeaders:"] || _objj_forward)(response, "_setAllResponseHeaders:", self._HTTPRequest.getAllResponseHeaders()));
            }
            if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("connection:didReceiveResponse:"))))
                ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["connection:didReceiveResponse:"] || _objj_forward)(___r1, "connection:didReceiveResponse:", self, response));
            if (!self._isCanceled)
            {
                if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("connection:didReceiveData:"))))
                    ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["connection:didReceiveData:"] || _objj_forward)(___r1, "connection:didReceiveData:", self, self._HTTPRequest.responseText()));
                else if (self._connectionOperation !== nil)
                    (self.isa.method_msgSend["_connectionOperationDidReceiveResponse:data:error:"] || _objj_forward)(self, "_connectionOperationDidReceiveResponse:data:error:", response, self._HTTPRequest.responseText(), nil);
                if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("connectionDidFinishLoading:"))))
                    ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["connectionDidFinishLoading:"] || _objj_forward)(___r1, "connectionDidFinishLoading:", self));
            }
        }
    }
    ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["limitDateForMode:"] || _objj_forward)(___r1, "limitDateForMode:", CPDefaultRunLoopMode));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("_HTTPRequest"), function(self, _cmd)
{
    return self._HTTPRequest;
}
,["HTTPRequest"]), new objj_method(sel_getUid("_connectionOperationDidReceiveResponse:data:error:"), function(self, _cmd, aResponse, aData, anError)
{
    ((___r1 = self._connectionOperation), ___r1 == null ? null : (___r1.isa.method_msgSend["_setResponse:data:error:"] || _objj_forward)(___r1, "_setResponse:data:error:", aResponse, aData, anError));
    if (self._operationQueue)
        ((___r1 = self._operationQueue), ___r1 == null ? null : (___r1.isa.method_msgSend["addOperation:"] || _objj_forward)(___r1, "addOperation:", self._connectionOperation));
    else
    {
        ((___r1 = self._connectionOperation), ___r1 == null ? null : (___r1.isa.method_msgSend["main"] || _objj_forward)(___r1, "main"));
    }
    var ___r1;
}
,["void","CPURLResponse","CPData","CPError"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("setClassDelegate:"), function(self, _cmd, delegate)
{
    CPURLConnectionDelegate = delegate;
}
,["void","id"]), new objj_method(sel_getUid("sendSynchronousRequest:returningResponse:"), function(self, _cmd, aRequest, aURLResponse)
{
    try    {
        var aCFHTTPRequest = new CFHTTPRequest();
        aCFHTTPRequest.setWithCredentials((aRequest == null ? null : (aRequest.isa.method_msgSend["withCredentials"] || _objj_forward)(aRequest, "withCredentials")));
        aCFHTTPRequest.open((aRequest == null ? null : (aRequest.isa.method_msgSend["HTTPMethod"] || _objj_forward)(aRequest, "HTTPMethod")), ((___r1 = (aRequest == null ? null : (aRequest.isa.method_msgSend["URL"] || _objj_forward)(aRequest, "URL"))), ___r1 == null ? null : (___r1.isa.method_msgSend["absoluteString"] || _objj_forward)(___r1, "absoluteString")), NO);
        var fields = (aRequest == null ? null : (aRequest.isa.method_msgSend["allHTTPHeaderFields"] || _objj_forward)(aRequest, "allHTTPHeaderFields")),
            key = nil,
            keys = (fields == null ? null : (fields.isa.method_msgSend["keyEnumerator"] || _objj_forward)(fields, "keyEnumerator"));
        while ((key = (keys == null ? null : (keys.isa.method_msgSend["nextObject"] || _objj_forward)(keys, "nextObject"))) !== nil)
            aCFHTTPRequest.setRequestHeader(key, (fields == null ? null : (fields.isa.method_msgSend["objectForKey:"] || _objj_forward)(fields, "objectForKey:", key)));
        aCFHTTPRequest.send((aRequest == null ? null : (aRequest.isa.method_msgSend["HTTPBody"] || _objj_forward)(aRequest, "HTTPBody")));
        if (!aCFHTTPRequest.success())
            return nil;
        return (CPData.isa.method_msgSend["dataWithRawString:"] || _objj_forward)(CPData, "dataWithRawString:", aCFHTTPRequest.responseText());
    }
    catch(anException)     {
    }    return nil;
    var ___r1;
}
,["CPData","CPURLRequest","CPURLResponse"]), new objj_method(sel_getUid("sendAsynchronousRequest:queue:completionHandler:"), function(self, _cmd, aRequest, aQueue, aHandler)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["_initWithRequest:queue:completionHandler:"] || _objj_forward)(___r1, "_initWithRequest:queue:completionHandler:", aRequest, aQueue, aHandler));
    var ___r1;
}
,["CPURLConnection","CPURLRequest","CPOperationQueue","Function"]), new objj_method(sel_getUid("connectionWithRequest:delegate:"), function(self, _cmd, aRequest, aDelegate)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithRequest:delegate:"] || _objj_forward)(___r1, "initWithRequest:delegate:", aRequest, aDelegate));
    var ___r1;
}
,["CPURLConnection","CPURLRequest","id"])]);
}{var the_class = objj_allocateClassPair(CPOperation, "_AsynchronousConnectionOperation"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_didReceiveResponse", "BOOL"), new objj_ivar("_response", "CPURLResponse"), new objj_ivar("_data", "CPData"), new objj_ivar("_error", "CPError"), new objj_ivar("_operationFunction", "Function")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithFunction:"), function(self, _cmd, aFunction)
{
    self = (objj_getClass("_AsynchronousConnectionOperation").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._didReceiveResponse = NO;
        self._response = nil;
        self._data = nil;
        self._error = nil;
        self._operationFunction = aFunction;
    }
    return self;
}
,["id","Function"]), new objj_method(sel_getUid("_setResponse:data:error:"), function(self, _cmd, aResponse, aData, anError)
{
    self._didReceiveResponse = YES;
    self._response = aResponse;
    self._data = aData;
    self._error = anError;
}
,["void","CPURLResponse","CPData","CPError"]), new objj_method(sel_getUid("main"), function(self, _cmd)
{
    self._operationFunction(self._response, self._data, self._error);
}
,["void"]), new objj_method(sel_getUid("isReady"), function(self, _cmd)
{
    return self._didReceiveResponse && (objj_getClass("_AsynchronousConnectionOperation").super_class.method_dtable["isReady"] || _objj_forward)(self, "isReady");
}
,["BOOL"])]);
}{
var the_class = objj_getClass("CPURLConnection")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPURLConnection\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("_XMLHTTPRequest"), function(self, _cmd)
{
    _CPReportLenientDeprecation(self, _cmd, sel_getUid("_HTTPRequest"));
    return (self.isa.method_msgSend["_HTTPRequest"] || _objj_forward)(self, "_HTTPRequest");
}
,["HTTPRequest"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("sendSynchronousRequest:returningResponse:error:"), function(self, _cmd, aRequest, aURLResponse, anError)
{
    _CPReportLenientDeprecation(self, _cmd, sel_getUid("sendSynchronousRequest:returningResponse:"));
    return (self.isa.method_msgSend["sendSynchronousRequest:returningResponse:"] || _objj_forward)(self, "sendSynchronousRequest:returningResponse:", aRequest, aURLResponse);
}
,["CPData","CPURLRequest","CPURLResponse","id"])]);
}p;12;CPURLError.jt;1647;@STATIC;1.0;t;1628;CPURLErrorDomain = "CPURLErrorDomain";
CPURLErrorFailingURLErrorKey = "CPErrorFailingURLKey";
CPURLErrorFailingURLStringErrorKey = "CPURLErrorFailingURLStringKey";
CPURLErrorUnknown = -1;
CPURLErrorCancelled = kCFURLErrorCancelled;
CPURLErrorBadURL = kCFURLErrorBadURL;
CPURLErrorTimedOut = kCFURLErrorTimedOut;
CPURLErrorUnsupportedURL = kCFURLErrorUnsupportedURL;
CPURLErrorCannotFindHost = kCFURLErrorCannotFindHost;
CPURLErrorCannotConnectToHost = kCFURLErrorCannotConnectToHost;
CPURLErrorNetworkConnectionLost = kCFURLErrorNetworkConnectionLost;
CPURLErrorDNSLookupFailed = kCFURLErrorDNSLookupFailed;
CPURLErrorHTTPTooManyRedirects = kCFURLErrorHTTPTooManyRedirects;
CPURLErrorResourceUnavailable = kCFURLErrorResourceUnavailable;
CPURLErrorNotConnectedToInternet = kCFURLErrorNotConnectedToInternet;
CPURLErrorRedirectToNonExistentLocation = kCFURLErrorRedirectToNonExistentLocation;
CPURLErrorBadServerResponse = kCFURLErrorBadServerResponse;
CPURLErrorUserCancelledAuthentication = kCFURLErrorUserCancelledAuthentication;
CPURLErrorUserAuthenticationRequired = kCFURLErrorUserAuthenticationRequired;
CPURLErrorZeroByteResource = kCFURLErrorZeroByteResource;
CPURLErrorCannotDecodeRawData = kCFURLErrorCannotDecodeRawData;
CPURLErrorCannotDecodeContentData = kCFURLErrorCannotDecodeContentData;
CPURLErrorCannotParseResponse = kCFURLErrorCannotParseResponse;
CPURLErrorFileDoesNotExist = kCFURLErrorFileDoesNotExist;
CPURLErrorFileIsDirectory = kCFURLErrorFileIsDirectory;
CPURLErrorNoPermissionsToReadFile = kCFURLErrorNoPermissionsToReadFile;
CPURLErrorDataLengthExceedsMaximum = kCFURLErrorDataLengthExceedsMaximum;
p;14;CPURLRequest.jt;8354;@STATIC;1.0;i;14;CPDictionary.ji;10;CPObject.ji;10;CPString.ji;7;CPURL.jt;8275;objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPURL.j", YES);{var the_typedef = objj_allocateTypeDef("CPURLRequestCachePolicy");
objj_registerTypeDef(the_typedef);
}CPURLRequestUseProtocolCachePolicy = 0;
CPURLRequestReloadIgnoringLocalCacheData = 1;
CPURLRequestReturnCacheDataElseLoad = 2;
CPURLRequestReturnCacheDataDontLoad = 3;
{var the_class = objj_allocateClassPair(CPObject, "CPURLRequest"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_URL", "CPURL"), new objj_ivar("_HTTPBody", "CPString"), new objj_ivar("_HTTPMethod", "CPString"), new objj_ivar("_withCredentials", "BOOL"), new objj_ivar("_HTTPHeaderFields", "CPDictionary"), new objj_ivar("_timeoutInterval", "CPTimeInterval"), new objj_ivar("_cachePolicy", "CPURLRequestCachePolicy")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("URL"), function(self, _cmd)
{
    return self._URL;
}
,["CPURL"]), new objj_method(sel_getUid("setURL:"), function(self, _cmd, newValue)
{
    self._URL = newValue;
}
,["void","CPURL"]), new objj_method(sel_getUid("HTTPBody"), function(self, _cmd)
{
    return self._HTTPBody;
}
,["CPString"]), new objj_method(sel_getUid("setHTTPBody:"), function(self, _cmd, newValue)
{
    self._HTTPBody = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("HTTPMethod"), function(self, _cmd)
{
    return self._HTTPMethod;
}
,["CPString"]), new objj_method(sel_getUid("setHTTPMethod:"), function(self, _cmd, newValue)
{
    self._HTTPMethod = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("withCredentials"), function(self, _cmd)
{
    return self._withCredentials;
}
,["BOOL"]), new objj_method(sel_getUid("setWithCredentials:"), function(self, _cmd, newValue)
{
    self._withCredentials = newValue;
}
,["void","BOOL"]), new objj_method(sel_getUid("allHTTPHeaderFields"), function(self, _cmd)
{
    return self._HTTPHeaderFields;
}
,["CPDictionary"]), new objj_method(sel_getUid("timeoutInterval"), function(self, _cmd)
{
    return self._timeoutInterval;
}
,["CPTimeInterval"]), new objj_method(sel_getUid("cachePolicy"), function(self, _cmd)
{
    return self._cachePolicy;
}
,["CPURLRequestCachePolicy"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    return (self.isa.method_msgSend["initWithURL:"] || _objj_forward)(self, "initWithURL:", nil);
}
,["id"]), new objj_method(sel_getUid("initWithURL:cachePolicy:timeoutInterval:"), function(self, _cmd, anURL, aCachePolicy, aTimeoutInterval)
{
    if (self = (self == null ? null : (self.isa.method_msgSend["initWithURL:"] || _objj_forward)(self, "initWithURL:", anURL)))
    {
        self._cachePolicy = aCachePolicy;
        self._timeoutInterval = aTimeoutInterval;
    }
    return self;
}
,["id","CPURL","CPURLRequestCachePolicy","CPTimeInterval"]), new objj_method(sel_getUid("initWithURL:"), function(self, _cmd, aURL)
{
    if (self = (objj_getClass("CPURLRequest").super_class.method_dtable["init"] || _objj_forward)(self, "init"))
    {
        (self == null ? null : (self.isa.method_msgSend["setURL:"] || _objj_forward)(self, "setURL:", aURL));
        self._HTTPBody = "";
        self._HTTPMethod = "GET";
        self._HTTPHeaderFields = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        self._withCredentials = NO;
        self._timeoutInterval = 60.0;
        self._cachePolicy = CPURLRequestUseProtocolCachePolicy;
        (self == null ? null : (self.isa.method_msgSend["setValue:forHTTPHeaderField:"] || _objj_forward)(self, "setValue:forHTTPHeaderField:", "Thu, 01 Jan 1970 00:00:00 GMT", "If-Modified-Since"));
        switch(self._cachePolicy) {
        case CPURLRequestUseProtocolCachePolicy:
            (self == null ? null : (self.isa.method_msgSend["setValue:forHTTPHeaderField:"] || _objj_forward)(self, "setValue:forHTTPHeaderField:", "no-cache", "Cache-Control"));
            break;
        case CPURLRequestReturnCacheDataElseLoad:
            (self == null ? null : (self.isa.method_msgSend["setValue:forHTTPHeaderField:"] || _objj_forward)(self, "setValue:forHTTPHeaderField:", "max-stale=31536000", "Cache-Control"));
            break;
        case CPURLRequestReturnCacheDataDontLoad:
            (self == null ? null : (self.isa.method_msgSend["setValue:forHTTPHeaderField:"] || _objj_forward)(self, "setValue:forHTTPHeaderField:", "only-if-cached", "Cache-Control"));
            break;
        case CPURLRequestReloadIgnoringLocalCacheData:
            (self == null ? null : (self.isa.method_msgSend["setValue:forHTTPHeaderField:"] || _objj_forward)(self, "setValue:forHTTPHeaderField:", "no-cache", "Cache-Control"));
            break;
default:
            (self == null ? null : (self.isa.method_msgSend["setValue:forHTTPHeaderField:"] || _objj_forward)(self, "setValue:forHTTPHeaderField:", "no-cache", "Cache-Control"));
        }
        (self == null ? null : (self.isa.method_msgSend["setValue:forHTTPHeaderField:"] || _objj_forward)(self, "setValue:forHTTPHeaderField:", "XMLHttpRequest", "X-Requested-With"));
    }
    return self;
    var ___r1;
}
,["id","CPURL"]), new objj_method(sel_getUid("setURL:"), function(self, _cmd, aURL)
{
    self._URL = new CFURL(aURL);
}
,["void","CPURL"]), new objj_method(sel_getUid("valueForHTTPHeaderField:"), function(self, _cmd, aField)
{
    return ((___r1 = self._HTTPHeaderFields), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aField));
    var ___r1;
}
,["CPString","CPString"]), new objj_method(sel_getUid("setValue:forHTTPHeaderField:"), function(self, _cmd, aValue, aField)
{
    ((___r1 = self._HTTPHeaderFields), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", aValue, aField));
    var ___r1;
}
,["void","CPString","CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("requestWithURL:"), function(self, _cmd, aURL)
{
    return ((___r1 = (CPURLRequest.isa.method_msgSend["alloc"] || _objj_forward)(CPURLRequest, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithURL:"] || _objj_forward)(___r1, "initWithURL:", aURL));
    var ___r1;
}
,["id","CPURL"]), new objj_method(sel_getUid("requestWithURL:cachePolicy:timeoutInterval:"), function(self, _cmd, anURL, aCachePolicy, aTimeoutInterval)
{
    return ((___r1 = (CPURLRequest.isa.method_msgSend["alloc"] || _objj_forward)(CPURLRequest, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithURL:cachePolicy:timeoutInterval:"] || _objj_forward)(___r1, "initWithURL:cachePolicy:timeoutInterval:", anURL, aCachePolicy, aTimeoutInterval));
    var ___r1;
}
,["id","CPURL","CPURLRequestCachePolicy","CPTimeInterval"])]);
}{
var the_class = objj_getClass("CPURLRequest")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPURLRequest\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("copy"), function(self, _cmd)
{
    var request = ((___r1 = (CPURLRequest.isa.method_msgSend["alloc"] || _objj_forward)(CPURLRequest, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithURL:"] || _objj_forward)(___r1, "initWithURL:", (self.isa.method_msgSend["URL"] || _objj_forward)(self, "URL")));
    (request == null ? null : (request.isa.method_msgSend["setHTTPBody:"] || _objj_forward)(request, "setHTTPBody:", (self.isa.method_msgSend["HTTPBody"] || _objj_forward)(self, "HTTPBody")));
    (request == null ? null : (request.isa.method_msgSend["setHTTPMethod:"] || _objj_forward)(request, "setHTTPMethod:", (self.isa.method_msgSend["HTTPMethod"] || _objj_forward)(self, "HTTPMethod")));
    (request == null ? null : (request.isa.method_msgSend["setWithCredentials:"] || _objj_forward)(request, "setWithCredentials:", (self.isa.method_msgSend["withCredentials"] || _objj_forward)(self, "withCredentials")));
    request._HTTPHeaderFields = (self.isa.method_msgSend["allHTTPHeaderFields"] || _objj_forward)(self, "allHTTPHeaderFields");
    return request;
    var ___r1;
}
,["id"])]);
}p;15;CPURLResponse.jt;2665;@STATIC;1.0;i;10;CPObject.ji;7;CPURL.jt;2620;objj_executeFile("CPObject.j", YES);objj_executeFile("CPURL.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPURLResponse"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_URL", "CPURL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithURL:"), function(self, _cmd, aURL)
{
    self = (objj_getClass("CPURLResponse").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        self._URL = aURL;
    return self;
}
,["id","CPURL"]), new objj_method(sel_getUid("URL"), function(self, _cmd)
{
    return self._URL;
}
,["CPURL"])]);
}{var the_class = objj_allocateClassPair(CPURLResponse, "CPHTTPURLResponse"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_statusCode", "int"), new objj_ivar("_allResponseHeaders", "CPString"), new objj_ivar("_responseHeaders", "CPDictionary")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("_setStatusCode:"), function(self, _cmd, aStatusCode)
{
    self._statusCode = aStatusCode;
}
,["void","int"]), new objj_method(sel_getUid("statusCode"), function(self, _cmd)
{
    return self._statusCode;
}
,["int"]), new objj_method(sel_getUid("_setAllResponseHeaders:"), function(self, _cmd, responseHeadersString)
{
    self._allResponseHeaders = responseHeadersString;
}
,["void","CPString"]), new objj_method(sel_getUid("allHeaderFields"), function(self, _cmd)
{
    if (!self._responseHeaders)
        self._responseHeaders = ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["parseHTTPHeaders:"] || _objj_forward)(___r1, "parseHTTPHeaders:", self._allResponseHeaders));
    return self._responseHeaders;
    var ___r1;
}
,["CPDictionary"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("parseHTTPHeaders:"), function(self, _cmd, headersString)
{
    var r = (CPMutableDictionary.isa.method_msgSend["dictionary"] || _objj_forward)(CPMutableDictionary, "dictionary");
    if (headersString)
    {
        var headerLines = headersString.split('\r\n'),
            count = headerLines.length;
        while (count--)
        {
            var headerLine = headerLines[count],
                index = headerLine.indexOf(': ');
            if (index !== CPNotFound)
                (r == null ? null : (r.isa.method_msgSend["setValue:forKey:"] || _objj_forward)(r, "setValue:forKey:", headerLine.substring(index + 2), headerLine.substring(0, index)));
        }
    }
    return r;
}
,["CPDictionary","CPString"])]);
}p;16;CPUserDefaults.jt;27696;@STATIC;1.0;i;10;CPBundle.ji;8;CPData.ji;14;CPDictionary.ji;13;CPException.ji;17;CPKeyedArchiver.ji;19;CPKeyedUnarchiver.ji;22;CPNotificationCenter.ji;10;CPObject.ji;11;CPRunLoop.ji;10;CPString.ji;7;CPURL.ji;17;CPURLConnection.ji;14;CPURLRequest.jt;27441;objj_executeFile("CPBundle.j", YES);objj_executeFile("CPData.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPKeyedArchiver.j", YES);objj_executeFile("CPKeyedUnarchiver.j", YES);objj_executeFile("CPNotificationCenter.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPRunLoop.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPURL.j", YES);objj_executeFile("CPURLConnection.j", YES);objj_executeFile("CPURLRequest.j", YES);CPArgumentDomain = "CPArgumentDomain";
CPApplicationDomain = ((___r1 = ((___r2 = (CPBundle.isa.method_msgSend["mainBundle"] || _objj_forward)(CPBundle, "mainBundle")), ___r2 == null ? null : (___r2.isa.method_msgSend["infoDictionary"] || _objj_forward)(___r2, "infoDictionary"))), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", "CPBundleIdentifier")) || "CPApplicationDomain";
CPGlobalDomain = "CPGlobalDomain";
CPLocaleDomain = "CPLocaleDomain";
CPRegistrationDomain = "CPRegistrationDomain";
CPUserDefaultsDidChangeNotification = "CPUserDefaultsDidChangeNotification";
var StandardUserDefaults;
{var the_class = objj_allocateClassPair(CPObject, "CPUserDefaults"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_domains", "CPDictionary"), new objj_ivar("_stores", "CPDictionary"), new objj_ivar("_searchList", "CPDictionary"), new objj_ivar("_searchListNeedsReload", "BOOL")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPUserDefaults").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._domains = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        (self == null ? null : (self.isa.method_msgSend["_setupArgumentsDomain"] || _objj_forward)(self, "_setupArgumentsDomain"));
        var defaultStore = (CPUserDefaultsLocalStore == null ? null : (CPUserDefaultsLocalStore.isa.method_msgSend["supportsLocalStorage"] || _objj_forward)(CPUserDefaultsLocalStore, "supportsLocalStorage")) ? CPUserDefaultsLocalStore : CPUserDefaultsCookieStore;
        self._stores = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        (self == null ? null : (self.isa.method_msgSend["setPersistentStoreClass:forDomain:reloadData:"] || _objj_forward)(self, "setPersistentStoreClass:forDomain:reloadData:", defaultStore, CPGlobalDomain, YES));
        (self == null ? null : (self.isa.method_msgSend["setPersistentStoreClass:forDomain:reloadData:"] || _objj_forward)(self, "setPersistentStoreClass:forDomain:reloadData:", defaultStore, CPApplicationDomain, YES));
    }
    return self;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("_setupArgumentsDomain"), function(self, _cmd)
{
    var args = (CPApp == null ? null : (CPApp.isa.method_msgSend["namedArguments"] || _objj_forward)(CPApp, "namedArguments")),
        keys = (args == null ? null : (args.isa.method_msgSend["allKeys"] || _objj_forward)(args, "allKeys")),
        count = (keys == null ? null : (keys.isa.method_msgSend["count"] || _objj_forward)(keys, "count")),
        i = 0;
    for (; i < count; i++)
    {
        var key = keys[i];
        (self.isa.method_msgSend["setObject:forKey:inDomain:"] || _objj_forward)(self, "setObject:forKey:inDomain:", (args == null ? null : (args.isa.method_msgSend["objectForKey:"] || _objj_forward)(args, "objectForKey:", key)), key, CPArgumentDomain);
    }
}
,["void"]), new objj_method(sel_getUid("objectForKey:"), function(self, _cmd, aKey)
{
    if (self._searchListNeedsReload)
        (self.isa.method_msgSend["_reloadSearchList"] || _objj_forward)(self, "_reloadSearchList");
    return ((___r1 = self._searchList), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aKey));
    var ___r1;
}
,["id","CPString"]), new objj_method(sel_getUid("setObject:forKey:"), function(self, _cmd, anObject, aKey)
{
    (self.isa.method_msgSend["setObject:forKey:inDomain:"] || _objj_forward)(self, "setObject:forKey:inDomain:", anObject, aKey, CPApplicationDomain);
}
,["void","id","CPString"]), new objj_method(sel_getUid("objectForKey:inDomain:"), function(self, _cmd, aKey, aDomain)
{
    var domain = ((___r1 = self._domains), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aDomain));
    if (!domain)
        return nil;
    return (domain == null ? null : (domain.isa.method_msgSend["objectForKey:"] || _objj_forward)(domain, "objectForKey:", aKey));
    var ___r1;
}
,["id","CPString","CPString"]), new objj_method(sel_getUid("setObject:forKey:inDomain:"), function(self, _cmd, anObject, aKey, aDomain)
{
    if (!aKey || !aDomain)
        return;
    var domain = ((___r1 = self._domains), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aDomain));
    if (!domain)
    {
        domain = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        ((___r1 = self._domains), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", domain, aDomain));
    }
    (domain == null ? null : (domain.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(domain, "setObject:forKey:", anObject, aKey));
    self._searchListNeedsReload = YES;
    (self.isa.method_msgSend["domainDidChange:"] || _objj_forward)(self, "domainDidChange:", aDomain);
    var ___r1;
}
,["void","id","CPString","CPString"]), new objj_method(sel_getUid("removeObjectForKey:"), function(self, _cmd, aKey)
{
    (self.isa.method_msgSend["removeObjectForKey:inDomain:"] || _objj_forward)(self, "removeObjectForKey:inDomain:", aKey, CPApplicationDomain);
}
,["void","CPString"]), new objj_method(sel_getUid("removeObjectForKey:inDomain:"), function(self, _cmd, aKey, aDomain)
{
    if (!aKey || !aDomain)
        return;
    var domain = ((___r1 = self._domains), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aDomain));
    if (!domain)
        return;
    (domain == null ? null : (domain.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(domain, "removeObjectForKey:", aKey));
    self._searchListNeedsReload = YES;
    (self.isa.method_msgSend["domainDidChange:"] || _objj_forward)(self, "domainDidChange:", aDomain);
    var ___r1;
}
,["void","CPString","CPString"]), new objj_method(sel_getUid("registerDefaults:"), function(self, _cmd, aDictionary)
{
    var keys = (aDictionary == null ? null : (aDictionary.isa.method_msgSend["allKeys"] || _objj_forward)(aDictionary, "allKeys")),
        count = (keys == null ? null : (keys.isa.method_msgSend["count"] || _objj_forward)(keys, "count")),
        i = 0;
    for (; i < count; i++)
    {
        var key = keys[i];
        (self.isa.method_msgSend["setObject:forKey:inDomain:"] || _objj_forward)(self, "setObject:forKey:inDomain:", (aDictionary == null ? null : (aDictionary.isa.method_msgSend["objectForKey:"] || _objj_forward)(aDictionary, "objectForKey:", key)), key, CPRegistrationDomain);
    }
}
,["void","CPDictionary"]), new objj_method(sel_getUid("registerDefaultsFromContentsOfFile:"), function(self, _cmd, aURL)
{
    var contents = (CPURLConnection.isa.method_msgSend["sendSynchronousRequest:returningResponse:"] || _objj_forward)(CPURLConnection, "sendSynchronousRequest:returningResponse:", (CPURLRequest.isa.method_msgSend["requestWithURL:"] || _objj_forward)(CPURLRequest, "requestWithURL:", aURL), nil),
        data = (CPData.isa.method_msgSend["dataWithRawString:"] || _objj_forward)(CPData, "dataWithRawString:", (contents == null ? null : (contents.isa.method_msgSend["rawString"] || _objj_forward)(contents, "rawString"))),
        plist = (data == null ? null : (data.isa.method_msgSend["plistObject"] || _objj_forward)(data, "plistObject"));
    (self.isa.method_msgSend["registerDefaults:"] || _objj_forward)(self, "registerDefaults:", plist);
}
,["void","CPURL"]), new objj_method(sel_getUid("_reloadSearchList"), function(self, _cmd)
{
    self._searchListNeedsReload = NO;
    var dicts = [CPRegistrationDomain, CPGlobalDomain, CPApplicationDomain, CPArgumentDomain],
        count = (dicts == null ? null : (dicts.isa.method_msgSend["count"] || _objj_forward)(dicts, "count")),
        i = 0;
    self._searchList = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    for (; i < count; i++)
    {
        var domain = ((___r1 = self._domains), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", dicts[i]));
        if (!domain)
            continue;
        var keys = (domain == null ? null : (domain.isa.method_msgSend["allKeys"] || _objj_forward)(domain, "allKeys")),
            keysCount = (keys == null ? null : (keys.isa.method_msgSend["count"] || _objj_forward)(keys, "count")),
            j = 0;
        for (; j < keysCount; j++)
        {
            var key = keys[j];
            ((___r1 = self._searchList), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", (domain == null ? null : (domain.isa.method_msgSend["objectForKey:"] || _objj_forward)(domain, "objectForKey:", key)), key));
        }
    }
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("volatileDomainNames"), function(self, _cmd)
{
    return [CPArgumentDomain, CPLocaleDomain, CPRegistrationDomain];
}
,["CPArray"]), new objj_method(sel_getUid("persistentDomainNames"), function(self, _cmd)
{
    return [CPGlobalDomain, CPApplicationDomain];
}
,["CPArray"]), new objj_method(sel_getUid("persistentStoreForDomain:"), function(self, _cmd, aDomain)
{
    return ((___r1 = self._stores), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aDomain));
    var ___r1;
}
,["CPUserDefaultsStore","CPString"]), new objj_method(sel_getUid("setPersistentStoreClass:forDomain:reloadData:"), function(self, _cmd, aStoreClass, aDomain, aFlag)
{
    var currentStore = ((___r1 = self._stores), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", aDomain));
    if (currentStore && (currentStore == null ? null : (currentStore.isa.method_msgSend["class"] || _objj_forward)(currentStore, "class")) === aStoreClass)
        return currentStore;
    var store = ((___r1 = (aStoreClass == null ? null : (aStoreClass.isa.method_msgSend["alloc"] || _objj_forward)(aStoreClass, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    (store == null ? null : (store.isa.method_msgSend["setDomain:"] || _objj_forward)(store, "setDomain:", aDomain));
    ((___r1 = self._stores), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", store, aDomain));
    if (aFlag)
        (self.isa.method_msgSend["reloadDataFromStoreForDomain:"] || _objj_forward)(self, "reloadDataFromStoreForDomain:", aDomain);
    return store;
    var ___r1;
}
,["CPUserDefaultsStore","Class","CPString","BOOL"]), new objj_method(sel_getUid("reloadDataFromStoreForDomain:"), function(self, _cmd, aDomain)
{
    var data = ((___r1 = (self.isa.method_msgSend["persistentStoreForDomain:"] || _objj_forward)(self, "persistentStoreForDomain:", aDomain)), ___r1 == null ? null : (___r1.isa.method_msgSend["data"] || _objj_forward)(___r1, "data")),
        domain = data ? (CPKeyedUnarchiver.isa.method_msgSend["unarchiveObjectWithData:"] || _objj_forward)(CPKeyedUnarchiver, "unarchiveObjectWithData:", data) : nil;
    if (domain === nil)
        ((___r1 = self._domains), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObjectForKey:"] || _objj_forward)(___r1, "removeObjectForKey:", aDomain));
    else
        ((___r1 = self._domains), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", domain, aDomain));
    self._searchListNeedsReload = YES;
    var ___r1;
}
,["void","CPString"]), new objj_method(sel_getUid("domainDidChange:"), function(self, _cmd, aDomain)
{
    if (aDomain === CPGlobalDomain || aDomain === CPApplicationDomain)
        ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["performSelector:target:argument:order:modes:"] || _objj_forward)(___r1, "performSelector:target:argument:order:modes:", sel_getUid("synchronize"), self, nil, 0, [CPDefaultRunLoopMode]));
    ((___r1 = (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter")), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(___r1, "postNotificationName:object:", CPUserDefaultsDidChangeNotification, self));
    var ___r1;
}
,["void","CPString"]), new objj_method(sel_getUid("synchronize"), function(self, _cmd)
{
    var globalDomain = ((___r1 = self._domains), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPGlobalDomain));
    if (globalDomain)
    {
        var data = (CPKeyedArchiver.isa.method_msgSend["archivedDataWithRootObject:"] || _objj_forward)(CPKeyedArchiver, "archivedDataWithRootObject:", globalDomain);
        ((___r1 = (self.isa.method_msgSend["persistentStoreForDomain:"] || _objj_forward)(self, "persistentStoreForDomain:", CPGlobalDomain)), ___r1 == null ? null : (___r1.isa.method_msgSend["setData:"] || _objj_forward)(___r1, "setData:", data));
    }
    var appDomain = ((___r1 = self._domains), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", CPApplicationDomain));
    if (appDomain)
    {
        var data = (CPKeyedArchiver.isa.method_msgSend["archivedDataWithRootObject:"] || _objj_forward)(CPKeyedArchiver, "archivedDataWithRootObject:", appDomain);
        ((___r1 = (self.isa.method_msgSend["persistentStoreForDomain:"] || _objj_forward)(self, "persistentStoreForDomain:", CPApplicationDomain)), ___r1 == null ? null : (___r1.isa.method_msgSend["setData:"] || _objj_forward)(___r1, "setData:", data));
    }
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("arrayForKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    if ((value == null ? null : (value.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(value, "isKindOfClass:", CPArray)))
        return value;
    return nil;
}
,["CPArray","CPString"]), new objj_method(sel_getUid("boolForKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    if ((value == null ? null : (value.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(value, "respondsToSelector:", sel_getUid("boolValue"))))
        return (value == null ? null : (value.isa.method_msgSend["boolValue"] || _objj_forward)(value, "boolValue"));
    return NO;
}
,["BOOL","CPString"]), new objj_method(sel_getUid("dataForKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    if ((value == null ? null : (value.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(value, "isKindOfClass:", CPData)))
        return value;
    return nil;
}
,["CPData","CPString"]), new objj_method(sel_getUid("dictionaryForKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    if ((value == null ? null : (value.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(value, "isKindOfClass:", CPDictionary)))
        return value;
    return nil;
}
,["CPDictionary","CPString"]), new objj_method(sel_getUid("floatForKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    if (value === nil)
        return 0;
    if ((value == null ? null : (value.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(value, "respondsToSelector:", sel_getUid("floatValue"))))
        value = (value == null ? null : (value.isa.method_msgSend["floatValue"] || _objj_forward)(value, "floatValue"));
    return parseFloat(value);
}
,["float","CPString"]), new objj_method(sel_getUid("integerForKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    if (value === nil)
        return 0;
    if ((value == null ? null : (value.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(value, "respondsToSelector:", sel_getUid("intValue"))))
        value = (value == null ? null : (value.isa.method_msgSend["intValue"] || _objj_forward)(value, "intValue"));
    return parseInt(value);
}
,["int","CPString"]), new objj_method(sel_getUid("doubleForKey:"), function(self, _cmd, aKey)
{
    return (self.isa.method_msgSend["floatForKey:"] || _objj_forward)(self, "floatForKey:", aKey);
}
,["double","CPString"]), new objj_method(sel_getUid("stringForKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    if ((value == null ? null : (value.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(value, "isKindOfClass:", CPString)))
        return value;
    else if ((value == null ? null : (value.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(value, "respondsToSelector:", sel_getUid("stringValue"))))
        return (value == null ? null : (value.isa.method_msgSend["stringValue"] || _objj_forward)(value, "stringValue"));
    return nil;
}
,["CPString","CPString"]), new objj_method(sel_getUid("stringArrayForKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    if (!(value == null ? null : (value.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(value, "isKindOfClass:", CPArray)))
        return nil;
    for (var i = 0, count = (value == null ? null : (value.isa.method_msgSend["count"] || _objj_forward)(value, "count")); i < count; i++)
        if (!((___r1 = value[i]), ___r1 == null ? null : (___r1.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(___r1, "isKindOfClass:", CPString)))
            return nil;
    return value;
    var ___r1;
}
,["CPArray","CPString"]), new objj_method(sel_getUid("URLForKey:"), function(self, _cmd, aKey)
{
    var value = (self.isa.method_msgSend["objectForKey:"] || _objj_forward)(self, "objectForKey:", aKey);
    if ((value == null ? null : (value.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(value, "isKindOfClass:", CPURL)))
        return value;
    if ((value == null ? null : (value.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(value, "isKindOfClass:", CPString)))
        return (CPURL.isa.method_msgSend["URLWithString:"] || _objj_forward)(CPURL, "URLWithString:", value);
    return nil;
}
,["CPURL","CPString"]), new objj_method(sel_getUid("setBool:forKey:"), function(self, _cmd, aValue, aKey)
{
    if ((aValue == null ? null : (aValue.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(aValue, "respondsToSelector:", sel_getUid("boolValue"))))
        (self.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(self, "setObject:forKey:", (aValue == null ? null : (aValue.isa.method_msgSend["boolValue"] || _objj_forward)(aValue, "boolValue")), aKey);
}
,["void","BOOL","CPString"]), new objj_method(sel_getUid("setFloat:forKey:"), function(self, _cmd, aValue, aKey)
{
    if ((aValue == null ? null : (aValue.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(aValue, "respondsToSelector:", sel_getUid("floatValue"))))
        aValue = (aValue == null ? null : (aValue.isa.method_msgSend["floatValue"] || _objj_forward)(aValue, "floatValue"));
    (self.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(self, "setObject:forKey:", parseFloat(aValue), aKey);
}
,["void","float","CPString"]), new objj_method(sel_getUid("setDouble:forKey:"), function(self, _cmd, aValue, aKey)
{
    (self.isa.method_msgSend["setFloat:forKey:"] || _objj_forward)(self, "setFloat:forKey:", aValue, aKey);
}
,["void","double","CPString"]), new objj_method(sel_getUid("setInteger:forKey:"), function(self, _cmd, aValue, aKey)
{
    if ((aValue == null ? null : (aValue.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(aValue, "respondsToSelector:", sel_getUid("intValue"))))
        aValue = (aValue == null ? null : (aValue.isa.method_msgSend["intValue"] || _objj_forward)(aValue, "intValue"));
    (self.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(self, "setObject:forKey:", parseInt(aValue), aKey);
}
,["void","int","CPString"]), new objj_method(sel_getUid("setURL:forKey:"), function(self, _cmd, aValue, aKey)
{
    if ((aValue == null ? null : (aValue.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(aValue, "isKindOfClass:", CPString)))
        aValue = (CPURL.isa.method_msgSend["URLWithString:"] || _objj_forward)(CPURL, "URLWithString:", aValue);
    (self.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(self, "setObject:forKey:", aValue, aKey);
}
,["void","CPURL","CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("standardUserDefaults"), function(self, _cmd)
{
    if (!StandardUserDefaults)
        StandardUserDefaults = ((___r1 = (CPUserDefaults.isa.method_msgSend["alloc"] || _objj_forward)(CPUserDefaults, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    return StandardUserDefaults;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("resetStandardUserDefaults"), function(self, _cmd)
{
    if (StandardUserDefaults)
        (StandardUserDefaults == null ? null : (StandardUserDefaults.isa.method_msgSend["synchronize"] || _objj_forward)(StandardUserDefaults, "synchronize"));
    StandardUserDefaults = nil;
}
,["void"])]);
}{var the_class = objj_allocateClassPair(CPObject, "CPUserDefaultsStore"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_domain", "CPString")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("domain"), function(self, _cmd)
{
    return self._domain;
}
,["CPString"]), new objj_method(sel_getUid("setDomain:"), function(self, _cmd, newValue)
{
    self._domain = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("data"), function(self, _cmd)
{
    _CPRaiseInvalidAbstractInvocation(self, _cmd);
    return nil;
}
,["CPData"]), new objj_method(sel_getUid("setData:"), function(self, _cmd, aData)
{
    _CPRaiseInvalidAbstractInvocation(self, _cmd);
}
,["void","CPData"])]);
}{var the_class = objj_allocateClassPair(CPUserDefaultsStore, "CPUserDefaultsCookieStore"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_cookie", "CPCookie")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("setDomain:"), function(self, _cmd, aDomain)
{
    if (self._domain === aDomain)
        return;
    self._domain = aDomain;
    self._cookie = ((___r1 = (CPCookie == null ? null : (CPCookie.isa.method_msgSend["alloc"] || _objj_forward)(CPCookie, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithName:"] || _objj_forward)(___r1, "initWithName:", self._domain));
    var ___r1;
}
,["void","CPString"]), new objj_method(sel_getUid("data"), function(self, _cmd)
{
    var result = ((___r1 = self._cookie), ___r1 == null ? null : (___r1.isa.method_msgSend["value"] || _objj_forward)(___r1, "value"));
    if (!result || (result == null ? null : (result.isa.method_msgSend["length"] || _objj_forward)(result, "length")) < 1)
        return nil;
    return (CPData.isa.method_msgSend["dataWithRawString:"] || _objj_forward)(CPData, "dataWithRawString:", decodeURIComponent(result));
    var ___r1;
}
,["CPData"]), new objj_method(sel_getUid("setData:"), function(self, _cmd, aData)
{
    ((___r1 = self._cookie), ___r1 == null ? null : (___r1.isa.method_msgSend["setValue:expires:domain:"] || _objj_forward)(___r1, "setValue:expires:domain:", encodeURIComponent((aData == null ? null : (aData.isa.method_msgSend["rawString"] || _objj_forward)(aData, "rawString"))), (CPDate.isa.method_msgSend["distantFuture"] || _objj_forward)(CPDate, "distantFuture"), window.location.href.hostname));
    var ___r1;
}
,["void","CPData"])]);
}var CPUserDefaultsLocalStoreTestKey = "9961800812587769-Cappuccino-Storage-Test";
{var the_class = objj_allocateClassPair(CPUserDefaultsStore, "CPUserDefaultsLocalStore"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    if (!((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["supportsLocalStorage"] || _objj_forward)(___r1, "supportsLocalStorage")))
    {
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", "UnsupportedFeature", "Browser does not support localStorage for CPUserDefaultsLocalStore");
        return self = nil;
    }
    return self = (objj_getClass("CPUserDefaultsLocalStore").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("data"), function(self, _cmd)
{
    var result = localStorage.getItem(self._domain);
    if (!result || (result == null ? null : (result.isa.method_msgSend["length"] || _objj_forward)(result, "length")) < 1)
        return nil;
    return (CPData.isa.method_msgSend["dataWithRawString:"] || _objj_forward)(CPData, "dataWithRawString:", decodeURIComponent(result));
}
,["CPData"]), new objj_method(sel_getUid("setData:"), function(self, _cmd, aData)
{
    try    {
        localStorage.setItem(self._domain, encodeURIComponent((aData == null ? null : (aData.isa.method_msgSend["rawString"] || _objj_forward)(aData, "rawString"))));
    }
    catch(e)     {
        CPLog.warn("Unable to write to local storage: " + e);
    }}
,["void","CPData"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("supportsLocalStorage"), function(self, _cmd)
{
    if (!window.localStorage)
        return NO;
    try    {
        localStorage.setItem(CPUserDefaultsLocalStoreTestKey, "1");
        if (localStorage.getItem(CPUserDefaultsLocalStoreTestKey) != "1")
            return NO;
        localStorage.removeItem(CPUserDefaultsLocalStoreTestKey);
    }
    catch(e)     {
        return NO;
    }    return YES;
}
,["BOOL"])]);
}p;20;CPUserNotification.jt;5070;@STATIC;1.0;i;20;CPAttributedString.ji;9;CPArray.ji;8;CPDate.ji;14;CPDictionary.ji;10;CPObject.ji;12;CPTimeZone.jt;4950;objj_executeFile("CPAttributedString.j", YES);objj_executeFile("CPArray.j", YES);objj_executeFile("CPDate.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPTimeZone.j", YES);{var the_typedef = objj_allocateTypeDef("CPUserNotificationAction");
objj_registerTypeDef(the_typedef);
}{var the_typedef = objj_allocateTypeDef("CPUserNotificationActivationType");
objj_registerTypeDef(the_typedef);
}CPUserNotificationActivationTypeNone = 0;
CPUserNotificationActivationTypeContentsClicked = 1;
CPUserNotificationActivationTypeActionButtonClicked = 2;
(CPUserNotificationActivationTypeReplied = 3, CPUserNotificationActivationTypeAdditionalActionClicked = 4);
{var the_class = objj_allocateClassPair(CPObject, "CPUserNotification"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_presented", "BOOL"), new objj_ivar("_remote", "BOOL"), new objj_ivar("_actualDeliveryDate", "CPDate"), new objj_ivar("_deliveryDate", "CPDate"), new objj_ivar("_userInfo", "CPDictionary"), new objj_ivar("_contentImage", "CPImage"), new objj_ivar("_identifier", "CPString"), new objj_ivar("_informativeText", "CPString"), new objj_ivar("_title", "CPString"), new objj_ivar("_deliveryRepeatInterval", "CPTimeInterval"), new objj_ivar("_deliveryTimeZone", "CPTimeZone"), new objj_ivar("_activationType", "CPUserNotificationActivationType")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("isPresented"), function(self, _cmd)
{
    return self._presented;
}
,["BOOL"]), new objj_method(sel_getUid("_setPresented:"), function(self, _cmd, newValue)
{
    self._presented = newValue;
}
,["void","BOOL"]), new objj_method(sel_getUid("isRemote"), function(self, _cmd)
{
    return self._remote;
}
,["BOOL"]), new objj_method(sel_getUid("_setRemote:"), function(self, _cmd, newValue)
{
    self._remote = newValue;
}
,["void","BOOL"]), new objj_method(sel_getUid("actualDeliveryDate"), function(self, _cmd)
{
    return self._actualDeliveryDate;
}
,["CPDate"]), new objj_method(sel_getUid("_setActualDeliveryDate:"), function(self, _cmd, newValue)
{
    self._actualDeliveryDate = newValue;
}
,["void","CPDate"]), new objj_method(sel_getUid("deliveryDate"), function(self, _cmd)
{
    return self._deliveryDate;
}
,["CPDate"]), new objj_method(sel_getUid("setDeliveryDate:"), function(self, _cmd, newValue)
{
    self._deliveryDate = newValue;
}
,["void","CPDate"]), new objj_method(sel_getUid("userInfo"), function(self, _cmd)
{
    return self._userInfo;
}
,["CPDictionary"]), new objj_method(sel_getUid("setUserInfo:"), function(self, _cmd, newValue)
{
    self._userInfo = newValue;
}
,["void","CPDictionary"]), new objj_method(sel_getUid("contentImage"), function(self, _cmd)
{
    return self._contentImage;
}
,["CPImage"]), new objj_method(sel_getUid("setContentImage:"), function(self, _cmd, newValue)
{
    self._contentImage = newValue;
}
,["void","CPImage"]), new objj_method(sel_getUid("identifier"), function(self, _cmd)
{
    return self._identifier;
}
,["CPString"]), new objj_method(sel_getUid("setIdentifier:"), function(self, _cmd, newValue)
{
    self._identifier = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("informativeText"), function(self, _cmd)
{
    return self._informativeText;
}
,["CPString"]), new objj_method(sel_getUid("setInformativeText:"), function(self, _cmd, newValue)
{
    self._informativeText = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("title"), function(self, _cmd)
{
    return self._title;
}
,["CPString"]), new objj_method(sel_getUid("setTitle:"), function(self, _cmd, newValue)
{
    self._title = newValue;
}
,["void","CPString"]), new objj_method(sel_getUid("deliveryRepeatInterval"), function(self, _cmd)
{
    return self._deliveryRepeatInterval;
}
,["CPTimeInterval"]), new objj_method(sel_getUid("setDeliveryRepeatInterval:"), function(self, _cmd, newValue)
{
    self._deliveryRepeatInterval = newValue;
}
,["void","CPTimeInterval"]), new objj_method(sel_getUid("deliveryTimeZone"), function(self, _cmd)
{
    return self._deliveryTimeZone;
}
,["CPTimeZone"]), new objj_method(sel_getUid("setDeliveryTimeZone:"), function(self, _cmd, newValue)
{
    self._deliveryTimeZone = newValue;
}
,["void","CPTimeZone"]), new objj_method(sel_getUid("activationType"), function(self, _cmd)
{
    return self._activationType;
}
,["CPUserNotificationActivationType"]), new objj_method(sel_getUid("_setActivationType:"), function(self, _cmd, newValue)
{
    self._activationType = newValue;
}
,["void","CPUserNotificationActivationType"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPUserNotification").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._identifier = (self == null ? null : (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID"));
    }
    return self;
}
,["id"])]);
}p;26;CPUserNotificationCenter.jt;13992;@STATIC;1.0;i;9;CPArray.ji;10;CPObject.ji;9;CPTimer.ji;20;CPUserNotification.jt;13906;objj_executeFile("CPArray.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPTimer.j", YES);objj_executeFile("CPUserNotification.j", YES);{var the_protocol = objj_allocateProtocol("CPUserNotificationCenterDelegate");
var aProtocol = objj_getProtocol("CPObject");
if (!aProtocol) throw new SyntaxError("*** Could not find definition for protocol \"CPUserNotificationCenterDelegate\"");
protocol_addProtocol(the_protocol, aProtocol);
objj_registerProtocol(the_protocol);
}var CPUserNotificationCenterDelegate_userNotificationCenter_shouldPresentNotification_ = 1 << 0,
    CPUserNotificationCenterDelegate_userNotificationCenter_didDeliverNotification_ = 1 << 1,
    CPUserNotificationCenterDelegate_userNotificationCenter_didActivateNotification_ = 1 << 2;
var CPUserNotificationDefaultCenter = nil;
{var the_class = objj_allocateClassPair(CPObject, "CPUserNotificationCenter"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_deliveredNotifications", "CPArray"), new objj_ivar("_scheduledNotifications", "CPArray"), new objj_ivar("_delegate", "id"), new objj_ivar("_implementedDelegateMethods", "CPInteger"), new objj_ivar("_timersForUserNotification", "CPMutableDictionary")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("deliveredNotifications"), function(self, _cmd)
{
    return self._deliveredNotifications;
}
,["CPArray"]), new objj_method(sel_getUid("setDeliveredNotifications:"), function(self, _cmd, newValue)
{
    self._deliveredNotifications = newValue;
}
,["void","CPArray"]), new objj_method(sel_getUid("scheduledNotifications"), function(self, _cmd)
{
    return self._scheduledNotifications;
}
,["CPArray"]), new objj_method(sel_getUid("setScheduledNotifications:"), function(self, _cmd, newValue)
{
    self._scheduledNotifications = newValue;
}
,["void","CPArray"]), new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPUserNotificationCenter").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
    {
        self._deliveredNotifications = [];
        self._scheduledNotifications = [];
        self._timersForUserNotification = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    }
    return self;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("setDelegate:"), function(self, _cmd, aDelegate)
{
    if (self._delegate === aDelegate)
        return;
    self._delegate = aDelegate;
    self._implementedDelegateMethods = 0;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("userNotificationCenter:shouldPresentNotification:"))))
        self._implementedDelegateMethods |= CPUserNotificationCenterDelegate_userNotificationCenter_shouldPresentNotification_;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("userNotificationCenter:didDeliverNotification:"))))
        self._implementedDelegateMethods |= CPUserNotificationCenterDelegate_userNotificationCenter_didDeliverNotification_;
    if (((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["respondsToSelector:"] || _objj_forward)(___r1, "respondsToSelector:", sel_getUid("userNotificationCenter:didActivateNotification:"))))
        self._implementedDelegateMethods |= CPUserNotificationCenterDelegate_userNotificationCenter_didActivateNotification_;
    var ___r1;
}
,["void","id"]), new objj_method(sel_getUid("scheduleNotification:"), function(self, _cmd, anUserNotification)
{
    var scheduledDate = ((___r1 = (anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["deliveryDate"] || _objj_forward)(anUserNotification, "deliveryDate"))), ___r1 == null ? null : (___r1.isa.method_msgSend["copy"] || _objj_forward)(___r1, "copy"));
    (scheduledDate == null ? null : (scheduledDate.isa.method_msgSend["_dateWithTimeZone:"] || _objj_forward)(scheduledDate, "_dateWithTimeZone:", (anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["deliveryTimeZone"] || _objj_forward)(anUserNotification, "deliveryTimeZone"))));
    var timer = ((___r1 = (CPTimer.isa.method_msgSend["alloc"] || _objj_forward)(CPTimer, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithFireDate:interval:target:selector:userInfo:repeats:"] || _objj_forward)(___r1, "initWithFireDate:interval:target:selector:userInfo:repeats:", scheduledDate, (anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["deliveryRepeatInterval"] || _objj_forward)(anUserNotification, "deliveryRepeatInterval")), self, sel_getUid("_scheduledUserNotificationTimerDidFire:"), anUserNotification, (anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["deliveryRepeatInterval"] || _objj_forward)(anUserNotification, "deliveryRepeatInterval")) ? YES : NO));
    ((___r1 = self._scheduledNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", anUserNotification));
    self._timersForUserNotification[(anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["UID"] || _objj_forward)(anUserNotification, "UID"))] = timer;
    ((___r1 = (CPRunLoop.isa.method_msgSend["currentRunLoop"] || _objj_forward)(CPRunLoop, "currentRunLoop")), ___r1 == null ? null : (___r1.isa.method_msgSend["addTimer:forMode:"] || _objj_forward)(___r1, "addTimer:forMode:", timer, CPDefaultRunLoopMode));
    var ___r1;
}
,["void","CPUserNotification"]), new objj_method(sel_getUid("_scheduledUserNotificationTimerDidFire:"), function(self, _cmd, aTimer)
{
    (self.isa.method_msgSend["deliverNotification:"] || _objj_forward)(self, "deliverNotification:", (aTimer == null ? null : (aTimer.isa.method_msgSend["userInfo"] || _objj_forward)(aTimer, "userInfo")));
}
,["void","CPTimer"]), new objj_method(sel_getUid("removeScheduledNotification:"), function(self, _cmd, anUserNotification)
{
    if (((___r1 = self._scheduledNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["indexOfObject:"] || _objj_forward)(___r1, "indexOfObject:", anUserNotification)) != CPNotFound)
    {
        ((___r1 = self._scheduledNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObject:"] || _objj_forward)(___r1, "removeObject:", anUserNotification));
        ((___r1 = self._timersForUserNotification[(anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["UID"] || _objj_forward)(anUserNotification, "UID"))]), ___r1 == null ? null : (___r1.isa.method_msgSend["invalidate"] || _objj_forward)(___r1, "invalidate"));
        delete self._timersForUserNotification[(anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["UID"] || _objj_forward)(anUserNotification, "UID"))];
    }
    var ___r1;
}
,["void","CPUserNotification"]), new objj_method(sel_getUid("deliverNotification:"), function(self, _cmd, aNotification)
{
    (self.isa.method_msgSend["_launchUserNotification:"] || _objj_forward)(self, "_launchUserNotification:", aNotification);
}
,["void","CPUserNotification"]), new objj_method(sel_getUid("removeDeliveredNotification:"), function(self, _cmd, aNotification)
{
    ((___r1 = self._deliveredNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["removeObject:"] || _objj_forward)(___r1, "removeObject:", aNotification));
    var ___r1;
}
,["void","CPUserNotification"]), new objj_method(sel_getUid("removeAllDeliveredNotifications"), function(self, _cmd)
{
    ((___r1 = self._deliveredNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["removeAllObjects"] || _objj_forward)(___r1, "removeAllObjects"));
    var ___r1;
}
,["void"]), new objj_method(sel_getUid("_askPermissionForUserNotification:"), function(self, _cmd, anUserNotification)
{
    Notification.requestPermission(function(permission)
    {
        if (permission == "granted")
            (self.isa.method_msgSend["_launchUserNotification:"] || _objj_forward)(self, "_launchUserNotification:", anUserNotification);
    });
}
,["void","CPUserNotification"]), new objj_method(sel_getUid("_launchUserNotification:"), function(self, _cmd, anUserNotification)
{
    if (!window || !'Notification' in window)
        return;
    if (Notification.permission === 'default')
        (self.isa.method_msgSend["_askPermissionForUserNotification:"] || _objj_forward)(self, "_askPermissionForUserNotification:", anUserNotification);
    if (Notification.permission === 'granted')
    {
        if ((self.isa.method_msgSend["_delegateRespondsToShouldPresentNotification"] || _objj_forward)(self, "_delegateRespondsToShouldPresentNotification") && (self.isa.method_msgSend["_sendDelegateShouldPresentNotification:"] || _objj_forward)(self, "_sendDelegateShouldPresentNotification:", anUserNotification) || !(CPApp == null ? null : (CPApp.isa.method_msgSend["isActive"] || _objj_forward)(CPApp, "isActive")))
        {
            var notification = new Notification((anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["title"] || _objj_forward)(anUserNotification, "title")), {'body': (anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["informativeText"] || _objj_forward)(anUserNotification, "informativeText")), 'icon': ((___r1 = (anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["contentImage"] || _objj_forward)(anUserNotification, "contentImage"))), ___r1 == null ? null : (___r1.isa.method_msgSend["filename"] || _objj_forward)(___r1, "filename")), 'tag': (anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["identifier"] || _objj_forward)(anUserNotification, "identifier"))});
            anUserNotification._presented = YES;
            notification.onclick = function()
            {
                anUserNotification._activationType = CPUserNotificationActivationTypeContentsClicked;
                (self.isa.method_msgSend["_sendDelegateDidActivateNotification:"] || _objj_forward)(self, "_sendDelegateDidActivateNotification:", anUserNotification);
                this.close();
            };
            notification.onclose = function()
            {
            };
        }
        else
        {
            anUserNotification._presented = NO;
        }
        anUserNotification._activationType = CPUserNotificationActivationTypeNone;
        anUserNotification._actualDeliveryDate = (CPDate.isa.method_msgSend["date"] || _objj_forward)(CPDate, "date");
        ((___r1 = self._deliveredNotifications), ___r1 == null ? null : (___r1.isa.method_msgSend["addObject:"] || _objj_forward)(___r1, "addObject:", anUserNotification));
        if (!(anUserNotification == null ? null : (anUserNotification.isa.method_msgSend["deliveryRepeatInterval"] || _objj_forward)(anUserNotification, "deliveryRepeatInterval")))
            (self.isa.method_msgSend["removeScheduledNotification:"] || _objj_forward)(self, "removeScheduledNotification:", anUserNotification);
        (self.isa.method_msgSend["_sendDelegateDidDeliverNotification:"] || _objj_forward)(self, "_sendDelegateDidDeliverNotification:", anUserNotification);
    }
    var ___r1;
}
,["void","CPUserNotification"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("defaultUserNotificationCenter"), function(self, _cmd)
{
    if (!CPUserNotificationDefaultCenter)
        CPUserNotificationDefaultCenter = ((___r1 = (CPUserNotificationCenter.isa.method_msgSend["alloc"] || _objj_forward)(CPUserNotificationCenter, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    return CPUserNotificationDefaultCenter;
    var ___r1;
}
,["CPNotificationCenter"])]);
}{
var the_class = objj_getClass("CPUserNotificationCenter")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPUserNotificationCenter\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("_delegateRespondsToShouldPresentNotification"), function(self, _cmd)
{
    return self._implementedDelegateMethods & CPUserNotificationCenterDelegate_userNotificationCenter_shouldPresentNotification_;
}
,["BOOL"]), new objj_method(sel_getUid("_sendDelegateShouldPresentNotification:"), function(self, _cmd, aNotification)
{
    return ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["userNotificationCenter:shouldPresentNotification:"] || _objj_forward)(___r1, "userNotificationCenter:shouldPresentNotification:", self, aNotification));
    var ___r1;
}
,["BOOL","CPUserNotification"]), new objj_method(sel_getUid("_sendDelegateDidActivateNotification:"), function(self, _cmd, aNotification)
{
    if (!(self._implementedDelegateMethods & CPUserNotificationCenterDelegate_userNotificationCenter_didActivateNotification_))
        return;
    ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["userNotificationCenter:didActivateNotification:"] || _objj_forward)(___r1, "userNotificationCenter:didActivateNotification:", self, aNotification));
    var ___r1;
}
,["void","CPUserNotification"]), new objj_method(sel_getUid("_sendDelegateDidDeliverNotification:"), function(self, _cmd, aNotification)
{
    if (!(self._implementedDelegateMethods & CPUserNotificationCenterDelegate_userNotificationCenter_didDeliverNotification_))
        return;
    ((___r1 = self._delegate), ___r1 == null ? null : (___r1.isa.method_msgSend["userNotificationCenter:didDeliverNotification:"] || _objj_forward)(___r1, "userNotificationCenter:didDeliverNotification:", self, aNotification));
    var ___r1;
}
,["void","CPUserNotification"])]);
}p;22;CPUserSessionManager.jt;3158;@STATIC;1.0;i;22;CPNotificationCenter.ji;10;CPObject.ji;10;CPString.jt;3082;objj_executeFile("CPNotificationCenter.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);{var the_typedef = objj_allocateTypeDef("CPUserSessionStatus");
objj_registerTypeDef(the_typedef);
}CPUserSessionUndeterminedStatus = 0;
CPUserSessionLoggedInStatus = 1;
CPUserSessionLoggedOutStatus = 2;
CPUserSessionManagerStatusDidChangeNotification = "CPUserSessionManagerStatusDidChangeNotification";
CPUserSessionManagerUserIdentifierDidChangeNotification = "CPUserSessionManagerUserIdentifierDidChangeNotification";
var CPDefaultUserSessionManager = nil;
{var the_class = objj_allocateClassPair(CPObject, "CPUserSessionManager"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_status", "CPUserSessionStatus"), new objj_ivar("_userIdentifier", "CPString")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPUserSessionManager").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        self._status = CPUserSessionUndeterminedStatus;
    return self;
}
,["id"]), new objj_method(sel_getUid("status"), function(self, _cmd)
{
    return self._status;
}
,["CPUserSessionStatus"]), new objj_method(sel_getUid("setStatus:"), function(self, _cmd, aStatus)
{
    if (self._status == aStatus)
        return;
    self._status = aStatus;
    ((___r1 = (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter")), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(___r1, "postNotificationName:object:", CPUserSessionManagerStatusDidChangeNotification, self));
    if (self._status != CPUserSessionLoggedInStatus)
        (self.isa.method_msgSend["setUserIdentifier:"] || _objj_forward)(self, "setUserIdentifier:", nil);
    var ___r1;
}
,["void","CPUserSessionStatus"]), new objj_method(sel_getUid("userIdentifier"), function(self, _cmd)
{
    return self._userIdentifier;
}
,["CPString"]), new objj_method(sel_getUid("setUserIdentifier:"), function(self, _cmd, anIdentifier)
{
    if (self._userIdentifier == anIdentifier)
        return;
    self._userIdentifier = anIdentifier;
    ((___r1 = (CPNotificationCenter.isa.method_msgSend["defaultCenter"] || _objj_forward)(CPNotificationCenter, "defaultCenter")), ___r1 == null ? null : (___r1.isa.method_msgSend["postNotificationName:object:"] || _objj_forward)(___r1, "postNotificationName:object:", CPUserSessionManagerUserIdentifierDidChangeNotification, self));
    var ___r1;
}
,["void","CPString"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("defaultManager"), function(self, _cmd)
{
    if (!CPDefaultUserSessionManager)
        CPDefaultUserSessionManager = ((___r1 = (CPUserSessionManager.isa.method_msgSend["alloc"] || _objj_forward)(CPUserSessionManager, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    return CPDefaultUserSessionManager;
    var ___r1;
}
,["id"])]);
}p;9;CPValue.jt;2408;@STATIC;1.0;i;9;CPCoder.ji;10;CPObject.jt;2361;objj_executeFile("CPCoder.j", YES);objj_executeFile("CPObject.j", YES);{var the_class = objj_allocateClassPair(CPObject, "CPValue"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_JSObject", "JSObject")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("initWithJSObject:"), function(self, _cmd, aJSObject)
{
    self = (objj_getClass("CPValue").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        self._JSObject = aJSObject;
    return self;
}
,["id","JSObject"]), new objj_method(sel_getUid("JSObject"), function(self, _cmd)
{
    return self._JSObject;
}
,["JSObject"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("valueWithJSObject:"), function(self, _cmd, aJSObject)
{
    return ((___r1 = (self.isa.method_msgSend["alloc"] || _objj_forward)(self, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithJSObject:"] || _objj_forward)(___r1, "initWithJSObject:", aJSObject));
    var ___r1;
}
,["id","JSObject"])]);
}var CPValueValueKey = "CPValueValueKey";
{
var the_class = objj_getClass("CPValue")
if(!the_class) throw new SyntaxError("*** Could not find definition for class \"CPValue\"");
var meta_class = the_class.isa;class_addMethods(the_class, [new objj_method(sel_getUid("initWithCoder:"), function(self, _cmd, aCoder)
{
    self = (objj_getClass("CPValue").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        self._JSObject = JSON.parse((aCoder == null ? null : (aCoder.isa.method_msgSend["decodeObjectForKey:"] || _objj_forward)(aCoder, "decodeObjectForKey:", CPValueValueKey)));
    return self;
}
,["id","CPCoder"]), new objj_method(sel_getUid("encodeWithCoder:"), function(self, _cmd, aCoder)
{
    (aCoder == null ? null : (aCoder.isa.method_msgSend["encodeObject:forKey:"] || _objj_forward)(aCoder, "encodeObject:forKey:", JSON.stringify(self._JSObject), CPValueValueKey));
}
,["void","CPCoder"])]);
}CPJSObjectCreateJSON = function(aJSObject)
{
    CPLog.warn("CPJSObjectCreateJSON deprecated, use JSON.stringify() or CPString's objectFromJSON");
    return JSON.stringify(aJSObject);
}
CPJSObjectCreateWithJSON = function(aString)
{
    CPLog.warn("CPJSObjectCreateWithJSON deprecated, use JSON.parse() or CPString's JSONFromObject");
    return JSON.parse(aString);
}
p;20;CPValueTransformer.jt;7934;@STATIC;1.0;i;8;CPData.ji;14;CPDictionary.ji;13;CPException.ji;17;CPKeyedArchiver.ji;19;CPKeyedUnarchiver.ji;10;CPNumber.ji;10;CPObject.jt;7790;objj_executeFile("CPData.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPKeyedArchiver.j", YES);objj_executeFile("CPKeyedUnarchiver.j", YES);objj_executeFile("CPNumber.j", YES);objj_executeFile("CPObject.j", YES);var transformerMap = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
{var the_class = objj_allocateClassPair(CPObject, "CPValueTransformer"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("reverseTransformedValue:"), function(self, _cmd, aValue)
{
    if (!((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["allowsReverseTransformation"] || _objj_forward)(___r1, "allowsReverseTransformation")))
    {
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, self + " is not reversible.");
    }
    return (self.isa.method_msgSend["transformedValue:"] || _objj_forward)(self, "transformedValue:", aValue);
    var ___r1;
}
,["id","id"]), new objj_method(sel_getUid("transformedValue:"), function(self, _cmd, aValue)
{
    return nil;
}
,["id","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("initialize"), function(self, _cmd)
{
    if (self !== (CPValueTransformer.isa.method_msgSend["class"] || _objj_forward)(CPValueTransformer, "class"))
        return;
}
,["void"]), new objj_method(sel_getUid("setValueTransformer:forName:"), function(self, _cmd, transformer, aName)
{
    (transformerMap == null ? null : (transformerMap.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(transformerMap, "setObject:forKey:", transformer, aName));
}
,["void","CPValueTransformer","CPString"]), new objj_method(sel_getUid("valueTransformerForName:"), function(self, _cmd, aName)
{
    return (transformerMap == null ? null : (transformerMap.isa.method_msgSend["objectForKey:"] || _objj_forward)(transformerMap, "objectForKey:", aName));
}
,["CPValueTransformer","CPString"]), new objj_method(sel_getUid("valueTransformerNames"), function(self, _cmd)
{
    return (transformerMap == null ? null : (transformerMap.isa.method_msgSend["allKeys"] || _objj_forward)(transformerMap, "allKeys"));
}
,["CPArray"]), new objj_method(sel_getUid("allowsReverseTransformation"), function(self, _cmd)
{
    return NO;
}
,["BOOL"]), new objj_method(sel_getUid("transformedValueClass"), function(self, _cmd)
{
    return (CPObject.isa.method_msgSend["class"] || _objj_forward)(CPObject, "class");
}
,["Class"])]);
}{var the_class = objj_allocateClassPair(CPValueTransformer, "CPNegateBooleanTransformer"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("reverseTransformedValue:"), function(self, _cmd, aValue)
{
    return !(aValue == null ? null : (aValue.isa.method_msgSend["boolValue"] || _objj_forward)(aValue, "boolValue"));
}
,["id","id"]), new objj_method(sel_getUid("transformedValue:"), function(self, _cmd, aValue)
{
    return !(aValue == null ? null : (aValue.isa.method_msgSend["boolValue"] || _objj_forward)(aValue, "boolValue"));
}
,["id","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("allowsReverseTransformation"), function(self, _cmd)
{
    return YES;
}
,["BOOL"]), new objj_method(sel_getUid("transformedValueClass"), function(self, _cmd)
{
    return (CPNumber.isa.method_msgSend["class"] || _objj_forward)(CPNumber, "class");
}
,["Class"])]);
}{var the_class = objj_allocateClassPair(CPValueTransformer, "CPIsNilTransformer"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("transformedValue:"), function(self, _cmd, aValue)
{
    return aValue === nil || aValue === undefined;
}
,["id","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("allowsReverseTransformation"), function(self, _cmd)
{
    return NO;
}
,["BOOL"]), new objj_method(sel_getUid("transformedValueClass"), function(self, _cmd)
{
    return (CPNumber.isa.method_msgSend["class"] || _objj_forward)(CPNumber, "class");
}
,["Class"])]);
}{var the_class = objj_allocateClassPair(CPValueTransformer, "CPIsNotNilTransformer"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("transformedValue:"), function(self, _cmd, aValue)
{
    return aValue !== nil && aValue !== undefined;
}
,["id","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("allowsReverseTransformation"), function(self, _cmd)
{
    return NO;
}
,["BOOL"]), new objj_method(sel_getUid("transformedValueClass"), function(self, _cmd)
{
    return (CPNumber.isa.method_msgSend["class"] || _objj_forward)(CPNumber, "class");
}
,["Class"])]);
}{var the_class = objj_allocateClassPair(CPValueTransformer, "CPUnarchiveFromDataTransformer"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("reverseTransformedValue:"), function(self, _cmd, aValue)
{
    return (CPKeyedArchiver.isa.method_msgSend["archivedDataWithRootObject:"] || _objj_forward)(CPKeyedArchiver, "archivedDataWithRootObject:", aValue);
}
,["id","id"]), new objj_method(sel_getUid("transformedValue:"), function(self, _cmd, aValue)
{
    return (CPKeyedUnarchiver.isa.method_msgSend["unarchiveObjectWithData:"] || _objj_forward)(CPKeyedUnarchiver, "unarchiveObjectWithData:", aValue);
}
,["id","id"])]);
class_addMethods(meta_class, [new objj_method(sel_getUid("allowsReverseTransformation"), function(self, _cmd)
{
    return YES;
}
,["BOOL"]), new objj_method(sel_getUid("transformedValueClass"), function(self, _cmd)
{
    return (CPData.isa.method_msgSend["class"] || _objj_forward)(CPData, "class");
}
,["Class"])]);
}CPNegateBooleanTransformerName = "CPNegateBoolean";
CPIsNilTransformerName = "CPIsNil";
CPIsNotNilTransformerName = "CPIsNotNil";
CPUnarchiveFromDataTransformerName = "CPUnarchiveFromData";
CPKeyedUnarchiveFromDataTransformerName = "CPKeyedUnarchiveFromData";
(CPValueTransformer.isa.method_msgSend["setValueTransformer:forName:"] || _objj_forward)(CPValueTransformer, "setValueTransformer:forName:", ((___r1 = (CPNegateBooleanTransformer.isa.method_msgSend["alloc"] || _objj_forward)(CPNegateBooleanTransformer, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init")), CPNegateBooleanTransformerName);
(CPValueTransformer.isa.method_msgSend["setValueTransformer:forName:"] || _objj_forward)(CPValueTransformer, "setValueTransformer:forName:", ((___r1 = (CPIsNilTransformer.isa.method_msgSend["alloc"] || _objj_forward)(CPIsNilTransformer, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init")), CPIsNilTransformerName);
(CPValueTransformer.isa.method_msgSend["setValueTransformer:forName:"] || _objj_forward)(CPValueTransformer, "setValueTransformer:forName:", ((___r1 = (CPIsNotNilTransformer.isa.method_msgSend["alloc"] || _objj_forward)(CPIsNotNilTransformer, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init")), CPIsNotNilTransformerName);
(CPValueTransformer.isa.method_msgSend["setValueTransformer:forName:"] || _objj_forward)(CPValueTransformer, "setValueTransformer:forName:", ((___r1 = (CPUnarchiveFromDataTransformer.isa.method_msgSend["alloc"] || _objj_forward)(CPUnarchiveFromDataTransformer, "alloc")), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init")), CPUnarchiveFromDataTransformerName);
p;17;CPWebDAVManager.jt;10322;@STATIC;1.0;i;9;CPArray.ji;14;CPDictionary.ji;10;CPObject.ji;10;CPString.ji;7;CPURL.ji;17;CPURLConnection.ji;14;CPURLRequest.jt;10188;objj_executeFile("CPArray.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPURL.j", YES);objj_executeFile("CPURLConnection.j", YES);objj_executeFile("CPURLRequest.j", YES);var setURLResourceValuesForKeysFromProperties = function(aURL, keys, properties)
{
    var resourceType = (properties == null ? null : (properties.isa.method_msgSend["objectForKey:"] || _objj_forward)(properties, "objectForKey:", "resourcetype"));
    if (resourceType === CPWebDAVManagerCollectionResourceType)
    {
        (aURL == null ? null : (aURL.isa.method_msgSend["setResourceValue:forKey:"] || _objj_forward)(aURL, "setResourceValue:forKey:", YES, CPURLIsDirectoryKey));
        (aURL == null ? null : (aURL.isa.method_msgSend["setResourceValue:forKey:"] || _objj_forward)(aURL, "setResourceValue:forKey:", NO, CPURLIsRegularFileKey));
    }
    else if (resourceType === CPWebDAVManagerNonCollectionResourceType)
    {
        (aURL == null ? null : (aURL.isa.method_msgSend["setResourceValue:forKey:"] || _objj_forward)(aURL, "setResourceValue:forKey:", NO, CPURLIsDirectoryKey));
        (aURL == null ? null : (aURL.isa.method_msgSend["setResourceValue:forKey:"] || _objj_forward)(aURL, "setResourceValue:forKey:", YES, CPURLIsRegularFileKey));
    }
    var displayName = (properties == null ? null : (properties.isa.method_msgSend["objectForKey:"] || _objj_forward)(properties, "objectForKey:", "displayname"));
    if (displayName !== nil)
    {
        (aURL == null ? null : (aURL.isa.method_msgSend["setResourceValue:forKey:"] || _objj_forward)(aURL, "setResourceValue:forKey:", displayName, CPURLNameKey));
        (aURL == null ? null : (aURL.isa.method_msgSend["setResourceValue:forKey:"] || _objj_forward)(aURL, "setResourceValue:forKey:", displayName, CPURLLocalizedNameKey));
    }
};
CPWebDAVManagerCollectionResourceType = 1;
CPWebDAVManagerNonCollectionResourceType = 0;
{var the_class = objj_allocateClassPair(CPObject, "CPWebDAVManager"),
meta_class = the_class.isa;class_addIvars(the_class, [new objj_ivar("_blocksForConnections", "CPDictionary")]);objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    self = (objj_getClass("CPWebDAVManager").super_class.method_dtable["init"] || _objj_forward)(self, "init");
    if (self)
        self._blocksForConnections = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    return self;
    var ___r1;
}
,["id"]), new objj_method(sel_getUid("contentsOfDirectoryAtURL:includingPropertiesForKeys:options:block:"), function(self, _cmd, aURL, keys, aMask, aBlock)
{
    var properties = [],
        count = (keys == null ? null : (keys.isa.method_msgSend["count"] || _objj_forward)(keys, "count"));
    while (count--)
        properties.push(WebDAVPropertiesForURLKeys[keys[count]]);
    var makeContents = function(aURL, response)
    {
        var contents = [],
            URLString = nil,
            URLStrings = (response == null ? null : (response.isa.method_msgSend["keyEnumerator"] || _objj_forward)(response, "keyEnumerator"));
        while ((URLString = (URLStrings == null ? null : (URLStrings.isa.method_msgSend["nextObject"] || _objj_forward)(URLStrings, "nextObject"))) !== nil)
        {
            var URL = (CPURL.isa.method_msgSend["URLWithString:"] || _objj_forward)(CPURL, "URLWithString:", URLString),
                properties = (response == null ? null : (response.isa.method_msgSend["objectForKey:"] || _objj_forward)(response, "objectForKey:", URLString));
            if (!((___r1 = (URL == null ? null : (URL.isa.method_msgSend["absoluteString"] || _objj_forward)(URL, "absoluteString"))), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqual:"] || _objj_forward)(___r1, "isEqual:", (aURL == null ? null : (aURL.isa.method_msgSend["absoluteString"] || _objj_forward)(aURL, "absoluteString")))))
            {
                contents.push(URL);
                setURLResourceValuesForKeysFromProperties(URL, keys, properties);
            }
        }
        return contents;
        var ___r1;
    };
    if (!aBlock)
        return makeContents(aURL, (self.isa.method_msgSend["PROPFIND:properties:depth:block:"] || _objj_forward)(self, "PROPFIND:properties:depth:block:", aURL, properties, 1, nil));
    (self.isa.method_msgSend["PROPFIND:properties:depth:block:"] || _objj_forward)(self, "PROPFIND:properties:depth:block:", aURL, properties, 1, function(aURL, response)
    {
        aBlock(aURL, makeContents(aURL, response));
    });
}
,["CPArray","CPURL","CPArray","CPDirectoryEnumerationOptions","Function"]), new objj_method(sel_getUid("PROPFIND:properties:depth:block:"), function(self, _cmd, aURL, properties, aDepth, aBlock)
{
    var request = (CPURLRequest.isa.method_msgSend["requestWithURL:"] || _objj_forward)(CPURLRequest, "requestWithURL:", aURL);
    (request == null ? null : (request.isa.method_msgSend["setHTTPMethod:"] || _objj_forward)(request, "setHTTPMethod:", "PROPFIND"));
    (request == null ? null : (request.isa.method_msgSend["setValue:forHTTPHeaderField:"] || _objj_forward)(request, "setValue:forHTTPHeaderField:", aDepth, "Depth"));
    var HTTPBody = ["<?xml version=\"1.0\"?><a:propfind xmlns:a=\"DAV:\">"],
        index = 0,
        count = properties.length;
    for (; index < count; ++index)
        HTTPBody.push("<a:prop><a:", properties[index], "/></a:prop>");
    HTTPBody.push("</a:propfind>");
    (request == null ? null : (request.isa.method_msgSend["setHTTPBody:"] || _objj_forward)(request, "setHTTPBody:", HTTPBody.join("")));
    if (!aBlock)
        return parsePROPFINDResponse(((___r1 = (CPURLConnection.isa.method_msgSend["sendSynchronousRequest:returningResponse:"] || _objj_forward)(CPURLConnection, "sendSynchronousRequest:returningResponse:", request, nil)), ___r1 == null ? null : (___r1.isa.method_msgSend["rawString"] || _objj_forward)(___r1, "rawString")));
    else
    {
        var connection = (CPURLConnection.isa.method_msgSend["connectionWithRequest:delegate:"] || _objj_forward)(CPURLConnection, "connectionWithRequest:delegate:", request, self);
        ((___r1 = self._blocksForConnections), ___r1 == null ? null : (___r1.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(___r1, "setObject:forKey:", aBlock, (connection == null ? null : (connection.isa.method_msgSend["UID"] || _objj_forward)(connection, "UID"))));
    }
    var ___r1;
}
,["CPDictionary","CPURL","CPDictionary","CPString","Function"]), new objj_method(sel_getUid("connection:didReceiveData:"), function(self, _cmd, aURLConnection, aString)
{
    var block = ((___r1 = self._blocksForConnections), ___r1 == null ? null : (___r1.isa.method_msgSend["objectForKey:"] || _objj_forward)(___r1, "objectForKey:", (aURLConnection == null ? null : (aURLConnection.isa.method_msgSend["UID"] || _objj_forward)(aURLConnection, "UID"))));
    block(((___r1 = aURLConnection._request), ___r1 == null ? null : (___r1.isa.method_msgSend["URL"] || _objj_forward)(___r1, "URL")), parsePROPFINDResponse(aString));
    var ___r1;
}
,["void","CPURLConnection","CPString"])]);
}var WebDAVPropertiesForURLKeys = {};
WebDAVPropertiesForURLKeys[CPURLNameKey] = "displayname";
WebDAVPropertiesForURLKeys[CPURLLocalizedNameKey] = "displayname";
WebDAVPropertiesForURLKeys[CPURLIsRegularFileKey] = "resourcetype";
WebDAVPropertiesForURLKeys[CPURLIsDirectoryKey] = "resourcetype";
var XMLDocumentFromString = function(anXMLString)
{
    if (typeof window["ActiveXObject"] !== "undefined")
    {
        var XMLDocument = new ActiveXObject("Microsoft.XMLDOM");
        XMLDocument.async = false;
        XMLDocument.loadXML(anXMLString);
        return XMLDocument;
    }
    return (new DOMParser()).parseFromString(anXMLString, "text/xml");
};
var parsePROPFINDResponse = function(anXMLString)
{
    var XMLDocument = XMLDocumentFromString(anXMLString),
        responses = XMLDocument.getElementsByTagNameNS("*", "response"),
        responseIndex = 0,
        responseCount = responses.length,
        propertiesForURLs = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
    for (; responseIndex < responseCount; ++responseIndex)
    {
        var response = responses[responseIndex],
            elements = ((response.getElementsByTagNameNS("*", "prop")).item(0)).childNodes,
            index = 0,
            count = elements.length,
            properties = (___r1 = (CPDictionary.isa.method_msgSend["alloc"] || _objj_forward)(CPDictionary, "alloc"), ___r1 == null ? null : (___r1.isa.method_msgSend["init"] || _objj_forward)(___r1, "init"));
        for (; index < count; ++index)
        {
            var element = elements[index];
            if (element.nodeType === 8 || element.nodeType === 3)
                continue;
            var nodeName = element.nodeName,
                colonIndex = nodeName.lastIndexOf(':');
            if (colonIndex > -1)
                nodeName = nodeName.substr(colonIndex + 1);
            if (nodeName === "resourcetype")
                (properties == null ? null : (properties.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(properties, "setObject:forKey:", element.firstChild ? CPWebDAVManagerCollectionResourceType : CPWebDAVManagerNonCollectionResourceType, nodeName));
            else
                (properties == null ? null : (properties.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(properties, "setObject:forKey:", element.firstChild.nodeValue, nodeName));
        }
        var href = (response.getElementsByTagNameNS("*", "href")).item(0);
        (propertiesForURLs == null ? null : (propertiesForURLs.isa.method_msgSend["setObject:forKey:"] || _objj_forward)(propertiesForURLs, "setObject:forKey:", properties, href.firstChild.nodeValue));
    }
    return propertiesForURLs;
    var ___r1;
};
var mapURLsAndProperties = function(properties, ignoredURL)
{
};
p;12;Foundation.jt;3861;@STATIC;1.0;i;13;_CGGeometry.ji;9;CPArray.ji;10;CPBundle.ji;22;CPByteCountFormatter.ji;9;CPCache.ji;16;CPCharacterSet.ji;9;CPCoder.ji;23;CPComparisonPredicate.ji;21;CPCompoundPredicate.ji;8;CPData.ji;8;CPDate.ji;17;CPDateFormatter.ji;11;CPDecimal.ji;17;CPDecimalNumber.ji;18;CPDelayedPerform.ji;14;CPDictionary.ji;14;CPEnumerator.ji;9;CPError.ji;13;CPException.ji;14;CPExpression.ji;13;CPFormatter.ji;13;CPIndexPath.ji;12;CPIndexSet.ji;14;CPInvocation.ji;19;CPJSONPConnection.ji;17;CPKeyedArchiver.ji;19;CPKeyedUnarchiver.ji;18;CPKeyValueCoding.ji;21;CPKeyValueObserving.ji;10;CPLocale.ji;16;CPMutableArray.ji;14;CPMutableSet.ji;16;CPNotification.ji;22;CPNotificationCenter.ji;21;CPNotificationQueue.ji;8;CPNull.ji;10;CPNumber.ji;19;CPNumberFormatter.ji;10;CPObject.ji;15;CPObjJRuntime.ji;13;CPOperation.ji;18;CPOperationQueue.ji;13;CPPredicate.ji;29;CPPropertyListSerialization.ji;9;CPRange.ji;11;CPRunLoop.ji;11;CPScanner.ji;7;CPSet.ji;18;CPSortDescriptor.ji;10;CPString.ji;9;CPTimer.ji;12;CPTimeZone.ji;15;CPUndoManager.ji;7;CPURL.ji;17;CPURLConnection.ji;12;CPURLError.ji;14;CPURLRequest.ji;15;CPURLResponse.ji;16;CPUserDefaults.ji;20;CPUserNotification.ji;26;CPUserNotificationCenter.ji;22;CPUserSessionManager.ji;9;CPValue.ji;20;CPValueTransformer.jt;2599;objj_executeFile("_CGGeometry.j", YES);objj_executeFile("CPArray.j", YES);objj_executeFile("CPBundle.j", YES);objj_executeFile("CPByteCountFormatter.j", YES);objj_executeFile("CPCache.j", YES);objj_executeFile("CPCharacterSet.j", YES);objj_executeFile("CPCoder.j", YES);objj_executeFile("CPComparisonPredicate.j", YES);objj_executeFile("CPCompoundPredicate.j", YES);objj_executeFile("CPData.j", YES);objj_executeFile("CPDate.j", YES);objj_executeFile("CPDateFormatter.j", YES);objj_executeFile("CPDecimal.j", YES);objj_executeFile("CPDecimalNumber.j", YES);objj_executeFile("CPDelayedPerform.j", YES);objj_executeFile("CPDictionary.j", YES);objj_executeFile("CPEnumerator.j", YES);objj_executeFile("CPError.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPExpression.j", YES);objj_executeFile("CPFormatter.j", YES);objj_executeFile("CPIndexPath.j", YES);objj_executeFile("CPIndexSet.j", YES);objj_executeFile("CPInvocation.j", YES);objj_executeFile("CPJSONPConnection.j", YES);objj_executeFile("CPKeyedArchiver.j", YES);objj_executeFile("CPKeyedUnarchiver.j", YES);objj_executeFile("CPKeyValueCoding.j", YES);objj_executeFile("CPKeyValueObserving.j", YES);objj_executeFile("CPLocale.j", YES);objj_executeFile("CPMutableArray.j", YES);objj_executeFile("CPMutableSet.j", YES);objj_executeFile("CPNotification.j", YES);objj_executeFile("CPNotificationCenter.j", YES);objj_executeFile("CPNotificationQueue.j", YES);objj_executeFile("CPNull.j", YES);objj_executeFile("CPNumber.j", YES);objj_executeFile("CPNumberFormatter.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPObjJRuntime.j", YES);objj_executeFile("CPOperation.j", YES);objj_executeFile("CPOperationQueue.j", YES);objj_executeFile("CPPredicate.j", YES);objj_executeFile("CPPropertyListSerialization.j", YES);objj_executeFile("CPRange.j", YES);objj_executeFile("CPRunLoop.j", YES);objj_executeFile("CPScanner.j", YES);objj_executeFile("CPSet.j", YES);objj_executeFile("CPSortDescriptor.j", YES);objj_executeFile("CPString.j", YES);objj_executeFile("CPTimer.j", YES);objj_executeFile("CPTimeZone.j", YES);objj_executeFile("CPUndoManager.j", YES);objj_executeFile("CPURL.j", YES);objj_executeFile("CPURLConnection.j", YES);objj_executeFile("CPURLError.j", YES);objj_executeFile("CPURLRequest.j", YES);objj_executeFile("CPURLResponse.j", YES);objj_executeFile("CPUserDefaults.j", YES);objj_executeFile("CPUserNotification.j", YES);objj_executeFile("CPUserNotificationCenter.j", YES);objj_executeFile("CPUserSessionManager.j", YES);objj_executeFile("CPValue.j", YES);objj_executeFile("CPValueTransformer.j", YES);p;10;_CPArray.jt;31884;@STATIC;1.0;i;14;CPEnumerator.ji;13;CPException.ji;10;CPObject.ji;9;CPRange.ji;18;CPSortDescriptor.jt;31776;objj_executeFile("CPEnumerator.j", YES);objj_executeFile("CPException.j", YES);objj_executeFile("CPObject.j", YES);objj_executeFile("CPRange.j", YES);objj_executeFile("CPSortDescriptor.j", YES);CPEnumerationNormal = 0;
CPEnumerationConcurrent = 1 << 0;
CPEnumerationReverse = 1 << 1;
CPBinarySearchingFirstEqual = 1 << 8;
CPBinarySearchingLastEqual = 1 << 9;
CPBinarySearchingInsertionIndex = 1 << 10;
var CPArrayMaxDescriptionRecursion = 10;
var concat = Array.prototype.concat,
    join = Array.prototype.join,
    push = Array.prototype.push;
{var the_class = objj_allocateClassPair(CPObject, "CPArray"),
meta_class = the_class.isa;objj_registerClassPair(the_class);
class_addMethods(the_class, [new objj_method(sel_getUid("init"), function(self, _cmd)
{
    if (self === _CPSharedPlaceholderArray)
    {
        arguments[0] = (_CPJavaScriptArray == null ? null : (_CPJavaScriptArray.isa.method_msgSend["alloc"] || _objj_forward)(_CPJavaScriptArray, "alloc"));
        return objj_msgSend.apply(this, arguments);
    }
    return (objj_getClass("CPArray").super_class.method_dtable["init"] || _objj_forward)(self, "init");
}
,["id"]), new objj_method(sel_getUid("initWithArray:"), function(self, _cmd, anArray)
{
    if (self === _CPSharedPlaceholderArray)
    {
        arguments[0] = (_CPJavaScriptArray == null ? null : (_CPJavaScriptArray.isa.method_msgSend["alloc"] || _objj_forward)(_CPJavaScriptArray, "alloc"));
        return objj_msgSend.apply(this, arguments);
    }
    return (objj_getClass("CPArray").super_class.method_dtable["init"] || _objj_forward)(self, "init");
}
,["id","CPArray"]), new objj_method(sel_getUid("initWithArray:copyItems:"), function(self, _cmd, anArray, shouldCopyItems)
{
    if (self === _CPSharedPlaceholderArray)
    {
        arguments[0] = (_CPJavaScriptArray == null ? null : (_CPJavaScriptArray.isa.method_msgSend["alloc"] || _objj_forward)(_CPJavaScriptArray, "alloc"));
        return objj_msgSend.apply(this, arguments);
    }
    return (objj_getClass("CPArray").super_class.method_dtable["init"] || _objj_forward)(self, "init");
}
,["id","CPArray","BOOL"]), new objj_method(sel_getUid("initWithObjects:"), function(self, _cmd, anObject)
{
    if (self === _CPSharedPlaceholderArray)
    {
        arguments[0] = (_CPJavaScriptArray == null ? null : (_CPJavaScriptArray.isa.method_msgSend["alloc"] || _objj_forward)(_CPJavaScriptArray, "alloc"));
        return objj_msgSend.apply(this, arguments);
    }
    return (objj_getClass("CPArray").super_class.method_dtable["init"] || _objj_forward)(self, "init");
}
,["id","id"]), new objj_method(sel_getUid("initWithObjects:count:"), function(self, _cmd, objects, aCount)
{
    if (self === _CPSharedPlaceholderArray)
    {
        arguments[0] = (_CPJavaScriptArray == null ? null : (_CPJavaScriptArray.isa.method_msgSend["alloc"] || _objj_forward)(_CPJavaScriptArray, "alloc"));
        return objj_msgSend.apply(this, arguments);
    }
    return (objj_getClass("CPArray").super_class.method_dtable["init"] || _objj_forward)(self, "init");
}
,["id","CPArray","CPUInteger"]), new objj_method(sel_getUid("initWithCapacity:"), function(self, _cmd, aCapacity)
{
    if (self === _CPSharedPlaceholderArray)
    {
        arguments[0] = (_CPJavaScriptArray == null ? null : (_CPJavaScriptArray.isa.method_msgSend["alloc"] || _objj_forward)(_CPJavaScriptArray, "alloc"));
        return objj_msgSend.apply(this, arguments);
    }
    return (objj_getClass("CPArray").super_class.method_dtable["init"] || _objj_forward)(self, "init");
}
,["id","CPUInteger"]), new objj_method(sel_getUid("containsObject:"), function(self, _cmd, anObject)
{
    return (self.isa.method_msgSend["indexOfObject:"] || _objj_forward)(self, "indexOfObject:", anObject) !== CPNotFound;
}
,["BOOL","id"]), new objj_method(sel_getUid("containsObjectIdenticalTo:"), function(self, _cmd, anObject)
{
    return (self.isa.method_msgSend["indexOfObjectIdenticalTo:"] || _objj_forward)(self, "indexOfObjectIdenticalTo:", anObject) !== CPNotFound;
}
,["BOOL","id"]), new objj_method(sel_getUid("count"), function(self, _cmd)
{
    _CPRaiseInvalidAbstractInvocation(self, _cmd);
}
,["CPUInteger"]), new objj_method(sel_getUid("hash"), function(self, _cmd)
{
    return (self.isa.method_msgSend["UID"] || _objj_forward)(self, "UID");
}
,["unsigned"]), new objj_method(sel_getUid("firstObject"), function(self, _cmd)
{
    var count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
    if (count > 0)
        return (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", 0);
    return nil;
}
,["id"]), new objj_method(sel_getUid("lastObject"), function(self, _cmd)
{
    var count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
    if (count <= 0)
        return nil;
    return (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", count - 1);
}
,["id"]), new objj_method(sel_getUid("objectAtIndex:"), function(self, _cmd, anIndex)
{
    _CPRaiseInvalidAbstractInvocation(self, _cmd);
}
,["id","CPUInteger"]), new objj_method(sel_getUid("objectsAtIndexes:"), function(self, _cmd, indexes)
{
    var index = CPNotFound,
        objects = [];
    while ((index = (indexes == null ? null : (indexes.isa.method_msgSend["indexGreaterThanIndex:"] || _objj_forward)(indexes, "indexGreaterThanIndex:", index))) !== CPNotFound)
        objects.push((self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index));
    return objects;
}
,["CPArray","CPIndexSet"]), new objj_method(sel_getUid("objectEnumerator"), function(self, _cmd)
{
    return ((___r1 = (_CPArrayEnumerator == null ? null : (_CPArrayEnumerator.isa.method_msgSend["alloc"] || _objj_forward)(_CPArrayEnumerator, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithArray:"] || _objj_forward)(___r1, "initWithArray:", self));
    var ___r1;
}
,["CPEnumerator"]), new objj_method(sel_getUid("reverseObjectEnumerator"), function(self, _cmd)
{
    return ((___r1 = (_CPReverseArrayEnumerator == null ? null : (_CPReverseArrayEnumerator.isa.method_msgSend["alloc"] || _objj_forward)(_CPReverseArrayEnumerator, "alloc"))), ___r1 == null ? null : (___r1.isa.method_msgSend["initWithArray:"] || _objj_forward)(___r1, "initWithArray:", self));
    var ___r1;
}
,["CPEnumerator"]), new objj_method(sel_getUid("indexOfObject:"), function(self, _cmd, anObject)
{
    return (self.isa.method_msgSend["indexOfObject:inRange:"] || _objj_forward)(self, "indexOfObject:inRange:", anObject, nil);
}
,["CPUInteger","id"]), new objj_method(sel_getUid("indexOfObject:inRange:"), function(self, _cmd, anObject, aRange)
{
    if (anObject && anObject.isa)
    {
        var index = aRange ? aRange.location : 0,
            count = aRange ? CPMaxRange(aRange) : (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
        for (; index < count; ++index)
            if (((___r1 = (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index)), ___r1 == null ? null : (___r1.isa.method_msgSend["isEqual:"] || _objj_forward)(___r1, "isEqual:", anObject)))
                return index;
        return CPNotFound;
    }
    return (self.isa.method_msgSend["indexOfObjectIdenticalTo:inRange:"] || _objj_forward)(self, "indexOfObjectIdenticalTo:inRange:", anObject, aRange);
    var ___r1;
}
,["CPUInteger","id","CPRange"]), new objj_method(sel_getUid("indexOfObjectIdenticalTo:"), function(self, _cmd, anObject)
{
    return (self.isa.method_msgSend["indexOfObjectIdenticalTo:inRange:"] || _objj_forward)(self, "indexOfObjectIdenticalTo:inRange:", anObject, nil);
}
,["CPUInteger","id"]), new objj_method(sel_getUid("indexOfObjectIdenticalTo:inRange:"), function(self, _cmd, anObject, aRange)
{
    var index = aRange ? aRange.location : 0,
        count = aRange ? CPMaxRange(aRange) : (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
    for (; index < count; ++index)
        if ((self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index) === anObject)
            return index;
    return CPNotFound;
}
,["CPUInteger","id","CPRange"]), new objj_method(sel_getUid("indexOfObjectPassingTest:"), function(self, _cmd, aPredicate)
{
    return (self.isa.method_msgSend["indexOfObjectWithOptions:passingTest:context:"] || _objj_forward)(self, "indexOfObjectWithOptions:passingTest:context:", CPEnumerationNormal, aPredicate, undefined);
}
,["unsigned","Function"]), new objj_method(sel_getUid("indexOfObjectPassingTest:context:"), function(self, _cmd, aPredicate, aContext)
{
    return (self.isa.method_msgSend["indexOfObjectWithOptions:passingTest:context:"] || _objj_forward)(self, "indexOfObjectWithOptions:passingTest:context:", CPEnumerationNormal, aPredicate, aContext);
}
,["unsigned","Function","id"]), new objj_method(sel_getUid("indexOfObjectWithOptions:passingTest:"), function(self, _cmd, options, aPredicate)
{
    return (self.isa.method_msgSend["indexOfObjectWithOptions:passingTest:context:"] || _objj_forward)(self, "indexOfObjectWithOptions:passingTest:context:", options, aPredicate, undefined);
}
,["unsigned","CPEnumerationOptions","Function"]), new objj_method(sel_getUid("indexOfObjectWithOptions:passingTest:context:"), function(self, _cmd, options, aPredicate, aContext)
{
    if (options & CPEnumerationReverse)
    {
        var index = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count") - 1,
            stop = -1,
            increment = -1;
    }
    else
    {
        var index = 0,
            stop = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count"),
            increment = 1;
    }
    for (; index !== stop; index += increment)
        if (aPredicate((self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index), index, aContext))
            return index;
    return CPNotFound;
}
,["unsigned","CPEnumerationOptions","Function","id"]), new objj_method(sel_getUid("indexOfObject:inSortedRange:options:usingComparator:"), function(self, _cmd, anObject, aRange, options, aComparator)
{
    if (!aComparator)
        _CPRaiseInvalidArgumentException(self, _cmd, "comparator is nil");
    if (options & CPBinarySearchingFirstEqual && options & CPBinarySearchingLastEqual)
        _CPRaiseInvalidArgumentException(self, _cmd, "both CPBinarySearchingFirstEqual and CPBinarySearchingLastEqual options cannot be specified");
    var count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
    if (count <= 0)
        return options & CPBinarySearchingInsertionIndex ? 0 : CPNotFound;
    var first = aRange ? aRange.location : 0,
        last = (aRange ? CPMaxRange(aRange) : (self.isa.method_msgSend["count"] || _objj_forward)(self, "count")) - 1;
    if (first < 0)
        _CPRaiseRangeException(self, _cmd, first, count);
    if (last >= count)
        _CPRaiseRangeException(self, _cmd, last, count);
    while (first <= last)
    {
        var middle = FLOOR((first + last) / 2),
            result = aComparator(anObject, (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", middle));
        if (result > 0)
            first = middle + 1;
        else if (result < 0)
            last = middle - 1;
        else
        {
            if (options & CPBinarySearchingFirstEqual)
                while (middle > first && aComparator(anObject, (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", middle - 1)) === CPOrderedSame)
                    --middle;
            else if (options & CPBinarySearchingLastEqual)
            {
                while (middle < last && aComparator(anObject, (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", middle + 1)) === CPOrderedSame)
                    ++middle;
                if (options & CPBinarySearchingInsertionIndex)
                    ++middle;
            }
            return middle;
        }
    }
    if (options & CPBinarySearchingInsertionIndex)
        return MAX(first, 0);
    return CPNotFound;
}
,["CPUInteger","id","CPRange","CPBinarySearchingOptions","Function"]), new objj_method(sel_getUid("indexesOfObjectsPassingTest:"), function(self, _cmd, aPredicate)
{
    return (self.isa.method_msgSend["indexesOfObjectsWithOptions:passingTest:context:"] || _objj_forward)(self, "indexesOfObjectsWithOptions:passingTest:context:", CPEnumerationNormal, aPredicate, undefined);
}
,["CPIndexSet","Function"]), new objj_method(sel_getUid("indexesOfObjectsPassingTest:context:"), function(self, _cmd, aPredicate, aContext)
{
    return (self.isa.method_msgSend["indexesOfObjectsWithOptions:passingTest:context:"] || _objj_forward)(self, "indexesOfObjectsWithOptions:passingTest:context:", CPEnumerationNormal, aPredicate, aContext);
}
,["CPIndexSet","Function","id"]), new objj_method(sel_getUid("indexesOfObjectsWithOptions:passingTest:"), function(self, _cmd, options, aPredicate)
{
    return (self.isa.method_msgSend["indexesOfObjectsWithOptions:passingTest:context:"] || _objj_forward)(self, "indexesOfObjectsWithOptions:passingTest:context:", options, aPredicate, undefined);
}
,["CPIndexSet","CPEnumerationOptions","Function"]), new objj_method(sel_getUid("indexesOfObjectsWithOptions:passingTest:context:"), function(self, _cmd, options, aPredicate, aContext)
{
    if (options & CPEnumerationReverse)
    {
        var index = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count") - 1,
            stop = -1,
            increment = -1;
    }
    else
    {
        var index = 0,
            stop = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count"),
            increment = 1;
    }
    var indexes = (CPIndexSet == null ? null : (CPIndexSet.isa.method_msgSend["indexSet"] || _objj_forward)(CPIndexSet, "indexSet"));
    for (; index !== stop; index += increment)
        if (aPredicate((self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index), index, aContext))
            (indexes == null ? null : (indexes.isa.method_msgSend["addIndex:"] || _objj_forward)(indexes, "addIndex:", index));
    return indexes;
}
,["CPIndexSet","CPEnumerationOptions","Function","id"]), new objj_method(sel_getUid("makeObjectsPerformSelector:"), function(self, _cmd, aSelector)
{
    (self.isa.method_msgSend["makeObjectsPerformSelector:withObjects:"] || _objj_forward)(self, "makeObjectsPerformSelector:withObjects:", aSelector, nil);
}
,["void","SEL"]), new objj_method(sel_getUid("makeObjectsPerformSelector:withObject:"), function(self, _cmd, aSelector, anObject)
{
    return (self.isa.method_msgSend["makeObjectsPerformSelector:withObjects:"] || _objj_forward)(self, "makeObjectsPerformSelector:withObjects:", aSelector, [anObject]);
}
,["void","SEL","id"]), new objj_method(sel_getUid("makeObjectsPerformSelector:withObjects:"), function(self, _cmd, aSelector, objects)
{
    if (!aSelector)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPInvalidArgumentException, "makeObjectsPerformSelector:withObjects: 'aSelector' can't be nil");
    var index = 0,
        count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
    if ((objects == null ? null : (objects.isa.method_msgSend["count"] || _objj_forward)(objects, "count")))
    {
        var argumentsArray = ((___r1 = [nil, aSelector]), ___r1 == null ? null : (___r1.isa.method_msgSend["arrayByAddingObjectsFromArray:"] || _objj_forward)(___r1, "arrayByAddingObjectsFromArray:", objects));
        for (; index < count; ++index)
        {
            argumentsArray[0] = (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index);
            objj_msgSend.apply(this, argumentsArray);
        }
    }
    else
    {
        var anIsa = self.isa;
        for (; index < count; ++index)
            anIsa.objj_msgSend0((self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index), aSelector);
    }
    var ___r1;
}
,["void","SEL","CPArray"]), new objj_method(sel_getUid("enumerateObjectsUsingBlock:"), function(self, _cmd, aFunction)
{
    var index = 0,
        count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count"),
        shouldStop = NO,
        shouldStopRef = function(__input) { if (arguments.length) return shouldStop = __input; return shouldStop; };
    for (; index < count; ++index)
    {
        aFunction((self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index), index, shouldStopRef);
        if (shouldStop)
            return;
    }
}
,["void","Function"]), new objj_method(sel_getUid("enumerateObjectsWithOptions:usingBlock:"), function(self, _cmd, options, aFunction)
{
    if (options & CPEnumerationReverse)
    {
        var index = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count") - 1,
            stop = -1,
            increment = -1;
    }
    else
    {
        var index = 0,
            stop = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count"),
            increment = 1;
    }
    var shouldStop = NO,
        shouldStopRef = function(__input) { if (arguments.length) return shouldStop = __input; return shouldStop; };
    for (; index !== stop; index += increment)
    {
        aFunction((self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index), index, shouldStopRef);
        if (shouldStop)
            return;
    }
}
,["void","CPEnumerationOptions","Function"]), new objj_method(sel_getUid("firstObjectCommonWithArray:"), function(self, _cmd, anArray)
{
    var count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
    if (!(anArray == null ? null : (anArray.isa.method_msgSend["count"] || _objj_forward)(anArray, "count")) || !count)
        return nil;
    var index = 0;
    for (; index < count; ++index)
    {
        var object = (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index);
        if ((anArray == null ? null : (anArray.isa.method_msgSend["containsObject:"] || _objj_forward)(anArray, "containsObject:", object)))
            return object;
    }
    return nil;
}
,["id","CPArray"]), new objj_method(sel_getUid("isEqualToArray:"), function(self, _cmd, anArray)
{
    if (self === anArray)
        return YES;
    if (!(anArray == null ? null : (anArray.isa.method_msgSend["isKindOfClass:"] || _objj_forward)(anArray, "isKindOfClass:", CPArray)))
        return NO;
    var count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count"),
        otherCount = (anArray == null ? null : (anArray.isa.method_msgSend["count"] || _objj_forward)(anArray, "count"));
    if (anArray === nil || count !== otherCount)
        return NO;
    var index = 0;
    for (; index < count; ++index)
    {
        var lhs = (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index),
            rhs = (anArray == null ? null : (anArray.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(anArray, "objectAtIndex:", index));
        if (lhs !== rhs && (lhs && !lhs.isa || rhs && !rhs.isa || !(lhs == null ? null : (lhs.isa.method_msgSend["isEqual:"] || _objj_forward)(lhs, "isEqual:", rhs))))
            return NO;
    }
    return YES;
}
,["BOOL","id"]), new objj_method(sel_getUid("isEqual:"), function(self, _cmd, anObject)
{
    return self === anObject || (self.isa.method_msgSend["isEqualToArray:"] || _objj_forward)(self, "isEqualToArray:", anObject);
}
,["BOOL","id"]), new objj_method(sel_getUid("_javaScriptArrayCopy"), function(self, _cmd)
{
    var index = 0,
        count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count"),
        copy = [];
    for (; index < count; ++index)
        push.call(copy, (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index));
    return copy;
}
,["Array"]), new objj_method(sel_getUid("arrayByAddingObject:"), function(self, _cmd, anObject)
{
    var argumentArray = (self.isa.method_msgSend["_javaScriptArrayCopy"] || _objj_forward)(self, "_javaScriptArrayCopy");
    push.call(argumentArray, anObject);
    return ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["arrayWithArray:"] || _objj_forward)(___r1, "arrayWithArray:", argumentArray));
    var ___r1;
}
,["CPArray","id"]), new objj_method(sel_getUid("arrayByAddingObjectsFromArray:"), function(self, _cmd, anArray)
{
    if (!anArray)
        return (self.isa.method_msgSend["copy"] || _objj_forward)(self, "copy");
    var anArray = anArray.isa === _CPJavaScriptArray ? anArray : (anArray == null ? null : (anArray.isa.method_msgSend["_javaScriptArrayCopy"] || _objj_forward)(anArray, "_javaScriptArrayCopy")),
        argumentArray = concat.call((self.isa.method_msgSend["_javaScriptArrayCopy"] || _objj_forward)(self, "_javaScriptArrayCopy"), anArray);
    return ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["arrayWithArray:"] || _objj_forward)(___r1, "arrayWithArray:", argumentArray));
    var ___r1;
}
,["CPArray","CPArray"]), new objj_method(sel_getUid("subarrayWithRange:"), function(self, _cmd, aRange)
{
    if (!aRange)
        return (self.isa.method_msgSend["copy"] || _objj_forward)(self, "copy");
    if (aRange.location < 0 || CPMaxRange(aRange) > self.length)
        (CPException.isa.method_msgSend["raise:reason:"] || _objj_forward)(CPException, "raise:reason:", CPRangeException, "subarrayWithRange: aRange out of bounds");
    var index = aRange.location,
        count = CPMaxRange(aRange),
        argumentArray = [];
    for (; index < count; ++index)
        push.call(argumentArray, (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index));
    return ((___r1 = (self.isa.method_msgSend["class"] || _objj_forward)(self, "class")), ___r1 == null ? null : (___r1.isa.method_msgSend["arrayWithArray:"] || _objj_forward)(___r1, "arrayWithArray:", argumentArray));
    var ___r1;
}
,["CPArray","CPRange"]), new objj_method(sel_getUid("sortedArrayUsingDescriptors:"), function(self, _cmd, descriptors)
{
    var sorted = (self.isa.method_msgSend["copy"] || _objj_forward)(self, "copy");
    (sorted == null ? null : (sorted.isa.method_msgSend["sortUsingDescriptors:"] || _objj_forward)(sorted, "sortUsingDescriptors:", descriptors));
    return sorted;
}
,["CPArray","CPArray"]), new objj_method(sel_getUid("sortedArrayUsingFunction:"), function(self, _cmd, aFunction)
{
    return (self.isa.method_msgSend["sortedArrayUsingFunction:context:"] || _objj_forward)(self, "sortedArrayUsingFunction:context:", aFunction, nil);
}
,["CPArray","Function"]), new objj_method(sel_getUid("sortedArrayUsingFunction:context:"), function(self, _cmd, aFunction, aContext)
{
    var sorted = (self.isa.method_msgSend["copy"] || _objj_forward)(self, "copy");
    (sorted == null ? null : (sorted.isa.method_msgSend["sortUsingFunction:context:"] || _objj_forward)(sorted, "sortUsingFunction:context:", aFunction, aContext));
    return sorted;
}
,["CPArray","Function","id"]), new objj_method(sel_getUid("sortedArrayUsingSelector:"), function(self, _cmd, aSelector)
{
    var sorted = (self.isa.method_msgSend["copy"] || _objj_forward)(self, "copy");
    (sorted == null ? null : (sorted.isa.method_msgSend["sortUsingSelector:"] || _objj_forward)(sorted, "sortUsingSelector:", aSelector));
    return sorted;
}
,["CPArray","SEL"]), new objj_method(sel_getUid("componentsJoinedByString:"), function(self, _cmd, aString)
{
    return join.call((self.isa.method_msgSend["_javaScriptArrayCopy"] || _objj_forward)(self, "_javaScriptArrayCopy"), aString);
}
,["CPString","CPString"]), new objj_method(sel_getUid("arrayByApplyingBlock:"), function(self, _cmd, aFunction)
{
    var result = [],
        count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count");
    for (var idx = 0; idx < count; idx++)
    {
        var obj = aFunction((self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", idx), idx);
        (result == null ? null : (result.isa.method_msgSend["addObject:"] || _objj_forward)(result, "addObject:", obj));
    }
    return result;
}
,["CPArray","Function"]), new objj_method(sel_getUid("description"), function(self, _cmd)
{
    return (self.isa.method_msgSend["_descriptionWithMaximumDepth:"] || _objj_forward)(self, "_descriptionWithMaximumDepth:", CPArrayMaxDescriptionRecursion);
}
,["CPString"]), new objj_method(sel_getUid("_descriptionWithMaximumDepth:"), function(self, _cmd, maximumDepth)
{
    var index = 0,
        count = (self.isa.method_msgSend["count"] || _objj_forward)(self, "count"),
        description = "@[";
    for (; index < count; ++index)
    {
        if (index === 0)
            description += "\n";
        var object = (self.isa.method_msgSend["objectAtIndex:"] || _objj_forward)(self, "objectAtIndex:", index);
        description += (CPDescriptionOfObject(object, maximumDepth)).replace(/^/mg, "    ");
        if (index < count - 1)
            description += ",\n";
        else
            description += "\n";
    }
    return description + "]";
}
,["CPString","int"]), new objj_method(sel_getUid("pathsMatchingExtensions:"), function(self, _cmd, filterTypes)
{
    var index = 0,