@import <Foundation/CPObject.j>
@import "MKMapView.j"

@class MKMapView



MKLocationStringRegEx = /\s*<(\-?\d*\.?\d*),\s*(\-?\d*\.?\d*)>\s*$/;

@implementation MKLocation : CPObject {
    float         _latitude   @accessors(property=latitude);
    float         _longitude  @accessors(property=longitude);
}



- (void) encodeWithCoder:(CPCoder)coder {
    [coder encodeObject:[_latitude, _longitude] forKey:@"location"];
}



- (LatLng) googleLatLng {
    var gm= [MKMapView gmNamespace];
    if ( !gm )
    	return null;
    return new gm.LatLng(_latitude, _longitude);
}



- (id) initWithLatLng:(LatLng)aLatLng {
    return [self initWithLatitude:aLatLng.lat() andLongitude:aLatLng.lng()];
}



- (id) initWithLatitude:(float)aLat andLongitude:(float)aLng {
    if (self = [super init]) {
        _latitude = aLat;
        _longitude = aLng;
    }
    return self;
}



- (float) latitude {
	return _latitude;
}



- (float) longitude {
	return _longitude;
}



+ (MKLocation) location {
    return [[MKLocation alloc] init];
}



+ (MKLocation) locationWithLatitude:(float)aLat andLongitude:(float)aLng {
    return [[MKLocation alloc] initWithLatitude:aLat andLongitude:aLng];
}



+ (MKLocation) locationFromString:(CPString)aString {
    var res = MKLocationStringRegEx.exec(aString);
    
    if ( res && res.length === 3 ) {
        return [MKLocation locationWithLatitude:res[1] andLongitude:res[2]];
    }
    
    return nil;
}



@end

