@import <AppKit/CPView.j>
@import "MKMapItem.j"
@import "MKMapView.j"
@import "MKLocation.j"

@class Marker



@implementation MKMarker : MKMapItem {
    Marker      _gMarker    @accessors(property=gMarker);
    id			_gMaps;
    MKLocation  _location   @accessors(property=location);
    BOOL        _draggable  @accessors(property=draggable);
    BOOL        _withShadow  @accessors(property=withShadow);
    CPString    _iconUrl    @accessors(property=iconUrl);
    CPString    _shadowUrl  @accessors(property=shadowUrl);
    id          _delegate  @accessors(property=delegate);
    CPString    _infoWindowHTML;
    CPDictionary _eventHandlers;
	CPString	_title;
}



- (void) addEventForName:(CPString)anEvent withFunction:(JSObject)aFunction {
    if ( !_eventHandlers )
        _eventHandlers = {};
    
    _eventHandlers[anEvent] = aFunction;

	/*
    if ( _gMaps && _gMarker ) {
    	alert("invoking addListener...");
       _gMaps.Event.addListener(_gMarker, anEvent, aFunction);
    }
    */
}



- (void) addToMapView:(MKMapView)mapView {
	_gMarker= [mapView setInMapWithLongitude:[_location longitude] latitude:[_location latitude] draggable:_draggable icon:_iconUrl title:_title withShadow:_withShadow];

	if ( !_gMarker ) {
		alert("MKMarker: addToMapView: _gMaker not defined");
		return;
	}

	/*
    if ( _infoWindowHTML )
        _gMarker.openInfoWindowHtml(_infoWindowHTML);
    
	_gMaps= [mapView gmNamespace];
    alert("addToMapView: invoking addListeners with _gMaps="+_gMaps);
    if ( _eventHandlers ) {
        for (var key in _eventHandlers) {
            var func= _eventHandlers[key];
            alert("MKMarker4: _gMarker="+_gMarker+"  key="+key+"  func="+func);
            _gMaps.Event.addListener(_gMarker, key, func);
        }
    }
    alert("addToMapView: invoking addListeners 2 _gMaps...");
    _gMaps.Event.addListener(_gMarker, "dragend", function() { [self updateLocation]; });
    */
}



- (void) closeInfoWindow {
	if ( _gMarker )
        _gMarker.closeInfoWindow();
}



- (void) encodeWithCoder:(CPCoder)coder {
    [coder encodeObject:[[_location latitude], [_location longitude]] forKey:@"location"];
}



- (id) getMarker {
    return _gMarker;
}



- (CPString) infoWindowHTML {
    return _infoWindowHTML;
}



- (id) initAtLocation:(MKLocation)aLocation {
    if (self = [super init]) {
    	_gMaps= null;
        _location = aLocation;
        _withShadow = YES;
        _draggable = YES;
		_title	= "";
    }
    return self;
}



- (MKLocation) location {
	[self updateLocation];
	return _location;
}



+ (MKMarker) marker {
    return [[MKMarker alloc] init];
}



- (void) openInfoWindow {
	if ( _gMarker ) {
        _gMarker.closeInfoWindow();
        _gMarker.openInfoWindowHtml(_infoWindowHTML);
    }
}



- (void) removeFromMapView {
	if ( _gMarker )
		_gMarker.setMap(null);
}



- (void) setDraggable:(BOOL)aBOOL {
	_draggable=aBOOL;
}



- (void) setGoogleIcon:(CPString)anIconName withShadow:(BOOL)withShadow {
    _withShadow = withShadow;
    
    if (anIconName) {
        _iconUrl = "http://maps.google.com/mapfiles/ms/micons/" + anIconName + ".png"
        
        if (withShadow) {
            if (anIconName.match(/dot/) || anIconName.match(/(blue|green|lightblue|orange|pink|purple|red|yellow)$/)) {
                _shadowUrl = "http://maps.google.com/mapfiles/ms/micons/msmarker.shadow.png";
            } else if (anIconName.match(/pushpin/)) {
                _shadowUrl = "http://maps.google.com/mapfiles/ms/micons/pushpin_shadow.png";
            } else {
                _shadowUrl = "http://maps.google.com/mapfiles/ms/micons/" + anIconName + ".shadow.png";
            }
        }
    } 
    else {
        _iconUrl = nil;
        _shadowUrl = "http://maps.google.com/mapfiles/ms/micons/msmarker.shadow.png"; //default shadow
    }
}



- (void) setGoogleIcon:(CPString)anIconName {
    [self setGoogleIcon:anIconName withShadow:YES];
}



- (void) setInfoWindowHTML:(CPString)someHTML {
   [self setInfoWindowHTML:someHTML openOnClick:NO];
}



- (void) setInfoWindowHTML:(CPString)someHTML openOnClick:(BOOL)shouldOpenOnClick {
    _infoWindowHTML = someHTML;
    if ( shouldOpenOnClick )
        [self addEventForName:@"click" withFunction:function() {[self openInfoWindow];}];
}



- (void) setLocation:(MKLocation)loca  {
    _location= loca;
    var gLatLng= [loca googleLatLng];
	_gMarker.setPosition(gLatLng);
}



- (void) setOtherIcon:(CPString)anIconName {
	_iconUrl= anIconName;
}



- (void) setTitle:(CPString)aTitle {
	_title= aTitle;
}



- (CPString) title {
	return _title;
}



- (void) updateLocation {
    _location = [[MKLocation alloc] initWithLatLng:_gMarker.getPosition()];
    if (_delegate && [_delegate respondsToSelector:@selector(mapMarker:didMoveToLocation:)])
        [_delegate mapMarker:self didMoveToLocation:_location];
}




@end



/*!
    Sets the icon URL based on this url pattern:
    http://maps.google.com/mapfiles/ms/micons/<anIconName>.png
    
    Some examples:
    
    POI
    arts
    bar
    blue-dot
    blue-pushpin
    blue
    bus
    cabs
    camera
    campfire
    campground
    caution
    coffeehouse
    convienancestore
    cycling
    dollar
    drinking_water
    earthquake
    electronics
    euro
    fallingrocks
    ferry
    firedept
    fishing
    flag
    gas
    golfer
    green-dot
    green
    grn-pushpin
    grocerystore
    groecerystore
    helicopter
    hiker
    homegardenbusiness
    horsebackriding
    hospitals
    hotsprings
    info
    info_circle
    landmarks-jp
    lightblue
    lodging
    ltblu-pushpin
    ltblue-dot
    man
    marina
    mechanic
    motorcycling
    movies
    orange-dot
    orange
    parkinglot
    partly_cloudy
    pharmacy-us
    phone
    picnic
    pink-dot
    pink-pushpin
    pink
    plane
    police
    postoffice-jp
    postoffice-us
    purple-dot
    purple-pushpin
    purple
    question
    rail
    rainy
    rangerstation
    realestate
    recycle
    red-dot
    red-pushpin
    red
    restaurant
    sailing
    salon
    shopping
    ski
    ski
    snack_bar
    snowflake_simple
    sportvenue
    subway
    sunny
    swimming
    toilets
    trail
    tram
    tree
    truck
    volcano
    water
    waterfalls
    webcam
    wheel_chair_accessible
    woman
    yellow-dot
    yellow
    yen
    ylw-pushpin
    
    You can find a list of official google maps icons here:
    http://www.visual-case.it/cgi-bins/vc/GMapsIcons.pl
*/

