@import <AppKit/CPView.j>
@import "MKMapItem.j"
@import "MKMapView.j"
@import "MKLocation.j"

@class MKMapView


@implementation MKPolyline : MKMapItem {
    CPArray     _locations     @accessors(property=locations);
    CPString    _colorCode     @accessors(property=colorCode);
    int         _lineStroke    @accessors(property=lineStroke);
    id			_line;
}



- (void) addLocation:(MKLocation)aLocation {
    if (!_locations) {
        _locations = [[CPArray alloc] init];
    }
    [_locations addObject:aLocation];
}



- (void) addToMapView:(MKMapView)mapView {
    [self googlePolyline];
    var gMap= [mapView gMap];
    _line.setMap(gMap);
}



- (void) clearFromMap:(MKMapView)mapView {
    _line.setMap(null);
}



- (id) getPolyline {
    return _line;
}



- (Polyline) googlePolyline {
    if ( _locations ) {
        var gm = [MKMapView gmNamespace];
        var locEnum = [_locations objectEnumerator];
        var loc = nil
        var lineCoordinates = [];
        while ( loc = [locEnum nextObject] )
            lineCoordinates.push([loc googleLatLng]);
        /*
            {path: lineCoordinates,
    			geodesic: true,
    			strokeColor: '#FF0000',
    			strokeOpacity: 1.0,
    			strokeWeight: 2
  				}
  		*/
		_line= new google.maps.Polyline({path:lineCoordinates,strokeColor:_colorCode});
    }
    else
	    _line= nil;
    return _line;
}



- (id) init {
    return [self initWithLocations:nil];
}



- (id) initWithLocations:(CPArray)someLocations {
    if (self = [super init]) {
        _locations = someLocations;
        _colorCode = @"#ff0000";
        _lineStroke = 5;
    }
    return self;
}



- (CPArray) locations {
	return _locations;
}



+ (MKPolyline) polyline {
    return [[MKPolyline alloc] init];
}



- (void) setColor:(CPString)color {
	_colorCode= color;
}



- (void) setLineStroke:(int)lineStroke {
	_lineStroke= lineStroke;
}



@end

