//
//  RMSchedulerView.j
//  riweb
//
//  Created by Pablo Miranda on 2/25/16.
//  Copyright Route-Miner 2016. All rights reserved.
//

@import <Foundation/CPObject.j>
@import <AppKit/CPView.j>
@import "RMWebView.j"



@implementation RMSchedulerView : RMWebView {

	CPString divName; 
	CPString divWidth @accessors;
	CPString divHeight @accessors;

	CPString funcName;

	id	googFlag;
	CPString htmlPage;
	
	CPArray idenArra;

	id mapFunc;
	id mapDeviIdenArra;
	id mapSour;
	CPString mode;

	CPArray nameArra;
    CPArray custHoliArra;
	CPString onLoad;
	CPString optiStri;

	CPString repoType @accessors;
	
	CPString scrpCodeStar;
	CPString scrpCodeEnd;

	id timrChar;
	CPString title @accessors;
	
	CPString vari;
	
    id appCont;
	id cgiHost;

}



- (CPString) buildBody {
	console.log("RMSchedulerView:: buildBody: entering...");

	var stri = "";

	stri += "<div id='"+divName+"' class='dhx_cal_container' style='width:100%; height:100%;'>";
		stri += "<div class='dhx_cal_navline'>";
			stri += "<div class='dhx_cal_prev_button'>&nbsp;</div>";
			stri += "<div class='dhx_cal_next_button'>&nbsp;</div>";
			stri += "<div class='dhx_cal_today_button'></div>";
			stri += "<div class='dhx_cal_date'></div>";
			stri += "<div class='dhx_cal_tab' name='day_tab' style='right:50px;'></div>";
			stri += "<div class='dhx_cal_tab' name='week_tab' style='right:40px;'></div>";
			stri += "<div class='dhx_cal_tab' name='month_tab' style='right:30px;'></div>";
			stri += "<div class='dhx_cal_tab' name='agenda_tab' style='right:30px;'></div>";
			//stri += "<div class='dhx_cal_tab' name='map_tab' style='right:30px;'></div>";
		stri += "</div>";
		stri += "<div class='dhx_cal_header'></div>";
		stri += "<div class='dhx_cal_data'></div>";
	stri += "</div>";
	
	console.log(stri);

	return stri;
}



- (CPString) buildBodyAlternative {
	//var fram = [self frame];
	//var framWidt  = fram.size.width - 20;
	//var framHeig  = fram.size.height - 20;
	//return "<div id='" + divName + "' style='width:" + framWidt + "; height:" + framHeig +"'>";
	return "<div id='" + divName + "' style='width:100%; height:100%'>";
}



- (void) buildHTMLPage {
	console.log("RMSchedulerView:: buildHTMLPage: entering...");

	htmlPage = "<html>";
	htmlPage += "<head>";
	htmlPage += "<meta http-equiv='Content-type' content='text/html; charset=utf-8'>";
	htmlPage += "<title>RM Scheduler</title>";
	
	//DHTMLX GENERAL
	htmlPage += "<script src='codebase/dhtmlxscheduler.js' type='text/javascript' charset='utf-8'></script>";
	htmlPage += "<link rel='stylesheet' href='codebase/dhtmlxscheduler.css' type='text/css' media='screen' title='RM Scheduler' charset='utf-8'>";
	htmlPage += "<link rel='stylesheet' href='style.css' type='text/css' media='screen' title='RM Scheduler' charset='utf-8'>";
	
	//htmlPage += "<script src='http://maps.google.com/maps/api/js?sensor=false'></script>";
	htmlPage += "<script type='text/javascript' src='https://maps.googleapis.com/maps/api/js?v=3.exp&amp;key=AIzaSyCRoA5SknDayXD8Rs44vui4TQSdqhfVTF0&amp;libraries=drawing'> </script>"
	
	htmlPage += "<script src='codebase/locale/locale_es.js' type='text/javascript' charset='utf-8'></script>";
	htmlPage += "<script src='codebase/ext/dhtmlxscheduler_active_links.js'></script>";
	htmlPage += "<script src='codebase/ext/dhtmlxscheduler_limit.js'></script>";
	htmlPage += "<script src='codebase/ext/dhtmlxscheduler_agenda_view.js'></script>";
    htmlPage += "<script src='codebase/ext/dhtmlxscheduler_tooltip.js' type='text/javascript' charset='utf-8'></script>";

	//htmlPage += "<script src='codebase/ext/dhtmlxscheduler_map_view.js'></script>";
	htmlPage += "<script src='codebase/ext/dhtmlxscheduler_pdf.js'></script>";
	
	htmlPage += "<script src='codebase/ext/dhtmlxscheduler_editors.js' type='text/javascript'></script>";
	htmlPage += "<link href='codebase/combo/skins/web/dhtmlxcombo.css' rel='stylesheet' type='text/css'/> ";
	htmlPage += "<script src='codebase/common/dhtmlxCommon/dhtmlxcommon.js' type='text/javascript'></script>";
	htmlPage += "<script src='codebase/common/dhtmlxCombo/dhtmlxcombo.js' type='text/javascript'></script>";	
		
	
	htmlPage += "</head>";
	htmlPage += [self buildMiddle];
	htmlPage += "<body onLoad='init();'>";
	htmlPage += [self buildBody];
	htmlPage += "</body>";
	
	htmlPage += "</html>";
}



- (CPString) buildMiddle {
	var stri = @"";
	
	stri += "<style type='text/css' media='screen'>";
	stri += "html, body {margin: 0px; padding: 0px; height: 100%; overflow: hidden;}";
	stri += ".dhx_cal_event.past_event div{color:black ;}";
    stri += ".dhx_cal_event_line.past_event{color:black;}";
	stri += ".dhx_cal_event_clear.past_event{color:black;}";

	stri += "</style>";

	stri += "<script type='text/javascript' charset='utf-8'>";
		stri += "function " + funcName + "() {";
			
			//stri += "scheduler.config.touch = 'force';";
			//stri += "scheduler.config.multi_day = true;";
			stri += "var temp;";
			stri += "scheduler.config.prevent_cache = true;";
			stri += "scheduler.locale.labels.agenda_tab = 'Agenda';";
			stri += "scheduler.config.xml_date = '%Y-%m-%d %H:%i';";
			stri += "scheduler.config.active_link_view = 'day';";
			stri += "scheduler.config.first_hour = 0;";
			stri += "scheduler.config.last_hour = 24;";
			stri += "scheduler.config.resize_month_events = true;";
			stri += "scheduler.config.agenda_start = new Date(2015,0,0);";
			stri += "scheduler.config.agenda_end = new Date(2020,11,30);";
			stri += "scheduler.config.dblclick_create = false;";
			stri += "scheduler.config.drag_create = false;";
			stri += "scheduler.config.show_loading = true;";
			//stri += "scheduler.config.map_start = new Date(2015,0,0);";
			//stri += "scheduler.config.map_end = new Date(2020,11,30);";
			
			stri += " var snacks = [ ";
			stri += "	{ key: 1, label: '1' }, ";
			stri += "	{ key: 2, label: '2' } ";
			stri += " ]; ";
			
			
			stri += "scheduler.config.lightbox.sections = [";
			stri += "{name:'desc', height:21, type:'textarea', map_to:'text', focus:false},";
			    //stri += "{name:'source',      height:21, type:'textarea', map_to:'source'},";
			    //stri += "{name:'calendar',    height:21, type:'textarea', map_to:'calendar''},";//Original
			//stri += "{ name:'calendar', options: snacks, map_to:'calendar', type:'combo', image_path: '', filtering: true, script_path: 'data/test.xml', cache: false },";
			stri += "{name: 'filtActi', options: snacks, map_to: 'combo_select', type: 'combo', image_path: 'codebase/combo/skins/web/imgs/', height: 30, filtering: true,";
            stri +=  "      script_path: 'connectors/dbConnCombCale.php', cache: false },"; 
			stri += "{ name:'calendar', options: snacks, map_to:'calendar', type:'textarea', image_path: '', filtering: true, cache: false },";
			    
			    /*{ name: "country", options: snacks, map_to: "combo_select", type: "combo", 
			    image_path: "../../samples/common/dhtmlxCombo/imgs/", filtering: true, script_path: "data/combo_select.php", cache: false }*/
			stri += "{name: 'filtPers', options: snacks, map_to: 'combo_select', type: 'combo', image_path: 'codebase/combo/skins/web/imgs/', height: 30, filtering: true,";
            stri +=  "      script_path: 'connectors/dbConnCombPers.php', cache: false },";    
			stri += "{name:'personnel',   height:21, type:'textarea', map_to:'personnel'},";			
			
			stri += "{name:'location',    height:21, type:'textarea', map_to:'location'},";
			stri += "{name:'customer',    height:21, type:'textarea', map_to:'customer'},";
			
			stri += "{name: 'filtVehi', options: snacks, map_to: 'combo_select', type: 'combo', image_path: 'codebase/combo/skins/web/imgs/', height: 30, filtering: true,";
            stri +=  "      script_path: 'connectors/dbConnCombVehi.php', cache: false },"; 
			stri += "{name:'vehicle',     height:21, type:'textarea', map_to:'vehicle'},";
				/*stri += "{name:'type',        height:21, type:'select',   map_to:'type', options:[";
					stri += "{key:1, label:'Simple'},";
					stri += "{key:2, label:'Complex'},";
					stri += "{key:3, label:'Unknown'}";
				stri += "]},";*/
			    //stri += "{name:'color',       height:21, type:'textarea', map_to:'color'},";
			    //stri += "{name:'description', height:50, type:'textarea', map_to:'text'},";
			stri += "{name:'eventComm',    height:50, type:'textarea', map_to:'eventComm'},";
			stri += "{name:'serieComm',    height:50, type:'textarea', map_to:'serieComm'},";
			stri += "{name:'time',        height:60, type:'time',     map_to:'auto'}";
			stri += "];";
			
			var dateDesc = [[CPDate dateWithTimeIntervalSinceNow:-60*60*24*7] description];
			var rang     = CPMakeRange(0,4);
			var year     = [dateDesc substringWithRange:rang];
			rang         = CPMakeRange(5,2);
			var mont     = [[dateDesc substringWithRange:rang] intValue] - 1;
			rang         = CPMakeRange(8,2);
			var day      = [dateDesc substringWithRange:rang];

			//stri += "scheduler.init('"+divName+"', new Date("+year+","+mont+","+day+"), 'month');";
			stri += "scheduler.init('"+divName+"', new Date(), 'month');";

			//stri += "scheduler.locale.labels.agenda_tab = 'Agenda';"; //Original
			stri += "scheduler.locale.labels.map_tab = 'Map';";
			//stri += "scheduler.locale.labels.section_type = 'Type';";
			//stri += "scheduler.locale.labels.section_source = 'Source';";
			stri += "scheduler.locale.labels.section_desc      = 'Título:';";
			stri += "scheduler.locale.labels.section_filtActi  = 'Filtro actividad:';";
			stri += "scheduler.locale.labels.section_calendar  = 'Actividad:';";
			stri += "scheduler.locale.labels.section_filtPers  = 'Filtro personal:';";
			stri += "scheduler.locale.labels.section_personnel = 'Personal:';";
			stri += "scheduler.locale.labels.section_location  = 'Organización:';";
			stri += "scheduler.locale.labels.section_customer  = 'Cliente:';";
			stri += "scheduler.locale.labels.section_filtVehi  = 'Filtro Vehículo:';";
			stri += "scheduler.locale.labels.section_vehicle   = 'Vehículo:';";
			stri += "scheduler.locale.labels.section_eventComm = 'Comentario Evento:';";
			stri += "scheduler.locale.labels.section_serieComm = 'Comentario Serie:';";
			//stri += "scheduler.locale.labels.section_color = 'Color';";

			
			stri += "scheduler.ignore_week = function(date) {";
			    stri += "if (date.getDay() == 7 || date.getDay() == -1)";
			        stri += "return true;";
			stri += "};";
			
			
			
			/*
			//This function hidden Sunday  in month view
			stri += "scheduler.ignore_month = function(date) {";
    			stri += "if ( date.getDay() == 0 )";
    			    stri += "return true;";
			stri += "};";
			*/
			/*
			stri += "scheduler.attachEvent('onClick', function (id, e){";
			    stri += "console.log('onClick: id='+id);";
				stri += "scheduler.updateView();";
			    stri += "return true;";
			stri += "});";  */
			var srvrSide = @"cgi-bin";
            srvrSide = @"rm_webservices/index.php/orkin";
            var url = [CPString stringWithFormat:@"http://%@%@%@/%@",cgiHost,appCont.appHost,srvrSide,appCont.cgiServ];
			stri += "scheduler.attachEvent('onBeforeEventChanged', function(ev, e, is_new, ov){";
			    stri += "console.log('onBeforeEventChanged: ev='+ev.text);";
			    stri += "return true;";
			stri += "});";
			
			stri += "scheduler.attachEvent('onBeforeEventDelete', function(id,ev){";
				stri += "console.log('onBeforeEventDelete: ev='+ev.text);";
    			stri += "console.log(ev);";
    			stri += "return true;";
			stri += "});";
			stri += "scheduler.attachEvent('onEventChanged',function(id,ev){";
				stri += "if ( !ev.text ) {";
					stri += "alert('onEventChanged: Text must not be empty');";
					stri += "return false;";
				stri += "}";
				stri += "console.log(ev);";
				/**
				
				
var url = "get_data.php";
var params = "lorem=ipsum&name=binny";
http.open("POST", url, true);

//Send the proper header information along with the request
http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");

http.onreadystatechange = function() {//Call a function when the state changes.
    if(http.readyState == 4 && http.status == 200) {
        alert(http.responseText);
    }
}
http.send(params);
				
				**/
			    //stri += "console.log('onEventChanged: id='+id+'   ev='+ev.text);";
			   // stri += "console.log('changing event dhtmlx, also must change series.....');";
			    //add 2017-02-23
			    /*
			    stri += "var xhttp;";
			    stri += "xhttp = new XMLHttpRequest();";
			    stri += "xhttp.onreadystatechange = function() {";
			    stri += "if (this.readyState == 4 && this.status == 200) {";
			    stri += "alert('Cambios realizados!!!');";
			    stri += " }";
			    stri += "};";
			    stri += "xhttp.open('GET', 'http://201.196.229.154/cgi-bin/updateEvent.php?iden='+id, true);";
			    stri += "xhttp.send(); "
			    */
			    /*
			    stri += "var hr = new XMLHttpRequest();";			    
			    stri += "hr.open('POST', 'http://201.196.229.154/cgi-bin/updateEvent.php', true);";
			    stri += "hr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');"			    
			    stri += "hr.onreadystatechange = function() {";
			    stri += "if (this.readyState == 4 && this.status == 200) {";
			    stri += "alert('Cambios realizados!!!');";
			    stri += " }";
			    stri += "};";			  
			    stri += "var vari = 'iden='+id ;";
			    stri += "hr.send(vari); "
				*/
				stri += "return true;";
			stri += "});";
			//Read onlu
			stri += "scheduler.attachEvent('onLightbox', function(){";
			
			//stri += "var desc = scheduler.formSection('desc');";
			//stri += "desc.control.disabled = true;";
			
			//stri += "var caleSect = scheduler.formSection('calendar');";
			//stri += "caleSect.control.disabled = true;";
			
			//stri += "var persSect = scheduler.formSection('personnel');";
			//stri += "persSect.control.disabled = true;";
			
			stri += "var locaSect = scheduler.formSection('location');";
			stri += "locaSect.control.disabled = true;";
			
			stri += "var custSect = scheduler.formSection('customer');";
			stri += "custSect.control.disabled = true;";
			/*
			stri += "var vehiSect = scheduler.formSection('vehicle');";
			stri += "vehiSect.control.disabled = true;";
			
			stri += "var com1Sect = scheduler.formSection('comment1');";
			stri += "com1Sect.control.disabled = true;";
			
			stri += "var com2Sect = scheduler.formSection('comment2');";
			stri += "com2Sect.control.disabled = true;";
			*/
			
			stri += "});"
			
   			stri += "dhtmlXTooltip.config.timeout_to_display = 5;";
   			stri += "dhtmlXTooltip.config.delta_x = 15;";
   			stri += "dhtmlXTooltip.config.delta_y = -20;";
/*
   			stri += "var striPers; ";
   			stri += "scheduler.templates.event_text=function(start,end,event){  ";
   			stri += " striPers = scheduler.getLabel('personnel',event.personnel);  }";
*/
   			/*
scheduler.templates.event_text=function(start,end,event){ 
  return "Staff:"+scheduler.getLabel("staff",event.staff);
}
   			*/

   			stri += "var format = scheduler.date.date_to_str('%d-%m-%y %H:%i');";
   			stri += "scheduler.templates.tooltip_text = function (start, end, event) {";
      		stri += "return '<b>Actividad: </b>' + event.calendar + '</br> <b>Personal: </b>' + event.personnel + '</br> <b>Vehículo: </b>' + event.vehicle; };";


   			stri += "scheduler.templates.event_class = function (start, end, event) {";	
       		stri += "if (event.text) ";
           	stri += "return 'past_event'; };";			
			
			stri += " scheduler.updateView();";
			
			var now = [CPDate dateWithTimeIntervalSinceNow:0];
			var rangYear = CPMakeRange(0,4);
		  	var year = [[[now description] substringWithRange:rangYear] intValue];
			var coun = [custHoliArra count];
			for ( var i=0; i<coun; i++ ) {
				var valuList = [custHoliArra[i] valueList];
				var rang = CPMakeRange(4,6);
 				var date = [valuList[2] substringWithRange:rang];
				for(var j=0; j<=5; j++){
					var day = (year+j)+date + " 00:00:00";
					stri += "scheduler.addMarkedTimespan({  ";
    				stri += " days: new Date('"+day+"'),";  
    				stri += " zones: 'fullday',  ";    
    				stri += " css:   'holiday',";
    				stri += "html:'"+valuList[4]+"'";  
					stri += "});";
				}
			}
			
			
			stri += "scheduler.attachEvent('onSaveError', function(ids, resp){";
    			stri += "dhtmlx.alert('Fallo en actualizar los datos.');";
			stri += "});";
	
			//marks dates
			
			stri += "scheduler.attachEvent('onLoadError', function(response){";
    			stri += "dhtmlx.message('Fallo en cargar los datos.');";
			stri += "});";
			
			
			stri += "scheduler.updateView();";	
			


			//load data from db
			stri += "scheduler.load('http://" + cgiHost + "/RMScheduler/dbconnector_server.php?table="+appCont.useTabl+"');";
				//update data
			stri += "var dp = new dataProcessor('http://" + cgiHost + "/RMScheduler/dbconnector_server.php?table="+appCont.useTabl+"');";

			stri += "dp.attachEvent('onAfterUpdate', function(id, action, tid, response){";
				//stri += "console.log(action);";
     			stri += "if(action == 'updated'){";
     				stri += "dhtmlx.alert('Actualización exitosa!');";
     			stri += "}else if(action == 'deleted'){";
     				stri += "dhtmlx.alert('Se eliminó correctamente!');";
     			stri += "}else{";
     				stri += "dhtmlx.alert('Ha ocurrido un error en la operación, cierre el calendario y aplique nuevamente el filtro e intente de nuevo. Si el problema persiste comuniquese con el administrador');";
				stri += "}";

			stri += "});";
			stri += "dp.enableDebug(true);";
			stri += "dp.init(scheduler);";
			//back up
			/*
			stri += "scheduler.load('http://201.196.229.154/cgi-bin/dbconnector_server.php');";
			//update data
			stri += "var dp = new dataProcessor('http://201.196.229.154/cgi-bin/dbconnector_server.php');";
			stri += "dp.init(scheduler);";
			*/
			//stri += "dp.setAutoUpdate(5000,null);";

		stri += "}";
	stri += "</script>";
	return stri;
}





- (CPString) buildOptionScript {
    var scr = @"var options = {";
    scr += optiStri;
	scr += @"};";
	return scr;
}



- (void) buildScheduler:(id)paraAppCont {
	console.log("RMSchedulerView:: buildScheduler: entering...");
	
	appCont = paraAppCont;
	cgiHost = [appCont phpHost];
	
	[self buildHTMLPage];
	console.log(htmlPage);

	[self loadHTMLString:htmlPage];
	console.log("RMSchedulerView:: buildScheduler: timer...");

	timrChar = [CPTimer scheduledTimerWithTimeInterval:2 target:self selector:@selector(showSchedulerStart) userInfo:null repeats:NO];
	
}



- (CPArray) identification {
	return idenArra;
}



- (id) initWithFrame:(CGRect)aFrame {

	console.log("RMSchedulerView:: initWithFrame: entering...");
	console.log("RMSchedulerView:: width="+aFrame.size.width);

	if ( self = [super initWithFrame:aFrame] ) {

		[self setScrollMode:CPWebViewScrollNone];

		var aux  = Math.floor(Math.random()*1000000);
		funcName = "fnc_" + aux;
		divName  = "div_" + aux;

		googFlag = YES;

		onLoad = @"";
		optiStri = @"";

		scrpCodeStar = @"";
		scrpCodeEnd = @"";

		googFlag = NO;
		onLoad = "onload='"+funcName+"();'";

		console.log("RMSchedulerView:: inited.");
	}

	return self;
}






- (CPString) mode {
	return mode;
}



- (CPArray) name {
	return nameArra;
}



- (CPString) options {
	return optiStri;
}



- (void) setIdentification:(CPArray)idenArraNew {
	idenArra = [idenArraNew copy];
}



- (void) setMapFunction:(id)mapFuncNew forObject:(CPArray)deviIdenArraNew source:(CPString)sourNew {
	mapFunc = mapFuncNew;
	mapDeviIdenArra = deviIdenArraNew;
	mapSour = [sourNew copy];
}



- (void) setMode:(CPString)modeNew {
	mode = [modeNew copy];
}



- (void) setName:(CPArray)nameArraNew {
	nameArra = [nameArraNew copy];
}



- (void) setOptions:(CPString)optiStriNew {
	if ( !optiStriNew )
		return;
	optiStri = [optiStriNew copy];
}



- (void) setReportType:(CPString)_stri {
    _stri     = [_stri stringByReplacingOccurrencesOfString:@"[" withString:@""];
	_stri     = [_stri stringByReplacingOccurrencesOfString:@"]" withString:@""];
    repoType  = _stri;
}



- (void) setVariable:(CPString)variNew {
	vari = [variNew copy];
}


- (void) setHolidays:(CPArray)variNew {
	custHoliArra = [variNew copy];
}


- (void) showSchedulerStart {
	console.log("RMSchedulerView:: showSchedulerStart: entering...");
    var domWind = [self DOMWindow];
    if ( !domWind ) {
    	[CPTimer scheduledTimerWithTimeInterval:2 target:self selector:@selector(showSchedulerStart) userInfo:null repeats:NO];
    	console.log("1");
    }
    else if ( !domWind.document ) {
    	[CPTimer scheduledTimerWithTimeInterval:2 target:self selector:@selector(showSchedulerStart) userInfo:null repeats:NO];
    	console.log("2");
    }
	else
		domWind.document.addEventListener("DOMContentLoaded", [self showScheduler]);    
}



- (void) showScheduler {
	console.log("RMSchedulerView:: showScheduler: entering...");

    var domWind = [self DOMWindow];

    if ( typeof(domWind) == 'undefined' || googFlag && (typeof(domWind.google) == 'undefined' || typeof(domWind.google.charts) == 'undefined') ) {
	    console.log("DOMWindow.google.charts undefined");
		timrChar = [CPTimer scheduledTimerWithTimeInterval:0.5 target:self selector:@selector(showScheduler) userInfo:null repeats:NO];
		return;
    } 

	var wind = [self DOMIFrameWindow];
	wind.mapFunc = mapFunc;
	wind.mapDeviIdenArra = mapDeviIdenArra;
	wind.mapSour = mapSour;
	console.log("RMSchedulerView:: showScheduler: wind="+wind+"  wind.mapFunc="+wind.mapFunc);
	console.log(Object.keys(wind));

	console.log("RMSchedulerView:: showScheduler: displaying with func:"+funcName);

	var wso = [self windowScriptObject];
	var fnct= funcName + "()";
	[wso evaluateWebScript:fnct];
}



- (CPString) variable {
	return vari;
}




@end
