//
// RMSchedulerController
//
// Created by Alonso Villanueva

@import "../AppController.j"
@import "../model/Model.j"




@implementation AutomaticLocation :  RMControllerObject{


  	id mode;
  
	CPPanel repoPane;
   	CPPanel geneRepoPane;
   	
   	
   	id orgaPopu;
	id orgaDict;
	id orgaDictKeys;
   	
   	id locaPopu;
	id locaDict;
	id locaDictKeys;
	id locaCustDict;
	id locaCustDictKeys;
	
   	id emaiText;
   	
   	CPTableView emplTabl;
   	id emplDict;
   	id emplDictKeys;
   	id emplCustContDict;
   	id emplCustContDictKeys;
   	
   	
   	id locaAutoRepoDict;
	id locaAutoRepoDictKeys;
   	
   	
   	id persMenu;

  	id emaiComm;
  	id repoComm;

  	id checkActi;
  	id prevValuCheckActi;
  	id checkSendEmpt;
  	
  	id textDays;
  	
  	id dateStarText;
	id datePickStarPane;
  	

}



- (id) init:(id)paraAppCont {
	[super init];
 	
 	appCont = paraAppCont;
	dataBase = [appCont getDataBase];
	//alert("db init reports= " + [appCont getDataBase]);
	repoPane = geneRepoPane =  NULL;

	emplTabl = emplDict = NULL;
  	mode = NULL;
  	prevValuCheckActi = "0";
	emaiComm = repoComm = "";
	locaCustDict     = [[CPDictionary alloc] init];
	emplCustContDict = [[CPDictionary alloc] init];
	
	if ( !mode ) {
		mode = [[Model alloc]init:self];
		[mode organizationCodeSet:[appCont getOrgaCode] ];
		[mode organizationIdSet:[appCont organizationId] ];
		[mode cgiSetHost:[appCont getcgiHost] server:[appCont getcgiServ]];
		//Employees
		[mode loadPersonsDictionary];
		emplDict     = [mode persDict];
		emplDictKeys = [emplDict allKeys];
		
		//Organizations
		[mode loadOrganizationsDictionary];
		orgaDict     = [mode orgaDict];
		orgaDictKeys = [orgaDict allKeys];
		
		//Locations
		[mode loadLocationsDictionary];
		locaDict     = [mode locaDict];
		locaDictKeys = [locaDict allKeys];
		
		//AutomaticLocation
		[mode loadLocationsAutomaticReport];
		locaAutoRepoDict = [mode locaAutoRepoDict];		 
		locaAutoRepoDictKeys = [locaAutoRepoDict allKeys];
		
		
	}
	
	
	return self;
}




- (void)  applicationQuit {

	if ( repoPane ) {
		[repoPane orderOut:0];
		[repoPane release];
	}	
	
	if ( geneRepoPane ) {
		[geneRepoPane orderOut:0];
		[geneRepoPane release];
	}	
	
	if (emplTabl) { [emplTabl  release];}
	if (emplDict) { [emplDict  release];}
	if (emaiComm) { [emaiComm  release];}
	if (repoComm) { [repoComm  release];}
	if (mode) { 
		[mode  applicationQuit];
		[mode release];
	}

}


- (void) datePickerStartDateChange:(id)sender {
	[dateStarText setStringValue:[[[sender dateValue] description] substringToIndex:10]];
	[datePickStarPane close];
}

- (void) datePickerStartPanel:(id)sender {

	if ( datePickStarPane ) {
		[datePickStarPane orderFront:self];
	}else{
	
	var fram = CGRectMake(350,350,144,148);
	datePickStarPane = [[CPPanel alloc] initWithContentRect:fram styleMask:CPHUDBackgroundWindowMask|CPClosableWindowMask]; 
	[datePickStarPane setFloatingPanel:YES];
	[datePickStarPane setTitle:@"Fecha Inicio"];
	[datePickStarPane orderFront:self];

	var paneContView = [datePickStarPane contentView];

	fram = CGRectMake(0,0,144,148);
	var datePick = [[CPDatePicker alloc] initWithFrame:fram];
	[datePick setBackgroundColor:[CPColor whiteColor]];
	[datePick setTimeZone:[CPTimeZone defaultTimeZone]];
	[datePick setDatePickerElements:128];
	var dpe = [datePick datePickerElements];
	[datePick setDatePickerStyle:1];
	var dps = [datePick datePickerStyle];
	[datePick setDateValue:[CPDate date]];
	[datePick setObjectValue:[CPDate date]];
	[datePick setTarget:self];
	[datePick setAction:@selector(datePickerStartDateChange:)];
	//alert("dpe="+dpe+"  dps="+dps);
	
	[paneContView addSubview:datePick];
	}
}



- (void) reportsPanel {
	return repoPane;
}



- (void) reportsPanel:(id)sender {
	
	
	if (repoPane) {
		emplDict = NULL;
		[emplTabl reloadData];
		[repoPane orderFront:self];
	}else{
		
	var horiPos1 = 15;
	var horiPos2 = horiPos1 + 80;
	var horiPos3 = 310;
	var horiPos4 = horiPos3 + 253;

	var horiTextWidt = 200;
	var horiPosiOffs = -4;
	var horiPosi = 200;

	var vertPosi = 15;
	var vertPosiOffs = -4;
	var vertIncr = 26;
	var vertLineHeig = 30;

	var paneWidt = 750;
	var paneHeig = 620;
	var tablWidt = paneWidt - 20;
	var tablHeig = 150;
	
	var x = 50 + Math.random()*40;
	var y = 60 + Math.random()*40;
	var fram = CGRectMake(x,y, paneWidt,paneHeig);

	repoPane = [[CPPanel alloc] initWithContentRect:fram styleMask:CPHUDBackgroundWindowMask|CPClosableWindowMask|CPResizableWindowMask]; 
	[repoPane setFloatingPanel:YES]; 
	[repoPane orderFront:self];
	[repoPane setTitle:@"Reporte Automático Locación"];
	
	var paneContView = [repoPane contentView];
	[paneContView setBackgroundColor:coloDefaLite];
	[self addBanners:paneContView heightBlue:1. heightOrange:4.];

	var view = paneContView;

	//Organizations
	var labe = [self addTextField:@"Organizaciones:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	vertPosi += 30;
	orgaPopu = [self addPopupButton:@"Organizaciones" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:200 TFHeight:24  VView:view pullsDown:NO];
	[orgaPopu setTarget:self];
	[orgaPopu setAction:@selector(organizationSelectionPopUp:)];
	// populate  pop up
	
	orgaDictKeys = [orgaDict allKeys];
	for(var i = 0; i < [orgaDictKeys count]; i ++ ){
		var aKey = [orgaDictKeys objectAtIndex:i];
		var objt = [orgaDict objectForKey:aKey];
		[orgaPopu addItemWithTitle:[objt name] ];
	}


	//Location
	vertPosi -= 30;
	labe = [self addTextField:@"Locaciones:" TFPosX:horiPos2 + 130 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	vertPosi += 30;
	locaPopu = [self addPopupButton:@"Locaciones" TFPosX:horiPos2 + 130 TFPosY:vertPosi TFWidth:200 TFHeight:24  VView:view pullsDown:NO];
	[locaPopu setTarget:self];
	[locaPopu setAction:@selector(locationSelectionPopUp:)];
	// populate  pop up
	/*
	locaDictKeys = [locaDict allKeys];	
	for(var j = 0; j < [locaDictKeys count]; j ++ ){
		var aKey = [locaDictKeys objectAtIndex:j];
		var objt = [locaDict objectForKey:aKey];
		[locaPopu addItemWithTitle:[objt name] ];
	}
	*/
	
	//Tables
	
	vertPosi += 30;
	var labe = [self addTextField:@"Empleados:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	
	vertPosi += 20;

	//Pesonnel

	var fram= CGRectMake(horiPos1,vertPosi, 300,200);
	
	fram= CGRectMake(horiPos1,vertPosi, 700,260);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	emplTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[emplTabl setDataSource:self];
	[emplTabl setTarget:self];
	[emplTabl setAction:@selector(emplTableSelection:)];
	[emplTabl setAllowsColumnReordering:YES];
	[emplTabl setUsesAlternatingRowBackgroundColors:YES];
	[emplTabl setAllowsMultipleSelection:YES];
	[emplTabl setDelegate:self];

	var colu= [[CPTableColumn alloc] initWithIdentifier:@"NamePers"];
	[[colu headerView] setStringValue:@"Nombre Completo"];
	[colu setWidth:200];
	[emplTabl addTableColumn:colu];

	colu= [[CPTableColumn alloc] initWithIdentifier:@"EmaiPers"];
	[[colu headerView] setStringValue:@"Email"];
	[colu setWidth:200];
	[emplTabl addTableColumn:colu];
	
	colu= [[CPTableColumn alloc] initWithIdentifier:@"Posicion"];
	[[colu headerView] setStringValue:@"Posición"];
	[colu setWidth:200];
	[emplTabl addTableColumn:colu];
	
	colu= [[CPTableColumn alloc] initWithIdentifier:@"prevDays"];
	[[colu headerView] setStringValue:@"Dias previos"];
	[colu setWidth:150];
	[emplTabl addTableColumn:colu];
	
	
	[scroView setDocumentView:emplTabl];
	
	/*
	//Menu Person table
	
	emplMenu = [[CPMenu alloc] initWithTitle:@"Opciones"];
	var seriCommOpti = [emplMenu insertItemWithTitle:@"Agregar Empleado" 
							    action:@selector(addFromPerson:)
							     keyEquivalent:@""
							     atIndex:0];
	
	[scroView setMenu:emplMenu];
	[[CPArray arrayWithObjects:seriCommOpti] makeObjectsPerformSelector:@selector(setTarget:) withObject:self];
	//end
	*/
	
	[view addSubview:scroView];
	
	
	vertPosi += 280;
	//start date
	labe= [self addTextField:@"Fecha Inicio:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	dateStarText = [self addTextField:[[[CPDate date] description] substringToIndex:10] TFPosX:horiPos2-4 TFPosY:vertPosi-4 TFWidth:85 TFHeight:30 VView:view Editable:YES];
	[self addButton:@"DP" TFPosX:horiPos2 + 90 TFPosY:vertPosi-2 TFWidth:50 TFHeight:24  VView:view sizeToFit:NO Action:@selector(datePickerStartPanel:)];
	
	vertPosi += 40;
	//Days
	labe = [self addTextField:@"Dias previos:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	//vertPosi += 20;
	textDays = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:100 TFHeight:25 VView:view Editable:YES];
    [textDays setLineBreakMode:CPLineBreakByWordWrapping]
    
    vertPosi += 20;
    checkActi = [[CPCheckBox alloc] initWithFrame:CGRectMake(horiPos1,vertPosi,120,25)];
	[checkActi setTitle:"Activar"];
    [checkActi setFont:[CPFont fontWithName:@"Arial" size:12]];
    [checkActi setTextColor:[CPColor whiteColor]];
	[view addSubview:checkActi];
	
	vertPosi += 20;
	checkSendEmpt = [[CPCheckBox alloc] initWithFrame:CGRectMake(horiPos1,vertPosi,280,25)];
	[checkSendEmpt setTitle:"Enviar aunque no tenga trabajos programados"];
    [checkSendEmpt setFont:[CPFont fontWithName:@"Arial" size:12]];
    [checkSendEmpt setTextColor:[CPColor whiteColor]];
	[view addSubview:checkSendEmpt];
	
	vertPosi += 40;
	//Comment Email
	labe = [self addTextField:@"Comentario email:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	vertPosi += 20;
	emaiComm = [self addTextField:@"" TFPosX:horiPos1 TFPosY:vertPosi-4 TFWidth:350 TFHeight:2*vertLineHeig VView:view Editable:YES];
    [emaiComm setLineBreakMode:CPLineBreakByWordWrapping];
    
	//vertPosi += 60;
	//Comment Report
	vertPosi -= 20;
	labe = [self addTextField:@"Comentario Reporte:" TFPosX:horiPos2 + 280 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];
	vertPosi += 20;
	repoComm = [self addTextField:@" " TFPosX:horiPos2 + 280 TFPosY:vertPosi-4 TFWidth:350 TFHeight:2*vertLineHeig VView:view Editable:YES];
    [repoComm setLineBreakMode:CPLineBreakByWordWrapping];
    
    vertPosi += 70;
    [self addButton:@"Guardar" TFPosX:horiPos4 TFPosY:vertPosi-2 TFWidth:75 TFHeight:24  VView:view sizeToFit:NO Action:@selector(updateChangesAutomaticReport:)];
    [self addButton:@"Recargar" TFPosX:(horiPos4 + 80) TFPosY:vertPosi-2 TFWidth:75 TFHeight:24  VView:view sizeToFit:NO Action:@selector(reloadEmployeeTable:)];
//    [self addButton:@"Eliminar" TFPosX:horiPos1  + 150 TFPosY:vertPosi-2 TFWidth:65 TFHeight:24  VView:view sizeToFit:NO Action:@selector(deleteChangesAutomaticReport:)];
	
	}
	

}


-(void) cleanFields {

	[textDays setStringValue: "" ];
	[emaiComm setStringValue: "" ];
	[repoComm setStringValue: "" ];
	[checkActi setStringValue:"0"];
	[checkSendEmpt setStringValue:"0"];
}

- (void) organizationSelectionPopUp:(id)sender {
	
	var inde = [orgaPopu indexOfSelectedItem];
	[self cleanFields];
	
	if ( inde < 0 ){
		return;
	}
		
	[locaCustDict removeAllObjects];
	[locaPopu removeAllItems];
	[locaPopu addItemWithTitle:@"Locaciones"];
	
	[emplCustContDict removeAllObjects];
		
	if(inde == 0){
		
	}else{
	
		inde --;
		var aKey1 = [orgaDictKeys objectAtIndex:inde];
		var objt1 = [orgaDict objectForKey:aKey1];
		
		locaDictKeys = [locaDict allKeys];
		for(var i = 0; i < [locaDictKeys count]; i ++){
			var aKey2 = [locaDictKeys objectAtIndex:i];
			var objt2 = [locaDict objectForKey:aKey2];
			if ([objt2 idenOrga] == [objt1 idenOrga] ){
				[locaPopu addItemWithTitle:[objt2 name] ];
				[locaCustDict setObject:objt2  forKey:"" + [objt2 idenLoca] + ""];
			}
		}
			
	}
	
	if ([locaCustDict count] > 0){
		[locaPopu selectItemAtIndex:1 ];
	}
	
	[self locationSelectionPopUp:sender];
	
	[emplTabl reloadData];
}



- (void) locationSelectionPopUp:(id)sender {

	var inde = [locaPopu indexOfSelectedItem];
	[self cleanFields];
	if ( inde < 0 ){
		return;
	}
		
	[emplCustContDict removeAllObjects];
	
	if(inde == 0){
			
	}else{	
		inde --;
		locaCustDictKeys = [locaCustDict allKeys];
		var aKey2 = [locaCustDictKeys objectAtIndex:inde];
		var objt2 = [locaCustDict objectForKey:aKey2];
		//console.log("\n cont0 = " + [objt2 cont0] + " name = " + [objt2 name]);
		
		/*
		console.log("cont 0 " + [objt2 cont0]);
			console.log("cont 1 " + [objt2 cont1]);
			console.log("cont 2 " + [objt2 cont2]);
			console.log("cont 3 " + [objt2 cont3]);
			
			console.log("contCor 0 " + [objt2 contCor0]);
			console.log("contCor 1 " + [objt2 contCor1]);
			console.log("contCor 2 " + [objt2 contCor2]);
			console.log("contCor 3 " + [objt2 contCor3]);
		*/
		///*
		for ( var j = 0; j <  [emplDictKeys count]; j ++ ){
			var aKey3 = [emplDictKeys objectAtIndex:j];
			var objt3 = [emplDict objectForKey:aKey3];
			//console.log("iden pers = " + [objt3 idenPers]);
			switch ( [objt3 idenPers] ){

				case [objt2 cont0]:
					[emplCustContDict setObject:objt3 forKey:""+ [objt3 idenPers] +""];
					break;
				case [objt2 cont1]:
					[emplCustContDict setObject:objt3 forKey:""+ [objt3 idenPers] +""];
					break;
				case [objt2 cont2]:
					[emplCustContDict setObject:objt3 forKey:""+ [objt3 idenPers] +""];
					break;
				case [objt2 cont3]:
					[emplCustContDict setObject:objt3 forKey:""+ [objt3 idenPers] +""];
					break;					
				default:
				break;		
			}
		}
		//*/
		
		
		for (var k = 0; k <  [emplDictKeys count]; k ++){
			var aKey3 = [emplDictKeys objectAtIndex:k];
			var objt3 = [emplDict objectForKey:aKey3];
			//console.log("iden pers = " + [objt3 idenPers]);
			switch ( [objt3 idenPers] ){
								
				case [objt2 contCor0]:
					[emplCustContDict setObject:objt3 forKey:""+ [objt3 idenPers] +""];
					break;
				case [objt2 contCor1]:
					[emplCustContDict setObject:objt3 forKey:""+ [objt3 idenPers] +""];
					break;
				case [objt2 contCor2]:
					[emplCustContDict setObject:objt3 forKey:""+ [objt3 idenPers] +""];
					break;
				case [objt2 contCor3]:
					[emplCustContDict setObject:objt3 forKey:""+ [objt3 idenPers] +""];
					break;				
				default:
				break;		
			}
		}
			
			
	
			
			//console.log("\nid pers = " + [objt3 idenPers] + " cont0 = " + [objt3 nameFirst] );
			/*if ( ( [objt3 idenPers] == [objt2 cont0] )  ) {
				[emplCustContDict setObject:objt3 forKey:""+ [objt3 idenPers] +""];
				//break;
			}*/
		
	}
	//WHERE " + dataBase + ".persons.id = " + dataBase + ".organizationLocations.Contact0Id AND " + dataBase + ".organizationLocations.OrganizationId ='" + idenOrga + "';
	[emplTabl reloadData];
	
}




- (void) reloadEmployeeTable:(id)sender {
	
	
	//Employees
	[emplDict removeAllObjects];
	[mode emptyEmplAutoRepoDict];
	[mode loadPersonsDictionary];
	emplDict     = [mode persDict];
	emplDictKeys = [emplDict allKeys];
	[emplCustContDict removeAllObjects];
		
	//Organizations
	[orgaDict removeAllObjects];
	[mode emptyOrganizationsDictionary];
	[mode loadOrganizationsDictionary];
	orgaDict     = [mode orgaDict];
	orgaDictKeys = [orgaDict allKeys];
	
	//Locations
	[locaDict removeAllObjects];
	[mode emptyLocationsDictionary];
	[mode loadLocationsDictionary];
	locaDict     = [mode locaDict];
	locaDictKeys = [locaDict allKeys];
		
	//AutomaticLocation
	[locaAutoRepoDict removeAllObjects];
	[mode emptyLocaAutoRepoDict];
	[mode loadLocationsAutomaticReport];
	locaAutoRepoDict = [mode locaAutoRepoDict];		 
	locaAutoRepoDictKeys = [locaAutoRepoDict allKeys];
	
	[locaPopu selectItemAtIndex:0 ];
	[orgaPopu selectItemAtIndex:0 ];
	
	[emplTabl reloadData]
}


- (void) updateChangesAutomaticReport:(id)sender {
	
	var inde = [emplTabl selectedRow];
	if ( inde < 0 ){
		[glblAlerPane showWithMessage:@"Atencion" info:"Seleccione un contacto para realizar la actualización"];
		return;
	}
	
	if ([textDays stringValue] > 10 ){	
		[glblAlerPane showWithMessage:@"Atencion" info:"El numero maximo es de 10 dias"];
		return;
	}
	if ([textDays stringValue] < 0 ){	
		[glblAlerPane showWithMessage:@"Atencion" info:"El numero de dias debe ser mayor a 0"];
		return;
	}
	

	var aKey = [emplCustContDictKeys objectAtIndex:inde];
	var objt = [emplCustContDict objectForKey:aKey];
	
	
	
	var indeLocaPop = [locaPopu indexOfSelectedItem];
	if ( indeLocaPop < 0 ){
		return;
	}
	indeLocaPop --;
	locaCustDictKeys = [locaCustDict allKeys];
	var locaKey = [locaCustDictKeys objectAtIndex:indeLocaPop];
	var locaObjt = [locaCustDict objectForKey:locaKey];
	//console.log("ideLoca =  " + [locaObjt idenLoca] + "name =  " + [locaObjt name] );
	

	var locaAutoRepoObjt = [locaAutoRepoDict objectForKey:"" + [locaObjt idenLoca] + ""];
		
		
	
	[locaAutoRepoObjt initDate: [ [dateStarText stringValue] substringToIndex:10] ];
	[locaAutoRepoObjt daysPrev:[textDays stringValue] ];
	//var striPara = [CPString stringWithFormat:@"nameFirst=%@:sc:nameLast=%@:sc:role=%@:sc:id=%@",[objt nameFirst],[objt nameLast],[objt role],[objt idenPers]];
	//var striPara = "";
	//[locaAutoRepoObjt contPara:striPara];
	
	var  arraEmai = [[CPArray alloc] init];
	
	var tempObjt = [emplCustContDict objectForKey:[locaObjt cont0] ];
	
	if (tempObjt) {
		[arraEmai addObject:@"" +  [ tempObjt emai ] ];	
	}
	
	tempObjt = [emplCustContDict objectForKey:[locaObjt cont1] ];	
	if (tempObjt) {
		[arraEmai addObject:@"" +  [ tempObjt emai ] ];	
	}
	
	tempObjt = [emplCustContDict objectForKey:[locaObjt cont2] ];	
	if (tempObjt) {
		[arraEmai addObject:@"" +  [ tempObjt emai ] ];	
	}
	
	tempObjt = [emplCustContDict objectForKey:[locaObjt cont3] ];	
	if (tempObjt) {
		[arraEmai addObject:@"" +  [ tempObjt emai ] ];	
	}
	 
	 
	 
	 tempObjt = [emplCustContDict objectForKey:[locaObjt contCor0] ];	
	if (tempObjt) {
		[arraEmai addObject:@"" +  [ tempObjt emai ] ];	
	}
	
	tempObjt = [emplCustContDict objectForKey:[locaObjt contCor1] ];	
	if (tempObjt) {
		[arraEmai addObject:@"" +  [ tempObjt emai ] ];	
	}
	
	tempObjt = [emplCustContDict objectForKey:[locaObjt contCor2] ];	
	if (tempObjt) {
		[arraEmai addObject:@"" +  [ tempObjt emai ] ];	
	}
	
	tempObjt = [emplCustContDict objectForKey:[locaObjt contCor3] ];	
	if (tempObjt) {
		[arraEmai addObject:@"" +  [ tempObjt emai ] ];	
	}
	 
	 var striEmai = "";
	for(var kk = 0; kk < [arraEmai count]; kk ++ ){
		var aux = kk + 1;
		if (aux ==  [arraEmai count] ){
			striEmai += arraEmai[kk];
		}else{
			striEmai +=  arraEmai[kk] + ":sc:" ;
		}
		
	}
	//console.log("  " + striEmai );
	
	[locaAutoRepoObjt emaiList:striEmai ];
	if ([checkActi state] == 1) {
		[locaAutoRepoObjt acti:"1"];
	}else{
		[locaAutoRepoObjt acti:"0"];
	}
	if ([checkSendEmpt state] == 1) {
		[locaAutoRepoObjt sendEmpt:"1"];
	}else{
		[locaAutoRepoObjt sendEmpt:"0"];
	}
	
	[locaAutoRepoObjt comm1: [repoComm stringValue] ];
	[locaAutoRepoObjt comm2: [emaiComm stringValue] ];
		
	var quer = "";
	if  ( (prevValuCheckActi == "0") && ([locaAutoRepoObjt acti] == "1") ){	
	quer = [CPString stringWithFormat:
	@"UPDATE %@.automaticReportDefinitions SET initialDate = '%@', prevDays = '%@', emailList = '%@', active = %@ , sendEmpty = %@,comment1 = '%@', comment2 = '%@', nextGeneDate = curdate() + interval 20 hour + interval 30 minute WHERE identifier = '%@'",
	                         	dataBase,[locaAutoRepoObjt initDate],[locaAutoRepoObjt daysPrev], [locaAutoRepoObjt emaiList],
	                         	[locaAutoRepoObjt acti],[locaAutoRepoObjt sendEmpt],[locaAutoRepoObjt comm1],[locaAutoRepoObjt comm2],[locaAutoRepoObjt idenLoca] ];
	}else{
		quer = [CPString stringWithFormat:
	@"UPDATE %@.automaticReportDefinitions SET initialDate = '%@', prevDays = '%@', emailList = '%@', active = %@ , sendEmpty = %@,comment1 = '%@', comment2 = '%@' WHERE identifier = '%@'",
	                         	dataBase,[locaAutoRepoObjt initDate],[locaAutoRepoObjt daysPrev], [locaAutoRepoObjt emaiList],
	                         	[locaAutoRepoObjt acti],[locaAutoRepoObjt sendEmpt],[locaAutoRepoObjt comm1],[locaAutoRepoObjt comm2],[locaAutoRepoObjt idenLoca] ];
	}
     //console.log(quer);
	 [self query:quer];
	 [emplDict setObject:objt forKey:aKey];
	 [emplTabl reloadData];

}


//- (void) deleteChangesAutomaticReport:(id)sender {}




- (void) emplTableSelection:(id)sender {

	var inde = [emplTabl selectedRow];
	if ( inde < 0 ){
		return;
	}
	
	var aKey = [emplDictKeys objectAtIndex:inde];
	var objt = [emplDict objectForKey:aKey];
	
	var indeLocaPop = [locaPopu indexOfSelectedItem];
	if ( indeLocaPop < 0 ){
		return;
	}
	indeLocaPop --;
	locaCustDictKeys = [locaCustDict allKeys];
	var locaKey = [locaCustDictKeys objectAtIndex:indeLocaPop];
	var locaObjt = [locaCustDict objectForKey:locaKey];
	//console.log("ideLoca =  " + [locaObjt idenLoca] + "name =  " + [locaObjt name] );
	

	var locaAutoRepoObjt = [locaAutoRepoDict objectForKey:"" + [locaObjt idenLoca] + ""];
	//var locaAutoRepoObjt = [locaAutoRepoDict objectForKey:"3268"];
	//console.log("ideRepoLoca =  " + [locaAutoRepoObjt idenLoca] + " init =  " + [locaAutoRepoObjt initDate] );
	//locaAutoRepoDictKeys = [locaAutoDict allKeys];
	
	[textDays setStringValue: [locaAutoRepoObjt daysPrev]];
//	var a =  [locaAutoRepoObjt initDate];
	[dateStarText setStringValue: [locaAutoRepoObjt initDate]];
	var tempStri = [[dateStarText stringValue] substringToIndex:10];
	[dateStarText setStringValue: tempStri];
//	[[dateStarText stringValue] substringToIndex:10];
	if ([locaAutoRepoObjt acti] == 1) {
		[checkActi setStringValue:"1"];
		prevValuCheckActi = "1";
	}else{
		[checkActi setStringValue:"0"];
		prevValuCheckActi = "0";
	}
	
	if ([locaAutoRepoObjt sendEmpt] == 1) {
		[checkSendEmpt setStringValue:"1"];
	}else{
		[checkSendEmpt setStringValue:"0"];
	}
	 
	
	[repoComm setStringValue: [locaAutoRepoObjt comm1]];
	[emaiComm setStringValue: [locaAutoRepoObjt comm2]];
	
}


//		TABLE SOURCE DELEGATE METHODS

- (int) numberOfRowsInTableView:(CPTableView)tablView {
	var coun= 0;
	var quer;
	
	if ( tablView == emplTabl ) {
		coun = [emplCustContDict count];
	}
	

	return coun;
}


- (id) tableView:(CPTableView)tablView objectValueForTableColumn:(CPTableColumn)tablColu row:(int)rowInde {

	var headStri= [[tablColu headerView] stringValue];
	var headIden= [tablColu identifier];
	var valu = @"N/A";
	emplCustContDictKeys = [emplCustContDict allKeys];


	if ( tablView == emplTabl ) {
		var aKey = [emplCustContDictKeys objectAtIndex:rowInde];
		var objt = [emplCustContDict objectForKey:aKey];
		if ( [headIden isEqualToString:@"NamePers"] ){
			valu = [objt nameLast] + " " + [objt nameFirst];
		}else if ( [headIden isEqualToString:@"EmaiPers"] ){
			valu = [objt emai] ;	
		}else if ( [headIden isEqualToString:@"Posicion"] ){
			valu = [objt role] ;
		}else if ( [headIden isEqualToString:@"prevDays"] ){
			valu = [self returnPreviousDaysPerson:[objt idenPers]];
	  }
	}
		
	return valu;
}



-(id) returnPreviousDaysPerson:(id) iden {

  var valuPrevDays = "N/A";
	locaCustDictKeys = [locaCustDict allKeys];
		for (var i = 0; i < [locaCustDictKeys count]; i ++ ){
			var aKey2 = [locaCustDictKeys objectAtIndex:  i  ];
			var objt2 = [locaCustDict objectForKey:aKey2];
			/*
			console.log("iden Pers = " + iden );
			console.log("idenLoca " + [objt2 idenLoca]);
			console.log("cont 0 " + [objt2 cont0]);
			console.log("cont 1 " + [objt2 cont1]);
			console.log("cont 2 " + [objt2 cont2]);
			console.log("cont 3 " + [objt2 cont3]);
			
			console.log("contCor 0 " + [objt2 contCor0]);
			console.log("contCor 1 " + [objt2 contCor1]);
			console.log("contCor 2 " + [objt2 contCor2]);
			console.log("contCor 3 " + [objt2 contCor3]);
			*/
			switch ( iden ){
				
				case [objt2 cont0]:
				    //console.log("idenLoca " + [objt2 idenLoca]);
					var objtSele = [locaAutoRepoDict objectForKey:""+ [objt2 idenLoca]  +""];
					valuPrevDays = [objtSele daysPrev];
					//console.log("cont 0");
					i = [locaCustDictKeys count];
					break;
				case [objt2 cont1]:
					var objtSele = [locaAutoRepoDict objectForKey:""+ [objt2 idenLoca]  +""];
					valuPrevDays = [objtSele daysPrev];
					//console.log("cont 1");
					i = [locaCustDictKeys count];
					break;
				case [objt2 cont2]:
					var objtSele = [locaAutoRepoDict objectForKey:""+ [objt2 idenLoca]  +""];
					valuPrevDays = [objtSele daysPrev];
					//console.log("cont 2");
					i = [locaCustDictKeys count];
					break;
				case [objt2 cont3]:
					var objtSele = [locaAutoRepoDict objectForKey:""+ [objt2 idenLoca]  +""];
					valuPrevDays = [objtSele daysPrev];
					//console.log("cont 3");
					i = [locaCustDictKeys count];
					break;	
					case [objt2 contCor0]:
					var objtSele = [locaAutoRepoDict objectForKey:""+ [objt2 idenLoca]  +""];
					valuPrevDays = [objtSele daysPrev];
					//console.log("cont 4");
					i = [locaCustDictKeys count];
					break;
				case [objt2 contCor1]:
					var objtSele = [locaAutoRepoDict objectForKey:""+ [objt2 idenLoca]  +""];
					valuPrevDays = [objtSele daysPrev];
					//console.log("cont 5");
					i = [locaCustDictKeys count];
					break;
				case [objt2 contCor2]:
					var objtSele = [locaAutoRepoDict objectForKey:""+ [objt2 idenLoca]  +""];
					valuPrevDays = [objtSele daysPrev];
					//console.log("cont 6");
					i = [locaCustDictKeys count];
					break;
				case [objt2 contCor3]:
					var objtSele = [locaAutoRepoDict objectForKey:""+ [objt2 idenLoca]  +""];
					valuPrevDays = [objtSele daysPrev];
					//console.log("cont 7");
					i = [locaCustDictKeys count];
					break;
								
				default:
				break;		
			}
			
		}
		return valuPrevDays;
}







@end
