// RMSchedulerAssetsController.j
// RMSchedulerAssetsController
// Created by Anthony Picado Ávila

@import <Foundation/Foundation.j>
@import <AppKit/AppKit.j>
@import <MapKit/MKMapView.j>
@import <AppKit/CPTextField.j>
@import <AppKit/CPApplication.j>
@import <Foundation/CPURLRequest.j>
@import "AppController.j"

var pACont;



@implementation RMSchedulerResourcesController : RMControllerObject {

	CPArray actiArra;
	CPTextField actiDescText;
	CPTextField actiDuraText;
	CPTextField actiPricText;
	CPTableView actiTabl;
     
	CPPanel resoPane;

    CPArray emplArra;
	CPTableView emplTabl;
	CPTextField emplNameLastText, emplNameFirsText, emplPosiText;
	CPTextField emplPhon1Text,emplPhon2Text,emplEmaiText,emplAddrStreText,emplAddrCityText,emplAddrStatText, emplNoteText;
	CPTextField emplHourStarMondText,emplHourStarTuesText,emplHourStarWednText,emplHourStarThurText,emplHourStarFridText,emplHourStarSatruText,emplHourStarSundText;
	CPTextField emplHourFiniMondText,emplHourFiniTuesText,emplHourFiniWednText,emplHourFiniThurText,emplHourFiniFridText,emplHourFiniSatruText,emplHourFiniSundText;
	
    id emplActiChec,equiActiChec;
    id prevValuEmplActiChec;
    id emplActiSundChec,emplActiMondChec,emplActiTuesChec,emplActiWednChec,emplActiThurChec,emplActiFridChec,emplActiSatuChec;

	CPArray emplEquiArra;
	CPTextField emplEquiIdenText;
	CPPopUpButton emplEquiPopu;
	CPTableView emplEquiTabl;

	CPArray emplTraiArra;
	//CPTextField emplTraiOrgaText;
	CPTextField emplTraiAbbrText;
	CPTextField emplTraiDateLastText;
	CPTableView emplTraiTabl;

	CPArray emplVacaArra;
	CPTextField emplVacaStarText, emplVacaFiniText;
	id emplVacaStarButt, emplVacaFiniButt;
	CPTableView emplVacaTabl;

    CPArray equiArra;
	CPTableView equiTabl;
	CPTextField equiIden0Text,equiIden1Text,equiIden2Text,equiLawIdenText,equiMakeText,equiModeText,equiYearText;
	CPTextField equiTypeText,equiRestText,equiPassCounText;
	CPTextField equiNoteText;

	CPArray holiArra;
	CPTextField holiDateStarText;
	CPTextField holiDateFiniText;
	CPTextField holiDescText;
	CPTableView holiTabl;
     
	CPPopUpButton orgaPopu;
	CPPopUpButton orgaTraiAbbrPopu;
	CPArray orgaArra;
    CPTextField orgaTraiDescText;
    CPTextField orgaTraiDateLastText;
    CPTextField orgaTraiDateExpiText;
    
    id chanStat;
}



- (void)  applicationQuit {
	if ( resoPane ) {
		[resoPane orderOut:0];
		[resoPane release];
	}
}



- (id) init:(id)paraAppCont {
	[super init];
	
	chanStat = 0;
	ip = [CPString stringWithFormat:@"167.250.194.153"];
	resoPane = NULL;
	//routRefrFunc = setInterval(refreshFunction,30000);
	//add 2017-03-03
	appCont = paraAppCont;
	dataBase = [appCont getDataBase];
	prevValuEmplActiChec = "0";
	//alert("db init resources= " + [appCont getDataBase]);
	
	return self;
}



// Activities

- (void) activitiesClearFields:(id)sender {
	[actiDescText setStringValue:@""];
	[actiDuraText setStringValue:@""];
	[actiPricText setStringValue:@""];
}



- (void) activitiesDelete:(id)sender {
	var inde = [actiTabl selectedRow];
	if ( inde < 0 )
		return;
	var iden = [[actiArra[inde] valueList] objectAtIndex:0];
	var desc = [[actiArra[inde] valueList] objectAtIndex:1];

	var conf = confirm("Quiere eliminar la actividad *"+desc+"* con codigo *"+iden+"* ?");
	if ( ! conf )
		return;

	var quer = [CPString stringWithFormat:@"delete from %@.organizationActivities where id=%@",dataBase,iden];
	[self query:quer];

	[actiTabl reloadData];
}



- (void) activitiesInsert:(id)sender {
	var actiDesc = [actiDescText  stringValue];
	var actiDura = [actiDuraText  stringValue];
	var actiPric = [actiPricText  stringValue];

	var quer = [CPString stringWithFormat:@"insert into %@.organizationActivities (description,duration,price,active) values ('%@',%@,%@,1)",
		dataBase,actiDesc,actiDura,actiPric];

	[self query:quer];

	[actiTabl reloadData];
}



- (void) activitiesTableSelection:(id)sender {
	var inde = [actiTabl selectedRow];
	if ( inde < 0 )
		return;

	var valuList = [actiArra[inde] valueList];
	var actiDesc = valuList[1];
	var actiDura = valuList[2];
	var actiPric = valuList[3];
	var actiActi = valuList[4];
	
	[actiDescText setStringValue:actiDesc];
	[actiDuraText setStringValue:actiDura];
	[actiPricText setStringValue:actiPric];
	[actiActiChec setState:actiActi];
}



- (void) activitiesUpdate:(id)sender {
	var inde = [actiTabl selectedRow];
	if ( inde < 0 )
		return;
	var valuList = [actiArra[inde] valueList];
	var iden = valuList[0];

	var actiDesc = [actiDescText  stringValue];
	var actiDura = [actiDuraText  stringValue];
	var actiPric = [actiPricText  stringValue];
	var actiActi = [actiActiChec  stringValue];

	var quer = [CPString stringWithFormat:@"update %@.organizationActivities set description='%@',duration=%@,price=%@,active=%@ where id=%@",
		dataBase,actiDesc,actiDura,actiPric,actiActi,iden];

	[self query:quer];

	[actiTabl reloadData];
}



- (void) datePickerDateChange:(id)sender {
	[emplVacaText setStringValue:[[[sender dateValue] description] substringToIndex:10]];
}



- (void) datePickerPanel:(id)sender {

	var fram = CGRectMake(350,200,144,148);
	var datePickPane = [[CPPanel alloc] initWithContentRect:fram styleMask:CPHUDBackgroundWindowMask|CPClosableWindowMask]; 
	[datePickPane setFloatingPanel:YES];
	[datePickPane setTitle:@"DatePicker"];
	[datePickPane orderFront:self];

	var paneContView = [datePickPane contentView];

	fram = CGRectMake(0,0,144,148);
	var datePick = [[CPDatePicker alloc] initWithFrame:fram];
	[datePick setBackgroundColor:[CPColor whiteColor]];
	[datePick setTimeZone:[CPTimeZone defaultTimeZone]];
	[datePick setDatePickerElements:128];
	var dpe = [datePick datePickerElements];
	[datePick setDatePickerStyle:1];
	var dps = [datePick datePickerStyle];
	[datePick setDateValue:[CPDate date]];
	[datePick setObjectValue:[CPDate date]];
	[datePick setTarget:self];
	[datePick setAction:@selector(datePickerDateChange:)];
	
	if ( sender == emplVacaStarButt )
		emplVacaText = emplVacaStarText;
	else
		emplVacaText = emplVacaFiniText;
	
	[paneContView addSubview:datePick];
}



- (CPPanel) resourcesPanel {
	return resoPane;
}



- (void)  resourcesPanel:(id)sender {

	var horiPos1 = 10;
	var horiPos2 = horiPos1 + 100;
	var horiPos3 = 390;
	var horiPos4 = horiPos3 + 100;

	var horiTextWidt = 200;
	var horiPosiOffs = -4;
	var horiPosi = 200;

	var vertPosi = 20;
	var vertOffs = -4;
	var vertIncr = 26;
	var vertLineHeig = 30;

	var paneWidt = 1250;
	var paneHeig = 680;
	var tablWidt = paneWidt - 20;
	var tablHeig = 150;
    xStart = 60;
	
	var x = 20 + Math.random()*40;
	var y = 60 + Math.random()*40;

	resoPane = [[CPPanel alloc] initWithContentRect:CGRectMake(x,y, paneWidt,paneHeig) styleMask:CPHUDBackgroundWindowMask|CPClosableWindowMask|CPResizableWindowMask]; 
	[resoPane setFloatingPanel:YES]; 
	[resoPane orderFront:self];
	[resoPane setTitle:@"Panel Recursos"];
	

	var paneContView = [resoPane contentView];  //obteniendo el content view 1 first step
	[tabView setBackgroundColor:coloDefaBrig];
	[tabView setAutoresizingMask:CPViewWidthSizable|CPViewHeightSizable|CPViewMinXMargin];
	[paneContView setBackgroundColor:coloDefaLite];
	[self addBanners:paneContView heightBlue:2. heightOrange:5.];

	var tabView = [[CPTabView alloc] initWithFrame:CGRectMake(5,10,paneWidt-10,paneHeig-10)]; // opciones
	[tabView setDelegate:self];

	[paneContView addSubview:tabView];	// agregar al panel 
	var labe;
	var tabViewItem;
	var view;


	// Employees *************************************************

	tabViewItem = [[CPTabViewItem alloc] initWithIdentifier:@"personnel"];
	[tabViewItem setLabel:@"  Personal  "];
				
	view = [[CPView alloc] initWithFrame: CGRectMake(50,50, 50,50)]; // donde se pone los controles --> cp view
	[view setBackgroundColor:coloDefaBrig];

	vertPosi = 20;

	var fram= CGRectMake(horiPos2,vertPosi, 1100,tablHeig);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	emplTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[emplTabl setDataSource:self];
	[emplTabl setTarget:self];
	[emplTabl setAction:@selector(employeeTableSelection:)];
	[emplTabl setAllowsColumnReordering:YES];
	[emplTabl setUsesAlternatingRowBackgroundColors:YES];
	[emplTabl setAllowsMultipleSelection:YES];
	[emplTabl setDelegate:self];

	var colu = [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:50];
	[emplTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Cedula"];
	[[colu headerView] setStringValue:@"Cedula"];
	[colu setWidth:100];
	[emplTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Apellidos"];
	[[colu headerView] setStringValue:@"Apellidos"];
	[colu setWidth:140];
	[emplTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Nombre"];
	[[colu headerView] setStringValue:@"Nombre"];
	[colu setWidth:120];
	[emplTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Posicion"];
	[[colu headerView] setStringValue:@"Posicion"];
	[colu setWidth:50];
	[emplTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Telefono1"];
	[[colu headerView] setStringValue:@"Telefono1"];
	[colu setWidth:100];
	[emplTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Telefono2"];
	[[colu headerView] setStringValue:@"Telefono2"];
	[colu setWidth:100];
	[emplTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Correo"];
	[[colu headerView] setStringValue:@"Correo"];
	[colu setWidth:150];
	[emplTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Comentarios"];
	[[colu headerView] setStringValue:@"Comentarios"];
	[colu setWidth:200];
	[emplTabl addTableColumn:colu];

	[scroView setDocumentView:emplTabl];

	[view addSubview:scroView];


    vertPosi += tablHeig + 10;
    var vertPosiHere = vertPosi;

    labe = [self addTextField:@"Cédula :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplLawIdenText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];
    
    vertPosi += vertIncr;

	labe = [self addTextField:@"Apellidos :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplNameLastText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:200 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

	labe = [self addTextField:@"Nombre :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplNameFirsText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:200 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

	labe = [self addTextField:@"Posicion :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplPosiText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:200 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

    labe = [self addTextField:@"Dirección :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplAddrStreText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:200 TFHeight:2*vertLineHeig VView:view Editable:YES];
    [emplAddrStreText setLineBreakMode:CPLineBreakByWordWrapping];

    vertPosi += 2*vertLineHeig;

    labe = [self addTextField:@"Ciudad :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplAddrCityText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:160 TFHeight:vertLineHeig VView:view Editable:YES];
    
    vertPosi += vertIncr;

    labe = [self addTextField:@"Estado :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplAddrStatText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:160 TFHeight:vertLineHeig VView:view Editable:YES];
    
    vertPosi += vertIncr;

    labe = [self addTextField:@"Tel. Trabajo :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplPhon1Text = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];
    
    vertPosi += vertIncr;

    labe = [self addTextField:@"Tel. Personal :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplPhon2Text = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];
    
    vertPosi += vertIncr;

    labe = [self addTextField:@"Correo :" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplEmaiText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:300 TFHeight:vertLineHeig VView:view Editable:YES];
    
    vertPosi += vertIncr;

    labe = [self addTextField:@"Comentarios:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplNoteText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:300 TFHeight:2*vertLineHeig VView:view Editable:YES];


    vertPosi += 2.5*vertIncr;

    labe = [self addTextField:@"Activo:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
    [labe setTextColor:[CPColor whiteColor]];

    emplActiChec = [CPCheckBox checkBoxWithTitle:@"Seleccione para activar/desactivar el empleado"];
    [emplActiChec setTextColor:[CPColor whiteColor]];
    [emplActiChec setFrameOrigin:CPPointMake(horiPos2, vertPosi)];
    [emplActiChec setTarget:self];
    [emplActiChec setEnabled:YES];
    //[checDeshClie setAction:@selector(stateCheck4:)];
    [view addSubview:emplActiChec];

    vertPosi += 30;
    var vertButt = vertPosi;

    butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2,vertPosi, 75,24)];
	[butt setTitle:"Ingresar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeInsert:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+75,vertPosi, 75,24)];
	[butt setTitle:"Actualizar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeUpdate:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+150,vertPosi, 75,24)];
	[butt setTitle:"Eliminar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeDelete:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+225,vertPosi, 75,24)];
	[butt setTitle:"Limpiar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeClearFields:)];                
	[view addSubview:butt];


	// Working hours

	vertPosi = vertPosiHere;

	var checPos1 = 350;
	var checPos2 = checPos1 + 80;
	var hourWidt = 60;
	var checPos3 = checPos2 + hourWidt;

    labe = [self addTextField:@"Días laborales:" TFPosX:checPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
    [labe setTextColor:[CPColor whiteColor]];

    vertPosi += vertIncr;

    emplActiSundChec = [CPCheckBox checkBoxWithTitle:@"Domingo"];
    [emplActiSundChec setTextColor:[CPColor whiteColor]];
    [emplActiSundChec setFrameOrigin:CPPointMake(checPos1, vertPosi)];
    [emplActiSundChec setTarget:self];
    [emplActiSundChec setAction:@selector(employeeActiveDay:)];
    [emplActiSundChec setEnabled:YES];
    [view addSubview:emplActiSundChec];

    emplHourStarSundText = [self addTextField:@"" TFPosX:checPos2 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];
    emplHourFiniSundText = [self addTextField:@"" TFPosX:checPos3 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

    emplActiMondChec = [CPCheckBox checkBoxWithTitle:@"Lunes"];
    [emplActiMondChec setTextColor:[CPColor whiteColor]];
    [emplActiMondChec setFrameOrigin:CPPointMake(checPos1, vertPosi)];
    [emplActiMondChec setTarget:self];
    [emplActiMondChec setAction:@selector(employeeActiveDay:)];
    [emplActiMondChec setEnabled:YES];
    [view addSubview:emplActiMondChec];

    emplHourStarMondText = [self addTextField:@"" TFPosX:checPos2 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];
    emplHourFiniMondText = [self addTextField:@"" TFPosX:checPos3 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

    emplActiTuesChec = [CPCheckBox checkBoxWithTitle:@"Martes"];
    [emplActiTuesChec setTextColor:[CPColor whiteColor]];
    [emplActiTuesChec setFrameOrigin:CPPointMake(checPos1, vertPosi)];
    [emplActiTuesChec setTarget:self];
    [emplActiTuesChec setAction:@selector(employeeActiveDay:)];
    [emplActiTuesChec setEnabled:YES];
    [view addSubview:emplActiTuesChec];

    emplHourStarTuesText = [self addTextField:@"" TFPosX:checPos2 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];
    emplHourFiniTuesText = [self addTextField:@"" TFPosX:checPos3 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

    emplActiWednChec = [CPCheckBox checkBoxWithTitle:@"Miercoles"];
    [emplActiWednChec setTextColor:[CPColor whiteColor]];
    [emplActiWednChec setFrameOrigin:CPPointMake(checPos1, vertPosi)];
    [emplActiWednChec setTarget:self];
    [emplActiWednChec setAction:@selector(employeeActiveDay:)];
    [emplActiWednChec setEnabled:YES];
    [view addSubview:emplActiWednChec];

    emplHourStarWednText = [self addTextField:@"" TFPosX:checPos2 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];
    emplHourFiniWednText = [self addTextField:@"" TFPosX:checPos3 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

    emplActiThurChec = [CPCheckBox checkBoxWithTitle:@"Jueves"];
    [emplActiThurChec setTextColor:[CPColor whiteColor]];
    [emplActiThurChec setFrameOrigin:CPPointMake(checPos1, vertPosi)];
    [emplActiThurChec setTarget:self];
    [emplActiThurChec setAction:@selector(employeeActiveDay:)];
    [emplActiThurChec setEnabled:YES];
    [view addSubview:emplActiThurChec];

    emplHourStarThurText = [self addTextField:@"" TFPosX:checPos2 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];
    emplHourFiniThurText = [self addTextField:@"" TFPosX:checPos3 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

    emplActiFridChec = [CPCheckBox checkBoxWithTitle:@"Viernes"];
    [emplActiFridChec setTextColor:[CPColor whiteColor]];
    [emplActiFridChec setFrameOrigin:CPPointMake(checPos1, vertPosi)];
    [emplActiFridChec setTarget:self];
    [emplActiFridChec setAction:@selector(employeeActiveDay:)];
    [emplActiFridChec setEnabled:YES];
    [view addSubview:emplActiFridChec];

    emplHourStarFridText = [self addTextField:@"" TFPosX:checPos2 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];
    emplHourFiniFridText = [self addTextField:@"" TFPosX:checPos3 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

    emplActiSatuChec = [CPCheckBox checkBoxWithTitle:@"Sabado"];
    [emplActiSatuChec setTextColor:[CPColor whiteColor]];
    [emplActiSatuChec setFrameOrigin:CPPointMake(checPos1, vertPosi)];
    [emplActiSatuChec setTarget:self];
    [emplActiSatuChec setAction:@selector(employeeActiveDay:)];
    [emplActiSatuChec setEnabled:YES];
    [view addSubview:emplActiSatuChec];

    emplHourStarSatuText = [self addTextField:@"" TFPosX:checPos2 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];
    emplHourFiniSatuText = [self addTextField:@"" TFPosX:checPos3 TFPosY:vertPosi TFWidth:hourWidt TFHeight:vertLineHeig VView:view Editable:YES];


	// Employee Vacations

    vertPosi = vertPosiHere;

    var vacaPos1 = checPos1 + 235;
    
    labe = [self addTextField:@"Vacaciones:" TFPosX:vacaPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
    [labe setTextColor:[CPColor whiteColor]];

    vertPosi += vertIncr;

	var fram= CGRectMake(vacaPos1,vertPosi, 260,tablHeig*0.75);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	emplVacaTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[emplVacaTabl setDataSource:self];
	[emplVacaTabl setTarget:self];
	[emplVacaTabl setAction:@selector(employeeVacationTableSelection:)];
	[emplVacaTabl setAllowsColumnReordering:YES];
	[emplVacaTabl setUsesAlternatingRowBackgroundColors:YES];
	[emplVacaTabl setAllowsMultipleSelection:YES];
	[emplVacaTabl setDelegate:self];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"DateStart"];
	[[colu headerView] setStringValue:@"FechaInicio"];
	[colu setWidth:120];
	[emplVacaTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"DateFinish"];
	[[colu headerView] setStringValue:@"FechaFin"];
	[colu setWidth:120];
	[emplVacaTabl addTableColumn:colu];

	[scroView setDocumentView:emplVacaTabl];

	[view addSubview:scroView];

    vertPosi += tablHeig*0.80;

    labe = [self addTextField:@"Fecha Inicio :" TFPosX:vacaPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplVacaStarText = [self addTextField:@"" TFPosX:vacaPos1+75 TFPosY:vertPosi-4 TFWidth:130 TFHeight:vertLineHeig VView:view Editable:YES];

	emplVacaStarButt= [self addButton:@"DP" TFPosX:vacaPos1+200 TFPosY:vertPosi-2 TFWidth:35 TFHeight:24  VView:view sizeToFit:NO Action:@selector(datePickerPanel:)];

    vertPosi += vertIncr;

    labe = [self addTextField:@"Fecha Final :" TFPosX:vacaPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplVacaFiniText = [self addTextField:@"" TFPosX:vacaPos1+75 TFPosY:vertPosi-4 TFWidth:130 TFHeight:vertLineHeig VView:view Editable:YES];

	emplVacaFiniButt= [self addButton:@"DP" TFPosX:vacaPos1+200 TFPosY:vertPosi-2 TFWidth:35 TFHeight:24  VView:view sizeToFit:NO Action:@selector(datePickerPanel:)];

    vertPosi += 30;

    var butt = [[CPButton alloc] initWithFrame: CGRectMake(vacaPos1,vertPosi, 75,24)];
	[butt setTitle:"Ingresar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeVacationsInsert:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(vacaPos1+75,vertPosi, 75,24)];
	[butt setTitle:"Actualizar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeVacationsUpdate:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(vacaPos1+150,vertPosi, 75,24)];
	[butt setTitle:"Eliminar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeVacationsDelete:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(vacaPos1+225,vertPosi, 75,24)];
	[butt setTitle:"Limpiar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeVacationsClearFields:)];                
	[view addSubview:butt];


	// Employee Equipment
	
    vertPosi += 2*vertIncr;

	labe = [self addTextField:@"Equipo:" TFPosX:vacaPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
    [labe setTextColor:[CPColor whiteColor]];

    vertPosi += vertIncr;

	var fram= CGRectMake(vacaPos1,vertPosi, 260,tablHeig*0.75);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	emplEquiTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[emplEquiTabl setDataSource:self];
	[emplEquiTabl setTarget:self];
	[emplEquiTabl setAction:@selector(employeeEquipmentTableSelection:)];
	[emplEquiTabl setAllowsColumnReordering:YES];
	[emplEquiTabl setUsesAlternatingRowBackgroundColors:YES];
	[emplEquiTabl setAllowsMultipleSelection:YES];
	[emplEquiTabl setDelegate:self];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:50];
	[emplEquiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"EquipoID"];
	[[colu headerView] setStringValue:@"EquipoID"];
	[colu setWidth:60];
	[emplEquiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Description"];
	[[colu headerView] setStringValue:@"Descripción"];
	[colu setWidth:120];
	[emplEquiTabl addTableColumn:colu];

	[scroView setDocumentView:emplEquiTabl];

	[view addSubview:scroView];

    vertPosi += tablHeig*0.80;

    labe = [self addTextField:@"ID de Equipo:" TFPosX:vacaPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplEquiPopu = [self addPopupButton:@"Equipo" TFPosX:vacaPos1+84 TFPosY:vertPosi TFWidth:180 TFHeight:24  VView:view pullsDown:NO];
	[emplEquiPopu setTarget:self];
	[emplEquiPopu setAction:@selector(employeeEquipmentPopupSelection:)];

	//emplEquiIdenText = [self addTextField:@"" TFPosX:vacaPos1+75 TFPosY:vertPosi-4 TFWidth:130 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += 30;

    var butt = [[CPButton alloc] initWithFrame: CGRectMake(vacaPos1,vertPosi, 75,24)];
	[butt setTitle:"Ingresar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeEquipmentInsert:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(vacaPos1+75,vertPosi, 75,24)];
	[butt setTitle:"Actualizar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeEquipmentUpdate:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(vacaPos1+150,vertPosi, 75,24)];
	[butt setTitle:"Eliminar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeEquipmentDelete:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(vacaPos1+225,vertPosi, 75,24)];
	[butt setTitle:"Limpiar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeEquipmentClearFields:)];                
	[view addSubview:butt];


	// Employee Training

    vertPosi = vertPosiHere;

    var traiPos1 = vacaPos1 + 330;
    var traiPos2 = traiPos1 + 80;

    labe = [self addTextField:@"Capacitaciones:" TFPosX:traiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
    [labe setTextColor:[CPColor whiteColor]];

    vertPosi += vertIncr;

	var fram= CGRectMake(traiPos1,vertPosi, 300,tablHeig);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	emplTraiTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[emplTraiTabl setDataSource:self];
	[emplTraiTabl setTarget:self];
	[emplTraiTabl setAction:@selector(employeeTrainingTableSelection:)];
	[emplTraiTabl setAllowsColumnReordering:YES];
	[emplTraiTabl setUsesAlternatingRowBackgroundColors:YES];
	[emplTraiTabl setAllowsMultipleSelection:YES];
	[emplTraiTabl setDelegate:self];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:50];
	[emplTraiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Organization"];
	[[colu headerView] setStringValue:@"Organizacion"];
	[colu setWidth:100];
	[emplTraiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Abbreviation"];
	[[colu headerView] setStringValue:@"Sigla"];
	[colu setWidth:120];
	[emplTraiTabl addTableColumn:colu];

	[scroView setDocumentView:emplTraiTabl];

	[view addSubview:scroView];


    vertPosi += tablHeig + 10;

	labe = [self addTextField:@"Organizacion:" TFPosX:traiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	//emplTraiOrgaText = [self addTextField:@"" TFPosX:traiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];
	orgaPopu = [self addPopupButton:@"Organizaciones" TFPosX:traiPos2+4 TFPosY:vertPosi TFWidth:200 TFHeight:24  VView:view pullsDown:NO];
	[orgaPopu setTarget:self];
	[orgaPopu setAction:@selector(organizationPopupSelection:)];

	quer = [CPString stringWithFormat:@"select id,name from %@.organizations where id!='%@' and active=1 order by name",
		dataBase,orgaCode];
	orgaArra= [self query:quer];
	var coun = [orgaArra count];
	for ( var i=0; i<coun; i++ ) {
		var valuList = [orgaArra[i] valueList];
		var iden = valuList[0];
		[orgaPopu addItemWithTitle:iden];
	}

    vertPosi += vertIncr;

	labe = [self addTextField:@"Sigla:" TFPosX:traiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	//emplTraiAbbrText = [self addTextField:@"" TFPosX:traiPos2 TFPosY:vertPosi-4 TFWidth:100 TFHeight:vertLineHeig VView:view Editable:YES];
	orgaTraiAbbrPopu = [self addPopupButton:@"Siglas" TFPosX:traiPos2+4 TFPosY:vertPosi TFWidth:200 TFHeight:24  VView:view pullsDown:NO];
	[orgaTraiAbbrPopu setTarget:self];
	[orgaTraiAbbrPopu setAction:@selector(organizationTrainingAbbreviationPopupSelection:)];

    vertPosi += vertIncr;

	labe = [self addTextField:@"Capacitación:" TFPosX:traiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	emplTraiDateLastText = [self addTextField:@"" TFPosX:traiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];

	vertPosi += vertIncr;
	
	labe = [self addTextField:@"Descripcion:" TFPosX:traiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	orgaTraiDescText = [self addTextField:@"" TFPosX:traiPos2 TFPosY:vertPosi-4 TFWidth:220 TFHeight:2*vertLineHeig VView:view Editable:YES];
	[orgaTraiDescText setLineBreakMode:CPLineBreakByWordWrapping];
	[orgaTraiDescText setTextColor:[CPColor lightGrayColor]];

    vertPosi += 2*vertLineHeig;

	labe = [self addTextField:@"Fecha Desde:" TFPosX:traiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	orgaTraiDateLastText = [self addTextField:@"" TFPosX:traiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];
	[orgaTraiDateLastText setTextColor:[CPColor lightGrayColor]];

    vertPosi += vertIncr;

	labe = [self addTextField:@"Fecha Hasta:" TFPosX:traiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	orgaTraiDateExpiText = [self addTextField:@"" TFPosX:traiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];
	[orgaTraiDateExpiText setTextColor:[CPColor lightGrayColor]];

    vertPosi += 30;

    var butt = [[CPButton alloc] initWithFrame: CGRectMake(traiPos1,vertPosi, 75,24)];
	[butt setTitle:"Ingresar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeTrainingInsert:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(traiPos1+75,vertPosi, 75,24)];
	[butt setTitle:"Actualizar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeTrainingUpdate:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(traiPos1+150,vertPosi, 75,24)];
	[butt setTitle:"Eliminar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeTrainingDelete:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(traiPos1+225,vertPosi, 75,24)];
	[butt setTitle:"Limpiar"];
	[butt setTarget:self];
	[butt setAction:@selector(employeeTrainingClearFields:)];                
	[view addSubview:butt];


	[tabViewItem setView:view];

	[tabView addTabViewItem: tabViewItem];


	// Vehicles *****************************************************

	tabViewItem = [[CPTabViewItem alloc] initWithIdentifier:@"equipment"];
	[tabViewItem setLabel:@"  Equipo  "];
				
	view = [[CPView alloc] initWithFrame: CGRectMake(50,50, 50,50)]; // donde se pone los controles --> cp view
	[view setBackgroundColor:coloDefaBrig];

	vertPosi = 20;

	var fram= CGRectMake(horiPos2,vertPosi, 1000,tablHeig);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	equiTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[equiTabl setDataSource:self];
	[equiTabl setTarget:self];
	[equiTabl setAction:@selector(equipmentTableSelection:)];
	[equiTabl setAllowsColumnReordering:YES];
	[equiTabl setUsesAlternatingRowBackgroundColors:YES];
	[equiTabl setAllowsMultipleSelection:YES];
	[equiTabl setDelegate:self];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"ID0"];
	[[colu headerView] setStringValue:@"ID0"];
	[colu setWidth:60];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"ID1"];
	[[colu headerView] setStringValue:@"ID1"];
	[colu setWidth:60];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"ID2"];
	[[colu headerView] setStringValue:@"ID2"];
	[colu setWidth:60];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Placa"];
	[[colu headerView] setStringValue:@"Placa"];
	[colu setWidth:80];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Marca"];
	[[colu headerView] setStringValue:@"Marca"];
	[colu setWidth:100];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Modelo"];
	[[colu headerView] setStringValue:@"Modelo"];
	[colu setWidth:120];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Año"];
	[[colu headerView] setStringValue:@"Año"];
	[colu setWidth:60];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Tipo"];
	[[colu headerView] setStringValue:@"Tipo"];
	[colu setWidth:120];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Espacios"];
	[[colu headerView] setStringValue:@"Espacios"];
	[colu setWidth:60];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Restriccion"];
	[[colu headerView] setStringValue:@"Restriccion"];
	[colu setWidth:80];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Activo"];
	[[colu headerView] setStringValue:@"Activo"];
	[colu setWidth:60];
	[equiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Comentarios"];
	[[colu headerView] setStringValue:@"Comentarios"];
	[colu setWidth:200];
	[equiTabl addTableColumn:colu];

	[scroView setDocumentView:equiTabl];

	[view addSubview:scroView];


    vertPosi += tablHeig + 10;
    vertPosiHere = vertPosi;

	labe = [self addTextField:@"ID0:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiIden0Text = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:60 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

	labe = [self addTextField:@"*ID1:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiIden1Text = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:100 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

	labe = [self addTextField:@"*ID2:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiIden2Text = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:100 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

    labe = [self addTextField:@"*Placa:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiLawIdenText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:100 TFHeight:vertLineHeig VView:view Editable:YES];
    
    vertPosi += vertIncr;

	labe = [self addTextField:@"Marca:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiMakeText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:200 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

	labe = [self addTextField:@"Modelo:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiModeText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:200 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

	labe = [self addTextField:@"Año:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiYearText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:60 TFHeight:vertLineHeig VView:view Editable:YES];


	var vertPosiBott = vertPosi + vertIncr;
    vertPosi = vertPosiHere;

    labe = [self addTextField:@"Tipo:" TFPosX:horiPos3 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiTypeText = [self addTextField:@"" TFPosX:horiPos4 TFPosY:vertPosi-4 TFWidth:200 TFHeight:vertLineHeig VView:view Editable:YES];
    
    vertPosi += vertIncr;

    labe = [self addTextField:@"Espacios:" TFPosX:horiPos3 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiPassCounText = [self addTextField:@"" TFPosX:horiPos4 TFPosY:vertPosi-4 TFWidth:60 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

    labe = [self addTextField:@"Restriccion:" TFPosX:horiPos3 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiRestText = [self addTextField:@"" TFPosX:horiPos4 TFPosY:vertPosi-4 TFWidth:240 TFHeight:2*vertLineHeig VView:view Editable:YES];
	[equiRestText setLineBreakMode:CPLineBreakByWordWrapping];

    vertPosi += 2*vertLineHeig;

    labe = [self addTextField:@"Comentarios:" TFPosX:horiPos3 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	equiNoteText = [self addTextField:@"" TFPosX:horiPos4 TFPosY:vertPosi-4 TFWidth:240 TFHeight:2*vertLineHeig VView:view Editable:YES];
	[equiNoteText setLineBreakMode:CPLineBreakByWordWrapping];

    vertPosi = vertPosiBott + 0.5*vertIncr;

    labe = [self addTextField:@"Activo:" TFPosX:horiPos1 TFPosY:vertPosi+10 TFWidth:0 TFHeight:0 VView:view Editable:NO];
    [labe setTextColor:[CPColor whiteColor]];

    equiActiChec = [CPCheckBox checkBoxWithTitle:@"Seleccione para activar/desactivar el equipo"];
    [equiActiChec setTextColor:[CPColor whiteColor]];
    [equiActiChec setFrameOrigin:CPPointMake(horiPos2, vertPosi+10)];
    [equiActiChec setTarget:self];
    [equiActiChec setEnabled:YES];
    //[checDeshClie setAction:@selector(stateCheck4:)];
    [view addSubview:equiActiChec];


	vertPosi += 2*vertIncr;

    butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2,vertPosi, 75,24)];
	[butt setTitle:"Ingresar"];
	[butt setTarget:self];
	[butt setAction:@selector(equipmentInsert:)];                
	[view addSubview:butt];
    
	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+75,vertPosi, 75,24)];
	[butt setTitle:"Actualizar"];
	[butt setTarget:self];
	[butt setAction:@selector(equipmentUpdate:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+150,vertPosi, 75,24)];
	[butt setTitle:"Eliminar"];
	[butt setTarget:self];
	[butt setAction:@selector(equipmentDelete:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+225,vertPosi, 75,24)];
	[butt setTitle:"Limpiar"];
	[butt setTarget:self];
	[butt setAction:@selector(equipmentClearFields:)];                
	[view addSubview:butt];

	[tabViewItem setView:view];
				
	[tabView addTabViewItem: tabViewItem];
	
	[tabView selectFirstTabViewItem:0];
	
	
	// Holidays *****************************************************

	tabViewItem = [[CPTabViewItem alloc] initWithIdentifier:@"holidays"];
	[tabViewItem setLabel:@"  Feriados  "];
				
	view = [[CPView alloc] initWithFrame: CGRectMake(50,50, 50,50)]; // donde se pone los controles --> cp view
	[view setBackgroundColor:coloDefaBrig];

	vertPosi = 20;

	var fram= CGRectMake(horiPos2,vertPosi, 500,tablHeig);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	holiTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[holiTabl setDataSource:self];
	[holiTabl setTarget:self];
	[holiTabl setAction:@selector(holidaysTableSelection:)];
	[holiTabl setAllowsColumnReordering:YES];
	[holiTabl setUsesAlternatingRowBackgroundColors:YES];
	[holiTabl setAllowsMultipleSelection:YES];
	[holiTabl setDelegate:self];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:50];
	[holiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"FechaInicio"];
	[[colu headerView] setStringValue:@"FechaInicio"];
	[colu setWidth:140];
	[holiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"FechaFin"];
	[[colu headerView] setStringValue:@"FechaFin"];
	[colu setWidth:140];
	[holiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Descripcion"];
	[[colu headerView] setStringValue:@"Descripcion"];
	[colu setWidth:160];
	[holiTabl addTableColumn:colu];

	[scroView setDocumentView:holiTabl];

	[view addSubview:scroView];


    vertPosi += tablHeig + 10;
    vertPosiHere = vertPosi;

	labe = [self addTextField:@"FechaInicio:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	holiDateStarText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

	labe = [self addTextField:@"FechaFin:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	holiDateFiniText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

	labe = [self addTextField:@"Descripcion:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	holiDescText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:500 TFHeight:2*vertLineHeig VView:view Editable:YES];
	[holiDescText setLineBreakMode:CPLineBreakByWordWrapping];

    vertPosi += 2*vertLineHeig;

    var butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2,vertPosi, 75,24)];
	[butt setTitle:"Ingresar"];
	[butt setTarget:self];
	[butt setAction:@selector(holidaysInsert:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+75,vertPosi, 75,24)];
	[butt setTitle:"Actualizar"];
	[butt setTarget:self];
	[butt setAction:@selector(holidaysUpdate:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+150,vertPosi, 75,24)];
	[butt setTitle:"Eliminar"];
	[butt setTarget:self];
	[butt setAction:@selector(holidaysDelete:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+225,vertPosi, 75,24)];
	[butt setTitle:"Limpiar"];
	[butt setTarget:self];
	[butt setAction:@selector(holidaysClearFields:)];                
	[view addSubview:butt];


	[tabViewItem setView:view];
				
	[tabView addTabViewItem: tabViewItem];
	

	// Activities *****************************************************

	tabViewItem = [[CPTabViewItem alloc] initWithIdentifier:@"activities"];
	[tabViewItem setLabel:@"  Actividades  "];
				
	view = [[CPView alloc] initWithFrame: CGRectMake(50,50, 50,50)]; // donde se pone los controles --> cp view
	[view setBackgroundColor:coloDefaBrig];

	vertPosi = 20;

	labe = [self addTextField:@"Actividades:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	var fram= CGRectMake(horiPos2,vertPosi, 500,tablHeig);
	var scroView= [[CPScrollView alloc] initWithFrame:fram];

	actiTabl = [[CPTableView alloc] initWithFrame:[scroView bounds]];
	[actiTabl setDataSource:self];
	[actiTabl setTarget:self];
	[actiTabl setAction:@selector(activitiesTableSelection:)];
	[actiTabl setAllowsColumnReordering:YES];
	[actiTabl setUsesAlternatingRowBackgroundColors:YES];
	[actiTabl setAllowsMultipleSelection:YES];
	[actiTabl setDelegate:self];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"ID"];
	[[colu headerView] setStringValue:@"ID"];
	[colu setWidth:50];
	[actiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Descripcion"];
	[[colu headerView] setStringValue:@"Descripcion"];
	[colu setWidth:300];
	[actiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Duracion"];
	[[colu headerView] setStringValue:@"Duracion"];
	[colu setWidth:70];
	[actiTabl addTableColumn:colu];

	colu = [[CPTableColumn alloc] initWithIdentifier:@"Precio"];
	[[colu headerView] setStringValue:@"Precio"];
	[colu setWidth:70];
	[actiTabl addTableColumn:colu];

	[scroView setDocumentView:actiTabl];

	[view addSubview:scroView];


    vertPosi += tablHeig + 10;
    vertPosiHere = vertPosi;

	labe = [self addTextField:@"Descripcion:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	actiDescText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:500 TFHeight:2*vertLineHeig VView:view Editable:YES];
	[actiDescText setLineBreakMode:CPLineBreakByWordWrapping];

    vertPosi += 2*vertLineHeig;

	labe = [self addTextField:@"Duracion:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	actiDuraText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += vertIncr;

	labe = [self addTextField:@"Precio:" TFPosX:horiPos1 TFPosY:vertPosi TFWidth:0 TFHeight:0 VView:view Editable:NO];
	[labe setTextColor:[CPColor whiteColor]];

	actiPricText = [self addTextField:@"" TFPosX:horiPos2 TFPosY:vertPosi-4 TFWidth:140 TFHeight:vertLineHeig VView:view Editable:YES];

    vertPosi += 1.5*vertIncr;

    actiActiChec = [CPCheckBox checkBoxWithTitle:@"Seleccione para activar/desactivar la actividad"];
	[actiActiChec setTextColor:[CPColor whiteColor]];
    [actiActiChec setFrameOrigin:CPPointMake(horiPos2, vertPosi)];
    [actiActiChec setTarget:self];
    [actiActiChec setEnabled:YES];
    [view addSubview:actiActiChec];

    vertPosi += 2*vertLineHeig;

    var butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2,vertPosi, 75,24)];
	[butt setTitle:"Ingresar"];
	[butt setTarget:self];
	[butt setAction:@selector(activitiesInsert:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+75,vertPosi, 75,24)];
	[butt setTitle:"Actualizar"];
	[butt setTarget:self];
	[butt setAction:@selector(activitiesUpdate:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+150,vertPosi, 75,24)];
	[butt setTitle:"Eliminar"];
	[butt setTarget:self];
	[butt setAction:@selector(activitiesDelete:)];                
	[view addSubview:butt];

	butt = [[CPButton alloc] initWithFrame: CGRectMake(horiPos2+225,vertPosi, 75,24)];
	[butt setTitle:"Limpiar"];
	[butt setTarget:self];
	[butt setAction:@selector(activitiesClearFields:)];                
	[view addSubview:butt];


	[tabViewItem setView:view];
				
	[tabView addTabViewItem: tabViewItem];
	

	[tabView selectFirstTabViewItem:0];
}



- (void) employeeActiveDay:(id)sender {
	chanStat = 1;
	if ( sender == emplActiSundChec && [sender state] ) {
		[emplHourStarSundText setStringValue:@"00:00"];
		[emplHourFiniSundText setStringValue:@"23:59"];
	}
	else if ( sender == emplActiSundChec ) {
		[emplHourStarSundText setStringValue:@""];
		[emplHourFiniSundText setStringValue:@""];
	}
	if ( sender == emplActiMondChec && [sender state] ) {
		[emplHourStarMondText setStringValue:@"00:00"];
		[emplHourFiniMondText setStringValue:@"23:59"];
	}
	else if ( sender == emplActiMondChec ) {
		[emplHourStarMondText setStringValue:@""];
		[emplHourFiniMondText setStringValue:@""];
	}
	if ( sender == emplActiTuesChec && [sender state] ) {
		[emplHourStarTuesText setStringValue:@"00:00"];
		[emplHourFiniTuesText setStringValue:@"23:59"];
	}
	else if ( sender == emplActiTuesChec ) {
		[emplHourStarTuesText setStringValue:@""];
		[emplHourFiniTuesText setStringValue:@""];
	}
	if ( sender == emplActiWednChec && [sender state] ) {
		[emplHourStarWednText setStringValue:@"00:00"];
		[emplHourFiniWednText setStringValue:@"23:59"];
	}
	else if ( sender == emplActiWednChec ) {
		[emplHourStarWednText setStringValue:@""];
		[emplHourFiniWednText setStringValue:@""];
	}
	if ( sender == emplActiThurChec && [sender state] ) {
		[emplHourStarThurText setStringValue:@"00:00"];
		[emplHourFiniThurText setStringValue:@"23:59"];
	}
	else if ( sender == emplActiThurChec ) {
		[emplHourStarThurText setStringValue:@""];
		[emplHourFiniThurText setStringValue:@""];
	}
	if ( sender == emplActiFridChec && [sender state] ) {
		[emplHourStarFridText setStringValue:@"00:00"];
		[emplHourFiniFridText setStringValue:@"23:59"];
	}
	else if ( sender == emplActiFridChec ) {
		[emplHourStarFridText setStringValue:@""];
		[emplHourFiniFridText setStringValue:@""];
	}
	if ( sender == emplActiSatuChec && [sender state] ) {
		[emplHourStarSatuText setStringValue:@"00:00"];
		[emplHourFiniSatuText setStringValue:@"23:59"];
	}
	else if ( sender == emplActiSatuChec ) {
		[emplHourStarSatuText setStringValue:@""];
		[emplHourFiniSatuText setStringValue:@""];
	}
}



- (void)  employeeClearFields:(id)sender {
	[emplLawIdenText setStringValue:""];
	[emplNameLastText setStringValue:""];
	[emplNameFirsText setStringValue:""];
	[emplPosiText setStringValue:""];
	[emplAddrStreText setStringValue:""];
	[emplAddrCityText setStringValue:""];
	[emplAddrStatText setStringValue:""];
	[emplPhon1Text setStringValue:""];
	[emplPhon2Text setStringValue:""];
	[emplEmaiText setStringValue:""];
	[emplNoteText setStringValue:""];
	[emplActiChec setState:0];
	prevValuEmplActiChec = "0";

	[emplActiSundChec setState:0];
	[emplActiMondChec setState:0];
	[emplActiTuesChec setState:0];
	[emplActiWednChec setState:0];
	[emplActiThurChec setState:0];
	[emplActiFridChec setState:0];
	[emplActiSatuChec setState:0];

	[emplHourStarSundText setStringValue:@""];
	[emplHourStarMondText setStringValue:@""];
	[emplHourStarTuesText setStringValue:@""];
	[emplHourStarWednText setStringValue:@""];
	[emplHourStarThurText setStringValue:@""];
	[emplHourStarFridText setStringValue:@""];
	[emplHourStarSatuText setStringValue:@""];
	[emplHourFiniSundText setStringValue:@""];
	[emplHourFiniMondText setStringValue:@""];
	[emplHourFiniTuesText setStringValue:@""];
	[emplHourFiniWednText setStringValue:@""];
	[emplHourFiniThurText setStringValue:@""];
	[emplHourFiniFridText setStringValue:@""];
	[emplHourFiniSatuText setStringValue:@""];
	
	[emplVacaStarText setStringValue:@""];
	[emplVacaFiniText setStringValue:@""];
}



- (void) employeeDelete:(id)sender {
	var inde = [emplTabl selectedRow];
	if ( inde < 0 )
		return;

	var valuList = [[emplArra objectAtIndex:inde] valueList];
	var iden = [valuList objectAtIndex:0];
	var nameLast = [valuList objectAtIndex:1];
	var nameFirs = [valuList objectAtIndex:2];

	var conf = confirm("Quiere eliminar los datos de "+nameLast+", "+nameFirs+" id="+iden);
	if ( ! conf )
		return;
	/*
	var quer = [CPString stringWithFormat:@"delete from %@.automaticReportEmployee where personId = %@",dataBase,iden];
	[self query:quer];
    */
	var quer = [CPString stringWithFormat:@"delete from %@.persons where id=%@",dataBase,iden];
	[self query:quer];

	var acti = [emplActiChec state];
	var posi = [emplPosiText stringValue];
	var quer = [CPString stringWithFormat:@"delete from %@.organizationPersons where organizationId='%@' and personId=%@",
		dataBase,orgaCode,iden];
	[self query:quer];
	
	quer = [CPString stringWithFormat:@"delete from %@.personSchedule where personId=%@",dataBase,iden];
	[self query:quer];

	//var useTabl
	quer = [CPString stringWithFormat:@"select * from %@.events where personnel like '%%:%@|%%'",dataBase,iden];
	var arra = [self query:quer];
	alert("Numero de eventos con esta persona: "+[arra count]);
	
	quer = [CPString stringWithFormat:@"DELETE FROM %@.automaticReportDefinitions  WHERE identifier = '%@' AND typeReportId = 3",dataBase,iden];
	[self query:quer];
	
	[emplTabl reloadData];
	chanStat = 0;
}



- (void) employeeInsert:(id)sender {
	var quer = [CPString stringWithFormat:@"insert into %@.persons (lawId,nameLast,nameFirst,role,phone1,phone2,email,homeAddressStreet,homeAddressCity,homeAddressState,notes) values ('%@','%@','%@','%@','%@','%@','%@','%@','%@','%@','%@')",dataBase,
		[emplLawIdenText stringValue],[emplNameLastText stringValue],[emplNameFirsText stringValue],[emplPosiText stringValue],[emplPhon1Text stringValue],[emplPhon2Text stringValue],[emplEmaiText stringValue],[emplAddrStreText stringValue],[emplAddrCityText stringValue],[emplAddrStatText stringValue],[emplNoteText stringValue]];
	[self query:quer];

	quer = @"select max(id) from " + dataBase + ".persons";
	arra = [self query:quer];
	coun = [arra count];
	if ( [[emplPosiText stringValue] length] == 0 ) 
       		[emplPosiText setStringValue:@"NA"];
	if ( coun ) {
		var valuList = [arra[0] valueList];
		alert("El nuevo ID="+valuList[0]);
		quer = [CPString stringWithFormat:@"insert into %@.organizationPersons (position,active,eMail,personId,organizationId) values ('%@',%@,'%@',%@,'%@')",dataBase,
			[emplPosiText stringValue],[emplActiChec state],[emplEmaiText stringValue],valuList[0],orgaCode];
		[self query:quer];
	    quer = [CPString stringWithFormat:@"INSERT INTO %@.automaticReportDefinitions (typeReportId,sendFrequencyId,identifier,daysToSend,nextGeneDate) VALUES (%@,%@,%@,%@,curdate() + interval 20 hour + interval 0 minute)",
								  dataBase,3,3,valuList[0],3];
		//console.log("query = " + quer);
		[self query:quer];
	}
	
	[emplTabl reloadData];
	chanStat = 0;
}



- (void)  employeeTableSelection:(id)sender {
	var inde = [emplTabl selectedRow];
	if ( inde < 0 )
		return;

	if ( chanStat )
		alert("Modificaciones no serán guardadas");
	chanStat = 0;

	[self employeeClearFields:0];

	var valuList = [[emplArra objectAtIndex:inde] valueList];
	[emplLawIdenText  setStringValue:valuList[1]];
	[emplNameLastText setStringValue:valuList[2]];
	[emplNameFirsText setStringValue:valuList[3]];
	[emplPosiText     setStringValue:valuList[4]];
	[emplAddrStreText setStringValue:valuList[5]];
	[emplAddrCityText setStringValue:valuList[6]];
	[emplAddrStatText setStringValue:valuList[7]];
	[emplPhon1Text    setStringValue:valuList[8]];
	[emplPhon2Text    setStringValue:valuList[9]];
	[emplEmaiText     setStringValue:valuList[10]];
	[emplNoteText     setStringValue:valuList[11]];
	[emplActiChec     setState:[valuList[12] intValue]];
	prevValuEmplActiChec = "" + [emplActiChec state] + "";
	
	var quer = [CPString stringWithFormat:@"select day,timeStart,timeFinish from %@.personSchedule where personId=%@",dataBase,valuList[0]];
	var scheArra = [self query:quer];
	var coun = [scheArra count];

	for ( var i=0; i<coun; i++ ) {
		var valuList = [scheArra[i] valueList];
		if ( [valuList[0] intValue] == 0 ) {
			[emplActiSundChec setState:1];
			[emplHourStarSundText setStringValue:valuList[1]];
			[emplHourFiniSundText setStringValue:valuList[2]];
		}
		else if ( [valuList[0] intValue] == 1 ) {
			[emplActiMondChec setState:1];
			[emplHourStarMondText setStringValue:valuList[1]];
			[emplHourFiniMondText setStringValue:valuList[2]];
		}
		else if ( [valuList[0] intValue] == 2 ) {
			[emplActiTuesChec setState:1];
			[emplHourStarTuesText setStringValue:valuList[1]];
			[emplHourFiniTuesText setStringValue:valuList[2]];
		}
		else if ( [valuList[0] intValue] == 3 ) {
			[emplActiWednChec setState:1];
			[emplHourStarWednText setStringValue:valuList[1]];
			[emplHourFiniWednText setStringValue:valuList[2]];
		}
		else if ( [valuList[0] intValue] == 4 ) {
			[emplActiThurChec setState:1];
			[emplHourStarThurText setStringValue:valuList[1]];
			[emplHourFiniThurText setStringValue:valuList[2]];
		}
		else if ( [valuList[0] intValue] == 5 ) {
			[emplActiFridChec setState:1];
			[emplHourStarFridText setStringValue:valuList[1]];
			[emplHourFiniFridText setStringValue:valuList[2]];
		}
		else if ( [valuList[0] intValue] == 6 ) {
			[emplActiSatuChec setState:1];
			[emplHourStarSatuText setStringValue:valuList[1]];
			[emplHourFiniSatuText setStringValue:valuList[2]];
		}
	}
	
	[emplEquiTabl reloadData]
	[emplVacaTabl reloadData];
	[emplTraiTabl reloadData];
	
}



- (void) employeeUpdate:(id)sender {
	var inde = [emplTabl selectedRow];
	if ( inde < 0 )
		return;
	var iden = [[[emplArra objectAtIndex:inde] valueList] objectAtIndex:0];
	var name = [[[emplArra objectAtIndex:inde] valueList] objectAtIndex:3];
	var lastName = [[[emplArra objectAtIndex:inde] valueList] objectAtIndex:2];
	var lastPosi = [[[[emplArra objectAtIndex:inde] valueList] objectAtIndex:4] substringToIndex:1];
	var newPosi = [[emplPosiText stringValue] substringToIndex:1];
	var newPers = "REPLACE(personnel,'|"+lastName+", "+name+" ["+lastPosi+"]:"+iden+"|','|"+[emplNameLastText stringValue]+", "+[emplNameFirsText stringValue]+" ["+newPosi+"]:"+iden+"|')";
	var quer = "update "+dataBase+".eventsPermanent set personnel="+newPers+" where personnel like '%"+iden+"%' ";
	console.log(quer);
	[self query:quer];
	var iden = [[[emplArra objectAtIndex:inde] valueList] objectAtIndex:0];
	var quer = [CPString stringWithFormat:@"update %@.persons set lawId='%@',nameLast='%@',nameFirst='%@',role='%@',phone1='%@',phone2='%@',email='%@',homeAddressStreet='%@',homeAddressCity='%@',homeAddressState='%@',notes='%@' where id=%@",dataBase,
		[emplLawIdenText stringValue],[emplNameLastText stringValue],[emplNameFirsText stringValue],[emplPosiText stringValue],[emplPhon1Text stringValue],[emplPhon2Text stringValue],[emplEmaiText stringValue],[emplAddrStreText stringValue],[emplAddrCityText stringValue],[emplAddrStatText stringValue],[emplNoteText stringValue],iden];
	[self query:quer];

	var acti = [emplActiChec state];
	var posi = [emplPosiText stringValue];
	var quer = [CPString stringWithFormat:@"update %@.organizationPersons set active=%@,position='%@',eMail = '%@' where organizationId='%@' and personId=%@",dataBase,
		acti,posi,[emplEmaiText stringValue],orgaCode,iden];
	[self query:quer];
	
	[self employeeWeekScheduleUpdateFor:iden];
	
	
	
	if  (  (prevValuEmplActiChec == "1") && (acti == 0) ){
	
	var striPara = [CPString stringWithFormat:@"nameFirst=%@:sc:nameLast=%@:sc:role=%@:sc:id=%@",[emplNameFirsText stringValue],[emplNameLastText stringValue],[emplPosiText stringValue],iden ];
	quer = [CPString stringWithFormat:@"UPDATE %@.automaticReportDefinitions SET active = 0, contentParameters ='%@', emailList='%@' WHERE identifier = '%@' AND typeReportId = 3",
										  dataBase,striPara,[emplEmaiText stringValue],iden];
		//console.log("query= " + quer);
	}else{
		var striPara = [CPString stringWithFormat:@"nameFirst=%@:sc:nameLast=%@:sc:role=%@:sc:id=%@",[emplNameFirsText stringValue],[emplNameLastText stringValue],[emplPosiText stringValue],iden ];
		quer = [CPString stringWithFormat:@"UPDATE %@.automaticReportDefinitions SET contentParameters ='%@', emailList='%@' WHERE identifier = '%@' AND typeReportId = 3",
										  dataBase,striPara,[emplEmaiText stringValue],iden];
	}	
		
	[self query: quer];

	[emplTabl reloadData];
	chanStat = 0;

}



- (void) employeeWeekScheduleUpdateFor:(id)iden {
	quer = [CPString stringWithFormat:@"delete from %@.personSchedule where personId=%@",dataBase,iden];
	[self query:quer];

	var inse = 0;
	quer = @"insert into " + dataBase + ".personSchedule (personId,day,timeStart,timeFinish) values ";

	if ( [emplActiSundChec state] ) {
		quer = [CPString stringWithFormat:@"%@ (%@,0,'%@','%@')", quer,iden,[emplHourStarSundText stringValue],[emplHourFiniSundText stringValue]];
		inse++;
	}
	else {
		[emplHourStarSundText setStringValue:@""];
		[emplHourFiniSundText setStringValue:@""];
	}
	if ( [emplActiMondChec state] ) {
		if ( inse )
			quer = [CPString stringWithFormat:@"%@, (%@,1,'%@','%@')", quer,iden,[emplHourStarMondText stringValue],[emplHourFiniMondText stringValue]];
		else
			quer = [CPString stringWithFormat:@"%@ (%@,1,'%@','%@')", quer,iden,[emplHourStarMondText stringValue],[emplHourFiniMondText stringValue]];
		inse++;
	}
	else {
		[emplHourStarMondText setStringValue:@""];
		[emplHourFiniMondText setStringValue:@""];
	}
	if ( [emplActiTuesChec state] ) {
		if ( inse )
			quer = [CPString stringWithFormat:@"%@, (%@,2,'%@','%@')", quer,iden,[emplHourStarTuesText stringValue],[emplHourFiniTuesText stringValue]];
		else
			quer = [CPString stringWithFormat:@"%@ (%@,2,'%@','%@')", quer,iden,[emplHourStarTuesText stringValue],[emplHourFiniTuesText stringValue]];
		inse++;
	}
	else {
		[emplHourStarTuesText setStringValue:@""];
		[emplHourFiniTuesText setStringValue:@""];
	}
	if ( [emplActiWednChec state] ) {
		if ( inse )
			quer = [CPString stringWithFormat:@"%@, (%@,3,'%@','%@')", quer,iden,[emplHourStarWednText stringValue],[emplHourFiniWednText stringValue]];
		else
			quer = [CPString stringWithFormat:@"%@ (%@,3,'%@','%@')", quer,iden,[emplHourStarWednText stringValue],[emplHourFiniWednText stringValue]];
		inse++;
	}
	else {
		[emplHourStarWednText setStringValue:@""];
		[emplHourFiniWednText setStringValue:@""];
	}
	if ( [emplActiThurChec state] ) {
		if ( inse )
			quer = [CPString stringWithFormat:@"%@, (%@,4,'%@','%@')", quer,iden,[emplHourStarThurText stringValue],[emplHourFiniThurText stringValue]];
		else
			quer = [CPString stringWithFormat:@"%@ (%@,4,'%@','%@')", quer,iden,[emplHourStarThurText stringValue],[emplHourFiniThurText stringValue]];
		inse++;
	}
	else {
		[emplHourStarThurText setStringValue:@""];
		[emplHourFiniThurText setStringValue:@""];
	}
	if ( [emplActiFridChec state] ) {
		if ( inse )
			quer = [CPString stringWithFormat:@"%@, (%@,5,'%@','%@')", quer,iden,[emplHourStarFridText stringValue],[emplHourFiniFridText stringValue]];
		else
			quer = [CPString stringWithFormat:@"%@ (%@,5,'%@','%@')", quer,iden,[emplHourStarFridText stringValue],[emplHourFiniFridText stringValue]];
		inse++;
	}
	else {
		[emplHourStarFridText setStringValue:@""];
		[emplHourFiniFridText setStringValue:@""];
	}
	if ( [emplActiSatuChec state] ) {
		if ( inse )
			quer = [CPString stringWithFormat:@"%@, (%@,6,'%@','%@')", quer,iden,[emplHourStarSatuText stringValue],[emplHourFiniSatuText stringValue]];
		else
			quer = [CPString stringWithFormat:@"%@ (%@,6,'%@','%@')", quer,iden,[emplHourStarSatuText stringValue],[emplHourFiniSatuText stringValue]];
		inse++;
	}
	else {
		[emplHourStarSatuText setStringValue:@""];
		[emplHourFiniSatuText setStringValue:@""];
	}

	if ( inse )
		[self query:quer];
}



// Employee Vacations

- (void) employeeEquipmentClearFields:(id)sender {
	[emplEquiIdenText setStringValue:@""];
}



- (void) employeeEquipmentDelete:(id)sender {
	var inde = [emplEquiTabl selectedRow];
	if ( inde < 0 )
		return;

	var emplEquiIden = [[emplEquiArra[inde] valueList] objectAtIndex:0];
	
	var conf = confirm("Por favor confirme la eliminación del registro *"+emplEquiIden+"*");
	if ( conf ) {
		var quer = [CPString stringWithFormat:@"delete from %@.personEquipment where id=%@",dataBase,emplEquiIden];
		[self query:quer];
		[emplEquiTabl reloadData];
	}
}



- (void) employeeEquipmentInsert:(id)sender {
	var inde = [emplTabl selectedRow];
	if ( inde < 0 ) {
		alert("Seleccione el empleado antes de proceder");
		return;
	}
	var emplIden = [[emplArra[inde] valueList] objectAtIndex:0];

	inde = [emplEquiPopu indexOfSelectedItem];
	if ( inde < 0 ) {
		alert("Seleccione primero el equipo");
		return;
	}

	var valuList = [equiArra[inde] valueList];
	var equiIden = valuList[0];

	var quer = [CPString stringWithFormat:@"insert into %@.personEquipment (personId,equipmentId) values (%@,%@)",dataBase,
		emplIden,equiIden];
	[self query:quer];

	[emplEquiTabl reloadData];
}



- (void) employeeEquipmentPopupSelection:(id)sender {
}



- (void) employeeEquipmentTableSelection:(id)sender {
	var inde = [emplEquiTabl selectedRow];
	if ( inde < 0 )
		return;

	var valuList = [emplEquiArra[inde] valueList];
	var emplEquiDesc = [valuList objectAtIndex:1];
	
	[emplEquiIdenText setStringValue:emplEquiDesc];
}



- (void) employeeEquipmentUpdate:(id)sender {
	var inde = [emplEquiTabl selectedRow];
	if ( inde < 0 ) {
		alert("Seleccione a un equipo antes de proceder ("+inde+")");
		return;
	}

	var emplEquiIden = [[emplEquiArra[inde] valueList] objectAtIndex:0];

	var equiIden = [emplEquiIdenText stringValue];

	var quer = [CPString stringWithFormat:@"update %@.personEquipment set equipmentId=%@ where id=%@",dataBase,
		equiIden,emplEquiIden];
	[self query:quer];

	[emplEquiTabl reloadData];
}



// Employee Trainings

- (void) employeeTrainingClearFields:(id)sender {
	//[emplTraiOrgaText setStringValue:@""];
	[orgaPopu selectItemAtIndex:0];
	//[emplTraiAbbrText setStringValue:@""];
	[orgaTraiAbbrPopu selectItemAtIndex:0];
	[emplTraiDateLastText setStringValue:@""];
}



- (void) employeeTrainingDelete:(id)sender {
	inde = [emplTraiTabl selectedRow];
	if ( inde < 0 )
		return;
	var emplTraiIden = [[emplTraiArra[inde] valueList] objectAtIndex:0];

	var quer = [CPString stringWithFormat:@"delete from %@.employeeTraining where id=%@",dataBase,emplTraiIden];
	[self query:quer];

	[emplTraiTabl reloadData];
}



- (void) employeeTrainingInsert:(id)sender {
	var inde = [emplTabl selectedRow];
	if ( inde < 0 )
		return;
	var emplIden = [[emplArra[inde] valueList] objectAtIndex:0];

	inde = [orgaPopu indexOfSelectedItem];
	if ( inde < 1 )
		return;

	inde--;
	var emplTraiOrga = [[orgaArra[inde] valueList] objectAtIndex:0];

	//var emplTraiAbbr = [emplTraiAbbrText stringValue];
	inde = [orgaTraiAbbrPopu indexOfSelectedItem];
	if ( inde < 1 ) {
		alert("Por favor seleccione la sigla");
		return;
	}
	var emplTraiAbbr = [orgaTraiAbbrPopu titleOfSelectedItem];
	var emplTraiDateLast = [emplTraiDateLastText stringValue];

	var quer = [CPString stringWithFormat:@"select abbreviation from %@.employeeTraining where personId='%@' and organizationId='%@' and abbreviation='%@'",dataBase,
		emplIden,emplTraiOrga,emplTraiAbbr];
	var arra = [self query:quer];
	var coun = [arra count];
	if ( coun > 0 ) {
		alert("La capacitación "+emplTraiAbbr+" de la organización "+emplTraiOrga+" ya fue registrada para el recurso "+emplIden+". Por favor verifique.");
		return;
	}

	quer = [CPString stringWithFormat:@"insert into %@.employeeTraining (personId,organizationId,abbreviation,dateLast) values (%@,'%@','%@','%@')",dataBase,
		emplIden,emplTraiOrga,emplTraiAbbr,emplTraiDateLast];
	[self query:quer];

	[emplTraiTabl reloadData];
}



- (void) employeeTrainingTableSelection:(id)sender {
	var inde = [emplTraiTabl selectedRow];
	if ( inde < 0 )
		return;

	var valuList = [emplTraiArra[inde] valueList];
	var emplTraiOrga = valuList[1];
	var emplTraiAbbr = valuList[2];
	var emplTraiDateLast = valuList[3];
	var orgaTraiDesc = valuList[4];
	var orgaTraiDateLast = valuList[5];
	var orgaTraiDateExpi = valuList[6];
	
	//[emplTraiOrgaText setStringValue:emplTraiOrga];
	[orgaPopu selectItemWithTitle:emplTraiOrga];
	//[emplTraiAbbrText setStringValue:emplTraiAbbr];
	[orgaTraiAbbrPopu selectItemWithTitle:emplTraiAbbr];
	[emplTraiDateLastText setStringValue:emplTraiDateLast];
	[orgaTraiDescText setStringValue:orgaTraiDesc];
	[orgaTraiDateLastText setStringValue:orgaTraiDateLast];
	[orgaTraiDateExpiText setStringValue:orgaTraiDateExpi];
	
	if ( emplTraiDateLast < orgaTraiDateLast )
		alert("Periodo de capacitación no es valido.");
		
	var date = [CPDate date];
	var dateStri = [[date description] substringToIndex:19];
	if ( dateStri > orgaTraiDateExpi )
		alert("Periodo de validez de la capacitación ya no es valido.");
}



- (void) employeeTrainingUpdate:(id)sender {
	var inde = [emplTraiTabl selectedRow];
	if ( inde < 0 )
		return;
	var emplTraiIden = [[emplTraiArra[inde] valueList] objectAtIndex:0];

	//var emplTraiAbbr = [emplTraiAbbrText stringValue];
	inde = [orgaTraiAbbrPopu indexOfSelectedItem];
	if ( inde < 1 ) {
		alert("Por favor seleccione la sigla");
		return;
	}
	var emplTraiAbbr = [orgaTraiAbbrPopu titleOfSelectedItem];

	var emplTraiDateLast = [emplTraiDateLastText stringValue];

	inde = [emplTabl selectedRow];
	if ( inde < 0 )
		return;
	var emplIden = [[emplArra[inde] valueList] objectAtIndex:0];

	inde = [orgaPopu indexOfSelectedItem];
	if ( inde < 1 )
		return;
	inde--;
	var emplTraiOrga = [[orgaArra[inde] valueList] objectAtIndex:0];

	var quer = [CPString stringWithFormat:@"select abbreviation from %@.employeeTraining where id!=%@ and personId='%@' and organizationId='%@' and abbreviation='%@'",dataBase,
		emplTraiIden,emplIden,emplTraiOrga,emplTraiAbbr];
	var arra = [self query:quer];
	var coun = [arra count];
	if ( coun > 0 ) {
		alert("La capacitación "+emplTraiAbbr+" de la organización "+emplTraiOrga+" ya fue registrada para el recurso "+emplIden+" con id="+emplTraiIden+". Por favor verifique.");
		return;
	}

	//var emplTraiOrga = [emplTraiOrgaText stringValue];
	inde = [orgaPopu indexOfSelectedItem];
	if ( inde < 1 )
		quer = [CPString stringWithFormat:@"update %@.employeeTraining set abbreviation='%@',dateLast='%@' where id=%@",dataBase,
			emplTraiAbbr,emplTraiDateLast,emplTraiIden];
	else {
		inde--;
		var emplTraiOrga = [[orgaArra[inde] valueList] objectAtIndex:0];
		quer = [CPString stringWithFormat:@"update %@.employeeTraining set organizationId='%@',abbreviation='%@',dateLast='%@' where id=%@",dataBase,
			emplTraiOrga,emplTraiAbbr,emplTraiDateLast,emplTraiIden];
	}

	[self query:quer];

	[emplTraiTabl reloadData];
}



// Employee Vacations

- (void) employeeVacationsClearFields:(id)sender {
	//[emplTraiOrgaText setStringValue:@""];
	[emplVacaStarText setStringValue:@""];
	[emplVacaFiniText setStringValue:@""];
}



- (void) employeeVacationsDelete:(id)sender {
	var inde = [emplVacaTabl selectedRow];
	if ( inde < 0 )
		return;

	var emplVacaIden = [[emplVacaArra[inde] valueList] objectAtIndex:0];
	
	var conf = confirm("Por favor confirme la eliminación del registro * "+emplVacaIden+" *");
	if ( conf ) {
		var quer = [CPString stringWithFormat:@"delete from %@.personVacations where id=%@",dataBase,emplVacaIden];
		[self query:quer];
		[emplVacaTabl reloadData];
	}
}



- (void) employeeVacationsInsert:(id)sender {
	var inde = [emplTabl selectedRow];
	if ( inde < 0 )
		return;

	var emplIden = [[emplArra[inde] valueList] objectAtIndex:0];

	var emplVacaStar = [emplVacaStarText stringValue];
	var emplVacaFini = [emplVacaFiniText stringValue];

	var quer = [CPString stringWithFormat:@"insert into %@.personVacations (personId,dateStart,dateFinish) values (%@,'%@ 00:00:00','%@ 23:59:59')",dataBase,
		emplIden,emplVacaStar,emplVacaFini];
	[self query:quer];

	[emplVacaTabl reloadData];
}



- (void) employeeVacationsTableSelection:(id)sender {
	var inde = [emplVacaTabl selectedRow];
	if ( inde < 0 )
		return;

	var valuList = [emplVacaArra[inde] valueList];
	var emplVacaStar = [valuList objectAtIndex:1];
	var emplVacaFini = [valuList objectAtIndex:2];
	
	[emplVacaStarText setStringValue:emplVacaStar];
	[emplVacaFiniText setStringValue:emplVacaFini];
}



- (void) employeeVacationsUpdate:(id)sender {
	var inde = [emplVacaTabl selectedRow];
	if ( inde < 0 )
		return;

	var emplVacaIden = [[emplVacaArra[inde] valueList] objectAtIndex:0];

	var emplVacaStar = [emplVacaStarText stringValue];
	var emplVacaFini = [emplVacaFiniText stringValue];

	var quer = [CPString stringWithFormat:@"update %@.personVacations set dateStart='%@',dateFinish='%@' where id=%@",dataBase,
		emplVacaStar,emplVacaFini,emplVacaIden];
	[self query:quer];

	[emplVacaTabl reloadData];
}




// Equipment ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

- (void)  equipmentClearFields:(id)sender{
	[equiIden0Text 		setStringValue:@""]
	[equiIden1Text 		setStringValue:@""]
	[equiIden2Text 		setStringValue:@""]
	[equiLawIdenText 	setStringValue:@""]
	[equiMakeText 		setStringValue:@""]
	[equiModeText 		setStringValue:@""]
	[equiYearText 		setStringValue:@""]
	[equiTypeText 		setStringValue:@""]
	[equiPassCounText 	setStringValue:@""]
	[equiRestText 		setStringValue:@""]
	[equiNoteText 		setStringValue:@""]
	[equiPassCounText 	setStringValue:@""];
    [equiActiChec 		setState:0]
}



- (void) equipmentDelete:(id)sender {
	var inde = [equiTabl selectedRow];
	if ( inde < 0 )
		return;

	var valuList = [equiArra[inde] valueList];
	var iden = valuList[0];

	var conf = confirm("Quiere eliminar el equipo con codigo "+iden+" ?");
	if ( ! conf )
		return;

	var quer = [CPString stringWithFormat:@"delete from %@.equipment where id0=%@",dataBase,iden];
	[self query:quer];

	[equiTabl reloadData];
}



- (void) equipmentInsert:(id)sender {
	var equiIden0 = [equiIden0Text stringValue];
	var equiIden1 = [equiIden1Text stringValue];
	var equiIden2 = [equiIden2Text stringValue];
	var equiLawIden = [equiLawIdenText stringValue];
	var equiMake = [equiMakeText stringValue];
	var equiMode = [equiModeText stringValue];
	var equiYear = [equiYearText stringValue];
	var equiType = [equiTypeText stringValue];
	var equiPassCoun = [equiPassCounText stringValue];
	var equiRest = [equiRestText stringValue];
	var equiNote = [equiNoteText stringValue];
    var equiActi = [equiActiChec state];

	//@"select id0,id1,id2,lawId,make,model,year,type,passengerCount,restriction,notes,active from db.equipment"];

	var quer = [CPString stringWithFormat:@"select count(*) from %@.equipment where (id1='%@' or id2='%@' or lawId='%@') and organizationId='%@'",dataBase,
		equiIden1,equiIden2,equiLawIden,orgaCode];
	var resp = [self query:quer];
	
	var respCoun = [[[resp[0] valueList] objectAtIndex:0] intValue];
	if ( respCoun == 0 ) {
		var quer = [CPString stringWithFormat:@"insert into %@.equipment (id1,id2,lawId,make,model,year,type,passengerCount,restriction,notes,active,organizationId) values ('%@','%@','%@','%@','%@','%@','%@','%@','%@','%@','%@','%@')",
			dataBase,equiIden1,equiIden2,equiLawIden,equiMake,equiMode,equiYear,equiType,equiPassCoun,equiRest,equiNote,equiActi,orgaCode];
		[self query:quer];
	}
	else {
		var mess = [CPString stringWithFormat:@"Error: ya existe un equipo con un identificador utilizado (id1='%@' o id2='%@' o placa='%@')",
			equiIden1,equiIden2,equiLawIden];
		alert(mess);
	}

	[equiTabl reloadData];
}



- (void) equipmentTableSelection:(id)sender {
	var inde = [equiTabl selectedRow];
	if ( inde < 0 )
		return;

	var valuList = [[equiArra objectAtIndex:inde] valueList];
	[equiIden0Text		setStringValue:valuList[0]];
	[equiIden1Text 		setStringValue:valuList[1]];
	[equiIden2Text 		setStringValue:valuList[2]];
	[equiLawIdenText	setStringValue:valuList[3]];
	[equiMakeText		setStringValue:valuList[4]];
	[equiModeText		setStringValue:valuList[5]];
	[equiYearText		setStringValue:valuList[6]];
	[equiTypeText		setStringValue:valuList[7]];
	[equiPassCounText	setStringValue:valuList[8]];
	[equiRestText		setStringValue:valuList[9]];
	[equiNoteText		setStringValue:valuList[10]];
    [equiActiChec		setState:[valuList[11] intValue]];
}



- (void) equipmentUpdate:(id)sender {
	var inde = [equiTabl selectedRow];
	if ( inde < 0 )
		return;

	var equiIden0 = [equiIden0Text stringValue];
	var equiIden1 = [equiIden1Text stringValue];
	var equiIden2 = [equiIden2Text stringValue];
	var equiLawIden = [equiLawIdenText stringValue];
	var equiMake = [equiMakeText stringValue];
	var equiMode = [equiModeText stringValue];
	var equiYear = [equiYearText stringValue];
	var equiType = [equiTypeText stringValue];
	var equiPassCoun = [equiPassCounText stringValue];
	var equiRest = [equiRestText stringValue];
	var equiNote = [equiNoteText stringValue];
    var equiActi = [equiActiChec state];

	//@"select id0,id1,id2,lawId,make,model,year,type,passengerCount,restriction,notes,active from db.equipment"];

	var quer = [CPString stringWithFormat:@"update %@.equipment set id1='%@',id2='%@',lawId='%@',make='%@',model='%@',year=%@,type='%@',passengerCount=%@,restriction='%@',notes='%@',active=%@,organizationId='%@' where id0=%@",
		dataBase,equiIden1,equiIden2,equiLawIden,equiMake,equiMode,equiYear,equiType,equiPassCoun,equiRest,equiNote,equiActi,orgaCode,equiIden0];

	[self query:quer];
	
	[equiTabl reloadData];
}



// Holidays

- (void) holidaysClearFields:(id)sender {
	[holiDateStarText setStringValue:@""];
	[holiDateFiniText setStringValue:@""];
	[holiDescText setStringValue:@""];
}



- (void) holidaysDelete:(id)sender {
	var inde = [holiTabl selectedRow];
	if ( inde < 0 )
		return;
	var iden = [[holiArra[inde] valueList] objectAtIndex:0];
	var orgaIden = [[holiArra[inde] valueList] objectAtIndex:1];

	var conf = confirm("Quiere eliminar el feriado * "+name+" * de la organizacion * "+orgaIden+" * con codigo "+iden+" ?");
	if ( ! conf )
		return;

	var quer = [CPString stringWithFormat:@"delete from %@.organizationHolidays where id=%@",dataBase,iden];
	[self query:quer];

	[holiTabl reloadData];
	
	[self holidaysClearFields:0];
}



- (void) holidaysInsert:(id)sender {
	var holiDateStar = [holiDateStarText  stringValue];
	var holiDateFini = [holiDateFiniText  stringValue];
	var holiDesc = [holiDescText  stringValue];

	var quer = [CPString stringWithFormat:@"insert into %@.organizationHolidays (organizationId,dateStart,dateFinish,description) values ('%@','%@','%@','%@')",
		dataBase,orgaCode,holiDateStar,holiDateFini,holiDesc];
	[self query:quer];

	[holiTabl reloadData];
}



- (void) holidaysTableSelection:(id)sender {
	var inde = [holiTabl selectedRow];
	if ( inde < 0 )
		return;

	var valuList = [holiArra[inde] valueList];
	var holiDateStar = [valuList objectAtIndex:1];
	var holiDateFini = [valuList objectAtIndex:2];
	var holiDesc = [valuList objectAtIndex:3];
	
	[holiDateStarText setStringValue:holiDateStar];
	[holiDateFiniText setStringValue:holiDateFini];
	[holiDescText setStringValue:holiDesc];
}



- (void) holidaysUpdate:(id)sender {
	var inde = [holiTabl selectedRow];
	if ( inde < 0 )
		return;
	var valuList = [holiArra[inde] valueList];
	var iden = valuList[0];

	var holiDateStar = [holiDateStarText  stringValue];
	var holiDateFini = [holiDateFiniText  stringValue];
	var holiDesc = [holiDescText  stringValue];

	var quer = [CPString stringWithFormat:@"update %@.organizationHolidays set dateStart='%@',dateFinish='%@',description='%@' where id=%@",
		dataBase,holiDateStar,holiDateFini,holiDesc,iden];

	[self query:quer];

	[holiTabl reloadData];
}



- (void) organizationPopupSelection:(id)sender {
	var inde = [orgaPopu indexOfSelectedItem];
	if ( inde < 1 )
		return;

	inde--;
	var orgaIden = [[orgaArra[inde] valueList] objectAtIndex:0];
	var quer = [CPString stringWithFormat:@"select abbreviation from %@.organizationTraining where organizationId='%@' order by abbreviation",
		dataBase,orgaIden];
	var orgaTraiAbbrArra= [self query:quer];
	var coun = [orgaTraiAbbrArra count];

	[orgaTraiAbbrPopu removeAllItems];
	[orgaTraiAbbrPopu addItemWithTitle:@"Siglas"];
	for ( var i=0; i<coun; i++ ) {
		var valuList = [orgaTraiAbbrArra[i] valueList];
		var abbr = valuList[0];
		[orgaTraiAbbrPopu addItemWithTitle:abbr];
	}

	[emplTraiTabl reloadData];
}



- (void) organizationTrainingAbbreviationPopupSelection:(id)sender {
}



//		TAB SOURCE DELEGATE METHODS


- (void) tabView:(CPTabView)tabView willSelectTabViewItem:(CPTabViewItem)tabViewItem {
        var tabIden = [tabViewItem identifier];

        if ( [tabIden isEqualToString:@"activities"]) {
        	[actiTabl reloadData];
        }
        else if ( [tabIden isEqualToString:@"equipment"]) {
        	[equiTabl reloadData];
        }
        else if ( [tabIden isEqualToString:@"holidays"]) {
        	[holiTabl reloadData];
        }
        else if ( [tabIden isEqualToString:@"personnel"]) {
        	[emplTabl reloadData];
        }
}



//		TABLE SOURCE DELEGATE METHODS

- (int) numberOfRowsInTableView:(CPTableView)tablView {
	var coun= 0;
	var quer;
	if ( tablView == actiTabl ) {
		quer = @"select id,description,duration,price,active from " + dataBase + ".organizationActivities order by description";
		actiArra = [self query:quer];
		coun= [actiArra count];
	}
	else if ( tablView == emplTabl ) {
		quer = [CPString stringWithFormat:@"select t1.id,t1.lawId,t1.nameLast,t1.nameFirst,t2.position,t1.homeAddressStreet,t1.homeAddressCity,t1.homeAddressState,t1.phone1,t1.phone2,t1.email,t1.notes,t2.active from %@.persons t1, %@.organizationPersons t2 where t2.organizationId='%@' and t1.id=t2.personId order by t1.nameLast,t1.nameFirst",
			dataBase,dataBase,orgaCode];
		emplArra= [self query:quer];
		//alert ("quer =" + quer);
		coun= [emplArra count];
	}
	else if ( tablView == emplEquiTabl ) {
		var inde = [emplTabl selectedRow];
		if ( inde < 0 )
			return 0;
		var emplIden = [[emplArra[inde] valueList] objectAtIndex:0];
		quer = [CPString stringWithFormat:@"select t1.id,t1.equipmentId,t2.make,t2.model,t2.year,t2.id1 from %@.personEquipment t1, %@.equipment t2 where t1.personId=%@ and t2.id0=t1.equipmentId order by t2.make,t2.model,t2.description,t2.id0",dataBase,dataBase,emplIden];
		emplEquiArra = [self query:quer];
		coun= [emplEquiArra count];
	}
	else if ( tablView == emplTraiTabl ) {
		var inde = [emplTabl selectedRow];
		if ( inde < 0 )
			return 0;
		var emplIden = [[emplArra[inde] valueList] objectAtIndex:0];
		inde = [orgaPopu indexOfSelectedItem];
		var orgaCond = @"";
		if ( inde > 0 ) {
			inde--;
			orgaCond = [CPString stringWithFormat:@"and t1.organizationId='%@'",[[orgaArra[inde] valueList] objectAtIndex:0]];
		}
		quer = [CPString stringWithFormat:@"select t1.id,t1.organizationId,t1.abbreviation,t1.dateLast,t2.description,t2.dateLast,t2.dateExpiration from %@.employeeTraining t1, %@.organizationTraining t2 where t1.organizationId=t2.organizationId and t1.abbreviation=t2.abbreviation and personId=%@ %@ order by organizationId,abbreviation",
			dataBase,dataBase,emplIden,orgaCond];
		emplTraiArra = [self query:quer];
		coun= [emplTraiArra count];
	}
	else if ( tablView == emplVacaTabl ) {
		var inde = [emplTabl selectedRow];
		if ( inde < 0 )
			return 0;
		var emplIden = [[emplArra[inde] valueList] objectAtIndex:0];
		quer = [CPString stringWithFormat:@"select id,dateStart,dateFinish from %@.personVacations where personId=%@ order by dateStart,dateFinish",dataBase,emplIden];
		emplVacaArra= [self query:quer];
		coun= [emplVacaArra count];
	}
	else if ( tablView == equiTabl ) {
		quer = [CPString stringWithFormat:@"select id0,id1,id2,lawId,make,model,year,type,passengerCount,restriction,notes,active from %@.equipment where organizationId='%@'",dataBase,orgaCode];
		equiArra = [self query:quer];
		coun = [equiArra count];
		
		[emplEquiPopu removeAllItems];
		for ( var i=0; i<coun; i++ ) {
			var valuList = [equiArra[i] valueList];
			[emplEquiPopu addItemWithTitle:[CPString stringWithFormat:@"%@_%@_%@_%@",
				valuList[4],valuList[5],valuList[6],valuList[1]]];
		}

	}
	else if ( tablView == holiTabl ) {
		quer = [CPString stringWithFormat:@"select id,dateStart,dateFinish,description from %@.organizationHolidays where organizationId='%@' order by dateStart",dataBase,orgaCode];
		holiArra = [self query:quer];
		coun= [holiArra count];
	}
	
	return coun;
}




- (id) tableView:(CPTableView)tablView objectValueForTableColumn:(CPTableColumn)tablColu row:(int)rowInde {
	var headStri= [[tablColu headerView] stringValue];
	var headIden= [tablColu identifier];
	var valu= @"N/A";

	if ( tablView == actiTabl ) {
		var arra = [[actiArra objectAtIndex:rowInde] valueList];
		if ( [headStri isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headStri isEqualToString:@"Descripcion"] )
			valu= arra[1];
		else if ( [headStri isEqualToString:@"Duracion"] )
			valu= arra[2];
		else if ( [headStri isEqualToString:@"Precio"] )
			valu= arra[3];
	}
	else if ( tablView == emplTabl ) {
		var arra = [[emplArra objectAtIndex:rowInde] valueList];
		if ( [headStri isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headStri isEqualToString:@"Cedula"] )
			valu= arra[1];
		else if ( [headStri isEqualToString:@"Apellidos"] )
			valu= arra[2];
		else if ( [headStri isEqualToString:@"Nombre"] )
			valu= arra[3];
		else if ( [headStri isEqualToString:@"Posicion"] )
			valu= arra[4];
		else if ( [headStri isEqualToString:@"Telefono1"] )
			valu= arra[8];
		else if ( [headStri isEqualToString:@"Telefono2"] )
			valu= arra[9];
		else if ( [headStri isEqualToString:@"Correo"] )
			valu= arra[10];
		else if ( [headStri isEqualToString:@"Comentarios"] )
			valu= arra[11];
	}
	else if ( tablView == emplEquiTabl ) {
		var arra = [emplEquiArra[rowInde] valueList];
		if ( [headIden isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headIden isEqualToString:@"EquipoID"] )
			valu= arra[1];
		else if ( [headIden isEqualToString:@"Description"] )
			valu= [CPString stringWithFormat:@"%@_%@_%@_%@",arra[2],arra[3],arra[4],arra[5]];
	}
	else if ( tablView == emplTraiTabl ) {
		var arra = [emplTraiArra[rowInde] valueList];
		if ( [headIden isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headIden isEqualToString:@"Organization"] )
			valu= arra[1];
		else if ( [headIden isEqualToString:@"Abbreviation"] )
			valu= arra[2];
	}
	else if ( tablView == equiTabl ) {
		var arra = [[equiArra objectAtIndex:rowInde] valueList];
		if ( [headStri isEqualToString:@"ID0"] )
			valu= arra[0];
		else if ( [headStri isEqualToString:@"ID1"] )
			valu= arra[1];
		else if ( [headStri isEqualToString:@"ID2"] )
			valu= arra[2];
		else if ( [headStri isEqualToString:@"Placa"] )
			valu= arra[3];
		else if ( [headStri isEqualToString:@"Marca"] )
			valu= arra[4];
		else if ( [headStri isEqualToString:@"Modelo"] )
			valu= arra[5];
		else if ( [headStri isEqualToString:@"Año"] )
			valu= arra[6];
		else if ( [headStri isEqualToString:@"Tipo"] )
			valu= arra[7];
		else if ( [headStri isEqualToString:@"Espacios"] )
			valu= arra[8];
		else if ( [headStri isEqualToString:@"Restriccion"] )
			valu= arra[9];
		else if ( [headStri isEqualToString:@"Comentarios"] )
			valu= arra[10];
		else if ( [headStri isEqualToString:@"Activo"] )
			valu= arra[11];
	}
	else if ( tablView == emplVacaTabl ) {
		var arra = [emplVacaArra[rowInde] valueList];
		if ( [headIden isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headIden isEqualToString:@"DateStart"] )
			valu= arra[1];
		else if ( [headIden isEqualToString:@"DateFinish"] )
			valu= arra[2];
	}
	else if ( tablView == holiTabl ) {
		var arra = [[holiArra objectAtIndex:rowInde] valueList];
		if ( [headStri isEqualToString:@"ID"] )
			valu= arra[0];
		else if ( [headStri isEqualToString:@"FechaInicio"] )
			valu= arra[1];
		else if ( [headStri isEqualToString:@"FechaFin"] )
			valu= arra[2];
		else if ( [headStri isEqualToString:@"Descripcion"] )
			valu= arra[3];
	}
	/*
	*/
	console.log(valu);
	return valu;
}



@end
