<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Administrators extends CI_Controller {

	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el correcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		$this->lang->load('spanish_lang','spanish');
		$this->load->model('User_model');
	}

	/**
	** Función  que se encarga de cargar la vista de administradores en el módulo administrador.
	**/
	public function index()
	{

        //Verifica si hay una sesión iniciada, de lo contrario lo redirecciona al login para que se registre.
        $isAdministrator = $this->session->userdata('isAdministrator');
        if(isset($isAdministrator)){
            if(!$isAdministrator){
                redirect(site_url('Client/Main'));
            }else{
                $rol = $this->session->userdata('rol');
                if($rol != 1){
                    redirect(site_url('Administrator/Upload'));
                }
            }
        }else{
            redirect(site_url());
        }


		//Titulo a mostrar en la pestaña del navegador.
		$data['title'] =  $this->lang->line('aTitle_Admins');
		//Se carga la vista indicada y se le pasa la información para que pueda se utilizada desde la vista.
		return $this->load->view('Administrator/administrators',$data);
	}

	/**
	** Función  que se encarga de retornar todos los usuarios que sean administradores en el sistema.
	**/
	public function getAllAdmins()
	{
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            //Obtiene a los administradores
            $result = $this->User_model->getAllUsers(1);
            //Verifica si el resultado esta vacio( no hay administradores registrados)
            if ($result) {
                //Se envia la respuesta en formato JSON.
                echo json_encode($result->result());
            } else {
                echo json_encode(new stdClass);
            }
        }
		 
	}

	/**
	** Función  que se encarga de insertar(registrar) un administrador en el sistema.
	** Retorna 1 si se insertó correctamente y 0 si el nombre de usuario ya esta ocupado.
	**/
	public function insertAdmin()
	{
		//Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
		if(!$this->input->is_ajax_request()){
			redirect('404');
		}else{
			//Obtiene los datos del administrador ingresado.
			$admin = $this->input->post('user');
			//Verifica si el nombre de usuario ingresado esta disponible.
			if($this->User_model->isAvailable($admin,true))
			{
				//Encripta con md5 la contraseña ingresada.
				//$admin['password'] = md5($admin['password']);
				//Administrador de bajo nivel
                $admin['fkRoleId'] = 2;
				//Inserta el administrador.
				$this->User_model->insertUser($admin,true);
				//Todo salio bien.
				echo 1;
			}else{
				//El nombre de usuario ya esta ocupado.
				echo 0;
			}
		}
	}

	/**
	** Función  que se encarga de actualizar(modificar) un administrador en el sistema.
	** Retorna 1 si se inserto correctamente y 0 si el nombre de usuario ya esta ocupado.
	**/
	public function updateAdmin()
	{
		//Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
		if(!$this->input->is_ajax_request()){
			redirect('404');
		}else{
			//Obtiene los datos actualizados del administrador ingresado.
			$admin = $this->input->post('user');
			//Verifica si el nombre de usuario ingresado esta disponible.
			if($this->User_model->isAvailable($admin,true))
			{

                //Elimina la contraseña si viene vacia.
                if(strcmp($admin['password'],"")==0){
                    unset($admin['password']);
                }
                //else{
                    //$admin['password'] = md5($admin['password']);
               //}

				//Actualiza el administrador
				$this->User_model->updateUser($admin,true);
				//Todo salio bien
			 	echo 1;
			}else{
				//El nombre de usuario ya esta ocupado.
				echo 0;
			}
		}
	}

    /**
     ** Función que se encarga de eliminar un administrador.
     **/
    public function deleteAdmin()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else{
            //Obtiene el usuario a eliminar.
            $admin = $this->input->post('user');
            //Elimina el usuario
            $this->User_model->deleteUser($admin['idUser'],1);

        }
    }



}