<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Clients extends CI_Controller {

	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el correcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		$this->lang->load('spanish_lang','spanish');
		$this->load->model('User_model');
        $this->load->model('Organization_model');
	}

	/**
	** Función  que se encarga de cargar la vista de clientes en el módulo administrador.
	**/
	public function index()
	{
        //Verifica si hay una sesión iniciada, de lo contrario lo redirecciona al login para que se registre.
        $isAdministrator = $this->session->userdata('isAdministrator');
        if(isset($isAdministrator)){
            if(!$isAdministrator){
                redirect(site_url('Client/Main'));
            }
        }else{
            redirect(site_url());
        }


		//Titulo a mostrar en la pestaña del navegador.
		$data['title'] =  $this->lang->line('aTitle_Clients');
        $result = $this->Organization_model->getAllOrganizations();
        if($result){
            $data['organizations'] = $result->result();
        }else{
            $data['organizations'] = array();
        }
		//Se carga la vista indicada y se le pasa la información para que pueda se utilizada desde la vista.
		return $this->load->view('Administrator/clients',$data);
	}

	/**
	** Función  que se encarga de retornar todos los usuarios que sean clientes en el sistema.
	**/
	public function getAllClients()
	{
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            //Obtiene a los clientes
            $result = $this->User_model->getAllUsers();
            //Verifica si el resultado esta vacio( no hay clientes registrados)
            if ($result) {
                //Recorre los resultados.
                foreach ($result->result() as $row) {
                    //Cambia isActive de un entero a un booleano
                    $row->isActive = (bool)$row->isActive;
                    //Verifica si el nombre de la organización viene vacío, de ser asi se le asigna el nombre legal
                    if (strcmp($row->Name, "") == 0) {
                        $row->Name = $row->NameLegal;
                    }
                    //Obtenemos las localizaciones del cliente actual
                    $locations = $this->User_model->getAllLocationsByClient($row->id);
                    //Si hay locaciones asociadas
                    if($locations){
                        //Array para almacenar los id de las locaciones
                        $locationIds = array();
                        //Variable para almacenar el texto a mostrar
                        $text ="";
                        //Se recorren las locaciones
                        foreach ($locations->result() as $location ){
                            //Se guarda el id en el arreglo de id
                            array_push($locationIds,$location->Id);
                            //Se concatena el nombre de la locación al texto a mostrar
                            $text.=$location->Name.", ";

                        }
                        //Se elimina el espacio y como final
                        $text = substr($text,0,strlen ($text)-2);
                        //Texto completo
                        $row->locationsName = $text;
                        $row->locationsId = $locationIds;
                        //Se verifica si el tamaño del texto es el adecuado para su visualización.
                        if($row->isGlobal == 1){
                            $row->text = $this->lang->line('all');
                        }else{
                            if(strlen($text)>40){
                            //Si no lo es, se corta para que se muestre correctamente
                            $row->text = substr($text,0,40)."...";
                        }else{
                            //Si lo es, se deja tal y como esta.
                            $row->text = $text;
                        }
                        }
                    }else{
                        $row->locationsName =  $this->lang->line('all');
                        $row->text = $this->lang->line('all');
                    }
                }
                //Se envia la respuesta en formato JSON.
                echo json_encode($result->result());

            } else {
                //Se envía una respuesta vacia.
                echo json_encode(new stdClass);
            }
        }
	}

	/**
	** Función  que se encarga de insertar(registrar) un cliente en el sistema.
	** Retorna 1 si se inserto correctamente y 0 si el nombre de usuario ya esta ocupado.
	**/
	public function insertClient()
	{
		//Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
		if(!$this->input->is_ajax_request()){
			redirect('404');
		}else{
			//Obtiene los datos del cliente ingresado.
			$client = $this->input->post('user');
			//Verifica si el nombre de usuario ingresado esta disponible.
			if($this->User_model->isAvailable($client))
			{
				//Encripta con md5 la contraseña ingresada.
				//$client['password'] = md5($client['password']);
				//Inserta el cliente.
				$id = $this->User_model->insertUser($client);
                //Obtiene las locaciones
                $locations = $this->input->post('locations');
                if(count($locations) > 0){
                    //Arreglo con el conjunto de datos a insertar
                    $data = array();
                    //Se recorren las locaciones
                    foreach ($locations as $location){
                        //Registro, relaciona un cliente con una locación
                        $row = array(
                            'idLocation'=>(int)$location,
                            'idClient'=>(int)$id
                        );
                        //Lo agrega al arreglo
                        array_push($data,$row);
                    }
                    //Se insertan esas relaciones a la base de datos
                    $this->User_model->assignUserLocation($data);
                }
				//Todo salio bien.
				echo 1;
			}else{
				//El nombre de usuario ya esta ocupado.
				echo 0;
			}
		}
	}

	/**
	** Función  que se encarga de actualizar(modificar) un cliente en el sistema.
	** Retorna 1 si se inserto correctamente y 0 si el nombre de usuario ya esta ocupado.
	**/
	public function updateClient()
	{
		//Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
		if(!$this->input->is_ajax_request()){
			redirect('404');
		}else{
			//Obtiene los datos actuaizados del cliente ingresado.
			$client = $this->input->post('user');
			//Verifica si el nombre de usuario ingresado esta disponible.
			if($this->User_model->isAvailable($client))
			{
				//Elimina la contraseña(Si esta viene vacia) y la informacion acerca del nombre de la organización
                // y las locaciones.
                if(strcmp($client['password'],"")==0){
                    unset($client['password']);
                }
                //else{
                  //  $client['password'] = md5($client['password']);
                //}
                unset($client['Name']);
                unset($client['NameLegal']);
                unset($client['locationsName']);
                unset($client['locationsId']);
                unset($client['text']);

				//Conversión de formato para ingresar a la base de datos.
				$client['isActive'] = (int)($client['isActive']);
				//Si se actualiza si esta activo o no, se coloca o borra la fecha de inactividad
				if($client['isActive'] == 0){
                    $client['inactiveDate'] = date('Y-m-d');
                }else{
                    $client['inactiveDate'] = null;
                }
				//Actualiza el cliente

				$this->User_model->updateUser($client);
                //Se eliminan las asociaciones con locaciones existentes
                $this->User_model->deleteAssignUserLocation($client['id']);

                //Obtiene las locaciones
                $locations = $this->input->post('locations');
                if(count($locations) > 0){
                    //Arreglo con el conjunto de datos a insertar
                    $data = array();
                    //Se recorren las locaciones
                    foreach ($locations as $location){
                        //Registro, relaciona un cliente con una locación
                        $row = array(
                            'idLocation'=>(int)$location,
                            'idClient'=>(int)$client['id']
                        );
                        //Lo agrega al arreglo
                        array_push($data,$row);
                    }
                    //Se insertan esas relaciones a la base de datos
                    $this->User_model->assignUserLocation($data);
                }
				//Todo salio bien
			 	echo 1;
			}else{
				//El nombre de usuario ya esta ocupado.
				echo 0;
			}
		}
	}
	
	    /**
     ** Función que se encarga de eliminar un cliente.
     **/
    public function deleteClient()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else{
            //Obtiene el usuario a eliminar.
            $client = $this->input->post('user');
            //Elimina el usuario
            $this->User_model->deleteUser($client['id']);

        }
    }
}