<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Files extends CI_Controller {

	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el correcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		$this->lang->load('spanish_lang','spanish');
		$this->load->model('Organization_model');
        $this->load->model('Structure_model');
	}

	/**
	** Función  que se encarga de cargar la vista de archivos en el módulo administrador.
	**/
	public function index()
	{

        //Verifica si hay una sesión iniciada, de lo contrario lo redirecciona al login para que se registre.
        $isAdministrator = $this->session->userdata('isAdministrator');
        if(isset($isAdministrator)){
            if(!$isAdministrator){
                redirect(site_url('Client/Main'));
            }
        }else{
            redirect(site_url(''));
        }


		//Titulo a mostrar en la pestaña del navegador.
		$data['title'] =  $this->lang->line('aTitle_Files');

        $result = $this->Organization_model->getAllOrganizations();
        if($result){
            $data['organizations'] = $result->result();
        }
		//Se carga la vista indicada y se le pasa la información para que pueda se utilizada desde la vista.
		return $this->load->view('Administrator/files',$data);
	}

    /**
     ** Función  que se encarga de retornar todas las locaciones de una organización.

     **/
    public function getLocations()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            //Se repuera la organización
            $organization = $this->input->post('organization');
            $file = $this->input->post('file');
            //Obtienen las locaciones
            $result = $this->Organization_model->getLocations($organization);
            if(isset($file)){
                if($file != false){
                    $resultRelation = $this->Structure_model->getFolder_locations($file,$organization);
                 if ($resultRelation) {
                    foreach ($result->result() as $row){
                        $found =false;
                        foreach ($resultRelation->result() as $row2){
                            if($row->Id == $row2->idLocation){
                                $found = true;
                            }
                        }
                        if($found){
                            $row->checked = true;
                        }else{
                           $row->checked = false; 
                        }
                    }
                }
                }
            }
            //Verifica si el resultado esta vacio(la organización seleccionada no tiene locaciones)
            if ($result) {
                //Se envia la respuesta en formato JSON.
                echo json_encode($result->result());
            } else {
                //Se envia un json vacío
                echo json_encode(new stdClass);
            }
        }

    }
    
    
    /**
     ** Función que se encarga de retornar todas las organizaciones.

     **/
    public function getOrganizations()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            
            $file = $this->input->post('file');
            //Se recupera el id del archivo
            
            $resultRelation = $this->Structure_model->getFolder_locations($file);
            
            //Obtienen las organizaciones
            $result = $this->Organization_model->getAllOrganizations();
            //Verifica si el resultado esta vacio
            if ($result) {
                //Se envia la respuesta en formato JSON.
                 if ($resultRelation) {
                    foreach ($result->result() as $row){
                        $found =false;
                        foreach ($resultRelation->result() as $row2){
                            if($row->idPrimary == $row2->idOrganization){
                                $found = true;
                                break;
                            }
                        }
                        if($found){
                            $row->checked = true;
                        }else{
                           $row->checked = false; 
                        }
                    }
                }
                echo json_encode($result->result());
            }else {
                //Se envia un json vacío
                echo json_encode(new stdClass);
            }
        }

    }

	/**
	** Función  que se encarga de retornar todos los archivos de una organización o locación.
	**/
	public function getAllFiles()
	{
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            //Obtenemos la organización
            $organization = $this->input->post('organization');
            //Obtenemos la locación
            $location= $this->input->post('location');
            //Obtiene los archivos correspondientes con los parámetros ingresados
            $result = $this->Structure_model->getFilesByLocation($organization,$location);
            //Verifica si el resultado esta vacio(no hay archivos asociados a la locación u organización)
            if ($result) {
                //Se recorren los resultados
               foreach ($result->result() as $row){
                   //Se cambia validity de entero a booleano para su visualización
                  $row->validity = (bool)$row->validity;
                      //Se verifica si el nombre tiene el tamaño adecuado para su visualización
                   if(strlen($row->Name)>60){
                       //De no ser así, lo corta.
                       $row->text = substr($row->Name,0,60)."...";
                   }else{
                       //De ser adecuado el tamaño se deja tal y como esta.
                       $row->text = $row->Name;
                   }
                   //echo "HOLA2";
                   //Verifica si es público

                  //Se verifica si el archivo pertenece a alguna organización en su totalidad
                  if(is_null($row->Organization)){
                    if(is_null($row->Location)){
                        $row->Location = $this->lang->line('all');
                    }
                  }else{
                      if(strlen($row->Organization) < 1){
                          $row->Location = $row->OrganizationName;
                      }else{
                          $row->Location = $row->Organization;
                      }
                  }
                  
                  if(strlen($row->Location)>60){
                       //De no ser así, lo corta.
                       $row->textLocation = substr($row->Location,0,60)."...";
                   }else{
                       //De ser adecuado el tamaño se deja tal y como esta.
                       $row->textLocation = $row->Location;
                   }
                  
               }
                //var_dump($result->result());
                //Se envia la respuesta en formato JSON.
                echo json_encode($result->result());
            } else {
                //Se envia un json vacío.
                echo json_encode(new stdClass);
            }
        }
	}

	/**
	** Función  que se encarga de actualizar(Solo la validéz) un archivo en el sistema.
	**/
	public function updateFile()
	{
		//Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
		if(!$this->input->is_ajax_request()){
			redirect('404');
		}else{
			//Obtiene los datos actualizados del archivo ingresado.
			$file = $this->input->post('file');
			//Se convierte a entero validity para su almacenamiento.
			$file['validity'] = (int)$file['validity'];
			$file['id'] = $file['Id'];//Se renombra key para su ingreso en bases de datos.
            //Se eliminan los datos que no se van a actualizar.
			unset($file['Id']);
            unset($file['Name']);
            unset($file['Location']);
            unset($file['creationDate']);
            unset($file['text']);
            unset($file['Organization']);
            unset($file['OrganizationName']);
            unset($file['textLocation']);
            //Actualiza el archivo
			$this->Structure_model->updateFile($file);

		}
	}

    /**
     ** Función que se encarga de eliminar un archivo.
     **/
    public function deleteFile()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else{
            //Obtiene el archivo a eliminar.
            $file = $this->input->post('file');

            //Se procede a elimianr el archivo
            $this->Structure_model->deleteFile($file['Id']);

        }
    }



}