<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 *
*                                   !!!!!!!!!!!!!IMPORTANTE!!!!!!!!!!!!
 *
 *
 * Para que el proyecto funcione correctamente con las estructuras en la tabla type_folder deben existir los siguientes registros:
 *
 *      id              name
 *
 *      1               Categoria
 *      2               SubCategoria
 *      3               Carpeta
 */

class Structures extends CI_Controller {

	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el correcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		$this->lang->load('spanish_lang','spanish');
        $this->load->model('Structure_model');
        $this->load->model('Organization_model');
        //$this->load->library('ftp');
	}

	/**
	** Función  que se encarga de cargar la vista de estructuras en el módulo administrador.
	**/
	public function index()
	{
        //Verifica si hay una sesión iniciada, de lo contrario lo redirecciona al login para que se registre.
        $isAdministrator = $this->session->userdata('isAdministrator');
        if(isset($isAdministrator)){
            if(!$isAdministrator){
                redirect(site_url('Client/Main'));
            }
        }else{
            redirect(site_url(''));
        }


		//Titulo a mostrar en la pestaña del navegador.
		$data['title'] =  $this->lang->line('aTitle_Structures');
		//Contenido a utilizar en la vista.
        $data['content'] = $this->session->userdata('username');
        //Se cargan las organizaciones
        $result = $this->Organization_model->getAllOrganizations();
        if($result){
            $data['organizations'] = $result->result();
        }
		//Se carga la vista indicada y se le pasa la información para que pueda se utilizada desde la vista.
		return $this->load->view('Administrator/structures',$data);
	}

    /**
     ** Función  que se encarga de crear una carpeta en el servidor FTP.
     ** Params:
     **     $path: Ruta de la carpeta a crear.
     **/
     private function createFolderFTP($path){
        //Configuración de la conexión al servidor FTP
        $config['hostname'] = 'localhost';
        $config['username'] = 'daemon';
        $config['password'] = 'xampp';
        $config['debug']        = TRUE;
        //Se crea la conexión
        $this->ftp->connect($config);
        //Se crea la carpeta
        $this->ftp->mkdir($path);
        //Se cierra la conexión
        $this->ftp->close();
    }
    /**
     ** Función  que se encarga de eliminar una carpeta en el servidor FTP junto con su contenido.
     ** Params:
     **     $path: Ruta de la carpeta a crear.
     **/
    private function deleteFolderFTP($path){

        //Configuración de la conexión al servidor FTP
        $config['hostname'] = 'localhost';
        $config['username'] = 'daemon';
        $config['password'] = 'xampp';
        $config['debug']        = TRUE;
        //Se crea la conexión
        $this->ftp->connect($config);
        //Se elimina la carpeta y su contenido
        $this->ftp->delete_dir($path);
        //Se cierra la conexión
        $this->ftp->close();
    }

	/**
	** Función  que se encarga de retornar la estructura jerarquica de carpetas del sistema.
	**/
	public function getStructureTree()
	{
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            //Se verifica si se van a gestionar estructuras o subir algún archivo.
            $upload = $this->input->post('upload');
             //Se recupera la locación del cual se quieren ver los archivos
            $location = $this->input->post('location');
            
            $organization = $this->input->post('organization');
            //var_dump($organization);
            
            //Se obtienen todas la categorías del sistema
            $categories = $this->Structure_model->getCategories();
            //Arreglo que contendra el árbol de carpetas
            $tree = array();
            //Si existen categorías
            if ($categories) {
                //Se recorren las categorías
                foreach ($categories->result() as $category) {
                    //Se crea el nodo del arbol con sus respectivos atributos
                    $cat = array(
                        "id" => $category->id,
                        "text" => $category->name,
                        //Estados del nodo
                        "state" => array(
                            "selected" => false,
                            "opened" => false,
                            "checkbox_disabled" => true,
                            "checked" => false,
                        ),
                        //Atributos css
                        "a_attr" => array("class" => "text-space"),
                        "li_attr" => array("class" => "hide-check"),
                        //Tipo de nodo
                        "type" => "root",
                        "data" => array("delete" => $category->isRemovable)
                    );
                    //Si lo que se desea es subir un archivo se desabilitan los nodo raíz ya que solo se pueden subir archivos
                    // en los nodos archivo.
                    if($upload != 0){
                        $cat['state']['disabled'] = true;
                    }
                    //Se obtienen las sub categorías de la actual categoría
                    $subcategories = $this->Structure_model->getSubcategoriesbyParent($category->id);
                    //Si existen subcategorías
                    if ($subcategories) {
                        //Arreglo con los nodos subcategorías (Default)
                        $subcategoriesArray = array();
                        //Se recorren las sub categorías
                        foreach ($subcategories->result() as $subcategory) {
                            //Se crea el nodo con sus respectivos atributos
                            $sub = array(
                                "id" => $subcategory->id,
                                "text" => $subcategory->name,
                                //Atributos del nodo
                                "state" => array(
                                    "selected" => false,
                                    "opened" => false,
                                    "checked" => false,
                                    "checkbox_disabled" => true
                                ),
                                //Css del nodo
                                "a_attr" => array("class" => "text-space"),
                                "li_attr" => array("class" => "hide-check"),
                                //Tipo del nodo
                                "type" => "default",
                                "data" => array("delete" => $subcategory->isRemovable)
                            );
                            //Si lo que se desea es subir un archivo se desabilitan los nodo default ya que solo se pueden subir archivos
                            // en los nodos archivo.
                            if($upload != 0){
                                $sub['state']['disabled'] = true;
                            }
                            //Se obtienen las carpetas dentro de la actual subcategoría
                            $folders = $this->Structure_model->getFoldersbyParent($subcategory->id);
                            //Si existen carpetas
                            if ($folders) {
                                //Arreglo con los nodos carpeta(File)
                                $foldersArray = array();
                                //Se recorren en las carpetas
                                foreach ($folders->result() as $folder) {
                                    //Se crea el nodo con sus respectivos atributos
                                    $fold = array(
                                        "id" => $folder->id,
                                        "text" => $folder->name,
                                        "state" => array(
                                            "selected" => false,
                                            "opened" => false
                                        ),
                                        //Css del nodo
                                        "a_attr" => array("class" => "text-space"),
                                        //Tipo del nodo
                                        "type" => "file",
                                        "data" => array("delete" => $folder->isRemovable)
                                    );
                                    //Si upload es 2 significa que es la vista para subir una nueva versión.
                                    if($upload != 1){
                                        //Arreglo con los nodos Archivo(fileLast)
                                        $filesArray = array();
                                        //Se desabilita la carpeta para que no pueda ser seleccionada, ya que solo se pueden seleccionar archivos.
                                        if($upload != 0){
                                             $fold['state']['disabled'] = true;
                                        }
                                        //Se oculta el check de la carpeta por que se debe seleccionar un archivo
                                        $fold["li_attr"] = array("class" => "hide-check");
                                        
                                        //Se obtiene la lista de archivos de esta carpeta
                                        $fileList = $this->Structure_model->getFilesbyFolder($folder->id,$location,null,$organization);
                                        //Se recorren los archivos
                                        //var_dump($fileList);
                                        if($fileList) {
                                            foreach ($fileList->result() as $file) {
                                                //Se crea el nodo con sus respectivos atributos
                                                $fil = array(
                                                    "id" => $file->id."-F",
                                                    "text" => $file->name,
                                                    "state" => array(
                                                        "selected" => false,
                                                        "opened" => false
                                                    ),
                                                    //Css del nodo
                                                    "a_attr" => array("class" => "text-space"),
                                                    //Tipo del nodo
                                                    "type" => "fileLast",
                                                    "data" => array("dateCreation" => $file->creationDate ,"delete" => 1)
                                                );
                                                if($upload == 0){
                                                    $fil["li_attr"] = array("class" => "hide-check");
                                                }
                                                //Se ingresa el nodo archivo en el array de nodos archivos
                                                array_push($filesArray, $fil);
                                            }
                                            //Se agrega el conjunto de archivos a la carpeta actual
                                            $fold['children'] = $filesArray;
                                        }
                                    }
                                    //Se ingresa el nodo carpeta en el array de nodos carpeta
                                    array_push($foldersArray, $fold);
                                }
                                //Se agrega el conjunto de carpetas a la subcategoría actual
                                $sub['children'] = $foldersArray;
                            }
                            //Se agrega el nodo subcategoría al arreglo de subcategorías
                            array_push($subcategoriesArray, $sub);
                        }
                        //Se agrega el conjunto de subcategorías a la categoría actual
                        $cat['children'] = $subcategoriesArray;
                    }
                    //Se agrega la categoría al árbol final
                    array_push($tree, $cat);
                }
            }
            //Se envia un json con la estructura.
            echo json_encode($tree);
        }
	}

	/**
	** Función  que se encarga de ingresar una carpeta en el sistema.
	** Retorna el id de la carpeta que se insertó.
	**/
	public function insertFolder()
	{
		//Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
		if(!$this->input->is_ajax_request()){
			redirect('404');
		}else{

		    //Se obtiene el tipo de carpeta a insertar y su padre en la jerarquía
			$f = $this->input->post('folder');
			$type = $f['type'];
			//Se completan los datos de la carpeta
            $folder = array(
                "name"=>htmlentities($f['name']),
                "uniqueIdentifier"=>uniqid(),
                "creationDate"=>date('Y-m-d H:i:s T', time()),
                "idTypeFolder"=>$type,
                "typeUpload"=>$f['typeUpload']
            );
            //Se inserta y se obtiene el id que se le asignó
            $new_id= $this->Structure_model->insertFolder($folder);
            //Se verifica si la carpeta que se ingreso esta en lo mas alto de la jerarquía (Categoría)
            if($type != 1){
                //Si no se crea la relación con su carpeta padre
                $data = array(
                    "idFolderParent"=>$f['parent_id'],
                    "idFolderInside"=>$new_id,
                );
                //Se inserta la relación
                $this->Structure_model->insertFolderInside($data);

            }
            if(strcmp($f['typeUpload'],"ftp") == 0) {
                //Obtenemos la ruta para insertarla del servidor ftp
                $path = $this->Structure_model->getPath($new_id);

                //Se crea la carpeta en el servidor FTP.
                $this->createFolderFTP($path);
            }

            //Se retorna el id
            echo $new_id;


		}
	}

	/**
	** Función  que se encarga de actualizar una carpeta en el sistema.
	**/
	public function updateFolder()
	{
		//Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
		if(!$this->input->is_ajax_request()){
			redirect('404');
		}else{
		    //Obtiene la informacion del folder que se desea actualizar
            $folder = $this->input->post('folder');
            //Se procede a actualizar la carpeta
            $this->Structure_model->updateFolder($folder);

		}
	}

    /**
     ** Función  que se encarga de eliminar una carpeta del el sistema.
     **/
    public function deleteFolder()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else{
            //Se obtiene el id de la carpeta que se desea eliminar
            $folder = $this->input->post('folder');
            $id = $folder['id'];

            if(strcmp($folder['typeUpload'],"ftp") == 0) {
                //Obtenemos la ruta para eliminarla del servidor ftp
                $path = $this->Structure_model->getPath($id);
                //Eliminamos la carpeta del servidor FTP
                $this->deleteFolderFTP($path);
            }
            //Se elimina la carpeta
            $this->Structure_model->deleteFolder($id);


        }
    }



}