<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Upload extends CI_Controller {

	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el corrcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		$this->lang->load('spanish_lang','spanish');
        $this->load->model('User_model');
        $this->load->model('Structure_model');
        $this->load->library('ftp');
        $this->load->model('Organization_model');
        $this->load->library('Email_library');
	}

    /**
     ** Función que se encarga de subir un archivo al servidor FTP.
     ** Params:
     **     $pathFile: ruta del archivo temporal a subir.
     **     $newPath: ruta en el servidor FTP donde se almacenara el archivo
     **     $nameFile: nombre del archivo a salir.
     **/
    private function uploadFTP($pathFile,$newPath,$nameFile){
        //Configuración para la conexion al servidor FTP
        $config['hostname'] = 'localhost';
        $config['username'] = 'daemon';
        $config['password'] = 'xampp';
        $config['debug']        = TRUE;
        //Variable para indicar si ya esxiste la carpeta del mes
        $exist = false;
        //Se realiza la conexión
        $this->ftp->connect($config);
        //Se obtiene la lista de todos los archivos y directorios de la carpeta de la ruta.
        $list = $this->ftp->list_files($newPath);
        //Mes y año
        $date = date('m-Y');
        //Se concatena para obtener la carpeta del mes
        $newPath = $newPath.$date;
        //Se recorre la lista del directoria para verificar si la carpeta del mes ya existe.
        foreach ($list as $l){
            //Obtenemos la ultima carpeta o archivo de cada ruta para comparar.
            $pathExplode = explode('/',$l);
            $final = $pathExplode[count($pathExplode)-1];
            //Revisamos si existe
            if(strcmp($final,$date) == 0){
                $exist = true;
                break;
            }
        }
        //Si no existe la carpeta del mes se crea
        if(!$exist){

            $this->ftp->mkdir($newPath);
        }
        //Se sube el archivo en la carpeta del mes
        $this->ftp->upload($pathFile, $newPath."/".$nameFile);
        //Se cierra conexion
        $this->ftp->close();
    }


	/**
	** Función que se encarga de cargar la vista subir archivo del módulo administrador.
	**/
	public function index()
	{
        //Verifica si hay una sesión iniciada, de lo contrario lo redirecciona al login para que se registre.
        $isAdministrator = $this->session->userdata('isAdministrator');
        if(isset($isAdministrator)){
            if(!$isAdministrator){
                redirect(site_url('Client/Main'));
            }
        }else{
            redirect(site_url());
        }
		//Titulo que se muestra en la pestaña del navegador.
		$data['title'] = $this->lang->line('aTitle_Upload');
		//Contenido a utilizar en la vista.
		$data['content'] = $this->session->userdata('username');
		//Se cargan las organizaciones
        $result = $this->Organization_model->getAllOrganizations();
        if($result){
            $data['organizations'] = $result->result();
        }
		//Se carga la vista indicada y se le pasa la información para que pueda se utilizada desde la vista.
		$this->load->view('Administrator/upload', $data);
	}

    /**
     ** Función que se encarga de cargar la vista subir nueva versión del módulo administrador.
     **/
    public function update()
    {
        //Verifica si hay una sesión iniciada, de lo contrario lo redirecciona al login para que se registre.
        $isAdministrator = $this->session->userdata('isAdministrator');
        if(isset($isAdministrator)){
            if(!$isAdministrator){
                redirect(site_url('Client/Main'));
            }
        }else{
            redirect(site_url());
        }

        //Titulo que se muestra en la pestaña del navegador.
        $data['title'] = $this->lang->line('aTitle_Update');
        //Contenido a utilizar en la vista.
        $data['content'] = $this->session->userdata('username');
        //Se cargan las organizaciones
        $result = $this->Organization_model->getAllOrganizations();
        if($result){
            $data['organizations'] = $result->result();
        }

        //Se carga la vista indicada y se le pasa la información para que pueda se utilizada desde la vista.
        $this->load->view('Administrator/update', $data);
    }

    /**
     ** Función que se encarga de subir un archivo al sistema.
     **/
    public function uploadFile(){

        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            //Obtenemos el valor isVersion para saber si se esta subiendo un nuevo archivo o una nueva versión de un archivo.
            $isVersion =  (boolean)$this->input->post('isVersion');
            

            if($isVersion){
                //Si es una nueva versión

                //Id del archivo de la nueva versión

                $idFile = explode('-',$this->input->post('file'))[0];
                //Obtenemos los datos del archivo
                $result = $this->Structure_model->getFile($idFile);
                $oldfile = $result->result()[0];

                //Carpeta en la que se encuentra el archivo
                $folderId = $oldfile->idFolder;

            }else{
                //Carpeta en la que se encuentra el archivo
                $folderId = $this->input->post('folder');
                //Organizacion a la cual pertenece el archivo
                //$organization = $this->input->post('organization');
                //Locaciones a las cuales se le van a subir el archivo
                //$locations = explode(',',$this->input->post('locations'));
            }
            //Cantidad de archivos subidos
            $size = $this->input->post('length');
            //Si se va a subir por FTP o a base de datos(BLOB)
            $typeUpload = $this->input->post('typeUpload');
            //Recorre los archivos que se van a subir
            //Variable para guardar los nombres
            $names = "<br>";


            //Recorren los archivos para concatenar los nombres de los archivos para la notificación
            for($j =0;$j < $size; $j++){
                //Obtenemos el nombre del archivo
                $fileName = $_FILES['file_' . $j]['name'];
                //Se concatena
                $names .= "  - ".$fileName."<br>";
            }
            //Retornamos los nombres de los archivos.
            echo $names;
            echo $size;
            //var_dump($_FILES);
            for ($i = 0; $i < $size; $i++) {
                //Obtenemos el nuevo archivo

                $file = $_FILES['file_' . $i];
                //Array para almacenar la información del archivo
                $data = array();
                //Obtenemos la extensión del archivo
                $extension = pathinfo($file['name'], PATHINFO_EXTENSION);

                //Se completan los datos del archivo
                $onlyName = explode('.',$file['name']);
                $data['name'] = htmlentities($onlyName[0]);
                $data['extension'] = $extension;
                $data['type'] = $file['type'];
                $data['creationDate'] = date('Y-m-d H:i:s', time());
                $data['validity'] = 1;
                $data['uniqueIdentifier'] = uniqid();//Identificador unico para el archivo.
                $data['typeUpload'] = $typeUpload;

                

                //Verificamos el tipo de subida
                if (strcmp($typeUpload, "blob") == 0) {
                    //Si es blob obtenemos el contenido del archivo para almacenarlo en la base de datos.
                    $data['content'] = file_get_contents($file["tmp_name"]);
                    //echo "Entro!";
                } else {
                    //Si es FTP creamos la ruta para el archivo en el servidor
                    $path = $this->Structure_model->getPath($folderId);
                    //Nombre del nuevo archivo
                    $name = $data['uniqueIdentifier'] . "." . $data['type'];
                    //Se procede a subir el archivo al servidor FTP
                    $this->uploadFTP($file["tmp_name"], $path,$name);
                    $data['content'] = "NULL";
                }
                if($isVersion){
                    //Si es una nueva versión se respaldan los datos del archivo anterior
                    $newVersion = array(
                        'name' => $oldfile->name,
                        'type' => $oldfile->type,
                        'extension'=>$oldfile->extension,
                        'creationDate' => $oldfile->creationDate,
                        'uniqueIdentifier' => $oldfile->uniqueIdentifier,
                        'typeUpload' => $oldfile->typeUpload,
                        'content'=> $oldfile->content,
                        'idFile'=> $idFile

                    );
                    //Se insertan los datos viejos como una versión.
                    $this->Structure_model->insertVersion($newVersion);

                    $data['id'] = $idFile;
                    //Se actualiza el archivo con la información de la nueva versión.
                    $this->Structure_model->updateFile($data);
                }else{
                    $data['idFolder'] = $folderId;
                    //if(strcmp($organization,"public") != 0){
                       // $data['organization'] = $organization;
                   // }
                    //Si no es una nueva versión simplemente se guarda el archivo.
                    //Id del archivo ingresado
                    $idNewFile = $this->Structure_model->insertFile($data);
                    /**
                    if(strcmp($locations[0],"public") != 0){
                        //Arreglo con el conjunto de relaciones entre locaciones y el archivo
                        $info = array();
                        //Se recorren las locaciones
                        foreach ($locations as $location){
                            //Registro, con la relación entre el archivo y la locación
                            $row = array(
                                'idLocation'=>(int)$location,
                                'idFile'=>(int)$idNewFile
                            );
                            //Se ingresa el registro en el arreglo de relaciones
                            array_push($info,$row);
                        }
                        //Se ingresan las relaciones a la base de datos
                        $this->Structure_model->file_location($info);
                    }
                    **/
                }
            }
        }
    }


    /**
     ** Se encarga de enviar notificaciones al correo electrónico cuando se suben nuevos archivos.
     **/
    public function sendNotifications(){
        //Se obtienen las locaciones
        $locations = $this->input->post('locations');
        //Se obtiene el nombre de los archivos
        $names= $this->input->post('names');

        //Para cada locación
        foreach ($locations as $location){
            //Se obtiene el email de la actual locación
            $result = $this->User_model->getEmail($location);
            //Si existe el email
            if($result) {
                foreach ($result->result() as $c) {
                    //Email del usuario
                    $email = $c->EMail;
                    //echo $email;
                    $this->email_library->sendEmail($this->lang->line('email'), $this->lang->line('email_name'),
                        $email,$this->lang->line('title_email_notif'),$this->lang->line('body_email_notif')."<br>".$names);
                }
            }
        }
    }
    
    /**
     ** Se encarga de enviar notificaciones al correo electrónico cuando se suben nuevos archivos.
     **/
    public function assingLocations(){
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else{
            //Se obtienen las locaciones
            $locations = $this->input->post('newData');
            //$file = $this->input->post('file');
            $folder = $this->input->post('folder');
            $locationsOld = $this->input->post('oldData');
            $areLocations = $this->input->post('areLocations');
            $organization = $this->input->post('organization');
            if(is_null($locations)){
                $locations = array();
            }
            if(is_null($locationsOld)){
                $locationsOld = array();
            }
            $toDelete = array_diff($locationsOld,$locations);
            $toInsert = array_diff($locations,$locationsOld);
            /**
            $files = array();
            if($folder == 1){
                $files = $this->Structure_model->getFilesByFolderWithoutLocation($file);
                $files = $files->result();
            }else{
                $object = new stdClass;
                $object->id = $file;
                array_push($files,$object);
            }**/
            if($areLocations == "true"){
                    if(!empty($toDelete)){
                        $this->Structure_model->deleteFolder_locations($folder,$toDelete,$areLocations);
                    }
                    $info = array();
                    $publi = false;
                    if(!empty($toInsert)){
                        foreach ($toInsert as $value) {
                            if($value != "public"){
                                $row = array(
                                    'idOrganization'=>str_replace("$"," ",$organization),
                                    'idLocation'=>$value,
                                    'idFolder'=>(int)$folder
                                 );
                                 array_push($info,$row); 
                            }else{
                                $publi = true;
                                $row = array(
                                    'idOrganization'=>str_replace("$"," ",$organization),
                                    'idFolder'=>(int)$folder
                                 );
                                 array_push($info,$row); 
                                 break;
                            }
                        }
                        if(!empty($info)){
                           $this->Structure_model->folder_location($info);
                        }
                        
                    }
                    if(!$publi){
                        $orga = [$organization];
                        $this->Structure_model->deleteFolder_locations($folder,$orga,"false",1);
                    }
                    $data = array(
                            'id'=>$folder,
                            'isGlobal'=>0
                        );
                    $this->Structure_model->updateFolder($data);
            }else{
                    if(!empty($toDelete)){
                        foreach ($toDelete as $value) {
                           $value =  str_replace("$"," ",$value);
                        }
                        $this->Structure_model->deleteFolder_locations($folder,$toDelete,$areLocations);
                    }
                    $info = array();
                    $publi = false;
                    if(!empty($toInsert)){
                        foreach ($toInsert as $value) {
                            if($value == "public"){
                                 $publi = true;
                                 $data = array(
                                     'id'=>$folder,
                                     'isGlobal'=>1
                                 );
                                 $this->Structure_model->updateFolder($data);
                                 break;
                            }else{
                                $row = array(
                                    'idOrganization'=>str_replace("$"," ",$value),
                                    'idFolder'=>(int)$folder
                                 );
                                 array_push($info,$row); 
                            }
        
                        }
                        if(!empty($info)){
                           $this->Structure_model->folder_location($info);
                        }
                        
                    }
                    if(!$publi){
                        $data = array(
                            'id'=>$folder,
                            'isGlobal'=>0
                        );
                       $this->Structure_model->updateFolder($data);
                    }
                
            }
        }
    }
}