<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Main extends CI_Controller {

	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el correcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		$this->load->library('form_validation');
		$this->lang->load('spanish_lang','spanish');
		$this->load->model('User_model');
        $this->load->model('Structure_model');
	}

    /**
     ** Función  que se encarga de cargar la vista principal del módulo cliente.
     **/
	public function index()
	{
        //Verificación de autorización
        $isAdministrator = $this->session->userdata('isAdministrator');
        if(isset($isAdministrator)){
            if($isAdministrator){
                redirect(site_url('../Administrator/Upload'));
            }
        }else{
            redirect(site_url('../'));
        }
        $data['title'] =  $this->lang->line('a_Tittle_OWC');
        //Locación con la cuál se ingreso al módulo.
        $data['location'] = $this->session->userdata('location');
        //Carpeta que se desea mostrar en pantalla
        $folder = $this->input->get('folder');
        if(isset($folder)){
            $saveFolder = array('folder' => $folder);
            $this->session->set_userdata($saveFolder);
        }else{
            $folder = $this->session->userdata('folder');
        }
        //Si viene la información de la carpeta
        if(isset($folder)){
            //Se separa la información de la carpeta.
            $folder_array = explode('$',base64_decode($folder));
            $path = explode('/',$folder_array[1]);
            $data['title_folder'] = $path[2] ;
            $data['title_subCategory'] = $path[1];
            $data['title_Category'] = $path[0];
            $data['folder_id'] = $folder_array[0];
        }else{
            //Información por defecto
            $data['title_folder'] = "" ;
            $data['title_subCategory'] = "";
            $data['title_Category'] = "";
            $data['folder_id'] = -1;
        }
		$this->load->view('Client/main',$data);
	}

    /**
     ** Función  que se encarga de recibir la locación con la cuál se va a ingresar al módulo.
     **/
	public function receiveLocation(){
	    //Locación escogida por el usuario.
	    $location = array('location' => $this->input->post('txtLocation'));
	    //Se guarda la locación con sesión.
        $this->session->set_userdata($location);
        //Se verifica si es primera vez para almacenar la información general en sesión.
        $first = $this->input->post('txtFirst');
        if(isset($first)){
            //Se almacena la información temporal en sesión
            $session_data = $this->session->userdata('temp');
            $this->session->set_userdata($session_data);
        }
        //Redirecciona al módulo cliente.
        redirect(site_url('../Client/Main/'));

    }

    /**
     ** Función  que se encarga de retornar la estructura jerárquica de carpetas del sistema.
     **/
    public function getMenu()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            //Se obtiene el id del usuario para recuperar sus locaciones.
            $idUser = $this->session->userdata('idUser');
            //Se recupera la locación del cual se quieren ver los archivos
            $location = array();
            array_push($location,$this->session->userdata('location'));
            //Se obtienen todas la categorías del sistema
            $categories = $this->Structure_model->getCategories();
            //Arreglo que contendra el árbol de carpetas
            $tree = array();
            //Si existen categorías
            if ($categories) {
                //Se recorren las categorías
                foreach ($categories->result() as $category) {
                    //Para controlar si existe al menos un archivo en la categoría
                    $found = false;
                    //Se crea la opción del menú
                    $cat = array(
                        "id" => $category->id,
                        "name" => $category->name,
                    );
                    //Se obtienen las sub categorías de la actual categoría
                    $subcategories = $this->Structure_model->getSubcategoriesbyParent($category->id);
                    //Si existen subcategorías
                    if ($subcategories) {
                        //Arreglo con las subcategorías
                        $subcategoriesArray = array();
                        //Se recorren las sub categorías
                        foreach ($subcategories->result() as $subcategory) {
                            $subfound = false;
                            //Se crea la sub-opción del menú
                            $sub = array(
                                "id" => $subcategory->id,
                                "name" => $subcategory->name
                            );
                            //Se obtienen las carpetas dentro de la actual subcategoría
                            $folders = $this->Structure_model->getFoldersbyParent($subcategory->id);
                            //Si existen carpetas
                            if ($folders) {
                                //Arreglo con los nodos carpeta(File)
                                $foldersArray = array();
                                //Se recorren en las carpetas
                                foreach ($folders->result() as $folder) {

                                    //Se crea el nodo con sus respectivos atributos
                                    $fold = array(
                                        "id" => $folder->id,
                                        "name" => $folder->name
                                    );
                                        $inactiveDate = $this->User_model->getInactiveDate($idUser);
                                       // if(strcmp($location[0], 'public') === 0){
                                            //echo "vida";
                                            //Se obtiene la lista de archivos de esta carpeta
                                            $organization = $this->session->userdata('organization');
                                            $fileList = $this->Structure_model->getFilesbyFolder($folder->id,$location,$inactiveDate->result()[0]->inactiveDate,$organization);
                                        //}else{
                                            //echo "false";
                                            //Se obtiene la lista de archivos de esta carpeta
                                            //$fileList = $this->Structure_model->getFilesbyFolder($folder->id,$location,$inactiveDate->result()[0]->inactiveDate);
                                        //}
                                        
                                        //Se recorren los archivos
                                        if($fileList) {

                                            //Indicamos que si se encontraron archivos
                                            $found = true;
                                            $subfound = true;
                                            //Se ingresa la carpeta en el array de carpetas
                                            array_push($foldersArray, $fold);
                                        }
                                }
                                //Se agrega el conjunto de carpetas a la subcategoría actual
                                $sub['children'] = $foldersArray;
                            }
                            //Si se encontraron archivos en la categoría
                            if($subfound) {
                                //Se agrega el nodo subcategoría al arreglo de subcategorías
                                array_push($subcategoriesArray, $sub);
                            }
                        }
                        //Se agrega el conjunto de subcategorías a la categoría actual
                        $cat['children'] = $subcategoriesArray;

                    }
                    //Si se encontraron archivos en la categoría
                    if($found){
                        //Se agrega la categoría al árbol final
                        array_push($tree, $cat);
                    }
                }
            }

            $resu = $this->User_model->getAllLocationsByClient($idUser);
            $locations = [];
            if($resu){
                $locations = $resu->result();
            }
            $isGlobal = $this->User_model->getIsGlobal($idUser);
            if(strcmp($isGlobal->result()[0]->isGlobal,"1") === 0){
                $temp = new stdClass;
                $temp->Id = "public";
                $temp->Name = $this->lang->line('all');
                array_unshift($locations, $temp);
            }
            //var_dump($locations);
            //Respuesta con la jerarquía, la locación actual y las locaciones disponibles para el usuario.
            $data = array(
                'menu'=>$tree,
                'locations'=>$locations,
                'location'=>$location
            );

            //Se envia un json con la estructura.
            echo json_encode($data);
        }
    }

    /**
     ** Función que se encarga de recuperar los archivos de un cliente, según su locación y carpeta.
     **/
    public function getClientFiles(){
        //Obtenemos la locación
        $location = array();
        array_push($location,$this->session->userdata('location'));
        //Obtenemos la carpeta
        $folder = $this->input->post('folder');
        $inactiveDate = $this->session->userdata('inactiveDate');
        if(strcmp($inactiveDate,"")==0){
            $inactiveDate = null;
        }

        //Se obtiene la lista de archivos de esta carpeta
        $organization = $this->session->userdata('organization');
        //Recuperamos los archivos
        $fileList = $this->Structure_model->getFilesbyFolder($folder,$location,$inactiveDate,$organization);

        //Si hay archivos, se retornan
        if($fileList){
            echo json_encode($fileList->result());
        }
    }

    /**
     ** Función que se encarga de recuperar las versiones de un archivo.
     **/
    public function getVersions(){
        //Se obtiene el archivo
        $file = $this->input->post('file');
        //Se recuperan las versiones
        $versionsList = $this->Structure_model->get_versions($file);
        //Si hay versiones, se retornan
        if($versionsList){
            echo json_encode($versionsList->result());
        }else{
            echo "-1";
        }
    }

    /**
     ** Función que se encarga de recuperar el contenido de un archivo para su descarga.
     **/
    public function downloadFile(){
        //Se obtiene el cuerpo de la petición
        $request_body = file_get_contents('php://input');
        //Se decodifica, ya que lo que se recibe es un JSON.
        $data = json_decode($request_body);
        //Se obtiene el archivo, isFile indica si es un archivo o una versión
        $file = $this->Structure_model->get_file_download($data->file,$data->isFile);
        //Si se encuentra el archivo
        if($file){
            //Se codifica a base 64 el contenido del archivo.
            $sendFile = $file->result();
            $sendFile[0]->content = base64_encode($sendFile[0]->content);
            //Se retorna el archivo para su descarga.
           echo json_encode($sendFile[0]);
        }else{
            echo "-1";
        }
    }


}
