<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Report extends CI_Controller {

	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el corrcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		$this->lang->load('spanish_lang','spanish');
        $this->load->model('Structure_model');
        $this->load->model('Query_model');
        $this->load->library('Curl_library');

	}

    private function _get_web_page($url) {
        $options = array(
            CURLOPT_RETURNTRANSFER => true,   // return web page
            CURLOPT_HEADER         => false,  // don't return headers
            CURLOPT_FOLLOWLOCATION => true,   // follow redirects
            CURLOPT_MAXREDIRS      => 10,     // stop after 10 redirects
            CURLOPT_USERAGENT      => "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13",
            CURLOPT_ENCODING       => "",     // handle compressed
            CURLOPT_USERAGENT      => "test", // name of client
            CURLOPT_AUTOREFERER    => true,   // set referrer on redirect
            CURLOPT_CONNECTTIMEOUT => 120,    // time-out on connect
            CURLOPT_TIMEOUT        => 120,    // time-out on response
        ); 
    
        $ch = curl_init($url);
        curl_setopt_array($ch, $options);
    
        $content  = curl_exec($ch);
    
        curl_close($ch);

        return $content;
    }    

	/**
     ** Funcion que se encargar de ingresar un reporte en el sistema, en su lugar correspondiente.
     **/
    public function saveReport(){

            //Organizacion a la cual pertenece el archivo
            $client = $this->input->post('client');
            
            //Fecha del reporte
            $date = $this->input->post('date');
            //echo $client."!<br>";
            $cl = explode(";",$client);
            if(count($cl) > 1){
               $orga = explode(":",$cl[0]);
               $loca = explode(":",$cl[1]);
            }else{
               $orga = explode(":",$cl[0]);
               $loca = $orga;
            }
            
            $report = $this->input->post('report');
            //echo $report."!<br>";
            $url = base64_decode($this->input->post('url'));
            $url = str_replace("%2D","-",$url);
            //echo $url."!<br>";
            //Crear las carpetas necesarias
            $category = $this->Structure_model->folderExist("Reportes de Visitas Mensuales",1);
            if($category == false){
                $folder = array(
                    "name"=>"Reportes",
                    "uniqueIdentifier"=>uniqid(),
                    "creationDate"=>date('Y-m-d H:i:s T', time()),
                    "idTypeFolder"=>1,
                    "typeUpload"=>"blob",
                    "isRemovable" => 0
                );
                $category = $this->Structure_model->insertFolder($folder);
            }

            $subcategory = $this->Structure_model->folderExist($report,2,$category);
                if($subcategory == false){
                    $folder = array(
                    "name"=>$report,
                    "uniqueIdentifier"=>uniqid(),
                    "creationDate"=>date('Y-m-d H:i:s T', time()),
                    "idTypeFolder"=>2,
                    "typeUpload"=>"blob",
                    "isRemovable" => 0
                );
                $subcategory = $this->Structure_model->insertFolder($folder);
                $data = array(
                    "idFolderParent"=>$category,
                    "idFolderInside"=>$subcategory,
                );
                //Se inserta la relacin
                $this->Structure_model->insertFolderInside($data);
            }

            $folderExist = $this->Structure_model->folderExist($loca[0],3,$subcategory);
                if($folderExist == false){
                    $folder = array(
                    "name"=>$loca[0],
                    "uniqueIdentifier"=>uniqid(),
                    "creationDate"=>date('Y-m-d H:i:s T', time()),
                    "idTypeFolder"=>3,
                    "typeUpload"=>"blob",
                    "isRemovable" => 0
                );
                $folderExist = $this->Structure_model->insertFolder($folder);
                $data = array(
                    "idFolderParent"=>$subcategory,
                    "idFolderInside"=>$folderExist,
                );
                //Se inserta la relacin
                $this->Structure_model->insertFolderInside($data);
                
                if(isset($loca)){
                    $row = array(
                    'idLocation'=>(int)$loca[1],
                    'idOrganization'=>$orga[1],
                    'idFolder'=>(int)$folderExist
                    );
                }else{
                    $row = array(
                    'idOrganization'=>$orga[1],
                    'idFolder'=>(int)$folderExist
                    );
                }
                $info = array();
                //Se ingresa el registro en el arreglo de relaciones
                array_push($info,$row);
                //var_dump($info);
                $this->Structure_model->folder_location($info);
            }
            
            //Array para almacenar la informacin del archivo
            $data = array();
            //Se completan los datos del archivo
            //$date = date('Y-m-d H:i:s', time());
            if(isset($loca)){
               $data['name'] = htmlentities($loca[0]."-".substr($date, 0, 11)); 
            }else{
                $data['name'] = htmlentities($orga[0]."-".substr($date, 0, 11));
            }
            $data['extension'] = "pdf";
            $data['type'] = "application/pdf";
            $data['creationDate'] = $date ;
            $data['validity'] = 1;
            $data['uniqueIdentifier'] = uniqid();//Identificador unico para el archivo.
            $data['typeUpload'] = "blob";
            echo $url."\n<br>";
            //$data['content'] = file_get_contents($url);
            $data['content'] = $this->curl_library->get_web_page($url);
            //var_dump($data['content']);
            $data['idFolder'] = $folderExist;
            
            $exists = $this->Structure_model->existsFile($data['name'],$data['idFolder']);
            if($exists){
                $existsId = $exists->result();
                $this->Structure_model->deleteFile($existsId[0]->id);
                echo "Borrado\n";
                
            }
            
            $this->Structure_model->insertFile($data);
    }
    
    /**
     ** Funcion que se encargar de ingresar un reporte en el sistema, en su lugar correspondiente.
     **/
    public function getData(){
         $code = $this->input->post('code');
         if(strcmp($code,"orkin2018-06-29") == 0){
            $query = $this->input->post('query');
            echo $query."!!!";
            //$result = $this->Query_model->execute_query($query);
            if($result){
	            $data = array(
                    'data' => $result->result(),
                    'status' => 1
				);                
            }else{
                $data = array(
                    'status' => 0
				); 
            }
            echo json_encode($data, JSON_PRETTY_PRINT);
         }
    }
}