<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Start extends CI_Controller {

	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el corrcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		$this->load->library('form_validation');
		$this->lang->load('spanish_lang','spanish');
		$this->load->model('User_model');
        $this->load->library('Email_library');
	}

    /**
     ** Función  que se encarga de cargar la vista del login.
     **/
	public function index()
	{
        $isAdministrator = $this->session->userdata('isAdministrator');
        if(isset($isAdministrator)){
            if($isAdministrator){
                redirect(site_url('Administrator/Structures'));
            }else{
                redirect(site_url('Client/Main'));
            }

        }
		$this->load->view('start/login');
	}

	/**
	** Función que se encarga de comprobar si el usuario ingresado se encuentra registrado en el sistema.
	**/
	public function check_login()
	{

        echo json_encode("estoy en check_login");
		//Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
		if(!$this->input->is_ajax_request()){
			redirect('404');
		}else{

			//Arreglo con la configuración de las validaciones.
			$config = array(
		        array(
		                'field' => 'userName',
		                'label' => $this->lang->line('username'),
		                //Restricciones del campo
		                'rules' => 'required|min_length[5]|max_length[30]|trim|alpha_numeric',
		                //Mensajes de error
		                'errors' => array(
		                        'required' => $this->lang->line('error_userNameEmpty'),
		                        'min_length' => $this->lang->line('error_userNameMin'),
		                        'max_length' => $this->lang->line('error_userNameMax'),
		                        'alpha_numeric' => $this->lang->line('error_userNameAlphanumeric'))
		        ),
		        array(
		                'field' => 'password',
		                'label' => $this->lang->line('password'),
		                //Restricciones del campo
		                'rules' => 'required|min_length[5]|max_length[30]|trim',
		                //Mensajes de error
		                'errors' => array(
		                        'required' => $this->lang->line('error_passwordEmpty'),
		                        'min_length' => $this->lang->line('error_passwordMin'),
		                        'max_length' => $this->lang->line('error_passwordMax'))
		        )
			);
			//Asigna la configuración recien hecha a la validación.
			$this->form_validation->set_rules($config);

			//Verifica lo ingresado con las restricciones de cada campo.
			if(!$this->form_validation->run()){ 
               //Se encontraron errores. Retorna Status 1 y los mensajes de error que se encontraron.
               $send = array(
	            	'status' => 1,
	            	'response' => validation_errors());
               //Se envia la respuesta en formato JSON y sin escapar caractéres especiales.
               echo json_encode($send, JSON_UNESCAPED_UNICODE);
            }else{
             	//No ha errores de validación
             	$username = $this->input->post('userName');
             	$password= $this->input->post('password');

             	$data = array('username' => $username,
	             			  'password' => $password);
             	//Se verifica si es usuario ingresado esta registrado en el sistema.
	            $response = $this->User_model->isRegister($data);

	            if(!$response){
	            	//No existe el usuario en la base de datos del sistema. Retorna Status 2.
	            	$send = array(
	            	'status' => 2,
	            	'response' => '');
	            	//Se envia la respuesta en formato JSON.
	            	echo json_encode($send);
	            }else{
	            	//El usuario si se encuentra registrado en el sistema. Retorna Status 3 y si es administrador o cliente.
	            	$row = $response->result();
	            	//Se obtienen datos de importancia sobre el usuario.
                    if(array_key_exists('idUser',$row[0])){
                        $idUser = $row[0]->idUser;
                        $isAdministrator = True;
                        $inactiveDate = "";
                        $isGlobal = "";
                        $organization = "";
                    }else {
                        $idUser = $row[0]->id;
                        $isAdministrator = False;
                        $inactiveDate = $row[0]->inactiveDate;
                        $isGlobal = $row[0]->isGlobal;
                        $organization = $row[0]->idOrganization;
                    }
					
					//Se obtiene la hora GMT +0
					date_default_timezone_set('UTC');
					$date = date('Y-m-d H:i:s T', time());

	            	$dataLog = array( 'dateLogin' => $date,
	            			'ipAddress' => $this->input->ip_address(),//Obtiene la ip del usuario
	             			'idUser' => $idUser,
                            'isAdministrator'=>($isAdministrator)?1:0);

	            	//Registra el inicio de sesión en la base de datos. 
	            	$this->User_model->insertLog($dataLog);

	            	//Información del usuario que se almacenará en sesión.
	            	$newdata = array(
				        'idUser'  => $idUser,
				        'username'  => $username,
				        'isAdministrator' => $isAdministrator,
                        'inactiveDate' => $inactiveDate,
                        'isGlobal' => $isGlobal,
                        'organization' => $organization
					);
	            	if($isAdministrator){
                        $newdata['rol'] = $row[0]->fkRoleId;
                        $this->session->set_userdata($newdata);
                    }else{
                        //Sesión temporal hasta que ingrese la locación, posteriormente se confirma
                        $temp = array(
                            'temp'=>$newdata
                        );
                        $this->session->set_userdata($temp);
                    }
                    //Se recuperan las locaciones del cliente
                    $locations = $this->User_model->getAllLocationsByClient($idUser);
	            	//Respuesta
					$send = array(
	            	'status' => 3,
	            	'response'=> $isAdministrator,
	            	'isGlobal' => $isGlobal);
					if($locations){
					    $send['locations'] = $locations->result();
                    }
					//Se envia la respuesta en formato JSON.
	            	echo json_encode($send);
	            }
             }
		}

	}


    /**
     ** Función que se encarga de destruir la sesión al salir del sistema.
     **/
	public function logout(){
	    //Variables a destruir
        $session_vars = array('username', 'idUser','isAdministrator','rol','location','temp','inactiveDate','folder');
        //Se destruye la sesión
        $this->session->unset_userdata($session_vars);
        //Redireción al Login
        redirect(site_url());

    }

    /**
     ** Función que se encarga de cargar la vista de Recuperar contraseña
     **/
    public function forgotPassword()
    {
        //Verificación de autorización
        $isAdministrator = $this->session->userdata('isAdministrator');
        if(isset($isAdministrator)){
            if($isAdministrator){
                redirect(site_url('Upload'));
            }else{
                redirect(site_url('Cliente/Main'));
            }

        }
        $this->load->view('start/changePassword');
    }

    /**
     ** Función que se encarga de enviar un correo con el código paa restablecer la contraseña
     **/
    public function sendEmail()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            //Obtenemos el correo al cual enviar el código de recuperación
            $email = $this->input->post('email');
            $code = strtoupper(substr(uniqid(),0,8));
            $this->email_library->sendEmail($this->lang->line('email'), $this->lang->line('email_name'),
                $email,$this->lang->line('title_email_pass'),$this->lang->line('body_email_pass')."<br>".$code);

            //Respuesta, con el indicador de éxito, el código para comparar.
            $send = array(
                'response' =>1,
                'code'=>$code);

            }
            //Se envia la respuesta en formato JSON.
            echo json_encode($send);
    }


    /**
     ** Función que se encarga de verificar que un nombre de usuario exista en el sistema y retornar los correos
     ** electrónicos asociados a las locaciones que tiene asignadas.
     **/
    public function checkUsername()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else {
            //Obtenemos el nombre de usuario
            $username = $this->input->post('userName');
            //Datos para la verificación
            $data['username'] = $username;
            //Verificamos si existe es usuario.
            $result = $this->User_model->isAvailable($data);
            if(!$result){
                //Si existe recuperamos los emails
                $emails = $this->User_model->getEmail($username);
                //Se elabora la respuesta, dependiendo si existen o no emails asociados
                if($emails){
                    $send = array(
                        //Emails
                        'emails' => $emails->result(),
                        //Id del cliente para actualizar la contraseña
                        'idClient'=>$emails->result()[0]->id,
                        'response' =>1
                    );
                }else{
                    $send = array(
                        //Vacío por que no tiene emails asociados
                        'emails' => '',
                        'response' =>1
                     );
                }
            //Respuesta si no existe el usuario.
            }else{
                $send = array(
                    'response' =>0
                );
            }
            //Se envia la respuesta en formato JSON.
            echo json_encode($send);
        }
    }

    /**
     ** Función que se encarga de actualizar la contraseña de un usuario
     **/
    public function updatePassword()
    {
        //Verifica si la petición se realiza por medio de ajax, de lo contrario retorna error.
        if(!$this->input->is_ajax_request()){
            redirect('404');
        }else{
            //Obtiene la nueva contraseña.
            $client = $this->input->post('user');
            //La encripta con md5
            $client['password'] = md5($client['password']);
            //Actualiza
            $this->User_model->updateUser($client);
        }
    }

}
