<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Organization_model extends CI_Model {


	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el correcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		$this->load->database();
	}

    /**
     ** Función que se encarga de retornar todas las organizaciones de la base de datos.
     **/
    function getAllOrganizations()
    {
        //Seleccionar los atributos requeridos
        $query = $this->db->select('idPrimary,Name,NameLegal');
        //De la tabla organizations
        $query = $this->db->from('organizations');
        $query =$this->db->where('Active',1);
        $query =$this->db->where('Deletion',0);
        //Agrupado por id
        $query = $this->db->group_by('idPrimary');
        //Ordenados por Name ascendente
        $query = $this->db->order_by('Name', 'ASC');
        $query = $this->db->get();

        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }

    /**
     ** Función que se encarga de retornar todas las locaciones de una organización en la base de datos.
     **/
    function getLocations($organization)
    {
        //Seleccionar los atributos requeridos
        $query = $this->db->select('Id,Name');
        //De la tabla organizationLocations
        $query = $this->db->from('organizationLocations');
        //Donde el id de la organización sea el proporcionado
        $query =$this->db->where('OrganizationId',$organization);
        $query =$this->db->where('Active',1);
        //Agrupado por el Id
        $query = $this->db->group_by('Id');
        //Ordenados por Name ascendente
        $query = $this->db->order_by('Name', 'ASC');
        //$sql = $this->db->get_compiled_select();
        //echo $sql;
        $query = $this->db->get();

        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }





}
