<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Structure_model extends CI_Model {


	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el correcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
           $this->load->database();
	}
	
	/**
	** Función que se encarga de recuperar todas las categorías del sistema.
	**/
	function getCategories(){
		//Seleccionar los datos requeridos
		$query = $this->db->select('id,name,isRemovable');
		//De la tabla vw_folder
		$query = $this->db->from('vw_folder');
		//Donde el tipo de carpeta se 1 (Categoría)
		$query = $this->db->where('idTypeFolder',1);
		$query = $this->db->order_by('orderShow','ASC');
		$query = $this->db->get();
		//Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
		//a 0 significa que si se encontraron resultados.
		if($query->num_rows() > 0){
			//Retorna los resultados.
			return $query;
		}else{
			//Retorna false por que no hubo coincidencia.
			return false;

			
		}
	}

	/**
	** Función que se encarga de recuperar todas las subcategoría pertenecientes a una categoría.
	** $id = id de la categoría de la cual se desea obtener las subcategorías.
	**/
	function getSubcategoriesbyParent($id){
        //Seleccionar los datos requeridos
        $query = $this->db->select('vw_folder.id as id,name,isRemovable');
        //De la tabla vw_folder
        $query = $this->db->from('vw_folder');
        //Junto a la tabla vw_folder_inside_folder
        $query = $this->db->join('vw_folder_inside_folder', 'vw_folder.id = vw_folder_inside_folder.idFolderInside');
        //Donde el id de la carpeta padre coincida con el id proporcionado
        $query = $this->db->where('idFolderParent',$id);
        //Donde el tipo de carpeta se 2(Subcategoría)
        $query = $this->db->where('idTypeFolder',2);
        $query = $this->db->order_by('name','ASC');
        $query = $this->db->get();
        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;


        }
	}

	/**
	** Función que se encarga de recuperar todas las carpetas pertenecientes a una subcategoría.
    ** $id = id de la categoría de la cual se desea obtener las subcategorías.
	**/
	function getFoldersbyParent ($id)
    {
        //Seleccionar los datos requeridos
        $query = $this->db->select('vw_folder.id as id,name,isRemovable');
        //De la tabla vw_folder
        $query = $this->db->from('vw_folder');
        //Junto a la tabla vw_folder_inside_folder
        $query = $this->db->join('vw_folder_inside_folder', 'vw_folder.id = vw_folder_inside_folder.idFolderInside');
        //Donde el id de la carpeta padre coincida con el id proporcionado
        $query = $this->db->where('idFolderParent',$id);
        //Donde el tipo de carpeta se 3(Carpeta)
        $query = $this->db->where('idTypeFolder',3);
        $query = $this->db->order_by('name','ASC');
        $query = $this->db->get();
        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;


        }
	}
	
	/**
	** Función que se encarga averiguar si existe una carpeta.
    ** $name = nombre de la carpeta, $type = tipo de la carpeta, $parent = carpeta padre
	**/
	function folderExist($name,$type,$parent= null)
    {
        //Seleccionar los datos requeridos
        $query = $this->db->select('vw_folder.id as id');
        //De la tabla vw_folder
        $query = $this->db->from('vw_folder');
        if($type > 1){
             $query = $this->db->join('vw_folder_inside_folder', 'vw_folder.id = vw_folder_inside_folder.idFolderInside');
             $query = $this->db->where('idFolderParent',$parent);
        }
        $query = $this->db->where('name',$name);
        $query = $this->db->where('idTypeFolder',$type);
        $query = $this->db->limit(1);
        $query = $this->db->get();
        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query->result()[0]->id;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;


        }
	}

	/**
	** Función que se encarga insertar una carpeta en la base de datos.
	** $data = arreglo con la información de la carpeta a insertar.
	**/
	function insertFolder($data){
		//Inserta los datos en la tabla vw_folder
		$this->db->insert('vw_folder', $data);
		//Obtiene el id del registro recién ingresado
        $insert_id = $this->db->insert_id();
        return $insert_id;
	}

    /**
     ** Función que se encarga insertar una relación estre carpetas en la base de datos.
     ** $data = arreglo con la información de la relación a insertar.
     **/
    function insertFolderInside($data){
        //Inserta los datos en la tabla vw_folder_inside_folder
        $this->db->insert('vw_folder_inside_folder', $data);
    }

	/**
	** Función que se encarga actualizar una carpeta en la base de datos.
	** $data = arreglo con la información de la carpeta a actualizar.
	**/
	function updateFolder($data){
		//Captura el id de la carpeta a actualizar.
		$id = $data['id'];
		//Remueve el id del arreglo de datos para que no se intente actualizar el id.
		unset($data['id']);
		//Se agrega la información que se va a actualizar.
		$this->db->set($data);
		//Donde el id coincida con el id que capturamos anteriormente.
		$this->db->where('id', $id);
		//Actualiza los datos de la tabla vw_folder
		$this->db->update('vw_folder');
	}

	/**
	** Función que se encarga de eliminar un carpeta y todo su contenido.
    ** La mayor profundida de la estructura de carpetas es 3, por lo tanto se buscan contenido de la carpeta a eliminar
    ** hasta una profundida de 3 para asegurarse de que todo el contenido sea eliminado.
	** $id = id de la carpeta a eliminar.
	**/
	function deleteFolder($id){
	    //Se selecciona los datos necesarios.
        $query = $this->db->select('idFolderInside');
        //De la tabla vw_folder_inside_folder
        $query = $this->db->from('vw_folder_inside_folder');
        //Donde el folder padre sea igual al id de la carpeta a eliminar.
        $query = $this->db->where('idFolderParent',$id);
        $query = $this->db->get();
        //Donde el id sea igual al id padre
        $this->db->where('idFolderParent', $id);
        //O al id de la carpeta hijo
        $this->db->or_where('idFolderInside', $id);
        //Elimine de la tabla vw_folder_inside_folder
        $this->db->delete('vw_folder_inside_folder');
        //Donde el id de la carpeta sea igual al id que queremos eliminar
        $this->db->where('id', $id);
        //Elimine de la tabla vw_folder
        $this->db->delete('vw_folder');
        //$query contiene todas las carpetas que estaban dentro de la carpeta que se desea eliminar
        if($query){
            //Se recorre la lista de carpetas a eliminar
            foreach ($query->result() as $folder){
                //Se selecciona los datos requeridos
                $sql = $this->db->select('idFolderInside');
                //De la tabla vw_folder_inside_folder
                $sql = $this->db->from('vw_folder_inside_folder');
                //Donde el id de la carpeta sea igual al id que queremos eliminar
                $sql = $this->db->where('idFolderParent',$folder->idFolderInside);
                $sql = $this->db->get();
                //Donde el id sea igual al id padre
                $this->db->where('idFolderParent', $folder->idFolderInside);
                //O al id de la carpeta hijo
                $this->db->or_where('idFolderInside', $folder->idFolderInside);
                //Elimine de la tabla vw_folder_inside_folder
                $this->db->delete('vw_folder_inside_folder');
                //$query contiene todas las carpetas que estaban dentro de la carpeta que se desea eliminar
                if($sql){
                    //Se recorre la lista de carpetas a eliminar
                    foreach ($sql->result() as $f) {
                        //Donde el id de la carpeta sea igual al id que queremos eliminar
                        $this->db->where('id', $f->idFolderInside);
                        //Elimine de la tabla vw_folder
                        $this->db->delete('vw_folder');
                    }
                }
                //Donde el id de la carpeta sea igual al id que queremos eliminar
                $this->db->where('id', $folder->idFolderInside);
                //Elimine de la tabla vw_folder
                $this->db->delete('vw_folder');
            }
        }
	}

    /**
     ** Función que se encarga de obtener la ruta de una carpeta.
     ** $id = id de la carpeta.
     **/
	function getPath($id){
	    //Ruta del archivo
	    $path ="/";
	    //Variables de control
	    $search = true;
	    $cont = 0;
	    do{
            //Se selecciona los datos necesarios.
            $query = $this->db->select('uniqueIdentifier');
            //De la tabla vw_folder
            $query = $this->db->from('vw_folder');
            //Donde el id sea igual al proporcionado
            $query = $this->db->where('id',$id);
            $query = $this->db->get();
            //Carpeta
            $folder = $query->result();
            //Se obtiene el nombre único que es el que se usa en el servidor FTP
            $uniqueName = $folder[0]->uniqueIdentifier;
            //Se concatena el nombre único a la ruta que ya tenemos.
            $path = "/".$uniqueName.$path;
            //Se selecciona los datos necesarios.
            $query = $this->db->select('idFolderParent');
            //De la tabla vw_folder_inside_folder
            $query = $this->db->from('vw_folder_inside_folder');
            //Donde el folder de adentro sea igual al id de la carpeta.
            $query = $this->db->where('idFolderInside',$id);
            $query = $this->db->get();
            //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
            //a 0 significa que si se encontraron resultados.
            if($query->num_rows() <= 0){
                //La carpeta no se encuentra dentro de ninguna carpeta, por lo tanto le damos a search el valor de false
                // para que termine la construcción de la ruta.
                $search = false;
            }else{
                //Procedemos a evaluar la rut de la carpeta padre.
                $folder = $query->result();
                $id = $folder[0]->idFolderParent ;
            }
            //Control(para que no se haga un ciclo infinito en caso de un error lógico)
            $cont++;
            if($cont == 3){
                break;
            }
        }while($search);
        //Se retorna la ruta
        return $path;
    }

    /**
     ** Función que se encarga de insertar un archivo en la base de datos.
     ** $data: atributos del archivo a insertar
     **/
    function insertFile($data){
        //Inserta en archivo en base de datos.
        $this->db->insert('vw_file',$data);
        //Retornamos el id del archivo que se acaba de insertar
        $insert_id = $this->db->insert_id();
        echo $insert_id."!";
        //$errNo   = $this->db->_error_number();
        //$errMess = $this->db->_error_message();
        //echo  $errNo;
       // echo $errMess;
        return $insert_id;
    }

    /**
     ** Función que se encarga de obtener los archivos dentro de una carpeta.
     ** $id: id de la carpeta
     *  $location: locación del cual buscamos los archivos
     **/
    function getFilesByFolder($id,$location,$inactiveDate = null,$organization = null){
        //Se seleccionan los atributos necesarios.
        $query = $this->db->select('vw_file.id,vw_file.name,vw_file.creationDate,validity');
        //De la tabla vw_file
        $query = $this->db->from('vw_file');
        $query = $this->db->join('vw_folder', 'vw_file.idFolder = vw_folder.id');
        $query = $this->db->join('vw_folder_location', 'vw_file.idFolder = vw_folder_location.idFolder', 'left');
        //Cuando se cumplan las condiciones
        if(strcmp($organization,"all") == 0){
                $query = $this->db->where('vw_file.idFolder ='.$id." ");
        }else if($organization && (strcmp($organization,"public") != 0) && (strcmp($organization,"private") != 0) && strcmp($location[0],"public") == 0){
                $query = $this->db->where('vw_file.idFolder ='.$id.' AND (idLocation in (Select id from organizationLocations where OrganizationId = "'.$organization.'")
                OR idOrganization = "'.$organization.'" OR vw_folder.isGlobal = 1)');
        }else{
            
                if(strcmp($location[0],"public") == 0){
                    $query = $this->db->where('vw_file.idFolder ='.$id." ");
                    $query = $this->db->where('vw_folder.isGlobal = 1');
                }else if(strcmp($location[0],"private") == 0){
                    $query = $this->db->where('vw_file.idFolder ='.$id." ");
                    $query = $this->db->where('vw_folder.isGlobal = 0');
                    $query = $this->db->where("vw_file.idFolder not in (Select idFolder from vw_folder_location Group  by idFolder)");
                }else{
                    $query = $this->db->where('vw_file.idFolder ='.$id);
                    $queryLocations = ' (( ';
                    for ($i = 0; $i < count($location); $i++) {
                        $queryLocations = $queryLocations." idLocation = ".$location[$i]." ";
                        if(($i+1) != count($location)){
                            $queryLocations = $queryLocations." OR ";
                        }
                    }
                    if($organization){
                        $queryLocations = "(vw_folder_location.idOrganization = '".$organization."' AND ".$queryLocations;
                        $queryLocations = $queryLocations." OR vw_folder_location.idLocation IS NULL)) ";
                    }else{
                        $queryLocations = $queryLocations.' ) ';
                    }
                    $query = $this->db->where($queryLocations." OR vw_folder.isGlobal = 1)");
                }
        }
        if($inactiveDate){
            $query = $this->db->where("vw_file.creationDate <= '".$inactiveDate."'");
        }
        $query = $this->db->where('vw_file.validity = 1');

        $this->db->group_by('vw_file.id');
        $this->db->order_by('vw_file.name', 'ASC');
        //$sql = $this->db->get_compiled_select();
        //echo $sql;
        $query = $this->db->get();

        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else {
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }
    
    /**
     ** Función que se encarga de obtener los archivos dentro de una carpeta.
     ** $id: id de la carpeta
     *  $location: locación del cual buscamos los archivos
     **/
    function getFilesByFolderWithoutLocation($id){
        //Se seleccionan los atributos necesarios.
        $query = $this->db->select('id');
        //De la tabla vw_file
        $query = $this->db->from('vw_file');
        $query = $this->db->where('idFolder',$id);
       // $sql = $this->db->get_compiled_select();
        //echo $sql;
        $query = $this->db->get();

        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else {
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }

    /**
     ** Función que se encarga de obtener un archivo específico.
     ** $id: id del archivo.
     **/
    function getFile($id)
    {
        //Seleccionamos los atributos necesarios
        $query = $this->db->select('*');
        //De la tabla vw_file
        $query = $this->db->from('vw_file');
        //Donde el id sea igual al proporcionado
        $query = $this->db->where('id', $id);

        $query = $this->db->get();
        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if ($query->num_rows() > 0) {
            //Retorna los resultados.
            return $query;
        } else {
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }
    
    
    /**
     ** Función que se encarga de averiguar si un archivo es publico.
     ** $id: id del archivo.
     **/
    function getFolderIsGlobal($id)
    {
        //Seleccionamos los atributos necesarios
        $query = $this->db->select('isGlobal');
        //De la tabla vw_file
        $query = $this->db->from('vw_folder');
        //Donde el id sea igual al proporcionado
        $query = $this->db->where('id', $id);

        $query = $this->db->get();
        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if ($query->num_rows() > 0) {
            //Retorna los resultados.
            return $query;
        } else {
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }
    
    
    /**
     ** Función que se encarga de insertar una nueva versión de un archivo en la base de datos.
     ** $data: atributos del archivo a insertar/
     **/
    function insertVersion($data){

        //Inserta una nueva versión de un archivo
        $this->db->insert('vw_version_file',$data);
    }

    /**
     ** Función que se encarga de actualizar un archivo en la base de datos.
     ** $data: atributos del archivo a actualizar
     **/
    function updateFile($data)
    {
        //Captura el id de la carpeta a actualizar.
        $id = $data['id'];
       // var_dump($data);
        //Remueve el id del arreglo de datos para que no se intente actualizar el id.
        unset($data['id']);
        //Se agrega la información que se va a actualizar.
        $this->db->set($data);
        //Donde el id coincida con el id que capturamos anteriormente.
        $this->db->where('id', $id);
        //Actualiza los datos de la tabla vw_file
        $this->db->update('vw_file');

    }


        /**
         ** Función que se encarga de obtener los archivos relacionados a una locación.
         ** $organization: id de la organización.
         **  $location: id de la locación
         **/
        function getFilesByLocation($organization,$location)
        {
            //Seleccionamos los atributos necesarios
            $query = $this->db->select("vw_file.id As Id, vw_file.name As Name,validity,GROUP_CONCAT(organizationLocations.Name SEPARATOR ',') 
            As Location,organizations.Name As Organization,organizations.NameLegal As OrganizationName,vw_file.creationDate");
            //De la tabla vw_file
            $query = $this->db->from('vw_file');
            //Join con otras tablas
            $query = $this->db->join('vw_folder', 'vw_file.idFolder = vw_folder.id');
            $query = $this->db->join('vw_folder_location', 'vw_file.idFolder = vw_folder_location.idFolder','left');
            $query = $this->db->join('organizations', 'vw_folder_location.idOrganization = organizations.id','left');
            $query = $this->db->join('organizationLocations', 'vw_folder_location.idLocation = organizationLocations.Id','left');
            //Si viene una organización específica.
            if(strcmp($organization,"all") != 0){
                if(strcmp($organization,"public") != 0){
                    if(strcmp($organization,"private") != 0){
                        //Donde el id de la organización sea igual al proporcionado.
                        $query = $this->db->where('vw_folder_location.idOrganization', $organization);
                        //Si viene una locación específica
                        if(strcmp($location,"public") !=0){
                            //Donde el id de la locación sea igual al proporcionado.
                            $query = $this->db->where("(vw_folder_location.idLocation = '".$location."' OR vw_folder_location.idLocation IS NULL)");
                        }
                        //O sean archivos públicos
                        $query = $this->db->or_where("vw_folder.isGlobal",1);   
                    }else{
                        $query = $this->db->where('vw_folder.isGlobal = 0');
                        $query = $this->db->where("vw_file.idFolder not in (Select idFolder from vw_folder_location Group  by idFolder)");
                    }
                }else{
                    $query = $this->db->or_where("vw_folder.isGlobal",1); 
                }
            }

            //Agrupado por id
            $query = $this->db->group_by('Id');
            // $query = $this->db->limit(210);

            //$sql = $this->db->get_compiled_select();
            //echo $sql;
            $query = $this->db->get();
            //var_dump($query->result());
            //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
            //a 0 significa que si se encontraron resultados.
            if ($query->num_rows() > 0) {
                //Retorna los resultados.
                return $query;
            } else {
                //Retorna false por que no hubo coincidencia.
                return false;
            }
        }
        
        /**
         ** Función que se encarga de eliminar un archivo de la base de datos.
         ** $id: id del archivo a eliminar.
         **/
        function existsFile($name,$idFolder = null){
            $query = $this->db->select('id');
            //De la tabla vw_version_file
            $query = $this->db->from('vw_file');
            //Donde el id del archivo sea igual al proporcionado
            $query = $this->db->where('name', $name);
            if($idFolder){
                $query = $this->db->where('idFolder', $idFolder);
            }
            $query = $this->db->get();
            
            if ($query->num_rows() > 0) {
            //Retorna los resultados.
                return $query;
            } else {
            //Retorna false por que no hubo coincidencia.
                return false;
            }
        }

        /**
         ** Función que se encarga de eliminar un archivo de la base de datos.
         ** $id: id del archivo a eliminar.
         **/
        function deleteFile($id){
            //Donde el id sea igual al proporcionado
            $this->db->where('id', $id);
            //Elimine de la tabla vw_file
            $this->db->delete('vw_file');
        }

    /**
     ** Función que se encarga relacionar una carpeta que se subio con las locaciones correspondientes.
     ** $data = datos a insertar.
     **/
    function folder_location($data){
        //Se inserta la información
        $this->db->insert_batch('vw_folder_location', $data);
    }

    /**
     ** Función que se encarga de recuperar todas las versiones de un archivo
     ** id: id del archivo
     **/
    function get_versions($id){
        //Seleccionamos los atributos necesarios
        $query = $this->db->select('id,name,creationDate');
        //De la tabla vw_version_file
        $query = $this->db->from('vw_version_file');
        //Donde el id del archivo sea igual al proporcionado
        $query = $this->db->where('idFile', $id);

        $query = $this->db->get();
        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if ($query->num_rows() > 0) {
            //Retorna los resultados.
            return $query;
        } else {
            //Retorna false por que no hubo coincidencia.
            return false;
        }

    }

    /**
     ** Función que se encarga de recuperar todas las versiones de un archivo
     ** id: id del archivo
     **/
    function get_file_download($id,$isFile){

        if($isFile){
            //Seleccionamos los atributos necesarios
            $query = $this->db->select('name,type,extension,content');
            //De la tabla vw_version_file
            $query = $this->db->from('vw_file');
        }else{
            //Seleccionamos los atributos necesarios
            $query = $this->db->select('name,type,extension,content');
            //De la tabla vw_version_file
            $query = $this->db->from('vw_version_file');

        }
        //Donde el id del archivo sea igual al proporcionado
        $query = $this->db->where('id', $id);

        $query = $this->db->get();
        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if ($query->num_rows() > 0) {
            //Retorna los resultados.
            return $query;
        } else {
            //Retorna false por que no hubo coincidencia.
            return false;
        }

    }
    
    /**
     ** Función que se encarga de eliminar un relacion carpeta-locacion de la base de datos.
     ** $id: id del archivo a eliminar.
     **/
    function deleteFolder_locations($id,$data,$areLocations,$flag = null){
        //Donde el id sea igual al proporcionado
        $this->db->where('idFolder', $id);
        if($areLocations == "true"){
            $this->db->where_in('idLocation',$data);
        }else{
            $this->db->where_in('idOrganization',$data);
            if($flag){
                $this->db->where('idLocation IS NULL');
            }
        }
        //$sql = $this->db->get_compiled_select();
        //echo $sql;
        $this->db->delete('vw_folder_location');
    }
    
    
    /**
     ** Función que se encarga de recuperar todas las locaciones relacionadas a una carpeta de la base de datos.
     ** $id: id del archivo, $organization : si hay alguna organizacion especifica..
     **/
    function getFolder_locations($idFolder,$organization = null){
        //Seleccionar los datos requeridos
		$query = $this->db->select('idOrganization,idLocation');
		$query = $this->db->from('vw_folder_location');
		$query = $this->db->where('idFolder',$idFolder);
		if($organization){
		    $query = $this->db->where('idOrganization',$organization);
		}else{
		    $query = $this->db->group_by('idOrganization'); 
		}
		$query = $this->db->get();
		//$sql = $this->db->get_compiled_select();
        //echo $sql;
		//Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
		//a 0 significa que si se encontraron resultados.
		if($query->num_rows() > 0){
			//Retorna los resultados.
			return $query;
		}else{
			//Retorna false por que no hubo coincidencia.
			return false;
		}
    }
    
    


}
