<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_model extends CI_Model {


	/**
	** Función constructor que se encarga de cargar todos los componentes necesarios para el correcto funcionamiento de la clase.
	**/
	function __construct(){
		parent::__construct();
		//$this->load->database();
	}

	/**
	** Función que se encarga de verificar si un usuario se encuentra registrado en el sistema.
	** $data = arreglo con el nombre de usuario y su contraseña.
	**/
	function isRegister($data){

	    //Primero verificamos si es administrador en riglobal
        $ri = $this->load->database('riglobal',True);
		//Seleccionar todos los datos
		$query = $ri->select('*');
		//De la tabla user
		$query = $ri->from('user');
		//Donde el nombre de usuario ingresado coincida con el del registro
		$query = $ri->where('name',$data['username']);
		//Donde la contraseña ingresada coincida con la del registro
		$query = $ri->where('password',$data['password']);
		$query = $ri->get();

		//Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
		//a 0 significa que si se encontraron resultados.
		if($query->num_rows() > 0){
			//Retorna los resultados.
			return $query;
		}else{
			//Si no es administrador, verifica si es cliente en la base de datos por defecto
            $this->load->database();
            //Seleccionar todos los datos
            $query = $this->db->select('*');
            //De la tabla vw_client
            $query = $this->db->from('vw_client');
            //Donde el nombre de usuario ingresado coincida con el del registro
            $query = $this->db->where('username',$data['username']);
            //Donde la contraseña ingresada coincida con la del registro
            $query = $this->db->where('password',$data['password']);
            $query = $this->db->get();

            if($query->num_rows() > 0) {
                //Retorna los resultados.
                return $query;
            }else{
                //Retorna false por que no es ni cliente ni administrador.
                return false;
            }
		}
	}

	/**
	** Función que se encarga de registrar un inicio de sesión en la base de datos.
	** $data = arreglo con la ip, fecha y id del usuario que inicio sesión.
	**/
	function insertLog($data){
        //Cargamos la base de datos
        $this->load->database('default');

		//Inserta los datos en la tabla vw_log
		$this->db->insert('vw_log', $data);
	}

	/**
	** Función que se encarga de retornar todos los usuarios del sistema, ya sea que se especifique si es administrador.
    ** $isAdmin = Si el valor viene nulo es por que se desea recuperar solamente los clientes, de lo contrario si isAdmin
    ** tiene algun valor se retornaran solamente los administradores.
    ** Por defecto tiene el valor false.
	**/
	function getAllUsers($isAdmin = null)
    {


        //Si isAdmin es null recuperamos de la base de datos por default los clientes
        //Si no, recuperamos los administradores de riglobal
        if ($isAdmin === null) {
            //Cargamos la base de datos
            $this->load->database('default');

            //Seleccionar los atributos necesarios
            $query = $this->db->select('vw_client.id,username,password,isActive,Name,NameLegal,idOrganization,isGlobal');
            //De la tabla vw_client
            $query = $this->db->from('vw_client');
            //Junto con la tabla organizaciones cuando coincidan sus respectivos id
            $query = $this->db->join('organizations', 'vw_client.idOrganization = organizations.idPrimary');
            //Ordenados por id descendente
            $query = $this->db->order_by('id', 'DESC');
            //Agrupado por nombre de usuario
            $this->db->group_by("username");
            //$sql = $this->db->get_compiled_select();
            //echo $sql;
            $query = $this->db->get();
        }else{
            //Cargamos la base de datos
            $ri = $this->load->database('riglobal',True);

            //Seleccionar los atributos necesarios
            $query = $ri->select('idUser,name,password');
            //De la tabla user
            $query = $ri->from('user');
            //Donde fkProducto sea igual a 9, valor que indica que es administrador de esta plataforma
            $query = $ri->where('fkProduct',9);
            //Donde el rol sea 2, para que no sea super usuario
            $query = $ri->where('fkRoleId',2);
            //Ordenados por id descendente
            $query = $ri->order_by('idUser', 'DESC');
            $query = $ri->get();
        }

		//Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
		//a 0 significa que si se encontraron resultados.
		if($query->num_rows() > 0){
			//Retorna los resultados.
			return $query;
		}else{
			//Retorna false por que no hubo coincidencia.
			return false;
		}
	}


    /**
     ** Función que se encarga de retornar todas las organizaciones de la base de datos.
     **/
    function getAllOrganizations()
    {
        //Cargamos la base de datos
        $this->load->database('default');
        //Seleccionar los atributos requeridos
        $query = $this->db->select('idPrimary,Name,NameLegal');
        //De la tabla organizations
        $query = $this->db->from('organizations');
        //Agrupado por id
        $query = $this->db->group_by('idPrimary');
        //Ordenados por Name ascendente
        $query = $this->db->order_by('Name', 'ASC');
        $query = $this->db->get();

        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }

	/**
	** Función que se encarga insertar un cliente o administrador es su respectiva tabla.
	** $data = arreglo con la información del cliente o administrador a insertar.
    ** $isAdmin = Es igual a false si se desea insertar un cliente, true si lo que se quiere ingresar es un administrador.
    ** Por defecto tiene el valor false.
	**/
	function insertUser($data,$isAdmin = false){
        //Verificamos si es administrador o cliente para saber donde insertarlo.
	    if($isAdmin){
            //Cargamos la base de datos
            $ri = $this->load->database('riglobal',True);

            //Inserta los datos en la tabla user
            $ri->insert('user', $data);
        }else{
            //Cargamos la base de datos
            $this->load->database('default');

            //Inserta los datos en la tabla vw_client
            $this->db->insert('vw_client', $data);
            //El id del registro que acabamos de insertar
            $insert_id = $this->db->insert_id();

            return $insert_id;
        }

	}

	/**
	** Función que se encarga actualizar un cliente o administrador.
	** $data = arreglo con la información del cliente o administrador a actualizar.
    ** $isAdmin = Es igual a false si se desea actualizar un cliente, true si lo que se quiere actualizar es un administrador.
    ** Por defecto tiene el valor false.
	**/
	function updateUser($data,$isAdmin = false){
        //Verificamos si es administrador o cliente para saber donde buscarlo para actualizarlo.
	    if($isAdmin){
            //Cargamos la base de datos
            $ri = $this->load->database('riglobal',True);

            //Captura el id del administrador a actualizar.
            $id = $data['idUser'];
            //Remueve el id del arreglo de datos para que no se intente actualizar el id.
            unset($data['idUser']);
            //Se agrega la información que se va a actualizar.
            $ri->set($data);
            //Donde el id coincida con el id que capturamos anteriormente.
            $ri->where('idUser', $id);
            //Actualiza los datos de la tabla user
            $ri->update('user');
        }else{
            //Cargamos la base de datos
            $this->load->database('default');

            //Captura el id del cliente a actualizar.
            $id = $data['id'];
            //Remueve el id del arreglo de datos para que no se intente actualizar el id.
            unset($data['id']);
            //Se agrega la información que se va a actualizar.
            $this->db->set($data);
            //Donde el id coincida con el id que capturamos anteriormente.
            $this->db->where('id', $id);

            //Actualiza los datos de la tabla vw_client
            $this->db->update('vw_client');
        }


	}

	/**
	** Función que se encarga de verificar is un nombre de usuario esta disponible, es decir no se ha utilizado.
	** $data = arreglo con el nombre del usuario.
    ** $isAdmin = Es igual a false si se desea comprobar el nombre de usuario de un cliente, true si lo que se quiere
    ** es comprobar el nombre de usuario  de un administrador.
    ** Por defecto tiene el valor false.
	**/
	function isAvailable($data,$isAdmin = false){

        //Si isAdmin es null buscamos en la base de datos por default los clientes
        //Si no, buscamos los administradores en riglobal
	    if($isAdmin){
            //Cargamos la base de datos
            $ri = $this->load->database('riglobal',True);

            //Seleccionar el id
            $query = $ri->select('idUser');
            //De la tabla user
            $query = $ri->from('user');
            //Donde el nombre de usuario ingresado coincida con el del registro
            $query = $ri->where('name',$data['name']);
            /**
             ** Verifica si en el arrreglo de datos viene el id
             ** Si es asi, significa que es una actualización y no una inserción.Por lo tanto agrega la siguiente condición ya que
             ** si es una inserción no va traer el id porque este solo se asigna hasta que esta ingresado en la base de datos por que
             ** es un autoincremental.
             **/
            if (array_key_exists("idUser",$data))
            {
                /**
                 ** Donde el id ingresado sea diferente de el del registro
                 ** Esto por que si es una actualización y no hay cambios en el nombre de usuario a la hora de confirmar
                 ** si el nombre de usuario existe va a devolver que si existe, pero es el mismo cliente que va a actualizar sus demás datos
                 ** el poseedor del nombre de usuario por lo que no hay problema, por eso se hace la distinción de que si es una actualización verifique
                 ** si alguien que no sea el mismo ya tiene ocupado ese nombre de usuario.
                 **/

                $query = $ri->where('idUser !=',$data['idUser']);
            }
            $query = $ri->get();
        }else{
            //Cargamos la base de datos
            $this->load->database('default');

            //Seleccionar el id
            $query = $this->db->select('id');
            //De la tabla vw_client
            $query = $this->db->from('vw_client');
            //Donde el nombre de usuario ingresado coincida con el del registro
            $query = $this->db->where('username',$data['username']);
            /**
             ** Verifica si en el arrreglo de datos viene el id
             ** Si es asi, significa que es una actualización y no una inserción.Por lo tanto agrega la siguiente condición ya que
             ** si es una inserción no va traer el id porque este solo se asigna hasta que esta ingresado en la base de datos por que
             ** es un autoincremental.
             **/
            if (array_key_exists("id",$data))
            {
                /**
                 ** Donde el id ingresado sea diferente de el del registro
                 ** Esto por que si es una actualización y no hay cambios en el nombre de usuario a la hora de confirmar
                 ** si el nombre de usuario existe va a devolver que si existe, pero es el mismo cliente que va a actualizar sus demás datos
                 ** el poseedor del nombre de usuario por lo que no hay problema, por eso se hace la distinción de que si es una actualización verifique
                 ** si alguien que no sea el mismo ya tiene ocupado ese nombre de usuario.
                 **/

                $query = $this->db->where('id !=',$data['id']);
            }
            $query = $this->db->get();
        }

		//Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
		//a 0 significa que si se encontraron resultados.
		if($query->num_rows() > 0){
			//Retorna los resultados.
			return false;
		}else{
			//Retorna false por que no hubo coincidencia.
			return true;

			
		}
	}

    /**
     ** Función que se encarga de obtener el Email de un usuario.
     ** Params:
     **     Nombre del usuario.
     **/
    function getEmail($username)
    {
        //Cargamos la base de datos
        $this->load->database('default');
        //Seleccionar los atributos requeridos
        $query = $this->db->select('vw_client.id,EMail');
        //De la tabla organizations
        $query = $this->db->from('organizationLocations');
        //Junto la tabla clientes
        $query = $this->db->join('vw_client_location', 'vw_client_location.idLocation = organizationLocations.Id');
        $query = $this->db->join('vw_client', 'vw_client.id = vw_client_location.IdClient');
        if(strcmp($username,"public") != 0) {
            //Donde el nombre de usuario corresponda al proporcionado.
            $query = $this->db->like('vw_client_location.idLocation', $username);
            $query = $this->db->or_where('vw_client.username', $username);
        }
        //Agrupado por email
        $query = $this->db->group_by("EMail");
        //$sql = $this->db->get_compiled_select();
        //echo $sql;
        $query = $this->db->get();



        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }

    /**
     ** Función que se encarga eliminar un administrador.
     ** $id = id del administrador a actualizar.
     **/
    function deleteUser($id,$isAdmin = null){
        if($isAdmin){
            $ri = $this->load->database('riglobal',True);
            //Donde el id sea igual al proporcionado
            $ri->where('idUser', $id);
            $ri->delete('user');
        }else{
             $this->load->database('default');
             //Donde el id sea igual al proporcionado
            $this->db->where('id', $id);
            $this->db->delete('vw_client');
        }
            
    }

    /**
     ** Función que se encarga asignar una o varias locaciones a un usuario.
     ** $data = datos a insertar.
     **/
    function assignUserLocation($data){
        //Cargamos la base de datos
        $this->load->database('default');
        //Se inserta la información
        $this->db->insert_batch('vw_client_location', $data);
    }

    /**
     ** Función que se encarga eliminar las locaciones asignadas a un cliente..
     ** $id = id del cliente.
     **/
    function deleteAssignUserLocation($id){
        //Se carga la base de datos
        $this->load->database('default');
        //Donde el id sea igual al proporcionado
        $this->db->where('idClient', $id);
        //Elimina
        $this->db->delete('vw_client_location');
    }

    /**
     ** Función que se encarga retornar las locaciones de un cliente
     ** $data = datos a insertar.
     **/
    function getAllLocationsByClient($id){
        //Cargamos la base de datos
        $this->load->database('default');

        $query = $this->db->select('organizationLocations.Id As Id,Name');
        //De la tabla organizations
        $query = $this->db->from('organizationLocations');
        $query = $this->db->join('vw_client_location', 'vw_client_location.idLocation = organizationLocations.Id');
        //Donde el id del cliente sea igual al proporcionado
        $query = $this->db->where('vw_client_location.idClient', $id);
        //Ordenados por Name ascendente
        $query = $this->db->order_by('Name', 'ASC');
        //$sql = $this->db->get_compiled_select();
        //echo $sql;
        $query = $this->db->get();

        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;
        }

    }

    /**
     ** Función que se encarga de obtener la fecha de inactividad de un usuario.
     ** Params:
     **     Id del usuario.
     **/
    function getInactiveDate($id)
    {
        //Cargamos la base de datos
        $this->load->database('default');
        //Seleccionar los atributos requeridos
        $query = $this->db->select('inactiveDate');
        //De la tabla organizations
        $query = $this->db->from('vw_client');
        $query = $this->db->where('vw_client.id', $id);
        $query = $this->db->get();

        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }
    
        /**
     ** Función que se encarga de obtener un usuario tiene acceso global.
     ** Params:
     **     Id del usuario.
     **/
    function getIsGlobal($id)
    {
        //Cargamos la base de datos
        $this->load->database('default');
        //Seleccionar los atributos requeridos
        $query = $this->db->select('isGlobal');
        //De la tabla organizations
        $query = $this->db->from('vw_client');
        $query = $this->db->where('vw_client.id', $id);
        $query = $this->db->get();

        //Verifica si existe alguna coincidencia a lo buscado, si el numero de filas devueltas es mayor
        //a 0 significa que si se encontraron resultados.
        if($query->num_rows() > 0){
            //Retorna los resultados.
            return $query;
        }else{
            //Retorna false por que no hubo coincidencia.
            return false;
        }
    }



}
