<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
    $this->lang->load('spanish_lang','spanish');

?>
<!DOCTYPE html>
<html lang="es">
  <head>
    <title>Orkin</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <BASE href="<?php echo site_url()?>/">

    <!-- CSS -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/input-style.css" rel="stylesheet">
    <link href="assets/css/sweetalert2.css" rel="stylesheet">
    <link rel="shortcut icon" href="assets/images/favicon.ico" />
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap-select.min.css" />
    
  </head>
  <body>
      <div class="container-fluid">
		  <div class="row">
			  <div class="col-md-8 col-md-offset-2">
                  <div class="container">
                      <div class="row">
                          <div class="col-md-12">
                              <br>
                              <a href="<?php echo site_url();?>">
                                  <img  class="img-responsive img-center" src="assets/images/Logo.png" alt="Logo">
                              </a>
                              <h3>
                                  <p class="text-center"><?php echo $this->lang->line('change_pass_title') ?></p>
                              </h3>
                              <section>
                                  <div class="wizard">
                                      <div class="wizard-inner">
                                          <div class="connecting-line"></div>
                                          <ul class="nav nav-tabs" role="tablist">
                                              <li role="presentation" class="active">
                                                  <a href="#step1" class="steps" data-toggle="tab" aria-controls="step1" role="tab" title="Step 1">
                                                      <span class="round-tab">
                                                         <i class="glyphicon glyphicon-envelope"></i>
                                                       </span>
                                                  </a>
                                              </li>
                                              <li role="presentation" class="disabled">
                                                  <a href="#step2" data-toggle="tab" aria-controls="step2" role="tab" title="Step 2">
                                                      <span class="round-tab">
                                                          <i class="glyphicon glyphicon-pencil"></i>
                                                      </span>
                                                  </a>
                                              </li>
                                              <li role="presentation" class="disabled">
                                                  <a href="#complete" data-toggle="tab" aria-controls="complete" role="tab" title="Complete">
                                                      <span class="round-tab">
                                                          <i class="glyphicon glyphicon-ok"></i>
                                                      </span>
                                                  </a>
                                              </li>
                                          </ul>
                                      </div>
                                      <div class="tab-content">
                                          <div class="tab-pane active" role="tabpanel" id="step1">
                                              <div class="row">
                                                  <div class="col-md-4">
                                                      <h4><?php echo $this->lang->line('step_1') ?></h4>
                                                      <div class="col-3 input-effect">
                                                          <input class="effect-17" type="text" placeholder="" id="txtUserName" name="txtUserName"
                                                              maxlength="30" minlength="5">
                                                          <label><?php echo $this->lang->line('username') ?></label>
                                                          <span class="focus-border"></span>
                                                      </div>
                                                      <br><br><br><br>
                                                      <div class="form-group" id="divEmail">
                                                          <label style="margin-right:10px;" for="ex-multiselect"><h4><?php echo $this->lang->line('attr_location');?>:</h4></label>
                                                          <select name="sltEmail" id="sltEmail" class="selectpicker" data-live-search="true" data-dropup-auto="false">

                                                          </select>
                                                      </div>
                                                      <br>
                                                      <div class="col-3 input-effect" id="divOther">
                                                          <input class="effect-17" type="text" placeholder="" id="txtEmailOther" name="txtEmailOther" maxlength="100" minlength="13">
                                                          <label><?php echo $this->lang->line('attr_email') ?></label>
                                                          <span class="focus-border"></span>
                                                      </div>
                                                  </div>
                                              </div>
                                          <div class="row">
                                              <div class="col-md-3 col-md-offset-4">
                                                  <ul class="list-inline pull-right" >
                                                      <li><button type="button" class="btn btn-primary next-step" id="btnCheck" onclick="checkUser();"><?php echo $this->lang->line('btn__validate_username') ?></button></li>
                                                  </ul>
                                              </div>
                                          </div>
                                      </div>
                                      <div class="tab-pane" role="tabpanel" id="step2">
                                          <div class="row">
                                              <div class="col-md-4">
                                                  <h4><?php echo $this->lang->line('step_2') ?></h4>
                                                  <div class="col-3 input-effect">
                                                      <input class="effect-17" type="text" placeholder="" id="txtCode" name="txtCode"
                                                           maxlength="30" minlength="5">
                                                      <label><?php echo $this->lang->line('code') ?></label>
                                                      <span class="focus-border"></span>
                                                  </div>
                                              </div>
                                              </div>
                                          <div class="row">
                                              <div class="col-md-3 col-md-offset-4" >
                                                  <ul class="list-inline pull-right">
                                                       <li><button type="button" class="btn btn-primary next-step" id="btnContinue"><?php echo $this->lang->line('btn_continue') ?></button></li>
                                                   </ul>
                                               </div>
                                          </div>
                                      </div>
                                      <div class="tab-pane" role="tabpanel" id="complete">
                                          <div class="row">
                                              <div class="col-md-4">
                                                  <h4><?php echo $this->lang->line('step_3') ?></h4>
                                                  <div class="form-group">
                                                      <div class="col-3 input-effect form-group">
                                                          <input class="effect-17" type="password" placeholder="" id="txtPassword" name="txtPassword"
                                                               maxlength="30" minlength="5">
                                                          <label><?php echo $this->lang->line('password') ?></label>
                                                          <span class="focus-border"></span>
                                                      </div>
                                                  </div>
                                                  <br><br>
                                                  <div class="col-3 input-effect form-group">
                                                      <input class="effect-17" type="password" placeholder="" id="txtPasswordRepeat" name="txtPasswordRepeat"
                                                          maxlength="30" minlength="5">
                                                      <label><?php echo $this->lang->line('repeat_pass') ?></label>
                                                      <span class="focus-border"></span>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row">
                                              <div class="col-md-3 col-md-offset-4">
                                                  <ul class="list-inline pull-right">
                                                      <li><button type="button" class="btn btn-primary next-step" id="btnDo"><?php echo $this->lang->line('btn_do') ?></button></li>
                                                  </ul>
                                              </div>
                                          </div>
                                      </div>
                                      <div class="clearfix"></div>
                                      </div>
                                  </div>
                              </section>
                          </div>
                      </div>
                  </div>
              </div>
		  </div>
		  <br><br><br><br>
	    <div class="row">
		    <div class="col-md-12" id="custom-footer">
			    <p class="text-center"><?php echo $this->lang->line('footer_copyright') ?></p>
		    </div>
	    </div>
	</div>
	
	<!-- Javascript -->
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/sweetalert2.js"></script>
    <script src="assets/js/bootstrap-select.min.js"></script>
    <script src="assets/js/validations.js"></script>
    <script src="assets/js/load_language.js"></script>
    <script src="assets/js/changePassword_js.js"></script>
  </body>
</html>