/**
 ** Función que se encarga de construir el grid de la vista de administradores.
 ** http://js-grid.com/
 **/

$(function() {

    var erase = false;

    //Configuración del JSGrid
    $("#jsGrid").jsGrid({
        height: "auto",
        width: "100%",
        editing: true,
        autoload: true,
        paging: true,
        pageSize : 25,
        sorting: true,
        filtering: true,
        onItemDeleting: function(args) {
            if(erase === false){
                swal({
                    title: lang.delete_title,
                    text: lang.delete_warning,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: lang.delete_comfirm
                }).then(function () {
                    erase = true;
                    $("#jsGrid").jsGrid("deleteItem", args.item);
                }).catch(swal.noop);
                args.cancel = true;
            }else{
                erase = false;
            }
        },
        pagerFormat: lang.pag_page+" : {first} {prev} {pages} {next} {last} {pageIndex} "+lang.pag_of+" {pageCount}",
        pagePrevText: lang.pag_prev,
        pageNextText: lang.pag_next,
        pageFirstText: lang.grid_first,
        pageLastText: lang.grid_last,
        pageNavigatorNextText: "...",
        pageNavigatorPrevText: "...",
        noDataContent: lang.not_found,
        loadMessage: lang.waiting,
        invalidMessage: lang.invalid_data,
        //Dispara el evento que muestra el dialogo para editar.
        rowClick: function(args) {
            showDetailsDialog(lang.grid_edit, args.item);//Al hacer click llama al método que abre el dialog para actualizar un administrador
        },
        //Métodos de manejo de datos
        controller: {
            loadData: function(filter) {
                var d = $.Deferred();
                //Consulta AJAX que trae todos los administradores
                $.ajax({
                    type: "GET",
                    url: "Administrator/administrators/getAllAdmins",
                    dataType: "json",
                }).done(function(result) {
                    //Verificación de los filtros con los registros encontrados
                    result = $.grep(result, function(user) {
                        return (!filter.name || user.name.toUpperCase().indexOf(filter.name.toUpperCase()) > -1) &&
                        (!filter.password || user.password.toUpperCase().indexOf(filter.password.toUpperCase()) > -1);

                    });
                    d.resolve(result);
                })
                return d.promise();
            },
            insertItem: function(user) {
                //Consulta AJAX que inserta un administrador
                $.ajax({
                    type: "POST",
                    url: "Administrator/administrators/insertAdmin",
                    data: {"user":user},
                    success: function(data)
                    {
                        //Si data es 0 significa que el nombre de usuario ya esta ocupado, si es 1 esta disponible.
                        if(data == 0){
                            //Mensaje de que ocurrio un error
                            swal(
                                lang.error_title,
                                lang.insert_error,
                                'error'
                            ).catch(swal.noop);
                        }else{
                            //Cierra el dialog
                            $("#detailsDialog").dialog("close");
                            //Mensaje de que se insertó correctamente.
                            swal(
                                lang.success_title,
                                lang.insert_success_admin,
                                'success'
                            ).catch(swal.noop);
                        }
                        //Al insertar un nuevo usuario se vuelve a cargar el contenido del grid
                        $("#jsGrid").jsGrid("loadData");
                    },
                    error: function(xhr)
                    {
                        //Muestra en pantalla e imprime en la consola del navegador el error.
                        swal(
                            lang.error_title ,
                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                            'error'
                        ).catch(swal.noop);
                        console.log(xhr);
                    }
                });
            },
            updateItem: function(user) {
                //Consulta AJAX que actualiza un administrador
                $.ajax({
                    type: "POST",
                    url: "Administrator/administrators/updateAdmin",
                    data: {"user":user},
                    success: function(data)
                    {
                        //Si data es 0 significa que el nombre de usuario ya esta ocupado, si es 1 esta disponible.
                        if(data == 0){
                            //Mensaje de que ocurrio un error
                            swal(
                                lang.error_title,
                                lang.update_error,
                                'error'
                            ).catch(swal.noop);
                        }else{
                            //Cierra el dialog
                            $("#detailsDialog").dialog("close");
                            //Mensaje de que se actualizó correctamente.
                            swal(
                                lang.success_title,
                                lang.update_success_admin,
                                'success'
                            ).catch(swal.noop);
                        }
                        //Al actualizar un administrador se vuelve a cargar el contenido del grid
                        $("#jsGrid").jsGrid("loadData");
                    },
                    error: function(xhr)
                    {
                        //Muestra en pantalla e imprime en la consola del navegador el error.
                        swal(
                            lang.error_title ,
                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                            'error'
                        ).catch(swal.noop);
                        console.log(xhr);
                    }
                });
            },
            deleteItem: function(user) {
                //Consulta AJAX que elimina un administrador
                $.ajax({
                    type: "POST",
                    url: "Administrator/administrators/deleteAdmin",
                    data: {"user":user},
                    success: function(data)
                    {
                            console.log(data);
                            //Mensaje de que se elimino correctamente.
                            swal(
                                lang.success_title,
                                lang.delete_success_admin,
                                'success'
                            ).catch(swal.noop);

                        //Al eliminar un administrador se vuelve a cargar el contenido del grid
                        $("#jsGrid").jsGrid("loadData");
                    },
                    error: function(xhr)
                    {
                        //Muestra en pantalla e imprime en la consola del navegador el error.
                        swal(
                            lang.error_title ,
                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                            'error'
                        ).catch(swal.noop);
                        console.log(xhr);
                    }
                });
            }
        },
        //Se definen los campos que tendrá el grid
        fields: [
            { name: 'name',title:lang.attr_username, type: "text", width: 100 },
            { name: 'password',title:lang.attr_password, type: "text", width: 100 },
            {
                type: "control",
                modeSwitchButton: false,
                editButton: false,
                deleteButton: true,
                clearFilterButtonTooltip: lang.control_clean,
                searchButtonTooltip: lang.control_search,
                //Modificación del botón de agregar
                headerTemplate: function() {
                    return $("<input>").attr("type", "button").addClass('jsgrid-button jsgrid-insert-button')
                        .on("click", function () {
                            showDetailsDialog(lang.grid_add, {});//Al hacer click llama al método que abre el dialog para agregar un nuevo administrador
                        });
                }
            }
        ]
    });

    //Dialog para insertar y actualizar los administradores
    $("#detailsDialog").dialog({
        autoOpen: false,
        width: 400,
        height: 'auto',
        minWidth: 400,
        maxWidth: 600,
        minHeight: 230,
        modal: true,
        fluid: true,
        resizable: false,
        open: function(event, ui){
            fluidDialog();
        },
        close: function() {
            $("#detailsForm").validate().resetForm();
            $("#detailsForm").find(".error").removeClass("error");
        }
    });


    //Se ejecuta en todos los dialog
    $(document).on("dialogopen", ".ui-dialog", function (event, ui) {
        fluidDialog();
    });

    //Remueve el nombre de espacio de la ventana de redimensionar
    $(document).on("dialogclose", ".ui-dialog", function (event, ui) {
        $(window).off("resize.responsive");
    });

    //Función para que el dialog sea responsive
    function fluidDialog() {
        var $visible = $(".ui-dialog:visible");
        //Cada dialog visible
        $visible.each(function () {
            var $this = $(this);
            var dialog = $this.find(".ui-dialog-content").data("ui-dialog");
            // Si la opción fluid es true
            if (dialog.options.maxWidth && dialog.options.width) {
                // Arregla el bud max-width
                $this.css("max-width", dialog.options.maxWidth);
                //Reposiciona el dialog
                dialog.option("position", dialog.options.position);
            }

            if (dialog.options.fluid) {
                //Agrega el nombre de espacio de la ventana de redimensionar
                $(window).on("resize.responsive", function () {
                    var wWidth = $(window).width();
                    //Compara el width de la ventana con el del dialog
                    if (wWidth < dialog.options.maxWidth + 50) {
                        //Mantener el dialog llenando toda la pantalla
                        $this.css("width", "90%");

                    }
                    //Reposiciona el dialog
                    dialog.option("position", dialog.options.position);
                });
            }

        });
    }

    //Validación para alfanumérica
    $.validator.addMethod("alphanumeric", function(value, element) {
        return this.optional(element) || /^[a-z0-9\-\s]+$/i.test(value);
    }, "");

    //Validaciones del form del dialog
    $("#detailsForm").validate({
        //Restricciones de los campos
        rules: {
            txtUserName: { required: true, minlength:5,maxlength:30,alphanumeric: true},
            txtPassword: { required: true, minlength:5,maxlength:30,alphanumeric: true}
        },
        //Mensajes de error para cada campo
        messages: {
            txtUserName: lang.eattr_username,
            txtPassword: lang.eattr_password
        },
        //Método que se encargara de manejar el submit del form
        submitHandler: function() {
            formSubmitHandler();
        }
    });

    var formSubmitHandler = $.noop;

    //Método que se encarga de preparar el dialog ya sea para insertar o actualizar
    var showDetailsDialog = function(dialogType, admin) {
        $("#detailsDialog").removeClass("invisible");
        $("#txtPassword").val('');
        var settings = $('#detailsForm').validate().settings;
        //Verifica si va a insertar
        if(dialogType === lang.grid_add){
            //Agregamos la regla de que la contraseña sea obligatoria
            settings.rules.txtPassword = {required: true, minlength:5,maxlength:30,alphanumeric: true};
        }else{
            //Eliminamos la regla de que la contraseña sea obligatoria
            delete settings.rules.txtPassword.required;

        }
        //Asigna los valores del administrador a editar en los campos de texto.
        $("#txtUserName").val(admin.name);


        //Función que se encarga manejar el submit del form en el dialog
        formSubmitHandler = function() {
            saveClient(admin, dialogType === lang.grid_add);
        };

        //Abre el dialog
        $("#detailsDialog").dialog("option", "title", dialogType )
            .dialog("open");
    };


    //Función que se encarga de ingresar o actualizar el cliente
    var saveClient = function(admin, isNew) {

        $.extend(admin, {
            name: $("#txtUserName").val(),
            password: $("#txtPassword").val(),
            fkProduct:9
        });

        //Llama al método de ingresar o actualizar del jsgrid
        $("#jsGrid").jsGrid(isNew ? "insertItem" : "updateItem", admin);

    };

    $('.jsgrid-filter-row > td > input').attr("placeholder",lang.filter_one);

});
