
    /**
     ** Función para trasladarse de etapa.
     **/
    function nextTab(elem) {
        $(elem).next().find('a[data-toggle="tab"]').click();
    }

    //Cliente y código de verificación
    var codeR = -1;
    var client = -1;

    /**
    ** Acciones a realizar cuando se termine de cargar la página.
    **/
    $(document).ready(function() {
		//Verifica si el input ,el que posee el focus, tiene contenido o no y le asigna o remueve una clase css según corresponda.
		$(".input-effect input").focusout(function(){
			//Verifica si hay contenido o no
			if($(this).val() != ""){
				$(this).addClass("has-content");
			}else{
				$(this).removeClass("has-content");
			}
		});

        //Continua a la próxima etapa
        $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {

            var $target = $(e.target);
            if ($target.parent().hasClass('disabled')) {
                return false;
            }
        });
        //Oculta el div donde esta el select con los emails para recuperar la contraseñ
        $("#divEmail").hide();
        $("#divOther").hide();

    });



        /**
         ** Función que se encarga de validar si el nombre de usuario existe y retornar sus emails asociados.
         **/
        function checkUser () {
            //Se obtiene nombre de usuario
        	var username = $("#txtUserName").val();
        	//Se valida si esta vacío
        	if(isEmpty(username)){
                swal(
                    lang.warning_title,
                    lang.error_userNameEmpty,
                    'warning'
                ).catch(swal.noop);
			}else{
        	    //Si no es alfanumérico
        		if(!isAlphanumeric(username)){
                    swal(
                        lang.error_title,
                        lang.error_userNameAlphanumeric,
                        'error'
                    ).catch(swal.noop);
				}else{
        		    //Llamada a AJAX para enviar el correo
                    $.ajax({
                        type: "POST",
                        url: "/Start/checkUsername",
                        data: {
                            "userName":username
                        } ,
                        success: function(data)
                        {
                        	//Se convierte a JSON la respuesta
                        	var r = JSON.parse(data);

                            //Se guarda el cliente
                        	client = r.idClient;
                        	//Si la respuesta es 1 significa el usuario si existe
                        	if(r.response == 1){
                                    //Muestra el select con los emails
                                    $("#divEmail").fadeIn(400);
                                    //Desabilita el campo de texto donde se ingreso el usuario
                                    $( "#txtUserName" ).prop( "disabled", true );
                                    //Cambia el texto del botón
                                    $("#btnCheck").html(lang.btn_send);
                                    //Cambia la función a ejecutarse con un click
                                    $("#btnCheck").attr("onclick","sendEmail()");
                                    //Por cada email
                                    jQuery.each(r.emails, function(i, val) {
                                        if(val.EMail != ''){
                                            //Separa el texto del email del dominio
                                            var text = val.EMail.split("@");
                                            //Tamaño del texto del email
                                            var size = text[0].length/2;
                                            //Texto bloqueado *
                                            var block ="";
                                            //Completa la mitad del texto del email con *
                                            for (i=0;i<(text[0].length-size);i++){
                                                block=block+"*";
                                            }
                                            //Agrega el email al select
                                            $("#sltEmail").append("<option class='email' value="+val.EMail+">"+text[0].substring(0,(size))+block+"@"+text[1]+"</option>");
                                        }
                                    });
                                    $("#sltEmail").append("<option class='email' value='none'>"+lang.another+"</option>");
                                    //Refresca el select de emails
                                    $('#sltEmail').selectpicker('refresh');
							}else{
                        	    //Si el usuario no existe
                                swal(
                                    lang.error_title,
                                    lang.error_user,
                                    'error'
                                ).catch(swal.noop);
							}
                        },
                        error: function(xhr)
                        {
                            //Muestra en pantalla e imprime en la consola del navegador el error.
                            swal(
                                lang.error_title ,
                                lang.error_code_status+xhr.status+': '+xhr.statusText,
                                'error'
                            ).catch(swal.noop);
                            console.log(xhr);
                        }
                    });//Final AJAX

				}
			}
        };


        /**
         ** Evento que se ejecuta al querer enviar el correo con el código.
         **/
        function sendEmail() {
            //Email a enviar el correo
            var email = $("#sltEmail").val();
            if(email == 'none'){
                email = $('#txtEmailOther').val();
            }
            if(!special_characters_in_mail(email)){
                //Llamada a AJAX para enviar el correo
                $.ajax({
                    type: "POST",
                    url: "/Start/sendEmail",
                    data: {
                        "email":email
                    } ,
                    success: function(data)
                    {
                        //Se convierte a JSON la respuesta
                        var r = JSON.parse(data);

                        //Se almacena el código.
                        codeR = r.code;
                        //Mensaje de éxito
                        swal(
                            lang.success_title,
                            lang.send_email,
                            'success'
                        ).catch(swal.noop);
                        //Se desabilita la etapa actual y se habilita la siguiente
                        var $active = $('.wizard .nav-tabs li.active');
                        $active.addClass('disabled');
                        $active.next().removeClass('disabled');
                        nextTab($active);

                    },
                    error: function(xhr)
                    {
                        //Muestra en pantalla e imprime en la consola del navegador el error.
                        swal(
                            lang.error_title ,
                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                            'error'
                        ).catch(swal.noop);
                        console.log(xhr);
                    }
                });//Final AJAX
            }else{
                swal(
                    lang.error_title ,
                    lang.error_no_emails,
                    'error'
                ).catch(swal.noop);
            }

        };

        /**
         ** Evento que se ejecuta al querer verificar el código.
         **/
        $("#btnContinue").click(function (e) {
            //Se obtiene el código ingresado
            var code = $("#txtCode").val();

            if(codeR != -1){
                //Si el código es diferente a -1 significa que ya esta almacenado
                //Se verifica si esta vacío
                if(isEmpty(code)){
                    swal(
                        lang.warning_title,
                        lang.error_empty_code,
                        'warning'
                    ).catch(swal.noop);
                }else{
                    //Si no es alfanumerico
                    if(!isAlphanumeric(code)){
                        swal(
                            lang.error_title,
                            lang.error_userNameAlphanumeric,
                            'error'
                        ).catch(swal.noop);
                    }else{
                        //Verifica que los códigos sean iguales.
                    	if(code === codeR){
                            //Se desabilita la etapa actual y se habilita la siguiente
                            var $active = $('.wizard .nav-tabs li.active');
                            $active.addClass('disabled');
                            $active.next().removeClass('disabled');
                            nextTab($active);
						}else{

                            swal(
                                lang.error_title,
                                lang.error_code,
                                'error'
                            ).catch(swal.noop);
						}

                    }
                }
			}else{

			}



        });
        /**
         ** Evento que se ejecuta al querer actualizar la contraseña.
         **/
        $("#btnDo").click(function (e) {
            //Se obtienen las contraseñas
            var password = $("#txtPassword").val();
            var passwordRepeat = $("#txtPasswordRepeat").val();
            //Se verifican si estan vacias
                if(isEmpty(password) || isEmpty(passwordRepeat)){
                    swal(
                        lang.warning_title,
                        lang.error_passwordEmpty,
                        'warning'
                    ).catch(swal.noop);
                }else{
                    //Si cumplen con la longitud permitida
                	if(maxLength(password,30) && minLength(password,5)){
                	    //Si son alfanumericos
                        if(!isAlphanumeric(password) || !isAlphanumeric(passwordRepeat)){
                            swal(
                                lang.error_title,
                                lang.error_alpha_pass,
                                'error'
                            ).catch(swal.noop);
                        }else{
                            //Se verifica que las contraseñas ingresadas sean iguales
                            if(password === passwordRepeat){
                                //Llamada a AJAX para actualizar la contraseñas
                                $.ajax({
                                    type: "POST",
                                    url: "/Start/updatePassword",
                                    data: {
                                        "user":{'id':client,'password':password}
                                    } ,
                                    success: function(data)
                                    {
                                        //Mensaje de éxito
                                        swal(
                                            lang.success_title,
                                            lang.password_new,
                                            'success'
                                        ).catch(swal.noop);
                                        //Redireción al login
                                        setTimeout(function(){ window.location.href = "../"; }, 1000);


                                    },
                                    error: function(xhr)
                                    {
                                        //Muestra en pantalla e imprime en la consola del navegador el error.
                                        swal(
                                            lang.error_title ,
                                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                                            'error'
                                        ).catch(swal.noop);
                                        console.log(xhr);
                                    }
                                });//Final AJAX

                            }else{
                                //No coinciden las contraseñas
                                swal(
                                    lang.error_title,
                                    lang.error_match,
                                    'error'
                                ).catch(swal.noop);
                            }
                        }
					}else{
                	    //El tamaño de la contraseña no es válido
                        swal(
                            lang.error_title,
                            lang.error_length,
                            'error'
                        ).catch(swal.noop);
					}
                }
        });

    /**
     * Funcion que muestra el espacio para ingresar otro email en caso que el deseado no aparezca en la lista
     */
    $( "#sltEmail" ).change(function() {
      if($( "#sltEmail" ).val() == 'none'){
          $("#divOther").show();
      }else{
          $("#divOther").hide();
      }
    });

    /**
     * Función que valida si el texto ingresado es un email válido
     * @param data: Texto a verficar
     * @returns {boolean}: True si es un email válido, false de lo contrario.
     */
    function special_characters_in_mail(data) {
        var expr = /^[a-zA-Z0-9_\.\-]+@[a-zA-Z\-]+\.[a-zA-Z\-\.]+$/;
        if (!expr.test(data)) {
            return true;
        } else {
            return false;
        }
    }

