/**
** Función que se encarga de construir el grid de la vista de clientes.
** http://js-grid.com/
**/

$(function() {
    
     var erase = false;
    
    //últimas locaciones cargadas
    var lastLocations;
    //Configuración del JSGrid
    $("#jsGrid").jsGrid({
        height: "auto",
        width: "100%",
        editing: true,
        autoload: true,
        paging: true,
        pageSize : 25,
        sorting: true,
        filtering: true,
        onItemDeleting: function(args) {
            if(erase === false){
                swal({
                    title: lang.delete_title,
                    text: lang.delete_warning,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: lang.delete_comfirm
                }).then(function () {
                    erase = true;
                    $("#jsGrid").jsGrid("deleteItem", args.item);
                }).catch(swal.noop);
                args.cancel = true;
            }else{
                erase = false;
            }
        },
        pagerFormat: lang.pag_page+" : {first} {prev} {pages} {next} {last} {pageIndex} "+lang.pag_of+" {pageCount}",
        pagePrevText: lang.pag_prev,
        pageNextText: lang.pag_next,
        pageFirstText: lang.grid_first,
        pageLastText: lang.grid_last,
        pageNavigatorNextText: "...",
        pageNavigatorPrevText: "...",
        noDataContent: lang.not_found,
        loadMessage: lang.waiting,
        invalidMessage: lang.invalid_data,
        //Dispara el evento que muestra el dialogo para editar.
        rowClick: function(args) {
            showDetailsDialog(lang.grid_edit, args.item);//Al hacer click llama al método que abre el dialog para actualizar un cliente
        },
        //Cada vez que se refresca el grid se vincula el popover a las celdas con el id popover
        onRefreshed: function () {
            $("td[data-toggle=popover]").popover({ placement: "top", trigger: "hover" ,container: 'body'});
        },
        //Métodos de manejo de datos
        controller: {
            loadData: function(filter) {
                var d = $.Deferred();
                //Consulta AJAX que trae todos los clientes
                $.ajax({
                    type: "GET",
                    url: "Administrator/clients/getAllClients",
                    dataType: "json",    
                }).done(function(result) {
                    
                    //Verificación de los filtros con los registros encontrados
                    result = $.grep(result, function(user) {
                        return (!filter.Name || user.Name.toUpperCase().indexOf(filter.Name.toUpperCase()) > -1 )&&
                        (!filter.username || user.username.toUpperCase().indexOf(filter.username.toUpperCase()) > -1) &&
                        (!filter.text || user.locationsName.toUpperCase().indexOf(filter.text.toUpperCase()) > -1 ||
                        user.text.toUpperCase().indexOf(filter.text.toUpperCase()) > -1) &&
                        (!filter.password || user.password.toUpperCase().indexOf(filter.password.toUpperCase()) > -1) &&
                        (filter.isActive === undefined || user.isActive == ((filter.isActive)?1:0));
                    });
                    d.resolve(result);
                })
                    return d.promise();
            },
            insertItem: function(user) {
                var locations = $('#sltLocation').val();
                var isGlobal = 0;
                if(locations[0] === 'public'){
                    locations = lastLocations;
                    isGlobal = 1;
                }
                user['isGlobal'] = isGlobal;
                //Consulta AJAX que inserta un cliente
                $.ajax({
                    type: "POST",
                    url: "Administrator/clients/insertClient",
                    data: {"user":user,"locations":locations},
                    success: function(data)             
                    {
                        //console.log(data);
                        //Si data es 0 significa que el nombre de usuario ya esta ocupado, si es 1 esta disponible.
                        if(data == 0){
                            //Mensaje de que ocurrio un error
                            swal(
                                lang.error_title,
                                lang.insert_error,
                                'error'
                            ).catch(swal.noop);
                        }else{
                            //Cierra el dialog
                            $("#detailsDialog").dialog("close");
                            //Mensaje de que se insertó correctamente. 
                            swal(
                            lang.success_title,
                            lang.insert_success_client,
                            'success'
                            ).catch(swal.noop);
                        }
                        //Al insertar un nuevo usuario se vuelve a cargar el contenido del grid
                        $("#jsGrid").jsGrid("loadData");
                    },
                    error: function(xhr)
                    {
                        //Muestra en pantalla e imprime en la consola del navegador el error.
                        swal(
                            lang.error_title ,
                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                            'error'
                        ).catch(swal.noop);
                        console.log(xhr);
                    }
                });
            },
            updateItem: function(user) {
                var locations = $('#sltLocation').val();
                var isGlobal = 0;
                if(locations[0] === "public"){
                    locations = lastLocations;
                    isGlobal = 1;
                }
                user['isGlobal'] = isGlobal;
                //Consulta AJAX que actualiza un cliente
                $.ajax({
                    type: "POST",
                    url: "Administrator/clients/updateClient",
                    data: {"user":user,"locations":locations},
                    success: function(data)
                    {
                        //Si data es 0 significa que el nombre de usuario ya esta ocupado, si es 1 esta disponible.
                        if(data == 0){
                            //Mensaje de que ocurrio un error
                            swal(
                                lang.error_title,
                                lang.update_error,
                                'error'
                            ).catch(swal.noop);
                        }else{
                            //Cierra el dialog
                            $("#detailsDialog").dialog("close");
                            //Mensaje de que se actualizó correctamente.
                            swal(
                                lang.success_title,
                                lang.update_success_client,
                                'success'
                            ).catch(swal.noop);
                        }
                        //Al actualizar un cliente se vuelve a cargar el contenido del grid
                        $("#jsGrid").jsGrid("loadData");

                    },
                    error: function(xhr)
                    {
                        //Muestra en pantalla e imprime en la consola del navegador el error.
                        swal(
                            lang.error_title ,
                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                            'error'
                        ).catch(swal.noop);
                        console.log(xhr);
                    }
                });
            },
            deleteItem: function(user) {
                //Consulta AJAX que elimina un administrador
                $.ajax({
                    type: "POST",
                    url: "Administrator/clients/deleteClient",
                    data: {"user":user},
                    success: function(data)
                    {
                            console.log(data);
                            //Mensaje de que se elimino correctamente.
                            swal(
                                lang.success_title,
                                lang.delete_success_client,
                                'success'
                            ).catch(swal.noop);

                        //Al eliminar un administrador se vuelve a cargar el contenido del grid
                        $("#jsGrid").jsGrid("loadData");
                    },
                    error: function(xhr)
                    {
                        //Muestra en pantalla e imprime en la consola del navegador el error.
                        swal(
                            lang.error_title ,
                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                            'error'
                        ).catch(swal.noop);
                        console.log(xhr);
                    }
                });
            }
        },
        //Se encarga de agregar un popover a la columna de locaciones
        rowRenderer: function(client) {
            var $row = $('<tr>');
            //Asigna los valores del cliente a las celdas
            this._renderCells($row, client);
            $locations = $row[0].children[1];
            //Asigna el texto completo de las locaciones al popover
            $($locations).attr("data-toggle", "popover");
            $($locations).attr("data-content",client.locationsName);
            $($locations).attr("title", lang.attr_locations);

            return $row;
        },
        //Se definen los campos que tendrá el grid
        fields: [
            { name: 'Name', type: "text", title: lang.attr_company, width: 100 },
            { name: 'text', type: "text", title: lang.attr_locations, width: 150 },
            { name: 'username',title:lang.attr_username, type: "text", width: 100 },
            { name: 'password',title:lang.attr_password, type: "text", width: 100 },
            { name: 'isActive' ,type: "checkbox", title: lang.attr_active,width: 50  },
            {
                type: "control",
                modeSwitchButton: false,
                editButton: false,
                deleteButton: true,
                clearFilterButtonTooltip: lang.control_clean,
                searchButtonTooltip: lang.control_search,
                //Modificación del botón de agregar
                headerTemplate: function() {
                    return $("<input>").attr("type", "button").addClass('jsgrid-button jsgrid-insert-button')
                        .on("click", function () {
                            showDetailsDialog(lang.grid_add, {});//Al hacer click llama al método que abre el dialog para agregar un nuevo cliente
                        });
                }
            }
        ]
    });

    //Dialog para insertar y actualizar los administradores
    $("#detailsDialog").dialog({
        autoOpen: false,
        width: 400,
        height: 'auto',
        minWidth: 500,
        minHeight: 300,
        modal: true,
        fluid: true,
        resizable: false,
        open: function(event, ui){
            fluidDialog();
        },
        //Al cerrar reinicie el dialog
        close: function() {
            $("#detailsForm").validate().resetForm();
            $("#detailsForm").find(".error").removeClass("error");
        }
    });


    //Se ejecuta en todos los dialog
    $(document).on("dialogopen", ".ui-dialog", function (event, ui) {
        fluidDialog();
    });

    //Remueve el nombre de espacio de la ventana de redimensionar
    $(document).on("dialogclose", ".ui-dialog", function (event, ui) {
        $(window).off("resize.responsive");
    });

    //Función para que el dialog sea responsive
    function fluidDialog() {
        var $visible = $(".ui-dialog:visible");
        //Cada dialog visible
        $visible.each(function () {
            var $this = $(this);
            var dialog = $this.find(".ui-dialog-content").data("ui-dialog");
            // Si la opción fluid es true
            if (dialog.options.maxWidth && dialog.options.width) {
                // Arregla el bud max-width
                $this.css("max-width", dialog.options.maxWidth);
                //Reposiciona el dialog
                dialog.option("position", dialog.options.position);
            }

            if (dialog.options.fluid) {
                //Agrega el nombre de espacio de la ventana de redimensionar
                $(window).on("resize.responsive", function () {
                    var wWidth = $(window).width();
                    //Compara el width de la ventana con el del dialog
                    if (wWidth < dialog.options.maxWidth + 50) {
                        //Mantener el dialog llenando toda la pantalla
                        $this.css("width", "90%");

                    }
                    //Reposiciona el dialog
                    dialog.option("position", dialog.options.position);
                });
            }

        });
    }
    //Validación para alfanumérica
    $.validator.addMethod("alphanumeric", function(value, element) {
        return this.optional(element) || /^[a-z0-9\-\s]+$/i.test(value);
    }, "");

    //Validaciones del form del dialog
    $("#detailsForm").validate({
        //Restricciones de los campos
        rules: {
            sltOrganization: { required: true},
            txtUserName: { required: true, minlength:5,maxlength:30,alphanumeric : true},
            txtPassword: { required: true, minlength:5,maxlength:30,alphanumeric : true}
        },
        //Mensajes de error para cada campo
        messages: {
            txtCompany: lang.eattr_company,
            txtUserName: lang.eattr_username,
            txtPassword: lang.eattr_password
        },
        //Método que se encargara de manejar el submit del form
        submitHandler: function() {
            formSubmitHandler();
        }
    });

    var formSubmitHandler = $.noop;

    //Método que se encarga de preparar el dialog ya sea para insertar o actualizar
    var showDetailsDialog = function(dialogType, client) {
        //Muestra el dialog
        $("#detailsDialog").removeClass("invisible");
        //Deselecciona todas las opciones marcadas
        $('#sltOrganization').selectpicker('deselectAll');
        var locations;
            //Obtenemos las restricciones del form
            var settings = $('#detailsForm').validate().settings;
            //Limpiamos el campo de contraseña
            $("#txtPassword").val('');
            //Verifica si va a insertar
            if(dialogType === lang.grid_add){
                //Se selecciona el primero de la lista
                $('#sltOrganization :nth-child(1)').prop('selected', true);
                //Agregamos la regla de que la contraseña sea obligatoria y las restricciones de tamaño
                settings.rules.txtPassword = {required: true,minlength:5,maxlength:30,alphanumeric: true};
                //Oculta el check de active y lo marca por que todo usuario al inicio esta activo y muestra la contraseña.
                $("#divActive").hide();
                $("#chkActive").prop("checked", 1);
            }else{

                //Eliminamos la regla de que la contraseña sea obligatoria
                delete settings.rules.txtPassword.required;
                //Se muestra el div para activar o desactivar un cliente
                $("#divActive").show();
                //Se le asigna el valor del cliente
                $("#chkActive").prop("checked", client.isActive);
                //Se selecciona la organización del cliente
                $("#sltOrganization option[value='"+client.idOrganization+"']").prop("selected", true);
                //Se almacenan las locaciones del cliente
                locations = client.locationsId
            }
            //Asigna los valores del cliente a editar en los campos de texto.
            $("#txtUserName").val(client.username);

            $('#sltOrganization').selectpicker('refresh');
            //Se cargan las locaciones de la organización
            chargeLocations(locations);

           
           //Función que se encarga manejar el submit del form en el dialog
            formSubmitHandler = function() {
                saveClient(client, dialogType === lang.grid_add);
            };

            //Abre el dialog
            $("#detailsDialog").dialog("option", "title", dialogType )
                .dialog("open");
    };


    //Función que se encarga de ingresar o actualizar el cliente
    var saveClient = function(client, isNew) {
        //Se combina el cliente con los otros atributos
    $.extend(client, {
        idOrganization: $('#sltOrganization').val(),
        username: $("#txtUserName").val(),
        password: $("#txtPassword").val(),
        isActive: ($("#chkActive").is(":checked"))?1:0,
    });

    //Llama al método de ingresar o actualizar del jsgrid 
    $("#jsGrid").jsGrid(isNew ? "insertItem" : "updateItem", client);
    //Desmarca el check de si es activo o no
    $("#chkActive").attr('checked', false);
                
    };

    /**
     * Evento que se ejecuta al cambiar una opción del select de organizaciones
     */
    $( "#sltOrganization" ).change(function() {
        chargeLocations();
    });

    //Significa que el evento de cambio esta siendo disparado por el usuario
    var changeEvent = true;


    /**
     * Función que se encarga de llenar el select de las locaciones y marcar si el cliente
     * ya tiene seleccionadas.
     * @param locationsId: id de las locaciones
     */
    function chargeLocations(locationsId){
        //Reinicia las ultimas locaciones cargadas
        lastLocations= [];
        //Se obtiene la organización
        var organization = $('#sltOrganization').val();
        //Si la organización es públic
        if(organization === "public"){
            //Se vacian las locaciones
            $("#sltLocation").empty();
            //Se agrega la opción públic
            $("#sltLocation").append("<option value='public' selected>"+lang.all+"</option>");
            //Se refresca el select
            $('#sltLocation').selectpicker('refresh');

            //Se obtiene la organización
            var locations = $('#sltLocation').val();
            //Si la organización es públic
            if(locations === "public"){
                deselect = true;
            }else {
                deselect = false;
            }
            //Si es una específica
        }else{

            //Llamada ajax para obtener las localizaciones
            $.ajax({
                type: "POST",
                url: "Administrator/Files/getLocations",
                data: {"organization":organization},
                success: function(data)
                {
                    //console.log(data);
                    //Convertimos a JSON
                    var location = JSON.parse(data);
                    //Se vacia el select de las locaciones
                    $("#sltLocation").empty();
                    //Se agrega la opción públic
                    $("#sltLocation").append("<option value='public'>"+lang.all+"</option>");
                    //Por cada locación
                    jQuery.each(location, function(i, val) {
                        //Se agrega al select
                        $("#sltLocation").append("<option value="+val.Id+">"+val.Name+"</option>");
                        //Se agrega el id al arreglo del últimas locaciones
                        lastLocations.push(val.Id);
                    });
                    //Si locationsId no esta indefinido
                    if(typeof locationsId != "undefined"){
                        //Se indica que el cambio no lo realiza el usuario, sino mas bien el sistema
                        changeEvent = false;
                        //Se deseleccionan todos
                        //$('#sltLocation').selectpicker('deselectAll');
                        //Se reinicia la variable
                        changeEvent = true;
                        //Si la cantidad de locaciones marcadas es igual a la cantidad de locaciones totales
                        if(lastLocations.length === locationsId.length ){
                            //Se selecciona la opción Todos(public)
                            $("#sltLocation option[value='public']").prop("selected", true);
                        }else{
                            //Se seleccionan las opciones que vienen el id de arreglos
                            for(i=0;i<locationsId.length;i++){
                                $("#sltLocation option[value='"+locationsId[i]+"']").prop("selected", true);
                            }
                        }
                    }else{
                       $("#sltLocation option[value='public']").prop("selected", true); 
                    }
                    //Se actualiza el select
                    $('#sltLocation').selectpicker('refresh');
                    //Se obtiene la organización
                    var locations = $('#sltLocation').val();
                    //Si la organización es públic
                    if(locations[0] === "public"){
                        deselect = true;
                    }else {
                        deselect = false;
                    }

                },
                error: function(xhr)
                {
                    //Muestra en pantalla e imprime en la consola del navegador el error.
                    swal(
                        lang.error_title ,
                        lang.error_code_status+xhr.status+': '+xhr.statusText,
                        'error'
                    ).catch(swal.noop);
                    console.log(xhr);
                }
            });
        }

    };
    //Esta la opción todos seleccionado, lo que significa que las otras estan deseleccionadas.
    var deselect = true;

    /**
     * Evento que se ejecuta cuando se cambia la opción del select de locaciones
     **/
    $( "#sltLocation" ).change(function() {
        //Se obtiene las locaciones
        var locations = $('#sltLocation').val();
        //Si solo esta seleccionado la opción public(Todos)
        if(deselect){
            //Si hay seleccionada más de una opción
            if(locations.length == (lastLocations.length+1)){
                //Se deseleccionan todas las opciónes
                $('#sltLocation').selectpicker('deselectAll');
                //Se selecciona la opción públic
                $("#sltLocation option[value='public']").prop("selected", true);
                //Se refresca el select
                $('#sltLocation').selectpicker('refresh');
                //Solo esta seleccionada la opción públic
                deselect = true;
            }
            else if(locations.length > 1){
                //Se deselecciona la opción public
                $("#sltLocation option[value='public']").prop("selected", false);
                //Se reffresca el select
                $('#sltLocation').selectpicker('refresh');
                //Ya no esta marcada solo a la opción pública
                deselect = false;
            }
            //Si no esta marcado solo la opción públic
        }else{
            //Si esta seleccionada la opción públic
            if(locations[0]==="public" || locations.length == lastLocations.length){
                //Se deseleccionan todas las opciónes
                $('#sltLocation').selectpicker('deselectAll');
                //Se selecciona la opción públic
                $("#sltLocation option[value='public']").prop("selected", true);
                //Se refresca el select
                $('#sltLocation').selectpicker('refresh');
                //Solo esta seleccionada la opción públic
                deselect = true;
            }
        }
        //Si no hay ningúna seleccionada y el evento se dispara por un cambio hecho por el usuario
        if(locations.length == 0 && changeEvent){
            //Selecciona la opción públic
            $("#sltLocation option[value='public']").prop("selected", true);
            //Se refresca el select
            $('#sltLocation').selectpicker('refresh');
            //Solo esta marcada la opción públic
            deselect = true;
        }

    });

    $('.jsgrid-filter-row > td > input').attr("placeholder",lang.filter_one);

});
