/**
 ** Función que se encarga de construir el grid de la vista de administradores.
 ** http://js-grid.com/
 **/
 
 $( document ).ready(function() {
    $("#sltLocation").empty();
    $("#sltLocation").append("<option value='private' selected>"+lang.none+"</option>");
    $("#sltLocation").selectpicker('refresh');
    $("#sltLocation").prop('disabled', true);
    $("#sltOrganization").prop('disabled', true);


});
 
 $('#filterCheck').change(function() {
         var chk = $('#filterCheck').is(":checked");
         if(chk){
             $('#sltOrganization').prop('disabled', false);
             $('#sltLocation').prop('disabled', false);
         }else{
            $('#sltOrganization').prop('disabled', true);
            $('#sltLocation').prop('disabled', true);
         }
        $("#jsGrid").jsGrid("loadData");
});
 
 
$(function() {

    // Acceso a eliminar archivos
    var deleteAccess;
    //Solo si es super admin tiene acceso a eliminar archivos
    if(superadmin == 1){
        deleteAccess = true;
    }else{
        deleteAccess = false;
    }

    //Variable que indica si ya se dio permiso para eliminar un archivo
    var erase = false;


    //Configuración del JSGrid
    $("#jsGrid").jsGrid({
        height: "auto",
        width: "100%",
        editing: true,
        autoload: true,
        paging: true,
        pageSize : 25,
        sorting: true,
        filtering: true,
        onItemDeleting: function(args) {
            //Si no se ha dado permiso
            if(erase === false){
                //Muestra el mensaje de confirmación
                swal({
                    title: lang.delete_title,
                    text: lang.delete_warning,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: lang.delete_comfirm
                }).then(function () {
                    //Si se da confirmación
                    erase = true;
                    //Se procede a eliminar el archivo
                    $("#jsGrid").jsGrid("deleteItem", args.item);
                }).catch(swal.noop);
                //Se cancela la eliminacion para esperar el permiso
                args.cancel = true;
            }else{
                //Se reinicia el permiso
                erase = false;
            }
        },
        //Cada vez que se refresca el grid se vincula el popover a las celdas con el id popover
        onRefreshed: function () {
            $("td[id=popover]").popover({ placement: "top", trigger: "hover",container: 'body'});
        },
        pagerFormat: lang.pag_page+" : {first} {prev} {pages} {next} {last} {pageIndex} "+lang.pag_of+" {pageCount}",
        pagePrevText: lang.pag_prev,
        pageNextText: lang.pag_next,
        pageFirstText: lang.grid_first,
        pageLastText: lang.grid_last,
        pageNavigatorNextText: "...",
        pageNavigatorPrevText: "...",
        noDataContent: lang.not_found,
        loadMessage: lang.waiting,
        invalidMessage: lang.invalid_data,
        //Dispara el evento que muestra el dialogo para editar.
        rowClick: function(args) {
            showDetailsDialog( args.item);//Al hacer click llama al método que abre el dialog para actualizar un administrador
        },
        //Métodos de manejo de datos
        controller: {
            loadData: function(filter) {
                var organization = $('#sltOrganization').val();
                var chk = $('#filterCheck').is(":checked");
                if(!chk){
                    organization = "all";
                }
                var location = $('#sltLocation').val();
                var d = $.Deferred();
                //Consulta AJAX que trae todos los archivos
                $.ajax({
                    type: "POST",
                    url: "Administrator/Files/getAllFiles",
                    data: {"location":location,"organization":organization},
                    dataType: "json",
                }).done(function(result) {
                    //console.log(result);
                    //Verificación de los filtros con los registros encontrados
                    result = $.grep(result, function(file) {
                        return (!filter.text || file.Name.toUpperCase().indexOf(filter.text.toUpperCase()) > -1) &&
                            (!filter.Location || file.Location.toUpperCase().indexOf(filter.Location.toUpperCase()) > -1) &&
                            (!filter.creationDate || file.creationDate.toUpperCase().indexOf(filter.creationDate.toUpperCase()) > -1) &&
                            (filter.validity === undefined || file.validity == ((filter.validity)?1:0));

                    });
                    d.resolve(result);
                })

                return d.promise();
            },
            updateItem: function(file) {
                //Consulta AJAX que actualiza un archivo
                $.ajax({
                    type: "POST",
                    url: "Administrator/files/updateFile",
                    data: {"file":file},
                    success: function(data)
                    {
                        console.log(data);
                        //Cierra el dialog
                        $("#detailsDialog").dialog("close");
                        //Mensaje de que se actualizó correctamente.
                        swal(
                            lang.success_title,
                            lang.update_success_file,
                            'success'
                        ).catch(swal.noop);

                        //Al actualizar un archivo se vuelve a cargar el contenido del grid
                        $("#jsGrid").jsGrid("loadData");
                    },
                    error: function(xhr)
                    {
                        //Muestra en pantalla e imprime en la consola del navegador el error.
                        swal(
                            lang.error_title ,
                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                            'error'
                        ).catch(swal.noop);
                        console.log(xhr);
                    }
                });
            },
            deleteItem: function(file) {
                //Consulta AJAX que elimina un archivo

                $.ajax({
                    type: "POST",
                    url: "Administrator/files/deleteFile",
                    data: {"file":file},
                    success: function(data)
                    {
                            swal(
                                lang.success_title,
                                lang.delete_success_file,
                                'success'
                            ).catch(swal.noop);

                        //Al eliminar un archivo se vuelve a cargar el contenido del grid
                        $("#jsGrid").jsGrid("loadData");
                    },
                    error: function(xhr)
                    {
                        //Muestra en pantalla e imprime en la consola del navegador el error.
                        swal(
                            lang.error_title ,
                            lang.error_code_status+xhr.status+': '+xhr.statusText,
                            'error'
                        ).catch(swal.noop);
                        console.log(xhr);
                    }
                });
                 
            }
        },
        //Se encarga de agregar un popover a la columna de locaciones
        rowRenderer: function(file) {
            //console.log(file);
            var $row = $('<tr>');
            //Asigna los valores del cliente a las celdas
            this._renderCells($row, file);
            
            $name = $row[0].children[0];
            //Asigna el texto completo de las locaciones al popover
            $($name).attr("id", "popover");
            $($name).attr("data-content", file.Location);
            $($name).attr("title",lang.attr_location_organization);
            
            $name = $row[0].children[1];
            //Asigna el texto completo de las locaciones al popover
            $($name).attr("id", "popover");
            $($name).attr("data-content", file.Name);
            $($name).attr("title",lang.attr_name_file );

            return $row;
        },
        //Se definen los campos que tendrá el grid
        fields: [
            { name: 'textLocation',title:lang.attr_location_organization, type: "text", width: 170 },
            { name: 'text',title:lang.attr_name_file, type: "text", width: 150 },
            { name: 'validity' ,type: "checkbox", title: lang.attr_validity,width: 50  },
            { name: 'creationDate' ,type: "text", title: lang.attr_date,width: 50  },
            {
                type: "control",
                itemTemplate: function(value, item) {
                    var $result = jsGrid.fields.control.prototype.itemTemplate.apply(this, arguments);

                    var $customButton = $("<input type='button' class='download-button'>")
                        .click(function (e) {
                            download(item.Id,true);
                            e.stopPropagation();
                        });

                    return $result.add($customButton);
                },
                modeSwitchButton: false,
                editButton: false,
                deleteButton: deleteAccess,
                clearFilterButtonTooltip: lang.control_clean,
                searchButtonTooltip: lang.control_search
            }
        ]
    });


    //Dialog para insertar y actualizar los administradores
    $("#detailsDialog").dialog({
        autoOpen: false,
        width: 400,
        height: 'auto',
        minWidth: 400,
        maxWidth: 600,
        minHeight: 230,
        modal: true,
        fluid: true,
        resizable: false,
        open: function(event, ui){
            fluidDialog();
        },
        //Al cerrar reinicie el dialog
        close: function() {
            $("#detailsForm").validate().resetForm();
            $("#detailsForm").find(".error").removeClass("error");
        }
    });


    //Se ejecuta en todos los dialog
    $(document).on("dialogopen", ".ui-dialog", function (event, ui) {
        fluidDialog();
    });

    //Remueve el nombre de espacio de la ventana de redimensionar
    $(document).on("dialogclose", ".ui-dialog", function (event, ui) {
        $(window).off("resize.responsive");
    });

    //Función para que el dialog sea responsive
    function fluidDialog() {
        var $visible = $(".ui-dialog:visible");
        //Cada dialog visible
        $visible.each(function () {
            var $this = $(this);
            var dialog = $this.find(".ui-dialog-content").data("ui-dialog");
            // Si la opción fluid es true
            if (dialog.options.maxWidth && dialog.options.width) {
                // Arregla el bud max-width
                $this.css("max-width", dialog.options.maxWidth);
                //Reposiciona el dialog
                dialog.option("position", dialog.options.position);
            }

            if (dialog.options.fluid) {
                //Agrega el nombre de espacio de la ventana de redimensionar
                $(window).on("resize.responsive", function () {
                    var wWidth = $(window).width();
                    //Compara el width de la ventana con el del dialog
                    if (wWidth < dialog.options.maxWidth + 50) {
                        //Mantener el dialog llenando toda la pantalla
                        $this.css("width", "90%");

                    }
                    //Reposiciona el dialog
                    dialog.option("position", dialog.options.position);
                });
            }

        });
    }



    //Validación para alfanumérica
    $.validator.addMethod("alphanumeric", function(value, element) {
        return this.optional(element) || /^[a-z0-9\-\s]+$/i.test(value);
    }, "");

    //Validaciones del form del dialog
    $("#detailsForm").validate({


        //Restricciones de los campos
        rules: {
            txtName: { required: true, minlength:5,alphanumeric : true}
        },
        //Mensajes de error para cada campo
        messages: {
            txtName: lang.eattr_file_name
        },

        //Método que se encargara de manejar el submit del form
        submitHandler: function() {
            formSubmitHandler();
        }
    });

    var formSubmitHandler = $.noop;

    //Método que se encarga de preparar el dialog ya sea para insertar o actualizar
    var showDetailsDialog = function(file) {
        //Se muestra el dialog
        $("#detailsDialog").removeClass("invisible");
        //Se asigna el valor de validéz del archivo al check
        $("#chkValidity").prop("checked", file.validity);
        $("#txtName").val(file.Name);


        //Función que se encarga manejar el submit del form en el dialog
        formSubmitHandler = function() {
            saveClient(file);
        };

        //Abre el dialog
        $("#detailsDialog").dialog("option", "title", lang.grid_edit)
            .dialog("open");
    };


    //Función que se encarga de ingresar o actualizar el archivo
    var saveClient = function(file) {
        //Se combina el archivo con los otros atributos
        $.extend(file, {
            validity: ($("#chkValidity").is(":checked"))?1:0,
            name: $("#txtName").val()
        });

        //Llama al método de actualizar del jsgrid
        $("#jsGrid").jsGrid("updateItem", file);

    };

});

$( "#sltOrganization" ).change(function() {
    $("#sltLocation").prop('disabled', false);
    var organization = $('#sltOrganization').val();
    if(organization === "public"){
        $("#sltLocation").empty();
        $("#sltLocation").append("<option value='public' selected>"+lang.all+"</option>");
        $('#sltLocation').selectpicker('refresh');
        $("#jsGrid").jsGrid("loadData");
    }else if(organization === "private"){
            $("#sltLocation").empty();
            $("#sltLocation").append("<option value='private' selected>"+lang.none+"</option>");
            $("#sltLocation").selectpicker('refresh');
            $("#sltLocation").prop('disabled', true);
            $("#jsGrid").jsGrid("loadData");
    }else{
        show(lang.waiting);
        $.ajax({
            type: "POST",
            url: "Administrator/Files/getLocations",
            data: {"organization":organization},
            success: function(data)
            {
                //Se convierte a JSON
                var location = JSON.parse(data);
                //Se vacia el select de locaciones
                $("#sltLocation").empty();
                //Se agrega y selecciona la opción públic
                $("#sltLocation").append("<option value='public' selected>"+lang.all+"</option>");
                //Para cada locación
                jQuery.each(location, function(i, val) {
                    //Se agrega al select
                    $("#sltLocation").append("<option value="+val.Id+">"+val.Name+"</option>");
                });
                //Se refresca el select
                $('#sltLocation').selectpicker('refresh');
                //Al actualizar se vuelve a cargar el contenido del grid
                $("#jsGrid").jsGrid("loadData");
                hide();
            },
            error: function(xhr)
            {
                //Muestra en pantalla e imprime en la consola del navegador el error.
                swal(
                    lang.error_title ,
                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                    'error'
                ).catch(swal.noop);
                console.log(xhr);
            }
        });
    }


});

/**
 * Evento que se ejecuta cuando se cambia la opción del select de locaciones
 */
$( "#sltLocation" ).change(function() {
    //Carga de nuevo los datos del jsgrid
    $("#jsGrid").jsGrid("loadData");
});


/**
 * Función que se encarga de descargar un archivo o versión.
 * @param id : id del archivo o versión
 * @param isFile : indica si es archivo o versión
 */
function download(id,isFile){
    show(lang.downloading);
    //Llamada al servidor
    var xhr = new XMLHttpRequest();
    xhr.open('POST', 'Client/Main/downloadFile', true);
    xhr.responseType = 'json';

    xhr.setRequestHeader('Content-type', 'application/json; charset=utf-8');
    xhr.onload = function(e) {

        //Respuesta del servidor
        var v = this.response;
        //console.log(v);
        //Si todo salio bien
        if (this.status == 200) {
            //Creamos un elemento anchor, le asignamos el contenido de nuestro archivo o versión
            // y desparamos el evento click en él para que se descargue.
            var link=document.createElement('a');
            var blob = b64toBlob(v.content, v.type);
            var blobUrl = URL.createObjectURL(blob);
            link.href= blobUrl;
            link.download=v.name.replace(/\./g, " ")+"."+v.extension;
            link.click();
            hide();
        } else {
            hide();
            swal(
                lang.error_title,
                lang.download_error,
                'error'
            ).catch(swal.noop);
        }
    };
    //Datos a ser enviados
    var jsonData = {
        'file': id,
        'isFile':isFile
    };
    //Se envia la petición
    xhr.send(JSON.stringify(jsonData));

}


function b64toBlob(b64Data, contentType, sliceSize) {
  contentType = contentType || '';
  sliceSize = sliceSize || 512;

  var byteCharacters = atob(b64Data);
  var byteArrays = [];

  for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
    var slice = byteCharacters.slice(offset, offset + sliceSize);

    var byteNumbers = new Array(slice.length);
    for (var i = 0; i < slice.length; i++) {
      byteNumbers[i] = slice.charCodeAt(i);
    }

    var byteArray = new Uint8Array(byteNumbers);

    byteArrays.push(byteArray);
  }
  var blob = new Blob(byteArrays, {type: contentType});
  return blob;
}



