
/**
** Se encarga de obtener el diccionario de mensaje por medio de una consulta ajax al servidor
**/

//Diccionario con los mensajes 
var lang;
//Variable que indica si ya se cargo el dictionario de mensajes anteriormente.
var load = false;

//Verifica si localstorage esta habilitado en el navegador del usuario
if(typeof(Storage) !== "undefined") {
    //verifica si ya fue cargado el diccionario, si es así modifica el valor de la variable load
    if (localStorage.language) {
        load = true;
    }
}


//Si no ha sido cargado el diccionario, realiza la consulta ajax para solicitarlo
if(!load){
    $.ajax({                        
        type: "GET",                 
        url: "/OrkinWebClients/Language/getDictionary",
        async: false,//Mo es asincrónico para que las demas esperen a que el diccionario esta cargado.
        success: function(data)             
        {
            //Guarda el diccionario en el localstorage
             localStorage.language = data;
             //Lo que se almacena es un JSON, por lo tanto se realiza la conversión y se guarda en
             // la variable lang, la cual va a ser accesado por las demas librerías javascript.
             lang =  JSON.parse(localStorage.language); 
        },
        error: function(xhr)
        {
            //Muestra en pantalla e imprime en la consola del navegador el error.
            swal(
                lang.error_title ,
                lang.error_code_status+xhr.status+': '+xhr.statusText,
                'error'
            ).catch(swal.noop);
            console.log(xhr);
        }
    });
}else{
    //Lo que se almacena es un JSON, por lo tanto se realiza la conversión y se guarda en
    // la variable lang, la cual va a ser accesado por las demas librerías javascript.
    lang =  JSON.parse(localStorage.language);
    //Elimina el dictionario del localStorage para volver a ser recuperado(Descomentar en caso de cambios,recargar un par de veces el sitio y volver a comentar.)
    localStorage.removeItem("language");

}
