/**
** Validación de los datos del formulario de login.
**/
function validate(){

	//Se obtienen los valores ingresados
    var userName = $('#txtUserName').val();
    var password = $('#txtPassword').val();

    //Variable de control para saber si no existe error y se puede enviar la información.
    var submit = true;
	    
	    //Validaciones al nombre de usuario ingresado.

	    //Verifica si esta vacio
	    if(isEmpty(userName)){
	    	submit = false;
	    	$('#errorUserName').hide().html(lang.error_userNameEmpty).fadeIn(400);//Muestra el mensaje de error si esta vacio.
	    }else{
	    	//Verifica si cumple con el máximo de caractéres permitidos
	    	if(maxLength(userName,30)){
	    		//Verifica si cumple con el mínimo de caractéres permitidos
	    		if(minLength(userName,5)){
	    			//Verifica si es alfanumérico
	    			if(isAlphanumeric(userName)){
	    				$('#errorUserName').html('');//Limpia el mensaje de error
	    			}else{
	    				submit = false;
	    				$('#errorUserName').hide().html(lang.error_userNameAlphanumeric).fadeIn(400);//Muestra el mensaje de error si no es alfanumérico
	    			}
	    		}else{
	    			submit = false;
	    			$('#errorUserName').hide().html(lang.error_userNameMin).fadeIn(400);//Muestra el mensaje de error si no cumple con el mínimo de caractéres establecidos
	    		}
	    	}else{
	    		submit = false;
	    		$('#errorUserName').hide().html(lang.error_userNameMax).fadeIn(400);//Muestra el mensaje de error si no cumple con el máximo de caractéres establecidos
	    	}
	    }

	    //Valdaciones a la contraseña ingresada.

	    //Verifica si esta vacio
	    if(isEmpty(password)){
	    	submit = false;
	    	$('#errorPassword').hide().html(lang.error_passwordEmpty).fadeIn(400);//Muestra el mensaje de error si esta vacio.
	    }else{
	    	//Verifica si cumple con el máximo de caractéres permitidos
	    	if(maxLength(password,30)){
	    		//Verifica si cumple con el mínimo de caractéres permitidos
	    		if(minLength(password,5)){
	    			$('#errorPassword').html('');//Limpia el mensaje de error
	    		}else{
	    			submit = false;
	    			$('#errorPassword').hide().html(lang.error_passwordMin).fadeIn(400);//Muestra el mensaje de error si no cumple con el mínimo de caractéres establecidos
	    		}
	    	}else{
	    		submit = false;
	    		$('#errorPassword').hide().html(lang.error_passwordMax).fadeIn(400);//Muestra el mensaje de error si no cumple con el máximo de caractéres establecidos
	    	}
	    }
		
		/**
		**	Si no existe error en la validación de los datos procede con la comprobación en base de datos
		**  por medio de ajax.
		**/
	    if(submit){
            show(lang.wait);
            $("#errorLogin").hide();

			console.log(userName+" "+password);
	    	$.ajax({                        
	           type: "POST",                 
	           url: "Start/check_login",
	           //Datos que se envian a comprobar                     
	           data: {
	           		"userName":userName,
	           		"password":password,
	           } , 
	           success: function(data)             
	           {
	           		//Lo que se recibe es un JSON, por eso se realiza la conversión.
	           		var obj = JSON.parse(data);
	           		//El valor de status nos va a indicar que paso del lado del servidor y así podremos tomar una decición 
	           		var status = obj.status;
	           		
	           		//Se detecto errores de validación en los datos del lado del servidor.
	           		if(status === 1){
						
                        $("#errorLogin").css('visibility', 'visible');
	           			$("#errorLogin").html(obj.response).fadeIn(400); //Se muestran los errores encontrados en el servidor
	           		}else{

	           			//El usuario ingresado o su contraseña es errónea.
	           			if(status === 2){
							console.log("status 2");
                            $("#errorLogin").css('visibility', 'visible');
	           				$("#errorLogin").html(lang.error_login).fadeIn(400); //Se muestra el error de que el usuario no existe
	           			}else{
	           				//Se inicio sesión exitosamente.
	           				//Respose es true is es administrador o false si es cliente
	           				if(obj.response){
	           					//Ingresa al módulo administrativo
	           					//window.location.href = "http://192.168.1.136/OrkinWebClients/Administrator/Structures/";
	           					window.location.href = page;
	           				}else{
	           				    if(obj.isGlobal == "1" ){
	           				        redirect_client(1);
	           				    }else{
	           				    //Se recuperan las locaciones del cliente
                                var location = obj.locations;
                                //Para cada locación
                                jQuery.each(location, function(i, val) {
                                	//Se agrega al select
                                    $("#sltLocation").append("<option value="+val.Id+">"+val.Name+"</option>");
                                });
                                if(location.length == 1){
                                    redirect_client(0);
                                }else{
                                     //Se refresca el select
                                    $('#sltLocation').selectpicker('refresh');
                                    //Se cambia la función a ejecutar con el click
                                    $("#btnLogIn").attr("onclick","redirect_client(0)");
                                    //Se muestra el div con el select de las locaciones
                                    $("#divLocation").css('visibility', 'visible');
                                    $("#divLocation").fadeIn(400);
                                    //Desabilita los campos de nombre de usuario y la contraseña
                                    $( "#txtUserName" ).prop( "disabled", true );
                                    $( "#txtPassword" ).prop( "disabled", true );
                                    //Se remueve la opción de recuperar contraseña
                                    $("#btnForgot").fadeOut(200);
                                    //Se cambia el texto del botón
                                    $("#btnLogIn").html(lang.btn_in).fadeIn(200);
                                }
	           				    }
	           				}
	           			}
	           		}
	           		hide();
	           },
	           error: function(xhr)
	           {
                   hide();
	           		//Muestra en pantalla e imprime en la consola del navegador el error.
                   swal(
                       lang.error_title ,
					   lang.error_code_status+xhr.status+': '+xhr.statusText,
                        'error'
                   ).catch(swal.noop);
				   console.log("hola mundo" );
	               console.log(xhr);
	           }
       		});//Final AJAX
	    }
    }

    //Función que se encarga de redireccionar a la vista de recuperar contraseña
    function forgot() {
        window.location.href = "./Start/forgotPassword";
    }

	//Función que redirecciona al módulo del cliente
    function redirect_client(isGlobal) {
        if(isGlobal == "0"){
            var location = $('#sltLocation').val();
            $('#txtLocation').val(location);   
        }else{
         	//Se obtiene la locación
            $('#txtLocation').val("public"); 
        }
        console.log( $('#txtLocation').val());
        $('#redirect').submit();

    }


    /**
    ** Acciones a realizar cuando se termine de carguar la página.
    **/
    $(document).ready(function() {
		//Verifica si el input ,el que posee el focus, tiene contenido o no y le asigna o remueve una clase css según corresponda.
		$(".input-effect input").focusout(function(){
			//Verifica si hay contenido o no
			if($(this).val() != ""){
				$(this).addClass("has-content");
			}else{
				$(this).removeClass("has-content");
			}
		})
		//Para verificar si el navegador mantuvo texto en el campo de texto de usuario
        if($('#txtUserName').val() !== "") {
            $('#txtUserName').addClass("has-content");
        }
    	
    });
