//Últimos archivos cargados
var lastFiles;
//DataTable de los archivos
var dataTable;
//DataTable de las versiones.
var dataTableVersions;
$(document).ready(function(){



    $("#toggler").click(function(){
        $(this).toggleClass('active, inactive');
    });

    //Cabeceras del dataTable de los archivos
    var header = "<tr><th>"+lang.attr_name_file+"</th>" +
        //"<th>"+lang.versions+"</th>" +
        "<th>"+lang.download+"</th></tr>";
    //Se añade la cabecera
    $('#fileTable-header').html(header);
    //Configuración del dataTable
    dataTable = $('#fileTable').DataTable({
        "columns": [
            null,
            { "width": "15%" }
        ],
        "bSort": false,
        "aaSorting": [],
        "language": {
            "lengthMenu": lang.lengthMenu,
            "zeroRecords": lang.zeroRecords,
            "info": lang.info,
            "infoEmpty": lang.infoEmpty,
            "infoFiltered": lang.infoFiltered,
            "search": lang.control_search,
            "paginate": {
                "first":  lang.pag_first,
                "last":   lang.pag_last,
                "next":   lang.pag_next,
                "previous": lang.pag_prev
            }
        }

    });
    //Configuración del dataTable
    dataTableVersions = $('#versionTable').DataTable({
        "columns": [
            null,
            { "width": "15%" }
        ],
        "aaSorting": [],
        "bSort": false,
        "language": {
            "lengthMenu": lang.lengthMenu,
            "zeroRecords": lang.zeroRecords,
            "info": lang.info,
            "infoEmpty": lang.infoEmpty,
            "infoFiltered": lang.infoFiltered,
            "search": lang.control_search,
            "paginate": {
                "first":  lang.pag_first,
                "last":   lang.pag_last,
                "next":   lang.pag_next,
                "previous": lang.pag_prev
            }
        }});

    $(".dataTables_filter input").addClass("input-search form-control");
    $(".dataTables_filter").addClass("search-div");

    //Si hay alguna carpeta
    if(folder != -1){
        show(lang.wait);
        //Llamada AJAX para obtener los archivos del cliente
        $.ajax({
            type: "POST",
            url: "Client/Main/getClientFiles",
            data: {'folder':folder},
            success: function(data)
            {
                //Se cargan los archivos
                chargeFiles(data,'2');
                //Se guardan los archivos recién recuperados.
                lastFiles = data;
                hide();


            },
            error: function(xhr)
            {
                hide();
                //Muestra en pantalla e imprime en la consola del navegador el error.
                swal(
                    lang.error_title ,
                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                    'error'
                ).catch(swal.noop);
                console.log(xhr);
            }
        });
    }
    
    swal(
        lang.check_browser ,
        lang.browser_text,
        'warning'
    ).catch(swal.noop);


});

/**
 * Función que se encarga mostrar el modal con las versiones de un archivo.
 * @param id : Id del archivo
 * @param name : Nombre del archivo
 */
function showVersions(id,name){
    show(lang.wait);
    //Llamada AJAX para recuperar las versiones.
    $ .ajax({
        type: "POST",
        url: "Client/Main/getVersions",
        data: {'file':id},
        success: function(data)
        {
            hide();
            //Se convierten los datos a JSON
            var v = JSON.parse(data);
            //Se limpia el DataTable
            dataTableVersions.clear();
            //Se agregan las versiones como filas del dataTable
            for(i=0;i<v.length;i++){
                dataTableVersions.row.add( [
                    v[i].name,
                    "<button type=\"button\" class=\"btn color-button\" onclick=\"download("+v[i].id+","+false+");\">"+lang.download+"</button>",
                ] ).draw( false );
            }
            
            //Se refresca el dataTable
            dataTableVersions.draw();
            //Se coloca el nombre del archivo como título del modal
            $('#header-modal').html(name);
            //Se agrega las clases css para darle estilo a la barra de búsqueda.
            $(".dataTables_filter input").addClass("input-search form-control");
            $(".dataTables_filter").addClass("search-div");
            //Se muestra el modal
            $('#myModal').modal('show');
        },
        error: function(xhr)
        {
            hide();
            //Muestra en pantalla e imprime en la consola del navegador el error.
            swal(
                lang.error_title ,
                lang.error_code_status+xhr.status+': '+xhr.statusText,
                'error'
            ).catch(swal.noop);
            console.log(xhr);
        }
    });

}

/**
 * Función que se encarga de descargar un archivo o versión.
 * @param id : id del archivo o versión
 * @param isFile : indica si es archivo o versión
 */
function download(id,isFile){
    show(lang.downloading);
    //Llamada al servidor
    var xhr = new XMLHttpRequest();
    xhr.open('POST', 'Client/Main/downloadFile', true);
    xhr.responseType = 'json';

    xhr.setRequestHeader('Content-type', 'application/json; charset=utf-8');
    xhr.onload = function(e) {

        //Respuesta del servidor
        var v = this.response;
        //Si todo salio bien
        if (this.status == 200) {
            //Creamos un elemento anchor, le asignamos el contenido de nuestro archivo o versión
            // y desparamos el evento click en él para que se descargue.
            //console.log(v);
            var link=document.createElement('a');
            var blob = b64toBlob(v.content, v.type);
            var blobUrl = URL.createObjectURL(blob);
            link.href= blobUrl;
            link.download=v.name.replace(/\./g, " ")+"."+v.extension;
            link.click();
            hide();
        } else {
            hide();
            swal(
                lang.error_title,
                lang.download_error,
                'error'
            ).catch(swal.noop);
        }
    };
    //Datos a ser enviados
    var jsonData = {
        'file': id,
        'isFile':isFile
    };
    //Se envia la petición
    xhr.send(JSON.stringify(jsonData));

}


function b64toBlob(b64Data, contentType, sliceSize) {
  contentType = contentType || '';
  sliceSize = sliceSize || 512;

  var byteCharacters = atob(b64Data);
  var byteArrays = [];

  for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
    var slice = byteCharacters.slice(offset, offset + sliceSize);

    var byteNumbers = new Array(slice.length);
    for (var i = 0; i < slice.length; i++) {
      byteNumbers[i] = slice.charCodeAt(i);
    }

    var byteArray = new Uint8Array(byteNumbers);

    byteArrays.push(byteArray);
  }
  var blob = new Blob(byteArrays, {type: contentType});
  return blob;
}


/**
 * Función que se ejecuta al realizar un cambio en el select del filtro
 */
$( "#sltFilter" ).change(function() {
    //Obtiene el valor del select del filtro
   var filter = $('#sltFilter').val();
   //Si hay una carpeta mostrandose actualmente vuelve a cargar los archivos, de lo contrario no.
    if(folder != -1) {
        //Se utilizan los archivos guardados anteriormente y se pasa el valor del filtro.
        chargeFiles(lastFiles, filter);
    }
});

/**
 * Función que se encarga de añadir los archivos como filas del dataTable
 * @param data: conjunto de archivos a cargar en el dataTable
 * @param filter: Valor del filtro
 */
function chargeFiles(data,filter){
    //Se convierte la información en un JSON
    var v = JSON.parse(data);
    //Se limpia el dataTable
    dataTable.clear();
    //Se procede a agregar los archivos al dataTable
    for(i=0;i<v.length;i++){
        //Se pregunta si el valor de validez es igual al del filtro, o si el filtro es igual 2, lo que significa
        // que se deben mostrar todos los archivos
        if(v[i].validity === filter.toString() || filter.toString() === '2'){
            //console.log(v[i].name);
            dataTable.row.add( [
                v[i].name,
                //"<button type=\"button\" class=\"btn color-button\" onclick=\"showVersions("+v[i].id+",'"+v[i].name+"');\"'>"+lang.versions+"</button>",
                "<button type=\"button\" class=\"btn color-button\" onclick=\"download("+v[i].id+","+true+");\">"+lang.download+"</button>"
            ] ).draw( false );
        }
    }
    //Se redibuja el dataTable
    dataTable.draw();
    //Se agrega las clases css para darle estilo a la barra de búsqueda.
    $(".dataTables_filter input").addClass("input-search form-control");
    $(".dataTables_filter").addClass("search-div");
}
