/**
 ** Acciones a realizar cuando se termine de carguar la pgina.
 **/
 $(document).ready(function() {
    //Selecciona la primera opcin
    $('#filterOrganization :nth-child(1)').prop('selected', true);
    $('#filterOrganization').selectpicker('refresh');
    //Se cargan las locaciones
    changeLocations("filterOrganization","filterLocation");
    $("#sltLocation").prop('disabled', true);
    $("#filterOrganization").prop('disabled', true);
    $("#filterLocation").prop('disabled', true);
});

$('#filterCheck').change(function() {
         var chk = $('#filterCheck').is(":checked");
         if(chk){
             $('#filterOrganization').prop('disabled', false);
             $('#filterLocation').prop('disabled', false);
         }else{
            $('#filterOrganization').prop('disabled', true);
            $('#filterLocation').prop('disabled', true);
         }
         refreshTree();
});

function chooseLocations(){
        $("#sltOrganization").empty();
        if(oldOrganizations[0] != "public"){
             show(lang.waiting);
            //jQuery.each(organizationsGlobal, function(i, val) {
                jQuery.each(oldOrganizations, function(i, val) {
                        var name = $("#sltOrganizations option[value='"+val+"']").text();
                        $("#sltOrganization").append("<option value="+val+">"+name+"</option>");
             //});
            });
            hide();
            $("#sltOrganization").selectpicker('refresh');
           changeLocations("sltOrganization","sltLocations",lastSelectedNode.id);
           $('#btnChooseLocation').prop('onclick',null).off('click');
           $('#btnChooseLocation').html(lang.back);
           $('#btnAssing').html(lang.assing_loca);
           $("#btnChooseLocation").click(function(){back(); });
           $('#assingOrganizations').hide();
           $('#assingLocations').show();
           areLocations = true;
        }else{
             swal(
                lang.public_file,
                lang.specify_organization,
                'info'
            ).catch(swal.noop);
        }
};

function back(){
    $('#btnChooseLocation').prop('onclick',null).off('click');
     $('#btnChooseLocation').html(lang.choose_location);
     $('#btnAssing').html(lang.assing_orga);
    $("#btnChooseLocation").click(function(){chooseLocations(); });
    $('#assingOrganizations').show();
    $('#assingLocations').hide();
    areLocations = false;
    $('#chkException').prop('disabled', false);
};

function assingLocations(){
        var oldData = [];
        var newData = [];
        var organization = null;
        var chk = $('#chkException').is(":checked");
        
        if(!areLocations){
            
            oldData = oldOrganizations;
            var organizations = $('#sltOrganizations').val();
            var allOrganizations = [];
            $('#sltOrganizations option').each(function(){
                allOrganizations.push($(this).val());
            });
            allOrganizations.shift();
            if(chk){
                jQuery.grep(allOrganizations, function(orga) {
                    if (jQuery.inArray(orga,organizations) == -1) {
                        newData.push(orga);
                    }
                });
            }else{
                newData = organizations;
            }
        }else{
            oldData = oldLocations;
            organization = $('#sltOrganization').val();
            var locations = $('#sltLocations').val();
            var allLocations = [];
            $('#sltLocations option').each(function(){
                allLocations.push($(this).val());
            });
            allLocations.shift();
            if(chk){
                jQuery.grep(allLocations, function(loca) {
                    if (jQuery.inArray(loca,locations) == -1) {
                        newData.push(loca);
                    }
                });
            }else{
                newData = locations;
            }
        }
        $.ajax({
            type: "POST",
            url: "Administrator/Upload/assingLocations",
            data:{"newData":newData,"oldData":oldData,"areLocations":areLocations,"organization":organization,"folder":lastSelectedNode.id},
            success: function(data)
            {
                //console.log(data);
                $('#myModalAssing').modal('toggle');
                 swal(
                    lang.success_title,
                    lang.assig_correct,
                    'info'
                ).catch(swal.noop);
                refreshTree();
            },
            error: function(xhr)
            {
                //Muestra en pantalla e imprime en la consola del navegador el error.
                swal(
                    lang.error_title ,
                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                    'error'
                ).catch(swal.noop);
                console.log(xhr);
            }
        });
        
        
};

var type = "blob";
var areLocations = false;
var oldLocations = [];
var oldOrganizations = [];
var organizationsGlobal = [];
var lastSelectedNode = null;

function create_node() {
    var ref = $('#jstree').jstree(true),
        sel = ref.get_selected();
    var selectedNode = ref.get_selected(true);

    if(!sel.length) {
        return false;
    }
    var deep = selectedNode[0].parents.length;
    sel = sel[0];
    if(deep === 1){
        $.ajax({
            type: "POST",
            url: "Administrator/Structures/insertFolder",
            data:{"folder":{"type":2,"parent_id":selectedNode[0].id,"typeUpload":type,"name":lang.new_subcategory}},
            success: function(data)
            {

                sel = ref.create_node(sel, {"type":"default","id":data,"text":lang.new_subcategory,"a_attr" :{"class" : "text-space"}
                    });
                if(sel) {
                    ref.edit(sel);
                }
            },
            error: function(xhr)
            {
                //Muestra en pantalla e imprime en la consola del navegador el error.
                swal(
                    lang.error_title ,
                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                    'error'
                ).catch(swal.noop);
                console.log(xhr);
            }
        });
    }else if(deep === 2){
        $.ajax({
            type: "POST",
            url: "Administrator/Structures/insertFolder",
            data:{"folder":{"type":3,"parent_id":selectedNode[0].id,"typeUpload":type,"name":lang.new_folder}},
            success: function(data)
            {

                sel = ref.create_node(sel, {"type":"file","id":data,"text":lang.new_folder,"a_attr" :{"class" : "text-space"}});
                if(sel) {
                    ref.edit(sel);
                }
            },
            error: function(xhr)
            {
                //Muestra en pantalla e imprime en la consola del navegador el error.
                swal(
                    lang.error_title ,
                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                    'error'
                ).catch(swal.noop);
                console.log(xhr);
            }
        });

    }
};

function create_root() {
    var ref = $('#jstree').jstree(true);
    $.ajax({
        type: "POST",
        url: "Administrator/Structures/insertFolder",
        data:{"folder":{"type":1,"typeUpload":type,"name":lang.new_category}},
        success: function(data)
        {
            var sel = ref.create_node(null, {"type":"root","id":data,"text":lang.new_category,"a_attr" :{"class" : "text-space"}
                });
            if(sel) {
                ref.edit(sel);
            }
        },
        error: function(xhr)
        {
            //Muestra en pantalla e imprime en la consola del navegador el error.
            swal(
                lang.error_title ,
                lang.error_code_status+xhr.status+': '+xhr.statusText,
                'error'
            ).catch(swal.noop);
            console.log(xhr);
        }
    });
};

//Expande todos los nodos
function expand_all() {
    var ref = $('#jstree');
    ref.jstree('open_all','#',200);


};

//Collapso todos los nodes
function close_all() {
    var ref = $('#jstree');
    ref.jstree('close_all','#',200);

};

function rename_node() {
    var ref = $('#jstree').jstree(true),
        sel = ref.get_selected();
    if(!sel.length) { return false; }
    sel = sel[0];
    ref.edit(sel);
};

function show_date() {
    var ref = $('#jstree').jstree(true);
    var selectedNode = ref.get_selected(true);
        swal(
            lang.attr_date_creation ,
            selectedNode[0].data.dateCreation,
            'info'
            ).catch(swal.noop);
   
};

function delete_node() {
    var ref = $('#jstree').jstree(true),sel = ref.get_selected();
    var selectedNode = ref.get_selected(true);
    //Mensaje de confirmacion para eliminar la carpeta.
    if(selectedNode[0].data.delete == 1){
        swal({
            title: lang.delete_title,
            text: lang.delete_warning,
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: lang.delete_comfirm
        }).then(function () {
            if(!sel.length) { return false; }
            var urlSend = '';
            var dataSend = '';
            if(selectedNode[0].parents.length == 4){
                urlSend = "Administrator/files/deleteFile";
                var file = {"Id":selectedNode[0].id}
                dataSend = {"file":file};
            }else{
                urlSend = "Administrator/Structures/deleteFolder";
                dataSend = {"folder":{"id":selectedNode[0].id,"typeUpload":type}};
            }
            $.ajax({
                type: "POST",
                url: urlSend,
                data:dataSend,
                success: function(data)
                {
                    ref.delete_node(sel);
                },
                error: function(xhr)
                {
                    //Muestra en pantalla e imprime en la consola del navegador el error.
                    
                    console.log(xhr);
                }
            });
        }).catch(swal.noop);
    }else{
        swal(
            lang.error_title ,
            lang.cant_delete,
            'error'
       ).catch(swal.noop);
    }

};

/**
 ** Refreca el rbol con los archivos del cliente seleccionado
 **/
function refreshTree() {
    //Cliente del cual se van a buscar los archivos
    var location = $('#filterLocation').val();
    var organization = $('#filterOrganization').val();
    var v;
    var chk = $('#filterCheck').is(":checked");
    if(!chk){
        organization = "all";
    }
    show(lang.waiting);
    //Peticion de AJAX para obtener la nueva estructura de archivos.
    $.ajax({
        type: "POST",
        url: "Administrator/Structures/getStructureTree",
        data:{"upload":0,'location':location,'organization':organization},
        success: function(data)
        {
            //Se vincula la nueva estructura con el rbol y se refresca.
            v= JSON.parse(data);

            $('#jstree').jstree(true).settings.core.data = v;
            $('#jstree').jstree(true).refresh();
            hide();
        },
        error: function(xhr)
        {
            //Muestra en pantalla e imprime en la consola del navegador el error.
            swal(
                lang.error_title ,
                lang.error_code_status+xhr.status+': '+xhr.statusText,
                'error'
            ).catch(swal.noop);
            console.log(xhr);
            hide();
        }
    });
}

//Tipo de subida de archivos
var typeUpload = "blob";
//Para que se cargue el rbol por primera vez y no se refresca
var first = true;

//Esta la opcin todos seleccionado, lo que significa que las otras estan deseleccionadas.
var deselect = {"sltOrganizations":true,"sltLocations":true,"filterLocation":true};

var lastlocations = {"sltOrganizations":[],"sltLocations":[],"filterLocation":[]};


  /**
  ** LLamada AJAX para obtener la estructura jerrquica de carpetas.
  **/
function chargeTree() {
    var to = false;
    $('#search-field').keyup(function () {
        if(to) { clearTimeout(to); }
        to = setTimeout(function () {
            var v = $('#search-field').val();
            $('#jstree').jstree(true).search(v);
        }, 250);
    });
    var location = $('#filterLocation').val();
    var organization = $('#filterOrganization').val();
    var chk = $('#filterCheck').is(":checked");
    if(!chk){
        organization = "all";
    }
    var v;
    show(lang.waiting);
    $.ajax({
        type: "POST",
        url: "Administrator/Structures/getStructureTree",
        data:{"upload":0 ,"location":location,'organization':organization},
        success: function(data)
        {
            v= JSON.parse(data);
            $('#jstree')
                .jstree({
                    "core" : {
                        "dblclick_toggle":false,
                        "animation" : 200,
                        'check_callback' : function (operation, node, node_parent, node_position) {
                            if(operation === 'rename_node'){
                                var text = node_position;
                                if(!isEmpty(text)){
                                    if(isAlphanumeric(text)){
                                        if(maxLength(text,100)){
                                            return true;
                                        }else{
                                            swal(
                                                lang.error_title ,
                                                lang.error_strct_max,
                                                'error'
                                            ).catch(swal.noop);
                                            return false;
                                        }
                                    }else{
                                        swal(
                                            lang.error_title ,
                                            lang.error_strct_alpha,
                                            'error'
                                        ).catch(swal.noop);
                                        return false;
                                    }
                                }else{
                                    swal(
                                        lang.error_title ,
                                        lang.error_strct_empty,
                                        'error'
                                    ).catch(swal.noop);
                                    return false;
                                }
                            }else{
                                return true;
                            }

                        },
                        'force_text' : true,
                        "multiple" : false,
                        "themes" : {
                            "stripes" : true,
                            "variant": "large",
                            'dots' : false
                        },
                        "strings":{
                            'Loading ...' : lang.loading
                        },
                        "data":v
                    },
                    "types": {
                            "#": {"max_depth": 3, "valid_children": ["root"]},
                            "root": {"icon": "assets/images/category.png", "valid_children": ["default"]},
                            "default": {"icon": "assets/images/subcategory.png", "valid_children": ["file"]},
                            "file": {"icon": "assets/images/folder.png"},
                            "fileLast": {"icon": "assets/images/file.png", "valid_children": ["fileLast"]}
                        },
                    "contextmenu":{
                        "items" : function (node) {
                            var items = {
                                "upload" : {
                                    "separator_before"	: false,
                                    "icon"				: false,
                                    "separator_after"	: false,
                                    "_disabled"			: false,
                                    "label"				: lang.aTitle_Upload,
                                    "action"			: function (data) {
                                        $('#btnUpload').prop('onclick',null).off('click');
                                        $('#header-modal').html(lang.aTitle_Upload);
                                       $('#uploadFiles').fileinput('clear');
                                        $("#btnUpload").click(function(){ upload(node.id); });
                                         $('#myModal').modal('show');
                                    }
                                },/**
                                "version" : {
                                    "separator_before"	: false,
                                    "icon"				: false,
                                    "separator_after"	: false,
                                    "_disabled"			: false,
                                    "label"				: lang.aTitle_Update,
                                    "action"			: function (data) {
                                        $('#btnUpload').prop('onclick',null).off('click');
                                         $('#header-modal').html(lang.aTitle_Update);
                                         $('#uploadFiles').fileinput('clear');
                                          $("#btnUpload").click(function(){ update(node.id); });
                                         $('#myModal').modal('show');
                                    }
                                },**/
                                "create" : {
                                    "separator_before"	: false,
                                    "separator_after"	: false,
                                    "_disabled"			: false,
                                    "label"				: lang.grid_create,
                                    "action"			: function (data) {
                                        create_node();

                                    }
                                },
                                "rename" : {
                                    "separator_before"	: false,
                                    "separator_after"	: false,
                                    "_disabled"			: false,
                                    "label"				: lang.grid_rename,
                                    "action"			: function (data) {
                                        rename_node();
                                    }
                                },
                                "remove" : {
                                    "separator_before"	: false,
                                    "icon"				: false,
                                    "separator_after"	: false,
                                    "_disabled"			: false,
                                    "label"				: lang.grid_delete,
                                    "action"			: function (data) {
                                        delete_node();
                                    }
                                },
                                "date" : {
                                    "separator_before"	: true,
                                    "icon"				: false,
                                    "separator_after"	: false,
                                    "_disabled"			: false,
                                    "label"				: lang.attr_date_creation,
                                    "action"			: function (data) {
                                        show_date();
                                    }
                                },
                                "assign" : {
                                    "separator_before"	: true,
                                    "icon"				: false,
                                    "separator_after"	: false,
                                    "_disabled"			: false,
                                    "label"				: lang.assing_file,
                                    "action"			: function (data) {
                                        show(lang.waiting);
                                        $.ajax({
                                            type: "POST",
                                            url: "Administrator/Files/getOrganizations",
                                            data: {"file":node.id},
                                            success: function(data)
                                            {
                                                back();
                                                //Convertimos a JSON
                                                
                                                var organizations = JSON.parse(data);
                                                organizationsGlobal = organizations;
                                                //Se vacia el select de las locaciones
                                                $("#sltOrganizations").empty();
                                                //Se selecciona la primera opcin
                                                $("#sltOrganizations").append("<option value='public'>"+lang.all+"</option>");
                                                //Por cada locacin
                                                var publi = true;
                                                var lastLocationsLocal = [];
                                                oldOrganizations = [];
                                                jQuery.each(organizations, function(i, val) {
                                                    if(val.Name === ""){
                                                        var name = val.NameLegal;
                                                    }else{
                                                        var name = val.Name;
                                                    }
                                                    if(val.checked == true){
                                                        publi = false;
                                                         oldOrganizations.push(val.idPrimary);
                                                         $("#sltOrganizations").append("<option value="+val.idPrimary.replace(" ","$")+" selected>"+name+"</option>");
                                                    }else{
                                                        $("#sltOrganizations").append("<option value="+val.idPrimary.replace(" ","$")+">"+name+"</option>");
                                                    }
                                                    lastLocationsLocal.push(val.idPrimary);
                                                });
                                                lastlocations["sltOrganizations"] = lastLocationsLocal;
                                                $('#chkException').prop('checked', false);
                                                if(publi){
                                                    $('#chkException').prop('disabled', true);
                                                    deselect['sltOrganizations'] = true;
                                                    $("#sltOrganizations option[value='public']").prop("selected", true); 
                                                }else{
                                                    deselect['sltOrganizations'] = false;
                                                }
                                                //Se refresca el select
                                                $("#sltOrganizations").selectpicker('refresh');
                                                hide();

                                                if(oldOrganizations.length > 0){
                                                    $('#btnChooseLocation').show();
                                                }else{
                                                    $('#btnChooseLocation').hide();
                                                }
                                                $('#myModalAssing').modal({
                                                    backdrop: 'static',
                                                    keyboard: false
                                                });
                                    
                                            },
                                            error: function(xhr)
                                            {
                                                //Muestra en pantalla e imprime en la consola del navegador el error.
                                                swal(
                                                    lang.error_title ,
                                                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                                                    'error'
                                                ).catch(swal.noop);
                                                console.log(xhr);
                                                hide();
                                            }
                                        });
                                    }
                                }
                            };
                            if(node.parents.length > 2){
                                delete items.create;
                            }

                            if(node.parents.length != 3){
                                delete items.upload;
                                delete items.assign;
                            }
                            if(node.parents.length != 4){
                                //delete items.version;
                                delete items.date;
                                
                            }
                            lastSelectedNode = node;
                            
                            return items;
                        }
                    },
                    "plugins" : ["contextmenu", "dnd", "search", "state", "types", "wholerow"]
                });



            $("#jstree").bind(
                "rename_node.jstree", function(event,data){
                    var urlSend = '';
                    var dataSend = '';
                    
                    if(data.node.parents.length == 4){
                        urlSend = "Administrator/files/updateFile";
                        var file = {"Id":data.node.id,"name":data.text,"validity":1};
                        dataSend = {"file":file};
                    }else{
                        urlSend = "Administrator/Structures/updateFolder";
                        dataSend = {"folder":{"name":data.text,"id":data.node.id}};
                    }
                    $.ajax({
                        type: "POST",
                        url: urlSend,
                        data:dataSend,
                        success: function(dat)
                        {

                        },
                        error: function(xhr)
                        {
                            //Muestra en pantalla e imprime en la consola del navegador el error.
                            swal(
                                lang.error_title ,
                                lang.error_code_status+xhr.status+': '+xhr.statusText,
                                'error'
                            ).catch(swal.noop);
                            console.log(xhr);
                        }
                    });
                }
            );
            hide();
        },
        error: function(xhr)
        {
            //Muestra en pantalla e imprime en la consola del navegador el error.
            swal(
                lang.error_title ,
                lang.error_code_status+xhr.status+': '+xhr.statusText,
                'error'
            ).catch(swal.noop);
            console.log(xhr);
            hide();
        }
    });
    $('#jstree').bind("dblclick.jstree", function (e) {
        var nodeDOM = $(e.target).closest("li");
        var node = $('#jstree').jstree(true).get_node(nodeDOM);
        if(node.children.length != 0){
            $("#jstree").jstree("toggle_node", node);
        }
    });



};

$( "#filterOrganization" ).change(function() {
    $('#filterLocation').prop('disabled', false);
    changeLocations("filterOrganization","filterLocation");

});

$( "#sltOrganization" ).change(function() {
    changeLocations("sltOrganization","sltLocations",lastSelectedNode.id);
});

$( "#sltOrganizations" ).change(function() {
     locationsSelect("sltOrganizations");
});

/**
 ** Configuracin de file input de bootstrap
 **/
$('#uploadFiles').fileinput({
    //Lenguaje espa09ol, y ocultamos el botn de subir.
    language: 'es',
    showUpload: false,
    maxFileCount: 10,
    maxFileSize: 102400,
    allowedFileExtensions: ["jpg","jpeg", "pdf", "png", "txt","xls","doc","docx","xlsx","xlsm","ppt","pptx"]
});


function changeLocations(organizationSelect,location,file = false){
    var lastLocationsLocal = [];
    //Se obtiene la organizacin
    var organization = $('#'+organizationSelect).val();
    //Si la organizacin es pblic
    if(organization === "public"){
        //Se vacian las locaciones
        $("#"+location).empty();
        //Se agrega la opcin pblic
        $("#"+location).append("<option value='public' selected>"+lang.all+"</option>");
        //Se refresca el select
        $('#'+location).selectpicker('refresh');
        if(organizationSelect === "filterOrganization"){
            //Si es la primera vez
            if(first){
                //Se carga el rbol
                chargeTree();
                first = false;
            }else{
                //Si no, se refresca
                refreshTree();
            }
        }
    }else if(organization === "private"){
        if(organizationSelect === "filterOrganization"){
            $("#"+location).empty();
            $("#"+location).append("<option value='private' selected>"+lang.none+"</option>");
            $('#'+location).selectpicker('refresh');
            $('#'+location).prop('disabled', true);
            //Si es la primera vez
            if(first){
                //Se carga el rbol
                chargeTree();
                first = false;
            }else{
                //Si no, se refresca
                refreshTree();
            }
        }
    }else{
        show(lang.waiting);
        //Llamada ajax para obtener las localizaciones
        $.ajax({
            type: "POST",
            url: "Administrator/Files/getLocations",
            data: {"organization":organization,"file":file},
            success: function(data)
            {
                
                //Convertimos a JSON
                var locations = JSON.parse(data);
                oldLocations = [];
                //Se vacia el select de las locaciones
                $("#"+location).empty();
                //Se selecciona la primera opcin
                $("#"+location).append("<option value='public'>"+lang.all+"</option>");
                //Por cada locacin
                var publi = true;
                jQuery.each(locations, function(i, val) {
                    //Se agrega al select
                    if(file != false){
                        if(val.checked == true){
                            publi = false;
                            oldLocations.push(val.Id);
                            $("#"+location).append("<option value="+val.Id+" selected>"+val.Name+"</option>");
                        }else{
                            $("#"+location).append("<option value="+val.Id+">"+val.Name+"</option>");
                        }
                    }else{
                         $("#"+location).append("<option value="+val.Id+">"+val.Name+"</option>");
                    }
                    lastLocationsLocal.push(val.Id);
                });
                if(publi){
                        $('#chkException').prop('checked', false);
                        $('#chkException').prop('disabled', true);
                        deselect[location] = true;
                        $("#"+location +" option[value='public']").prop("selected", true); 
                }else{
                        deselect[location] = false;
                }
                //Se refresca el select
                $('#'+location).selectpicker('refresh');
                if(organizationSelect === "filterOrganization"){
                    refreshTree();
   
                }
                lastlocations[location] = lastLocationsLocal;

                hide();
    
            },
            error: function(xhr)
            {
                //Muestra en pantalla e imprime en la consola del navegador el error.
                swal(
                    lang.error_title ,
                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                    'error'
                ).catch(swal.noop);
                console.log(xhr);
                hide();
            }
        });
    }
}

$('#filterLocation').on('hidden.bs.select', function (e) {
      refreshTree();
});


   /**
     * Evento que se ejecuta cuando se cambia la opcin del select de locaciones
     **/
$( "#filterLocation" ).change(function() {
    locationsSelect("filterLocation");
    
});

$( "#sltLocations" ).change(function() {
    locationsSelect("sltLocations");
    
});


function locationsSelect(select){
          //Se obtiene las locaciones
        var locations = $('#'+select).val();
        //Si solo esta seleccionado la opcin public(Todos)
        var lastlocationsLocal = lastlocations[select];
        if(deselect[select]){
                //Si hay seleccionada ms de una opcin
                if(locations.length == (lastlocationsLocal.length+1)){
                    //Se deseleccionan todas las opcines
                    $('#'+select).selectpicker('deselectAll');
                    //Se selecciona la opcin pblic
                    $('#'+select+" option[value='public']").prop("selected", true);
                    //Se refresca el select
                    $('#'+select).selectpicker('refresh');
                    //Solo esta seleccionada la opcin pblic
                    deselect[select] = true;
                }
                else if(locations.length > 1){
                    //Se deselecciona la opcin public
                    $('#'+select+" option[value='public']").prop("selected", false);
                    //Se reffresca el select
                    $('#'+select).selectpicker('refresh');
                    //Ya no esta marcada solo a la opcin pblica
                    deselect[select] = false;
                }
            //Si no esta marcado solo la opcin pblic
        }else{
            //Si esta seleccionada la opcin pblic
            if(locations[0]==="public" || locations.length == lastlocationsLocal.length){
                //Se deseleccionan todas las opcines
                $('#'+select).selectpicker('deselectAll');
                //Se selecciona la opcin pblic
                $('#'+select+" option[value='public']").prop("selected", true);
                //Se refresca el select
                $('#'+select).selectpicker('refresh');
                //Solo esta seleccionada la opcin pblic
                deselect[select] = true;
            }
        }
        //Si no hay ningna seleccionada
        if(locations.length == 0){
            //Selecciona la opcin pblic
            $('#'+select+" option[value='public']").prop("selected", true);
            //Se refresca el select
            $('#'+select).selectpicker('refresh');
            //Solo esta marcada la opcin pblic
            deselect[select] = true;
        }  
        
        if(select !== "filterLocation"){
            if(locations[0] == "public" && deselect[select]){
                $('#chkException').prop('checked', false);
                $('#chkException').prop('disabled', true);
            }else{
                $('#chkException').prop('disabled', false);
            }
        }
};
    
    
/**
 ** Funcin que maneja la subida de archivos
 **/
function upload(id){
    //Variable que almacenara los datos a enviar por AJAX
    var formData = new FormData();
    /**
    //Locacion al cual se le van a subir los archivos
    var locations = $('#filterLocation').val();
    //Organizacin de las locaciones
    var organization = $('#filterOrganization').val();
    //Si la organizacin no es pblic
    if(organization !== "public"){
        if(locations[0] === "public"){
            //Asigna el valor de las ultimas locaciones cargadas
            locations = lastlocationsFilter;
        }else{
            //Para que sea ignorada del lado del controlador ya que 
            // el archivo pertenece a una locacin especfica. 
            organization = "public";
        }
    }
    **/
    //Cantidad de archivos que se va a subir
    var length = ($("#uploadFiles"))[0].files.length;
    // Si hay almenos un archivo
   
    if(length > 0){
        //Se recorren todos y se almacenan en formData
        for(i =0;i<length;i++){
           
            formData.append("file_"+i, ($("#uploadFiles"))[0].files[i]);
        }
       
        //Se obtiene la carpeta seleccionada como destino del archivo
        //var ref = $('#jstree').jstree(true);
        //var selectedNode = ref.get_selected(true);
        // Se verifica que se haya seleccionado una carpeta
        //if(typeof selectedNode[0] === 'undefined'){
           // swal(
                //lang.warning_title,
                //lang.warning_folder,
                //'warning'
            //).catch(swal.noop);
        //}else{
            show(lang.uploading);
            //Si hay almenos un archivo y ya se slecciono la carpeta de destino
            //Se recopila la informacion necesaria y se almacena.
            //formData.append("organization",organization);
            //formData.append("locations",locations);
            formData.append("folder", id);
            formData.append("length", length);
            formData.append("typeUpload",typeUpload);
            formData.append("isVersion",0);
            //Llamada AJAX para subir el archivo.
            $.ajax({
                type: "POST",
                url: "Administrator/Upload/uploadFile",
                data:formData,
                //Para poder enviar archivos
                contentType:false,
                processData:false,
                success: function(data)
                {
                    //console.log(data);
                    hide();
                    swal(
                        lang.success_title,
                        lang.success_upload,
                        'success'
                    ).catch(swal.noop);
                    $('#uploadFiles').fileinput('clear');
                    refreshTree();
                    $('#myModal').modal('hide');
                },
                error: function(xhr)
                {
                    hide();
                    //Muestra en pantalla e imprime en la consola del navegador el error.
                    swal(
                        lang.error_title ,
                        lang.error_code_status+xhr.status+': '+xhr.statusText,
                        'error'
                    ).catch(swal.noop);
                    console.log(xhr);
                }
            });
       // }
    }else{
        swal(
            lang.warning_title,
            lang.warning_file,
            'warning'
        ).catch(swal.noop);
    }
};

/**
 ** Funcin que maneja la subida de archivos
 **/
function update(id){
    //Variable que almacenara los datos a enviar por AJAX
    var formData = new FormData();

    //Cantidad de archivos que se va a subir
    var length = ($("#uploadFiles"))[0].files.length;
    // Si hay almenos un archivo
    if(length > 0){
        //Se recorren todos y se almacenan en formData
        for(i =0;i<length;i++){
            formData.append("file_"+i, ($("#uploadFiles"))[0].files[i]);
        }
            //Si hay almenos un archivo y ya se selecciono la carpeta de destino
            //Se recopila la informacion necesaria y se almacena.
            show(lang.uploading);
            formData.append("file", id);
            formData.append("length", length);
            formData.append("typeUpload",typeUpload);
            formData.append("isVersion",1);

            //Llamada AJAX para subir el archivo.
            $.ajax({
                type: "POST",
                url: "Administrator/Upload/uploadFile",
                data:formData,
                //Para poder enviar archivos
                contentType:false,
                processData:false,
                success: function(data)
                {
                    hide();
                    //Se refresca el rbol para que aparezca la nueva versin
                    swal(
                        lang.success_title,
                        lang.success_upload,
                        'success'
                    ).catch(swal.noop);
                    $('#uploadFiles').fileinput('clear');
                    refreshTree();
                    $('#myModal').modal('hide');

                },
                error: function(xhr)
                {
                    hide();
                    //Muestra en pantalla e imprime en la consola del navegador el error.
                    swal(
                        lang.error_title ,
                        lang.error_code_status+xhr.status+': '+xhr.statusText,
                        'error'
                    ).catch(swal.noop);
                    console.log(xhr);
                }
            });
    }else{
        //Debe seleccionar al menos un archivo
        swal(
            lang.warning_title,
            lang.warning_file,
            'warning'
        ).catch(swal.noop);
    }
};


