
    /**
     ** Acciones a realizar cuando se termine de carguar la página.
     **/
    $(document).ready(function() {
        //Selecciona la primera opción
        $('#sltOrganization :nth-child(1)').prop('selected', true);
        $('#sltOrganization').selectpicker('refresh');
        //Se cargan las locaciones
        changeLocations();
    });




    /**
     ** Funcion que se encarga de buscar en el JSTree
     **/
    var to = false;
    $('#search-field').keyup(function () {
        if(to) { clearTimeout(to); }
        to = setTimeout(function () {
            var v = $('#search-field').val();
            $('#jstree').jstree(true).search(v);
        }, 250);
    });

    /**
     ** LLamada AJAX para obtener la estructura jerárquica de carpetas.
     **/
function chargeTree() {
        var v;
        var location = $('#sltLocation').val();
        show(lang.waiting);
        $.ajax({
            type: "POST",
            url: "Administrator/Structures/getStructureTree",
            data: {"upload": 2, 'location': location},
            success: function (data) {
                //Se convierte la respuesta a JSON
                v = JSON.parse(data);
                $('#jstree')
                //Configuraciones del JStree
                    .jstree({
                        "core": {
                            "dblclick_toggle": false,
                            "animation": 200,
                            "check_callback": true,
                            'force_text': true,
                            "multiple": false,
                            "themes": {
                                "stripes": true,
                                "variant": "large",
                                'dots': false
                            },
                            "strings":{
                                'Loading ...' : lang.loading
                            },
                            //Se le asocia los datos recuperados
                            "data": v
                        },
                        //Configuración del plugin checkBox
                        "checkbox": {
                            "cascade": "down",
                            "three_state": false
                        },
                        //Tipos de nodos en el árbol
                        "types": {
                            "#": {"max_depth": 3, "valid_children": ["root"]},
                            "root": {"icon": "assets/images/category.png", "valid_children": ["default"]},
                            "default": {"icon": "assets/images/subcategory.png", "valid_children": ["file"]},
                            "file": {"icon": "assets/images/folder.png"},
                            "fileLast": {"icon": "assets/images/file.png", "valid_children": ["fileLast"]}
                        },
                        "plugins": ["checkbox", "search", "types", "wholerow"]
                    });
                    hide();
            },
            error: function (error) {
                console.log(error);
            }
        });
    }
    /**
     ** Evento que se ejecuta al hacer doble click sobre un nodo, previene que se expanda o colapsen nodos sin hijos.
     **/
    $('#jstree').bind("dblclick.jstree", function (e) {
        //Obtenemos el objeto HTML sobre el cual se hizo doble click
        var nodeDOM = $(e.target).closest("li");
        //Obtenemos el nodo HTML sobre el cual se hizo doble click
        var node = $('#jstree').jstree(true).get_node(nodeDOM);
        //Verificamos si tiene hijos, de lo contrario no se dispara el evento doble click.
        if(node.children.length != 0){
            $("#jstree").jstree("toggle_node", node);
        }
    });

    /**
     ** Refreca el árbol cuando se cambia de cliente
     **/
    $( "#sltLocation" ).change(function() {
        refreshTree();
    });



//Expande todos los nodos
function expand_all() {
    var ref = $('#jstree');
    ref.jstree('open_all','#',200);


};

//Collapso todos los nodes
function close_all() {
    var ref = $('#jstree');
    ref.jstree('close_all','#',200);

};


/**
 ** Refreca el árbol con los archivos del cliente seleccionado
 **/
function refreshTree() {
    //Cliente del cual se van a buscar los archivos
    var location = $('#sltLocation').val();
    var v;
    show(lang.waiting);    
    //Peticion de AJAX para obtener la nueva estructura de archivos.
    $.ajax({
        type: "POST",
        url: "Administrator/Structures/getStructureTree",
        data:{"upload":2,'location':location},
        success: function(data)
        {
            //Se vincula la nueva estructura con el árbol y se refresca.
            v= JSON.parse(data);

            $('#jstree').jstree(true).settings.core.data = v;
            $('#jstree').jstree(true).refresh();
            hide();
        },
        error: function(xhr)
        {
            //Muestra en pantalla e imprime en la consola del navegador el error.
            swal(
                lang.error_title ,
                lang.error_code_status+xhr.status+': '+xhr.statusText,
                'error'
            ).catch(swal.noop);
            console.log(xhr);
        }
    });
}

/**
 ** Configuración de file input de bootstrap
 **/
$('#uploadFiles').fileinput({
    language: 'es',
    showUpload: false,
    maxFileSize: 102400,
    maxFileCount: 1,
    allowedFileExtensions: ["jpg","jpeg", "pdf", "png", "txt","xls","doc","docx","xlsx","xlsm"]
});

//Tipo de subida de archivos
var typeUpload = "blob";
//Para que se cargue el árbol por primera vez y no se refresca
var first = true;

/**
 ** Función que maneja la subida de archivos
 **/
function update(){
    //Variable que almacenara los datos a enviar por AJAX
    var formData = new FormData();
    //Locaciones a las cuales se le van a subir los archivos
    var location = $('#sltLocation').val();
    //Enviar notificación
    var notification;
    if( $('#chckNotification').prop('checked') ) {
        notification = 1;
    }else{
        notification = 0;
    }
    //Cantidad de archivos que se va a subir
    var length = ($("#uploadFiles"))[0].files.length;
    // Si hay almenos un archivo
    if(length > 0){
        //Se recorren todos y se almacenan en formData
        for(i =0;i<length;i++){
            formData.append("file_"+i, ($("#uploadFiles"))[0].files[i]);
        }
        //Se obtiene la carpeta seleccionada como destino del archivo
        var ref = $('#jstree').jstree(true);
        var selectedNode = ref.get_selected(true);
        if(typeof selectedNode[0] === 'undefined'){
            swal(
                lang.warning_title,
                lang.warning_file_version,
                'warning'
            ).catch(swal.noop);
        }else{
            //Si hay almenos un archivo y ya se selecciono la carpeta de destino
            //Se recopila la informacion necesaria y se almacena.
            show(lang.uploading);
            formData.append("file", selectedNode[0].id);
            formData.append("length", length);
            formData.append("typeUpload",typeUpload);
            formData.append("isVersion",1);

            //Llamada AJAX para subir el archivo.
            $.ajax({
                type: "POST",
                url: "Administrator/Upload/uploadFile",
                data:formData,
                //Para poder enviar archivos
                contentType:false,
                processData:false,
                success: function(data)
                {
                    hide();
                    //Se refresca el árbol para que aparezca la nueva versión
                    refreshTree();
                    swal(
                        lang.success_title,
                        lang.success_upload,
                        'success'
                    ).catch(swal.noop);
                    $('#uploadFiles').fileinput('clear');

                    //Si las notificaciones estan activadas
                    if(notification === 1){
                        //Es necesario enviar las locaciones en un arreglo
                        var info = [];
                        info[0] = location;
                        //Llamada AJAX para enviar notificaciones
                        $.ajax({
                            type: "POST",
                            url: "Administrator/Upload/sendNotifications",
                            data:{'locations':info,'names':data},
                            success: function(dataInfo)
                            {
                                console.log(dataInfo);
                            },
                            error: function(xhr)
                            {
                                //Muestra en pantalla e imprime en la consola del navegador el error.
                                swal(
                                    lang.error_title ,
                                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                                    'error'
                                ).catch(swal.noop);
                                console.log(xhr);
                            }
                        });
                    }

                },
                error: function(xhr)
                {
                    hide();
                    //Muestra en pantalla e imprime en la consola del navegador el error.
                    swal(
                        lang.error_title ,
                        lang.error_code_status+xhr.status+': '+xhr.statusText,
                        'error'
                    ).catch(swal.noop);
                    console.log(xhr);
                }
            });
        }
    }else{
        //Debe seleccionar al menos un archivo
        swal(
            lang.warning_title,
            lang.warning_file,
            'warning'
        ).catch(swal.noop);
    }
}

$( "#sltOrganization" ).change(function() {
    changeLocations();

});


function changeLocations(){
    //Se obtiene la organización
    var organization = $('#sltOrganization').val();
    //Si la organización es públic
    if(organization === "public"){
        //Se vacian las locaciones
        $("#sltLocation").empty();
        //Se agrega la opción públic
        $("#sltLocation").append("<option value='public' selected>"+lang.all+"</option>");
        //Se refresca el select
        $('#sltLocation').selectpicker('refresh');

    }else{
        show(lang.waiting);
        //Llamada ajax para obtener las localizaciones
        $.ajax({
            type: "POST",
            url: "Administrator/Files/getLocations",
            data: {"organization":organization},
            success: function(data)
            {
                //Convertimos a JSON
                var location = JSON.parse(data);
                //Se vacia el select de las locaciones
                $("#sltLocation").empty();
                //Se selecciona la primera opción
                $('#sltLocation :nth-child(1)').prop('selected', true);
                //Por cada locación
                jQuery.each(location, function(i, val) {
                    //Se agrega al select
                    $("#sltLocation").append("<option value="+val.Id+">"+val.Name+"</option>");
                });
                //Se refresca el select
                $('#sltLocation').selectpicker('refresh');
                //Si es la primera vez
                if(first){
                    //Se carga el àrbol
                    chargeTree();
                    first = false;
                }else{
                    //Si no, se refresca
                    refreshTree();
                }
                hide();

            },
            error: function(xhr)
            {
                //Muestra en pantalla e imprime en la consola del navegador el error.
                swal(
                    lang.error_title ,
                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                    'error'
                ).catch(swal.noop);
                console.log(xhr);
            }
        });
    }
}

