$(function () {
    //Ultimas locaciones cargadas
    /**
     ** Funcion que se encarga de buscar en el JSTree
     **/
    var to = false;
    $('#search-field').keyup(function () {
        if(to) { clearTimeout(to); }
        to = setTimeout(function () {
            var v = $('#search-field').val();
            $('#jstree').jstree(true).search(v);
        }, 250);
    });

    /**
     ** LLamada AJAX para obtener la estructura jerárquica de carpetas.
     **/
    var v;
    show(lang.waiting);
    $.ajax({
        type: "POST",
        url: "Administrator/Structures/getStructureTree",
        data:{"upload":1},
        success: function(data)
        {
            //Se convierte la respuesta a JSON
            v= JSON.parse(data);
            $('#jstree')
                //Configuraciones del JStree
                .jstree({
                    "core" : {
                        "dblclick_toggle":false,
                        "animation" : 200,
                        "check_callback" : true,
                        'force_text' : true,
                        "multiple" : false,
                        "themes" : {
                            "stripes" : true,
                            "variant": "large",
                            'dots' : false
                        },
                        "strings":{
                            'Loading ...' : lang.loading
                        },
                        //Se le asocia los datos recuperados
                        "data":v
                    },
                    //Configuración del plugin checkBox
                    "checkbox" : {
                        "cascade":"down",
                        "three_state" : false
                    },
                    //Tipos de nodos en el árbol
                    "types" : {
                        "#" : { "max_depth" : 3, "valid_children" : ["root"] },
                        "root" : { "icon" : "assets/images/category.png" , "valid_children" : ["default"] },
                        "default" : { "icon" : "assets/images/subcategory.png","valid_children" : ["file"] },
                        "file":{"icon" : "assets/images/folder.png"}
                    },
                    "plugins" : ["checkbox", "search", "types", "wholerow"]
                });
                hide();
        },
        error: function(xhr)
        {
            //Muestra en pantalla e imprime en la consola del navegador el error.
            swal(
                lang.error_title ,
                lang.error_code_status+xhr.status+': '+xhr.statusText,
                'error'
            ).catch(swal.noop);
            console.log(xhr);
        }
    });
    /**
     ** Evento que se ejecuta al hacer doble click sobre un nodo, previene que se expanda o colapsen nodos sin hijos.
     **/
    $('#jstree').bind("dblclick.jstree", function (e) {
        //Obtenemos el objeto HTML sobre el cual se hizo doble click
        var nodeDOM = $(e.target).closest("li");
        //Obtenemos el nodo HTML sobre el cual se hizo doble click
        var node = $('#jstree').jstree(true).get_node(nodeDOM);
        //Verificamos si tiene hijos, de lo contrario no se dispara el evento doble click.
        if(node.children.length != 0){
            $("#jstree").jstree("toggle_node", node);
        }
    });
});
//Esta la opción todos seleccionado, lo que significa que las otras estan deseleccionadas.
var deselect = true;

var lastlocations = [];

/**
 ** Configuración de file input de bootstrap
 **/
$('#uploadFiles').fileinput({
    //Lenguaje español, y ocultamos el botón de subir.
    language: 'es',
    showUpload: false,
    maxFileCount: 10,
    maxFileSize: 102400,
    allowedFileExtensions: ["jpg","jpeg", "pdf", "png", "txt","xls","doc","docx","xlsx","xlsm"]
});


//Expande todos los nodos
function expand_all() {
    var ref = $('#jstree');
    ref.jstree('open_all','#',200);


};

//Collapso todos los nodes
function close_all() {
    var ref = $('#jstree');
    ref.jstree('close_all','#',200);

};


//Tipo de subida de archivos
var typeUpload = "blob";




/**
 ** Función que maneja la subida de archivos
 **/
function upload(){
    //Variable que almacenara los datos a enviar por AJAX
    var formData = new FormData();
    //Locacion al cual se le van a subir los archivos
    var locations = $('#sltLocation').val();
    //Organización de las locaciones
    var organization = $('#sltOrganization').val();
    //Si la organización no es públic
    if(organization !== "public"){
        if(locations[0] === "public"){
            //Asigna el valor de las ultimas locaciones cargadas
            locations = this.lastlocations;
        }else{
            //Para que sea ignorada del lado del controlador ya que 
            // el archivo pertenece a una locación específica. 
            organization = "public";
        }
    }
    //Enviar notificación
    var notification;
    if( $('#chckNotification').prop('checked') ) {
        notification = 1;
    }else{
        notification = 0;
    }
    //Cantidad de archivos que se va a subir
    var length = ($("#uploadFiles"))[0].files.length;
    // Si hay almenos un archivo
    if(length > 0){
        //Se recorren todos y se almacenan en formData
        for(i =0;i<length;i++){
            formData.append("file_"+i, ($("#uploadFiles"))[0].files[i]);
        }
        //Se obtiene la carpeta seleccionada como destino del archivo
        var ref = $('#jstree').jstree(true);
        var selectedNode = ref.get_selected(true);
        // Se verifica que se haya seleccionado una carpeta
        if(typeof selectedNode[0] === 'undefined'){
            swal(
                lang.warning_title,
                lang.warning_folder,
                'warning'
            ).catch(swal.noop);
        }else{
            show(lang.uploading);
            //Si hay almenos un archivo y ya se slecciono la carpeta de destino
            //Se recopila la informacion necesaria y se almacena.
            formData.append("organization",organization);
            formData.append("locations",locations);
            formData.append("folder", selectedNode[0].id);
            formData.append("length", length);
            formData.append("typeUpload",typeUpload);
            formData.append("isVersion",0);
            console.log(locations);
            //Llamada AJAX para subir el archivo.
            $.ajax({
                type: "POST",
                url: "Administrator/Upload/uploadFile",
                data:formData,
                //Para poder enviar archivos
                contentType:false,
                processData:false,
                success: function(data)
                {
                    hide();
                    swal(
                        lang.success_title,
                        lang.success_upload,
                        'success'
                    ).catch(swal.noop);
                    $('#uploadFiles').fileinput('clear');
                    //Si las notificaciones estan activadas
                    if(notification === 1){
                        //Llamada AJAX para enviar notificaciones
                        $.ajax({
                            type: "POST",
                            url: "Administrator/Upload/sendNotifications",
                            data:{'locations':locations,'names':data},
                            success: function(dataInfo)
                            {
                                console.log(dataInfo);
                            },
                            error: function(xhr)
                            {
                                //Muestra en pantalla e imprime en la consola del navegador el error.
                                swal(
                                    lang.error_title ,
                                    lang.error_code_status+xhr.status+': '+xhr.statusText,
                                    'error'
                                ).catch(swal.noop);
                                console.log(xhr);
                            }
                        });
                    }

                },
                error: function(xhr)
                {
                    hide();
                    //Muestra en pantalla e imprime en la consola del navegador el error.
                    swal(
                        lang.error_title ,
                        lang.error_code_status+xhr.status+': '+xhr.statusText,
                        'error'
                    ).catch(swal.noop);
                    console.log(xhr);
                }
            });
        }
    }else{
        swal(
            lang.warning_title,
            lang.warning_file,
            'warning'
        ).catch(swal.noop);
    }
};

$( "#sltOrganization" ).change(function() {
    chargeLocations();
});


 /**
     * Función que se encarga de llenar el select de las locaciones y marcar si el cliente
     * ya tiene seleccionadas.
     * @param locationsId: id de las locaciones
     */
    function chargeLocations(){
        //Reinicia las ultimas locaciones cargadas
        var lastLocationsLocal = [];
        
        //Se obtiene la organización
        var organization = $('#sltOrganization').val();
        //Si la organización es públic
        if(organization === "public"){
            //Se vacian las locaciones
            $("#sltLocation").empty();
            //Se agrega la opción públic
            $("#sltLocation").append("<option value='public' selected>"+lang.all+"</option>");
            //Se refresca el select
            $('#sltLocation').selectpicker('refresh');

            //Se obtiene la organización
            var locations = $('#sltLocation').val();
            //Si la organización es públic
            if(locations === "public"){
                deselect = true;
            }else {
                deselect = false;
            }
            //Si es una específica
        }else{
            show(lang.waiting);
            //Llamada ajax para obtener las localizaciones
            $.ajax({
                type: "POST",
                url: "Administrator/Files/getLocations",
                data: {"organization":organization},
                success: function(data)
                {
                    //Convertimos a JSON
                    var location = JSON.parse(data);
                    //Se vacia el select de las locaciones
                    $("#sltLocation").empty();
                    //Se agrega la opción públic
                    $("#sltLocation").append("<option value='public' selected>"+lang.all+"</option>");
                    //Por cada locación
                    jQuery.each(location, function(i, val) {
                        //Se agrega al select
                        $("#sltLocation").append("<option value="+val.Id+">"+val.Name+"</option>");
                        //Se agrega el id al arreglo del últimas locaciones
                        lastLocationsLocal.push(val.Id);
                    });
                    //Se actualiza el select
                    $('#sltLocation').selectpicker('refresh');
                    //Se obtiene la organización
                    var locations = $('#sltLocation').val();
                    //Si la organización es públic
                    if(locations[0] === "public"){
                        deselect = true;
                    }else {
                        deselect = false;
                    }
                    
                    lastlocations = lastLocationsLocal;
                    hide();
                    //console.log(this.lastLocations);
                },
                error: function(xhr)
                {
                    //Muestra en pantalla e imprime en la consola del navegador el error.
                    swal(
                        lang.error_title ,
                        lang.error_code_status+xhr.status+': '+xhr.statusText,
                        'error'
                    ).catch(swal.noop);
                    console.log(xhr);
                }
            });
        }

    };

    /**
     * Evento que se ejecuta cuando se cambia la opción del select de locaciones
     **/
$( "#sltLocation" ).change(function() {
        //Se obtiene las locaciones
        var locations = $('#sltLocation').val();
        //Si solo esta seleccionado la opción public(Todos)
        if(deselect){
                //Si hay seleccionada más de una opción
                if(locations.length == (lastlocations.length+1)){
                    //Se deseleccionan todas las opciónes
                    $('#sltLocation').selectpicker('deselectAll');
                    //Se selecciona la opción públic
                    $("#sltLocation option[value='public']").prop("selected", true);
                    //Se refresca el select
                    $('#sltLocation').selectpicker('refresh');
                    //Solo esta seleccionada la opción públic
                    deselect = true;
                }
                else if(locations.length > 1){
                    //Se deselecciona la opción public
                    $("#sltLocation option[value='public']").prop("selected", false);
                    //Se reffresca el select
                    $('#sltLocation').selectpicker('refresh');
                    //Ya no esta marcada solo a la opción pública
                    deselect = false;
                }
            //Si no esta marcado solo la opción públic
        }else{
            //Si esta seleccionada la opción públic
            if(locations[0]==="public" || locations.length == lastlocations.length){
                //Se deseleccionan todas las opciónes
                $('#sltLocation').selectpicker('deselectAll');
                //Se selecciona la opción públic
                $("#sltLocation option[value='public']").prop("selected", true);
                //Se refresca el select
                $('#sltLocation').selectpicker('refresh');
                //Solo esta seleccionada la opción públic
                deselect = true;
            }
        }
        //Si no hay ningúna seleccionada
        if(locations.length == 0){
            //Selecciona la opción públic
            $("#sltLocation option[value='public']").prop("selected", true);
            //Se refresca el select
            $('#sltLocation').selectpicker('refresh');
            //Solo esta marcada la opción públic
            deselect = true;
        }
    
    });
