

/**
** Función que valida si el texto recibido por párametro esta vacío.
** @Parámetros: 
**			textValidate: Texto a validar.
** @Retorno:
**			True si el tamaño del texto es 0, de lo contrario false.
**/
function isEmpty(textValidate){
	return textValidate.length === 0;
}
/**
** Función que valida si el texto recibido por párametro es menor o igual al máximo permitido.
**@Parámetros: 
**			textValidate: Texto a validar.
**			max : Cantidad máxima de caractéres permitidos.
** @Retorno:
**			True si el tamaño del texto es menor o igual al máximo permitido, de lo contrario false.
**/
function maxLength(textValidate,max){
	return textValidate.length <= max;

}

/**
** Función que valida si el texto recibido por párametro es mayor o igual al mínimo permitido. 
**@Parámetros: 
**			textValidate: Texto a validar. 
**			min : Cantidad mínima de caractéres permitidos.
** @Retorno:
**			True si el tamaño del texto es mayor o igual al mínimo permitido , de lo contrario false.
**/
function minLength(textValidate,min){
	return textValidate.length >= min;

}

/**
** Función que valida si el texto recibido por párametro es alfanúmerico. 
**@Parámetros: 
**			textValidate: Texto a validar. 
** @Retorno:
**			True si el texto es un alfanùmerico, de lo contrario false;
**/
function isAlphanumeric(textValidate){
	var expr = /^[a-z0-9ñÑáéíóúÁÉÍÓÚ\s]+$/i;
	return expr.test(textValidate);
}