//Variable que identifica si ya existe un modal abierto.
var thereIsDialog = false;
//Dialog a ser mostrado
var $dialog;

/**
 * Función que se encarga de construir y mostrar el dialog
 * @param text: Título del dialog
 */
function show(text){
    //Si no hay ningun dialog abierto
    if(!thereIsDialog){
        //Se contruye el dialog
        $dialog = $(
            '<div class="modal fade" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true" style="padding-top:15%; overflow-y:visible;">' +
            '<div class="modal-dialog modal-m">' +
            '<div class="modal-content">' +
            '<div class="modal-header"><h4>'+text+'</h4></div>' +
            '<div class="modal-body">' +
            '<div class="progress progress-striped active" style="margin-bottom:0;">' +
            '<div class="progress-bar" style="width: 100%"></div>' +
            '</div>' +
            '</div>' +
            '</div>' +
            '</div>' +
            '</div>'
        );
        //Mostramos el dialog
        $dialog.modal();
        //Indicamos que ya hay un dialog abierto
        thereIsDialog = true;
    }
}

/**
 * Función que se encarga de ocultar el dialog que se esta mostrando
 */
function hide(){
    //Ocultamos el dialog
    $dialog.modal('hide');
    //Indicamos que no hay dialogs abiertos
    thereIsDialog = false;
}
