<html>
    <head>
    	<link rel="shortcut icon" href="">
        <title>
            Generar Código Qr
        </title>
        <script src="./Resources/JS/jquery-3.2.1.min.js"></script>
        <script src="./Resources/JS/jquery-ui.js"></script>
        <script src="./Resources/JS/qrcode.js"></script>
		<script src="./Resources/JS/select2.min.js"></script>
		<script src="./Resources/JS/xlsx.min.js"></script>
		<script src="./Resources/JS/FileSaver.min.js"></script>
        <style>
            #bodyHtml {
                margin: auto;
                width: 80%;
                padding: 10px;
            }
            #result, #result td, #result th {
                border: 1px solid black;
            }

            #result {
                border-collapse: collapse;
                width: 100%;
            }

            #result th {
                height: 50px;
            }
            #result td {
                padding: 10px;
                text-align: center;
            }

            #form-data{
                padding: 10px;
            }

            #btn-size{
                width: 100px;
                background: #FA5858;
                color: white;
                font-weight: bold;
                padding: 10px;
    			margin: 10px;
    			text-align: center;
    			border-radius: 5px;
            }

            table{
                width: 80%;
                padding: 10px;
                border: 3px solid black;
            }

            td input {
                width: 100%;
                padding : 5px;
                margin: 5px;
            }
            
            td select {
                width: 100%;
                padding : 5px;
                margin: 5px;
            }
            
            a {
            	display: inline;
    			width: 150px;
    			height: 15px;
    			background: #FA5858;
    			padding: 10px;
    			margin: 10px;
    			text-align: center;
    			border-radius: 5px;
    			color: white;
    			font-weight: bold;
    			text-decoration: none;
            }
        </style>
        

	<link rel="stylesheet" href="./Resources/CSS/select2.min.css" />
	<link rel="stylesheet" href="./Resources/CSS/jquery-ui.css" />

    </head>
    <body>
        <?php
        $dbhost = 'localhost';
        $dbuser = 'orkindb';
        $dbpass = 'rmschpsw1';
        $conn = mysqli_connect($dbhost, $dbuser, $dbpass);
        if (!$conn) {
            die('Could not connect: ' . mysqli_error());
        }
        mysqli_set_charset($conn,'utf8');
        ?>
        <div id='bodyHtml'>
        	<center>
        	<br><br>
            <a href="./QrCode.php">Codigos de Trampas</a> <a href="./QrCodeClient.php">Codigos de Clientes</a>
            <br><br><br><br>
            <img src='./Resources/Images/Orkin_Logo.png' width=500 height=300></img>
            <h2>Códigos QR para trampas.</h2>

            <br>
            <form action="" method='get' id="form-data">
                <table>
                    <tr>
                        <td>Reporte:</td> 
                        <td> 
                        <br>
                        <select name="reporttxt" id="reporttxt">
                                <?php
                                $sql = "Select * from rimonitor.report where active = 1;";
                                $resu = mysqli_query($conn, $sql);
                                if (mysqli_num_rows($resu) > 0) {
                                    while ($row = mysqli_fetch_assoc($resu)) {
                                           echo "<option value='" . $row["id"] . "' data-module='". $row["profileModuleId"] ."'   >" .$row["title"] . "</option>";
                                	}

                                }
                                ?>
                            </select>
                            <br><br>
                        </td>
                    </tr>
                     <tr>
                        <td>Tipo de trampa:</td> 
                        <td>
                            <br>
                             <select name="typetxt" id="typetxt">
                                <option value='1'>Normal</option>
                                <option value='2'>Refuerzo</option>
                             </select>   
                        </td>
                    </tr>
                    <tr>
                        <td>Cantidad de Trampas:</td> 
                        <td><input type="number" name="canttxt" id="canttxt" value="1" min="1"></td>
                    </tr>
                    <tr>
                        <td>Empezar desde la trampa numero:</td> 
                        <td><input type="number" name="starttxt" id="starttxt" value="1" min="1"><br></td>
						
                    </tr>
					<tr>
						<td>Cliente:</td> 
                        <td> 
                            <br>
                            <select name="locatxt" id="locatxt">
                                <?php
                                $sql = "Select Id,Name from rmscheduler_orkincr.organizationLocations Order By Name;";
                                $resu = mysqli_query($conn, $sql);
                                if (mysqli_num_rows($resu) > 0) {
                                    while ($row = mysqli_fetch_assoc($resu)) {
                                       echo "<option value='" . $row["Id"] . "'>" . $row["Name"] . "</option>";
                                    }
                                }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td></td> 
                        <td><br><input type="button" value="Generar" id="btn-size" onclick="makeCsv()"></td>
                    </tr>
                </table>
            </form>
            <div id="qrcode" ></div>
            <div id="container" ></div>
            <canvas id="canvas" ></canvas>
            </center>
        </div id='bodyHtml'>
        <script>
        
        		$( document ).ready(function() {
					$("#locatxt").select2( {
 						placeholder: "Seleccione un cliente",
 						allowClear: false
 					} );
				});
				
				$( document ).ready(function() {
					$("#reporttxt").select2( {
 						placeholder: "Seleccione un reporte",
 						allowClear: false
 					} );
				});

                $( document ).ready(function() {
                    $("#typetxt").select2( {
                        placeholder: "Seleccione un tipo de trampa",
                        allowClear: false
                    } );
                });
        		
        
        	function b64toBlob(b64Data, contentType, sliceSize) {
  				contentType = contentType || '';
  				sliceSize = sliceSize || 512;
				var base64 = b64Data.replace(/^data:image\/(png|jpeg|jpg|gif);base64,/, '');
  				var byteCharacters = atob(base64);
  				var byteArrays = [];

  				for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
    				var slice = byteCharacters.slice(offset, offset + sliceSize);

    				var byteNumbers = new Array(slice.length);
    				for (var i = 0; i < slice.length; i++) {
      					byteNumbers[i] = slice.charCodeAt(i);
    				}

    				var byteArray = new Uint8Array(byteNumbers);

    				byteArrays.push(byteArray);
  				}
  				var blob = new Blob(byteArrays, {type: contentType});
  				return blob;
			}
			
			
			function generate(current,last) {
					if(current == last){
						setTimeout(function(){ 
  				    		$("#" + "progress").dialog("close");
        					$("#progress").remove(); 
  						}, 3000);
					}else{
						var idReport = $("#reporttxt").val();
        				var reporte = $("#reporttxt option:selected").text();
						var module = $('#reporttxt option:selected').data('module');
						var locacion = $("#locatxt").val();
        				var cliente = $( "#locatxt option:selected" ).text();
        				$('#qrcode').html("");
        				var typeNumber = 0;
						var errorCorrectionLevel = 'L';
						var canvas = document.getElementById('canvas'),
        				ctx = canvas.getContext('2d');
        				var qr = qrcode(typeNumber, errorCorrectionLevel);
        				qr.addData(";RMR;"+module+";RMS;"+reporte+":"+idReport+":"+current+":"+locacion+";RMR;");
						qr.make();
					
						var image = new Image();
						image.setAttribute('data-number',current);
						image.onload = function() {
							var number = image.getAttribute('data-number');
							canvas.width = 500;
							canvas.crossOrigin = "Anonymous";
							canvas.height = 300;
				    		ctx.clearRect(0,0,canvas.width,canvas.height);
							ctx.drawImage(image, 0, 0);
							ctx.font = "14pt Arial";
    						ctx.fillStyle = "Black";
    						ctx.fillText(reporte+" #"+current,0,200);
    						ctx.font = "12pt Arial";
    						ctx.fillText(cliente.trim(),0,230);
    						var link=document.createElement('a');
            				var blob = b64toBlob(canvas.toDataURL(), 'image/png');
            				var blobUrl = URL.createObjectURL(blob);
            				link.href= blobUrl;
                    		var fileName = reporte+", trampa_"+current+", "+cliente.trim();
            				link.download= fileName.replace(".","");
           					link.click();
           					console.log(reporte+", trampa_"+current+", "+cliente.trim());
           					generate((current+1),last);
						};
						image.src = qr.createDataURL(5,5);
        			}
				
				}
			
        
        	function makeCode() {
        	
        	var alert_container = '';
            alert_container += '<div style="display:none" id="progress" title="' + "Generando..." + '">';
            
            alert_container += '<center><p>'+ '<img style="width:60px" src="./Resources/Images/progress_circle.gif" />' + '</p></center>';
            alert_container += '</div>';

            $("#" + "container").append(alert_container);

            var dialog ;
            $(function() {
               dialog = $("#" + "progress").dialog({
                    draggable: false,
                    resizable: false,
                    height: "auto",
                    width: "40%",
                    modal: true,
                    closeOnEscape: false,
                    dialogClass: "no-close",
                    
                });
            });
        	

        		var cantidad = $("#canttxt").val();
        		var empieza = $("#starttxt").val();
        		var hasta = +empieza + +cantidad;
				generate(+empieza,+hasta);
        	}
        	
        	
        function makeCsv() {
        	
        	var alert_container = '';
            alert_container += '<div style="display:none" id="progress" title="' + "Generando..." + '">';
            
            alert_container += '<center><p>'+ '<img style="width:60px" src="./Resources/Images/progress_circle.gif" />' + '</p></center>';
            alert_container += '</div>';

            $("#" + "container").append(alert_container);

            var dialog ;
            $(function() {
               dialog = $("#" + "progress").dialog({
                    draggable: false,
                    resizable: false,
                    height: "auto",
                    width: "40%",
                    modal: true,
                    closeOnEscape: false,
                    dialogClass: "no-close",
                    
                });
            });
        	


                var cantidad = $("#canttxt").val();
                var empieza = $("#starttxt").val();
                var hasta = +empieza + +cantidad;
                var type = $("#typetxt option:selected").text();
                if(type == "Refuerzo"){
                    type = "Refuerzo ";
                }else{
                    type = "";
                }
                var idReport = $("#reporttxt").val();
                var reporte = $("#reporttxt option:selected").text();
                var module = $('#reporttxt option:selected').data('module');
                var locacion = $("#locatxt").val();
                var cliente = $( "#locatxt option:selected" ).text();
                var rows = [];
                rows.push(['TIPO','CODIGO QR','TRAMPA','LOCACION']);

                for(var i=empieza;i<hasta;i++){
                    rows.push([reporte,';RMR;'+module+';RMS;'+reporte+':'+idReport+':'+type+i+':'+locacion+';RMR;',+i, ''+cliente.trim()+'']);
                }
				

				
				
				/**
				let csvContent = "";

				rows.forEach(function(rowArray) {
    				let row = rowArray.join(",");
    				csvContent += row + "\r\n";
				});
				
				var link = document.createElement("a");
				var blob = new Blob([csvContent], { type: 'text/csv' });
            	var blobUrl = URL.createObjectURL(blob);
            	link.href= blobUrl;
				link.download =  fileName+".csv";
				link.style = 'display:none;';
				document.body.appendChild(link); // Required for FF
				link.click();
				**/
				
				//console.log(rows);
				var fileName = "Trampas_"+(cliente.trim()).replace(".","");				
				var wb = XLSX.utils.book_new();
				wb.Props = {
                Title: fileName,
                Subject: "",
                Author: "Route-Miner",
                CreatedDate: new Date()
        		};
        		wb.SheetNames.push("Datos");
        		
        		var ws = XLSX.utils.aoa_to_sheet(rows);
        		wb.Sheets["Datos"] = ws;
        		var wbout = XLSX.write(wb, {bookType:'xlsx',  type: 'binary'});
        		
        		
				saveAs(new Blob([s2ab(wbout)],{type:"application/octet-stream"}), fileName+'.xlsx');
				
				
				
				setTimeout(function(){ 
  				    		$("#" + "progress").dialog("close");
        					$("#progress").remove(); 
  				}, 1000);
        	}
        	
        	function s2ab(s) { 
                var buf = new ArrayBuffer(s.length); //convert s to arrayBuffer
                var view = new Uint8Array(buf);  //create uint8array as viewer
                for (var i=0; i<s.length; i++) view[i] = s.charCodeAt(i) & 0xFF; //convert to octet
                return buf;    
			}
        </script>
    </body>
</html>